/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.lang.Gosu;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.UrlClassLoaderWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class GosuClassPathThing {
    public static final String GOSU_CLASS_PROTOCOL = "gosuclass";
    private static final String PROTOCOL_PACKAGE = "gw.internal.gosu.compiler.protocols";
    private static Boolean CAN_WRAP = Boolean.FALSE;

    private static void setupLoaderChainWithGosuUrl(ClassLoader loader) {
        UrlClassLoaderWrapper wrapped = UrlClassLoaderWrapper.wrapIfNotAlreadyVisited(loader);
        if (wrapped == null) {
            return;
        }
        GosuClassPathThing.addGosuClassUrl(wrapped);
        if (GosuClassPathThing.canWrapChain() && loader != ClassLoader.getSystemClassLoader() && (loader = loader.getParent()) != null) {
            GosuClassPathThing.setupLoaderChainWithGosuUrl(loader);
        }
    }

    private static boolean canWrapChain(ClassLoader loader) {
        boolean bSysLoader;
        if (loader == null) {
            return false;
        }
        UrlClassLoaderWrapper wrapped = UrlClassLoaderWrapper.wrap(loader);
        boolean bl = bSysLoader = loader == ClassLoader.getSystemClassLoader();
        if (bSysLoader) {
            return wrapped != null;
        }
        loader = loader.getParent();
        return wrapped != null && GosuClassPathThing.canWrapChain(loader);
    }

    private static void addGosuClassUrl(UrlClassLoaderWrapper urlLoader) {
        try {
            URL url = GosuClassPathThing.makeUrl(urlLoader.getLoader());
            if (!urlLoader.getURLs().contains(url)) {
                urlLoader.addURL(url);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static URL makeUrl(ClassLoader loader) throws MalformedURLException {
        URL url;
        int loaderAddress = System.identityHashCode(loader);
        String spec = "gosuclass://" + loaderAddress + "/";
        try {
            url = new URL(null, spec);
        }
        catch (Exception e) {
            GosuClassPathThing.addOurProtocolHandler();
            url = new URL(null, spec);
        }
        return url;
    }

    private static void addOurProtocolHandler() {
        try {
            Field field = URL.class.getDeclaredField("handlers");
            field.setAccessible(true);
            Method put = Hashtable.class.getMethod("put", Object.class, Object.class);
            Field instanceField = Class.forName("gw.internal.gosu.compiler.protocols.gosuclass.Handler").getField("INSTANCE");
            Object handler = instanceField.get(null);
            put.invoke(field.get(null), GOSU_CLASS_PROTOCOL, handler);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to configure gosu protocol handler", e);
        }
    }

    private static void removeOurProtocolHandler() {
        try {
            Field field = URL.class.getDeclaredField("handlers");
            field.setAccessible(true);
            Method remove = Hashtable.class.getMethod("remove", Object.class);
            remove.invoke(field.get(null), GOSU_CLASS_PROTOCOL);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to cleanup gosu protocol handler", e);
        }
    }

    private static boolean addOurProtocolPackage() {
        String strProtocolProp = "java.protocol.handler.pkgs";
        String protocols = PROTOCOL_PACKAGE;
        String oldProp = System.getProperty(strProtocolProp);
        if (oldProp != null) {
            if (oldProp.contains(PROTOCOL_PACKAGE)) {
                return false;
            }
            protocols = protocols + '|' + oldProp;
        }
        System.setProperty(strProtocolProp, protocols);
        return true;
    }

    private static void removeOurProtocolPackage() {
        String strProtocolProp = "java.protocol.handler.pkgs";
        String protocols = System.getProperty(strProtocolProp);
        if (protocols != null) {
            protocols = protocols.replace("gw.internal.gosu.compiler.protocols|", "");
            System.setProperty(strProtocolProp, protocols);
        }
    }

    public static synchronized boolean init() {
        if (GosuClassPathThing.addOurProtocolPackage() && Gosu.bootstrapGosuWhenInitiatedViaClassfile()) {
            TypeSystem.pushModule(TypeSystem.getGlobalModule());
        }
        ClassLoader loader = TypeSystem.getGosuClassLoader().getActualLoader();
        GosuClassPathThing.setupLoaderChainWithGosuUrl(loader);
        return true;
    }

    public static boolean canWrapChain() {
        return CAN_WRAP == null ? (CAN_WRAP = Boolean.valueOf(GosuClassPathThing.canWrapChain(TypeSystem.getGosuClassLoader().getActualLoader()))) : CAN_WRAP;
    }

    public static synchronized void cleanup() {
        GosuClassPathThing.removeOurProtocolPackage();
        GosuClassPathThing.removeOurProtocolHandler();
    }
}

