/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.util.concurrent.ConcurrentHashSet;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class UrlClassLoaderWrapper {
    private static final Set<Integer> VISITED_LOADER_IDS = new ConcurrentHashSet<Integer>();
    private final ClassLoader _loader;
    private final Method _getURLs;
    private final Method _addUrl;

    static UrlClassLoaderWrapper wrapIfNotAlreadyVisited(ClassLoader loader) {
        int loaderId = System.identityHashCode(loader);
        if (VISITED_LOADER_IDS.contains(loaderId)) {
            return null;
        }
        VISITED_LOADER_IDS.add(loaderId);
        UrlClassLoaderWrapper wrapped = UrlClassLoaderWrapper.wrap(loader);
        if (wrapped == null) {
            throw new IllegalStateException("Could not wrap loader: " + loader.getClass().getName());
        }
        return wrapped;
    }

    public static UrlClassLoaderWrapper wrap(ClassLoader loader) {
        Method addUrl;
        Method getURLs = UrlClassLoaderWrapper.findMethod(loader.getClass(), "getURLs", new Class[0], List.class, URL[].class);
        if (getURLs != null && (addUrl = UrlClassLoaderWrapper.findMethod(loader.getClass(), "addUrl", new Class[]{URL.class}, Void.TYPE)) != null) {
            return new UrlClassLoaderWrapper(loader, getURLs, addUrl);
        }
        return null;
    }

    private static Method findMethod(Class cls, String methodName, Class[] paramTypes, Class ... returnType) {
        block0: for (Method m : cls.getDeclaredMethods()) {
            Class<?>[] types;
            if (!m.getName().equalsIgnoreCase(methodName) || (types = m.getParameterTypes()).length != paramTypes.length) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!paramTypes[i].equals(types[i])) continue block0;
            }
            for (Class t : returnType) {
                if (!m.getReturnType().equals(t)) continue;
                m.setAccessible(true);
                return m;
            }
        }
        return cls.getSuperclass() != null ? UrlClassLoaderWrapper.findMethod(cls.getSuperclass(), methodName, paramTypes, returnType) : null;
    }

    private UrlClassLoaderWrapper(ClassLoader loader, Method getURLs, Method addUrl) {
        this._loader = loader;
        this._getURLs = getURLs;
        this._addUrl = addUrl;
    }

    public ClassLoader getLoader() {
        return this._loader;
    }

    public void addURL(URL url) {
        try {
            this._addUrl.invoke((Object)this._loader, url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<URL> getURLs() {
        if (this._loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)this._loader).getURLs();
            return urls == null ? Collections.emptyList() : Arrays.asList(urls);
        }
        try {
            List<URL> urls = this._getURLs.invoke((Object)this._loader, new Object[0]);
            urls = urls == null ? Collections.emptyList() : (urls.getClass().isArray() ? Arrays.asList((URL[])urls) : urls);
            return urls;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

