/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.java;

import gw.lang.Autoinsert;
import gw.lang.Deprecated;
import gw.lang.IAnnotation;
import gw.lang.IDimension;
import gw.lang.InternalAPI;
import gw.lang.Param;
import gw.lang.Params;
import gw.lang.Throws;
import gw.lang.annotation.AnnotationUsage;
import gw.lang.annotation.AnnotationUsages;
import gw.lang.annotation.IInherited;
import gw.lang.function.IBlock;
import gw.lang.parser.expressions.IBlockExpression;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IQueryResultSet;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.TypeSystemShutdownListener;
import gw.lang.reflect.gs.FragmentInstance;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuClassObject;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.gs.IProgramInstance;
import gw.lang.reflect.interval.BigDecimalInterval;
import gw.lang.reflect.interval.BigIntegerInterval;
import gw.lang.reflect.interval.ComparableInterval;
import gw.lang.reflect.interval.DateInterval;
import gw.lang.reflect.interval.IInterval;
import gw.lang.reflect.interval.IntegerInterval;
import gw.lang.reflect.interval.LongInterval;
import gw.lang.reflect.interval.NumberInterval;
import gw.lang.reflect.interval.SequenceableInterval;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IProject;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;

public class JavaTypes {
    private static final Map<IProject, Map<Class, IJavaType>> CACHE = new WeakHashMap<IProject, Map<Class, IJavaType>>();

    public static IJavaType pVOID() {
        return JavaTypes.getJreType(Void.TYPE);
    }

    public static IJavaType pBOOLEAN() {
        return JavaTypes.getJreType(Boolean.TYPE);
    }

    public static IJavaType pBYTE() {
        return JavaTypes.getJreType(Byte.TYPE);
    }

    public static IJavaType pCHAR() {
        return JavaTypes.getJreType(Character.TYPE);
    }

    public static IJavaType pDOUBLE() {
        return JavaTypes.getJreType(Double.TYPE);
    }

    public static IJavaType pFLOAT() {
        return JavaTypes.getJreType(Float.TYPE);
    }

    public static IJavaType pINT() {
        return JavaTypes.getJreType(Integer.TYPE);
    }

    public static IJavaType pLONG() {
        return JavaTypes.getJreType(Long.TYPE);
    }

    public static IJavaType pSHORT() {
        return JavaTypes.getJreType(Short.TYPE);
    }

    public static IType RUNNABLE() {
        return JavaTypes.getJreType(Runnable.class);
    }

    public static IType THROWS() {
        return JavaTypes.getSystemType(Throws.class);
    }

    public static IType VOID() {
        return JavaTypes.getJreType(Void.class);
    }

    public static IJavaType STRING() {
        return JavaTypes.getJreType(String.class);
    }

    public static IJavaType NUMBER() {
        return JavaTypes.getJreType(Number.class);
    }

    public static IJavaType DOUBLE() {
        return JavaTypes.getJreType(Double.class);
    }

    public static IJavaType BOOLEAN() {
        return JavaTypes.getJreType(Boolean.class);
    }

    public static IJavaType OBJECT() {
        return JavaTypes.getJreType(Object.class);
    }

    public static IJavaType DATE() {
        return JavaTypes.getJreType(Date.class);
    }

    public static IJavaType BYTE() {
        return JavaTypes.getJreType(Byte.class);
    }

    public static IJavaType FLOAT() {
        return JavaTypes.getJreType(Float.class);
    }

    public static IJavaType CHARACTER() {
        return JavaTypes.getJreType(Character.class);
    }

    public static IJavaType CHAR_SEQUENCE() {
        return JavaTypes.getJreType(CharSequence.class);
    }

    public static IJavaType STRING_BUILDER() {
        return JavaTypes.getJreType(StringBuilder.class);
    }

    public static IJavaType STRING_BUFFER() {
        return JavaTypes.getJreType(StringBuffer.class);
    }

    public static IJavaType INTEGER() {
        return JavaTypes.getJreType(Integer.class);
    }

    public static IJavaType LONG() {
        return JavaTypes.getJreType(Long.class);
    }

    public static IJavaType SHORT() {
        return JavaTypes.getJreType(Short.class);
    }

    public static IJavaType BIG_DECIMAL() {
        return JavaTypes.getJreType(BigDecimal.class);
    }

    public static IJavaType BIG_INTEGER() {
        return JavaTypes.getJreType(BigInteger.class);
    }

    public static IJavaType COLLECTION() {
        return JavaTypes.getJreType(Collection.class);
    }

    public static IJavaType ITERATOR() {
        return JavaTypes.getJreType(Iterator.class);
    }

    public static IJavaType COMPARABLE() {
        return JavaTypes.getJreType(Comparable.class);
    }

    public static IJavaType ITERABLE() {
        return JavaTypes.getJreType(Iterable.class);
    }

    public static IJavaType LIST() {
        return JavaTypes.getJreType(List.class);
    }

    public static IJavaType LINKED_LIST() {
        return JavaTypes.getJreType(LinkedList.class);
    }

    public static IJavaType SET() {
        return JavaTypes.getJreType(Set.class);
    }

    public static IJavaType MAP() {
        return JavaTypes.getJreType(Map.class);
    }

    public static IJavaType HASH_SET() {
        return JavaTypes.getJreType(HashSet.class);
    }

    public static IJavaType ARRAY_LIST() {
        return JavaTypes.getJreType(ArrayList.class);
    }

    public static IJavaType HASH_MAP() {
        return JavaTypes.getJreType(HashMap.class);
    }

    public static IJavaType CLASS() {
        return JavaTypes.getJreType(Class.class);
    }

    public static IJavaType THROWABLE() {
        return JavaTypes.getJreType(Throwable.class);
    }

    public static IJavaType ERROR() {
        return JavaTypes.getJreType(Error.class);
    }

    public static IJavaType EXCEPTION() {
        return JavaTypes.getJreType(Exception.class);
    }

    public static IJavaType RUNTIME_EXCEPTION() {
        return JavaTypes.getJreType(RuntimeException.class);
    }

    public static IJavaType ENUM() {
        return JavaTypes.getJreType(Enum.class);
    }

    public static IJavaType QNAME() {
        return JavaTypes.getJreType(QName.class);
    }

    public static IJavaType TIME_ZONE() {
        return JavaTypes.getJreType(TimeZone.class);
    }

    public static IJavaType ANNOTATION() {
        return JavaTypes.getJreType(Annotation.class);
    }

    public static IJavaType REPEATABLE() {
        return JavaTypes.getJreType(Repeatable.class);
    }

    public static IJavaType INHERITED() {
        return JavaTypes.getJreType(Inherited.class);
    }

    public static IJavaType LOCK() {
        return JavaTypes.getJreType(Lock.class);
    }

    public static IJavaType ANNOTATION_USAGE() {
        return JavaTypes.getGosuType(AnnotationUsage.class);
    }

    public static IJavaType ANNOTATION_USAGES() {
        return JavaTypes.getGosuType(AnnotationUsages.class);
    }

    public static IJavaType AUTOINSERT() {
        return JavaTypes.getGosuType(Autoinsert.class);
    }

    public static IJavaType IGOSU_OBJECT() {
        return JavaTypes.getGosuType(IGosuObject.class);
    }

    public static IJavaType IANNOTATION() {
        return JavaTypes.getGosuType(IAnnotation.class);
    }

    public static IJavaType INTERNAL_API() {
        return JavaTypes.getGosuType(InternalAPI.class);
    }

    public static IJavaType ITYPE() {
        return JavaTypes.getGosuType(IType.class);
    }

    public static IJavaType IDIMENSION() {
        return JavaTypes.getGosuType(IDimension.class);
    }

    public static IType FUNCTION_TYPE() {
        return JavaTypes.getGosuType(FunctionType.class);
    }

    public static IType IBLOCK() {
        return JavaTypes.getGosuType(IBlock.class);
    }

    public static IType GW_LANG_DEPRECATED() {
        return JavaTypes.getGosuType(Deprecated.class);
    }

    public static IType FRAGMENT_INSTANCE() {
        return JavaTypes.getGosuType(FragmentInstance.class);
    }

    public static IType IEXTERNAL_SYMBOL_MAP() {
        return JavaTypes.getGosuType(IExternalSymbolMap.class);
    }

    public static IType PARAM() {
        return JavaTypes.getGosuType(Param.class);
    }

    public static IType PARAMS() {
        return JavaTypes.getGosuType(Params.class);
    }

    public static IType IQUERY_RESULT_SET() {
        return JavaTypes.getGosuType(IQueryResultSet.class);
    }

    public static IJavaType IEXECUTION_ENVIRONMENT() {
        return JavaTypes.getGosuType(IExecutionEnvironment.class);
    }

    public static IJavaType IINHERITED() {
        return JavaTypes.getGosuType(IInherited.class);
    }

    public static IJavaType IGOSU_CLASS_OBJECT() {
        return JavaTypes.getGosuType(IGosuClassObject.class);
    }

    public static IJavaType IINTERVAL() {
        return JavaTypes.getGosuType(IInterval.class);
    }

    public static IJavaType INTEGER_INTERVAL() {
        return JavaTypes.getGosuType(IntegerInterval.class);
    }

    public static IJavaType LONG_INTERVAL() {
        return JavaTypes.getGosuType(LongInterval.class);
    }

    public static IJavaType NUMBER_INTERVAL() {
        return JavaTypes.getGosuType(NumberInterval.class);
    }

    public static IJavaType BIG_INTEGER_INTERVAL() {
        return JavaTypes.getGosuType(BigIntegerInterval.class);
    }

    public static IJavaType BIG_DECIMAL_INTERVAL() {
        return JavaTypes.getGosuType(BigDecimalInterval.class);
    }

    public static IJavaType DATE_INTERVAL() {
        return JavaTypes.getGosuType(DateInterval.class);
    }

    public static IJavaType SEQUENCEABLE_INTERVAL() {
        return JavaTypes.getGosuType(SequenceableInterval.class);
    }

    public static IJavaType COMPARABLE_INTERVAL() {
        return JavaTypes.getGosuType(ComparableInterval.class);
    }

    public static IJavaType IBLOCK_EXPRESSION() {
        return JavaTypes.getGosuType(IBlockExpression.class);
    }

    public static IJavaType IPROGRAM_INSTANCE() {
        return JavaTypes.getGosuType(IProgramInstance.class);
    }

    private static IJavaType findTypeFromJre(Class c) {
        IJavaType type = (IJavaType)TypeSystem.get(c, TypeSystem.getExecutionEnvironment().getJreModule());
        IExecutionEnvironment execEnv = type.getTypeLoader().getModule().getExecutionEnvironment();
        if (execEnv.getProject().isDisposed()) {
            throw new IllegalStateException("Whoops.... the project associated with type, " + type.getName() + ", is stale. ExecEnv: " + execEnv.getProject());
        }
        return type;
    }

    private static IJavaType findTypeFromProject(Class c) {
        return (IJavaType)TypeSystem.get(c, TypeSystem.getGlobalModule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IJavaType getCachedType(Class c, boolean bFromJre) {
        Map<Class, IJavaType> cache = JavaTypes.getCACHE();
        IJavaType type = cache.get(c);
        if (type == null) {
            TypeSystem.lock();
            try {
                type = cache.get(c);
                if (type == null) {
                    type = bFromJre ? JavaTypes.findTypeFromJre(c) : JavaTypes.findTypeFromProject(c);
                    cache.put(c, type);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Class, IJavaType> getCACHE() {
        IExecutionEnvironment execEnv = TypeSystem.getExecutionEnvironment();
        IProject project = execEnv.getProject();
        Map<Class, IJavaType> cache = CACHE.get(project);
        if (cache == null) {
            Map<IProject, Map<Class, IJavaType>> map = CACHE;
            synchronized (map) {
                cache = CACHE.get(project);
                if (cache == null) {
                    cache = new ConcurrentHashMap<Class, IJavaType>();
                    CACHE.put(project, cache);
                }
            }
        }
        return cache;
    }

    public static IJavaType getJreType(Class<?> c) {
        return JavaTypes.getCachedType(c, true);
    }

    public static IJavaType getGosuType(Class<?> c) {
        return JavaTypes.getCachedType(c, false);
    }

    public static IJavaType getSystemType(Class<?> c) {
        return JavaTypes.getGosuType(c);
    }

    public static void flushCache() {
        JavaTypes.getCACHE().clear();
    }

    static {
        TypeSystem.addShutdownListener(new TypeSystemShutdownListener(){

            @Override
            public void shutdown() {
                JavaTypes.flushCache();
            }
        });
    }
}

