/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class DynamicArray<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable {
    public static final DynamicArray EMPTY = new DynamicArray(0);
    public transient Object[] data;
    public int size;

    public DynamicArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.data = new Object[initialCapacity];
    }

    public DynamicArray() {
        this(10);
    }

    public DynamicArray(Collection<? extends E> c) {
        this.data = c.toArray();
        this.size = this.data.length;
        if (this.data.getClass() != Object[].class) {
            this.data = Arrays.copyOf(this.data, this.size, Object[].class);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.data.length;
        if (this.size < oldCapacity) {
            this.data = Arrays.copyOf(this.data, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.data;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = Arrays.copyOf(this.data, newCapacity);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            DynamicArray v = (DynamicArray)super.clone();
            v.data = Arrays.copyOf(this.data, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.data, this.size, a.getClass());
        }
        System.arraycopy(this.data, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public E get(int index) {
        this.RangeCheck(index);
        return (E)this.data[index];
    }

    @Override
    public E set(int index, E element) {
        this.RangeCheck(index);
        Object oldValue = this.data[index];
        this.data[index] = element;
        return (E)oldValue;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = e;
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = element;
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.RangeCheck(index);
        ++this.modCount;
        Object oldValue = this.data[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numMoved);
        }
        this.data[--this.size] = null;
        return (E)oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            for (int index = 0; index < this.size; ++index) {
                if (this.data[index] != null) continue;
                this.fastRemove(index);
                return true;
            }
        } else {
            for (int index = 0; index < this.size; ++index) {
                if (!o.equals(this.data[index])) continue;
                this.fastRemove(index);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numMoved);
        }
        this.data[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(a, 0, this.data, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.data, index, this.data, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.data, index, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.data, toIndex, this.data, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.data[--this.size] = null;
        }
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }
}

