/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.cli;

import gw.config.CommonServices;
import gw.internal.ext.org.apache.commons.cli.BasicParser;
import gw.internal.ext.org.apache.commons.cli.CommandLine;
import gw.internal.ext.org.apache.commons.cli.Option;
import gw.internal.ext.org.apache.commons.cli.Options;
import gw.lang.cli.ArgNames;
import gw.lang.cli.ArgOptional;
import gw.lang.cli.Args;
import gw.lang.cli.DefaultValue;
import gw.lang.cli.GosuHelpFormatter;
import gw.lang.cli.GosuOption;
import gw.lang.cli.Hidden;
import gw.lang.cli.LongName;
import gw.lang.cli.Required;
import gw.lang.cli.Separator;
import gw.lang.cli.ShortName;
import gw.lang.cli.SystemExitIgnoredException;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuVarPropertyInfo;
import gw.lang.reflect.java.JavaTypes;
import gw.util.StreamUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CommandLineAccess {
    private static List<String> _args = new ArrayList<String>();
    private static File _currentProgram = null;
    private static boolean _exitEnabled = true;
    private static boolean _useTerminalWidth = true;

    public static List<String> getRawArgs() {
        return _args;
    }

    public static void setRawArgs(List<String> args) {
        _args = args;
    }

    public static File getCurrentProgram() {
        return _currentProgram;
    }

    public static void setCurrentProgram(File currentProgram) {
        _currentProgram = currentProgram;
    }

    public static boolean isUseTerminalWidth() {
        return _useTerminalWidth;
    }

    public static void setUseTerminalWidth(boolean b) {
        _useTerminalWidth = b;
    }

    public static void initialize(IType commandLineShell) {
        CommandLineAccess.initialize(commandLineShell, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean initialize(Object obj, boolean exitOnBadArgs) {
        ArrayList<IPropertyInfo> propsToSet = new ArrayList<IPropertyInfo>();
        IType type = obj instanceof IType ? (IType)obj : TypeSystem.getFromObject(obj);
        ITypeInfo typeInfo = type.getTypeInfo();
        Options options = CommandLineAccess.deriveOptionsFromTypeInfo(typeInfo, propsToSet, obj instanceof IType);
        BasicParser parser = new BasicParser();
        try {
            CommandLine cl = parser.parse(options, _args.toArray(new String[_args.size()]));
            for (IPropertyInfo propertyInfo : propsToSet) {
                Object value;
                if (CommandLineAccess.isBooleanProp(propertyInfo = typeInfo.getProperty(propertyInfo.getName()))) {
                    propertyInfo.getAccessor().setValue(obj, cl.hasOption(CommandLineAccess.getShortName(propertyInfo)));
                    continue;
                }
                String defaultValue = null;
                if (propertyInfo.hasAnnotation(TypeSystem.get(DefaultValue.class))) {
                    IAnnotationInfo annotationInfo = propertyInfo.getAnnotationsOfType(TypeSystem.get(DefaultValue.class)).get(0);
                    defaultValue = ((DefaultValue)annotationInfo.getInstance()).value();
                }
                String shortName = CommandLineAccess.getShortName(propertyInfo);
                if (propertyInfo.getFeatureType().isArray()) {
                    value = cl.getOptionValues(shortName);
                    if (propertyInfo.hasAnnotation(TypeSystem.get(Args.class))) {
                        value = cl.getArgs();
                    } else if (value == null) {
                        if (defaultValue != null) {
                            value = defaultValue.split(" +");
                        } else if (cl.hasOption(shortName)) {
                            value = new String[]{};
                        }
                    }
                } else {
                    if (!CommandLineAccess.needsArg(propertyInfo) && defaultValue == null) {
                        defaultValue = "";
                    }
                    value = cl.getOptionValue(shortName, defaultValue);
                }
                try {
                    propertyInfo.getAccessor().setValue(obj, CommandLineAccess.convertValue(propertyInfo.getFeatureType(), value));
                }
                catch (Exception e) {
                    throw new gw.internal.ext.org.apache.commons.cli.ParseException("The parameter \"" + shortName + "\" requires an argument of type " + propertyInfo.getFeatureType().getRelativeName() + ".  The value \"" + value + "\" cannot be converted to this type.  Please pass in a valid value." + (e.getMessage() == null ? "" : "  Error message was : " + e.getMessage()));
                    return true;
                }
            }
        }
        catch (gw.internal.ext.org.apache.commons.cli.ParseException e) {
            if (!exitOnBadArgs) return false;
            if (!(e.getMessage().endsWith("-help") || e.getMessage().endsWith("-h") || e.getMessage().endsWith("--help"))) {
                System.out.println("\nArgument problem: " + e.getMessage() + "\n");
            }
            try {
                CommandLineAccess.showHelp(CommandLineAccess.getCurrentProgramName(), type);
            }
            catch (StringIndexOutOfBoundsException e1) {
                System.out.println("Unable to print help message.  Exiting.");
            }
            if (!_exitEnabled) throw new SystemExitIgnoredException();
            System.exit(-1);
            throw new SystemExitIgnoredException();
        }
    }

    static Object convertValue(IType type, Object value) {
        if (value instanceof String) {
            if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
                return Short.parseShort(value.toString());
            }
            if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
                return Integer.parseInt(value.toString());
            }
            if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                return Long.parseLong(value.toString());
            }
            if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
                return Float.valueOf(Float.parseFloat(value.toString()));
            }
            if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
                return Double.parseDouble(value.toString());
            }
            if (type == JavaTypes.DATE()) {
                try {
                    return CommonServices.getCoercionManager().parseDateTime(value.toString());
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return CommonServices.getCoercionManager().convertValue(value, type);
    }

    private static String getCurrentProgramName() {
        File file = CommandLineAccess.getCurrentProgram();
        if (file != null) {
            return file.getName();
        }
        return "unknown program";
    }

    public static void showHelp(String programName, Object obj) {
        PrintWriter pw = new PrintWriter(StreamUtil.getOutputStreamWriter(System.out));
        CommandLineAccess.printHelpToWriter(programName, obj, pw);
        pw.flush();
    }

    public static void showHelp(IType obj) {
        PrintWriter pw = new PrintWriter(StreamUtil.getOutputStreamWriter(System.out));
        CommandLineAccess.printHelpToWriter(CommandLineAccess.getCurrentProgramName(), obj, pw);
        pw.flush();
    }

    public static String getHelpMessageFor(Object obj) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        CommandLineAccess.printHelpToWriter(CommandLineAccess.getCurrentProgramName(), obj, pw);
        pw.flush();
        return writer.toString();
    }

    private static void printHelpToWriter(String programName, Object obj, PrintWriter pw) {
        GosuHelpFormatter formatter = new GosuHelpFormatter();
        if (_useTerminalWidth) {
            formatter.setWidth(80);
        }
        ITypeInfo typeInfo = obj instanceof IType ? ((IType)obj).getTypeInfo() : TypeSystem.getFromObject(obj).getTypeInfo();
        Options options = CommandLineAccess.deriveOptionsFromTypeInfo(typeInfo, new ArrayList<IPropertyInfo>(), obj instanceof IType);
        System.err.println("Printing help with defaultWidth= " + formatter.getWidth() + " programName= " + programName + " defaultLeftPad= " + formatter.getLeftPadding() + " defaultDescPad= " + formatter.getDescPadding());
        formatter.printHelp(pw, formatter.getWidth(), programName, null, options, formatter.getLeftPadding(), formatter.getDescPadding(), null, false);
    }

    private static Options deriveOptionsFromTypeInfo(ITypeInfo typeInfo, List<IPropertyInfo> propsToSet, boolean useStaticProps) {
        List<? extends IPropertyInfo> propertyInfos = typeInfo.getProperties();
        Options options = new Options();
        for (IPropertyInfo iPropertyInfo : propertyInfos) {
            Annotation argNames;
            IGosuVarPropertyInfo gsVarPropInfo;
            if (iPropertyInfo instanceof IGosuVarPropertyInfo && ((gsVarPropInfo = (IGosuVarPropertyInfo)iPropertyInfo).hasDeclaredProperty() || gsVarPropInfo.isFinal()) || useStaticProps != iPropertyInfo.isStatic() || !iPropertyInfo.isWritable(null)) continue;
            String shortName = CommandLineAccess.getShortName(iPropertyInfo);
            boolean needsArg = CommandLineAccess.needsArg(iPropertyInfo);
            GosuOption opt = new GosuOption(shortName, CommandLineAccess.getLongName(iPropertyInfo), needsArg, CommandLineAccess.deriveDescription(iPropertyInfo));
            opt.setHidden(iPropertyInfo.hasAnnotation(TypeSystem.get(Hidden.class)));
            opt.setRequired(iPropertyInfo.hasAnnotation(TypeSystem.get(Required.class)));
            if (iPropertyInfo.getFeatureType().isArray()) {
                opt.setType(iPropertyInfo.getFeatureType().getComponentType().getName());
                if (iPropertyInfo.hasAnnotation(TypeSystem.get(ArgNames.class))) {
                    argNames = (ArgNames)iPropertyInfo.getAnnotationsOfType(TypeSystem.get(ArgNames.class)).get(0).getInstance();
                    if (argNames.names() != null && argNames.names().length > 0) {
                        String compoundNames = "";
                        for (int i = 0; i < argNames.names().length; ++i) {
                            if (i != 0) {
                                compoundNames = compoundNames + " ";
                            }
                            compoundNames = compoundNames + argNames.names()[i];
                        }
                        opt.setArgName(compoundNames);
                        if (iPropertyInfo.hasAnnotation(TypeSystem.get(ArgOptional.class))) {
                            opt.setOptionalArg(true);
                        }
                        opt.setArgs(argNames.names().length);
                    }
                } else {
                    opt.setArgs(-2);
                }
                if (iPropertyInfo.hasAnnotation(TypeSystem.get(Separator.class))) {
                    argNames = (Separator)iPropertyInfo.getAnnotationsOfType(TypeSystem.get(Separator.class)).get(0).getInstance();
                    opt.setValueSeparator(argNames.value().charAt(0));
                }
            } else {
                opt.setType(iPropertyInfo.getFeatureType().getName());
                if (iPropertyInfo.hasAnnotation(TypeSystem.get(ArgNames.class)) && (argNames = (ArgNames)iPropertyInfo.getAnnotationsOfType(TypeSystem.get(ArgNames.class)).get(0).getInstance()).names() != null && argNames.names().length > 0) {
                    opt.setArgName(argNames.names()[0]);
                }
            }
            propsToSet.add(iPropertyInfo);
            options.addOption((Option)opt);
        }
        return options;
    }

    protected static String deriveDescription(IPropertyInfo propertyInfo) {
        String description;
        IType intrinsicType = propertyInfo.getOwnersType();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(intrinsicType.getName(), Locale.getDefault(), TypeSystem.getGosuClassLoader().getActualLoader());
            description = resourceBundle.getString(propertyInfo.getName());
        }
        catch (MissingResourceException e) {
            description = propertyInfo.getDescription();
        }
        return description == null ? "" : description.replaceAll("\n", " ");
    }

    private static String getShortName(IPropertyInfo propertyInfo) {
        String shortName = CommandLineAccess.makeCmdLineOptionName(propertyInfo);
        if (propertyInfo.hasAnnotation(TypeSystem.get(ShortName.class))) {
            IAnnotationInfo annotation = propertyInfo.getAnnotationsOfType(TypeSystem.get(ShortName.class)).get(0);
            ShortName value = (ShortName)annotation.getInstance();
            shortName = value.name();
        }
        return shortName;
    }

    private static String getLongName(IPropertyInfo propertyInfo) {
        String shortName = CommandLineAccess.makeCmdLineOptionName(propertyInfo);
        if (propertyInfo.hasAnnotation(TypeSystem.get(LongName.class))) {
            IAnnotationInfo annotation = propertyInfo.getAnnotationsOfType(TypeSystem.get(LongName.class)).get(0);
            LongName value = (LongName)annotation.getInstance();
            shortName = value.name();
        }
        return shortName;
    }

    private static String makeCmdLineOptionName(IPropertyInfo propertyInfo) {
        String name = propertyInfo.getName();
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        StringBuilder optionName = new StringBuilder();
        boolean lastWasLowerCase = false;
        for (int i = 0; i < name.length(); ++i) {
            if (i == 0) {
                optionName.append(Character.toLowerCase(name.charAt(i)));
                lastWasLowerCase = false;
                continue;
            }
            if (Character.isUpperCase(name.charAt(i))) {
                if (lastWasLowerCase) {
                    optionName.append("_");
                }
                optionName.append(Character.toLowerCase(name.charAt(i)));
                lastWasLowerCase = false;
                continue;
            }
            char c = name.charAt(i);
            optionName.append(c);
            lastWasLowerCase = Character.isLetter(c) && Character.isLowerCase(c);
        }
        return optionName.toString();
    }

    private static boolean needsArg(IPropertyInfo propertyInfo) {
        boolean requiresArgument = true;
        if (CommandLineAccess.isBooleanProp(propertyInfo)) {
            requiresArgument = false;
        } else if (propertyInfo.getFeatureType().isArray()) {
            requiresArgument = false;
        } else if (propertyInfo.hasAnnotation(TypeSystem.get(ArgOptional.class))) {
            requiresArgument = false;
        }
        return requiresArgument;
    }

    private static boolean isBooleanProp(IPropertyInfo propertyInfo) {
        return propertyInfo.getFeatureType().equals(JavaTypes.BOOLEAN()) || propertyInfo.getFeatureType().equals(JavaTypes.pBOOLEAN());
    }

    public static void setExitEnabled(boolean exitEnabled) {
        _exitEnabled = exitEnabled;
    }
}

