/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser;

import gw.lang.parser.IDynamicPropertySymbol;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.ISymbol;
import gw.lang.reflect.gs.IExternalSymbolMap;
import java.lang.reflect.Array;

public abstract class ExternalSymbolMapBase
implements IExternalSymbolMap {
    private boolean _assumeSymbolsRequireExternalSymbolMapArgument;

    protected ExternalSymbolMapBase(boolean assumeSymbolsRequireExternalSymbolMapArgument) {
        this._assumeSymbolsRequireExternalSymbolMapArgument = assumeSymbolsRequireExternalSymbolMapArgument;
    }

    @Override
    public Object getValue(String name) {
        ISymbol symbol = this.getSymbol(name);
        this.verifySymbol(name, symbol);
        if (this._assumeSymbolsRequireExternalSymbolMapArgument && symbol instanceof IDynamicPropertySymbol) {
            return ((IDynamicPropertySymbol)symbol).getGetterDfs().invoke(new Object[]{this});
        }
        return symbol.getValue();
    }

    @Override
    public Object getValue(String name, int iArrayDims) {
        Object value = this.getValue(name);
        if (iArrayDims < 0) {
            return value;
        }
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (this.isCapturedSymbol(iArrayDims, value, valueClass)) {
            return ((Object[])value)[0];
        }
        return value;
    }

    private boolean isCapturedSymbol(int iArrayDims, Object value, Class valueClass) {
        if (value != null && valueClass.isArray() && Array.getLength(value) == 1) {
            int iValueDims = 0;
            while (valueClass.isArray()) {
                ++iValueDims;
                valueClass = valueClass.getComponentType();
            }
            if (iValueDims - 1 == iArrayDims) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValue(String name, Object value) {
        ISymbol symbol = this.getSymbol(name);
        this.verifySymbol(name, symbol);
        if (this._assumeSymbolsRequireExternalSymbolMapArgument && symbol instanceof IDynamicPropertySymbol) {
            ((IDynamicPropertySymbol)symbol).getSetterDfs().invoke(new Object[]{this, value});
        } else {
            symbol.setValue(value);
        }
    }

    @Override
    public Object invoke(String name, Object[] args) {
        IFunctionSymbol functionSymbol = (IFunctionSymbol)this.getSymbol(name);
        if (this.shouldAddInExternalSymbolMapArgumentForFunctionSymbol(functionSymbol)) {
            if (args == null) {
                args = new Object[]{this};
            } else {
                Object[] originalArgs = args;
                args = new Object[originalArgs.length + 1];
                args[0] = this;
                System.arraycopy(originalArgs, 0, args, 1, originalArgs.length);
            }
        }
        return functionSymbol.invoke(args);
    }

    protected boolean shouldAddInExternalSymbolMapArgumentForFunctionSymbol(IFunctionSymbol symbol) {
        return this._assumeSymbolsRequireExternalSymbolMapArgument;
    }

    protected void verifySymbol(String name, ISymbol symbol) {
        if (symbol == null) {
            throw new IllegalStateException("External symbol not found: " + name);
        }
    }

    protected String handleCrappyPcfCapitalization(CharSequence name) {
        if (name.length() > 1) {
            String strName = null;
            char c = name.charAt(0);
            if (Character.isUpperCase(c)) {
                strName = Character.toLowerCase(c) + name.subSequence(1, name.length()).toString();
            } else if (Character.isLowerCase(c)) {
                strName = Character.toUpperCase(c) + name.subSequence(1, name.length()).toString();
            }
            return strName;
        }
        return null;
    }

    protected abstract ISymbol getSymbol(String var1);
}

