/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.parser.IExpression;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;

public class ParameterInfoBuilder {
    private String _name;
    private String _description;
    private IType _type;
    private IExpression _defValue;

    public ParameterInfoBuilder withName(String name) {
        this._name = name;
        return this;
    }

    public ParameterInfoBuilder withDescription(String description) {
        this._description = description;
        return this;
    }

    public ParameterInfoBuilder withType(IType type) {
        this._type = type;
        return this;
    }

    public ParameterInfoBuilder withDefValue(IExpression value) {
        this._defValue = value;
        return this;
    }

    public ParameterInfoBuilder withType(Class clazz) {
        this._type = TypeSystem.get(clazz);
        return this;
    }

    public ParameterInfoBuilder like(IParameterInfo param) {
        this.withName(param.getName());
        this.withDescription(param.getDescription());
        this.withType(param.getFeatureType());
        return this;
    }

    public IParameterInfo build(IFeatureInfo container) {
        return new BuiltParameterInfo(this, container);
    }

    public static class BuiltParameterInfo
    implements IParameterInfo {
        private final IFeatureInfo _container;
        private final String _name;
        private final String _description;
        private final IType _type;
        private final IExpression _defValue;

        public BuiltParameterInfo(ParameterInfoBuilder builder, IFeatureInfo container) {
            assert (container != null);
            assert (builder._name != null);
            assert (builder._type != null);
            this._container = container;
            this._name = this.makeDisplayName(builder._name);
            this._description = builder._description;
            this._type = builder._type;
            this._defValue = builder._defValue;
        }

        private String makeDisplayName(String name) {
            if (name == null) {
                return null;
            }
            int iParen = name.indexOf(40);
            if (iParen > 0) {
                return name.substring(0, iParen);
            }
            return name;
        }

        @Override
        public IFeatureInfo getContainer() {
            return this._container;
        }

        @Override
        public IType getOwnersType() {
            return this._container.getOwnersType();
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getDisplayName() {
            return this._name;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public IType getFeatureType() {
            return this._type;
        }

        public IExpression getDefaultValue() {
            return this._defValue;
        }
    }
}

