/*
 * Decompiled with CFR 0.152.
 */
package gw.fs.physical.win32;

import gw.fs.physical.win32.INativeWin32APICallback;
import gw.fs.physical.win32.Win32FindData;
import gw.lang.UnstableAPI;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@UnstableAPI
public class NativeWin32API {
    public static int _numNativeFiles = 0;
    public static int _numJavaFiles = 0;
    private static boolean _enabled = false;

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        NativeWin32API.recursiveListDir("C:\\eng\\diamond\\pl2\\active\\core");
        System.out.println("Native found " + _numNativeFiles + " in " + (System.currentTimeMillis() - start));
        NativeWin32API.testFileMetadata("C:\\eng\\diamond\\pl2\\active\\core\\platform\\gosu-core\\src\\gw\\internal\\gosu\\module\\fs\\IFileFactory.java", "C:\\eng\\diamond\\pl2\\active\\core\\platform\\gosu-core\\src\\gw\\internal\\gosu\\module\\fs\\ResourcePath.java");
        NativeWin32API.testFileListing("C:\\eng\\diamond\\pl2\\active\\core", "C:\\eng\\diamond\\pl2\\active\\core\\platform\\gosu-core\\src\\gw\\internal\\gosu\\module\\fs");
    }

    public static void recursiveListDir(String path) {
        List<Win32FindData> metadataList = NativeWin32API.listDir(path);
        for (Win32FindData fileMd : metadataList) {
            ++_numNativeFiles;
            if ((0x10 & fileMd.getAttributes()) == 0) continue;
            NativeWin32API.recursiveListDir(path + "\\" + fileMd.getName());
        }
    }

    public static void recursiveListDirInJava(File f) {
        File[] files;
        for (File child : files = f.listFiles()) {
            ++_numJavaFiles;
            if (!child.isDirectory()) continue;
            NativeWin32API.recursiveListDirInJava(child);
        }
    }

    public static void testFileMetadata(String path1, String path2) {
        int numTests = 10000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            NativeWin32API.fileMetadata(path2);
        }
        long nativeTime = System.currentTimeMillis() - start;
        System.out.println("Native attribute time was " + nativeTime + "ms");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            new File(path2).lastModified();
        }
        long javaTime = System.currentTimeMillis() - start;
        System.out.println("Java attribute time was " + javaTime + "ms");
    }

    public static void testFileListing(String path1, String path2) {
        int numTests = 1000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            NativeWin32API.listDir(path1);
            NativeWin32API.listDir(path2);
        }
        long nativeTime = System.currentTimeMillis() - start;
        System.out.println("Native listing time was " + nativeTime + "ms");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            new File(path1).listFiles();
            new File(path2).listFiles();
        }
        long javaTime = System.currentTimeMillis() - start;
        System.out.println("Java listing time was " + javaTime + "ms");
    }

    public static List<Win32FindData> listDir(String path) {
        final ArrayList<Win32FindData> results = new ArrayList<Win32FindData>();
        NativeWin32API.listDirectory(path, new INativeWin32APICallback(){

            @Override
            public void handleFile(String name, int attributes, long createTime, long lastAccessTime, long lastModifiedTime, long length) {
                if (!name.equals(".") && !name.equals("..")) {
                    results.add(new Win32FindData(attributes, createTime, lastAccessTime, lastModifiedTime, length, name));
                }
            }
        });
        return results;
    }

    public static Win32FindData fileMetadata(String path) {
        final Win32FindData[] result = new Win32FindData[1];
        NativeWin32API.fileMetadata(path, new INativeWin32APICallback(){

            @Override
            public void handleFile(String name, int attributes, long createTime, long lastAccessTime, long lastModifiedTime, long length) {
                result[0] = new Win32FindData(attributes, createTime, lastAccessTime, lastModifiedTime, length, name);
            }
        });
        return result[0];
    }

    public static native void listDirectory(String var0, INativeWin32APICallback var1);

    public static native void fileMetadata(String var0, INativeWin32APICallback var1);

    static {
        try {
            URL loc = Class.forName("gw.NativeLibraryLocationMarker").getProtectionDomain().getCodeSource().getLocation();
            System.load(new File(loc.toURI()).getParent() + File.separator + "newdirscanner.dll");
            _enabled = true;
        }
        catch (Throwable t) {
            _enabled = false;
            t.printStackTrace();
        }
    }
}

