/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class StringCache {
    private static Map<StringSoftReference, StringSoftReference> _cache = new HashMap<StringSoftReference, StringSoftReference>();
    private static Key _key = new Key("");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String rawString) {
        StringSoftReference cachedReference;
        if (rawString == null) {
            return null;
        }
        Map<StringSoftReference, StringSoftReference> map = _cache;
        synchronized (map) {
            _key.thisString = rawString;
            cachedReference = _cache.get(_key);
            if (cachedReference == null || cachedReference.get() == null) {
                cachedReference = new StringSoftReference(new String(rawString));
                _cache.put(cachedReference, cachedReference);
            }
        }
        return (String)cachedReference.get();
    }

    private static class StringSoftReference
    extends SoftReference<String> {
        public StringSoftReference(String referent) {
            super(referent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            String thisString = (String)this.get();
            String thatString = (String)((StringSoftReference)o).get();
            if (thisString == null) {
                return thatString == null;
            }
            if (thatString == null) {
                return false;
            }
            if (thisString.hashCode() != thatString.hashCode()) {
                return false;
            }
            return thisString.equals(thatString);
        }

        public int hashCode() {
            String thisString = (String)this.get();
            return thisString != null ? thisString.hashCode() : 0;
        }

        public String toString() {
            return (String)this.get();
        }
    }

    private static class Key {
        private String thisString;

        public Key(String string) {
            this.thisString = string;
        }

        public boolean equals(Object o) {
            String thatString = (String)((SoftReference)o).get();
            if (thatString == null) {
                return false;
            }
            if (this.thisString.hashCode() != thatString.hashCode()) {
                return false;
            }
            return this.thisString.equals(thatString);
        }

        public int hashCode() {
            return this.thisString.hashCode();
        }
    }
}

