/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.coercers;

import gw.config.CommonServices;
import gw.lang.parser.ICoercer;
import gw.lang.parser.IResolvingCoercer;
import gw.lang.parser.coercers.BooleanCoercer;
import gw.lang.parser.coercers.ByteCoercer;
import gw.lang.parser.coercers.CharCoercer;
import gw.lang.parser.coercers.DoubleCoercer;
import gw.lang.parser.coercers.FloatCoercer;
import gw.lang.parser.coercers.IntCoercer;
import gw.lang.parser.coercers.LongCoercer;
import gw.lang.parser.coercers.ShortCoercer;
import gw.lang.parser.coercers.StandardCoercer;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.TypeSystemShutdownListener;
import gw.lang.reflect.java.JavaTypes;
import gw.util.concurrent.LockingLazyVar;

public class BasePrimitiveCoercer
extends StandardCoercer
implements IResolvingCoercer {
    public static final LockingLazyVar<BasePrimitiveCoercer> DoublePCoercer = new LockingLazyVar<BasePrimitiveCoercer>(){

        @Override
        protected BasePrimitiveCoercer init() {
            return new BasePrimitiveCoercer(DoubleCoercer.instance(), JavaTypes.pDOUBLE(), JavaTypes.DOUBLE());
        }
    };
    public static final LockingLazyVar<BasePrimitiveCoercer> FloatPCoercer = new LockingLazyVar<BasePrimitiveCoercer>(){

        @Override
        protected BasePrimitiveCoercer init() {
            return new BasePrimitiveCoercer(FloatCoercer.instance(), JavaTypes.pFLOAT(), JavaTypes.FLOAT());
        }
    };
    public static final LockingLazyVar<BasePrimitiveCoercer> BooleanPCoercer = new LockingLazyVar<BasePrimitiveCoercer>(){

        @Override
        protected BasePrimitiveCoercer init() {
            return new BasePrimitiveCoercer(BooleanCoercer.instance(), JavaTypes.pBOOLEAN(), JavaTypes.BOOLEAN());
        }
    };
    public static final LockingLazyVar<BasePrimitiveCoercer> BytePCoercer = new LockingLazyVar<BasePrimitiveCoercer>(){

        @Override
        protected BasePrimitiveCoercer init() {
            return new BasePrimitiveCoercer(ByteCoercer.instance(), JavaTypes.pBYTE(), JavaTypes.BYTE());
        }
    };
    public static final LockingLazyVar<BasePrimitiveCoercer> ShortPCoercer = new LockingLazyVar<BasePrimitiveCoercer>(){

        @Override
        protected BasePrimitiveCoercer init() {
            return new BasePrimitiveCoercer(ShortCoercer.instance(), JavaTypes.pSHORT(), JavaTypes.SHORT());
        }
    };
    public static final LockingLazyVar<BasePrimitiveCoercer> CharPCoercer = new LockingLazyVar<BasePrimitiveCoercer>(){

        @Override
        protected BasePrimitiveCoercer init() {
            return new BasePrimitiveCoercer(CharCoercer.instance(), JavaTypes.pCHAR(), JavaTypes.CHARACTER());
        }
    };
    public static final LockingLazyVar<BasePrimitiveCoercer> IntPCoercer = new LockingLazyVar<BasePrimitiveCoercer>(){

        @Override
        protected BasePrimitiveCoercer init() {
            return new BasePrimitiveCoercer(IntCoercer.instance(), JavaTypes.pINT(), JavaTypes.INTEGER());
        }
    };
    public static final LockingLazyVar<BasePrimitiveCoercer> LongPCoercer = new LockingLazyVar<BasePrimitiveCoercer>(){

        @Override
        protected BasePrimitiveCoercer init() {
            return new BasePrimitiveCoercer(LongCoercer.instance(), JavaTypes.pLONG(), JavaTypes.LONG());
        }
    };
    private final ICoercer _nonPrimitiveCoercer;
    private final IType _primitiveType;
    private final IType _nonPrimitveType;

    public BasePrimitiveCoercer(ICoercer nonPrimitiveCoercer, IType primitiveType, IType nonPrimitiveType) {
        this._nonPrimitiveCoercer = nonPrimitiveCoercer;
        this._primitiveType = primitiveType;
        this._nonPrimitveType = nonPrimitiveType;
    }

    @Override
    public final Object coerceValue(IType typeToCoerceTo, Object value) {
        if (value == null) {
            return CommonServices.getCoercionManager().convertNullAsPrimitive(this._primitiveType, false);
        }
        return this._nonPrimitiveCoercer.coerceValue(typeToCoerceTo, value);
    }

    @Override
    public boolean handlesNull() {
        return true;
    }

    @Override
    public IType resolveType(IType target, IType source) {
        return target.isPrimitive() ? this._primitiveType : this._nonPrimitveType;
    }

    @Override
    public int getPriority(IType to, IType from) {
        return BasePrimitiveCoercer.getPriorityOf(to, from);
    }

    public static int getPriorityOf(IType to, IType from) {
        if (to == from) {
            return 0;
        }
        int infoLoss = BasePrimitiveCoercer.losesInformation(from, to);
        boolean bSameFamily = BasePrimitiveCoercer.isInSameFamily(from, to);
        int iScore = 1;
        if (infoLoss > 1) {
            iScore += 24;
            if (!bSameFamily) {
                ++iScore;
            }
        } else if (bSameFamily) {
            if (from == JavaTypes.pCHAR() || from == JavaTypes.CHARACTER()) {
                from = JavaTypes.pSHORT();
            }
            iScore += BasePrimitiveCoercer.distance(from, to);
        } else {
            iScore += infoLoss;
            iScore += 4;
        }
        return iScore;
    }

    private static int distance(IType from, IType to) {
        int iDistance = BasePrimitiveCoercer.getIndex(to) - BasePrimitiveCoercer.getIndex(from);
        return iDistance >= 0 ? iDistance : 5;
    }

    public static int losesInformation(IType from, IType to) {
        int[][] tab = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {2, 0, 2, 2, 0, 0, 0, 1}, {2, 0, 0, 0, 0, 0, 0, 1}, {2, 2, 2, 0, 0, 0, 0, 1}, {2, 2, 2, 2, 0, 0, 0, 1}, {2, 2, 2, 2, 2, 0, 0, 1}, {2, 2, 2, 2, 2, 2, 0, 0}, {2, 2, 2, 2, 2, 2, 1, 0}};
        int i = BasePrimitiveCoercer.getIndex(from);
        int j = BasePrimitiveCoercer.getIndex(to);
        if (i == -1 || j == -1) {
            return 0;
        }
        return tab[i][j];
    }

    private static int getIndex(IType type) {
        if (type == JavaTypes.pBOOLEAN() || type == JavaTypes.BOOLEAN()) {
            return 0;
        }
        if (type == JavaTypes.pCHAR() || type == JavaTypes.CHARACTER()) {
            return 1;
        }
        if (type == JavaTypes.pBYTE() || type == JavaTypes.BYTE()) {
            return 2;
        }
        if (type == JavaTypes.pSHORT() || type == JavaTypes.SHORT()) {
            return 3;
        }
        if (type == JavaTypes.pINT() || type == JavaTypes.INTEGER()) {
            return 4;
        }
        if (type == JavaTypes.pLONG() || type == JavaTypes.LONG()) {
            return 5;
        }
        if (type == JavaTypes.pFLOAT() || type == JavaTypes.FLOAT()) {
            return 6;
        }
        if (type == JavaTypes.pDOUBLE() || type == JavaTypes.DOUBLE()) {
            return 7;
        }
        return -1;
    }

    private static boolean isInSameFamily(IType t1, IType t2) {
        int indexT2;
        int indexT1 = BasePrimitiveCoercer.getIndex(t1);
        return indexT1 == (indexT2 = BasePrimitiveCoercer.getIndex(t2)) || indexT1 > 0 && indexT1 < 6 && indexT2 > 0 && indexT2 < 6 || indexT1 > 5 && indexT2 > 5;
    }

    static {
        TypeSystem.addShutdownListener(new TypeSystemShutdownListener(){

            @Override
            public void shutdown() {
                DoublePCoercer.clear();
                FloatPCoercer.clear();
                BooleanPCoercer.clear();
                BytePCoercer.clear();
                ShortPCoercer.clear();
                CharPCoercer.clear();
                IntPCoercer.clear();
                LongPCoercer.clear();
            }
        });
    }
}

