/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.lang.GosuShop;
import gw.lang.parser.ISourceCodeTokenizer;
import java.util.ArrayList;
import java.util.List;

public class GosuClassLightParser {
    private ISourceCodeTokenizer lexer;

    private String getTokenText() {
        return this.lexer.getTokenAsString();
    }

    private int advance() {
        return this.lexer.nextToken();
    }

    public GosuClassLightParser(String text) {
        this.lexer = GosuShop.createSourceCodeTokenizer(text);
        this.lexer.setCommentsSignificant(false);
        this.lexer.setWhitespaceSignificant(false);
    }

    private String findInnerClassDeclaration(ISourceCodeTokenizer lexer) {
        this.advance();
        if (this.isWord()) {
            String name = lexer.getTokenAsString();
            this.consumeParametrization();
            if (this.isChar('{')) {
                this.revert();
                return name;
            }
        }
        return null;
    }

    private void revert() {
        this.lexer.restoreToMark(this.lexer.mark() - 1);
    }

    private void consumeParametrization() {
        int parametrizationLevel = 0;
        this.advance();
        if (!this.isOperator("<")) {
            return;
        }
        while (this.hasTokens()) {
            if (this.isOperator("<")) {
                ++parametrizationLevel;
            } else if (this.isOperator(">") && --parametrizationLevel == 0) {
                this.advance();
                return;
            }
            this.advance();
        }
    }

    private boolean isOperator(String text) {
        return this.lexer.getType() == -6 && this.getTokenText().equals("'" + text + "'");
    }

    private boolean hasTokens() {
        return this.lexer.getType() != -1;
    }

    private boolean isWord() {
        return this.lexer.getType() == -5;
    }

    private boolean isChar(char c) {
        return this.lexer.getType() == c;
    }

    private boolean isKeyword(String text) {
        return this.lexer.getType() == -7 && this.getTokenText().equals(text);
    }

    public List<String> getInnerClasses() {
        ClassScope root = new ClassScope("");
        root.parse();
        ArrayList<String> classes = new ArrayList<String>();
        root.getClasses("", classes);
        return classes;
    }

    class ClassScope {
        String name;
        int braketLevel;
        List<ClassScope> children = new ArrayList<ClassScope>();
        final boolean isRoot;

        public ClassScope(String name) {
            this.name = name;
            this.isRoot = name.isEmpty();
            if (this.isRoot) {
                this.braketLevel = 1;
            }
        }

        private void parse() {
            GosuClassLightParser.this.advance();
            while (GosuClassLightParser.this.hasTokens()) {
                String innerClassDeclaration;
                if (this.isRoot && GosuClassLightParser.this.isKeyword("package")) {
                    GosuClassLightParser.this.advance();
                    this.name = this.parsePackage();
                } else if (GosuClassLightParser.this.isChar('{')) {
                    ++this.braketLevel;
                } else if (GosuClassLightParser.this.isChar('}')) {
                    --this.braketLevel;
                    if (this.braketLevel == 0) {
                        return;
                    }
                } else if (this.braketLevel == 1 && (GosuClassLightParser.this.isKeyword("class") || GosuClassLightParser.this.isKeyword("interface") || GosuClassLightParser.this.isKeyword("structure") || GosuClassLightParser.this.isKeyword("enum")) && (innerClassDeclaration = GosuClassLightParser.this.findInnerClassDeclaration(GosuClassLightParser.this.lexer)) != null) {
                    ClassScope classScope = new ClassScope(innerClassDeclaration);
                    classScope.parse();
                    this.children.add(classScope);
                }
                GosuClassLightParser.this.advance();
            }
        }

        private String parsePackage() {
            StringBuilder s = new StringBuilder();
            while (GosuClassLightParser.this.isWord() || GosuClassLightParser.this.isOperator(".")) {
                s.append(GosuClassLightParser.this.getTokenText());
                GosuClassLightParser.this.advance();
            }
            GosuClassLightParser.this.revert();
            return s.toString().trim();
        }

        public String toString() {
            return this.name;
        }

        public void getClasses(String prefix, List<String> classes) {
            String qName;
            String string = qName = this.isRoot ? this.name : prefix + "." + this.name;
            if (!this.isRoot) {
                classes.add(qName);
            }
            for (ClassScope child : this.children) {
                child.getClasses(qName, classes);
            }
        }
    }
}

