/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.lang.reflect.gs.IGosuClassRepository;
import gw.lang.reflect.gs.ISourceFileHandle;
import java.io.File;
import java.io.Reader;

public interface IFileSystemGosuClassRepository
extends IGosuClassRepository {
    public IDirectory[] getSourcePath();

    public void setSourcePath(IDirectory[] var1);

    public IDirectory[] getExcludedPath();

    public void setExcludedPath(IDirectory[] var1);

    public String getClassNameFromFile(IDirectory var1, IFile var2, String[] var3);

    public IFile findFirstFile(String var1);

    public static class Util {
        public static boolean isClassFileName(String strName, String[] fileExts) {
            for (String strExt : fileExts) {
                if (!strName.endsWith(strExt)) continue;
                return true;
            }
            return false;
        }

        public static void shiftInnerClassToFileName(StringBuilder innerClass, StringBuilder fileName) {
            if (innerClass.length() > 0 && fileName.length() > 0) {
                fileName.append(File.separatorChar);
            }
            while (innerClass.length() > 0 && innerClass.charAt(0) != '.') {
                fileName.append(innerClass.charAt(0));
                innerClass.deleteCharAt(0);
            }
            if (innerClass.length() > 0 && innerClass.charAt(0) == '.') {
                innerClass.deleteCharAt(0);
            }
        }
    }

    public static interface IClassFileInfo {
        public IDirectory getParentFile();

        public IFile getFile();

        public Reader getReader();

        public String getFileName();

        public String getNonCanonicalFileName();

        public String getFilePath();

        public int getClassPathLength();

        public boolean hasInnerClass();

        public ISourceFileHandle getSourceFileHandle();

        public ClassPathEntry getEntry();

        public String getContent();
    }

    public static class ClassPathEntry {
        private final IDirectory _path;
        private final boolean _isTestResource;

        public ClassPathEntry(IDirectory path, boolean testResource) {
            this._path = path;
            this._isTestResource = testResource;
        }

        public IDirectory getPath() {
            return this._path;
        }

        public boolean isTestResource() {
            return this._isTestResource;
        }

        public String toString() {
            return "" + this._path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassPathEntry)) {
                return false;
            }
            ClassPathEntry that = (ClassPathEntry)o;
            if (this._isTestResource != that._isTestResource) {
                return false;
            }
            return !(this._path != null ? !this._path.equals(that._path) : that._path != null);
        }

        public int hashCode() {
            int result = this._path != null ? this._path.hashCode() : 0;
            result = 31 * result + (this._isTestResource ? 1 : 0);
            return result;
        }
    }
}

