/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.GosuShop;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAnnotatedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IConstructorType;
import gw.lang.reflect.IEventInfo;
import gw.lang.reflect.IInvocableType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeVariableArrayType;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.MethodScore;
import gw.lang.reflect.MethodScorer;
import gw.lang.reflect.TypeSystem;
import gw.util.DynamicArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public interface ITypeInfo
extends IAnnotatedFeatureInfo {
    public static final String TYPEINFO_EXT = "TypeInfo";

    public List<? extends IPropertyInfo> getProperties();

    public IPropertyInfo getProperty(CharSequence var1);

    public MethodList getMethods();

    public IMethodInfo getMethod(CharSequence var1, IType ... var2);

    public IMethodInfo getCallableMethod(CharSequence var1, IType ... var2);

    public List<? extends IConstructorInfo> getConstructors();

    public IConstructorInfo getConstructor(IType ... var1);

    public IConstructorInfo getCallableConstructor(IType ... var1);

    public List<? extends IEventInfo> getEvents();

    public IEventInfo getEvent(CharSequence var1);

    public static class FIND {
        private static final IType[] EMPTY_TYPES = IType.EMPTY_ARRAY;

        public static IMethodInfo method(MethodList methodList, CharSequence method, IType ... params) {
            params = params == null ? EMPTY_TYPES : params;
            DynamicArray<? extends IMethodInfo> methods = methodList.getMethods(method.toString());
            for (int i = 0; i < methods.size; ++i) {
                IParameterInfo[] paramInfos;
                IMethodInfo methodInfo = (IMethodInfo)methods.data[i];
                if (!methodInfo.getDisplayName().equals(method.toString()) || !FIND.areParamsEqual(paramInfos = methodInfo.getParameters(), params)) continue;
                return methodInfo;
            }
            return null;
        }

        public static IConstructorInfo constructor(List<? extends IConstructorInfo> constructors, IType ... params) {
            params = params == null ? EMPTY_TYPES : params;
            for (IConstructorInfo iConstructorInfo : constructors) {
                IParameterInfo[] paramInfos = iConstructorInfo.getParameters();
                if (!FIND.areParamsEqual(paramInfos, params)) continue;
                return iConstructorInfo;
            }
            return null;
        }

        public static IMethodInfo callableMethod(MethodList methods, CharSequence method, IType ... params) {
            return FIND.callableMethodImpl(methods, method, false, params);
        }

        public static IMethodInfo callableMethodStrict(MethodList methods, CharSequence method, IType ... params) {
            return FIND.callableMethodImpl(methods, method, true, params);
        }

        private static IMethodInfo callableMethodImpl(MethodList methodList, CharSequence method, boolean strict, IType ... params) {
            params = params == null ? EMPTY_TYPES : params;
            DynamicArray<? extends IMethodInfo> methods = methodList.getMethods(method.toString());
            if (methods.isEmpty()) {
                return null;
            }
            HashMap<FunctionType, IMethodInfo> mis = new HashMap<FunctionType, IMethodInfo>();
            for (int i = 0; i < methods.size; ++i) {
                IMethodInfo methodInfo = (IMethodInfo)methods.data[i];
                if (!methodInfo.getDisplayName().equals(method.toString()) || methodInfo.getParameters().length != params.length) continue;
                FunctionType funcType = new FunctionType(methodInfo);
                if (funcType.isGenericType()) {
                    funcType = funcType.getRuntimeType();
                }
                mis.put(funcType, methodInfo);
            }
            List<MethodScore> list = MethodScorer.instance().scoreMethods(new ArrayList<IInvocableType>(mis.keySet()), Arrays.asList(params));
            if (list.size() == 0) {
                return null;
            }
            if (list.size() > 1 && list.get(0).getScore() == list.get(1).getScore()) {
                throw new IllegalArgumentException("Ambiguous methods: There is more than one method named " + method + " that accepts args " + Arrays.asList(params));
            }
            IInvocableType rawFunctionType = list.get(0).getRawFunctionType();
            if (strict && !FIND.areParamsCompatible(rawFunctionType.getParameterTypes(), params)) {
                return null;
            }
            return (IMethodInfo)mis.get(rawFunctionType);
        }

        private static boolean areParamsCompatible(IType[] actualParamTypes, IType[] userParamTypes) {
            for (int i = 0; i < actualParamTypes.length; ++i) {
                IType actualParamType = actualParamTypes[i];
                IType userParamType = userParamTypes[i];
                if (actualParamType.isAssignableFrom(userParamType)) continue;
                return false;
            }
            return true;
        }

        public static IConstructorInfo callableConstructor(List<? extends IConstructorInfo> constructors, IType ... params) {
            return FIND.callableConstructorImpl(constructors, false, params);
        }

        public static IConstructorInfo callableConstructorStrict(List<? extends IConstructorInfo> constructors, IType ... params) {
            return FIND.callableConstructorImpl(constructors, true, params);
        }

        private static IConstructorInfo callableConstructorImpl(List<? extends IConstructorInfo> constructors, boolean strict, IType ... params) {
            HashMap<IConstructorType, IConstructorInfo> cis = new HashMap<IConstructorType, IConstructorInfo>();
            params = params == null ? EMPTY_TYPES : params;
            for (IConstructorInfo iConstructorInfo : constructors) {
                if (params.length != iConstructorInfo.getParameters().length) continue;
                cis.put(GosuShop.getConstructorInfoFactory().makeConstructorType(iConstructorInfo), iConstructorInfo);
            }
            List<MethodScore> list = MethodScorer.instance().scoreMethods(new ArrayList<IInvocableType>(cis.keySet()), Arrays.asList(params));
            if (list.size() == 0) {
                return null;
            }
            if (list.size() > 1 && list.get(0).getScore() == list.get(1).getScore()) {
                throw new IllegalArgumentException("Ambiguous constructors: There is more than one constructor that accepts args " + Arrays.asList(params));
            }
            IInvocableType iInvocableType = list.get(0).getRawFunctionType();
            if (strict && !FIND.areParamsCompatible(iInvocableType.getParameterTypes(), params)) {
                return null;
            }
            return (IConstructorInfo)cis.get(iInvocableType);
        }

        public static boolean areParamsEqual(IParameterInfo[] srcArgs, IType[] testArgs) {
            if (srcArgs.length == testArgs.length) {
                for (int j = 0; j < srcArgs.length; ++j) {
                    IType methodParamType = srcArgs[j].getFeatureType();
                    IType testParamType = testArgs[j];
                    while (methodParamType.isArray() && testParamType.isArray()) {
                        methodParamType = methodParamType.getComponentType();
                        testParamType = testParamType.getComponentType();
                    }
                    if (methodParamType.isParameterizedType() && !testParamType.isParameterizedType()) {
                        methodParamType = TypeSystem.getPureGenericType(methodParamType);
                    } else if (testParamType.isParameterizedType() && !methodParamType.isParameterizedType()) {
                        testParamType = TypeSystem.getPureGenericType(testParamType);
                    } else if (FIND.typeVarsAreFromDifferentMethods(methodParamType, testParamType)) {
                        methodParamType = FIND.getConcreteBoundingType(methodParamType);
                        testParamType = FIND.getConcreteBoundingType(testParamType);
                    }
                    if (methodParamType.isParameterizedType()) {
                        if (!TypeSystem.getPureGenericType(methodParamType).equals(TypeSystem.getPureGenericType(testParamType))) {
                            return false;
                        }
                        IType[] methodTypeParameters = methodParamType.getTypeParameters();
                        IType[] testTypeParameters = testParamType.getTypeParameters();
                        for (int i = 0; i < methodTypeParameters.length; ++i) {
                            if (FIND.getConcreteBoundingType(methodTypeParameters[i]).isAssignableFrom(testTypeParameters[i])) continue;
                            return false;
                        }
                        continue;
                    }
                    if (methodParamType.equals(testParamType)) continue;
                    return methodParamType instanceof IPlaceholder && ((IPlaceholder)((Object)methodParamType)).isPlaceholder() || testParamType instanceof IPlaceholder && ((IPlaceholder)((Object)testParamType)).isPlaceholder();
                }
                return true;
            }
            return false;
        }

        private static boolean typeVarsAreFromDifferentMethods(IType methodParamType, IType testParamType) {
            if (methodParamType instanceof ITypeVariableArrayType && testParamType instanceof ITypeVariableArrayType) {
                return FIND.typeVarsAreFromDifferentMethods(methodParamType.getComponentType(), testParamType.getComponentType());
            }
            return testParamType instanceof ITypeVariableType && testParamType.getEnclosingType() instanceof FunctionType && methodParamType instanceof ITypeVariableType && methodParamType.getEnclosingType() instanceof FunctionType && testParamType.getEnclosingType() != methodParamType.getEnclosingType();
        }

        private static IType getConcreteBoundingType(IType type) {
            if (type instanceof ITypeVariableType) {
                return FIND.getConcreteBoundingType(((ITypeVariableType)type).getBoundingType());
            }
            if (type instanceof ITypeVariableArrayType) {
                return FIND.getConcreteBoundingType(type.getComponentType());
            }
            return type;
        }
    }
}

