/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IExpression;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.IParseResult;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ParserOptions;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IProgramInstance;

public interface IGosuProgram
extends IGosuClass {
    public static final String NAME_PREFIX = "__Program__";
    public static final String PACKAGE = "program_";
    public static final String PACKAGE_PLUS_DOT = "program_.";

    public boolean isExpression();

    public boolean isLhsExpression();

    public IExpression getExpression();

    public IStatement getStatement();

    public IParsedElement getEnclosingEvalExpression();

    public void setEnclosingEvalExpression(IParsedElement var1);

    public Object evaluate(IExternalSymbolMap var1);

    public Object evaluateRoot(IExternalSymbolMap var1);

    public void assign(Object var1);

    public IType getReturnType();

    public IType getExpectedReturnType();

    public IProgramInstance getProgramInstance();

    public IType getContextType();

    public static class Runner {
        public static Object runProgram(String strProgram) throws Exception {
            return Runner.runProgram(strProgram, null, null);
        }

        public static Object runProgram(String strProgram, ISymbolTable symTable, IType expectedType) throws Exception {
            IProgramInstance instance = Runner.getProgramInstance(strProgram, symTable, expectedType);
            return instance.evaluate(null);
        }

        public static IProgramInstance getProgramInstance(String strProgram) throws Exception {
            return Runner.getProgramInstance(strProgram, null, null);
        }

        public static IProgramInstance getProgramInstance(String strProgram, ISymbolTable symTable) throws Exception {
            return Runner.getProgramInstance(strProgram, symTable, null);
        }

        public static IProgramInstance getProgramInstance(String strProgram, ISymbolTable symTable, IType expectedType) throws Exception {
            IGosuProgramParser pcp = GosuParserFactory.createProgramParser();
            IParseResult res = pcp.parseProgramOnly(strProgram, symTable, new ParserOptions().withExpectedType(expectedType));
            IGosuProgram gp = res.getProgram();
            if (!gp.isValid()) {
                throw gp.getParseResultsException();
            }
            Class javaClass = gp.getBackingClass();
            return (IProgramInstance)javaClass.newInstance();
        }
    }
}

