/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.interval;

import gw.lang.reflect.interval.DateUnit;
import gw.lang.reflect.interval.IterableInterval;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DateInterval
extends IterableInterval<Date, Integer, DateUnit, DateInterval> {
    public DateInterval(Date left, Date right, Integer step, DateUnit unit) {
        this(left, right, step, unit, true, true, false);
    }

    public DateInterval(Date left, Date right, int iStep, DateUnit unit, boolean bLeftClosed, boolean bRightClosed, boolean bReverse) {
        super(left, right, iStep, unit == null ? DateUnit.DAYS : unit, bLeftClosed, bRightClosed, bReverse);
    }

    @Override
    public Iterator<Date> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<Date> iterateFromRight() {
        return new ReverseIterator();
    }

    private Date add(Date date) {
        return this.add(date, 1);
    }

    private Date add(Date date, int iMultiple) {
        Calendar dateTime = Calendar.getInstance();
        dateTime.setTime(date);
        dateTime.add(((DateUnit)((Object)this.getUnit())).getCalendarConst(), (Integer)this.getStep() * iMultiple);
        return dateTime.getTime();
    }

    private Date subtract(Date date) {
        return this.subtract(date, 1);
    }

    private Date subtract(Date date, int iMultiple) {
        Calendar dateTime = Calendar.getInstance();
        dateTime.setTime(date);
        dateTime.add(((DateUnit)((Object)this.getUnit())).getCalendarConst(), -((Integer)this.getStep() * iMultiple));
        return dateTime.getTime();
    }

    @Override
    public Date getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        Date date = this.add((Date)this.getLeftEndpoint(), this.isLeftClosed() ? iStepIndex : iStepIndex + 1);
        int iComp = date.compareTo((Date)this.getRightEndpoint());
        if (this.isRightClosed() ? iComp <= 0 : iComp < 0) {
            return date;
        }
        return null;
    }

    @Override
    public Date getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        Date date = this.subtract((Date)this.getRightEndpoint(), this.isRightClosed() ? iStepIndex : iStepIndex + 1);
        int iComp = date.compareTo((Date)this.getLeftEndpoint());
        if (this.isLeftClosed() ? iComp >= 0 : iComp > 0) {
            return date;
        }
        return null;
    }

    private class ReverseIterator
    implements Iterator<Date> {
        private Date _csr;

        public ReverseIterator() {
            this._csr = (Date)DateInterval.this.getRightEndpoint();
            if (!DateInterval.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int iComp = this._csr.compareTo((Date)DateInterval.this.getLeftEndpoint());
            return iComp > 0 || DateInterval.this.isLeftClosed() && iComp == 0;
        }

        @Override
        public Date next() {
            int iComp = this._csr.compareTo((Date)DateInterval.this.getLeftEndpoint());
            if (iComp < 0 || !DateInterval.this.isLeftClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            Date iRet = this._csr;
            this._csr = DateInterval.this.subtract(this._csr);
            return iRet;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ForwardIterator
    implements Iterator<Date> {
        private Date _iCsr;

        public ForwardIterator() {
            this._iCsr = (Date)DateInterval.this.getLeftEndpoint();
            if (!DateInterval.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            int iComp = this._iCsr.compareTo((Date)DateInterval.this.getRightEndpoint());
            return iComp < 0 || DateInterval.this.isRightClosed() && iComp == 0;
        }

        @Override
        public Date next() {
            int iComp = this._iCsr.compareTo((Date)DateInterval.this.getRightEndpoint());
            if (iComp > 0 || !DateInterval.this.isRightClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            Date date = this._iCsr;
            this._iCsr = DateInterval.this.add(this._iCsr);
            return date;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

