/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.ir.statement;

import gw.lang.UnstableAPI;
import gw.lang.ir.IRStatement;
import gw.lang.ir.statement.IRTerminalStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UnstableAPI
public class IRStatementList
extends IRStatement {
    private List<IRStatement> _statements;
    private boolean _hasScope = true;

    public IRStatementList(boolean hasScope, IRStatement ... statements) {
        this._hasScope = hasScope;
        this._statements = new ArrayList<IRStatement>();
        this._statements.addAll(Arrays.asList(statements));
        for (IRStatement statement : statements) {
            statement.setParent(this);
        }
    }

    public IRStatementList(boolean hasScope, List<IRStatement> statements) {
        this._hasScope = hasScope;
        this._statements = statements;
        for (IRStatement statement : statements) {
            if (statement == null) continue;
            statement.setParent(this);
        }
    }

    public void addStatement(IRStatement statement) {
        this._statements.add(statement);
        statement.setParent(this);
    }

    public List<IRStatement> getStatements() {
        return this._statements;
    }

    @Override
    public IRTerminalStatement getLeastSignificantTerminalStatement() {
        for (int i = 0; i < this._statements.size(); ++i) {
            IRTerminalStatement terminalStmt;
            if (this._statements.get(i) == null || (terminalStmt = this._statements.get(i).getLeastSignificantTerminalStatement()) == null) continue;
            return terminalStmt;
        }
        return null;
    }

    public void mergeStatements(IRStatement irStatement) {
        if (irStatement instanceof IRStatementList) {
            for (IRStatement statement : ((IRStatementList)irStatement).getStatements()) {
                this.addStatement(statement);
            }
        } else {
            this.addStatement(irStatement);
        }
    }

    public boolean hasScope() {
        return this._hasScope;
    }
}

