/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.parser.coercers;

import gw.lang.GosuShop;
import gw.lang.function.IBlock;
import gw.lang.parser.IResolvingCoercer;
import gw.lang.parser.coercers.BaseCoercer;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.features.IMethodReference;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class FunctionToInterfaceCoercer
extends BaseCoercer
implements IResolvingCoercer {
    private static FunctionToInterfaceCoercer _instance = new FunctionToInterfaceCoercer();

    public static FunctionToInterfaceCoercer instance() {
        return _instance;
    }

    private FunctionToInterfaceCoercer() {
    }

    @Override
    public Object coerceValue(IType typeToCoerceTo, Object value) {
        if (value instanceof IMethodReference) {
            return this.coerceValue(typeToCoerceTo, ((IMethodReference)value).toBlock());
        }
        if (value instanceof IBlock) {
            IGosuClass proxyClass = GosuShop.getBlockToInterfaceConversionClass(typeToCoerceTo, TypeSystem.get(value.getClass().getEnclosingClass()));
            IBlock blk = (IBlock)value;
            try {
                return proxyClass.getBackingClass().getConstructor(IBlock.class).newInstance(blk);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException();
    }

    public static IFunctionType getRepresentativeFunctionType(IType interfaceType) {
        IMethodInfo javaMethodInfo = FunctionToInterfaceCoercer.getSingleMethod(interfaceType);
        if (javaMethodInfo != null) {
            return GosuShop.createFunctionType(javaMethodInfo);
        }
        return null;
    }

    public static IMethodInfo getSingleMethod(IType interfaceType) {
        if (interfaceType.isInterface() && (interfaceType instanceof IJavaType || interfaceType instanceof IGosuClass)) {
            IMethodInfo mi;
            ArrayList<IMethodInfo> list = new ArrayList<IMethodInfo>(interfaceType.getTypeInfo().getMethods());
            ITypeInfo objTypeInfo = JavaTypes.OBJECT().getTypeInfo();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                IMethodInfo methodInfo = (IMethodInfo)it.next();
                IParameterInfo[] parameterInfos = methodInfo.getParameters();
                IType[] paramTypes = new IType[parameterInfos.length];
                for (int i = 0; i < parameterInfos.length; ++i) {
                    paramTypes[i] = parameterInfos[i].getFeatureType();
                }
                if (objTypeInfo.getMethod(methodInfo.getDisplayName(), paramTypes) != null || methodInfo.getOwnersType() instanceof IGosuEnhancement) {
                    it.remove();
                    continue;
                }
                if (methodInfo.getOwnersType().getName().contains(IGosuObject.class.getName())) {
                    it.remove();
                    continue;
                }
                if (methodInfo.isAbstract()) continue;
                it.remove();
            }
            if (list.size() == 1 && ((mi = (IMethodInfo)list.get(0)) instanceof IJavaMethodInfo || mi instanceof IGosuMethodInfo)) {
                return mi;
            }
        }
        return null;
    }

    public static IJavaClassMethod getSingleMethodFromJavaInterface(IJavaType interfaceType) {
        if (!interfaceType.isInterface()) {
            return null;
        }
        ArrayList<IJavaClassMethod> list = new ArrayList<IJavaClassMethod>(Arrays.asList(interfaceType.getBackingClassInfo().getDeclaredMethods()));
        IJavaClassInfo objTypeInfo = JavaTypes.OBJECT().getBackingClassInfo();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            IJavaClassMethod method = (IJavaClassMethod)it.next();
            IJavaClassInfo[] paramTypes = method.getParameterTypes();
            if (FunctionToInterfaceCoercer.hasMethod(objTypeInfo, method.getName(), paramTypes)) {
                it.remove();
                continue;
            }
            if (Modifier.isAbstract(method.getModifiers())) continue;
            it.remove();
        }
        if (list.size() == 1) {
            return (IJavaClassMethod)list.get(0);
        }
        return null;
    }

    private static boolean hasMethod(IJavaClassInfo jci, String name, IJavaClassInfo[] params) {
        block0: for (IJavaClassMethod method : jci.getDeclaredMethods()) {
            IJavaClassInfo[] methodParamTypes;
            if (!method.getName().equals(name) || params.length != (methodParamTypes = method.getParameterTypes()).length) continue;
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].equals(methodParamTypes[i])) continue block0;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isExplicitCoercion() {
        return false;
    }

    @Override
    public boolean handlesNull() {
        return false;
    }

    @Override
    public int getPriority(IType to, IType from) {
        return 2;
    }

    @Override
    public IType resolveType(IType target, IType source) {
        if (TypeSystem.get(IMethodReference.class).isAssignableFrom(source)) {
            return this.resolveType(target, source.getTypeParameters()[1]);
        }
        IFunctionType sourceFun = (IFunctionType)source;
        IType returnType = sourceFun.getReturnType();
        IType methodReturnType = this.extractReturnTypeFromInterface(target);
        if (methodReturnType instanceof ITypeVariableType) {
            IType[] paramTypes = target.getTypeParameters();
            IType[] parameterizationTypes = new IType[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                IType param = paramTypes[i];
                parameterizationTypes[i] = param instanceof ITypeVariableType && param.getName().equals(methodReturnType.getName()) ? returnType : target.getTypeParameters()[i];
            }
            return target.getParameterizedType(parameterizationTypes);
        }
        return target;
    }

    private IType extractReturnTypeFromInterface(IType target) {
        IFunctionType funcType = FunctionToInterfaceCoercer.getRepresentativeFunctionType(target);
        return funcType == null ? null : funcType.getReturnType();
    }
}

