/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.AbstractType;
import gw.lang.reflect.DefaultArrayTypeInfo;
import gw.lang.reflect.IDefaultArrayType;
import gw.lang.reflect.IHasJavaClass;
import gw.lang.reflect.INonLoadableType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.concurrent.LocklessLazyVar;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultArrayType
extends AbstractType
implements IDefaultArrayType,
IHasJavaClass {
    public static final LocklessLazyVar<List<IJavaType>> INTERFACES = new LocklessLazyVar<List<IJavaType>>(){

        @Override
        protected List<IJavaType> init() {
            return Arrays.asList(JavaTypes.getJreType(Cloneable.class), JavaTypes.getJreType(Serializable.class));
        }
    };
    private IType _componentType;
    private transient ITypeLoader _typeLoader;
    private transient ITypeInfo _typeInfo;
    private transient Set _allTypesInHierarchy;
    private transient IDefaultArrayType _arrayIntrinsicType;
    private transient IJavaClassInfo _concreteClass;
    private transient boolean _bDiscarded;
    private String _name;

    public DefaultArrayType(IType componentType, IJavaClassInfo componentConcreteClass, ITypeLoader typeLoader) {
        this._componentType = componentType;
        this._typeLoader = typeLoader;
        this._concreteClass = componentConcreteClass == null ? null : componentConcreteClass.getArrayType();
        this._name = this._componentType.getName() + "[]";
        assert (componentType instanceof INonLoadableType == this instanceof INonLoadableType) : "The loadability of component type of a DefaultArrayType must agree with the loadability of this type.  \nIf " + componentType.getClass().getName() + " is non loadable, its type must use DefaultNonLoadableArrayType as its array type.";
    }

    @Override
    public final IType getComponentType() {
        return this._componentType;
    }

    @Override
    public final String getRelativeName() {
        return this._componentType.getRelativeName() + "[]";
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public final Object readResolve() {
        return TypeSystem.getByFullName(this.getName());
    }

    @Override
    public final boolean isValid() {
        return true;
    }

    @Override
    public int getModifiers() {
        return this._componentType.getModifiers();
    }

    @Override
    public final boolean isAbstract() {
        return false;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final String getDisplayName() {
        return this.getName();
    }

    @Override
    public final String getNamespace() {
        return this._componentType.getNamespace();
    }

    @Override
    public final ITypeLoader getTypeLoader() {
        return this._typeLoader;
    }

    @Override
    public final IType getSupertype() {
        return null;
    }

    @Override
    public final IType getEnclosingType() {
        return null;
    }

    @Override
    public final IType getGenericType() {
        return null;
    }

    @Override
    public final boolean isFinal() {
        return false;
    }

    @Override
    public final boolean isInterface() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public final IType[] getInterfaces() {
        return EMPTY_TYPE_ARRAY;
    }

    @Override
    public final boolean isParameterizedType() {
        return false;
    }

    @Override
    public final boolean isGenericType() {
        return false;
    }

    @Override
    public final IGenericTypeVariable[] getGenericTypeVariables() {
        return null;
    }

    @Override
    public final IType[] getTypeParameters() {
        return null;
    }

    @Override
    public final IType getParameterizedType(IType ... ofType) {
        throw new UnsupportedOperationException(this.getName() + " does not support parameterization.");
    }

    public final Set getAllTypesInHierarchy() {
        if (this._allTypesInHierarchy == null) {
            HashSet<IType> allTypes = new HashSet<IType>();
            allTypes.add(JavaTypes.OBJECT());
            for (IType iType : this._componentType.getAllTypesInHierarchy()) {
                allTypes.add(iType.getArrayType());
            }
            if (this._concreteClass != null) {
                Set<? extends IType> allTypesInHierarchy = this._componentType.getAllTypesInHierarchy();
                for (IType iType : allTypesInHierarchy) {
                    if (!(iType instanceof IJavaType)) continue;
                    allTypes.add(iType.getArrayType());
                }
            }
            allTypes.addAll((Collection)INTERFACES.get());
            this._allTypesInHierarchy = allTypes;
        }
        return this._allTypesInHierarchy;
    }

    @Override
    public final boolean isPrimitive() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IDefaultArrayType getArrayType() {
        if (this._arrayIntrinsicType == null) {
            DefaultArrayType defaultArrayType = this;
            synchronized (defaultArrayType) {
                if (this._arrayIntrinsicType == null) {
                    IDefaultArrayType arrayIntrinsicType;
                    this._arrayIntrinsicType = arrayIntrinsicType = this.makeArrayType();
                }
            }
        }
        return this._arrayIntrinsicType;
    }

    protected IDefaultArrayType makeArrayType() {
        return new DefaultArrayType(this.getThisRef(), this.getConcreteClass(), this._typeLoader).getThisRef();
    }

    @Override
    public Object makeArrayInstance(int iLength) {
        return Array.newInstance(this.getConcreteClass().getBackingClass(), iLength);
    }

    @Override
    public IJavaClassInfo getConcreteClass() {
        return this._concreteClass;
    }

    @Override
    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return Array.get(array, iIndex);
    }

    @Override
    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Array.set(array, iIndex, value);
    }

    @Override
    public int getArrayLength(Object array) throws IllegalArgumentException {
        return Array.getLength(array);
    }

    @Override
    public boolean isAssignableFrom(IType type) {
        return type.getAllTypesInHierarchy().contains(this.getThisRef()) || type.isArray() && type.getClass().isInstance(this.getThisRef()) && this.getComponentType().isAssignableFrom(type.getComponentType());
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public final ITypeInfo getTypeInfo() {
        if (this._typeInfo == null) {
            this._typeInfo = new DefaultArrayTypeInfo(this.getThisRef());
        }
        return this._typeInfo;
    }

    @Override
    public final void unloadTypeInfo() {
        this._typeInfo = null;
        if (this._arrayIntrinsicType != null) {
            this._arrayIntrinsicType.unloadTypeInfo();
        }
    }

    public String toString() {
        return this.getComponentType().toString() + "[]";
    }

    public IDefaultArrayType getThisRef() {
        IType compType = this;
        while ((compType = compType.getComponentType()).isArray()) {
        }
        return compType instanceof INonLoadableType || compType instanceof IJavaType ? this : (IDefaultArrayType)((Object)TypeSystem.getOrCreateTypeReference(this));
    }

    @Override
    public boolean isDiscarded() {
        return this._bDiscarded;
    }

    @Override
    public void setDiscarded(boolean bDiscarded) {
        this._bDiscarded = bDiscarded;
    }

    @Override
    public boolean isCompoundType() {
        return false;
    }

    @Override
    public Set<IType> getCompoundTypeComponents() {
        return null;
    }

    @Override
    public Class getBackingClass() {
        return this.getConcreteClass().getBackingClass();
    }
}

