/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.util.CiHashMap;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveSet<T extends CharSequence>
extends AbstractSet<T>
implements Set<T>,
Serializable {
    private final Map<T, Object> _map;
    private static final Object MARKER = new Serializable(){};

    public CaseInsensitiveSet() {
        this._map = new CiHashMap<T, Object>();
    }

    public CaseInsensitiveSet(Collection<? extends T> c) {
        this();
        this.addAll(c);
    }

    public CaseInsensitiveSet(T[] stringArray) {
        this(Arrays.asList(stringArray));
    }

    public CaseInsensitiveSet(int initialCapacity) {
        this._map = new CiHashMap<T, Object>(initialCapacity);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this._map.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public boolean add(T o) {
        return this._map.put(o, MARKER) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this._map.remove(o) == MARKER;
    }

    @Override
    public void clear() {
        this._map.clear();
    }
}

