/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PromotableReadWriteLock
implements Lock {
    private ReentrantReadWriteLock _rwlock = new ReentrantReadWriteLock(false);
    private ThreadLocal<State> _statePerThread = new ThreadLocal();

    public void lockRead() {
        this._rwlock.readLock().lock();
        State state = this.getState();
        if (!state.isWriteLocked()) {
            state.incReadCount();
        }
    }

    public void unlockRead() {
        this._rwlock.readLock().unlock();
        State state = this.getState();
        if (!state.isWriteLocked()) {
            state.decReadCount();
        }
    }

    public void lockWrite() {
        this.releaseReadLocks();
        this._rwlock.writeLock().lock();
        this.getState().incWriteCount();
    }

    public void unlockWrite() {
        this.reacquireReadLocks();
        this._rwlock.writeLock().unlock();
        this.getState().decWriteCount();
    }

    private State getState() {
        State state = this._statePerThread.get();
        if (state == null) {
            state = new State();
            this._statePerThread.set(state);
        }
        return state;
    }

    protected void releaseReadLocks() {
        State state = this.getState();
        if (state.isWriteLocked()) {
            return;
        }
        int iCount = state.getReadCount();
        for (int i = 0; i < iCount; ++i) {
            this._rwlock.readLock().unlock();
        }
    }

    protected void reacquireReadLocks() {
        State state = this.getState();
        if (state.isWriteLockedMoreThanOnce()) {
            return;
        }
        int iCount = state.getReadCount();
        for (int i = 0; i < iCount; ++i) {
            this._rwlock.readLock().lock();
        }
    }

    @Override
    public void lock() {
        this.lockWrite();
    }

    @Override
    public void unlock() {
        this.unlockWrite();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryLock() {
        this.releaseReadLocks();
        if (this._rwlock.writeLock().tryLock()) {
            this.getState().incWriteCount();
            return true;
        }
        this.reacquireReadLocks();
        return false;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        this.releaseReadLocks();
        if (this._rwlock.writeLock().tryLock(time, unit)) {
            this.getState().incWriteCount();
            return true;
        }
        this.reacquireReadLocks();
        return false;
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    static class State {
        private int _iReadCount;
        private int _iWriteCount;

        State() {
        }

        public int getReadCount() {
            return this._iReadCount;
        }

        public void incReadCount() {
            ++this._iReadCount;
        }

        public void decReadCount() {
            --this._iReadCount;
            if (this._iReadCount < 0) {
                throw new IllegalStateException();
            }
        }

        public boolean isWriteLocked() {
            return this._iWriteCount > 0;
        }

        public boolean isWriteLockedMoreThanOnce() {
            return this._iWriteCount > 1;
        }

        public void incWriteCount() {
            ++this._iWriteCount;
        }

        public void decWriteCount() {
            --this._iWriteCount;
        }
    }
}

