/*
 * Decompiled with CFR 0.152.
 */
package gw.util.cache;

import gw.util.Predicate;
import gw.util.cache.FqnCache;
import gw.util.cache.FqnCacheNode;
import gw.util.cache.IFqnCache;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public class WeakFqnCache<T>
implements IFqnCache<T> {
    private FqnCache<WeakReference<T>> _cache = new FqnCache();
    private ReferenceQueue<T> _queue = new ReferenceQueue();

    @Override
    public void add(String fqn) {
        this.add(fqn, null);
    }

    @Override
    public void add(String fqn, T userData) {
        KeyedReference<T> ref = new KeyedReference<T>(fqn, userData, this._queue);
        this._cache.add(fqn, ref);
    }

    @Override
    public boolean remove(String fqn) {
        return this._remove(fqn);
    }

    private boolean _remove(String fqn) {
        return this._cache.remove(fqn);
    }

    @Override
    public T get(String fqn) {
        WeakReference<T> ref = this._cache.get(fqn);
        return ref == null ? null : (T)ref.get();
    }

    @Override
    public FqnCacheNode<WeakReference<T>> getNode(String fqn) {
        return this._cache.getNode(fqn);
    }

    @Override
    public boolean contains(String fqn) {
        return this._cache.contains(fqn);
    }

    @Override
    public void remove(String[] fqns) {
        this._cache.remove(fqns);
    }

    @Override
    public void clear() {
        this._cache.clear();
    }

    @Override
    public Set<String> getFqns() {
        return this._cache.getFqns();
    }

    @Override
    public void visitDepthFirst(final Predicate<T> visitor) {
        Predicate delegate = new Predicate<WeakReference<T>>(){

            @Override
            public boolean evaluate(WeakReference<T> node) {
                Object userData = node == null ? null : (Object)node.get();
                return visitor.evaluate(userData);
            }
        };
        ArrayList<FqnCacheNode<WeakReference<T>>> copy = new ArrayList<FqnCacheNode<WeakReference<T>>>(this._cache.getRoot().getChildren());
        for (FqnCacheNode fqnCacheNode : copy) {
            if (fqnCacheNode.visitDepthFirst(delegate)) continue;
            return;
        }
    }

    @Override
    public void visitNodeDepthFirst(Predicate<FqnCacheNode> visitor) {
        ArrayList<FqnCacheNode<WeakReference<T>>> copy = new ArrayList<FqnCacheNode<WeakReference<T>>>(this._cache.getRoot().getChildren());
        for (FqnCacheNode fqnCacheNode : copy) {
            if (fqnCacheNode.visitNodeDepthFirst(visitor)) continue;
            return;
        }
    }

    @Override
    public void visitBreadthFirst(final Predicate<T> visitor) {
        Predicate delegate = new Predicate<WeakReference<T>>(){

            @Override
            public boolean evaluate(WeakReference<T> node) {
                Object userData = node == null ? null : (Object)node.get();
                return visitor.evaluate(userData);
            }
        };
        ArrayList<FqnCacheNode<WeakReference<T>>> copy = new ArrayList<FqnCacheNode<WeakReference<T>>>(this._cache.getRoot().getChildren());
        for (FqnCacheNode fqnCacheNode : copy) {
            fqnCacheNode.visitBreadthFirst(delegate);
        }
    }

    private static class KeyedReference<T>
    extends WeakReference<T> {
        private String _fqn;

        public KeyedReference(String fqn, T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
            this._fqn = fqn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyedReference that = (KeyedReference)o;
            return this._fqn.equals(that._fqn) && this.equal(this.get(), that.get());
        }

        private <T> boolean equal(T p1, T p2) {
            if (p1 == null || p2 == null) {
                return p1 == p2;
            }
            if (p1 instanceof Object[] && p2 instanceof Object[]) {
                Object[] arr1 = (Object[])p1;
                Object[] arr2 = (Object[])p2;
                return Arrays.equals(arr1, arr2);
            }
            return p1.equals(p2);
        }

        public int hashCode() {
            return this._fqn.hashCode();
        }
    }
}

