/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.init;

import gw.lang.UnstableAPI;
import gw.lang.gosuc.GosucModule;
import gw.lang.init.GosuPathEntry;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IModule;
import gw.util.GosuExceptionUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

@UnstableAPI
public class GosuInitialization {
    private static final Map<IExecutionEnvironment, GosuInitialization> INSTANCES = new WeakHashMap<IExecutionEnvironment, GosuInitialization>();
    private IExecutionEnvironment _execEnv;
    private boolean _initialized;

    public static GosuInitialization instance(IExecutionEnvironment execEnv) {
        GosuInitialization gi = INSTANCES.get(execEnv);
        if (gi == null) {
            gi = new GosuInitialization(execEnv);
            INSTANCES.put(execEnv, gi);
        }
        return gi;
    }

    public static boolean isAnythingInitialized() {
        return !INSTANCES.isEmpty();
    }

    private GosuInitialization(IExecutionEnvironment execEnv) {
        this._execEnv = execEnv;
        this._initialized = false;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void uninitializeRuntime() {
        if (!this._initialized) {
            return;
        }
        this._initialized = false;
        try {
            Class<?> cls = Class.forName("gw.internal.gosu.init.InternalGosuInit");
            Method m = cls.getMethod("uninitializeRuntime", IExecutionEnvironment.class);
            m.invoke(null, this._execEnv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initializeRuntime(List<GosuPathEntry> pathEntries) {
        if (this._initialized) {
            throw new IllegalStateException("Illegal attempt to re-initialize Gosu");
        }
        this.callMethod("initializeRuntime", pathEntries);
        this._initialized = true;
    }

    public void initializeCompiler(GosucModule module) {
        if (this._initialized) {
            throw new IllegalStateException("Illegal attempt to re-initialize Gosu");
        }
        try {
            Class<?> cls = Class.forName("gw.internal.gosu.init.InternalGosuInit");
            Method m = cls.getMethod("initializeCompiler", IExecutionEnvironment.class, GosucModule.class);
            m.invoke(null, this._execEnv, module);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow(e);
        }
        this._initialized = true;
    }

    public void uninitializeCompiler() {
        if (!this._initialized) {
            throw new IllegalStateException("Illegal attempt to uninitialize Gosu");
        }
        try {
            Class<?> cls = Class.forName("gw.internal.gosu.init.InternalGosuInit");
            Method m = cls.getMethod("uninitializeCompiler", IExecutionEnvironment.class);
            m.invoke(null, this._execEnv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._initialized = false;
    }

    public void reinitializeRuntime(List<GosuPathEntry> pathEntries) {
        if (this._initialized) {
            this.uninitializeRuntime();
            this.callMethod("reinitializeRuntime", pathEntries);
        } else {
            this.callMethod("initializeRuntime", pathEntries);
        }
        this._initialized = true;
    }

    public void initializeMultipleModules(List<? extends IModule> modules) {
        if (this._initialized) {
            throw new IllegalStateException("Illegal attempt to initialize Gosu");
        }
        try {
            Class<?> cls = Class.forName("gw.internal.gosu.init.InternalGosuInit");
            Method m = cls.getMethod("initializeMultipleModules", IExecutionEnvironment.class, List.class);
            m.invoke(null, this._execEnv, modules);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._initialized = true;
    }

    public void uninitializeMultipleModules() {
        if (!this._initialized) {
            throw new IllegalStateException("Illegal attempt to uninitialize Gosu");
        }
        try {
            Class<?> cls = Class.forName("gw.internal.gosu.init.InternalGosuInit");
            Method m = cls.getMethod("uninitializeMultipleModules", IExecutionEnvironment.class);
            m.invoke(null, this._execEnv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._initialized = true;
    }

    private void callMethod(String methodName, List<GosuPathEntry> pathEntries) {
        try {
            Class<?> cls = Class.forName("gw.internal.gosu.init.InternalGosuInit");
            Method m = cls.getMethod(methodName, IExecutionEnvironment.class, List.class);
            m.invoke(null, this._execEnv, pathEntries);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow(e);
        }
    }
}

