/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.gs;

import gw.internal.gosu.parser.IParameterizableType;
import gw.lang.parser.ICompilationState;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IDynamicPropertySymbol;
import gw.lang.parser.IHasInnerClass;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.reflect.ICanBeAnnotation;
import gw.lang.reflect.IEnhanceableType;
import gw.lang.reflect.IEnumType;
import gw.lang.reflect.IFileBasedType;
import gw.lang.reflect.IHasJavaClass;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IModifierInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGosuClassTypeInfo;
import gw.lang.reflect.java.IJavaType;
import java.util.List;
import java.util.Map;

public interface IGosuClass
extends IFileBasedType,
ICompilableType,
IEnumType,
IEnhanceableType,
Comparable,
IHasInnerClass,
IHasJavaClass,
IParameterizableType,
ICanBeAnnotation {
    public static final String PROXY_PREFIX = "_proxy_";
    public static final String SUPER_PROXY_CLASS_PREFIX = "_java_";
    public static final String ANONYMOUS_PREFIX = "AnonymouS_";

    @Override
    public IGosuClassTypeInfo getTypeInfo();

    public IModifierInfo getModifierInfo();

    public boolean isSubClass(IType var1);

    public boolean isStructure();

    public boolean isCompiled();

    @Override
    public IGosuClass getInnerClass(CharSequence var1);

    public List<? extends IGosuClass> getInnerClasses();

    public Map<CharSequence, ? extends IGosuClass> getInnerClassesMap();

    public IClassStatement getClassStatementWithoutCompile();

    public ICompilationState getCompilationState();

    public boolean isCompilingHeader();

    public boolean isHeaderCompiled();

    public boolean isCompilingDeclarations();

    public boolean isDeclarationsCompiled();

    public boolean isDeclarationsBypassed();

    public boolean isInnerDeclarationsCompiled();

    public boolean isCompilingDefinitions();

    public boolean isDefinitionsCompiled();

    public boolean isTestClass();

    public boolean hasError();

    public boolean hasWarnings();

    public ParseResultsException getParseResultsException();

    public List<? extends IVarStatement> getMemberFields();

    public List<? extends IDynamicFunctionSymbol> getMemberFunctions();

    public Map<String, ? extends IVarStatement> getMemberFieldsMap();

    public IDynamicPropertySymbol getMemberProperty(String var1);

    public IType getEnclosingTypeReference();

    public IFunctionStatement getFunctionStatement(IMethodInfo var1);

    public IJavaType getJavaType();

    public List<? extends IType> getSubtypes();

    public void setEnclosingType(IType var1);

    public void setNamespace(String var1);

    public boolean shouldKeepDebugInfo();

    public void setCreateEditorParser(boolean var1);

    public void unloadBackingClass();

    public boolean hasBackingClass();

    public IType findProxiedClassInHierarchy();

    public Map<CharSequence, ? extends IGosuClass> getKnownInnerClassesWithoutCompiling();

    public List<IGosuClass> getBlocks();

    public void validateAncestry(List<IType> var1);

    public String getSource();

    public long getSourceFingerprint();

    public static class ProxyUtil {
        public static boolean isProxy(IType type) {
            return type != null && ProxyUtil.isProxyClass(type.getName());
        }

        public static boolean isProxyClass(String strName) {
            return strName != null && strName.length() > IGosuClass.PROXY_PREFIX.length() && strName.startsWith(IGosuClass.PROXY_PREFIX);
        }

        public static boolean isProxyStart(String strName) {
            return strName != null && strName.length() >= IGosuClass.PROXY_PREFIX.length() && strName.startsWith(IGosuClass.PROXY_PREFIX);
        }

        public static IType getProxiedType(IType type) {
            while (type.isParameterizedType()) {
                type = type.getGenericType();
            }
            if (ProxyUtil.isProxy(type)) {
                return TypeSystem.getByFullName(ProxyUtil.getNameSansProxy(type));
            }
            return type;
        }

        public static String getNameSansProxy(IType type) {
            return ProxyUtil.getNameSansProxy(type.getName());
        }

        public static String getNameSansProxy(String name) {
            if (ProxyUtil.isProxyName(name)) {
                return name.substring(IGosuClass.PROXY_PREFIX.length() + 1);
            }
            return name;
        }

        private static boolean isProxyName(String name) {
            return name.startsWith(IGosuClass.PROXY_PREFIX) && name.length() > IGosuClass.PROXY_PREFIX.length() + 1;
        }
    }
}

