/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import gw.lang.parser.CICS;
import gw.util.GosuObjectUtil;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CiHashMap<K extends CharSequence, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final int NULL_KEY_HASH_CODE = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int MAX_TABLE_SIZE = 0x40000000;
    private int _size;
    private Entry<K, V>[] _table;
    private int _resizeThreshold;
    private float _loadFactor;
    private int _modCount;

    public CiHashMap() {
        this(16);
    }

    public CiHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CiHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = this.findNearestPowerOfTwo(initialCapacity);
        this._table = new Entry[initialCapacity];
        this._resizeThreshold = (int)((float)initialCapacity * loadFactor);
        this._loadFactor = loadFactor;
        this._size = 0;
    }

    private int findNearestPowerOfTwo(int i) {
        int result;
        if (i > 0x40000000) {
            return 0x40000000;
        }
        for (result = 1; result < i; result <<= 1) {
        }
        return result;
    }

    public CiHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        super.putAllImpl(m, false);
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> entry = this.findEntry(key, CiHashMap.hash(key));
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findEntry(key, CiHashMap.hash(key)) != null;
    }

    private Entry<K, V> findEntry(Object key, int hash) {
        for (Entry<K, V> entry = this._table[this.bucketNumber(hash)]; entry != null; entry = entry.getNext()) {
            if (!this.entryMatches(key, hash, entry)) continue;
            return entry;
        }
        return null;
    }

    private boolean entryMatches(Object key, int hash, Entry<K, V> entry) {
        return entry.getHash() == hash && CiHashMap.keysMatch(key, entry.getKey());
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<K, V>[] entryArray = this._table;
        int n = entryArray.length;
        for (int i = 0; i < n; ++i) {
            for (Entry<K, V> entry = entryArray[i]; entry != null; entry = entry.getNext()) {
                if (!GosuObjectUtil.equals(value, entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        return this.putImpl(key, value, true);
    }

    private V putImpl(K key, V value, boolean resizeIfNecessary) {
        int hash = CiHashMap.hash(key);
        Entry<K, V> existing = this.findEntry(key, hash);
        if (existing != null) {
            V oldValue = existing.getValue();
            existing.setValue(value);
            existing.setKey(key);
            return oldValue;
        }
        ++this._modCount;
        int bucketIndex = this.bucketNumber(hash);
        Entry<K, V> bucketHead = this._table[bucketIndex];
        this._table[bucketIndex] = new Entry<K, V>(key, value, hash, bucketHead);
        ++this._size;
        if (resizeIfNecessary && this._size >= this._resizeThreshold) {
            this.resize(2 * this._table.length);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAllImpl(m, true);
    }

    private void putAllImpl(Map<? extends K, ? extends V> map, boolean resizeIfNecessary) {
        if (resizeIfNecessary && map.size() + this._size >= this._resizeThreshold) {
            this.resize(this.findNearestPowerOfTwo(map.size() + this._size));
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putImpl((CharSequence)entry.getKey(), entry.getValue(), resizeIfNecessary);
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> removed = this.removeEntry(key);
        return removed == null ? null : (V)removed.getValue();
    }

    private Entry<K, V> removeEntry(Object key) {
        int hash = CiHashMap.hash(key);
        int bucketNumber = this.bucketNumber(hash);
        Entry<K, V> previous = null;
        for (Entry<K, V> current = this._table[bucketNumber]; current != null; current = current.getNext()) {
            if (this.entryMatches(key, hash, current)) {
                if (previous == null) {
                    this._table[bucketNumber] = current.getNext();
                } else {
                    previous.setNext(current.getNext());
                }
                --this._size;
                ++this._modCount;
                return current;
            }
            previous = current;
        }
        return null;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this._table.length; ++i) {
            this._table[i] = null;
        }
        ++this._modCount;
        this._size = 0;
    }

    @Override
    public Object clone() {
        CiHashMap result;
        try {
            result = (CiHashMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        result._table = new Entry[this._table.length];
        result._modCount = 0;
        result._size = 0;
        result._resizeThreshold = this._resizeThreshold;
        result._loadFactor = this._loadFactor;
        result.putAllImpl(this, false);
        return result;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Collection<V> values() {
        return new ValuesCollection();
    }

    private static boolean keysMatch(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (!(x instanceof CharSequence)) {
            throw new IllegalArgumentException("Key value must be instanceof CharSequence");
        }
        if (!(y instanceof CharSequence)) {
            throw new IllegalArgumentException("Key value must be instanceof CharSequence");
        }
        return CICS.equalsIgnoreCase((CharSequence)x, (CharSequence)y);
    }

    private static int hash(Object x) {
        if (x instanceof CICS) {
            return x.hashCode();
        }
        if (x == null) {
            return 0;
        }
        if (!(x instanceof CharSequence)) {
            throw new IllegalArgumentException("Key value must be instanceof CharSequence it is a type of " + x.getClass());
        }
        return CICS.getLowerCaseHashCode((CharSequence)x);
    }

    private int bucketNumber(int hashCode) {
        return this.bucketNumber(hashCode, this._table.length);
    }

    private int bucketNumber(int hashCode, int tableLength) {
        return hashCode & tableLength - 1;
    }

    private void resize(int newCapacity) {
        if (this._table.length == 0x40000000) {
            this._resizeThreshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        for (Entry<K, V> entry : this._table) {
            while (entry != null) {
                int newBucketNumber = this.bucketNumber(entry.getHash(), newTable.length);
                Entry<K, V> next = entry.getNext();
                entry.setNext(newTable[newBucketNumber]);
                newTable[newBucketNumber] = entry;
                entry = next;
            }
        }
        this._table = newTable;
        this._resizeThreshold = (int)((float)newCapacity * this._loadFactor);
    }

    private abstract class EntryIterator<E>
    implements Iterator<E> {
        private Entry<K, V> _lastReturned;
        private Entry<K, V> _next;
        private int _nextBucket = 0;
        private int _expectedModCount;

        protected EntryIterator() {
            this._expectedModCount = CiHashMap.this._modCount;
            this.advanceIterator();
        }

        public Entry<K, V> nextEntry() {
            this.checkForConcurrentModification();
            if (this._next == null) {
                throw new NoSuchElementException();
            }
            this._lastReturned = this._next;
            this.advanceIterator();
            return this._lastReturned;
        }

        private void checkForConcurrentModification() {
            if (this._expectedModCount != CiHashMap.this._modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        @Override
        public void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException("remove() can only be called once after a call to next()");
            }
            this.checkForConcurrentModification();
            CiHashMap.this.removeEntry(this._lastReturned.getKey());
            this._lastReturned = null;
            this._expectedModCount = CiHashMap.this._modCount;
        }

        private void advanceIterator() {
            this._next = null;
            if (this._lastReturned != null && this._lastReturned.getNext() != null) {
                this._next = this._lastReturned.getNext();
            } else {
                while (this._nextBucket < CiHashMap.this._table.length) {
                    this._next = CiHashMap.this._table[this._nextBucket];
                    ++this._nextBucket;
                    if (this._next == null) continue;
                    break;
                }
            }
        }
    }

    private class MapEntryIterator
    extends EntryIterator<Map.Entry<K, V>> {
        private MapEntryIterator() {
        }

        @Override
        public Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class ValuesIterator
    extends EntryIterator<V> {
        private ValuesIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends EntryIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new MapEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry currentEntry = CiHashMap.this.findEntry(e.getKey(), e.getHash());
            return e == currentEntry;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Object key = ((Entry)o).getKey();
            return CiHashMap.this.removeEntry(key) != null;
        }

        @Override
        public int size() {
            return CiHashMap.this._size;
        }

        @Override
        public void clear() {
            CiHashMap.this.clear();
        }
    }

    private class ValuesCollection
    extends AbstractCollection<V> {
        private ValuesCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int size() {
            return CiHashMap.this._size;
        }

        @Override
        public boolean contains(Object o) {
            return CiHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            CiHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CiHashMap.this._size;
        }

        @Override
        public boolean contains(Object o) {
            return CiHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CiHashMap.this.removeEntry(o) != null;
        }

        @Override
        public void clear() {
            CiHashMap.this.clear();
        }
    }

    private static class Entry<K extends CharSequence, V>
    implements Map.Entry<K, V>,
    Serializable {
        private K _key;
        private V _value;
        private int _hash;
        private Entry<K, V> _next;

        public Entry(K key, V value, int hash, Entry<K, V> next) {
            this._key = key;
            this._value = value;
            this._hash = hash;
            this._next = next;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        public void setKey(K key) {
            this._key = key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V value) {
            this._value = value;
            return this._value;
        }

        public int getHash() {
            return this._hash;
        }

        public Entry<K, V> getNext() {
            return this._next;
        }

        public void setNext(Entry<K, V> next) {
            this._next = next;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry entry = (Entry)o;
                return GosuObjectUtil.equals(this.getKey(), entry.getKey()) && GosuObjectUtil.equals(this.getValue(), entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            int result = this._key != null ? this._key.hashCode() : 0;
            result = 31 * result + (this._value != null ? this._value.hashCode() : 0);
            return result;
        }
    }
}

