/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect;

import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IVisibilityModifierType;

public class ScriptabilityModifier
implements IScriptabilityModifier {
    private static final IScriptabilityModifier[] EMPTY = new IScriptabilityModifier[0];
    private IVisibilityModifierType _type;
    private transient Boolean _hasConstraintQualifiers;
    private IScriptabilityModifier[] _qualifiers;

    public ScriptabilityModifier(IVisibilityModifierType type) {
        this._type = type;
        this._qualifiers = EMPTY;
    }

    public ScriptabilityModifier(IVisibilityModifierType type, IScriptabilityModifier[] qualifiers) {
        this._type = type;
        this._qualifiers = qualifiers;
    }

    @Override
    public IVisibilityModifierType getType() {
        return this._type;
    }

    @Override
    public IScriptabilityModifier[] getQualifiers() {
        return this._qualifiers;
    }

    public IScriptabilityModifier[] getQualifiersAsArray() {
        return this._qualifiers;
    }

    @Override
    public boolean hasConstraintQualifiers() {
        if (this._hasConstraintQualifiers != null) {
            return this._hasConstraintQualifiers;
        }
        if (this._qualifiers.length == 0) {
            this._hasConstraintQualifiers = Boolean.FALSE;
            return this._hasConstraintQualifiers;
        }
        for (int i = 0; i < this._qualifiers.length; ++i) {
            IScriptabilityModifier vm = this._qualifiers[i];
            if (!vm.getType().isConstraint()) continue;
            this._hasConstraintQualifiers = Boolean.TRUE;
            return this._hasConstraintQualifiers;
        }
        this._hasConstraintQualifiers = Boolean.FALSE;
        return this._hasConstraintQualifiers;
    }

    @Override
    public boolean hasModifierWithType(IVisibilityModifierType type) {
        return this.getModifierWithType(type) != null;
    }

    @Override
    public IScriptabilityModifier getModifierWithType(IVisibilityModifierType type) {
        if (this._type.equals(type)) {
            return this;
        }
        IScriptabilityModifier[] qualifiers = this.getQualifiersAsArray();
        for (int i = 0; i < qualifiers.length; ++i) {
            IScriptabilityModifier vm = qualifiers[i].getModifierWithType(type);
            if (vm == null) continue;
            return vm;
        }
        return null;
    }

    @Override
    public boolean satisfiesConstraint(IScriptabilityModifier constraint) {
        IScriptabilityModifier modifier = this.getModifierWithType(constraint.getType());
        if (modifier == null) {
            return false;
        }
        if (!constraint.hasConstraintQualifiers()) {
            return true;
        }
        if (!modifier.hasConstraintQualifiers()) {
            return true;
        }
        IScriptabilityModifier[] modifierQualifiers = modifier.getQualifiers();
        IScriptabilityModifier[] constraintQualifiers = constraint.getQualifiers();
        block0: for (int i = 0; i < constraintQualifiers.length; ++i) {
            IScriptabilityModifier qualifierConstraint = constraintQualifiers[i];
            for (int j = 0; j < modifierQualifiers.length; ++j) {
                IScriptabilityModifier qualifierModifier = modifierQualifiers[j];
                if (qualifierModifier.satisfiesConstraint(qualifierConstraint)) continue block0;
            }
            return false;
        }
        return true;
    }
}

