/*
 * Decompiled with CFR 0.152.
 */
package gw.lang.reflect.module;

import gw.lang.UnstableAPI;
import gw.lang.reflect.TypeSystem;
import java.util.Map;

@UnstableAPI
public class TypeSystemLockHelper {
    private static Boolean _bStudioRunning = null;

    private static boolean isStudioRunning() {
        if (_bStudioRunning == null) {
            _bStudioRunning = System.getProperty("gw.studio.running") != null;
        }
        return _bStudioRunning;
    }

    public static void getTypeSystemLockWithMonitor(Object objectToLock) {
        long lStart = System.currentTimeMillis();
        while (!TypeSystem.getGlobalLock().tryLock()) {
            try {
                try {
                    TypeSystemLockHelper.maybeWaitOnContextLoader(objectToLock);
                    objectToLock.wait(100L);
                }
                catch (IllegalMonitorStateException e) {
                    Thread.sleep(100L);
                }
                if (TypeSystemLockHelper.isStudioRunning() || System.currentTimeMillis() - lStart <= 1000000L) continue;
                StringBuilder b = new StringBuilder();
                for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
                    b.append(entry.getKey().getName()).append('\n');
                    for (StackTraceElement stackTraceElement : entry.getValue()) {
                        b.append(stackTraceElement).append('\n');
                    }
                    b.append('\n');
                }
                System.err.print(b.toString());
                throw new RuntimeException("Deadlock detected while loading classes");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void maybeWaitOnContextLoader(Object objectToLock) throws InterruptedException {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        if (objectToLock != ctxLoader && ctxLoader != null) {
            try {
                ctxLoader.wait(100L);
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }
}

