/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.statement;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.compiler.NamedLabel;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.internal.gosu.ir.compiler.bytecode.IRCompilerLocalVar;
import gw.internal.gosu.ir.compiler.bytecode.IRFinallyCodePartitioner;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.statement.IRCatchClause;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import java.util.Collections;
import java.util.List;

public class IRTryCatchFinallyStatementCompiler
extends AbstractBytecodeCompiler {
    private IRFinallyCodePartitioner _finallyPartitioner;
    private IRTryCatchFinallyStatement _stmt;
    private IRBytecodeContext _context;

    private IRTryCatchFinallyStatement _stmt() {
        return this._stmt;
    }

    public static void compile(IRTryCatchFinallyStatement stmt, IRBytecodeContext context) {
        IRTryCatchFinallyStatementCompiler compiler = new IRTryCatchFinallyStatementCompiler(stmt, context);
        compiler.compile();
    }

    private IRTryCatchFinallyStatementCompiler(IRTryCatchFinallyStatement stmt, IRBytecodeContext context) {
        this._stmt = stmt;
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile() {
        MethodVisitor mv = this._context.getMv();
        NamedLabel tryStart = new NamedLabel("TryStart");
        NamedLabel tryEnd = new NamedLabel("TryEnd");
        NamedLabel tryCatchFinallyEnd = new NamedLabel("TryCatchFinallyEnd");
        List catchStmts = this._stmt().getCatchStatements();
        this._finallyPartitioner = this.pushFinallyStmt();
        try {
            this.compileTryStatement(mv, tryStart, tryEnd, tryCatchFinallyEnd);
            if (catchStmts != null && !catchStmts.isEmpty()) {
                this.compileCatchStatements(mv, tryStart, tryEnd, tryCatchFinallyEnd, catchStmts);
            }
            if (this.hasFinally()) {
                this.compileFinallyStatement(mv, tryStart);
            }
            mv.visitLabel((Label)tryCatchFinallyEnd);
        }
        finally {
            this.popFinallyStmt(this._finallyPartitioner);
        }
    }

    private void compileTryStatement(MethodVisitor mv, Label tryStart, Label tryEnd, Label tryCatchEnd) {
        mv.visitLabel(tryStart);
        IRBytecodeCompiler.compileIRStatement(this._stmt().getTryBody(), this._context);
        this.inlineLocalFinallyStmt(this._stmt().getTryBody(), tryCatchEnd);
        mv.visitLabel(tryEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileCatchStatements(MethodVisitor mv, Label tryStart, Label tryEnd, Label tryCatchEnd, List<IRCatchClause> catchStmts) {
        for (int i = 0; i < catchStmts.size(); ++i) {
            IRCatchClause catchStmt = catchStmts.get(i);
            this._context.pushScope();
            try {
                IRType type = catchStmt.getIdentifier().getType();
                NamedLabel catchStart = new NamedLabel("CatchStart for " + (type == null ? "(no type)" : type.getName()));
                this._context.visitLabel(catchStart);
                this.declareCatchExtents(mv, tryStart, tryEnd, catchStart, type);
                this.assignExceptionParam(mv, catchStmt.getIdentifier());
                IRBytecodeCompiler.compileIRStatement(catchStmt.getBody(), this._context);
                this.inlineLocalFinallyStmt(catchStmt.getBody(), tryCatchEnd);
                continue;
            }
            finally {
                this._context.popScope();
            }
        }
    }

    private void declareCatchExtents(MethodVisitor mv, Label tryStart, Label coverageEnd, Label handlerStart, IRType type) {
        Label end;
        Label start = tryStart;
        List starts = this._finallyPartitioner == null ? Collections.emptyList() : this._finallyPartitioner.getFinallyStarts();
        List ends = this._finallyPartitioner == null ? Collections.emptyList() : this._finallyPartitioner.getFinallyEnds();
        for (int i = 0; i < starts.size() && (end = (Label)starts.get(i)).getOffset() <= coverageEnd.getOffset(); ++i) {
            this.insertTryCatchBlock(mv, handlerStart, type, start, end);
            start = (Label)ends.get(i);
        }
        end = coverageEnd;
        this.insertTryCatchBlock(mv, handlerStart, type, start, end);
    }

    private void insertTryCatchBlock(MethodVisitor mv, Label handlerStart, IRType type, Label start, Label end) {
        if (start.getOffset() > end.getOffset()) {
            throw new IllegalStateException("start label must precede the end label");
        }
        if (start.getOffset() != end.getOffset()) {
            mv.visitTryCatchBlock(start, end, handlerStart, type.getSlashName());
        }
    }

    private void assignExceptionParam(MethodVisitor mv, IRSymbol exceptionSym) {
        IRCompilerLocalVar exceptionVar = this._context.getLocalVar(exceptionSym);
        mv.visitVarInsn(58, exceptionVar.getIndex());
    }

    private void compileFinallyStatement(MethodVisitor mv, Label tryStart) {
        NamedLabel finallyStart = new NamedLabel("Finally Start ");
        mv.visitLabel((Label)finallyStart);
        this.declareCatchExtents(mv, tryStart, finallyStart, finallyStart, JavaClassIRType.get(Throwable.class));
        int iExceptionIndex = this._context.getLocalVar(new IRSymbol("**temp**throwable**", JavaClassIRType.get(Throwable.class), true)).getIndex();
        mv.visitVarInsn(58, iExceptionIndex);
        IRBytecodeCompiler.compileIRStatement(this._stmt().getFinallyBody(), this._context);
        if (this._stmt().getFinallyBody().getLeastSignificantTerminalStatement() == null) {
            mv.visitVarInsn(25, iExceptionIndex);
            mv.visitInsn(191);
        }
    }

    private void inlineLocalFinallyStmt(IRStatement tryOrCatchStmt, Label labelEnd) {
        MethodVisitor mv = this._context.getMv();
        if (tryOrCatchStmt.getLeastSignificantTerminalStatement() == null) {
            if (this.hasFinally()) {
                this._finallyPartitioner.inlineFinally();
                NamedLabel endLabel = new NamedLabel("EndFinally" + this._finallyPartitioner.getFinallyEnds().size());
                this._context.visitLabel(endLabel);
                this._finallyPartitioner.endInlineFinally(endLabel);
            }
            mv.visitJumpInsn(167, labelEnd);
        }
    }

    private void popFinallyStmt(IRFinallyCodePartitioner partition) {
        if (this.hasFinally()) {
            this._context.popFinallyStatement(partition);
        }
    }

    private IRFinallyCodePartitioner pushFinallyStmt() {
        if (this.hasFinally()) {
            return this._context.pushFinallyStatement(this._stmt());
        }
        return null;
    }

    private boolean hasFinally() {
        return this._stmt().getFinallyBody() != null;
    }
}

