/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.GosuBaseAttributedFeatureInfo;
import gw.internal.gosu.parser.GosuClassTypeInfo;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.ModifierInfo;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IModifierInfo;
import gw.lang.reflect.IPresentationInfo;
import gw.lang.reflect.IPropertyAccessor;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuVarPropertyInfo;
import gw.lang.reflect.java.JavaTypes;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;

public class GosuVarPropertyInfo
extends GosuBaseAttributedFeatureInfo
implements IGosuVarPropertyInfo {
    private String _strIdentifer;
    private IType _actualType;
    private boolean _bStatic;
    private boolean _bPublic;
    private boolean _bProtected;
    private boolean _bInternal;
    private boolean _bPrivate;
    private IPropertyAccessor _accessor;
    private String _fullDescription;
    private boolean _hasProperty;
    private boolean _isScopedField;
    private IGosuClass _gosuClass;
    private boolean _isFinal;
    private IType _symbolType;
    private String _symbolScopeString;
    private String _symbolAttributeName;
    private int _modifiers;

    GosuVarPropertyInfo(IFeatureInfo container, IVarStatement varStmt) {
        super(container);
        this._strIdentifer = varStmt.getIdentifierName();
        this._actualType = this.assignActualType(varStmt.getType());
        this._bStatic = varStmt.isStatic();
        this._bPublic = varStmt.isPublic();
        this._bProtected = varStmt.isProtected();
        this._bInternal = varStmt.isInternal();
        this._bPrivate = varStmt.isPrivate();
        this._fullDescription = varStmt.getFullDescription();
        this._hasProperty = varStmt.hasProperty();
        this._symbolType = varStmt.getSymbol().getType();
        this._gosuClass = varStmt.getParent() != null ? varStmt.getParent().getGosuClass() : null;
        this._isFinal = varStmt.isFinal();
        ModifierInfo modifierInfo = ((VarStatement)varStmt).getModifierInfo();
        this._modifiers = modifierInfo.getModifiers();
        ((GosuClassTypeInfo)this.getOwnersType().getTypeInfo()).setModifierInfo(this, modifierInfo);
    }

    public GosuVarPropertyInfo(GosuClassTypeInfo container, GosuVarPropertyInfo pi) {
        super((IFeatureInfo)container);
        this._strIdentifer = pi._strIdentifer;
        this._actualType = this.assignActualType(pi._actualType);
        this._bStatic = pi._bStatic;
        this._bPublic = pi._bPublic;
        this._bProtected = pi._bProtected;
        this._bInternal = pi._bInternal;
        this._bPrivate = pi._bPrivate;
        this._fullDescription = pi._fullDescription;
        this._hasProperty = pi._hasProperty;
        this._isScopedField = pi._isScopedField;
        this._symbolScopeString = pi._symbolScopeString;
        this._symbolAttributeName = pi._symbolAttributeName;
        this._symbolType = pi._symbolType;
        this._gosuClass = pi._gosuClass;
        this._isFinal = pi._isFinal;
        this._modifiers = pi._modifiers;
        GosuClassTypeInfo ti = (GosuClassTypeInfo)this.getOwnersType().getTypeInfo();
        ti.setModifierInfo(this, ti.getModifierInfo(pi));
    }

    public String getName() {
        return this._strIdentifer == null ? null : this._strIdentifer;
    }

    public IType getFeatureType() {
        if (this._actualType == JavaTypes.pVOID()) {
            this.getOwnersType().isValid();
            this._actualType = this.assignActualType(this._actualType);
        }
        return this._actualType;
    }

    public boolean isStatic() {
        return this._bStatic;
    }

    public boolean isPrivate() {
        return this._bPrivate;
    }

    public boolean isInternal() {
        return this._bInternal;
    }

    public boolean isProtected() {
        return this._bProtected;
    }

    public boolean isFinal() {
        return this._isFinal;
    }

    public boolean isPublic() {
        return this._bPublic || !this.isPrivate() && !this.isInternal() && !this.isProtected();
    }

    @Override
    protected List<IGosuAnnotation> getGosuAnnotations() {
        IModifierInfo modifierInfo = ((GosuClassTypeInfo)this.getOwnersType().getTypeInfo()).getModifierInfo(this);
        return modifierInfo != null ? modifierInfo.getAnnotations() : Collections.emptyList();
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable(IType whosAskin) {
        return !this.isFinal();
    }

    public boolean isWritable() {
        return this.isWritable(null) && !this.isFinal();
    }

    public IPropertyAccessor getAccessor() {
        if (this._accessor != null) {
            return this._accessor;
        }
        this._accessor = new VarPropertyAccessor();
        return this._accessor;
    }

    public IPresentationInfo getPresentationInfo() {
        return IPresentationInfo.Default.GET;
    }

    public IType assignActualType(IType type) {
        if (this._actualType == null || this._actualType == JavaTypes.pVOID()) {
            this._actualType = this.getActualTypeInContainer((IFeatureInfo)this, type);
        }
        return this._actualType;
    }

    public void assignSymbolType(IType type) {
        if (this._symbolType == null || this._symbolType == JavaTypes.pVOID()) {
            this._symbolType = type;
        }
    }

    public boolean hasDeclaredProperty() {
        return this._hasProperty;
    }

    public boolean isScopedField() {
        return this._isScopedField;
    }

    public IType getScopedSymbolType() {
        return this._symbolType;
    }

    public String getSymbolScopeString() {
        return this._symbolScopeString;
    }

    public String getSymbolAttributeName() {
        return this._symbolAttributeName;
    }

    public GenericTypeVariable[] getTypeVariables() {
        return GenericTypeVariable.EMPTY_TYPEVARS;
    }

    public IType getParameterizedReturnType(IType ... typeParams) {
        return null;
    }

    public IType[] getParameterizedParameterTypes(IType ... typeParams) {
        return IType.EMPTY_ARRAY;
    }

    public IType[] getParameterizedParameterTypes2(IType ownersType, IType ... typeParams) {
        return IType.EMPTY_ARRAY;
    }

    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes(IType ... argTypes) {
        return null;
    }

    public TypeVarToTypeMap inferTypeParametersFromArgumentTypes2(IType owningParameterizedType, IType ... argTypes) {
        return null;
    }

    public boolean isCompileTimeConstantValue() {
        return this.getCompileTimeConstantExpression() != null;
    }

    public Object doCompileTimeEvaluation() {
        Expression expr = this.getCompileTimeConstantExpression();
        return expr instanceof INewExpression ? this.getName() : expr.evaluate();
    }

    private Expression getCompileTimeConstantExpression() {
        if (!this.isStatic() || !this.isFinal()) {
            return null;
        }
        IType type = this.getFeatureType();
        if (type != JavaTypes.STRING() && !type.isPrimitive() && !type.isEnum()) {
            return null;
        }
        if (this.getOwnersType().isDeclarationsCompiled()) {
            this.getOwnersType().isValid();
        }
        for (VarStatement varStmt : this.getOwnersType().getParseInfo().getStaticFields().values()) {
            Expression initiazerExpr;
            if (!varStmt.getIdentifierName().equals(this.getName()) || (initiazerExpr = varStmt.getAsExpression()) == null) continue;
            return varStmt.isEnumConstant() || initiazerExpr.isCompileTimeConstant() ? initiazerExpr : null;
        }
        return null;
    }

    public String getDescription() {
        return this._fullDescription;
    }

    private class VarPropertyAccessor
    implements IPropertyAccessor {
        private VarPropertyAccessor() {
        }

        public Object getValue(Object ctx) {
            IGosuClass gsClass = (IGosuClass)GosuVarPropertyInfo.this.getContainer().getOwnersType();
            try {
                Field field = gsClass.getBackingClass().getDeclaredField(GosuVarPropertyInfo.this._strIdentifer);
                field.setAccessible(true);
                return field.get(ctx);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setValue(Object ctx, Object value) {
            IGosuClass gsClass = GosuVarPropertyInfo.this._gosuClass;
            try {
                Field field = gsClass.getBackingClass().getDeclaredField(GosuVarPropertyInfo.this._strIdentifer);
                field.setAccessible(true);
                field.set(ctx, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

