/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.AsmConstructorJavaClassConstructor;
import gw.internal.gosu.parser.AsmFieldJavaClassField;
import gw.internal.gosu.parser.AsmMethodJavaClassMethod;
import gw.internal.gosu.parser.AsmTypeJavaClassType;
import gw.internal.gosu.parser.AsmTypeVariableJavaClassTypeVariable;
import gw.internal.gosu.parser.java.classinfo.AsmClassAnnotationInfo;
import gw.internal.gosu.parser.java.classinfo.JavaArrayClassInfo;
import gw.internal.gosu.parser.java.classinfo.JavaSourceMethodDescriptor;
import gw.internal.gosu.parser.java.classinfo.JavaSourcePropertyDescriptor;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.lang.GosuShop;
import gw.lang.SimplePropertyProcessing;
import gw.lang.javadoc.IClassDocNode;
import gw.lang.reflect.EnumValuePlaceholder;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IEnumValue;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ImplicitPropertyUtil;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.AbstractJavaClassInfo;
import gw.lang.reflect.java.IAsmJavaClassInfo;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaClassTypeVariable;
import gw.lang.reflect.java.IJavaMethodDescriptor;
import gw.lang.reflect.java.IJavaPropertyDescriptor;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.asm.AsmAnnotation;
import gw.lang.reflect.java.asm.AsmClass;
import gw.lang.reflect.java.asm.AsmField;
import gw.lang.reflect.java.asm.AsmInnerClassType;
import gw.lang.reflect.java.asm.AsmMethod;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.IAsmType;
import gw.lang.reflect.module.IModule;
import gw.util.GosuObjectUtil;
import gw.util.concurrent.LocklessLazyVar;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsmClassJavaClassInfo
extends AsmTypeJavaClassType
implements IAsmJavaClassInfo {
    private AsmClass _class;
    private IJavaClassMethod[] _declaredMethods;
    private IJavaClassInfo[] _interfaces;
    private IJavaClassInfo _superclass;
    private IJavaClassTypeVariable[] _typeVariables;
    private IJavaClassField[] _declaredFields;
    private IJavaClassConstructor[] _declaredConstructors;
    private IAnnotationInfo[] _declaredAnnotations;
    private IJavaPropertyDescriptor[] _propertyDescriptors;
    private IJavaMethodDescriptor[] _methodDescriptors;
    private IJavaClassField[] _allFields;
    private IJavaClassType[] _genericInterfaces;
    private IJavaClassInfo[] _declaredClasses;
    private LocklessLazyVar<IType> _enclosingClass = new LocklessLazyVar<IType>(){

        protected IType init() {
            AsmType enclosingClass = AsmClassJavaClassInfo.this._class.getEnclosingType();
            return enclosingClass == null ? null : TypeSystem.getByFullName((String)enclosingClass.getName(), (IModule)AsmClassJavaClassInfo.this._module);
        }
    };
    private IEnumValue[] _enumConstants;
    private String _simpleName;
    private String _namespace;
    private IJavaType _javaType;

    public AsmClassJavaClassInfo(AsmClass cls, IModule module) {
        super((IAsmType)cls, module);
        if (cls == null) {
            throw new IllegalArgumentException("Class cannot be null.");
        }
        this._class = cls;
        this._module = module;
    }

    public boolean isAnnotation() {
        return this._class.isAnnotation();
    }

    public boolean isInterface() {
        return this._class.isInterface();
    }

    public IJavaClassType getConcreteType() {
        return this;
    }

    @Override
    public String getName() {
        return this._class.getNameWithArrayBrackets();
    }

    public String getNameSignature() {
        return GosuShop.toSignature((String)this._class.getFqn());
    }

    public IJavaClassMethod getMethod(String methodName, IJavaClassInfo ... paramTypes) throws NoSuchMethodException {
        block0: for (IJavaClassMethod method : this.getDeclaredMethods()) {
            IJavaClassInfo[] methodParamTypes;
            if (!method.getName().equals(methodName) || paramTypes.length != (methodParamTypes = method.getParameterTypes()).length) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!paramTypes[i].equals((Object)methodParamTypes[i])) continue block0;
            }
            return method;
        }
        IJavaClassInfo superclass = this.getSuperclass();
        if (superclass != null) {
            return superclass.getMethod(methodName, paramTypes);
        }
        throw new NoSuchMethodException();
    }

    public IJavaClassMethod getDeclaredMethod(String methodName, IJavaClassInfo ... paramTypes) throws NoSuchMethodException {
        return this.getMethod(methodName, paramTypes);
    }

    public IJavaClassMethod[] getDeclaredMethods() {
        if (this._declaredMethods == null) {
            List asmMethods = this._class.getDeclaredMethodsAndConstructors();
            ArrayList<AsmMethodJavaClassMethod> methods = new ArrayList<AsmMethodJavaClassMethod>(asmMethods.size());
            for (AsmMethod asmMethod : asmMethods) {
                if (asmMethod.isConstructor() || asmMethod.isSynthetic()) continue;
                methods.add(new AsmMethodJavaClassMethod(asmMethod, this._module));
            }
            this._declaredMethods = methods.toArray(new IJavaClassMethod[methods.size()]);
        }
        return this._declaredMethods;
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        return null;
    }

    public Object[] getEnumConstants() {
        if (this._enumConstants == null) {
            IJavaClassField[] fields;
            ArrayList<EnumValuePlaceholder> enums = new ArrayList<EnumValuePlaceholder>();
            for (IJavaClassField field : fields = this.getFields()) {
                if (!field.isEnumConstant()) continue;
                enums.add(new EnumValuePlaceholder(field.getName()));
            }
            this._enumConstants = enums.toArray(new IEnumValue[enums.size()]);
        }
        return this._enumConstants;
    }

    public IType getJavaType() {
        return this._javaType == null ? (this._javaType = (IJavaType)TypeSystem.get((IJavaClassInfo)this)) : this._javaType;
    }

    public void setJavaType(IJavaType javaType) {
        this._javaType = javaType;
    }

    public IJavaClassInfo[] getInterfaces() {
        if (this._interfaces == null) {
            List rawInterfaces = this._class.getInterfaces();
            IJavaClassInfo[] interfaces = new IJavaClassInfo[rawInterfaces.size()];
            for (int i = 0; i < rawInterfaces.size(); ++i) {
                interfaces[i] = JavaSourceUtil.getClassInfo(((AsmType)rawInterfaces.get(i)).getName(), this._module);
            }
            this._interfaces = interfaces;
        }
        return this._interfaces;
    }

    public IJavaClassInfo getSuperclass() {
        if (this._superclass == null) {
            this._superclass = this._class.getSuperClass() == null ? NULL_TYPE : JavaSourceUtil.getClassInfo(this._class.getSuperClass().getName(), this._module);
        }
        return this._superclass == NULL_TYPE ? null : this._superclass;
    }

    public IJavaClassTypeVariable[] getTypeParameters() {
        if (this._typeVariables == null) {
            List rawTypeVariables = this._class.getTypeParameters();
            IJavaClassTypeVariable[] typeVariables = new IJavaClassTypeVariable[rawTypeVariables.size()];
            for (int i = 0; i < rawTypeVariables.size(); ++i) {
                typeVariables[i] = new AsmTypeVariableJavaClassTypeVariable((IAsmType)rawTypeVariables.get(i), this._module);
            }
            this._typeVariables = typeVariables;
        }
        return this._typeVariables;
    }

    public IJavaClassField[] getDeclaredFields() {
        if (this._declaredFields == null) {
            List rawFields = this._class.getDeclaredFields();
            IJavaClassField[] fields = new IJavaClassField[rawFields.size()];
            for (int i = 0; i < rawFields.size(); ++i) {
                fields[i] = new AsmFieldJavaClassField((AsmField)rawFields.get(i), this._module);
            }
            this._declaredFields = fields;
        }
        return this._declaredFields;
    }

    public IJavaClassConstructor[] getDeclaredConstructors() {
        if (this._declaredConstructors == null) {
            List asmMethods = this._class.getDeclaredMethodsAndConstructors();
            ArrayList<AsmConstructorJavaClassConstructor> ctors = new ArrayList<AsmConstructorJavaClassConstructor>(asmMethods.size());
            for (AsmMethod asmMethod : asmMethods) {
                if (!asmMethod.isConstructor() || asmMethod.isSynthetic()) continue;
                ctors.add(new AsmConstructorJavaClassConstructor(asmMethod, this._module));
            }
            this._declaredConstructors = ctors.toArray(new IJavaClassConstructor[ctors.size()]);
        }
        return this._declaredConstructors;
    }

    public IJavaClassConstructor getConstructor(IJavaClassInfo ... paramTypes) throws NoSuchMethodException {
        block0: for (IJavaClassConstructor ctor : this.getDeclaredConstructors()) {
            IJavaClassInfo[] methodParamTypes = ctor.getParameterTypes();
            if (paramTypes.length != methodParamTypes.length) continue;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!paramTypes[i].equals((Object)methodParamTypes[i])) continue block0;
            }
            return ctor;
        }
        throw new NoSuchMethodException();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._class.isAnnotationPresent(annotationClass);
    }

    public IAnnotationInfo getAnnotation(Class annotationClass) {
        for (IAnnotationInfo annotationInfo : this.getDeclaredAnnotations()) {
            if (!annotationInfo.getName().equals(annotationClass.getName())) continue;
            return annotationInfo;
        }
        return null;
    }

    public IAnnotationInfo[] getDeclaredAnnotations() {
        if (this._declaredAnnotations == null) {
            List annotations = this._class.getDeclaredAnnotations();
            IAnnotationInfo[] declaredAnnotations = new IAnnotationInfo[annotations.size()];
            for (int i = 0; i < declaredAnnotations.length; ++i) {
                declaredAnnotations[i] = new AsmClassAnnotationInfo((AsmAnnotation)annotations.get(i), (IJavaAnnotatedElement)this);
            }
            this._declaredAnnotations = declaredAnnotations;
        }
        return this._declaredAnnotations;
    }

    public IClassDocNode createClassDocNode() {
        return null;
    }

    public IJavaPropertyDescriptor[] getPropertyDescriptors() {
        if (this._propertyDescriptors == null) {
            this._propertyDescriptors = this.initPropertyDescriptors();
        }
        return this._propertyDescriptors;
    }

    protected IJavaPropertyDescriptor[] initPropertyDescriptors() {
        String propName;
        HashMap<String, IJavaClassMethod> getters = new HashMap<String, IJavaClassMethod>();
        HashMap<String, ArrayList<IJavaClassMethod>> setters = new HashMap<String, ArrayList<IJavaClassMethod>>();
        ArrayList<IJavaClassMethod> methods = new ArrayList<IJavaClassMethod>();
        methods.addAll(Arrays.asList(this.getDeclaredMethods()));
        boolean simplePropertyProcessing = this.getAnnotation(SimplePropertyProcessing.class) != null;
        for (IJavaClassMethod method : methods) {
            ImplicitPropertyUtil.ImplicitPropertyInfo info = JavaSourceUtil.getImplicitProperty(method, simplePropertyProcessing);
            if (info == null) continue;
            if (info.isGetter() && !getters.containsKey(info.getName())) {
                getters.put(info.getName(), method);
                continue;
            }
            if (!info.isSetter()) continue;
            ArrayList<IJavaClassMethod> infoSetters = (ArrayList<IJavaClassMethod>)setters.get(info.getName());
            if (infoSetters == null) {
                infoSetters = new ArrayList<IJavaClassMethod>(2);
            }
            infoSetters.add(method);
            setters.put(info.getName(), infoSetters);
        }
        ArrayList<JavaSourcePropertyDescriptor> propertyDescriptors = new ArrayList<JavaSourcePropertyDescriptor>();
        for (Map.Entry entry : getters.entrySet()) {
            propName = (String)entry.getKey();
            List infoSetters = (List)setters.get(propName);
            IJavaClassMethod getter = (IJavaClassMethod)entry.getValue();
            IJavaClassType getterType = getter == null ? null : getter.getGenericReturnType();
            IJavaClassMethod theSetter = null;
            if (infoSetters != null) {
                for (IJavaClassMethod setter : infoSetters) {
                    if (setter == null) continue;
                    setters.remove(propName);
                    if (getterType == null || !setter.getGenericParameterTypes()[0].equals(getterType) && !GosuObjectUtil.equals((Object)setter.getGenericParameterTypes()[0].getConcreteType(), (Object)getterType)) continue;
                    theSetter = setter;
                    break;
                }
            }
            if (getterType != null) {
                if (theSetter == null) {
                    theSetter = AsmClassJavaClassInfo.maybeFindSetterInSuper(getter, this.getSuperclass());
                }
                propertyDescriptors.add(new JavaSourcePropertyDescriptor(propName, (IJavaClassInfo)getterType.getConcreteType(), getter, theSetter));
                continue;
            }
            if (infoSetters == null) continue;
            for (IJavaClassMethod setter : infoSetters) {
                getter = AsmClassJavaClassInfo.maybeFindGetterInSuper(setter, this.getSuperclass());
                if (getter == null) continue;
                setters.remove(propName);
                propertyDescriptors.add(new JavaSourcePropertyDescriptor(propName, (IJavaClassInfo)getterType.getConcreteType(), getter, setter));
            }
        }
        for (Map.Entry entry : setters.entrySet()) {
            propName = (String)entry.getKey();
            IJavaClassMethod setter = (IJavaClassMethod)((List)entry.getValue()).get(0);
            IJavaClassType propType = setter.getGenericReturnType();
            IJavaClassMethod getter = AsmClassJavaClassInfo.maybeFindGetterInSuper(setter, this.getSuperclass());
            if (getter != null) {
                propType = getter.getGenericReturnType();
            }
            propertyDescriptors.add(new JavaSourcePropertyDescriptor(propName, (IJavaClassInfo)propType.getConcreteType(), getter, setter));
        }
        return propertyDescriptors.toArray(new IJavaPropertyDescriptor[propertyDescriptors.size()]);
    }

    public static IJavaClassMethod maybeFindSetterInSuper(IJavaClassMethod getter, IJavaClassInfo superClass) {
        if (superClass == null) {
            return null;
        }
        while (superClass != null) {
            for (IJavaPropertyDescriptor pd : superClass.getPropertyDescriptors()) {
                if (!AsmClassJavaClassInfo.doesSetterDescMatchGetterMethod(getter, pd)) continue;
                return pd.getWriteMethod();
            }
            superClass = superClass.getSuperclass();
        }
        return null;
    }

    private static boolean doesSetterDescMatchGetterMethod(IJavaClassMethod getter, IJavaPropertyDescriptor pd) {
        IJavaClassMethod setter;
        IJavaClassType getterType = getter.getGenericReturnType();
        return !(getterType == null || (setter = pd.getWriteMethod()) == null || !setter.getGenericParameterTypes()[0].equals(getterType) && !GosuObjectUtil.equals((Object)setter.getGenericParameterTypes()[0].getConcreteType(), (Object)getterType) || !("get" + pd.getName()).equals(getter.getName()) && !("is" + pd.getName()).equals(getter.getName()));
    }

    private static boolean doesGetterDescMatchSetterMethod(IJavaClassMethod setter, IJavaPropertyDescriptor pd) {
        IJavaClassMethod getter;
        IJavaClassInfo setterType;
        IJavaClassInfo iJavaClassInfo = setterType = setter.getParameterTypes().length == 1 ? setter.getParameterTypes()[0] : null;
        return setterType != null && (getter = pd.getReadMethod()) != null && (getter.getGenericReturnType().equals(setterType) || GosuObjectUtil.equals((Object)getter.getGenericReturnType().getConcreteType(), (Object)setterType)) && ("set" + pd.getName()).equals(setter.getName());
    }

    public static IJavaClassMethod maybeFindGetterInSuper(IJavaClassMethod setter, IJavaClassInfo superClass) {
        if (superClass == null) {
            return null;
        }
        while (superClass != null) {
            for (IJavaPropertyDescriptor pd : superClass.getPropertyDescriptors()) {
                if (!AsmClassJavaClassInfo.doesGetterDescMatchSetterMethod(setter, pd)) continue;
                return pd.getReadMethod();
            }
            superClass = superClass.getSuperclass();
        }
        return null;
    }

    public IJavaMethodDescriptor[] getMethodDescriptors() {
        if (this._methodDescriptors == null) {
            IJavaClassMethod[] declaredMethods = this.getDeclaredMethods();
            this._methodDescriptors = new IJavaMethodDescriptor[declaredMethods.length];
            for (int i = 0; i < declaredMethods.length; ++i) {
                this._methodDescriptors[i] = new JavaSourceMethodDescriptor(declaredMethods[i]);
            }
        }
        return this._methodDescriptors;
    }

    public boolean hasCustomBeanInfo() {
        return false;
    }

    public String getRelativeName() {
        return this.getName().substring(this.getNamespace().length() + 1);
    }

    public String getDisplayName() {
        return this.getSimpleName();
    }

    public String getSimpleName() {
        if (this._simpleName == null) {
            this._simpleName = this._class.getSimpleName();
        }
        return this._simpleName;
    }

    public boolean isVisibleViaFeatureDescriptor(IScriptabilityModifier constraint) {
        return true;
    }

    public boolean isHiddenViaFeatureDescriptor() {
        return false;
    }

    public IJavaClassField[] getFields() {
        if (this._allFields == null) {
            ArrayList<IJavaClassField> fields = new ArrayList<IJavaClassField>();
            IJavaClassField[] declaredFields = this.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; ++i) {
                IJavaClassField field = declaredFields[i];
                if (!Modifier.isPublic((int)field.getModifiers())) continue;
                fields.add(field);
            }
            IJavaClassInfo superclass = this.getSuperclass();
            if (superclass != null) {
                fields.addAll(Arrays.asList(superclass.getFields()));
            }
            this._allFields = fields.toArray(new IJavaClassField[fields.size()]);
        }
        return this._allFields;
    }

    public AsmClass getAsmType() {
        return this._class;
    }

    public IJavaClassInfo getComponentType() {
        return null;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isEnum() {
        return this._class.isEnum();
    }

    public int getModifiers() {
        return this._class.getModifiers();
    }

    public boolean isPrimitive() {
        return this._class.isPrimitive();
    }

    public IJavaClassInfo getEnclosingClass() {
        AsmType enclosingClass = this._class.getEnclosingType();
        if (enclosingClass != null) {
            return TypeSystem.getJavaClassInfo((String)enclosingClass.getName(), (IModule)this._module);
        }
        return null;
    }

    public IType getEnclosingType() {
        return (IType)this._enclosingClass.get();
    }

    @Override
    public String getNamespace() {
        if (this._namespace == null) {
            String name = this._class.getName();
            int iDot = name.lastIndexOf(46);
            this._namespace = iDot < 0 ? "" : name.substring(0, iDot);
        }
        return this._namespace;
    }

    public IJavaClassType[] getGenericInterfaces() {
        if (this._genericInterfaces == null) {
            List asmIfaces = this._class.getInterfaces();
            IJavaClassType[] ifaces = new IJavaClassType[asmIfaces.size()];
            for (int i = 0; i < asmIfaces.size(); ++i) {
                ifaces[i] = AsmTypeJavaClassType.createType((IAsmType)asmIfaces.get(i), this._module);
            }
            this._genericInterfaces = ifaces;
        }
        return this._genericInterfaces;
    }

    public IJavaClassType getGenericSuperclass() {
        return AsmTypeJavaClassType.createType((IAsmType)this._class.getSuperClass(), this._module);
    }

    public IJavaClassInfo getArrayType() {
        return new JavaArrayClassInfo((IJavaClassInfo)this);
    }

    public IJavaClassInfo[] getDeclaredClasses() {
        if (this._declaredClasses == null) {
            Map innerClasses = this._class.getInnerClasses();
            ArrayList<IJavaClassInfo> declaredClasses = new ArrayList<IJavaClassInfo>(innerClasses.size());
            for (AsmInnerClassType innerClass : innerClasses.values()) {
                IJavaClassInfo declaredClassInfo = TypeSystem.getJavaClassInfo((String)innerClass.getName(), (IModule)this._module);
                declaredClasses.add(declaredClassInfo);
            }
            this._declaredClasses = declaredClasses.toArray(new IJavaClassInfo[declaredClasses.size()]);
        }
        return this._declaredClasses;
    }

    public boolean isAssignableFrom(IJavaClassInfo aClass) {
        return AbstractJavaClassInfo.isAssignableFrom((IJavaClassInfo)this, (IJavaClassInfo)aClass);
    }

    public boolean isPublic() {
        return Modifier.isPublic((int)this._class.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected((int)this._class.getModifiers());
    }

    public boolean isInternal() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate((int)this._class.getModifiers());
    }

    @Override
    public boolean equals(Object obj) {
        return AbstractJavaClassInfo.equals((IJavaClassInfo)this, (Object)obj);
    }

    @Override
    public int hashCode() {
        return AbstractJavaClassInfo.hashCode((IJavaClassInfo)this);
    }

    public String toString() {
        return this._class.toString();
    }

    public Class getBackingClass() {
        return TypeSystem.getDefaultTypeLoader().loadClass(this.getName());
    }

    public ISourceFileHandle getSourceFileHandle() {
        return null;
    }

    @Override
    public IModule getModule() {
        return this._module;
    }

    public IJavaClassType resolveType(String relativeName, int ignoreFlags) {
        return null;
    }

    public IJavaClassType resolveType(String relativeName, IJavaClassInfo whosAskin, int ignoreFlags) {
        for (AsmInnerClassType innerClass : this._class.getInnerClasses().values()) {
            if (!innerClass.getName().equals(this.getName() + "$" + relativeName)) continue;
            return JavaSourceUtil.getClassInfo(innerClass.getName(), this.getJavaType().getTypeLoader().getModule());
        }
        return null;
    }

    public IJavaClassType resolveImport(String relativeName) {
        return null;
    }
}

