/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.fs.IFile;
import gw.internal.gosu.annotations.AnnotationMap;
import gw.internal.gosu.parser.ClassJavaClassInfo;
import gw.internal.gosu.parser.DefaultTypeLoader;
import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.GosuClassProxyFactory;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IJavaTypeInternal;
import gw.internal.gosu.parser.JavaEnumType;
import gw.internal.gosu.parser.JavaTypeExtensions;
import gw.internal.gosu.parser.JavaTypeInfo;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeVariableType;
import gw.lang.StrictGenerics;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.InnerClassCapableType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuFragment;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaBackedType;
import gw.lang.reflect.java.IJavaBackedTypeData;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.GosuClassUtil;
import gw.util.concurrent.LockingLazyVar;
import gw.util.perf.objectsize.IObjectSizeFilter;
import gw.util.perf.objectsize.ObjectSize;
import gw.util.perf.objectsize.ObjectSizeUtil;
import gw.util.perf.objectsize.UnmodifiableArraySet;
import java.beans.MethodDescriptor;
import java.io.File;
import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class JavaType
extends InnerClassCapableType
implements IJavaTypeInternal {
    private String _strName;
    private IType[] _typeParams;
    protected transient IJavaClassInfo _classInfo;
    private transient ITypeInfo _typeInfo;
    private transient String _strRelativeName;
    private volatile transient Set<IType> _allTypesInHierarchy;
    private transient boolean _bArray;
    private transient boolean _bPrimitive;
    private transient LockingLazyVar<Boolean> _bHasSuperType = new LockingLazyVar<Boolean>(){

        protected Boolean init() {
            return JavaType.this._classInfo.getSuperclass() != null && !JavaType.this._classInfo.getName().equals(AnnotationMap.class.getName());
        }
    };
    private volatile transient IType _superType;
    private transient List<IType> _tempInterfaces;
    private volatile transient IType[] _interfaces;
    private transient IGosuClassInternal _adapterClass;
    private transient GenericTypeVariable[] _tempGenericTypeVars;
    private transient LockingLazyVar<GenericTypeVariable[]> _lazyGenericTypeVars = new LockingLazyVar<GenericTypeVariable[]>(){

        protected GenericTypeVariable[] init() {
            return JavaType.this.assignGenericTypeVariables();
        }
    };
    private transient boolean _bDefiningGenericTypes;
    private transient ConcurrentMap<String, IJavaTypeInternal> _parameterizationByParamsName;
    private volatile transient IJavaTypeInternal _arrayType;
    private IJavaTypeInternal _componentType;
    private transient DefaultTypeLoader _typeLoader;
    private transient boolean _bDoesNotHaveExplicitTypeInfo;
    private Class<?> _explicitTypeInfoClass;
    private transient boolean _bDiscarded;
    private IJavaTypeInternal _typeRef;
    private transient int _tiChecksum;
    private volatile transient List<IJavaType> _innerClasses;
    private transient Boolean _bStrictGenerics;
    private static Set<String> SPECIAL_TYPE_INFO = new HashSet<String>(){
        {
            this.add("gw.lang.ScriptParameters");
            this.add("com.guidewire.studio.api.automation.IAutomatable");
            this.add("gw.datatype.gw.datatype.DataTypes");
            this.add("gw.i18n.ILocale");
            this.add("gw.datatype.DataTypes");
        }
    };

    public static IJavaTypeInternal get(Class cls, DefaultTypeLoader loader) {
        IJavaType type = (IJavaType)TYPES_BY_CLASS.get(cls);
        if (type == null || ((ITypeRef)type)._shouldReload()) {
            TypeSystem.lock();
            try {
                type = (IJavaType)TYPES_BY_CLASS.get(cls);
                if (type == null || ((ITypeRef)type)._shouldReload()) {
                    type = JavaType.define(cls, loader);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return (IJavaTypeInternal)type;
    }

    public static IJavaType getPrimitiveType(String strPrimitiveClassName) {
        return (IJavaType)((Map)TypeLoaderAccess.PRIMITIVE_TYPES_BY_NAME.get()).get(strPrimitiveClassName);
    }

    private static IJavaTypeInternal define(Class cls, DefaultTypeLoader loader) {
        IJavaTypeInternal type;
        if (cls.isEnum()) {
            JavaEnumType rawType = new JavaEnumType((IJavaClassInfo)new ClassJavaClassInfo(cls, loader.getModule()), loader);
            rawType._typeRef = type = (IJavaTypeInternal)TypeSystem.getOrCreateTypeReference((IType)rawType);
        } else {
            JavaType rawType = new JavaType((IJavaClassInfo)new ClassJavaClassInfo(cls, loader.getModule()), loader);
            IJavaTypeInternal extendedType = JavaTypeExtensions.maybeExtendType(rawType);
            rawType._typeRef = type = (IJavaTypeInternal)TypeSystem.getOrCreateTypeReference((IType)extendedType);
        }
        TYPES_BY_CLASS.put(cls, type);
        return type;
    }

    public static IJavaTypeInternal create(IJavaClassInfo cls, DefaultTypeLoader loader) {
        IJavaTypeInternal type;
        if (cls.isEnum()) {
            JavaEnumType rawType = new JavaEnumType(cls, loader);
            rawType._typeRef = type = (IJavaTypeInternal)TypeSystem.getOrCreateTypeReference((IType)rawType);
        } else {
            JavaType rawType = new JavaType(cls, loader);
            IJavaTypeInternal extendedType = JavaTypeExtensions.maybeExtendType(rawType);
            rawType._typeRef = type = (IJavaTypeInternal)TypeSystem.getOrCreateTypeReference((IType)extendedType);
        }
        return type;
    }

    @Override
    public boolean isDefiningGenericTypes() {
        return this._bDefiningGenericTypes;
    }

    @Override
    public GenericTypeVariable[] assignGenericTypeVariables() {
        if (this._typeParams != null && this._typeParams.length > 0) {
            return this.assignTypeVarsFromTypeParams(this._typeParams);
        }
        if (this._classInfo.getTypeParameters().length > 0) {
            this._bDefiningGenericTypes = true;
            try {
                this.assignGenericTypeVarPlaceholders();
                GenericTypeVariable[] genericTypeVariableArray = GenericTypeVariable.convertTypeVars((IType)this.thisRef(), null, this._classInfo.getTypeParameters());
                return genericTypeVariableArray;
            }
            finally {
                this._bDefiningGenericTypes = false;
            }
        }
        return GenericTypeVariable.EMPTY_TYPEVARS;
    }

    private void assignGenericTypeVarPlaceholders() {
        this._tempGenericTypeVars = new GenericTypeVariable[this._classInfo.getTypeParameters().length];
        int n = this._classInfo.getTypeParameters().length;
        for (int i = 0; i < n; ++i) {
            this._tempGenericTypeVars[i] = new GenericTypeVariable(String.valueOf('A') + i, (IType)JavaTypes.OBJECT());
        }
    }

    public JavaType(IJavaClassInfo cls, DefaultTypeLoader loader) {
        this.init(cls, loader);
        this._strName = this.computeQualifiedName();
    }

    private void init(IJavaClassInfo cls, DefaultTypeLoader loader) {
        this._classInfo = cls;
        this._bArray = cls.isArray();
        this._bPrimitive = cls.isPrimitive();
        this._typeLoader = loader;
        this._tiChecksum = TypeSystem.getSingleRefreshChecksum();
        this._strName = this.computeQualifiedName();
    }

    JavaType(Class cls, DefaultTypeLoader loader) {
        this.init(TypeSystem.getJavaClassInfo((Class)cls, (IModule)loader.getModule()), loader);
        this._strName = this.computeQualifiedName();
    }

    private JavaType(IJavaClassInfo cls, IType[] typeParams, DefaultTypeLoader loader) {
        this.init(cls, loader);
        this._typeParams = typeParams;
        this._strName = this.computeQualifiedName();
    }

    private JavaType(IJavaClassInfo arrayClass, IJavaTypeInternal componentType, DefaultTypeLoader loader) {
        this.init(arrayClass, loader);
        this._componentType = componentType;
        this._strName = this.computeQualifiedName();
    }

    public JavaType(IJavaClassInfo classInfo, DefaultTypeLoader loader, IType[] typeParams) {
        this.init(classInfo, loader);
        this._typeParams = typeParams;
        this._strName = this.computeQualifiedName();
    }

    private GenericTypeVariable[] assignTypeVarsFromTypeParams(IType[] typeParams) {
        ArrayList<GenericTypeVariable> genTypeVars = new ArrayList<GenericTypeVariable>();
        for (IType typeParam : typeParams) {
            if (!(typeParam instanceof TypeVariableType)) continue;
            genTypeVars.add((GenericTypeVariable)((TypeVariableType)typeParam).getTypeVarDef().getTypeVar());
        }
        return genTypeVars.toArray(new GenericTypeVariable[genTypeVars.size()]);
    }

    public DefaultTypeLoader getTypeLoader() {
        return this._typeLoader;
    }

    public String getName() {
        return this._strName;
    }

    String computeQualifiedName() {
        if (this.isArray()) {
            IType cType = this.getComponentType();
            return cType.getName() + "[]";
        }
        String strName = this._classInfo.getName().replace('$', '.');
        if (this.isParameterizedType()) {
            strName = strName + TypeLord.getNameOfParams(this._typeParams, false, false);
        }
        return strName;
    }

    public String getDisplayName() {
        return CommonServices.getEntityAccess().getLocalizedTypeName((IType)this.thisRef());
    }

    public String getRelativeName() {
        if (this._strRelativeName != null) {
            return this._strRelativeName;
        }
        if (this.isArray()) {
            return this.getComponentType().getRelativeName() + "[]";
        }
        String strQualifiedClassName = this._classInfo.getName();
        int iDotIndex = strQualifiedClassName.lastIndexOf(46);
        String strRelativeName = strQualifiedClassName.substring(iDotIndex + 1).replace('$', '.');
        if (this.isParameterizedType()) {
            strRelativeName = strRelativeName + TypeLord.getNameOfParams(this._typeParams, true, false);
        }
        this._strRelativeName = strRelativeName;
        return this._strRelativeName;
    }

    public String getNamespace() {
        return this._classInfo.getNamespace();
    }

    public boolean isArray() {
        return this._bArray;
    }

    public boolean isPrimitive() {
        return this._bPrimitive;
    }

    public Object makeArrayInstance(int iLength) {
        Class intrinsicClass = this.getIntrinsicClass();
        if (intrinsicClass == null) {
            boolean bl = false;
        }
        return Array.newInstance(intrinsicClass, iLength);
    }

    public boolean isAssignableFrom(IType type) {
        boolean isAssignable;
        if (TypeSystem.isDeleted((IType)type)) {
            return false;
        }
        IJavaTypeInternal pThis = this.thisRef();
        if (type == pThis) {
            return true;
        }
        if (type == null) {
            return false;
        }
        if (this.getBackingClassInfo().getName().equals(Object.class.getName())) {
            return type == JavaTypes.pVOID() || !type.isPrimitive();
        }
        if (this.isArray() && type.isArray()) {
            return this.getComponentType().isPrimitive() == type.getComponentType().isPrimitive() && this.getComponentType().isAssignableFrom(type.getComponentType());
        }
        if (this.isArray()) {
            return false;
        }
        if (this.isInterface() && type instanceof IGosuClass && ((IGosuClass)type).isStructure()) {
            return false;
        }
        Set allTypesInHierarchy = type.getAllTypesInHierarchy();
        boolean bl = isAssignable = allTypesInHierarchy != null && allTypesInHierarchy.contains(pThis);
        if (!isAssignable) {
            isAssignable = TypeLord.areGenericOrParameterizedTypesAssignable((IType)pThis, type);
        }
        return isAssignable || this.isAssignableFromJavaBackedType(type);
    }

    private boolean isAssignableFromJavaBackedType(IType type) {
        boolean isAssignable = false;
        if (!(type instanceof IJavaTypeInternal) && type instanceof IJavaBackedTypeData && !(type instanceof IGosuFragment)) {
            IJavaClassInfo backingClassInfo = ((IJavaBackedTypeData)type).getBackingClassInfo();
            isAssignable = backingClassInfo != null && this.getBackingClassInfo().isAssignableFrom(backingClassInfo);
        }
        return isAssignable;
    }

    public boolean isMutable() {
        return true;
    }

    public Class getIntrinsicClass() {
        return this._classInfo.getBackingClass();
    }

    public IJavaClassInfo getBackingClassInfo() {
        return this._classInfo;
    }

    public Class getBackingClass() {
        return this.getIntrinsicClass();
    }

    public ITypeInfo getTypeInfo() {
        IType reResolveByFullName;
        if (ExecutionMode.isIDE() && TypeSystem.getJreModule() != TypeSystem.getGlobalModule() && !this.getTypeLoader().getModule().equals(TypeSystem.getCurrentModule()) && (reResolveByFullName = TypeSystem.getByFullNameIfValid((String)this.getName())) != null && !this.equals(reResolveByFullName)) {
            return reResolveByFullName.getTypeInfo();
        }
        ITypeInfo typeInfo = this._typeInfo;
        if (typeInfo == null || this.hasAncestorBeenUpdated()) {
            TypeSystem.lock();
            try {
                typeInfo = this._typeInfo;
                if (typeInfo == null || this.hasAncestorBeenUpdated()) {
                    this._typeInfo = typeInfo = this.loadTypeInfo();
                    if (!this.isParameterizedType() && this._adapterClass != null && JavaType.haveAncestorsBeenUpdated(this, this._adapterClass.getTypeInfoChecksum(), new HashSet<IType>())) {
                        this._adapterClass = this.createAdapterClass();
                    }
                    this._tiChecksum = TypeSystem.getSingleRefreshChecksum();
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return typeInfo;
    }

    @Override
    public IGosuClassInternal getAdapterClass() {
        if (this.isParameterizedType()) {
            return this.getGenericType().getAdapterClass();
        }
        if (this._adapterClass == null) {
            return null;
        }
        if (this._adapterClass.isStale()) {
            this._adapterClass = this.createAdapterClass();
            return this._adapterClass;
        }
        if (JavaType.haveAncestorsBeenUpdated(this, this._adapterClass.getTypeInfoChecksum(), new HashSet<IType>())) {
            this._typeInfo = null;
            this._tiChecksum = TypeSystem.getSingleRefreshChecksum();
            this._adapterClass = this.createAdapterClass();
        }
        return this._adapterClass;
    }

    @Override
    public IGosuClassInternal getAdapterClassDirectly() {
        return this._adapterClass;
    }

    private ITypeInfo loadTypeInfo() {
        ITypeInfo typeInfo = this.getExplicitTypeInfo();
        if (typeInfo == null) {
            typeInfo = this.convertToTypeInfo();
        }
        return typeInfo;
    }

    public void unloadTypeInfo() {
        TypeSystem.lock();
        try {
            if (this._parameterizationByParamsName != null) {
                for (IJavaType parameteredClass : new ArrayList(this._parameterizationByParamsName.values())) {
                    parameteredClass.unloadTypeInfo();
                }
                this._parameterizationByParamsName.clear();
            }
            if (this._adapterClass != null) {
                this._adapterClass.unloadTypeInfo();
            }
            if (this._arrayType != null) {
                this._arrayType.unloadTypeInfo();
            }
            this._lazyGenericTypeVars.clearNoLock();
            this._allTypesInHierarchy = null;
            this._typeInfo = null;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public boolean isInterface() {
        return this._classInfo.isInterface();
    }

    public boolean isEnum() {
        return this._classInfo.isEnum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IType[] getInterfaces() {
        if (this._interfaces != null) {
            return this._interfaces;
        }
        TypeSystem.lock();
        try {
            ArrayList<IType> interfaces;
            IJavaClassType[] genericInterfaces;
            boolean bReentered;
            if (this._interfaces != null) {
                IType[] iTypeArray = this._interfaces;
                return iTypeArray;
            }
            boolean bl = bReentered = this._tempInterfaces != null;
            if (!bReentered) {
                this._tempInterfaces = new ArrayList<IType>();
            }
            if ((genericInterfaces = this._classInfo.getGenericInterfaces()).length == 0) {
                interfaces = EMPTY_TYPE_LIST;
            } else {
                IJavaClassInfo[] notParameterizedInterfaces = this._classInfo.getInterfaces();
                if (notParameterizedInterfaces.length != genericInterfaces.length) {
                    throw new RuntimeException("There should be as many generic interface as non-parameterized interfaces.");
                }
                interfaces = new ArrayList<IType>(genericInterfaces.length);
                for (int i = this._tempInterfaces.size(); i < genericInterfaces.length; ++i) {
                    IType parameterizedIface;
                    IJavaClassType interfaceType = genericInterfaces[i];
                    IType notParameterizedInterface = notParameterizedInterfaces[i].getJavaType();
                    if (notParameterizedInterface == null) {
                        throw new NullPointerException("notParameterizedInterface java type is null for " + notParameterizedInterfaces[i]);
                    }
                    this._tempInterfaces.add(notParameterizedInterface);
                    if (!this.isParameterizedType() && interfaceType instanceof IJavaClassInfo && !notParameterizedInterface.isGenericType()) {
                        interfaces.add(notParameterizedInterface);
                        continue;
                    }
                    TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName((IType)this.thisRef(), (IType)this.thisRef());
                    if (actualParamByVarName.isEmpty()) {
                        actualParamByVarName = TypeLord.mapTypeByVarName(notParameterizedInterface, notParameterizedInterface);
                    }
                    if ((parameterizedIface = interfaceType.getActualType(actualParamByVarName, true)).isGenericType() && !parameterizedIface.isParameterizedType()) {
                        parameterizedIface = TypeLord.getDefaultParameterizedType(parameterizedIface);
                    }
                    interfaces.add(parameterizedIface);
                    this._tempInterfaces.remove(notParameterizedInterface);
                    this._tempInterfaces.add(parameterizedIface);
                }
            }
            if (bReentered) {
                IType[] iTypeArray = this._tempInterfaces.toArray(new IType[this._tempInterfaces.size()]);
                return iTypeArray;
            }
            this._tempInterfaces = null;
            interfaces.trimToSize();
            this._interfaces = interfaces.toArray(new IType[interfaces.size()]);
        }
        finally {
            TypeSystem.unlock();
        }
        return this._interfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IType getSupertype() {
        if (!((Boolean)this._bHasSuperType.get()).booleanValue()) {
            return null;
        }
        if (this._superType != null) {
            return this.notDeletedSupertype();
        }
        TypeSystem.lock();
        try {
            IJavaType notParameterizedSuperType;
            if (this._superType != null) {
                IType iType = this.notDeletedSupertype();
                return iType;
            }
            IJavaClassInfo superclass = this._classInfo.getSuperclass();
            if (superclass != null) {
                IType superType = superclass.getJavaType();
                if (superType instanceof IErrorType) {
                    IErrorType iErrorType = TypeSystem.getErrorType();
                    return iErrorType;
                }
                notParameterizedSuperType = (IJavaType)superType;
            } else {
                notParameterizedSuperType = this._classInfo != null ? (IJavaType)TypeSystem.get((IJavaClassInfo)this._classInfo.getSuperclass()) : JavaTypes.OBJECT();
            }
            this._superType = notParameterizedSuperType;
            IJavaClassType genericSuperclass = this._classInfo.getGenericSuperclass();
            if (genericSuperclass instanceof IJavaClassInfo) {
                if (this._classInfo.isEnum()) {
                    this._superType = this._superType.getParameterizedType(new IType[]{this.thisRef()});
                }
                IType iType = this.notDeletedSupertype();
                return iType;
            }
            TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName((IType)this.thisRef(), (IType)this.thisRef());
            if (actualParamByVarName.isEmpty()) {
                actualParamByVarName = TypeLord.mapTypeByVarName((IType)notParameterizedSuperType, (IType)notParameterizedSuperType);
            }
            if (genericSuperclass != null) {
                this._superType = genericSuperclass.getActualType(actualParamByVarName, true);
            }
        }
        finally {
            TypeSystem.unlock();
        }
        return this.notDeletedSupertype();
    }

    private IType notDeletedSupertype() {
        if (TypeSystem.isDeleted((IType)this._superType)) {
            this._superType = TypeSystem.getErrorType();
        }
        return this._superType.isGenericType() && !this._superType.isParameterizedType() ? TypeLord.getDefaultParameterizedType(this._superType) : this._superType;
    }

    public List<IJavaType> getInnerClasses() {
        if (this._innerClasses != null) {
            return this._innerClasses;
        }
        IJavaClassInfo[] innerClasses = this.getBackingClassInfo().getDeclaredClasses();
        if (innerClasses.length == 0) {
            this._innerClasses = Collections.emptyList();
            return this._innerClasses;
        }
        ArrayList<IJavaType> inners = new ArrayList<IJavaType>(2);
        for (IJavaClassInfo c : innerClasses) {
            String name = c.getName().replace('$', '.');
            IJavaType inner = this._typeLoader.getInnerType(name);
            if (inner == null) {
                throw new IllegalStateException("Cannot load inner class " + name);
            }
            inners.add(inner);
        }
        this._innerClasses = inners;
        return this._innerClasses;
    }

    public IType getInnerClass(CharSequence name) {
        IJavaTypeInternal innerClass;
        if (name == null) {
            return null;
        }
        String strRelativeName = name.toString();
        int dotIndex = strRelativeName.indexOf(46);
        if (dotIndex == -1) {
            innerClass = this.getInnerClassSimple(strRelativeName);
        } else {
            innerClass = this.getInnerClassSimple(strRelativeName.substring(0, dotIndex));
            if (innerClass != null) {
                innerClass = (IJavaTypeInternal)innerClass.getInnerClass(strRelativeName.substring(dotIndex + 1, strRelativeName.length()));
            }
        }
        return innerClass;
    }

    private IJavaTypeInternal getInnerClassSimple(String simpleName) {
        JavaType enclosingType = this;
        for (IJavaType javaType : enclosingType.getInnerClasses()) {
            if (!GosuClassUtil.getNameNoPackage((String)javaType.getRelativeName()).equals(simpleName)) continue;
            return (IJavaTypeInternal)javaType;
        }
        return null;
    }

    public ISourceFileHandle getSourceFileHandle() {
        return this._classInfo.getSourceFileHandle();
    }

    public List<? extends IType> getLoadedInnerClasses() {
        return this.getInnerClasses();
    }

    public ClassType getClassType() {
        return ClassType.JavaClass;
    }

    public IType getEnclosingType() {
        return this._classInfo.getEnclosingType();
    }

    public IJavaTypeInternal getGenericType() {
        if (this.isParameterizedType()) {
            return (IJavaTypeInternal)TypeSystem.get((IJavaClassInfo)this._classInfo, (IModule)this.getTypeLoader().getModule());
        }
        if (this.isGenericType()) {
            return this.thisRef();
        }
        return null;
    }

    public boolean isFinal() {
        return Modifier.isFinal(this._classInfo.getModifiers());
    }

    public boolean isParameterizedType() {
        return this._typeParams != null && this._typeParams.length > 0;
    }

    public boolean isGenericType() {
        return this._bDefiningGenericTypes || this._lazyGenericTypeVars.get() != null && ((GenericTypeVariable[])this._lazyGenericTypeVars.get()).length > 0;
    }

    public GenericTypeVariable[] getGenericTypeVariables() {
        if (!this.isGenericType()) {
            return null;
        }
        if (this._bDefiningGenericTypes) {
            return this._tempGenericTypeVars;
        }
        return (GenericTypeVariable[])this._lazyGenericTypeVars.get();
    }

    public IType[] getTypeParameters() {
        return this._typeParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IType getParameterizedType(IType ... paramTypes) {
        String strNameOfParams;
        IJavaTypeInternal parameterizedType;
        if (paramTypes == null || paramTypes.length == 0) {
            throw new IllegalArgumentException("Parameter types required.");
        }
        if (this.isParameterizedType()) {
            return TypeLord.getPureGenericType(this.thisRef()).getParameterizedType(paramTypes);
        }
        if (this._parameterizationByParamsName == null) {
            TypeSystem.lock();
            try {
                if (this._parameterizationByParamsName == null) {
                    this._parameterizationByParamsName = new ConcurrentHashMap<String, IJavaTypeInternal>(2);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        if ((parameterizedType = (IJavaTypeInternal)this._parameterizationByParamsName.get(strNameOfParams = TypeLord.getNameOfParams(paramTypes = TypeSystem.boxPrimitiveTypeParams((IType[])paramTypes), false, true, true))) == null) {
            TypeSystem.lock();
            try {
                parameterizedType = (IJavaTypeInternal)this._parameterizationByParamsName.get(strNameOfParams);
                if (parameterizedType == null) {
                    parameterizedType = this._classInfo != null ? (IJavaTypeInternal)TypeSystem.getOrCreateTypeReference((IType)new JavaType(this._classInfo, paramTypes, this._typeLoader)) : (IJavaTypeInternal)TypeSystem.getOrCreateTypeReference((IType)new JavaType(this._classInfo, this.getTypeLoader(), paramTypes));
                    this._parameterizationByParamsName.put(strNameOfParams, parameterizedType);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return parameterizedType;
    }

    public Set<IType> getAllTypesInHierarchy() {
        if (this._allTypesInHierarchy != null) {
            return this._allTypesInHierarchy;
        }
        TypeSystem.lock();
        try {
            if (this._allTypesInHierarchy != null) {
                Set<IType> set = this._allTypesInHierarchy;
                return set;
            }
            if (this._classInfo.isArray()) {
                Set<IType> types = TypeLord.getAllClassesInClassHierarchyAsIntrinsicTypes(this._classInfo);
                types.addAll(new HashSet<IType>(TypeLord.getArrayVersionsOfEachType(this.getComponentType().getAllTypesInHierarchy())));
                this._allTypesInHierarchy = new UnmodifiableArraySet(types);
            } else {
                this._allTypesInHierarchy = TypeLord.getAllClassesInClassHierarchyAsIntrinsicTypes(this._classInfo);
                HashSet<IType> includeGenericTypes = new HashSet<IType>(this._allTypesInHierarchy);
                this.addGenericTypes((IType)this.thisRef(), includeGenericTypes);
                this._allTypesInHierarchy = new UnmodifiableArraySet(includeGenericTypes);
            }
        }
        finally {
            TypeSystem.unlock();
        }
        return this._allTypesInHierarchy;
    }

    private void addGenericTypes(IType type, Set<IType> includeGenericTypes) {
        if (type == null) {
            return;
        }
        if (type.isGenericType() || type.isParameterizedType()) {
            TypeLord.addAllClassesInClassHierarchy(type, includeGenericTypes, true);
        } else {
            this.addGenericTypes(type.getSupertype(), includeGenericTypes);
            IType[] interfaces = type.getInterfaces();
            if (interfaces != null) {
                for (IType iface : interfaces) {
                    this.addGenericTypes(iface, includeGenericTypes);
                }
            }
        }
    }

    private IJavaTypeInternal thisRef() {
        if (this._typeRef == null) {
            ITypeRef ref = TypeSystem.getOrCreateTypeReference((IType)this);
            try {
                this._typeRef = (IJavaTypeInternal)ref;
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Could not reresolve the java type " + this.getName() + ".\n" + "The actual type of the reference was " + ref.getClass(), e);
            }
        }
        return this._typeRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IType getArrayType() {
        block13: {
            if (this._arrayType == null) {
                TypeSystem.lock();
                try {
                    if (this._arrayType != null) break block13;
                    IJavaTypeInternal thisRef = this.thisRef();
                    IModule module = this.getTypeLoader().getModule();
                    if (module != null) {
                        TypeSystem.pushModule((IModule)this.getTypeLoader().getModule());
                    }
                    try {
                        boolean bParameterized = TypeLord.getCoreType((IType)thisRef).isParameterizedType();
                        if (this._classInfo != null) {
                            IJavaClassInfo arrayClass = this._classInfo.getArrayType();
                            if (bParameterized) {
                                this._arrayType = new JavaType(arrayClass, thisRef, this._typeLoader).thisRef();
                            } else {
                                this._arrayType = JavaType.create(arrayClass, this._typeLoader);
                                this._arrayType.setComponentType(thisRef);
                            }
                        } else {
                            this._arrayType = bParameterized ? new JavaType(this._classInfo.getArrayType(), this.getTypeLoader(), this.getTypeParameters()).thisRef() : new JavaType(this._classInfo.getArrayType(), this.getTypeLoader()).thisRef();
                        }
                    }
                    finally {
                        if (module != null) {
                            TypeSystem.popModule((IModule)module);
                        }
                    }
                }
                finally {
                    TypeSystem.unlock();
                }
            }
        }
        return this._arrayType;
    }

    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return Array.get(array, iIndex);
    }

    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        try {
            Array.set(array, iIndex, value);
        }
        catch (IllegalArgumentException ex) {
            HashSet<Class> interfaces = new HashSet<Class>();
            if (value != null) {
                this.getInterfaces(value.getClass(), interfaces);
            }
            throw new IllegalArgumentException("array element type mismatch.  Expected an element of type " + (array == null ? "<null>" : array.getClass()) + " got " + interfaces);
        }
    }

    private void getInterfaces(Class clazz, Set<Class> classes) {
        if (clazz == null || classes.contains(clazz)) {
            return;
        }
        classes.add(clazz);
        this.getInterfaces(clazz.getSuperclass(), classes);
        for (Class<?> aClass : clazz.getInterfaces()) {
            this.getInterfaces(aClass, classes);
        }
    }

    public int getArrayLength(Object array) throws IllegalArgumentException {
        return Array.getLength(array);
    }

    public IType getComponentType() {
        IModule module = this.getTypeLoader().getModule();
        TypeSystem.pushModule((IModule)module);
        try {
            if (this.isArray()) {
                if (this._componentType == null) {
                    IType type = TypeSystem.get((IJavaClassInfo)this._classInfo.getComponentType());
                    this._componentType = (IJavaTypeInternal)type;
                }
                IJavaTypeInternal iJavaTypeInternal = this._componentType;
                return iJavaTypeInternal;
            }
            IType iType = null;
            return iType;
        }
        finally {
            TypeSystem.popModule((IModule)module);
        }
    }

    @Override
    public void setComponentType(IJavaTypeInternal componentType) {
        this._componentType = componentType;
    }

    @Override
    public int getTypeInfoChecksum() {
        if (this.isParameterizedType()) {
            return this.getGenericType().getTypeInfoChecksum();
        }
        return this._tiChecksum;
    }

    @Override
    public boolean hasAncestorBeenUpdated() {
        if (!ExecutionMode.get().isRefreshSupportEnabled()) {
            return false;
        }
        return JavaType.haveAncestorsBeenUpdated(this, this._tiChecksum, new HashSet<IType>());
    }

    private static boolean haveAncestorsBeenUpdated(IJavaTypeInternal type, int tiChecksum, Set<IType> visited) {
        if (!ExecutionMode.get().isRefreshSupportEnabled()) {
            return false;
        }
        IType supertype = type.getSupertype();
        if (supertype instanceof IJavaTypeInternal && !visited.contains(supertype) && JavaType.hasBeenUpdated((IJavaTypeInternal)supertype, tiChecksum, visited)) {
            return true;
        }
        for (IType anInterface : type.getInterfaces()) {
            IJavaTypeInternal iFace;
            if (!(anInterface instanceof IJavaTypeInternal) || visited.contains(iFace = (IJavaTypeInternal)anInterface) || !JavaType.hasBeenUpdated(iFace, tiChecksum, visited)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBeenUpdated(IJavaTypeInternal type, int tiChecksum, Set<IType> visited) {
        if (!ExecutionMode.get().isRefreshSupportEnabled()) {
            return false;
        }
        visited.add((IType)type);
        if (TypeSystem.isDeleted((IType)type)) {
            return true;
        }
        return type.getTypeInfoChecksum() > tiChecksum || JavaType.haveAncestorsBeenUpdated(type, tiChecksum, visited);
    }

    @Override
    public Object writeReplace() {
        this.getName();
        return this;
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            int iIndex = this._strName.indexOf(60);
            if (iIndex > 0) {
                String strGenName = this._strName.substring(0, iIndex);
                IType type = TypeLoaderAccess.instance().getIntrinsicTypeByFullName(strGenName);
                return type.getParameterizedType(this._typeParams);
            }
            return TypeLoaderAccess.instance().getIntrinsicTypeByFullName(this._strName);
        }
        catch (ClassNotFoundException cnfe) {
            if (this._strName.endsWith("Exception")) {
                System.out.println("Exception subclass not found: " + this._strName + ". Substituting with Exception.class.");
                return JavaTypes.EXCEPTION();
            }
            throw new InvalidClassException(this._strName, cnfe.getMessage());
        }
    }

    public boolean isValid() {
        return true;
    }

    public int getModifiers() {
        return this._classInfo.getModifiers();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this._classInfo.getModifiers());
    }

    public boolean equals(Object o) {
        return this.thisRef() == o;
    }

    public int hashCode() {
        return this._classInfo.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ITypeInfo getExplicitTypeInfo() {
        if (this._bDoesNotHaveExplicitTypeInfo) {
            return null;
        }
        if (CommonServices.getEntityAccess().getLanguageLevel().isStandard()) {
            this._bDoesNotHaveExplicitTypeInfo = true;
            return null;
        }
        String name = this.getName();
        if (!Character.isLetter(name.charAt(name.length() - 1))) {
            this._bDoesNotHaveExplicitTypeInfo = true;
            return null;
        }
        try {
            if (SPECIAL_TYPE_INFO.contains(name)) {
                if (this._explicitTypeInfoClass == null) {
                    this._explicitTypeInfoClass = CommonServices.getEntityAccess().getPluginClassLoader().loadClass(name + "TypeInfo");
                }
                return (ITypeInfo)this._explicitTypeInfoClass.newInstance();
            }
            this._bDoesNotHaveExplicitTypeInfo = true;
            return null;
        }
        catch (Throwable t) {
            if (t instanceof ClassNotFoundException) {
                this._bDoesNotHaveExplicitTypeInfo = true;
                return null;
            }
            throw new RuntimeException(t);
        }
    }

    private ITypeInfo convertToTypeInfo() {
        return new JavaTypeInfo((IType)this.thisRef(), this._classInfo);
    }

    @Override
    public void setAdapterClass(IGosuClassInternal adapterClass) {
        if (this.isParameterizedType()) {
            this.getGenericType().setAdapterClass(adapterClass);
            return;
        }
        this._adapterClass = adapterClass;
    }

    public IGosuClassInternal createAdapterClass() {
        if (this.isParameterizedType()) {
            return (IGosuClassInternal)this.getGenericType().createAdapterClass();
        }
        this._adapterClass = GosuClassProxyFactory.instance().createImmediately((IType)this.thisRef());
        return this._adapterClass;
    }

    public static IJavaType[] convertClassArray(Class[] args) {
        IJavaType[] returnArray = new IJavaType[args.length];
        for (int i = 0; i < args.length; ++i) {
            returnArray[i] = (IJavaType)TypeSystem.get((Class)args[i]);
        }
        return returnArray;
    }

    public static void unloadTypes() {
        Collection types = TYPES_BY_CLASS.values();
        for (IJavaType type : types) {
            type.unloadTypeInfo();
        }
        TYPES_BY_CLASS.clear();
    }

    public boolean isDiscarded() {
        return this._bDiscarded;
    }

    public void setDiscarded(boolean bDiscarded) {
        this._bDiscarded = bDiscarded;
    }

    public boolean isCompoundType() {
        return false;
    }

    public Set<IType> getCompoundTypeComponents() {
        return null;
    }

    public IJavaClassInfo getConcreteClass() {
        return this._classInfo;
    }

    public IType getTypeFromJavaBackedType() {
        return TypeSystem.getTypeFromJavaBasedType((IJavaBackedType)this.thisRef());
    }

    public ObjectSize getRetainedMemory() {
        return ObjectSizeUtil.deepSizeOf((Object)this, (IObjectSizeFilter)new IObjectSizeFilter(){

            public boolean skipField(Field field) {
                return field.getType().equals(Class.class) || field.getType().equals(MethodDescriptor.class) || field.getName().equals("_typeLoader") || field.getName().equals("_container");
            }

            public boolean skipObject(Object obj) {
                Class<?> objClass = obj.getClass();
                return objClass.equals(Class.class) || obj instanceof IType && obj != JavaType.this || obj instanceof IModule || obj.getClass().getName().startsWith("org.eclipse") || obj.getClass().getName().startsWith("java.lang.reflect") || obj.getClass().getName().startsWith("java.beans") || obj instanceof IJavaClassInfo && obj != JavaType.this._classInfo;
            }
        }, (int)100000);
    }

    public IType[] getLoaderParameterizedTypes() {
        if (this._parameterizationByParamsName != null) {
            Collection values = this._parameterizationByParamsName.values();
            return values.toArray(new IType[values.size()]);
        }
        return IType.EMPTY_ARRAY;
    }

    public boolean isStrictGenerics() {
        if (this._bStrictGenerics != null) {
            return this._bStrictGenerics;
        }
        this._bStrictGenerics = this.getBackingClass() != null && Arrays.stream(this.getBackingClass().getAnnotations()).anyMatch(anno -> anno.getClass() == StrictGenerics.class);
        return this._bStrictGenerics;
    }

    public IFile[] getSourceFiles() {
        if (this.getSourceFileHandle() == null) {
            return IFile.EMPTY_ARRAY;
        }
        File file = new File(this.getSourceFileHandle().getFilePath());
        return new IFile[]{CommonServices.getFileSystem().getIFile(file)};
    }

    public boolean isAnnotation() {
        return this._classInfo.isAnnotation();
    }

    protected IType getTheRef() {
        return this.thisRef();
    }
}

