/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.BaseService;
import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.internal.gosu.compiler.SingleServingGosuClassLoader;
import gw.internal.gosu.module.Module;
import gw.internal.gosu.parser.AbstractTypeRef;
import gw.internal.gosu.parser.ClassJavaClassInfo;
import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.DefaultTypeLoader;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.ExecutionEnvironment;
import gw.internal.gosu.parser.FrequentUsedJavaTypeCache;
import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.GosuClassCompilingStack;
import gw.internal.gosu.parser.GosuClassTypeInfo;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IJavaTypeInternal;
import gw.internal.gosu.parser.ITypeLoaderStackInternal;
import gw.internal.gosu.parser.JavaType;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.ModuleTypeLoader;
import gw.internal.gosu.parser.RuntimeExceptionWithNoStacktrace;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeRefFactory;
import gw.internal.gosu.parser.TypeVariableType;
import gw.lang.GosuShop;
import gw.lang.gosuc.Gosuc;
import gw.lang.gosuc.ICustomParser;
import gw.lang.gosuc.IGosuc;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.ICompoundType;
import gw.lang.reflect.IDefaultTypeLoader;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.INonLoadableType;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.ITypeLoaderListener;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.ITypeSystem;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.NoReferenceFoundException;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.TypeSystemShutdownListener;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuClassLoader;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IJreModule;
import gw.lang.reflect.module.IModule;
import gw.lang.reflect.module.IProject;
import gw.lang.reflect.module.ITypeLoaderStack;
import gw.util.GosuExceptionUtil;
import gw.util.IdentitySet;
import gw.util.concurrent.LockingLazyVar;
import java.io.FileNotFoundException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class TypeLoaderAccess
extends BaseService
implements ITypeSystem {
    private Map<IType, IType> _boxToPrimitiveMap;
    private Map<IType, IType> _primitiveToBoxMap;
    public static LockingLazyVar<Map<String, IJavaType>> PRIMITIVE_TYPES_BY_NAME = new LockingLazyVar<Map<String, IJavaType>>(){

        protected Map<String, IJavaType> init() {
            HashMap<String, IJavaType> returnMap = new HashMap<String, IJavaType>(9);
            returnMap.put("byte", JavaTypes.pBYTE());
            returnMap.put("char", JavaTypes.pCHAR());
            returnMap.put("double", JavaTypes.pDOUBLE());
            returnMap.put("float", JavaTypes.pFLOAT());
            returnMap.put("int", JavaTypes.pINT());
            returnMap.put("long", JavaTypes.pLONG());
            returnMap.put("short", JavaTypes.pSHORT());
            returnMap.put("boolean", JavaTypes.pBOOLEAN());
            returnMap.put("void", JavaTypes.pVOID());
            return returnMap;
        }
    };
    private static final Map<CharSequence, TypeGetter> EMPTY_DEFAULT_TYPES = new HashMap<CharSequence, TypeGetter>();
    private static final ThreadLocal<ArrayList<IModule>> g_moduleStack = new ThreadLocal();
    private int _iRefreshChecksum = 0;
    private int _iSingleRefreshChecksum = 0;
    private Map<CharSequence, TypeGetter> _defaultTypes;
    private boolean _defaultTypesIniting = false;
    private final CopyOnWriteArrayList<WeakReference<ITypeLoaderListener>> _listeners;
    private final List<TypeSystemShutdownListener> _shutdownListeners = new ArrayList<TypeSystemShutdownListener>();
    private final ArgCallable<IType, String> getNamespaceTypeIfValid_Callable = new ArgCallable<IType, String>(){

        @Override
        public IType call(String strNamespace) throws Exception {
            return TypeLoaderAccess.this.getCurrentModuleTypeLoader().getNamespaceType(strNamespace);
        }
    };
    private final ArgCallable<IType, Object> getIntrinsicTypeFromObject_Callable = new ArgCallable<IType, Object>(){

        @Override
        public IType call(Object object) throws Exception {
            return TypeLoaderAccess.this.getCurrentModuleTypeLoader().getIntrinsicTypeFromObject(object);
        }
    };

    public static TypeLoaderAccess instance() {
        return (TypeLoaderAccess)CommonServices.getTypeSystem();
    }

    private ModuleTypeLoader getCurrentModuleTypeLoader() {
        Module module = this.getCurrentModule();
        return module == null ? null : module.getModuleTypeLoader();
    }

    public Module getCurrentModule() {
        if (!ExecutionMode.isIDE() || TypeSystem.getJreModule() == TypeSystem.getGlobalModule()) {
            return (Module)TypeSystem.getGlobalModule();
        }
        ArrayList<IModule> list = g_moduleStack.get();
        if (list != null && !list.isEmpty()) {
            return (Module)list.get(list.size() - 1);
        }
        return null;
    }

    public void pushModule(IModule module) {
        if (module == null) {
            throw new IllegalStateException("Attempted to push NULL module on Gosu module stack:");
        }
        ArrayList<Object> list = g_moduleStack.get();
        if (list == null) {
            list = new ArrayList();
            g_moduleStack.set(list);
        }
        list.add(module);
    }

    public void popModule(IModule module) {
        List list = g_moduleStack.get();
        if (list == null) {
            return;
        }
        if (list.size() == 0) {
            throw new IllegalStateException("Tried to pop a module when module stack was empty:\nTried: " + module);
        }
        int last = list.size() - 1;
        IModule remove = (IModule)list.get(last);
        if (module != remove) {
            throw new IllegalStateException("Tried to pop a module that was not at the top of the stack.\nTried: " + module + "  Current: " + Arrays.toString(list.toArray()));
        }
        list.remove(last);
    }

    public TypeLoaderAccess() {
        this._listeners = new CopyOnWriteArrayList();
        this.addShutdownListener(new TypeSystemShutdownListener(){

            public void shutdown() {
                GosuShop.clearThreadLocal((ThreadLocal)g_moduleStack);
            }
        });
    }

    public IGosuc makeGosucCompiler(String gosucProjectFile, ICustomParser custParser) {
        try {
            return new Gosuc(gosucProjectFile, custParser);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public IType getDefaultType(String name) {
        TypeGetter getter = this.getDefaultTypes().get(name);
        return getter != null ? getter.get() : null;
    }

    public boolean isParameterizedWith(IType type, ITypeVariableType ... typeVars) {
        if (typeVars == null) {
            return false;
        }
        for (ITypeVariableType tv : typeVars) {
            if (!type.equals(tv) && !TypeLord.isParameterizedWith(type, (TypeVariableType)tv)) continue;
            return true;
        }
        return false;
    }

    Map<CharSequence, TypeGetter> getDefaultTypes() {
        if (this._defaultTypesIniting) {
            return EMPTY_DEFAULT_TYPES;
        }
        if (this._defaultTypes == null) {
            this._defaultTypesIniting = true;
            HashMap<CharSequence, TypeGetter> defaultTypes = new HashMap<CharSequence, TypeGetter>();
            TypeLoaderAccess.getDefaultTypes(defaultTypes);
            this._defaultTypes = defaultTypes;
            this._defaultTypesIniting = false;
        }
        return this._defaultTypes;
    }

    public List<ITypeLoader> getAllTypeLoaders() {
        IModule[] moduleTraversalList;
        ArrayList<ITypeLoader> loaders = new ArrayList<ITypeLoader>();
        for (IModule module : moduleTraversalList = TypeLoaderAccess.getExecutionEnv().getGlobalModule().getModuleTraversalList()) {
            loaders.addAll(module.getModuleTypeLoader().getTypeLoaderStack());
        }
        return loaders;
    }

    public void pushTypeLoader(IModule module, ITypeLoader typeLoader) {
        if (module == null && (module = this.getCurrentModule()) == null) {
            throw new IllegalStateException("There is no current module. If you are not running/testing the Eclipse Gosu Plugin, maybe ExecutionEnvironment.initDefault() was not called first?");
        }
        ((Module)module).getModuleTypeLoader().pushTypeLoader(typeLoader);
    }

    public void removeTypeLoader(Class<? extends ITypeLoader> loaderType) {
        for (IModule iModule : TypeLoaderAccess.getExecutionEnv().getModules()) {
            ((ModuleTypeLoader)iModule.getModuleTypeLoader()).removeTypeLoader(loaderType);
        }
    }

    private List<ITypeLoaderListener> getListeners() {
        ArrayList<ITypeLoaderListener> listeners = new ArrayList<ITypeLoaderListener>(this._listeners.size());
        ArrayList<WeakReference<ITypeLoaderListener>> obsoleteListeners = null;
        for (WeakReference<ITypeLoaderListener> ref : this._listeners) {
            ITypeLoaderListener typeLoaderListener = (ITypeLoaderListener)ref.get();
            if (typeLoaderListener != null) {
                listeners.add(typeLoaderListener);
                continue;
            }
            if (obsoleteListeners == null) {
                obsoleteListeners = new ArrayList<WeakReference<ITypeLoaderListener>>();
            }
            obsoleteListeners.add(ref);
        }
        if (obsoleteListeners != null) {
            this._listeners.removeAll(obsoleteListeners);
        }
        return listeners;
    }

    public ITypeRef getTypeReference(IType type) {
        ITypeLoader typeLoader = type.getTypeLoader();
        ITypeRef ref = typeLoader.getModule().getModuleTypeLoader().getTypeRefFactory().get(type);
        if (ref == null) {
            throw new NoReferenceFoundException(type);
        }
        return ref;
    }

    public ITypeRef getOrCreateTypeReference(IType type) {
        ITypeLoader typeLoader = type.getTypeLoader();
        return typeLoader.getModule().getModuleTypeLoader().getTypeRefFactory().create(type);
    }

    public <T extends ITypeLoader> T getTypeLoader(Class<? extends T> loaderType, IModule module) {
        return ((Module)module).getModuleTypeLoader().getTypeLoader(loaderType);
    }

    public INamespaceType getNamespace(String strFqNamespace) {
        for (int i = 0; i < strFqNamespace.length(); ++i) {
            char ch = strFqNamespace.charAt(i);
            if (Character.isJavaIdentifierPart(ch) || ch == '.' || ch == '*') continue;
            return null;
        }
        IType namespaceType = this.returnFirstNonNull(this.getNamespaceTypeIfValid_Callable, strFqNamespace);
        if (namespaceType instanceof INamespaceType) {
            return (INamespaceType)namespaceType;
        }
        return null;
    }

    public IType getIntrinsicTypeFromObject(Object object) {
        return this.returnFirstNonNull(this.getIntrinsicTypeFromObject_Callable, object);
    }

    public IType getIntrinsicTypeByFullName(String fullyQualifiedName) throws ClassNotFoundException {
        IJavaType type = FrequentUsedJavaTypeCache.instance(TypeLoaderAccess.getExecutionEnv()).getHighUsageType(fullyQualifiedName);
        if (type != null) {
            return type;
        }
        type = this.getByFullNameIfValid(fullyQualifiedName);
        if (type == null) {
            throw new ClassNotFoundException(fullyQualifiedName + " in module " + this.getCurrentModule());
        }
        return type;
    }

    public IType getByRelativeName(String relativeName, ITypeUsesMap typeUses) throws ClassNotFoundException {
        int i;
        String relativeName1 = relativeName;
        IJavaType type = FrequentUsedJavaTypeCache.instance(TypeLoaderAccess.getExecutionEnv()).getHighUsageType(relativeName1);
        if (type != null) {
            return type;
        }
        int n = i = relativeName1 == null ? -1 : relativeName1.indexOf(60);
        if (i >= 0) {
            assert (relativeName1 != null);
            relativeName1 = relativeName1.substring(0, i);
        }
        if ((type = this.getTypeByRelativeNameIfValid_NoGenerics(relativeName1, typeUses)) == null) {
            throw new ClassNotFoundException(relativeName1);
        }
        return type;
    }

    public IType getTypeByRelativeNameIfValid_NoGenerics(String relativeName, ITypeUsesMap typeUses) {
        IType type = typeUses != null ? typeUses.resolveType(relativeName) : this.getByFullNameIfValid(relativeName);
        if (type == null) {
            type = this.getDefaultType(relativeName);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<? extends CharSequence> getAllTypeNames() {
        TypeSystem.lock();
        try {
            HashSet<CharSequence> names = new HashSet<CharSequence>();
            names.addAll(this.getDefaultTypes().keySet());
            List<ITypeLoader> loaders = this.getAllTypeLoaders();
            for (int i = loaders.size() - 1; i >= 0; --i) {
                names.addAll(loaders.get(i).getAllTypeNames());
            }
            HashSet<CharSequence> hashSet = names;
            return hashSet;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public void clearErrorTypes() {
        for (IModule iModule : TypeLoaderAccess.getExecutionEnv().getModules()) {
            ((ModuleTypeLoader)iModule.getModuleTypeLoader()).clearErrorTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean clearCachedTypes) {
        IModule globalModule = TypeSystem.getGlobalModule();
        this.pushModule(globalModule);
        TypeSystem.lock();
        try {
            this.dumpMaps();
            ++this._iRefreshChecksum;
            ++this._iSingleRefreshChecksum;
            for (IModule iModule : TypeLoaderAccess.getExecutionEnv().getModules()) {
                iModule.getModuleTypeLoader().refreshed();
            }
            CommonServices.getPlatformHelper().refresh(null);
            this.fireRefreshed();
            if (clearCachedTypes) {
                for (IModule iModule : TypeLoaderAccess.getExecutionEnv().getModules()) {
                    iModule.getModuleTypeLoader().getTypeRefFactory().clearCaches();
                }
                MetaType.clearCaches();
            }
            SingleServingGosuClassLoader.clearCache();
            this._defaultTypes = null;
        }
        finally {
            TypeSystem.unlock();
            this.popModule(globalModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        TypeSystem.lock();
        try {
            ExecutionEnvironment executionEnv = TypeLoaderAccess.getExecutionEnv();
            for (IModule iModule : executionEnv.getModules()) {
                iModule.getModuleTypeLoader().shutdown();
            }
            for (TypeSystemShutdownListener typeSystemShutdownListener : this._shutdownListeners) {
                typeSystemShutdownListener.shutdown();
            }
            TypeSystem.refresh((boolean)false);
            executionEnv.shutdown();
        }
        finally {
            TypeSystem.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void refreshTypes(RefreshRequest request) {
        TypeRefFactory typeRefFactory = (TypeRefFactory)request.module.getModuleTypeLoader().getTypeRefFactory();
        this.pushModule(request.module);
        TypeSystem.lock();
        try {
            void var6_8;
            ++this._iSingleRefreshChecksum;
            CommonServices.getMemoryMonitor().reclaimMemory(request);
            HashSet<ITypeRef> typesToRefresh = new HashSet<ITypeRef>(10);
            String[] stringArray = request.types;
            int n = stringArray.length;
            boolean bl = false;
            while (var6_8 < n) {
                String typeName = stringArray[var6_8];
                ITypeRef type = typeRefFactory.get(typeName);
                if (type != null) {
                    typesToRefresh.add(type);
                    if (!((AbstractTypeRef)type).isStale()) {
                        IModule[] enhancement;
                        IType iType;
                        ITypeRef topLevelType = this.getTopLevelType((IType)type);
                        if (topLevelType != null) {
                            typesToRefresh.add(topLevelType);
                        }
                        if (type instanceof IGosuEnhancement && (iType = (enhancement = (IModule[])type).getEnhancedType()) != null && !(iType instanceof INonLoadableType) && !TypeSystem.isDeleted((IType)iType)) {
                            ITypeRef topLevelType1 = this.getTopLevelType(iType);
                            if (topLevelType != null) {
                                typesToRefresh.add(topLevelType1);
                            }
                        }
                        enhancement = request.module.getModuleTraversalList();
                        int n2 = enhancement.length;
                        for (int i = 0; i < n2; ++i) {
                            ITypeRef orphanedEnhancement;
                            IModule module = enhancement[i];
                            ITypeLoaderStack moduleTypeLoader = module.getModuleTypeLoader();
                            GosuClassTypeLoader gosuClassTypeLoader = (GosuClassTypeLoader)moduleTypeLoader.getTypeLoader(GosuClassTypeLoader.class);
                            String orphanedEnhancementName = gosuClassTypeLoader.getEnhancementIndex().getOrphanedEnhancement(type.getName());
                            if (orphanedEnhancementName == null || !((orphanedEnhancement = typeRefFactory.get(orphanedEnhancementName)) instanceof AbstractTypeRef) || ((AbstractTypeRef)orphanedEnhancement).isStale()) continue;
                            typesToRefresh.add(orphanedEnhancement);
                        }
                    }
                }
                ++var6_8;
            }
            IdentitySet typesToMakeStaleSet = new IdentitySet(typesToRefresh.size() * 2);
            for (IType iType : typesToRefresh) {
                typesToMakeStaleSet.add((Object)((ITypeRef)iType));
                this.addGosuProxyClass((IdentitySet<ITypeRef>)typesToMakeStaleSet, iType);
                List<ITypeRef> subordinateRefs = typeRefFactory.getSubordinateRefs(iType.getName());
                for (ITypeRef typeRef : subordinateRefs) {
                    typesToMakeStaleSet.add((Object)typeRef);
                    this.addGosuProxyClass((IdentitySet<ITypeRef>)typesToMakeStaleSet, (IType)typeRef);
                }
            }
            for (IType iType : typesToMakeStaleSet) {
                if (!(iType instanceof IGosuClassInternal) || ((AbstractTypeRef)iType).isStale()) continue;
                IGosuClassInternal gsClass = (IGosuClassInternal)iType;
                ((IGosuClassInternal)gsClass.dontEverCallThis()).unloadBackingClass();
            }
            ITypeRef[] iTypeRefArray = (ITypeRef[])typesToMakeStaleSet.toArray((Object[])new ITypeRef[typesToMakeStaleSet.size()]);
            Arrays.sort(iTypeRefArray, new Comparator<IType>(){

                @Override
                public int compare(IType t1, IType t2) {
                    return this.computeSortIndex((AbstractTypeRef)t2) - this.computeSortIndex((AbstractTypeRef)t1);
                }

                private int computeSortIndex(AbstractTypeRef ref) {
                    return ref != null ? ref._getIndexForSortingFast(ref._getTypeName()) : 10000;
                }
            });
            HashMap typeLoaderToTypeMap = new HashMap();
            typeLoaderToTypeMap.put(request.typeLoader, new HashSet<String>(Arrays.asList(request.types)));
            for (ITypeRef type : typesToMakeStaleSet) {
                void var11_26;
                ITypeLoader typeLoader = type.getTypeLoaderDirectly();
                Set set = (Set)typeLoaderToTypeMap.get(typeLoader);
                if (set == null) {
                    HashSet hashSet = new HashSet(typesToMakeStaleSet.size());
                    typeLoaderToTypeMap.put(typeLoader, hashSet);
                }
                var11_26.add(((AbstractTypeRef)type)._getTypeName());
            }
            for (ITypeRef iTypeRef : iTypeRefArray) {
                if (iTypeRef == null) continue;
                iTypeRef._setStale(request.kind);
            }
            this.getGlobalModuleTypeLoader().clearFromCaches(request);
            for (ITypeRef iTypeRef : request.module.getModuleTraversalList()) {
                ((ModuleTypeLoader)iTypeRef.getModuleTypeLoader()).clearFromCaches(request);
            }
            for (ITypeLoader typeLoader : typeLoaderToTypeMap.keySet()) {
                Set strings = (Set)typeLoaderToTypeMap.get(typeLoader);
                RefreshRequest refreshRequest = new RefreshRequest(strings.toArray(new String[strings.size()]), request, typeLoader);
                typeLoader.refreshedTypes(refreshRequest);
            }
            for (ITypeLoaderListener listener : this.getListeners()) {
                listener.refreshedTypes(request);
            }
        }
        finally {
            TypeSystem.unlock();
            this.popModule(request.module);
        }
    }

    private ModuleTypeLoader getGlobalModuleTypeLoader() {
        IModule rootModule = TypeLoaderAccess.getExecutionEnv().getGlobalModule();
        return rootModule != null ? (ModuleTypeLoader)rootModule.getModuleTypeLoader() : null;
    }

    private void addGosuProxyClass(IdentitySet<ITypeRef> allTypes, IType type) {
        IGosuClassInternal gsProxyClass;
        if (type instanceof IJavaTypeInternal && !((AbstractTypeRef)type).isStale() && !((AbstractTypeRef)type).isDeleted() && (gsProxyClass = ((IJavaTypeInternal)type).getAdapterClassDirectly()) != null) {
            allTypes.add((Object)((ITypeRef)gsProxyClass));
        }
    }

    private ITypeRef getTopLevelType(IType type) {
        IType topLevelType = TypeLord.getTopLevelType(type);
        if (topLevelType instanceof ITypeRef) {
            return (ITypeRef)topLevelType;
        }
        return null;
    }

    public int getRefreshChecksum() {
        return this._iRefreshChecksum;
    }

    public int getSingleRefreshChecksum() {
        return this._iSingleRefreshChecksum;
    }

    public void addTypeLoaderListenerAsWeakRef(ITypeLoaderListener l) {
        if (!this.hasListener(l)) {
            this._listeners.add(new WeakReference<ITypeLoaderListener>(l));
        }
    }

    public void removeTypeLoaderListener(ITypeLoaderListener l) {
        for (WeakReference<ITypeLoaderListener> ref : this._listeners) {
            if (ref.get() != l) continue;
            this._listeners.remove(ref);
            break;
        }
    }

    private boolean hasListener(ITypeLoaderListener l) {
        for (WeakReference<ITypeLoaderListener> ref : this._listeners) {
            if (ref.get() != l) continue;
            return true;
        }
        return false;
    }

    private void fireRefreshed() {
        TypeSystem.lock();
        try {
            for (IModule iModule : TypeLoaderAccess.getExecutionEnv().getModules()) {
                iModule.getModuleTypeLoader().refreshed();
            }
            for (ITypeLoaderListener iTypeLoaderListener : this.getListeners()) {
                iTypeLoaderListener.refreshed();
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public void incrementChecksums() {
        ++this._iRefreshChecksum;
        ++this._iSingleRefreshChecksum;
    }

    private static ExecutionEnvironment getExecutionEnv() {
        return ExecutionEnvironment.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <E, A> E returnFirstNonNull(ArgCallable<E, A> callable, A argument) {
        TypeSystem.pushGlobalModule();
        try {
            E result = callable.call(argument);
            if (result != null) {
                E e = result;
                return e;
            }
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
        finally {
            TypeSystem.popGlobalModule();
        }
        Module module = this.getCurrentModule();
        if (module == null) {
            throw new RuntimeException("Current module must not be null.");
        }
        IModule[] iModuleArray = module.getModuleTraversalList();
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            if (m != TypeSystem.getGlobalModule()) {
                this.pushModule(m);
                try {
                    E result = callable.call(argument);
                    if (result != null) {
                        E e = result;
                        return e;
                    }
                }
                catch (Exception e) {
                    throw GosuExceptionUtil.forceThrow((Throwable)e);
                }
                finally {
                    this.popModule(m);
                }
            }
            ++n2;
        }
        return null;
    }

    public void addShutdownListener(TypeSystemShutdownListener listener) {
        this._shutdownListeners.add(listener);
    }

    private static void getDefaultTypes(Map<CharSequence, TypeGetter> typeMap) {
        typeMap.put("void", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Void.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("boolean", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Boolean.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("byte", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Byte.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("char", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Character.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("double", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Double.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("float", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Float.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("int", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Integer.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("long", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Long.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("short", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Short.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("void", new TypeGetter(){

            @Override
            public IType get() {
                return JavaType.get(Void.TYPE, TypeLoaderAccess._getDefaultLoader());
            }
        });
        typeMap.put("Type", new TypeGetter(){

            @Override
            public IType get() {
                return (IType)MetaType.ROOT_TYPE_TYPE.get();
            }
        });
    }

    private static DefaultTypeLoader _getDefaultLoader() {
        IModule jreModule = ExecutionEnvironment.instance().getJreModule();
        return (DefaultTypeLoader)jreModule.getModuleTypeLoader().getDefaultTypeLoader();
    }

    public IType get(Class<?> javaClass) {
        assert (javaClass != null);
        IJavaType type = FrequentUsedJavaTypeCache.instance(TypeLoaderAccess.getExecutionEnv()).getHighUsageType(javaClass);
        if (type != null) {
            return type;
        }
        String fqn = this.computeFullyQualifiedName(javaClass);
        if (IType.class.isAssignableFrom(javaClass) && fqn.endsWith("_Proxy")) {
            DefaultTypeLoader typeLoader;
            String typeName = this.unproxy(fqn);
            IType theType = TypeSystem.getByFullNameIfValid((String)typeName, (IModule)TypeSystem.getGlobalModule());
            if (theType != null) {
                IModule module = theType.getTypeLoader().getModule();
                typeLoader = (DefaultTypeLoader)((Object)module.getTypeLoaders(DefaultTypeLoader.class).get(0));
            } else {
                typeLoader = DefaultTypeLoader.instance();
            }
            type = JavaType.get(javaClass, typeLoader);
            if (type != null) {
                return type;
            }
        }
        if ((type = this.getByFullNameIfValid(fqn)) != null) {
            return type;
        }
        if (Proxy.isProxyClass(javaClass)) {
            return JavaType.get(javaClass, DefaultTypeLoader.instance());
        }
        return type;
    }

    private String unproxy(String fqn) {
        String suffix = "_TypeProxy_Proxy";
        if (fqn.endsWith(suffix)) {
            return fqn.substring(0, fqn.length() - suffix.length());
        }
        suffix = "_Proxy";
        if (fqn.endsWith(suffix)) {
            return fqn.substring(0, fqn.length() - suffix.length());
        }
        return fqn;
    }

    private String computeFullyQualifiedName(Class<?> javaClass) {
        if (javaClass.isArray()) {
            return this.computeFullyQualifiedName(javaClass.getComponentType()) + "[]";
        }
        return javaClass.getName().replace('$', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IType get(IJavaClassInfo javaClassInfo) {
        if (javaClassInfo == null) {
            throw new NullPointerException("Cannot have a null class info.");
        }
        if (javaClassInfo instanceof ClassJavaClassInfo) {
            this.pushModule(javaClassInfo.getModule());
            try {
                IType iType = this.get(((ClassJavaClassInfo)javaClassInfo).getJavaClass());
                return iType;
            }
            finally {
                this.popModule(javaClassInfo.getModule());
            }
        }
        String name = javaClassInfo.getName().replace('$', '.');
        IJavaType type = FrequentUsedJavaTypeCache.instance(javaClassInfo.getModule().getExecutionEnvironment()).getHighUsageType(name);
        if (type == null) {
            this.pushModule(javaClassInfo.getModule());
            try {
                type = this.getByFullNameIfValid(name);
            }
            finally {
                this.popModule(javaClassInfo.getModule());
            }
        }
        return type;
    }

    public IType getFromObject(Object object) {
        return this.getIntrinsicTypeFromObject(object);
    }

    public IType getByRelativeName(String relativeName) throws ClassNotFoundException {
        return this.getByRelativeName(relativeName, CommonServices.getEntityAccess().getDefaultTypeUses());
    }

    public IType getByFullName(String fullyQualifiedName) {
        try {
            return this.getIntrinsicTypeByFullName(fullyQualifiedName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeExceptionWithNoStacktrace(e);
        }
    }

    public IType getByFullNameIfValid(String fullyQualifiedName) {
        return this.getByFullNameIfValid(fullyQualifiedName, false);
    }

    public IType getByFullNameIfValidNoJava(String fullyQualifiedName) {
        return this.getByFullNameIfValid(fullyQualifiedName, true);
    }

    private IType getByFullNameIfValid(String fullyQualifiedName, boolean skipJava) {
        if (!this.isValidTypeName(fullyQualifiedName)) {
            return null;
        }
        Module module = this.getCurrentModule();
        if (module == null) {
            throw new RuntimeException("Current module must not be null.");
        }
        if (module.getExecutionEnvironment().isShadowingMode()) {
            module = TypeSystem.getGlobalModule();
        }
        for (IModule m : module.getModuleTraversalList()) {
            try {
                IType type = ((Module)m).getModuleTypeLoader().getTypeByFullNameIfValid(fullyQualifiedName, skipJava);
                if (type == null) continue;
                return type;
            }
            catch (Exception e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
        return null;
    }

    private final boolean isValidTypeName(String fqn) {
        if (fqn == null || fqn.length() == 0) {
            return false;
        }
        if (fqn.indexOf("block(") != -1 || fqn.indexOf("block (") != -1) {
            return false;
        }
        int braceIndex = fqn.indexOf(91);
        if (braceIndex > 0) {
            if (fqn.length() < braceIndex + 2 || fqn.charAt(braceIndex + 1) != ']') {
                return false;
            }
            fqn = fqn.substring(0, braceIndex);
        }
        if (this.isDefaultType(fqn)) {
            return true;
        }
        return Character.isJavaIdentifierPart(fqn.charAt(fqn.length() - 1));
    }

    private boolean isDefaultType(String fqn) {
        return this.getDefaultTypes().containsKey(fqn);
    }

    public IType boundTypes(IType targetType, List<IType> typesToBound) {
        return TypeLord.boundTypes(targetType, typesToBound);
    }

    public void refresh(ITypeRef typeRef) {
        this.refreshTypes(new RefreshRequest(null, new String[]{typeRef.getName()}, typeRef.getTypeLoader(), RefreshKind.MODIFICATION));
    }

    private void dumpMaps() {
        this._boxToPrimitiveMap = null;
        this._primitiveToBoxMap = null;
        PRIMITIVE_TYPES_BY_NAME.clear();
    }

    public void refresh(IModule module) {
        this.pushModule(module);
        TypeSystem.lock();
        try {
            if (module instanceof IJreModule) {
                this.dumpMaps();
            }
            ++this._iRefreshChecksum;
            ++this._iSingleRefreshChecksum;
            this.getGlobalModuleTypeLoader().refreshed();
            ((Module)module).getModuleTypeLoader().refreshed();
            CommonServices.getPlatformHelper().refresh(module);
            this.fireRefreshed();
            ((Module)module).getModuleTypeLoader().getTypeRefFactory().clearCaches();
            this._defaultTypes = null;
        }
        finally {
            TypeSystem.unlock();
            this.popModule(module);
        }
    }

    public void refreshed(IResource file, String typeName, RefreshKind refreshKind) {
        IModule module = ExecutionEnvironment.instance().getModule(file);
        if (module != null) {
            ((ITypeLoaderStackInternal)module.getModuleTypeLoader()).refresh(file, typeName, refreshKind);
        }
    }

    public String[] getTypesForFile(IModule module, IFile file) {
        if (module != null) {
            for (ITypeLoader loader : module.getModuleTypeLoader().getTypeLoaderStack()) {
                ArrayList<String> typeNames = new ArrayList<String>();
                if (loader.handlesFile(file)) {
                    typeNames.addAll(Arrays.asList(loader.getTypesForFile(file)));
                }
                if (typeNames.isEmpty()) continue;
                return typeNames.toArray(new String[typeNames.size()]);
            }
        }
        ArrayList<String> typeNames = new ArrayList<String>();
        for (ITypeLoader loader : this.getGlobalModuleTypeLoader().getTypeLoaderStack()) {
            if (!loader.handlesFile(file)) continue;
            typeNames.addAll(Arrays.asList(loader.getTypesForFile(file)));
        }
        if (!typeNames.isEmpty()) {
            return typeNames.toArray(new String[typeNames.size()]);
        }
        return new String[]{"default." + file.getBaseName()};
    }

    public IType parseType(String typeString) throws IllegalArgumentException {
        return this.parseType(typeString, (ITypeUsesMap)null);
    }

    public IType parseType(String typeString, ITypeUsesMap typeUsesMap) throws IllegalArgumentException {
        IType type = this.getTypeByRelativeNameIfValid_NoGenerics(typeString, typeUsesMap);
        if (type == null) {
            throw new IllegalArgumentException("Could not parse type " + typeString);
        }
        return type;
    }

    public IType parseType(String typeString, TypeVarToTypeMap actualParamByVarName) {
        return TypeLord.parseType(typeString, actualParamByVarName);
    }

    public IType parseType(String typeString, TypeVarToTypeMap actualParamByVarName, ITypeUsesMap typeUsesMap) {
        return TypeLord.parseType(typeString, actualParamByVarName, typeUsesMap);
    }

    public ITypeLiteralExpression parseTypeExpression(String typeString, TypeVarToTypeMap actualParamByVarName, ITypeUsesMap typeUsesMap) throws ParseResultsException {
        return TypeLord.parseTypeLiteral(typeString, actualParamByVarName, typeUsesMap);
    }

    public IType getComponentType(IType valueType) {
        Object componentType;
        if (valueType.isArray()) {
            componentType = valueType.getComponentType();
        } else if (valueType instanceof IPlaceholder && ((IPlaceholder)valueType).isPlaceholder()) {
            componentType = valueType.getComponentType();
        } else {
            IType qrsType = JavaTypes.IQUERY_RESULT_SET();
            if (qrsType.isAssignableFrom(valueType)) {
                for (IType iType : valueType.getAllTypesInHierarchy()) {
                    if (!iType.isParameterizedType() || !iType.getGenericType().equals(qrsType)) continue;
                    return iType.getTypeParameters()[0];
                }
                componentType = ErrorType.getInstance();
            } else {
                componentType = ErrorType.getInstance();
            }
        }
        return componentType;
    }

    public ITypeVariableType getOrCreateTypeVariableType(String strName, IType boundingType, IType enclosingType) {
        GenericTypeVariable typeVar = new GenericTypeVariable(strName, boundingType);
        typeVar.createTypeVariableDefinition(enclosingType);
        return new TypeVariableType(enclosingType, typeVar);
    }

    public IFunctionType getOrCreateFunctionType(IMethodInfo mi) {
        return new FunctionType(mi);
    }

    public IFunctionType getOrCreateFunctionType(String strFunctionName, IType retType, IType[] paramTypes) {
        return new FunctionType(strFunctionName, retType, paramTypes);
    }

    public TypeVarToTypeMap mapTypeByVarName(IType ownersType, IType declaringType) {
        return TypeLord.mapTypeByVarName(ownersType, declaringType);
    }

    public IType getActualType(IType type, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars) {
        return TypeLord.getActualType(type, actualParamByVarName, bKeepTypeVars);
    }

    public void inferTypeVariableTypesFromGenParamTypeAndConcreteType(IType genParamType, IType argType, TypeVarToTypeMap map) {
        TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(genParamType, argType, map);
    }

    public void inferTypeVariableTypesFromGenParamTypeAndConcreteType_Reverse(IType genParamType, IType argType, TypeVarToTypeMap map) {
        TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType_Reverse(genParamType, argType, map);
    }

    public IErrorType getErrorType() {
        return ErrorType.getInstance();
    }

    public IErrorType getErrorType(String strErrantName) {
        return ErrorType.getInstance(strErrantName);
    }

    public IErrorType getErrorType(ParseResultsException pe) {
        return new ErrorType(pe);
    }

    public IDefaultTypeLoader getDefaultTypeLoader() {
        return DefaultTypeLoader.instance();
    }

    public IType findParameterizedType(IType type, IType rhsType) {
        return TypeLord.findParameterizedType(type, rhsType);
    }

    public Set<String> getNamespacesFromTypeNames(Set<? extends CharSequence> allTypeNames, Set<String> namespaces) {
        return TypeLord.getNamespacesFromTypeNames(allTypeNames, namespaces);
    }

    public void pushTypeLoader(ITypeLoader loader) {
        this.pushTypeLoader(null, loader);
    }

    public void pushIncludeAll() {
        GosuClassTypeInfo.pushIncludeAll();
    }

    public void popIncludeAll() {
        GosuClassTypeInfo.popIncludeAll();
    }

    public boolean isIncludeAll() {
        return GosuClassTypeInfo.isIncludeAll();
    }

    public IType getCurrentCompilingType() {
        return GosuClassCompilingStack.getCurrentCompilingType();
    }

    public void pushCompilingType(IType type) {
        GosuClassCompilingStack.pushCompilingType(type);
    }

    public void popCompilingType() {
        GosuClassCompilingStack.popCompilingType();
    }

    public IType getCompilingType(String strName) {
        return GosuClassCompilingStack.getCompilingType(strName);
    }

    public void pushSymTableCtx(ISymbolTable ctx) {
        CompiledGosuClassSymbolTable.pushSymTableCtx(ctx);
    }

    public void popSymTableCtx() {
        CompiledGosuClassSymbolTable.popSymTableCtx();
    }

    public ISymbolTable getSymTableCtx() {
        return CompiledGosuClassSymbolTable.getSymTableCtx();
    }

    public IType getTypeFromObject(Object obj) {
        return this.getIntrinsicTypeFromObject(obj);
    }

    public boolean isExpandable(IType type) {
        return TypeLord.isExpandable(type);
    }

    public String getNameOfParams(IType[] paramTypes, boolean bRelative, boolean bWithEnclosingType) {
        return TypeLord.getNameOfParams(paramTypes, bRelative, bWithEnclosingType);
    }

    public ISymbolTable getCompiledGosuClassSymbolTable() {
        return CompiledGosuClassSymbolTable.instance();
    }

    public IType getJavaType(Class javaClass) {
        return TypeSystem.get((Class)javaClass);
    }

    public String getNameWithQualifiedTypeVariables(IType type) {
        return TypeLord.getNameWithQualifiedTypeVariables(type, false);
    }

    public IType getDefaultParameterizedType(IType type) {
        return TypeLord.getDefaultParameterizedType(type);
    }

    public IType getDefaultParameterizedTypeWithTypeVars(IType type) {
        return TypeLord.getDefaultParameterizedTypeWithTypeVars(type);
    }

    public boolean canCast(IType lhsType, IType rhsType) {
        if (lhsType instanceof ICompoundType) {
            return this.canCastCompountType((ICompoundType)lhsType, rhsType);
        }
        while (lhsType instanceof TypeVariableType && !TypeLord.isRecursiveType((TypeVariableType)lhsType, ((TypeVariableType)lhsType).getBoundingType())) {
            lhsType = ((TypeVariableType)lhsType).getBoundingType();
        }
        while (rhsType instanceof TypeVariableType && !TypeLord.isRecursiveType((TypeVariableType)rhsType, ((TypeVariableType)rhsType).getBoundingType())) {
            rhsType = ((TypeVariableType)rhsType).getBoundingType();
        }
        if (lhsType != null) {
            boolean bRawAssignable;
            if (lhsType instanceof IMetaType && rhsType instanceof IMetaType) {
                return this.canCast(((IMetaType)lhsType).getType(), ((IMetaType)rhsType).getType());
            }
            if (rhsType.isAssignableFrom(lhsType)) {
                return true;
            }
            if (lhsType.isAssignableFrom(rhsType)) {
                return true;
            }
            if (rhsType.isInterface() && lhsType.isInterface() && !this.genericInterfacesClash(rhsType, lhsType)) {
                return true;
            }
            if (!(!rhsType.isInterface() || (lhsType.isFinal() || lhsType.isPrimitive() || lhsType instanceof IFunctionType || lhsType.isArray() || this.genericInterfacesClash(rhsType, lhsType)) && !this.canCastMetaType(lhsType, rhsType))) {
                return true;
            }
            if (!(!lhsType.isInterface() || rhsType.isFinal() || rhsType.isPrimitive() || rhsType instanceof IFunctionType || rhsType.isArray() || this.genericInterfacesClash(lhsType, rhsType))) {
                return true;
            }
            if (lhsType == JavaTypes.OBJECT() && rhsType.isPrimitive() && rhsType != JavaTypes.pVOID()) {
                return true;
            }
            if (lhsType.isParameterizedType() && rhsType.isParameterizedType() && ((bRawAssignable = rhsType.getGenericType().isAssignableFrom(lhsType.getGenericType())) || this.canCast(lhsType.getGenericType(), rhsType.getGenericType()))) {
                IType compatibleRhsType;
                if (bRawAssignable) {
                    compatibleRhsType = rhsType;
                } else {
                    compatibleRhsType = TypeLord.findParameterizedType(rhsType, lhsType.getGenericType());
                    if (compatibleRhsType == null) {
                        return false;
                    }
                }
                IType[] lhsParams = lhsType.getTypeParameters();
                IType[] rhsParams = compatibleRhsType.getTypeParameters();
                for (int i = 0; i < lhsParams.length; ++i) {
                    if (rhsParams[i].isAssignableFrom(lhsParams[i]) || this.canCast(lhsParams[i], rhsParams[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean canCastCompountType(ICompoundType lhsType, IType rhsType) {
        for (IType type : lhsType.getTypes()) {
            if (this.canCast(type, rhsType)) continue;
            return false;
        }
        return true;
    }

    private boolean genericInterfacesClash(IType rhsType, IType lhsType) {
        return this._genericInterfacesClash(rhsType, lhsType) || this._genericInterfacesClash(lhsType, rhsType);
    }

    private boolean _genericInterfacesClash(IType rhsType, IType lhsType) {
        if (!rhsType.isParameterizedType() || !lhsType.isParameterizedType()) {
            return false;
        }
        IType lhsTypeInRhs = TypeLord.findParameterizedType(lhsType, rhsType.getGenericType());
        if (lhsTypeInRhs != null) {
            return !rhsType.isAssignableFrom(lhsTypeInRhs = TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(lhsTypeInRhs, lhsTypeInRhs.getEnclosingType())) && !lhsTypeInRhs.isAssignableFrom(rhsType);
        }
        return false;
    }

    private boolean canCastMetaType(IType lhsType, IType rhsType) {
        return lhsType instanceof IMetaType && ((IMetaType)lhsType).getType() instanceof ITypeVariableType && this.canCast(((ITypeVariableType)((IMetaType)lhsType).getType()).getBoundingType(), rhsType) || rhsType instanceof IGosuClass && ((IGosuClass)rhsType).isStructure() && (lhsType instanceof IMetaType && StandardCoercionManager.isStructurallyAssignable((IType)rhsType, (IType)((IMetaType)lhsType).getType()) || JavaTypes.CLASS().isAssignableFrom(lhsType) && (!lhsType.isParameterizedType() || StandardCoercionManager.isStructurallyAssignable((IType)rhsType, (IType)lhsType.getTypeParameters()[0])));
    }

    public IJavaType getPrimitiveType(String name) {
        return JavaType.getPrimitiveType(name);
    }

    public IType getPrimitiveType(IType boxType) {
        this.initBoxMapsIfNeeded();
        return this._boxToPrimitiveMap.get(boxType);
    }

    public IType getBoxType(IType primitiveType) {
        this.initBoxMapsIfNeeded();
        return this._primitiveToBoxMap.get(primitiveType);
    }

    public IType getExpandableComponentType(IType type) {
        return TypeLord.getExpandableComponentType(type);
    }

    private void initBoxMapsIfNeeded() {
        if (this._boxToPrimitiveMap == null) {
            TypeSystem.lock();
            try {
                if (this._boxToPrimitiveMap == null) {
                    this._boxToPrimitiveMap = new HashMap<IType, IType>();
                    this._primitiveToBoxMap = new HashMap<IType, IType>();
                    this.mapBoxType(JavaTypes.VOID(), (IType)JavaTypes.pVOID());
                    this.mapBoxType((IType)JavaTypes.BOOLEAN(), (IType)JavaTypes.pBOOLEAN());
                    this.mapBoxType((IType)JavaTypes.BYTE(), (IType)JavaTypes.pBYTE());
                    this.mapBoxType((IType)JavaTypes.CHARACTER(), (IType)JavaTypes.pCHAR());
                    this.mapBoxType((IType)JavaTypes.DOUBLE(), (IType)JavaTypes.pDOUBLE());
                    this.mapBoxType((IType)JavaTypes.FLOAT(), (IType)JavaTypes.pFLOAT());
                    this.mapBoxType((IType)JavaTypes.INTEGER(), (IType)JavaTypes.pINT());
                    this.mapBoxType((IType)JavaTypes.LONG(), (IType)JavaTypes.pLONG());
                    this.mapBoxType((IType)JavaTypes.SHORT(), (IType)JavaTypes.pSHORT());
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    private void mapBoxType(IType boxType, IType primitiveType) {
        this._boxToPrimitiveMap.put(boxType, primitiveType);
        this._primitiveToBoxMap.put(primitiveType, boxType);
    }

    public IExecutionEnvironment getExecutionEnvironment() {
        return ExecutionEnvironment.instance();
    }

    public IExecutionEnvironment getExecutionEnvironment(IProject project) {
        return ExecutionEnvironment.instance(project);
    }

    public IGosuClassLoader getGosuClassLoader() {
        DefaultTypeLoader loader = (DefaultTypeLoader)this.getCurrentModule().getTypeLoaders(IDefaultTypeLoader.class).get(0);
        return loader.getGosuClassLoader();
    }

    public void dumpGosuClassLoader() {
        DefaultTypeLoader loader = (DefaultTypeLoader)this.getCurrentModule().getTypeLoaders(IDefaultTypeLoader.class).get(0);
        loader.dumpGosuClassLoader();
    }

    public IType replaceTypeVariableTypeParametersWithBoundingTypes(IType type, IType enclosingType) {
        return TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(type, enclosingType);
    }

    public IMetaType getDefaultType() {
        return (IMetaType)MetaType.DEFAULT_TYPE_TYPE.get();
    }

    private static interface ArgCallable<V, A1> {
        public V call(A1 var1) throws Exception;
    }

    static interface TypeGetter {
        public IType get();
    }
}

