/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.nodes.IRMethodFromMethodInfo;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.BeanMethodCallExpansionTransformer;
import gw.internal.gosu.parser.ArrayExpansionMethodInfo;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.expressions.BeanMethodCallExpression;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.SuperAccess;
import gw.internal.gosu.parser.statements.BeanMethodCallStatement;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.parser.ICustomExpressionRuntime;
import gw.lang.parser.IExpression;
import gw.lang.parser.Keyword;
import gw.lang.parser.MemberAccessKind;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfoMethodInfo;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.List;

public class BeanMethodCallExpressionTransformer
extends AbstractExpressionTransformer<BeanMethodCallExpression> {
    public static IRExpression compile(TopLevelTransformationContext cc, BeanMethodCallExpression expr) {
        BeanMethodCallExpressionTransformer compiler = new BeanMethodCallExpressionTransformer(cc, expr);
        return compiler.compile();
    }

    public BeanMethodCallExpressionTransformer(TopLevelTransformationContext cc, BeanMethodCallExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        IRExpression result;
        IRMethodFromMethodInfo irMethod;
        if (((BeanMethodCallExpression)this._expr()).isExpansion()) {
            return BeanMethodCallExpansionTransformer.compile(this._cc(), (BeanMethodCallExpression)this._expr());
        }
        Expression rootExpr = ((BeanMethodCallExpression)this._expr()).getRootExpression();
        IMethodInfo mi = this.getMethodInfo();
        if (((BeanMethodCallExpression)this._expr()).getExpressionRuntime() instanceof ICustomExpressionRuntime) {
            return this.handleCustomExpressionRuntime((ICustomExpressionRuntime)((BeanMethodCallExpression)this._expr()).getExpressionRuntime(), ((BeanMethodCallExpression)this._expr()).getType());
        }
        if (mi instanceof ITypeInfoMethodInfo) {
            ITypeInfoMethodInfo metaMethod = (ITypeInfoMethodInfo)mi;
            IMethodInfo backingMethod = metaMethod.getBackingMethodInfo();
            irMethod = IRMethodFactory.createIRMethod(backingMethod, ((BeanMethodCallExpression)this._expr()).getFunctionType());
            result = this.callInstanceMethod(rootExpr, irMethod, ((BeanMethodCallExpression)this._expr()).getNamedArgOrder());
        } else if (mi.isStatic()) {
            irMethod = IRMethodFactory.createIRMethod(mi, ((BeanMethodCallExpression)this._expr()).getFunctionType());
            result = this.callStaticMethod(rootExpr, irMethod, ((BeanMethodCallExpression)this._expr()).getNamedArgOrder());
        } else {
            irMethod = IRMethodFactory.createIRMethod(mi, ((BeanMethodCallExpression)this._expr()).getFunctionType());
            result = this.callInstanceMethod(rootExpr, irMethod, ((BeanMethodCallExpression)this._expr()).getNamedArgOrder());
        }
        return this.castIfReturnTypeDerivedFromTypeVariable(irMethod, result);
    }

    private IRExpression callInstanceMethod(IExpression rootExpr, IRMethodFromMethodInfo irMethod, int[] namedArgOrder) {
        IRExpression irMethodCall;
        IRExpression irRootRaw;
        if (this.isArrayExpansionMethod(irMethod.getOriginalMethod())) {
            return BeanMethodCallExpansionTransformer.compile(this._cc(), (BeanMethodCallExpression)this._expr());
        }
        IRExpression irRoot = irRootRaw = this.pushRootExpression(irMethod, rootExpr);
        IRSymbol rootSymbol = null;
        boolean bShouldNullShortCircuitCheck = this.shouldNullShortCircuit();
        if (bShouldNullShortCircuitCheck) {
            rootSymbol = this._cc().makeAndIndexTempSymbol(irRoot.getType());
            irRoot = this.identifier(rootSymbol);
        }
        if (irMethod.isBytecodeMethod()) {
            ArrayList<IRExpression> irArgs = new ArrayList<IRExpression>();
            this.pushArgumentsWithCasting(irMethod, ((BeanMethodCallExpression)this._expr()).getArgs(), irArgs);
            if (rootExpr instanceof SuperAccess) {
                irMethodCall = this.callSpecialMethod(BeanMethodCallExpressionTransformer.getDescriptor(rootExpr.getType()), irMethod, irRoot, irArgs, namedArgOrder);
            } else if (this.isSuperCall(rootExpr)) {
                irMethodCall = this.callSpecialMethod(BeanMethodCallExpressionTransformer.getDescriptor(this._cc().getSuperType()), irMethod, irRoot, irArgs, namedArgOrder);
            } else {
                irMethodCall = this.callMethod(irMethod, irRoot, irArgs, namedArgOrder);
                this.assignStructuralTypeOwner(rootExpr, irMethodCall);
            }
        } else {
            irMethodCall = this.callMethodInfo(irMethod, irRoot, namedArgOrder);
        }
        if (this.shouldNullShortCircuit()) {
            irMethodCall = ((BeanMethodCallExpression)this._expr()).getType() == JavaTypes.pVOID() ? this.buildComposite(new IRElement[]{this.buildAssignment(rootSymbol, irRootRaw), this.buildIf((IRExpression)this.buildNotEquals((IRExpression)this.identifier(rootSymbol), this.nullLiteral()), (IRStatement)this.buildMethodCall(irMethodCall))}) : this.buildComposite(new IRElement[]{this.buildAssignment(rootSymbol, irRootRaw), this.buildNullCheckTernary(irRoot, this.shortCircuitValue(irMethodCall.getType()), irMethodCall)});
        }
        return irMethodCall;
    }

    private boolean shouldNullShortCircuit() {
        return ((BeanMethodCallExpression)this._expr()).getMemberAccessKind() == MemberAccessKind.NULL_SAFE;
    }

    private boolean isArrayExpansionMethod(IMethodInfo mi) {
        return mi instanceof ArrayExpansionMethodInfo;
    }

    private IRExpression callStaticMethod(IExpression rootExpr, IRMethodFromMethodInfo irMethod, int[] namedArgOrder) {
        if (irMethod.isBytecodeMethod()) {
            ArrayList<IRExpression> args = new ArrayList<IRExpression>();
            this.pushArgumentsWithCasting(irMethod, ((BeanMethodCallExpression)this._expr()).getArgs(), args);
            return this.callMethod(irMethod, null, args, namedArgOrder);
        }
        return this.callMethodInfo(irMethod, this.pushRootExpression(irMethod, rootExpr), namedArgOrder);
    }

    private IRExpression castIfReturnTypeDerivedFromTypeVariable(IRMethod mi, IRExpression root) {
        IType retType;
        if (!(((BeanMethodCallExpression)this._expr()).getParent() instanceof BeanMethodCallStatement || (retType = ((BeanMethodCallExpression)this._expr()).getReturnType()) == JavaTypes.pVOID() || retType.isPrimitive() || mi.getReturnType().equals(BeanMethodCallExpressionTransformer.getDescriptor(retType)))) {
            return this.checkCast(retType, root);
        }
        return root;
    }

    private IMethodInfo getMethodInfo() {
        IMethodInfo methodInfo = ((BeanMethodCallExpression)this._expr()).getMethodDescriptor();
        if (methodInfo == null) {
            throw new NullPointerException("Null method descriptor for expression: " + this._expr());
        }
        if (methodInfo.getOwnersType().getName().equals("gw.lang.reflect.gs.IGosuObject")) {
            if (methodInfo.getDisplayName().equals("equals")) {
                methodInfo = JavaTypes.OBJECT().getTypeInfo().getMethod((CharSequence)"equals", new IType[]{JavaTypes.OBJECT()});
            } else if (methodInfo.getDisplayName().equals("hashCode")) {
                methodInfo = JavaTypes.OBJECT().getTypeInfo().getMethod((CharSequence)"hashCode", new IType[0]);
            } else if (methodInfo.getDisplayName().equals("toString")) {
                methodInfo = JavaTypes.OBJECT().getTypeInfo().getMethod((CharSequence)"toString", new IType[0]);
            }
        }
        return methodInfo;
    }

    private boolean isSuperCall(IExpression rootExpr) {
        return rootExpr instanceof Identifier && Keyword.KW_super.equals(((Identifier)rootExpr).getSymbol().getName());
    }

    private IRExpression callMethodInfo(IRMethodFromMethodInfo irMethod, IRExpression irRootExpr, int[] namedArgOrder) {
        IRExpression irRoot;
        IMethodInfo mi = irMethod.getTerminalMethod();
        ArrayList<IRExpression> explicitArgs = new ArrayList<IRExpression>();
        this.pushArgumentsNoCasting(irMethod, ((BeanMethodCallExpression)this._expr()).getArgs(), explicitArgs);
        List<IRElement> callElements = this.handleNamedArgs(explicitArgs, namedArgOrder);
        if (!irMethod.isStatic()) {
            IRSymbol rootSymbol = this._cc().makeAndIndexTempSymbol(irRootExpr.getType());
            callElements.add((IRElement)this.buildAssignment(rootSymbol, irRootExpr));
            callElements.add((IRElement)this.nullCheckVar(rootSymbol));
            irRoot = this.identifier(rootSymbol);
        } else {
            irRoot = irRootExpr;
        }
        IRExpression miCall = this.callStaticMethod(GosuRuntimeMethods.class, "invokeMethodInfo", new Class[]{IType.class, String.class, IType[].class, Object.class, Object[].class}, BeanMethodCallExpressionTransformer.exprList(this.pushType(mi.getOwnersType(), true), this.pushConstant(mi.getDisplayName()), this.pushParamTypes(mi.getParameters()), irRoot, this.pushArgumentsAsArray(explicitArgs)));
        miCall = this.unboxValueToType(mi.getReturnType(), miCall);
        if (callElements.size() > 0) {
            callElements.add((IRElement)miCall);
            miCall = new IRCompositeExpression(callElements);
        }
        return miCall;
    }

    private IRExpression pushRootExpression(IRMethod irMethod, IExpression rootExpr) {
        IRType type;
        IRExpression root = ExpressionTransformer.compile(rootExpr, this._cc());
        if (irMethod != null) {
            root = this.boxValue(irMethod.getOwningIRType(), root);
        }
        if (!(irMethod == null || irMethod.isStatic() || (type = irMethod.getTargetRootIRType()).isAssignableFrom(root.getType()) || rootExpr.getType() instanceof IGosuClass && ((IGosuClass)rootExpr.getType()).isStructure())) {
            root = this.buildCast(type, root);
        }
        return root;
    }

    private IRExpression pushArgumentsAsArray(List<IRExpression> explicitArgs) {
        ArrayList<IRExpression> irArgs = new ArrayList<IRExpression>();
        if (explicitArgs != null) {
            for (IRExpression arg : explicitArgs) {
                if (arg.getType().isPrimitive()) {
                    arg = this.boxValue(arg.getType(), arg);
                }
                irArgs.add(arg);
            }
        }
        return this.buildInitializedArray(IRTypeConstants.OBJECT(), irArgs);
    }
}

