/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.AsmTypeJavaClassType;
import gw.internal.gosu.parser.java.classinfo.AsmClassAnnotationInfo;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.lang.gosuc.simple.CompilerDriverException;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.asm.AsmAnnotation;
import gw.lang.reflect.java.asm.AsmField;
import gw.lang.reflect.java.asm.IAsmType;
import gw.lang.reflect.module.IModule;
import java.lang.annotation.Annotation;
import java.util.List;

public class AsmFieldJavaClassField
implements IJavaClassField {
    private AsmField _field;
    private IModule _module;

    public AsmFieldJavaClassField(AsmField field, IModule module) {
        this._field = field;
        this._module = module;
    }

    public boolean isSynthetic() {
        return this._field.isSynthetic();
    }

    public int getModifiers() {
        return this._field.getModifiers();
    }

    public String getName() {
        return this._field.getName();
    }

    public IJavaClassInfo getType() {
        return JavaSourceUtil.getClassInfo(this._field.getType().getRawType().getNameWithArrayBrackets(), this._module);
    }

    public IJavaClassType getGenericType() {
        IJavaClassType type = AsmTypeJavaClassType.createType((IAsmType)this._field.getType(), this._module);
        if (type == null) {
            throw new CompilerDriverException("Unable to create a generic type for the field " + this._field.getName() + " on " + this._field.getDeclaringClass().getName() + " in module " + this._module.getName() + ". Please make sure all the external dependencies are present on the classpath.\n" + "Type : " + this._field.getType() + ", Type.class " + this._field.getType().getClass().getName() + " GenericType : " + this._field.getType() + ", GenericType.class : " + this._field.getType().getClass().getName());
        }
        return type;
    }

    public IJavaClassInfo getEnclosingClass() {
        return JavaSourceUtil.getClassInfo(this._field.getDeclaringClass(), this._module);
    }

    public boolean isEnumConstant() {
        return this._field.isEnumConstant();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._field.isAnnotationPresent(annotationClass);
    }

    public IAnnotationInfo getAnnotation(Class annotationClass) {
        AsmAnnotation annotation = this._field.getAnnotation(annotationClass);
        return annotation != null ? new AsmClassAnnotationInfo(annotation, (IJavaAnnotatedElement)this) : null;
    }

    public IAnnotationInfo[] getDeclaredAnnotations() {
        List annotations = this._field.getAnnotations();
        IAnnotationInfo[] declaredAnnotations = new IAnnotationInfo[annotations.size()];
        for (int i = 0; i < declaredAnnotations.length; ++i) {
            declaredAnnotations[i] = new AsmClassAnnotationInfo((AsmAnnotation)annotations.get(i), (IJavaAnnotatedElement)this);
        }
        return declaredAnnotations;
    }

    public String toString() {
        return this._field.toString();
    }

    public Object getStaticValue() {
        return this._field.getStaticValue();
    }
}

