/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.config.CommonServices;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.statements.StatementList;
import gw.lang.parser.statements.ICatchClause;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuObjectUtil;

public final class CatchClause
extends Statement
implements ICatchClause {
    private IType _catchType;
    private Statement _catchStmt;
    private Symbol _symbol;
    private int _iOffset;

    public IType getCatchType() {
        return this._catchType;
    }

    public Statement getCatchStmt() {
        return this._catchStmt;
    }

    public Symbol getSymbol() {
        return this._symbol;
    }

    public void init(IType iIntrinsicType, Statement catchStmt, Symbol symbol) {
        this._catchType = iIntrinsicType;
        this._catchStmt = catchStmt;
        if (catchStmt instanceof StatementList) {
            ((StatementList)catchStmt).setNoScope();
        }
        this._symbol = symbol;
    }

    @Override
    public Object execute() {
        return this._catchStmt.execute();
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        return this._catchStmt.getLeastSignificantTerminalStatement(bAbsolute);
    }

    @Override
    public String toString() {
        return "catch( " + (this._symbol == null ? "" : this._symbol.getName()) + (this._catchType == null ? "" : " : " + this._catchType.getName()) + " )\n" + (this._catchStmt == null ? "" : this._catchStmt);
    }

    public int getNameOffset(String identifierName) {
        return this._iOffset;
    }

    public void setNameOffset(int iOffset, String identifierName) {
        this._iOffset = iOffset;
    }

    public boolean declares(String identifierName) {
        return this._symbol != null && GosuObjectUtil.equals((Object)identifierName, (Object)this._symbol.getName());
    }

    public String[] getDeclarations() {
        if (this._symbol != null) {
            return new String[]{this._symbol.getName()};
        }
        return null;
    }

    public static IType getNakedCatchExceptionType() {
        IJavaType type = CommonServices.getEntityAccess().getLanguageLevel().supportsNakedCatchStatements() ? JavaTypes.EXCEPTION() : JavaTypes.THROWABLE();
        return type;
    }
}

