/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.expressions.EvalExpression;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.lang.parser.IStackProvider;
import gw.lang.parser.statements.IStatementList;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.reflect.TypeSystem;
import java.util.List;

public final class StatementList
extends Statement
implements IStatementList {
    protected Statement[] _statements;
    protected IStackProvider _stackProvider;

    public StatementList(IStackProvider stackProvider) {
        this._stackProvider = stackProvider;
    }

    @Override
    public void clearParseTreeInformation() {
        TypeSystem.lock();
        try {
            super.clearParseTreeInformation();
            if (this._statements != null) {
                for (int i = 0; i < this._statements.length; ++i) {
                    Statement statement = this._statements[i];
                    statement.clearParseTreeInformation();
                }
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public Statement[] getStatements() {
        return this._statements;
    }

    public void setStatements(List<Statement> statements) {
        if (statements.size() == 0) {
            this._statements = null;
        } else {
            this._statements = statements.toArray(new Statement[statements.size()]);
            this.tryToEliminateTheScope();
        }
    }

    public int indexOf(Statement stmt) {
        for (int i = 0; i < this._statements.length; ++i) {
            if (stmt != this._statements[i]) continue;
            return i;
        }
        return -1;
    }

    private void tryToEliminateTheScope() {
        for (int i = 0; i < this._statements.length; ++i) {
            Statement statement = this._statements[i];
            if (!(statement instanceof VarStatement) && (statement instanceof StatementList || !statement.getContainedParsedElementsByType(EvalExpression.class, null))) continue;
            return;
        }
        this.setNoScope();
    }

    public void setNoScope() {
        this._stackProvider = null;
    }

    public boolean hasScope() {
        return this._stackProvider != null;
    }

    @Override
    public Object execute() {
        if (!this.isCompileTimeConstant()) {
            return super.execute();
        }
        throw new CannotExecuteGosuException();
    }

    @Override
    protected ITerminalStatement getLeastSignificantTerminalStatement_internal(boolean[] bAbsolute) {
        bAbsolute[0] = false;
        return this.getLeastSignificantTerminalStatementAfter(null, bAbsolute);
    }

    public ITerminalStatement getLeastSignificantTerminalStatementAfter(Statement fromStmt, boolean[] bAbsolute) {
        int i;
        if (this._statements == null) {
            return null;
        }
        ITerminalStatement ret = null;
        int n = i = fromStmt == null ? 0 : this.indexOf(fromStmt) + 1;
        while (i < this._statements.length) {
            boolean[] bCsr = new boolean[]{false};
            ITerminalStatement terminalStmt = this._statements[i].getLeastSignificantTerminalStatement(bCsr);
            if (terminalStmt != null && (ret = StatementList.getLeastSignificant(ret, terminalStmt)) == terminalStmt) {
                bAbsolute[0] = bCsr[0];
            }
            ++i;
        }
        return ret;
    }

    @Override
    public String toString() {
        String strStatements = "{\n";
        if (this._statements != null) {
            for (Statement stmt : this._statements) {
                strStatements = strStatements + "  " + stmt.toString() + "\n";
            }
        }
        return strStatements + "}\n";
    }

    public Statement getSelfOrSingleStatement() {
        if (this._statements != null && this._statements.length == 1 && !this.hasScope()) {
            this._statements[0].addExceptionsFrom(this);
            return this._statements[0];
        }
        return this;
    }
}

