/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode;

import gw.internal.ext.org.objectweb.asm.AnnotationVisitor;
import gw.internal.ext.org.objectweb.asm.Attribute;
import gw.internal.ext.org.objectweb.asm.ClassVisitor;
import gw.internal.ext.org.objectweb.asm.ClassWriter;
import gw.internal.ext.org.objectweb.asm.FieldVisitor;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.ext.org.objectweb.asm.TypePath;
import gw.internal.gosu.ir.compiler.bytecode.GosuMethodVisitor;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaBackedTypeData;
import gw.lang.reflect.java.JavaTypes;

public class GosuClassWriter
extends ClassVisitor {
    private final ClassWriter _cw = new MyWriter();

    public GosuClassWriter() {
        super(327680);
    }

    public MethodVisitor visitMethod(int i, String s, String s2, String s3, String[] strings) {
        return new GosuMethodVisitor(this._cw.visitMethod(i, s, s2, s3, strings));
    }

    public byte[] toByteArray() {
        return this._cw.toByteArray();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this._cw.visit(version, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this._cw.visitAnnotation(desc, visible);
    }

    public void visitAttribute(Attribute attribute) {
        this._cw.visitAttribute(attribute);
    }

    public void visitEnd() {
        this._cw.visitEnd();
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return this._cw.visitField(access, name, desc, signature, value);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this._cw.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this._cw.visitOuterClass(owner, name, desc);
    }

    public void visitSource(String source, String debug) {
        this._cw.visitSource(source, debug);
    }

    public AnnotationVisitor visitTypeAnnotation(int i, TypePath typePath, String s, boolean b) {
        return this._cw.visitTypeAnnotation(i, typePath, s, b);
    }

    private static class MyWriter
    extends ClassWriter {
        public MyWriter() {
            super(3);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            IType fromT2;
            IType fromT1;
            IType t1 = TypeSystem.getByFullNameIfValid((String)type1.replace('/', '.').replace('$', '.'));
            IType t2 = TypeSystem.getByFullNameIfValid((String)type2.replace('/', '.').replace('$', '.'));
            if (t1 != null && t2 != null) {
                if (t1.isAssignableFrom(t2)) {
                    return type1;
                }
                if (t2.isAssignableFrom(t1)) {
                    return type2;
                }
                if (t1.isInterface() || t2.isInterface()) {
                    return "java/lang/Object";
                }
            }
            IType commonSuper = (fromT1 = this.findCommonClass(t1, t2)).isAssignableFrom(fromT2 = this.findCommonClass(t2, t1)) ? fromT2 : fromT1;
            String superTypeName = commonSuper instanceof IJavaBackedTypeData ? ((IJavaBackedTypeData)commonSuper).getBackingClassInfo().getName() : commonSuper.getName();
            return superTypeName.replace('.', '/');
        }

        private IType findCommonClass(IType t1, IType t2) {
            do {
                if ((t1 = t1.getSupertype()) != null) continue;
                return JavaTypes.OBJECT();
            } while (!(t1 = TypeLord.getPureGenericType(t1)).isAssignableFrom(t2));
            return t1;
        }
    }
}

