/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform;

import gw.internal.gosu.ir.transform.IRScope;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.TypeVariableType;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.parser.Keyword;
import gw.util.Stack;
import java.util.List;

public class FunctionBodyTransformationContext {
    public static final String TEMP_VAR_PREFIX = "*temp";
    private int _tempVarCount = 0;
    private Stack<IRScope> _scopes;
    private ConstructorState _constructorState;
    protected TopLevelTransformationContext _context;
    private boolean _isStatic;

    public FunctionBodyTransformationContext(TopLevelTransformationContext context, boolean isStatic) {
        this._context = context;
        this._isStatic = isStatic;
        this._constructorState = ConstructorState.CLEAR;
    }

    public void updateSuperInvokedAfterLastExpressionCompiles() {
        if (this._constructorState == ConstructorState.SUPER_INVOKED) {
            this._constructorState = ConstructorState.CLEAR;
        }
    }

    public boolean hasSuperBeenInvoked() {
        return this._constructorState != ConstructorState.PRE_SUPER;
    }

    public void markInvokingSuper() {
        this._constructorState = ConstructorState.PRE_SUPER;
    }

    public void markSuperInvoked() {
        this._constructorState = ConstructorState.SUPER_INVOKED;
    }

    public IRSymbol makeAndIndexTempSymbol(IRType type) {
        return this.makeAndIndexTempSymbol(null, type);
    }

    public IRSymbol makeAndIndexTempSymbol(String strNameSuffix, IRType type) {
        String strName = strNameSuffix != null ? TEMP_VAR_PREFIX + strNameSuffix : TEMP_VAR_PREFIX + this._tempVarCount++;
        IRSymbol symbol = new IRSymbol(strName, type, true);
        ((IRScope)this._scopes.peek()).addSymbol(symbol);
        return symbol;
    }

    public String makeTempSymbolName() {
        String strName = TEMP_VAR_PREFIX + this._tempVarCount;
        ++this._tempVarCount;
        return strName;
    }

    public void pushScope(boolean bInitialInstanceMethodScope) {
        if (this._scopes == null) {
            this._scopes = new Stack();
        }
        IRScope parent = this._scopes.isEmpty() ? null : (IRScope)this._scopes.peek();
        this._scopes.push((Object)new IRScope(parent));
        if (bInitialInstanceMethodScope) {
            assert (parent == null);
            ((IRScope)this._scopes.peek()).addSymbol(Keyword.KW_this.getName(), this._context.getIRTypeForCurrentClass());
        }
    }

    public void popScope() {
        this._scopes.pop();
    }

    public IRSymbol getTypeParamIndex(TypeVariableType type) {
        return ((IRScope)this._scopes.peek()).getSymbol("typeparam$" + type.getRelativeName());
    }

    public IRSymbol getSymbol(String symbolName) {
        IRSymbol symbol = ((IRScope)this._scopes.peek()).getSymbol(symbolName);
        if (symbol == null) {
            throw new IllegalStateException("No symbol found named " + symbolName);
        }
        return symbol;
    }

    public boolean hasSymbol(String symbolName) {
        return ((IRScope)this._scopes.peek()).getSymbol(symbolName) != null;
    }

    public void putSymbols(List<IRSymbol> symbols) {
        for (IRSymbol symbol : symbols) {
            this.putSymbol(symbol);
        }
    }

    public void putSymbol(IRSymbol symbol) {
        ((IRScope)this._scopes.peek()).addSymbol(symbol);
    }

    public IRSymbol createSymbol(String name, IRType type) {
        return ((IRScope)this._scopes.peek()).addSymbol(name, type);
    }

    public Stack<IRScope> getScopes() {
        return this._scopes;
    }

    public boolean isBlockInvoke() {
        return false;
    }

    public DynamicFunctionSymbol getCurrentDFS() {
        return null;
    }

    public boolean isStatic() {
        return this._isStatic;
    }

    private static enum ConstructorState {
        PRE_SUPER,
        SUPER_INVOKED,
        CLEAR;

    }
}

