/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.config.CommonServices;
import gw.internal.gosu.ir.compiler.bytecode.expression.IRMethodCallExpressionCompiler;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.statements.ForEachStatement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRForEachStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.interval.AbstractIntIterator;
import gw.lang.reflect.interval.AbstractLongIterator;
import gw.lang.reflect.interval.IntegerInterval;
import gw.lang.reflect.interval.LongInterval;
import gw.lang.reflect.java.JavaTypes;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ForEachStatementTransformer
extends AbstractStatementTransformer<ForEachStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, ForEachStatement stmt) {
        ForEachStatementTransformer compiler = new ForEachStatementTransformer(cc, stmt);
        return compiler.compile();
    }

    private ForEachStatementTransformer(TopLevelTransformationContext cc, ForEachStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        this._cc().pushScope(false);
        try {
            IRForEachStatement forLoop = this.makeLoopImpl(this._cc(), ExpressionTransformer.compile(((ForEachStatement)this._stmt()).getInExpression(), this._cc()), ((ForEachStatement)this._stmt()).getInExpression().getType(), ((ForEachStatement)this._stmt()).getIdentifier(), ((ForEachStatement)this._stmt()).getIndexIdentifier(), ((ForEachStatement)this._stmt()).getIteratorIdentifier());
            forLoop.setBody(this._cc().compile(((ForEachStatement)this._stmt()).getStatement()));
            IRForEachStatement iRForEachStatement = forLoop;
            return iRForEachStatement;
        }
        finally {
            this._cc().popScope();
        }
    }

    public static IRForEachStatement makeLoop(TopLevelTransformationContext cc, IRExpression rootExpression, IType type, Symbol identifier, Symbol indexSymbol) {
        return new ForEachStatementTransformer(cc, null).makeLoopImpl(cc, rootExpression, type, identifier, indexSymbol, null);
    }

    private IRForEachStatement makeLoopImpl(TopLevelTransformationContext cc, IRExpression rootExpression, IType type, Symbol identifier, Symbol indexSymbol, Symbol iteratorIdentifier) {
        IRForEachStatement forLoop = new IRForEachStatement();
        if (ForEachStatementTransformer.isArrayIteration(type)) {
            this.makeArrayLoop(cc, rootExpression, forLoop, identifier);
        } else if (identifier.getType() == JavaTypes.pINT() && !JavaTypes.NUMBER_INTERVAL().isAssignableFrom(type)) {
            this.makeIntLoop(cc, rootExpression, forLoop, identifier);
        } else {
            this.makeIteratorLoop(cc, rootExpression, forLoop, identifier, iteratorIdentifier);
        }
        if (indexSymbol != null) {
            IRAssignmentStatement indexAssignment = this.initLocalVar(indexSymbol, this.numericLiteral(-1));
            forLoop.addInitializer((IRStatement)indexAssignment);
            IRSymbol indexIRSymbol = indexAssignment.getSymbol();
            if (indexSymbol.isValueBoxed()) {
                IRExpression increment = this.buildAddition(this.buildArrayLoad((IRExpression)this.identifier(indexIRSymbol), 0, ForEachStatementTransformer.getDescriptor(indexSymbol.getType())), this.numericLiteral(1));
                forLoop.addIncrementor(this.buildArrayStore((IRExpression)this.identifier(indexIRSymbol), this.numericLiteral(0), increment, IRTypeConstants.pINT()));
            } else {
                IRExpression increment = this.buildAddition((IRExpression)this.identifier(indexIRSymbol), this.numericLiteral(1));
                forLoop.addIncrementor((IRStatement)this.buildAssignment(indexIRSymbol, increment));
            }
        }
        return forLoop;
    }

    private void makeIteratorLoop(TopLevelTransformationContext cc, IRExpression rootExpression, IRForEachStatement forLoop, Symbol identifier, Symbol iteratorIdentifier) {
        IRExpression nextValue;
        IRExpression iteratorInit = this.callStaticMethod(ForEachStatementTransformer.class, "makeIterator", new Class[]{Object.class, Boolean.TYPE}, ForEachStatementTransformer.exprList(rootExpression, this.pushConstant(this._stmt() != null && ((ForEachStatement)this._stmt()).isStructuralIterable())));
        if (rootExpression.getType() == JavaClassIRType.get(IntegerInterval.class)) {
            iteratorInit = this.checkCast(AbstractIntIterator.class, iteratorInit);
        } else if (rootExpression.getType() == JavaClassIRType.get(LongInterval.class)) {
            iteratorInit = this.checkCast(AbstractLongIterator.class, iteratorInit);
        }
        IRSymbol irSymbol = iteratorIdentifier != null ? this.makeIRSymbol(iteratorIdentifier) : cc.makeAndIndexTempSymbol(iteratorInit.getType());
        IRAssignmentStatement iterator = this.buildAssignment(irSymbol, iteratorInit);
        forLoop.addInitializer((IRStatement)iterator);
        forLoop.setIdentifierToNullCheck(this.identifier(iterator.getSymbol()));
        IRAssignmentStatement loopInitializer = this.initLocalVarWithDefault(identifier);
        forLoop.addInitializer((IRStatement)loopInitializer);
        IRSymbol loopIdentifier = loopInitializer.getSymbol();
        forLoop.setLoopTest(this.callMethod(Iterator.class, "hasNext", new Class[0], (IRExpression)this.identifier(iterator.getSymbol()), Collections.emptyList()));
        if (rootExpression.getType() == JavaClassIRType.get(IntegerInterval.class)) {
            nextValue = this.callMethod(AbstractIntIterator.class, "nextInt", new Class[0], (IRExpression)this.identifier(iterator.getSymbol()), Collections.emptyList());
        } else if (rootExpression.getType() == JavaClassIRType.get(LongInterval.class)) {
            nextValue = this.callMethod(AbstractLongIterator.class, "nextLong", new Class[0], (IRExpression)this.identifier(iterator.getSymbol()), Collections.emptyList());
        } else {
            IRExpression nextMethodCall = this.callMethod(Iterator.class, "next", new Class[0], (IRExpression)this.identifier(iterator.getSymbol()), Collections.emptyList());
            nextValue = this.checkCast(identifier.getType(), nextMethodCall);
        }
        if (identifier.isValueBoxed()) {
            forLoop.addIncrementor((IRStatement)this.buildAssignment(loopIdentifier, this.buildInitializedArray(ForEachStatementTransformer.getDescriptor(identifier.getType()), Collections.singletonList(nextValue))));
        } else {
            forLoop.addIncrementor((IRStatement)this.buildAssignment(loopIdentifier, nextValue));
        }
    }

    private void makeArrayLoop(TopLevelTransformationContext cc, IRExpression rootExpression, IRForEachStatement forLoop, Symbol identifier) {
        IRAssignmentStatement array = this.buildAssignment(cc.makeAndIndexTempSymbol(rootExpression.getType()), rootExpression);
        forLoop.addInitializer((IRStatement)array);
        forLoop.setIdentifierToNullCheck(this.identifier(array.getSymbol()));
        IRAssignmentStatement arrayLen = this.buildAssignment(cc.makeAndIndexTempSymbol(IRTypeConstants.pINT()), this.buildAddition(this.numericLiteral(-1), this.buildNullCheckTernary((IRExpression)this.identifier(array.getSymbol()), this.numericLiteral(-1), this.buildArrayLength((IRExpression)this.identifier(array.getSymbol())))));
        forLoop.addInitializer((IRStatement)arrayLen);
        IRAssignmentStatement arrayPos = this.buildAssignment(cc.makeAndIndexTempSymbol(IRTypeConstants.pINT()), this.numericLiteral(-1));
        forLoop.addInitializer((IRStatement)arrayPos);
        IRAssignmentStatement loopInitializer = this.initLocalVarWithDefault(identifier);
        forLoop.addInitializer((IRStatement)loopInitializer);
        IRSymbol loopIdentifier = loopInitializer.getSymbol();
        forLoop.setLoopTest((IRExpression)this.buildNotEquals((IRExpression)this.identifier(arrayPos.getSymbol()), (IRExpression)this.identifier(arrayLen.getSymbol())));
        forLoop.addIncrementor((IRStatement)this.buildAssignment(arrayPos.getSymbol(), this.buildAddition((IRExpression)this.identifier(arrayPos.getSymbol()), this.numericLiteral(1))));
        IRExpression nextValue = this.buildArrayLoad((IRExpression)this.identifier(array.getSymbol()), (IRExpression)this.identifier(arrayPos.getSymbol()), ForEachStatementTransformer.getDescriptor(identifier.getType()));
        if (identifier.isValueBoxed()) {
            forLoop.addIncrementor((IRStatement)this.buildAssignment(loopIdentifier, this.buildInitializedArray(ForEachStatementTransformer.getDescriptor(identifier.getType()), Collections.singletonList(nextValue))));
        } else {
            forLoop.addIncrementor((IRStatement)this.buildAssignment(loopIdentifier, nextValue));
        }
    }

    private void makeIntLoop(TopLevelTransformationContext cc, IRExpression rootExpression, IRForEachStatement forLoop, Symbol identifier) {
        IRAssignmentStatement intToCountTo = this.buildAssignment(cc.makeAndIndexTempSymbol(IRTypeConstants.pINT()), this.buildAddition(this.makeInt(rootExpression), this.numericLiteral(-1)));
        forLoop.addInitializer((IRStatement)intToCountTo);
        IRAssignmentStatement loopInitializer = this.initLocalVar(identifier, this.numericLiteral(-1));
        forLoop.addInitializer((IRStatement)loopInitializer);
        IRSymbol loopIdentifier = loopInitializer.getSymbol();
        if (identifier.isValueBoxed()) {
            forLoop.setLoopTest((IRExpression)this.buildGreaterThan((IRExpression)this.identifier(intToCountTo.getSymbol()), this.buildArrayLoad((IRExpression)this.identifier(loopIdentifier), 0, loopIdentifier.getType().getComponentType())));
            IRExpression incrementedValue = this.buildAddition(this.buildArrayLoad((IRExpression)this.identifier(loopIdentifier), 0, loopIdentifier.getType().getComponentType()), this.numericLiteral(1));
            forLoop.addIncrementor((IRStatement)this.buildAssignment(loopIdentifier, this.buildInitializedArray(ForEachStatementTransformer.getDescriptor(identifier.getType()), Collections.singletonList(incrementedValue))));
        } else {
            forLoop.setLoopTest((IRExpression)this.buildGreaterThan((IRExpression)this.identifier(intToCountTo.getSymbol()), (IRExpression)this.identifier(loopIdentifier)));
            IRExpression incrementedValue = this.buildAddition((IRExpression)this.identifier(loopIdentifier), this.numericLiteral(1));
            forLoop.addIncrementor((IRStatement)this.buildAssignment(loopIdentifier, incrementedValue));
        }
    }

    private IRExpression makeInt(IRExpression rootExpression) {
        if (rootExpression.getType().isInt()) {
            return rootExpression;
        }
        if (IRTypeConstants.NUMBER().isAssignableFrom(rootExpression.getType())) {
            return this.buildMethodCall(Number.class, "intValue", Integer.TYPE, new Class[0], rootExpression, Collections.emptyList());
        }
        if (rootExpression.getType().isPrimitive()) {
            return this.numberConvert(rootExpression.getType(), IRTypeConstants.pINT(), rootExpression);
        }
        throw new IllegalArgumentException("Cannot create an int from value of type " + rootExpression.getType());
    }

    private static boolean isArrayIteration(IType iterationType) {
        return ForEachStatementTransformer.isBytecodeType(iterationType) && iterationType.isArray();
    }

    public static Iterator makeIterator(Object obj, boolean bStructuralIterable) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        if (bStructuralIterable) {
            return ((Iterable)IRMethodCallExpressionCompiler.constructProxy(obj, Iterable.class)).iterator();
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof String) {
            return new StringIterator((String)obj);
        }
        if (obj instanceof Number) {
            return new NumberIterator((Number)obj);
        }
        if (TypeSystem.getFromObject((Object)obj).isArray()) {
            return new ArrayIterator(obj, TypeSystem.getFromObject((Object)obj));
        }
        return Collections.nCopies(1, obj).iterator();
    }

    static final class NumberIterator
    implements Iterator {
        private int _iIndex;
        private final int _iNum;

        public NumberIterator(Number numObj) {
            this._iNum = numObj.intValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry, the integer iterator does not support remove().");
        }

        @Override
        public boolean hasNext() {
            return this._iIndex < this._iNum;
        }

        public Object next() {
            return this._iIndex++;
        }
    }

    static final class StringIterator
    implements Iterator {
        int iCsr = 0;
        private final String _strObj;

        public StringIterator(String strObj) {
            this._strObj = strObj;
        }

        @Override
        public boolean hasNext() {
            return this.iCsr < this._strObj.length();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index [" + this.iCsr + "] for character iterator");
            }
            return String.valueOf(this._strObj.charAt(this.iCsr++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry, String character iterator does not support remove().");
        }
    }

    static final class ArrayIterator
    implements Iterator {
        private int _iCsr = 0;
        private Object _array;
        private IType _arrayType;

        ArrayIterator(Object array, IType arrayType) {
            this._arrayType = arrayType;
            this._array = CommonServices.getCoercionManager().convertValue(array, this._arrayType);
        }

        @Override
        public boolean hasNext() {
            return this._iCsr < this._arrayType.getArrayLength(this._array);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index [" + this._iCsr + "] for the array.");
            }
            return this._arrayType.getArrayComponent(this._array, this._iCsr++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry, ArrayIterator does not support remove().");
        }
    }
}

