/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.IModule;
import java.util.LinkedList;
import java.util.List;

public class GosuClassCompilingStack {
    private static final ThreadLocal<LinkedList<IType>> g_compilingClassStack = new ThreadLocal();

    public static IType getCurrentCompilingType() {
        LinkedList<IType> list = g_compilingClassStack.get();
        return list != null && !list.isEmpty() ? list.getFirst() : null;
    }

    public static IType getCompilingType(String typeName) {
        List list = g_compilingClassStack.get();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                IType type = (IType)list.get(i);
                if (!type.getName().equals(typeName)) continue;
                return type;
            }
        }
        return null;
    }

    public static void pushCompilingType(IType gsClass) {
        LinkedList<Object> list = g_compilingClassStack.get();
        if (list == null) {
            list = new LinkedList();
            g_compilingClassStack.set(list);
        }
        TypeSystem.pushModule((IModule)gsClass.getTypeLoader().getModule());
        list.add(0, gsClass);
    }

    public static void popCompilingType() {
        List list = g_compilingClassStack.get();
        if (list != null) {
            IType type = (IType)list.remove(0);
            TypeSystem.popModule((IModule)type.getTypeLoader().getModule());
        }
    }
}

