/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.internal.gosu.parser.DefaultTypeLoader;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.GosuClassCompilingStack;
import gw.internal.gosu.parser.ITypeLoaderStackInternal;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.NamespaceType;
import gw.internal.gosu.parser.NewIntrospector;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.TypeRefFactory;
import gw.lang.reflect.IDefaultTypeLoader;
import gw.lang.reflect.IExtendedTypeLoader;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.ITypeRefFactory;
import gw.lang.reflect.IUninitializableTypeLoader;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuClassRepository;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.module.IModule;
import gw.util.GosuClassUtil;
import gw.util.Pair;
import gw.util.Predicate;
import gw.util.cache.FqnCacheNode;
import gw.util.cache.WeakFqnCache;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModuleTypeLoader
implements ITypeLoaderStackInternal {
    private static final IType CACHE_MISS = ErrorType.getInstance("cache-miss-type");
    private IModule _module;
    private List<ITypeLoader> _globalStack;
    private DefaultTypeLoader _defaultTypeLoader;
    private Map<String, ITypeLoader> _loadersByPrefix;
    private WeakFqnCache<IType> _typesByName;
    private Map<String, IType> _namespaceTypesByName;
    private Map<String, IType> _typesByCaseInsensitiveName;
    private ITypeRefFactory _typeRefFactory;

    public ModuleTypeLoader(IModule module, List<ITypeLoader> loaderStack) {
        this._module = module;
        this.initMaps();
        this._globalStack.addAll(loaderStack);
        this._typeRefFactory = module.getModuleTypeLoader().getTypeRefFactory();
        for (ITypeLoader typeLoader : loaderStack) {
            List handledPrefixes = typeLoader.getHandledPrefixes();
            for (int i = 0; i < handledPrefixes.size(); ++i) {
                String handledPrefix = (String)handledPrefixes.get(i);
                this._loadersByPrefix.put(handledPrefix, typeLoader);
            }
        }
    }

    private void initMaps() {
        this._globalStack = new ArrayList<ITypeLoader>();
        this._loadersByPrefix = new HashMap<String, ITypeLoader>();
        this._typesByName = new WeakFqnCache();
        this._namespaceTypesByName = new HashMap<String, IType>();
        this._typesByCaseInsensitiveName = new HashMap<String, IType>();
    }

    public ModuleTypeLoader(IModule module, DefaultTypeLoader defaultTypeLoader) {
        this._module = module;
        this._defaultTypeLoader = defaultTypeLoader;
        this._typeRefFactory = new TypeRefFactory();
        this.reset();
    }

    public void reset() {
        this.initMaps();
        this._globalStack.add((ITypeLoader)this._defaultTypeLoader);
        this._typeRefFactory.clearCaches();
    }

    public IModule getModule() {
        return this._module;
    }

    @Override
    public List<ITypeLoader> getTypeLoaders() {
        return new ArrayList<ITypeLoader>(this._globalStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushTypeLoader(ITypeLoader typeLoader) {
        TypeSystem.lock();
        try {
            this.clearErrorTypes();
            int position = -1;
            for (int i = 0; i < this._globalStack.size(); ++i) {
                ITypeLoader loaderOnStack = this._globalStack.get(i);
                if (loaderOnStack.getClass() != typeLoader.getClass()) continue;
                position = i;
            }
            if (position == -1) {
                this._globalStack.add(0, typeLoader);
            } else {
                this._globalStack.set(position, typeLoader);
            }
            List handledPrefixes = typeLoader.getHandledPrefixes();
            for (int i = 0; i < handledPrefixes.size(); ++i) {
                String handledPrefix = (String)handledPrefixes.get(i);
                this._loadersByPrefix.put(handledPrefix, typeLoader);
            }
            CommonServices.getEntityAccess().getLogger().debug((Object)("TypeLoader added: " + GosuClassUtil.getShortClassName(typeLoader.getClass())));
        }
        finally {
            TypeSystem.unlock();
        }
        CommonServices.getEntityAccess().getLogger().debug((Object)("TypeLoader added: " + GosuClassUtil.getShortClassName(typeLoader.getClass())));
    }

    @Override
    public void clearErrorTypes() {
        TypeSystem.lock();
        try {
            this.removeMissesAndErrorsFromMainCache();
            this.removeMissesAndErrors(this._typesByCaseInsensitiveName.values());
            this.removeMissesAndErrors(this._namespaceTypesByName.values());
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private void removeMissesAndErrorsFromMainCache() {
        this._typesByName.visitNodeDepthFirst((Predicate)new Predicate<FqnCacheNode>(){

            public boolean evaluate(FqnCacheNode node) {
                IType type;
                WeakReference ref = (WeakReference)node.getUserData();
                if (ref != null && ((type = (IType)ref.get()) == CACHE_MISS || type instanceof ErrorType)) {
                    node.delete();
                }
                return true;
            }
        });
    }

    private void removeMissesAndErrors(Collection<IType> types) {
        Iterator<IType> iterator = types.iterator();
        while (iterator.hasNext()) {
            IType type = iterator.next();
            if (type != null && !(type instanceof ErrorType) && type != CACHE_MISS) continue;
            iterator.remove();
        }
    }

    private void clearCaches() {
        this._typesByName.clear();
        this._namespaceTypesByName.clear();
        this._typesByCaseInsensitiveName.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTypeLoader(Class<? extends ITypeLoader> loaderType) {
        TypeSystem.lock();
        try {
            ITypeLoader typeLoader = this.getTypeLoader(loaderType);
            if (typeLoader != null) {
                this._globalStack.remove(typeLoader);
                this.refreshed();
                List handledPrefixes = typeLoader.getHandledPrefixes();
                for (String handledPrefix : handledPrefixes) {
                    this._loadersByPrefix.remove(handledPrefix);
                }
                CommonServices.getEntityAccess().getLogger().debug((Object)("TypeLoader removed: " + GosuClassUtil.getShortClassName(typeLoader.getClass())));
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFromCaches(RefreshRequest request) {
        TypeSystem.lock();
        try {
            for (String fullyQualifiedTypeName : request.types) {
                this.clearFromCaches(fullyQualifiedTypeName);
            }
            this.clearNamespaces(request);
            DefaultTypeLoader defaultTypeLoader = this.getTypeLoader(DefaultTypeLoader.class);
            if (defaultTypeLoader != null) {
                defaultTypeLoader.clearMisses();
            }
            NewIntrospector.flushCaches();
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private void clearNamespaces(RefreshRequest request) {
        for (String fullyQualifiedTypeName : request.types) {
            int pos = fullyQualifiedTypeName.lastIndexOf(46);
            if (pos == -1) continue;
            String pkgName = fullyQualifiedTypeName.substring(0, pos);
            this._namespaceTypesByName.remove(pkgName);
        }
    }

    public Set<TypeName> getTypeNames(String namespace) {
        HashSet<TypeName> names = new HashSet<TypeName>();
        for (ITypeLoader loader : this._globalStack) {
            names.addAll(loader.getTypeNames(namespace));
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ITypeLoader> T getTypeLoader(Class<? extends T> loaderType) {
        TypeSystem.lock();
        try {
            for (ITypeLoader loader : this._globalStack) {
                if (!loader.getClass().equals(loaderType)) continue;
                ITypeLoader iTypeLoader = loader;
                return (T)iTypeLoader;
            }
            Iterator<ITypeLoader> iterator = null;
            return (T)iterator;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    @Override
    public INamespaceType getNamespaceType(String strNamespace) {
        IType foundType = this._namespaceTypesByName.get(strNamespace);
        if (foundType == null) {
            TypeSystem.lock();
            try {
                foundType = this._namespaceTypesByName.get(strNamespace);
                if (foundType == null) {
                    foundType = this.loadNamespaceAndCacheResult(strNamespace);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        if (foundType == CACHE_MISS) {
            return null;
        }
        if (foundType instanceof INamespaceType) {
            return (INamespaceType)foundType;
        }
        return null;
    }

    @Override
    public IType getIntrinsicTypeFromObject(Object object) {
        Object type = null;
        int iLoaders = this._globalStack.size();
        for (int i = 0; i < iLoaders; ++i) {
            ITypeLoader loader;
            try {
                loader = this._globalStack.get(i);
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            if (loader instanceof IExtendedTypeLoader && (!(loader instanceof IGosuObject) || GosuClassCompilingStack.getCompilingType(((IGosuObject)loader).getIntrinsicType().getName()) == null) && (type = ((IExtendedTypeLoader)loader).getIntrinsicTypeFromObject(object)) != null) break;
        }
        if (type == null && this._defaultTypeLoader != null) {
            type = this._defaultTypeLoader.getIntrinsicTypeFromObject(object);
        }
        if (type instanceof IMetaType && !((IMetaType)type).isLiteral()) {
            type = MetaType.getLiteral(((IMetaType)type).getType());
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IType getTypeByFullNameIfValid(String fullyQualifiedName, boolean skipJava) {
        String fqnNoArrays = ModuleTypeLoader.stripArrayBrackets(fullyQualifiedName);
        IType foundType = this.findInCache(fqnNoArrays);
        if (foundType == null) {
            TypeSystem.lock();
            try {
                foundType = this.findInCache(fqnNoArrays);
                if (foundType == null && (foundType = this.findInCaseInsenstiveCache(fqnNoArrays)) != null) {
                    this._typesByName.add(fqnNoArrays, (Object)foundType);
                }
                if (foundType == null) {
                    foundType = this.loadTypeAndCacheResult(fqnNoArrays, skipJava);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        if (foundType == CACHE_MISS) {
            return null;
        }
        if (foundType != null) {
            int numArrays = (fullyQualifiedName.length() - fqnNoArrays.length()) / 2;
            for (int i = 0; i < numArrays; ++i) {
                foundType = foundType.getArrayType();
            }
        }
        return foundType;
    }

    private IType findInCache(String fqnNoArrays) {
        IType foundType = (IType)this._typesByName.get(fqnNoArrays);
        if (foundType == null) {
            foundType = this._typeRefFactory.get(fqnNoArrays);
        }
        if (foundType instanceof ITypeRef && ((ITypeRef)foundType)._shouldReload()) {
            this.clearFromCaches(fqnNoArrays);
            foundType = null;
        }
        if (TypeSystem.isDeleted((IType)foundType)) {
            foundType = null;
        }
        return foundType;
    }

    private IType findInCaseInsenstiveCache(String fqnNoArrays) {
        IType foundType = this._typesByCaseInsensitiveName.get(fqnNoArrays);
        if (foundType instanceof ITypeRef && ((ITypeRef)foundType)._shouldReload()) {
            foundType = null;
        }
        return foundType;
    }

    static String stripArrayBrackets(String name) {
        int checkPos;
        if (name == null) {
            return "";
        }
        for (checkPos = name.length(); checkPos > 2 && name.charAt(checkPos - 2) == '[' && name.charAt(checkPos - 1) == ']'; checkPos -= 2) {
        }
        assert (checkPos <= name.length());
        return checkPos == name.length() ? name : name.substring(0, checkPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IType loadTypeAndCacheResult(String fullyQualifiedName, boolean skipJava) {
        Pair<IType, ITypeLoader> pair;
        TypeSystem.pushModule((IModule)this.getModule());
        try {
            pair = this.loadType(fullyQualifiedName, skipJava);
        }
        finally {
            TypeSystem.popModule((IModule)this.getModule());
        }
        IType type = pair != null ? this.cacheType(fullyQualifiedName, pair) : (!skipJava ? this.cacheType(fullyQualifiedName, (Pair<IType, ITypeLoader>)new Pair((Object)CACHE_MISS, null)) : null);
        return type;
    }

    private IType loadNamespaceAndCacheResult(String fullyQualifiedName) {
        IType type = this.loadNamespaceType(fullyQualifiedName);
        type = type != null ? this.cacheNamespace(fullyQualifiedName, type) : this.cacheNamespace(fullyQualifiedName, CACHE_MISS);
        return type;
    }

    public void refreshed() {
        TypeSystem.lock();
        try {
            this.clearCaches();
            for (ITypeLoader loader : this._globalStack) {
                loader.refreshed();
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private void clearFromCaches(String fullyQualifiedTypeName) {
        this._typesByName.remove(fullyQualifiedTypeName);
        this._typesByCaseInsensitiveName.remove(fullyQualifiedTypeName);
        if (fullyQualifiedTypeName.endsWith("PLACEHOLDER")) {
            this._namespaceTypesByName.remove(fullyQualifiedTypeName.substring(0, fullyQualifiedTypeName.length() - "PLACEHOLDER".length() - 1));
        }
    }

    private Pair<IType, ITypeLoader> loadType(String fullyQualifiedName, boolean skipJava) {
        String prefix;
        ITypeLoader typeLoader;
        IType type = TypeLoaderAccess.instance().getDefaultType(fullyQualifiedName);
        if (type != null) {
            return new Pair((Object)type, (Object)type.getTypeLoader());
        }
        int dotIdx = fullyQualifiedName.indexOf(46);
        if (dotIdx > 0 && fullyQualifiedName.indexOf(46, dotIdx + 1) < 0 && (typeLoader = this._loadersByPrefix.get(prefix = fullyQualifiedName.substring(0, dotIdx))) != null && typeLoader.isInited()) {
            return new Pair((Object)typeLoader.getType(fullyQualifiedName), (Object)typeLoader);
        }
        for (ITypeLoader loader : this._globalStack) {
            if (loader instanceof IGosuObject && (((IGosuObject)loader).getIntrinsicType().getName().equals(fullyQualifiedName) || GosuClassCompilingStack.getCompilingType(((IGosuObject)loader).getIntrinsicType().getName()) != null) || !loader.handlesNonPrefixLoads() || !loader.isInited() || loader instanceof IDefaultTypeLoader && skipJava || (type = loader.getType(fullyQualifiedName)) == null) continue;
            return new Pair((Object)type, (Object)loader);
        }
        return null;
    }

    private IType loadNamespaceType(String namespace) {
        for (int i = 0; i < this._globalStack.size(); ++i) {
            ITypeLoader loader = this._globalStack.get(i);
            if (loader instanceof IGosuObject && GosuClassCompilingStack.getCompilingType(((IGosuObject)loader).getIntrinsicType().getName()) != null || !loader.hasNamespace(namespace) && !this.isProxyType(namespace, loader)) continue;
            return new NamespaceType(namespace, this.getModule());
        }
        return null;
    }

    private boolean isProxyType(String fullyQualifiedName, ITypeLoader loader) {
        String minusProxy;
        return (loader == this._defaultTypeLoader || loader.getClass() == GosuClassTypeLoader.class) && IGosuClass.ProxyUtil.isProxyClass((String)fullyQualifiedName) && loader.hasNamespace(minusProxy = fullyQualifiedName.substring("_proxy_".length() + 1));
    }

    public List<ITypeLoader> getTypeLoaderStack() {
        return this._globalStack;
    }

    private IType cacheType(String name, Pair<IType, ITypeLoader> pair) {
        if (pair != null) {
            IType type = (IType)pair.getFirst();
            IType oldType = (IType)this._typesByName.get(name);
            if (oldType != null && oldType != CACHE_MISS) {
                return oldType;
            }
            this._typesByName.add(name, (Object)type);
            ITypeLoader typeLoader = (ITypeLoader)pair.getSecond();
            if (typeLoader != null && !typeLoader.isCaseSensitive()) {
                this._typesByCaseInsensitiveName.put(name, type);
            }
        }
        return pair != null ? (IType)pair.getFirst() : null;
    }

    private IType cacheNamespace(String name, IType type) {
        IType oldType;
        if (type != null && (oldType = this._namespaceTypesByName.put(name, type)) != null && oldType != CACHE_MISS) {
            this._namespaceTypesByName.put(name, oldType);
            return oldType;
        }
        return type;
    }

    public ITypeRefFactory getTypeRefFactory() {
        return this._typeRefFactory;
    }

    public void uninitializeTypeLoaders() {
        for (ITypeLoader typeLoader : this._globalStack) {
            if (!(typeLoader instanceof IUninitializableTypeLoader)) continue;
            ((IUninitializableTypeLoader)typeLoader).uninitialize();
        }
    }

    public DefaultTypeLoader getDefaultTypeLoader() {
        return this._defaultTypeLoader;
    }

    public String toString() {
        return this._module.toString();
    }

    public void shutdown() {
        for (ITypeLoader typeLoader : this._globalStack) {
            typeLoader.shutdown();
        }
    }

    @Override
    public boolean refresh(IResource file, String typeName, RefreshKind refreshKind) {
        TypeSystem.pushModule((IModule)this.getModule());
        TypeSystem.lock();
        try {
            if (file instanceof IFile) {
                boolean bl = this.refreshFile((IFile)file, typeName, refreshKind);
                return bl;
            }
            if (file instanceof IDirectory) {
                boolean bl = this.refreshDirectory((IDirectory)file, refreshKind);
                return bl;
            }
            throw new RuntimeException("Unknown resource: " + file);
        }
        finally {
            TypeSystem.unlock();
            TypeSystem.popModule((IModule)this.getModule());
        }
    }

    private boolean refreshDirectory(IDirectory directory, RefreshKind kind) {
        boolean processed = false;
        for (ITypeLoader typeLoader : this._globalStack) {
            if (!typeLoader.handlesDirectory(directory)) continue;
            String namespace = typeLoader.getNamespaceForDirectory(directory);
            if (namespace != null) {
                this.refreshNamespaceCaches(namespace, typeLoader, kind);
                typeLoader.refreshedNamespace(namespace, directory, kind);
            }
            processed = true;
        }
        for (IFile file : directory.listFiles()) {
            processed |= this.refreshFile(file, null, kind);
        }
        for (IDirectory dir : directory.listDirs()) {
            processed |= this.refreshDirectory(dir, kind);
        }
        return processed;
    }

    private void refreshNamespaceCaches(String namespace, ITypeLoader typeLoader, RefreshKind kind) {
        IGosuClassRepository repository;
        if (kind == RefreshKind.CREATION) {
            this._namespaceTypesByName.remove(namespace);
            this.clearErrorTypes();
        } else if (kind == RefreshKind.DELETION && typeLoader.getClass() == GosuClassTypeLoader.class && (repository = ((GosuClassTypeLoader)typeLoader).getRepository()).hasNamespace(namespace) == 1) {
            this._namespaceTypesByName.put(namespace, CACHE_MISS);
        }
    }

    private boolean refreshFile(IFile file, String typeName, RefreshKind kind) {
        boolean processed = false;
        for (ITypeLoader typeLoader : this._globalStack) {
            if (!typeLoader.handlesFile(file)) continue;
            String[] types = typeName != null ? new String[]{typeName} : typeLoader.getTypesForFile(file);
            kind = typeLoader.refreshedFile(file, types, kind);
            if (types != null && types.length != 0) {
                RefreshRequest refreshRequest = new RefreshRequest(file, types, typeLoader, kind);
                TypeLoaderAccess.instance().refreshTypes(refreshRequest);
            }
            processed = true;
        }
        return processed;
    }

    public IType getCachedType(String fqn) {
        IType foundType = this.findInCache(fqn);
        if (foundType == null) {
            foundType = this.findInCaseInsenstiveCache(fqn);
        }
        return foundType;
    }
}

