/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRExpression;
import gw.lang.ir.expression.IREqualityExpression;
import gw.lang.ir.expression.IRNullLiteral;
import gw.lang.ir.expression.IRTernaryExpression;

public class IRTernaryExpressionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRTernaryExpression expression, IRBytecodeContext context) {
        MethodVisitor mv = context.getMv();
        Label trueLabel = new Label();
        if (IRTernaryExpressionCompiler.isComparisonToNull(expression.getTest())) {
            IRBytecodeCompiler.compileIRExpression(IRTernaryExpressionCompiler.getNonNullEqualityOperand(expression.getTest()), context);
            mv.visitJumpInsn(IRTernaryExpressionCompiler.getNullOpCode(expression.getTest()), trueLabel);
        } else {
            IRBytecodeCompiler.compileIRExpression(expression.getTest(), context);
            mv.visitJumpInsn(154, trueLabel);
        }
        IRBytecodeCompiler.compileIRExpression(expression.getFalseValue(), context);
        Label falseLabel = new Label();
        mv.visitJumpInsn(167, falseLabel);
        mv.visitLabel(trueLabel);
        IRBytecodeCompiler.compileIRExpression(expression.getTrueValue(), context);
        mv.visitLabel(falseLabel);
    }

    private static int getNullOpCode(IRExpression test) {
        IREqualityExpression equalityExpression = (IREqualityExpression)test;
        if (equalityExpression.isEquals()) {
            return 198;
        }
        return 199;
    }

    private static boolean isComparisonToNull(IRExpression testExpression) {
        IREqualityExpression equalityExpression;
        return testExpression instanceof IREqualityExpression && ((equalityExpression = (IREqualityExpression)testExpression).getLhs() instanceof IRNullLiteral || equalityExpression.getRhs() instanceof IRNullLiteral);
    }

    private static IRExpression getNonNullEqualityOperand(IRExpression testExpression) {
        IREqualityExpression equalityExpression = (IREqualityExpression)testExpression;
        if (equalityExpression.getLhs() instanceof IRNullLiteral) {
            return equalityExpression.getRhs();
        }
        return equalityExpression.getLhs();
    }
}

