/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.expressions.ArithmeticExpression;
import gw.lang.ir.IRExpression;
import gw.lang.ir.expression.IRArithmeticExpression;
import gw.lang.reflect.java.JavaTypes;

public abstract class AbstractBitwiseExpressionTransformer<T extends ArithmeticExpression>
extends AbstractExpressionTransformer<T> {
    protected AbstractBitwiseExpressionTransformer(TopLevelTransformationContext cc, T expr) {
        super(cc, expr);
    }

    protected abstract IRArithmeticExpression.Operation getOp();

    @Override
    protected IRExpression compile_impl() {
        IRExpression lhs = ExpressionTransformer.compile(((ArithmeticExpression)this._expr()).getLHS(), this._cc());
        IRExpression rhs = ExpressionTransformer.compile(((ArithmeticExpression)this._expr()).getRHS(), this._cc());
        this.verifyTypes();
        return new IRArithmeticExpression(AbstractBitwiseExpressionTransformer.getDescriptor(((ArithmeticExpression)this._expr()).getType()), lhs, rhs, this.getOp());
    }

    private void verifyTypes() {
        if (((ArithmeticExpression)this._expr()).getLHS().getType() != ((ArithmeticExpression)this._expr()).getRHS().getType()) {
            throw new IllegalStateException("Bitwise operands are not the same type: lhs=" + ((ArithmeticExpression)this._expr()).getLHS().getType().getName() + " rhs=" + ((ArithmeticExpression)this._expr()).getRHS().getType().getName());
        }
        if (((ArithmeticExpression)this._expr()).getLHS().getType() != JavaTypes.pINT() && ((ArithmeticExpression)this._expr()).getLHS().getType() != JavaTypes.pLONG() && ((ArithmeticExpression)this._expr()).getLHS().getType() != JavaTypes.pBOOLEAN()) {
            throw new IllegalStateException("Operands must be int or long, found: " + ((ArithmeticExpression)this._expr()).getLHS().getType().getName());
        }
    }
}

