/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.parser.CannotExecuteGosuException;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.expressions.BinaryExpression;
import gw.lang.parser.expressions.IIntervalExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.interval.ISequenceable;
import gw.lang.reflect.java.JavaTypes;

public final class IntervalExpression
extends BinaryExpression
implements IIntervalExpression {
    private boolean _bLeftClosed;
    private boolean _bRightClosed;

    public IntervalExpression(boolean bLeftClosed, boolean bRightClosed, Expression lhsExpr, Expression rhsExpr) {
        this._bLeftClosed = bLeftClosed;
        this._bRightClosed = bRightClosed;
        this.setLHS(lhsExpr);
        this.setRHS(rhsExpr);
        this.setOperator((bLeftClosed ? "" : "|") + ".." + (bRightClosed ? "" : "|"));
    }

    public boolean isLeftClosed() {
        return this._bLeftClosed;
    }

    public boolean isRightClosed() {
        return this._bRightClosed;
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        throw new CannotExecuteGosuException();
    }

    public static IType getIntervalType(IType type) {
        if (AbstractElementTransformer.isIntType(type) || AbstractElementTransformer.isBoxedIntType(type)) {
            return JavaTypes.INTEGER_INTERVAL();
        }
        if (type == JavaTypes.pLONG() || type == JavaTypes.LONG()) {
            return JavaTypes.LONG_INTERVAL();
        }
        if (type == JavaTypes.BIG_INTEGER()) {
            return JavaTypes.BIG_INTEGER_INTERVAL();
        }
        if (type == JavaTypes.pFLOAT() || type == JavaTypes.FLOAT() || type == JavaTypes.pDOUBLE() || type == JavaTypes.DOUBLE() || type == JavaTypes.BIG_DECIMAL()) {
            return JavaTypes.BIG_DECIMAL_INTERVAL();
        }
        if (JavaTypes.DATE().isAssignableFrom(type)) {
            return JavaTypes.DATE_INTERVAL();
        }
        if (JavaTypes.getGosuType(ISequenceable.class).isAssignableFrom(type)) {
            if (type instanceof ErrorType) {
                return JavaTypes.SEQUENCEABLE_INTERVAL().getParameterizedType(new IType[]{type, JavaTypes.OBJECT(), JavaTypes.OBJECT()});
            }
            IType parameterizedSequenceable = TypeLord.findParameterizedType(type, (IType)JavaTypes.getGosuType(ISequenceable.class));
            return JavaTypes.SEQUENCEABLE_INTERVAL().getParameterizedType(new IType[]{type, parameterizedSequenceable.getTypeParameters()[1], parameterizedSequenceable.getTypeParameters()[2]});
        }
        if (type instanceof ErrorType) {
            return JavaTypes.COMPARABLE_INTERVAL().getParameterizedType(new IType[]{JavaTypes.OBJECT()});
        }
        return JavaTypes.COMPARABLE_INTERVAL().getParameterizedType(new IType[]{type});
    }
}

