/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.gosu.ir.compiler.bytecode.IRCompilerScope;
import gw.lang.GosuShop;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;

public class IRCompilerLocalVar {
    private String _name;
    private IRType _type;
    private int _index;
    private IRCompilerScope _scope;
    private Label _startLabel;
    private Label _endLabel;
    private boolean _temp;

    public IRCompilerLocalVar(IRSymbol symbol, int index, IRCompilerScope scope) {
        this._name = symbol.getName();
        this._type = IRCompilerLocalVar.maybeEraseStructuralType(symbol.getType());
        this._temp = symbol.isTemp();
        this._index = index;
        this._scope = scope;
    }

    public String getName() {
        return this._name;
    }

    public IRType getType() {
        return this._type;
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public IRCompilerScope getScope() {
        return this._scope;
    }

    public Label getStartLabel() {
        return this._startLabel;
    }

    public Label getEndLabel() {
        return this._endLabel;
    }

    public void setStartLabel(Label startLabel) {
        this._startLabel = startLabel;
    }

    public void setEndLabel(Label endLabel) {
        this._endLabel = endLabel;
    }

    public boolean isTemp() {
        return this._temp;
    }

    public int getWidth() {
        return this._type.getName().equals("long") || this._type.getName().equals("double") ? 2 : 1;
    }

    private static IRType maybeEraseStructuralType(IRType type) {
        IRType originalType = type;
        int iArrayDims = 0;
        while (type.isArray()) {
            ++iArrayDims;
            type = type.getComponentType();
        }
        if (type.isStructural()) {
            type = GosuShop.getIRTypeResolver().getDescriptor(Object.class);
            while (iArrayDims-- > 0) {
                type = type.getArrayType();
            }
        } else {
            type = originalType;
        }
        return type;
    }
}

