/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode;

import gw.internal.ext.org.objectweb.asm.Label;
import gw.internal.gosu.compiler.NamedLabel;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRStatement;
import gw.lang.ir.statement.IRBreakStatement;
import gw.lang.ir.statement.IRContinueStatement;
import gw.lang.ir.statement.IRLoopStatement;
import gw.lang.ir.statement.IRSwitchStatement;
import gw.lang.ir.statement.IRTerminalStatement;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import java.util.ArrayList;
import java.util.List;

public class IRFinallyCodePartitioner {
    private IRBytecodeContext _context;
    private IRTryCatchFinallyStatement _tryCatchFinallyStmt;
    private List<Label> _finallyStarts;
    private List<Label> _finallyEnds;

    public IRFinallyCodePartitioner(IRBytecodeContext context, IRTryCatchFinallyStatement tryCatchFinallyStmt) {
        this._context = context;
        this._tryCatchFinallyStmt = tryCatchFinallyStmt;
        this._finallyStarts = new ArrayList<Label>();
        this._finallyEnds = new ArrayList<Label>();
    }

    public String toString() {
        return this._tryCatchFinallyStmt.getFinallyBody().toString();
    }

    public void inlineFinally() {
        NamedLabel startLabel = new NamedLabel("FinallyStart" + this._finallyStarts.size());
        this._finallyStarts.add(startLabel);
        this._context.visitLabel(startLabel);
        IRBytecodeCompiler.compileIRStatement(this._tryCatchFinallyStmt.getFinallyBody(), this._context);
    }

    public List<Label> getFinallyStarts() {
        return this._finallyStarts;
    }

    public List<Label> getFinallyEnds() {
        return this._finallyEnds;
    }

    public boolean appliesTo(IRTerminalStatement elt) {
        return IRFinallyCodePartitioner.applies((IRStatement)this._tryCatchFinallyStmt, elt);
    }

    public static boolean applies(IRStatement statement, IRTerminalStatement terminal) {
        return !IRFinallyCodePartitioner.isContainedControlFlow(terminal, statement);
    }

    private static boolean isContainedControlFlow(IRTerminalStatement elt, IRStatement stmt) {
        if (elt instanceof IRBreakStatement || elt instanceof IRContinueStatement) {
            return IRFinallyCodePartitioner.elementIsEnclosedBy((IRElement)elt, IRLoopStatement.class, stmt) || IRFinallyCodePartitioner.elementIsEnclosedBy((IRElement)elt, IRSwitchStatement.class, stmt);
        }
        return false;
    }

    private static boolean elementIsEnclosedBy(IRElement elt, Class enclosedType, IRStatement stmt) {
        if (elt == null || elt == stmt) {
            return false;
        }
        if (enclosedType.isAssignableFrom(elt.getClass())) {
            return true;
        }
        return IRFinallyCodePartitioner.elementIsEnclosedBy(elt.getParent(), enclosedType, stmt);
    }

    public void endInlineFinally(Label endLabel) {
        this._finallyEnds.add(endLabel);
    }
}

