/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.parser.statements.ReturnStatement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.expression.IRNullLiteral;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRReturnStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRSyntheticStatement;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.expressions.IBlockLiteralExpression;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.ITryCatchFinallyStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.JavaTypes;

public class ReturnStatementTransformer
extends AbstractStatementTransformer<ReturnStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, ReturnStatement stmt) {
        ReturnStatementTransformer gen = new ReturnStatementTransformer(cc, stmt);
        return gen.compile();
    }

    private ReturnStatementTransformer(TopLevelTransformationContext cc, ReturnStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        IType retType = ((ReturnStatement)this._stmt()).getValue().getType();
        if (retType != JavaTypes.pVOID()) {
            IRExpression returnValue = this.compileReturnExpr(retType);
            return this.makeReturnStmt(returnValue);
        }
        if (this._cc().isBlockInvoke()) {
            if (((ReturnStatement)this._stmt()).getValue() != null) {
                return new IRStatementList(false, new IRStatement[]{new IRSyntheticStatement(this.compileReturnExpr(retType)), this.makeReturnStmt(this.nullLiteral())});
            }
            return this.makeReturnStmt(this.nullLiteral());
        }
        return this.buildReturn();
    }

    private IRReturnStatement makeReturnStmt(IRExpression returnValue) {
        if (this.needsTempVar()) {
            IRAssignmentStatement tempVarAssignment = this.buildAssignment(this._cc().makeAndIndexTempSymbol(returnValue.getType()), returnValue);
            IRIdentifier id = this.identifier(tempVarAssignment.getSymbol());
            return new IRReturnStatement((IRStatement)tempVarAssignment, (IRExpression)id);
        }
        return new IRReturnStatement(null, returnValue);
    }

    private boolean needsTempVar() {
        return this.finallyBlockInParentHierarchy((IParsedElement)this._stmt());
    }

    private boolean finallyBlockInParentHierarchy(IParsedElement stmt) {
        if (stmt == null || stmt instanceof IBlockLiteralExpression || stmt instanceof IClassStatement) {
            return false;
        }
        if (stmt instanceof ITryCatchFinallyStatement && ((ITryCatchFinallyStatement)stmt).getFinallyStatement() != null) {
            return true;
        }
        return this.finallyBlockInParentHierarchy(stmt.getParent());
    }

    private IRExpression compileReturnExpr(IType retType) {
        IRExpression expression = ExpressionTransformer.compile(((ReturnStatement)this._stmt()).getValue(), this._cc());
        if ((this._cc().isBlockInvoke() || this._cc().isFragmentEvaluation()) && retType.isPrimitive()) {
            expression = this.boxValue(retType, expression);
        }
        if (!this._cc().isBlockInvoke() && this._cc().getCurrentFunctionReturnType() != null) {
            IRType returnTypeDescriptor = ReturnStatementTransformer.getDescriptor(this._cc().getCurrentFunctionReturnType());
            if (!(expression instanceof IRNullLiteral && !this.finallyBlockInParentHierarchy((IParsedElement)this._stmt()) || returnTypeDescriptor.isAssignableFrom(expression.getType()))) {
                expression = this.buildCast(returnTypeDescriptor, expression);
            }
        }
        return expression;
    }
}

