/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.config.CommonServices;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.statements.CatchClause;
import gw.internal.gosu.parser.statements.TryCatchFinallyStatement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.statement.IRCatchClause;
import gw.lang.ir.statement.IRIfStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRThrowStatement;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import gw.lang.parser.EvaluationException;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TryCatchFinallyStatementTransformer
extends AbstractStatementTransformer<TryCatchFinallyStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, TryCatchFinallyStatement stmt) {
        TryCatchFinallyStatementTransformer compiler = new TryCatchFinallyStatementTransformer(cc, stmt);
        return compiler.compile();
    }

    private TryCatchFinallyStatementTransformer(TopLevelTransformationContext cc, TryCatchFinallyStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        IRStatement tryBody = this._cc().compile(((TryCatchFinallyStatement)this._stmt()).getTryStatement());
        List<Object> catchStatements = Collections.emptyList();
        if (((TryCatchFinallyStatement)this._stmt()).getCatchStatements() != null) {
            catchStatements = this.compileCatchStatements();
        }
        IRStatement finallyBody = null;
        if (((TryCatchFinallyStatement)this._stmt()).getFinallyStatement() != null) {
            finallyBody = this._cc().compile(((TryCatchFinallyStatement)this._stmt()).getFinallyStatement());
        }
        return new IRTryCatchFinallyStatement(tryBody, catchStatements, finallyBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IRCatchClause> compileCatchStatements() {
        ArrayList<IRCatchClause> resultingClauses = new ArrayList<IRCatchClause>();
        List<CatchClause> catchStmts = ((TryCatchFinallyStatement)this._stmt()).getCatchStatements();
        ArrayList<CatchClause> otherCatches = new ArrayList<CatchClause>();
        boolean bThrowableFound = false;
        for (CatchClause c : catchStmts) {
            Statement catchStmt = c.getCatchStmt();
            this._cc().pushScope(false);
            try {
                IType type = c.getCatchType();
                if ((type == null || TryCatchFinallyStatementTransformer.isBytecodeType(type)) && otherCatches.isEmpty()) {
                    Symbol catchSymbol = c.getSymbol();
                    IRSymbol exceptionParam = this.createCatchClauseSymbol(catchSymbol, type);
                    ArrayList<IRStatement> bodyStatements = new ArrayList<IRStatement>();
                    if (this.wrapInEvalException(type)) {
                        bodyStatements.add(this.wrapUndeclaredAsEvaluationException(exceptionParam, catchSymbol.getName(), catchSymbol.isValueBoxed()));
                    } else if (catchSymbol.isValueBoxed()) {
                        bodyStatements.add(this.boxCatchSymbol(exceptionParam.getType(), catchSymbol.getName(), (IRExpression)this.identifier(exceptionParam)));
                    }
                    bodyStatements.add(this._cc().compile(catchStmt));
                    resultingClauses.add(new IRCatchClause(exceptionParam, (IRStatement)new IRStatementList(false, bodyStatements)));
                    continue;
                }
                bThrowableFound = bThrowableFound || this.wrapInEvalException(type) || type == JavaTypes.THROWABLE();
                otherCatches.add(c);
            }
            finally {
                this._cc().popScope();
            }
        }
        if (!otherCatches.isEmpty()) {
            if (!bThrowableFound) {
                CatchClause catchClause = new CatchClause();
                catchClause.init((IType)JavaTypes.THROWABLE(), null, null);
                otherCatches.add(catchClause);
            }
            this.compileOtherCatchStatements(this._cc(), otherCatches, resultingClauses);
        }
        return resultingClauses;
    }

    private boolean wrapInEvalException(IType type) {
        return type == null && !CommonServices.getEntityAccess().getLanguageLevel().supportsNakedCatchStatements();
    }

    private IRSymbol createCatchClauseSymbol(Symbol symbol, IType type) {
        boolean temp = symbol.isValueBoxed() || this.wrapInEvalException(type);
        String name = symbol.getName();
        if (temp) {
            name = name + "$$temp";
        }
        if (type == null) {
            type = CatchClause.getNakedCatchExceptionType();
        }
        IRSymbol irSymbol = new IRSymbol(name, TryCatchFinallyStatementTransformer.getDescriptor(type), temp);
        this._cc().putSymbol(irSymbol);
        return irSymbol;
    }

    private IRStatement wrapUndeclaredAsEvaluationException(IRSymbol catchSymbol, String properName, boolean isBoxed) {
        IRExpression wrapper = this.wrapCatchSymbol((IRExpression)this.identifier(catchSymbol));
        if (isBoxed) {
            return this.boxCatchSymbol(catchSymbol.getType(), properName, wrapper);
        }
        return this.reassignCatchSymbol(catchSymbol.getType(), properName, wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileOtherCatchStatements(TopLevelTransformationContext cc, List<CatchClause> otherCatches, List<IRCatchClause> resultingClauses) {
        cc.pushScope(false);
        try {
            IRSymbol exceptionSymbol = new IRSymbol("exception$$temp$$var", TryCatchFinallyStatementTransformer.getDescriptor(Throwable.class), true);
            cc.putSymbol(exceptionSymbol);
            ArrayList<Object> catchBody = new ArrayList<Object>();
            IRSymbol exceptionTypeSymbol = new IRSymbol("exceptiontype$$temp$$var", IRTypeConstants.ITYPE(), true);
            cc.putSymbol(exceptionTypeSymbol);
            catchBody.add(this.buildAssignment(exceptionTypeSymbol, this.callStaticMethod(TypeSystem.class, "getFromObject", new Class[]{Object.class}, TryCatchFinallyStatementTransformer.exprList(new IRExpression[]{this.identifier(exceptionSymbol)}))));
            IRIfStatement lastStatement = null;
            for (CatchClause clause : otherCatches) {
                cc.pushScope(false);
                try {
                    Symbol symbol = clause.getSymbol();
                    IType type = clause.getCatchType();
                    if (type == null) {
                        type = JavaTypes.THROWABLE();
                    }
                    if (symbol != null) {
                        if (type != JavaTypes.THROWABLE()) {
                            IRExpression test = this.callMethod(IType.class, "isAssignableFrom", new Class[]{IType.class}, this.pushType(type), TryCatchFinallyStatementTransformer.exprList(new IRExpression[]{this.identifier(exceptionTypeSymbol)}));
                            ArrayList<IRStatement> body = new ArrayList<IRStatement>();
                            body.add(this.assignCatchClauseSymbol(exceptionSymbol, symbol.getName(), type, symbol.isValueBoxed()));
                            body.add(cc.compile(clause.getCatchStmt()));
                            IRIfStatement nestedCatchStatement = new IRIfStatement(test, (IRStatement)new IRStatementList(false, body), null);
                            if (lastStatement == null) {
                                catchBody.add(nestedCatchStatement);
                            } else if (lastStatement.getElseStatement() == null) {
                                lastStatement.setElseStatement((IRStatement)nestedCatchStatement);
                            }
                            lastStatement = nestedCatchStatement;
                            continue;
                        }
                        ArrayList<IRStatement> body = new ArrayList<IRStatement>();
                        body.add(this.assignCatchClauseSymbol(exceptionSymbol, symbol.getName(), clause.getCatchType(), symbol.isValueBoxed()));
                        body.add(cc.compile(clause.getCatchStmt()));
                        if (lastStatement != null) {
                            lastStatement.setElseStatement((IRStatement)new IRStatementList(false, body));
                            break;
                        }
                        catchBody.addAll(body);
                        break;
                    }
                    lastStatement.setElseStatement((IRStatement)new IRThrowStatement((IRExpression)this.identifier(exceptionSymbol)));
                }
                finally {
                    cc.popScope();
                }
            }
            resultingClauses.add(new IRCatchClause(exceptionSymbol, (IRStatement)new IRStatementList(false, catchBody)));
        }
        finally {
            cc.popScope();
        }
    }

    private IRStatement assignCatchClauseSymbol(IRSymbol genericCatchSymbol, String expectedName, IType expectedType, boolean isBoxed) {
        IRExpression root;
        IRType descriptorType;
        if (expectedType == null) {
            descriptorType = TryCatchFinallyStatementTransformer.getDescriptor(RuntimeException.class);
            root = this.wrapCatchSymbol((IRExpression)this.identifier(genericCatchSymbol));
        } else {
            descriptorType = TryCatchFinallyStatementTransformer.getDescriptor(expectedType);
            root = this.buildCast(descriptorType, (IRExpression)this.identifier(genericCatchSymbol));
        }
        if (isBoxed) {
            return this.boxCatchSymbol(descriptorType, expectedName, root);
        }
        return this.reassignCatchSymbol(descriptorType, expectedName, root);
    }

    private IRStatement reassignCatchSymbol(IRType symbolType, String properName, IRExpression rootValue) {
        IRSymbol newSymbol = new IRSymbol(properName, symbolType, false);
        this._cc().putSymbol(newSymbol);
        return this.buildAssignment(newSymbol, rootValue);
    }

    private IRExpression wrapCatchSymbol(IRExpression rootValue) {
        return this.callStaticMethod(EvaluationException.class, "wrap", new Class[]{Throwable.class}, TryCatchFinallyStatementTransformer.exprList(rootValue));
    }

    private IRStatement boxCatchSymbol(IRType componentType, String properName, IRExpression rootValue) {
        IRSymbol newSymbol = new IRSymbol(properName, componentType.getArrayType(), false);
        this._cc().putSymbol(newSymbol);
        IRExpression arrayBox = this.buildInitializedArray(componentType, TryCatchFinallyStatementTransformer.exprList(rootValue));
        return this.buildAssignment(newSymbol, arrayBox);
    }
}

