/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.util;

import gw.internal.gosu.compiler.FunctionClassUtil;
import gw.internal.gosu.ir.nodes.GosuClassIRType;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeVariableType;
import gw.lang.ir.IRType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.IJavaBackedType;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaType;
import gw.util.GosuExceptionUtil;
import java.util.ArrayList;
import java.util.List;

public class IRTypeResolver {
    public static IRType getDescriptor(IType type) {
        return IRTypeResolver.getDescriptor(type, false);
    }

    public static IRType getDescriptor(IType type, boolean getConcreteTypeForMetaType) {
        IType iType = type = type instanceof IMetaType ? type : TypeLord.getPureGenericType(type);
        if (type instanceof IJavaType) {
            try {
                return JavaClassIRType.get(((IJavaType)type).getBackingClassInfo());
            }
            catch (Exception e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e, (String)type.getName());
            }
        }
        if (type instanceof IGosuClassInternal) {
            if (IGosuClass.ProxyUtil.isProxy((IType)type)) {
                return IRTypeResolver.getDescriptor(IGosuClass.ProxyUtil.getProxiedType((IType)type), getConcreteTypeForMetaType);
            }
            return GosuClassIRType.get(type);
        }
        if (IRTypeResolver.getJavaBackedClass(type) != null) {
            return IRTypeResolver.getDescriptor(IRTypeResolver.getJavaBackedClass(type));
        }
        if (type.isArray()) {
            return IRTypeResolver.getDescriptor(type.getComponentType(), false).getArrayType();
        }
        if (type instanceof TypeVariableType) {
            return IRTypeResolver.getDescriptor(((TypeVariableType)type).getBoundingType(), getConcreteTypeForMetaType);
        }
        if (type instanceof IFunctionType) {
            return IRTypeResolver.getDescriptor((IType)FunctionClassUtil.getFunctionInterfaceForArity(((IFunctionType)type).getParameterTypes().length));
        }
        if (type instanceof MetaType) {
            if (getConcreteTypeForMetaType) {
                return IRTypeResolver.getConcreteIRTypeForMetaType((MetaType)type);
            }
            return IRTypeResolver.getDescriptor(IType.class);
        }
        return IRTypeResolver.getDescriptor(Object.class);
    }

    public static IRType getDescriptor(Class cls) {
        return JavaClassIRType.get(cls);
    }

    public static IRType getDescriptor(IJavaClassInfo cls) {
        return JavaClassIRType.get(cls);
    }

    public static IRType getConcreteIRTypeForMetaType(MetaType metaType) {
        if (((IType)MetaType.DEFAULT_TYPE_TYPE.get()).getName().equals(metaType.getName()) || ((MetaType)((Object)MetaType.ROOT_TYPE_TYPE.get())).getName().equals(metaType.getName())) {
            return IRTypeResolver.getDescriptor(IType.class);
        }
        IType underlyingType = metaType.getType();
        if (AbstractElementTransformer.isBytecodeType(underlyingType) && !IRTypeResolver.isEntityType(underlyingType)) {
            return IRTypeResolver.getDescriptor(underlyingType.getClass());
        }
        return IRTypeResolver.getDescriptor(IType.class);
    }

    private static boolean isEntityType(IType type) {
        String namespace = type.getNamespace();
        return "entity".equals(namespace) || "typekey".equals(namespace);
    }

    public static IJavaClassInfo getJavaBackedClass(IType arg) {
        if (arg instanceof IJavaBackedType) {
            IJavaClassInfo cls = ((IJavaBackedType)arg).getBackingClassInfo();
            if (cls == null) {
                throw new IllegalStateException("Type: " + arg.getName() + " returned null Class from IJavaBackedType.getBackingClassInfo()");
            }
            return cls;
        }
        return null;
    }

    public static List<IRType> getDescriptors(IJavaClassInfo[] classes) {
        ArrayList<IRType> irTypes = new ArrayList<IRType>(classes.length);
        for (IJavaClassInfo parameterClass : classes) {
            irTypes.add(IRTypeResolver.getDescriptor(parameterClass));
        }
        return irTypes;
    }

    public static List<IRType> getDescriptors(Class[] classes) {
        ArrayList<IRType> irTypes = new ArrayList<IRType>(classes.length);
        for (Class parameterClass : classes) {
            irTypes.add(IRTypeResolver.getDescriptor(parameterClass));
        }
        return irTypes;
    }

    public static List<IRType> getDescriptors(List<IType> types) {
        ArrayList<IRType> irTypes = new ArrayList<IRType>(types.size());
        for (IType type : types) {
            irTypes.add(IRTypeResolver.getDescriptor(type));
        }
        return irTypes;
    }
}

