/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.internal.gosu.dynamic.DynamicConstructorInfo;
import gw.internal.gosu.dynamic.DynamicMethodInfo;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.ir.transform.util.NameResolver;
import gw.internal.gosu.parser.AbstractGenericMethodInfo;
import gw.internal.gosu.parser.AmbiguousSymbol;
import gw.internal.gosu.parser.AnnotationConstructorGenerator;
import gw.internal.gosu.parser.ArrayExpansionMethodInfo;
import gw.internal.gosu.parser.ArrayExpansionPropertyInfo;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.CapturedSymbol;
import gw.internal.gosu.parser.CompilationState;
import gw.internal.gosu.parser.CompileTimeAnnotationHandler;
import gw.internal.gosu.parser.CompoundType;
import gw.internal.gosu.parser.ContextInferenceManager;
import gw.internal.gosu.parser.ContextType;
import gw.internal.gosu.parser.DefaultParamValueLiteral;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.DynamicPropertySymbol;
import gw.internal.gosu.parser.DynamicSymbol;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.GosuClass;
import gw.internal.gosu.parser.GosuClassParser;
import gw.internal.gosu.parser.GosuClassProxyFactory;
import gw.internal.gosu.parser.GosuConstructorInfo;
import gw.internal.gosu.parser.GosuMethodInfo;
import gw.internal.gosu.parser.GosuProgramParseInfo;
import gw.internal.gosu.parser.GosuProgramParser;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.IGosuTemplateInternal;
import gw.internal.gosu.parser.InitializerSymbol;
import gw.internal.gosu.parser.InnerClassFileSystemSourceFileHandle;
import gw.internal.gosu.parser.JavaTypeInfo;
import gw.internal.gosu.parser.LazyLightweightParserState;
import gw.internal.gosu.parser.LightweightParserState;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.ModifierInfo;
import gw.internal.gosu.parser.NamespaceType;
import gw.internal.gosu.parser.ParenthesizedExpression;
import gw.internal.gosu.parser.ParseTree;
import gw.internal.gosu.parser.ParsedElement;
import gw.internal.gosu.parser.ParserBase;
import gw.internal.gosu.parser.ReducedDynamicFunctionSymbol;
import gw.internal.gosu.parser.SourceCodeTokenizer;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.SuperConstructorFunctionSymbol;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.ThisConstructorFunctionSymbol;
import gw.internal.gosu.parser.ThisSymbol;
import gw.internal.gosu.parser.Token;
import gw.internal.gosu.parser.TransparentActivationContext;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeVariableArrayType;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.TypedSymbol;
import gw.internal.gosu.parser.VarPropertyGetFunctionSymbol;
import gw.internal.gosu.parser.VarPropertySetFunctionSymbol;
import gw.internal.gosu.parser.expressions.AdditiveExpression;
import gw.internal.gosu.parser.expressions.AnnotationExpression;
import gw.internal.gosu.parser.expressions.ArgumentListClause;
import gw.internal.gosu.parser.expressions.ArithmeticExpression;
import gw.internal.gosu.parser.expressions.ArrayAccess;
import gw.internal.gosu.parser.expressions.BadInitializerExpression;
import gw.internal.gosu.parser.expressions.BeanMethodCallExpression;
import gw.internal.gosu.parser.expressions.BinaryExpression;
import gw.internal.gosu.parser.expressions.BitshiftExpression;
import gw.internal.gosu.parser.expressions.BitwiseAndExpression;
import gw.internal.gosu.parser.expressions.BitwiseOrExpression;
import gw.internal.gosu.parser.expressions.BitwiseXorExpression;
import gw.internal.gosu.parser.expressions.BlockExpression;
import gw.internal.gosu.parser.expressions.BlockInvocation;
import gw.internal.gosu.parser.expressions.BlockLiteral;
import gw.internal.gosu.parser.expressions.BooleanLiteral;
import gw.internal.gosu.parser.expressions.CharLiteral;
import gw.internal.gosu.parser.expressions.CollectionInitializerExpression;
import gw.internal.gosu.parser.expressions.CompoundTypeLiteral;
import gw.internal.gosu.parser.expressions.ConditionalAndExpression;
import gw.internal.gosu.parser.expressions.ConditionalExpression;
import gw.internal.gosu.parser.expressions.ConditionalOrExpression;
import gw.internal.gosu.parser.expressions.ConditionalTernaryExpression;
import gw.internal.gosu.parser.expressions.DefaultArgLiteral;
import gw.internal.gosu.parser.expressions.DirectiveExpression;
import gw.internal.gosu.parser.expressions.EqualityExpression;
import gw.internal.gosu.parser.expressions.EvalExpression;
import gw.internal.gosu.parser.expressions.FeatureLiteral;
import gw.internal.gosu.parser.expressions.IHasOperatorLineNumber;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.IdentityExpression;
import gw.internal.gosu.parser.expressions.ImplicitTypeAsExpression;
import gw.internal.gosu.parser.expressions.InferredNewExpression;
import gw.internal.gosu.parser.expressions.InferredTypeLiteral;
import gw.internal.gosu.parser.expressions.InitializerAssignment;
import gw.internal.gosu.parser.expressions.InterfaceTypeLiteral;
import gw.internal.gosu.parser.expressions.IntervalExpression;
import gw.internal.gosu.parser.expressions.Literal;
import gw.internal.gosu.parser.expressions.LocalVarDeclaration;
import gw.internal.gosu.parser.expressions.MapAccess;
import gw.internal.gosu.parser.expressions.MapInitializerExpression;
import gw.internal.gosu.parser.expressions.MemberAccess;
import gw.internal.gosu.parser.expressions.MemberExpansionAccess;
import gw.internal.gosu.parser.expressions.MethodCallExpression;
import gw.internal.gosu.parser.expressions.ModifierListClause;
import gw.internal.gosu.parser.expressions.MultiplicativeExpression;
import gw.internal.gosu.parser.expressions.NameInDeclaration;
import gw.internal.gosu.parser.expressions.NewExpression;
import gw.internal.gosu.parser.expressions.NotAWordExpression;
import gw.internal.gosu.parser.expressions.NullExpression;
import gw.internal.gosu.parser.expressions.NumericLiteral;
import gw.internal.gosu.parser.expressions.ObjectInitializerExpression;
import gw.internal.gosu.parser.expressions.ParameterDeclaration;
import gw.internal.gosu.parser.expressions.ParameterListClause;
import gw.internal.gosu.parser.expressions.Program;
import gw.internal.gosu.parser.expressions.PropertyAccessIdentifier;
import gw.internal.gosu.parser.expressions.PropertyAsMethodCallIdentifier;
import gw.internal.gosu.parser.expressions.RelationalExpression;
import gw.internal.gosu.parser.expressions.StaticTypeOfExpression;
import gw.internal.gosu.parser.expressions.StringLiteral;
import gw.internal.gosu.parser.expressions.SuperAccess;
import gw.internal.gosu.parser.expressions.SynthesizedMemberAccess;
import gw.internal.gosu.parser.expressions.TemplateStringLiteral;
import gw.internal.gosu.parser.expressions.TypeAsExpression;
import gw.internal.gosu.parser.expressions.TypeIsExpression;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.expressions.TypeOfExpression;
import gw.internal.gosu.parser.expressions.TypeParameterListClause;
import gw.internal.gosu.parser.expressions.TypeVariableDefinition;
import gw.internal.gosu.parser.expressions.TypeVariableDefinitionImpl;
import gw.internal.gosu.parser.expressions.TypeVariableExtendsListClause;
import gw.internal.gosu.parser.expressions.TypeVariableListClause;
import gw.internal.gosu.parser.expressions.UnaryExpression;
import gw.internal.gosu.parser.expressions.UnaryNotPlusMinusExpression;
import gw.internal.gosu.parser.expressions.UnqualifiedEnumMemberAccess;
import gw.internal.gosu.parser.statements.ArrayAssignmentStatement;
import gw.internal.gosu.parser.statements.AssertStatement;
import gw.internal.gosu.parser.statements.AssignmentStatement;
import gw.internal.gosu.parser.statements.BeanMethodCallStatement;
import gw.internal.gosu.parser.statements.BlockInvocationStatement;
import gw.internal.gosu.parser.statements.BreakStatement;
import gw.internal.gosu.parser.statements.CaseClause;
import gw.internal.gosu.parser.statements.CatchClause;
import gw.internal.gosu.parser.statements.ClasspathStatement;
import gw.internal.gosu.parser.statements.ContinueStatement;
import gw.internal.gosu.parser.statements.DelegateStatement;
import gw.internal.gosu.parser.statements.DoWhileStatement;
import gw.internal.gosu.parser.statements.EvalStatement;
import gw.internal.gosu.parser.statements.ForEachStatement;
import gw.internal.gosu.parser.statements.FunctionStatement;
import gw.internal.gosu.parser.statements.HideFieldNoOpStatement;
import gw.internal.gosu.parser.statements.IfStatement;
import gw.internal.gosu.parser.statements.LoopStatement;
import gw.internal.gosu.parser.statements.MapAssignmentStatement;
import gw.internal.gosu.parser.statements.MemberAssignmentStatement;
import gw.internal.gosu.parser.statements.MethodCallStatement;
import gw.internal.gosu.parser.statements.NamespaceStatement;
import gw.internal.gosu.parser.statements.NewStatement;
import gw.internal.gosu.parser.statements.NoOpStatement;
import gw.internal.gosu.parser.statements.NotAStatement;
import gw.internal.gosu.parser.statements.PropertyStatement;
import gw.internal.gosu.parser.statements.ReturnStatement;
import gw.internal.gosu.parser.statements.StatementList;
import gw.internal.gosu.parser.statements.SwitchStatement;
import gw.internal.gosu.parser.statements.SyntheticMemberAccessStatement;
import gw.internal.gosu.parser.statements.ThrowStatement;
import gw.internal.gosu.parser.statements.TryCatchFinallyStatement;
import gw.internal.gosu.parser.statements.TypeLoaderStatement;
import gw.internal.gosu.parser.statements.UsesStatement;
import gw.internal.gosu.parser.statements.UsesStatementList;
import gw.internal.gosu.parser.statements.UsingStatement;
import gw.internal.gosu.parser.statements.VarStatement;
import gw.internal.gosu.parser.statements.WhileStatement;
import gw.internal.gosu.parser.types.ConstructorType;
import gw.internal.gosu.template.TemplateGenerator;
import gw.internal.gosu.util.StringUtil;
import gw.lang.IReentrant;
import gw.lang.annotation.UsageTarget;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRType;
import gw.lang.parser.ExternalSymbolMapForMap;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.GosuParserTypes;
import gw.lang.parser.IActivationContext;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.ICoercer;
import gw.lang.parser.ICoercionManager;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IDynamicPropertySymbol;
import gw.lang.parser.IDynamicSymbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFileContext;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.IGosuValidator;
import gw.lang.parser.IHasInnerClass;
import gw.lang.parser.IInjectedSymbol;
import gw.lang.parser.ILanguageLevel;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseResult;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParsedElementWithAtLeastOneDeclaration;
import gw.lang.parser.IParserState;
import gw.lang.parser.IResolvingCoercer;
import gw.lang.parser.IScope;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISource;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.lang.parser.IStackProvider;
import gw.lang.parser.IStatement;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITokenizerInstructor;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.Keyword;
import gw.lang.parser.MemberAccessKind;
import gw.lang.parser.ParserOptions;
import gw.lang.parser.PostCompilationAnalysis;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.SourceCodeReader;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.StandardScope;
import gw.lang.parser.SymbolType;
import gw.lang.parser.ThreadSafeSymbolTable;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.coercers.FunctionToInterfaceCoercer;
import gw.lang.parser.coercers.IdentityCoercer;
import gw.lang.parser.exceptions.DoesNotOverrideFunctionException;
import gw.lang.parser.exceptions.ErrantGosuClassException;
import gw.lang.parser.exceptions.NoCtorFoundException;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.exceptions.ParseWarning;
import gw.lang.parser.exceptions.ParseWarningForDeprecatedMember;
import gw.lang.parser.exceptions.WrongNumberOfArgsException;
import gw.lang.parser.expressions.IArithmeticExpression;
import gw.lang.parser.expressions.IBlockInvocation;
import gw.lang.parser.expressions.IImplicitTypeAsExpression;
import gw.lang.parser.expressions.IInferredNewExpression;
import gw.lang.parser.expressions.IInitializerExpression;
import gw.lang.parser.expressions.ILiteralExpression;
import gw.lang.parser.expressions.IParenthesizedExpression;
import gw.lang.parser.expressions.IProgram;
import gw.lang.parser.expressions.ISynthesizedMemberAccessExpression;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.parser.expressions.ITypeParameterListClause;
import gw.lang.parser.expressions.ITypeVariableDefinition;
import gw.lang.parser.expressions.ITypeVariableDefinitionExpression;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.expressions.Variance;
import gw.lang.parser.resources.Res;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.parser.statements.IClasspathStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.parser.statements.ITypeLoaderStatement;
import gw.lang.parser.statements.IUsesStatement;
import gw.lang.parser.statements.TerminalType;
import gw.lang.parser.template.TemplateParseException;
import gw.lang.reflect.ConstructorInfoBuilder;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.ICanBeAnnotation;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IConstructorType;
import gw.lang.reflect.IDynamicType;
import gw.lang.reflect.IEnumValue;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IHasParameterInfos;
import gw.lang.reflect.IInvocableType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IOptionalParamCapable;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.MethodScore;
import gw.lang.reflect.MethodScorer;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuArrayClass;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuFragment;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.IGosuVarPropertyInfo;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.StringSourceFileHandle;
import gw.lang.reflect.java.GosuTypes;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaPropertyInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.DynamicArray;
import gw.util.GosuExceptionUtil;
import gw.util.GosuObjectUtil;
import gw.util.SpaceEfficientHashMap;
import gw.util.Stack;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GosuParser
extends ParserBase
implements IGosuParser {
    public static final IType PENDING_BOUNDING_TYPE = ErrorType.getInstance("Pending Bounding Type");
    public static ErrorType notfound = ErrorType.getInstance("_notfound_");
    private SourceCodeTokenizer _tokenizer;
    private ISymbolTable _symTable;
    private boolean _bParsed;
    private Stack<ParsedElement> _stack;
    private Stack<DynamicFunctionSymbol> _stackDFS;
    private List<ParseTree> _locations;
    private Program _parsingProgram;
    private ArrayList<FunctionType> _parsingFunctions;
    private ArrayList<VarStatement> _parsingFieldInitializer;
    private Map<String, List<IFunctionSymbol>> _dfsDeclByName;
    private ITypeUsesMap _typeUsesMap;
    private String _strNamespace;
    private ITokenizerInstructor _tokenizerInstructor;
    private IScriptabilityModifier _scriptabilityConstraint;
    private int _iBreakOk;
    private int _iContinueOk;
    int _iReturnOk;
    private Stack<IScriptPartId> _scriptPartIdStack;
    private Map<String, ITypeVariableDefinition> _typeVarsByName;
    private Stack<ContextType> _inferredContextStack = new Stack();
    private boolean _bThrowForWarnings;
    private boolean _bStudioEditorParser;
    private boolean _bWarnOnCaseIssue;
    private Stack<Boolean> _parsingAbstractConstructor;
    private ContextInferenceManager _ctxInferenceMgr = new ContextInferenceManager();
    private Stack<IType> _blockReturnTypeStack = new Stack();
    private Stack<Boolean> _parsingStaticFeature;
    private boolean _bCaptureSymbolsForEval;
    private boolean _parsingAnnotation;
    private boolean _allowWildcards;
    private int _ignoreTypeDeprecation;
    private boolean _bGenRootExprAccess;
    private boolean _bProgramCallFunction;
    private Map<IScriptPartId, Map<String, IType>> _typeCache;
    private int _iStmtDepth;
    private List<ParseTree> _savedLocations;
    private Boolean _bAreUsingStatementsAllowedInStatementLists;
    private static final String[] METHOD_PREFIX_LIST = new String[]{"get", "is"};
    private static final String[] METHOD_PREFIX_LIST_WITH_SETTER = new String[]{"get", "is", "set"};

    GosuParser(ISymbolTable symTable, IScriptabilityModifier scriptabilityConstraint) {
        this(symTable, scriptabilityConstraint, CommonServices.getEntityAccess().getDefaultTypeUses());
    }

    GosuParser(ISymbolTable symTable, IScriptabilityModifier scriptabilityConstraint, ITypeUsesMap tuMap) {
        this.setOwner(this);
        this.setWarnOnCaseIssue(IGosuParser.Settings.WARN_ON_CASE_DEFAULT.get() == Boolean.TRUE);
        this.setEditorParser(IGosuParser.Settings.IDE_EDITOR_PARSER_DEFAULT.get() == Boolean.TRUE);
        this._symTable = symTable;
        this._typeUsesMap = tuMap.copy();
        this._scriptabilityConstraint = scriptabilityConstraint;
        this._dfsDeclByName = new HashMap<String, List<IFunctionSymbol>>();
        this._stack = new Stack();
        this._stackDFS = new Stack();
        this._locations = new ArrayList<ParseTree>();
        this._parsingFunctions = new ArrayList();
        this._parsingFieldInitializer = new ArrayList();
        this._typeVarsByName = new HashMap<String, ITypeVariableDefinition>(2);
        this._parsingStaticFeature = new Stack();
        this._parsingAbstractConstructor = new Stack();
        this._typeCache = new HashMap<IScriptPartId, Map<String, IType>>();
        this._bParsed = false;
        this._iReturnOk = 1;
        this._allowWildcards = false;
    }

    @Override
    public void setValidator(IGosuValidator validator) {
        super.setValidator(validator);
    }

    public IScriptPartId getScriptPart() {
        if (this._scriptPartIdStack == null || this._scriptPartIdStack.isEmpty()) {
            return null;
        }
        return (IScriptPartId)this._scriptPartIdStack.peek();
    }

    public Stack<IScriptPartId> getScriptPartIdStack() {
        return this._scriptPartIdStack;
    }

    public void pushScriptPart(IScriptPartId partId) {
        if (this._scriptPartIdStack == null) {
            this._scriptPartIdStack = new Stack();
        }
        this._scriptPartIdStack.push((Object)partId);
    }

    void popScriptPart(IScriptPartId partId) {
        IScriptPartId top = (IScriptPartId)this._scriptPartIdStack.pop();
        if (top != partId) {
            throw new IllegalStateException("Unbalanced push/pop script id");
        }
    }

    public void setScript(CharSequence source) {
        if (source == null) {
            source = "";
        }
        this.setScript(new SourceCodeReader(source));
    }

    public void setScript(ISource src) {
        if (src == null) {
            this.setScript((CharSequence)null);
            return;
        }
        ISourceCodeTokenizer tokenizer = src.getTokenizer();
        if (tokenizer == null) {
            this.setScript(src.getSource());
            src.setTokenizer((ISourceCodeTokenizer)this._tokenizer);
            this._tokenizer.setInstructor(this._tokenizerInstructor);
            if (this._tokenizerInstructor != null) {
                this._tokenizerInstructor.setTokenizer((ISourceCodeTokenizer)this._tokenizer);
            } else if (this.getGosuClass() instanceof IGosuTemplateInternal && ((IGosuTemplateInternal)this.getGosuClass()).getTokenizerInstructor() != null) {
                this._tokenizerInstructor = ((IGosuTemplateInternal)this.getGosuClass()).getTokenizerInstructor();
                this._tokenizerInstructor.setTokenizer((ISourceCodeTokenizer)this._tokenizer);
                if (this._tokenizer.getInstructor() == null) {
                    this._tokenizer.setInstructor(this._tokenizerInstructor);
                }
            }
        } else {
            this._tokenizer = (SourceCodeTokenizer)tokenizer;
            this._tokenizer.setInstructor(this._tokenizerInstructor);
            if (this._tokenizerInstructor != null) {
                this._tokenizerInstructor.setTokenizer((ISourceCodeTokenizer)this._tokenizer);
            }
            this._tokenizer.reset();
        }
        this.reset();
    }

    public void setScript(SourceCodeReader reader) {
        if (this._tokenizer == null) {
            this._tokenizer = new SourceCodeTokenizer(reader, this._tokenizerInstructor);
            this._tokenizer.wordChars(95, 95);
        } else {
            this._tokenizer.reset(reader);
        }
        this.reset();
    }

    public void resetScript() {
        this._tokenizer.reset();
        this.reset();
    }

    private void reset() {
        this._stack.clear();
        this._stackDFS.clear();
        this._dfsDeclByName.clear();
        this._typeUsesMap.clearNonDefaultTypeUses();
        this._strNamespace = null;
        this._locations.clear();
        this._parsingFunctions.clear();
        this._parsingFieldInitializer.clear();
        this._typeVarsByName.clear();
        this.setParsed(false);
    }

    @Override
    protected String getScript() {
        return this._tokenizer.getSource();
    }

    @Override
    public ISymbolTable getSymbolTable() {
        return this._symTable;
    }

    public void setSymbolTable(ISymbolTable symTable) {
        this._symTable = symTable;
    }

    public ITypeUsesMap getTypeUsesMap() {
        return this._typeUsesMap;
    }

    public void setTypeUsesMap(ITypeUsesMap typeUsesMap) {
        this._typeUsesMap = typeUsesMap == null ? null : typeUsesMap.copyLocalScope();
    }

    public String getNamespace() {
        return this._strNamespace;
    }

    void setNamespace(String strNamespace) {
        this._strNamespace = strNamespace;
        if (this._strNamespace != null) {
            this.getTypeUsesMap().addToTypeUses(strNamespace + ".*");
        }
    }

    public IScriptabilityModifier getVisibilityConstraint() {
        return this._scriptabilityConstraint;
    }

    public ITokenizerInstructor getTokenizerInstructor() {
        return this._tokenizerInstructor;
    }

    public void setTokenizerInstructor(ITokenizerInstructor tokenizerInstructor) {
        this._tokenizerInstructor = tokenizerInstructor;
        if (this._tokenizer != null) {
            this._tokenizer.setInstructor(this._tokenizerInstructor);
        }
    }

    public FunctionType peekParsingFunction() {
        return this._parsingFunctions.get(0);
    }

    FunctionType popParsingFunction() {
        return this._parsingFunctions.remove(0);
    }

    void pushParsingFunction(FunctionType functionType) {
        this._parsingFunctions.add(0, functionType);
    }

    public boolean isParsingFunction() {
        return this._parsingFunctions.size() > 0;
    }

    public VarStatement peekParsingFieldInitializer() {
        return this._parsingFieldInitializer.get(0);
    }

    VarStatement popParsingFieldInitializer() {
        return this._parsingFieldInitializer.remove(0);
    }

    void pushParsingFieldInitializer(VarStatement VarStatement2) {
        this._parsingFieldInitializer.add(0, VarStatement2);
    }

    public boolean isParsingFieldInitializer() {
        return !this.isParsingFunction() && !this.isParsingBlock() && this._parsingFieldInitializer.size() > 0;
    }

    Program peekParsingProgram() {
        return this._parsingProgram;
    }

    boolean isParsingProgram() {
        return this._parsingProgram != null;
    }

    public Statement parseStatements(IScriptPartId partId) throws ParseResultsException {
        Statement stmt = this.parseStatements(partId, true, true);
        this.assignRuntime(stmt, true, null, null, partId);
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement parseStatements(IScriptPartId partId, boolean verify, boolean isolatedScope) throws ParseResultsException {
        this.pushScriptPart(partId);
        try {
            int iOffset = this._tokenizer.getTokenStart();
            int iLineNum = this._tokenizer.getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            this._parseStatements(isolatedScope);
            Statement stmtList = this.peekStatement();
            this.verify((ParsedElement)stmtList, this.match(null, -1), Res.MSG_END_OF_STMT, new String[0]);
            this._bParsed = true;
            if (stmtList instanceof StatementList) {
                this.setLocation(iOffset, iLineNum, iColumn, true);
            }
            if (verify) {
                this.verifyParsedElement(stmtList);
            }
            Statement statement = stmtList;
            return statement;
        }
        finally {
            this.popScriptPart(partId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _parseStatements(boolean isolatedScope) {
        StatementList stmtList = new StatementList((IStackProvider)this._symTable);
        this._tokenizer.nextToken();
        if (this._tokenizer.getInstructor() == null) {
            this.parseProgramClasspathStatements();
            this.parseProgramTypeLoaderStatements();
        }
        if (isolatedScope) {
            this._symTable.pushScope();
        }
        try {
            UsesStatementList usesStmtList = this.parseUsesStatementList(true);
            ArrayList<Statement> statements = new ArrayList<Statement>();
            this.parseStatementsAndDetectUnreachable(statements);
            if (usesStmtList != null) {
                statements.add(0, usesStmtList);
            }
            stmtList.setStatements(statements);
            this.pushStatement(this.isDontOptimizeStatementLists() ? stmtList : stmtList.getSelfOrSingleStatement());
        }
        finally {
            if (isolatedScope) {
                this._symTable.popScope();
            }
        }
    }

    void parseStatementsAndDetectUnreachable(List<Statement> statements) {
        Statement stmt = null;
        while (this.parseStatement()) {
            stmt = this.popStatementAndDetectUnreachable(stmt, statements);
        }
    }

    private Statement popStatementAndDetectUnreachable(Statement previousStatement, List<Statement> statements) {
        Statement currentStatement = this.popStatement();
        if (!(previousStatement instanceof ReturnStatement) || !(currentStatement instanceof NotAStatement)) {
            boolean[] bAbsolute = new boolean[]{false};
            this.verifyOrWarn(currentStatement, previousStatement == null || currentStatement.isNoOp() || previousStatement.getLeastSignificantTerminalStatement(bAbsolute) == null || !bAbsolute[0], !CommonServices.getEntityAccess().isUnreachableCodeDetectionOn(), Res.MSG_UNREACHABLE_STMT, new Object[0]);
        }
        if (this.isParsingFunction() && !this.isParsingBlock()) {
            IType returnType = this.peekParsingFunction().getReturnType();
            if (previousStatement instanceof ReturnStatement && returnType == JavaTypes.pVOID() && (currentStatement instanceof NotAStatement || (currentStatement instanceof BeanMethodCallStatement || currentStatement instanceof MethodCallStatement || currentStatement instanceof MemberAssignmentStatement) && currentStatement.getLineNum() == previousStatement.getLineNum() || currentStatement instanceof NoOpStatement && this.isUnexpectedToken(currentStatement))) {
                if (this.isUnexpectedToken(currentStatement)) {
                    currentStatement.clearParseExceptions();
                }
                this.verify((ParsedElement)currentStatement, false, Res.MSG_RETURN_VAL_FROM_VOID_FUNCTION, new String[0]);
            }
        }
        statements.add(currentStatement);
        return currentStatement.isNoOp() ? previousStatement : currentStatement;
    }

    private boolean isUnexpectedToken(Statement statement) {
        for (IParseIssue issue : statement.getParseExceptions()) {
            if (issue.getMessageKey() != Res.MSG_UNEXPECTED_TOKEN) continue;
            return true;
        }
        return false;
    }

    public IProgram parseProgram(IScriptPartId partId) throws ParseResultsException {
        return this.parseProgram(partId, true, null);
    }

    public IProgram parseProgram(IScriptPartId partId, IType expectedExpressionType) throws ParseResultsException {
        return this.parseProgram(partId, true, expectedExpressionType);
    }

    public IProgram parseProgram(IScriptPartId partId, IType expectedExpressionType, IFileContext ctx, boolean assignRuntime) throws ParseResultsException {
        return this.parseProgram(partId, true, false, expectedExpressionType, ctx, assignRuntime);
    }

    public IProgram parseProgram(IScriptPartId partId, IType expectedExpressionType, IFileContext ctx, boolean assignRuntime, boolean bDoNotThrowParseResultsException) throws ParseResultsException {
        return this.parseProgram(partId, true, false, expectedExpressionType, ctx, assignRuntime, bDoNotThrowParseResultsException);
    }

    public IProgram parseProgram(IScriptPartId partId, boolean isolatedScope, IType expectedExpressionType) throws ParseResultsException {
        return this.parseProgram(partId, true, false, expectedExpressionType, null, true);
    }

    public IProgram parseProgram(IScriptPartId partId, boolean isolatedScope, boolean reallyIsolatedScope, IType expectedExpressionType, IFileContext ctx, boolean assignRuntime) throws ParseResultsException {
        return this.parseProgram(partId, isolatedScope, reallyIsolatedScope, expectedExpressionType, ctx, assignRuntime, false);
    }

    public IProgram parseProgram(IScriptPartId partId, boolean isolatedScope, boolean reallyIsolatedScope, IType expectedExpressionType, IFileContext ctx, boolean assignRuntime, boolean bDoNotThrowParseResultsException) throws ParseResultsException {
        return this.parseProgram(partId, isolatedScope, reallyIsolatedScope, expectedExpressionType, ctx, assignRuntime, bDoNotThrowParseResultsException, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProgram parseProgram(IScriptPartId partId, boolean isolatedScope, boolean reallyIsolatedScope, IType expectedExpressionType, IFileContext ctx, boolean assignRuntime, boolean bDoNotThrowParseResultsException, IType superType) throws ParseResultsException {
        Program program = new Program();
        program.setDeclaredReturnType(expectedExpressionType);
        this._parsingProgram = program;
        this.pushScriptPart(partId);
        try {
            try {
                this._tokenizer.nextToken();
                if (this._tokenizer.getInstructor() == null) {
                    this.parseProgramClasspathStatements();
                }
                if (superType != null) {
                    IGosuClassInternal superTypeGosuClass = IGosuClassInternal.Util.getGosuClassFrom(superType);
                    superTypeGosuClass.putClassMembers(this, this.getSymbolTable(), null, false);
                }
                if (isolatedScope) {
                    if (reallyIsolatedScope) {
                        this._symTable.pushIsolatedScope((IActivationContext)new GosuParserTransparentActivationContext(partId));
                    } else {
                        this._symTable.pushScope();
                    }
                }
                try {
                    ISymbol function = this.parseFunctionOrPropertyDeclaration(program, true, false);
                    while (function != null) {
                        this._symTable.putSymbol(function);
                        function = this.parseFunctionOrPropertyDeclaration(program, true, false);
                    }
                    this._tokenizer.reset();
                    this._locations.clear();
                    Statement mainStatement = this.parseStatements(this.getScriptPart(), false, false);
                    SpaceEfficientHashMap functionMap = new SpaceEfficientHashMap();
                    while (this.peekDynamicFunctionSymbol() != null) {
                        DynamicFunctionSymbol function2 = this.popDynamicFunctionSymbol();
                        functionMap.put(function2.getName(), function2);
                    }
                    mainStatement.addParseIssues(program.getParseIssues());
                    program.setMainStatement(mainStatement);
                    program.setFunctions((Map)functionMap);
                    program.setLocation(mainStatement.getLocation());
                    mainStatement.setParent(program);
                    this.verify((ParsedElement)program, this.match(null, -1), Res.MSG_END_OF_STMT, new String[0]);
                    this._bParsed = true;
                    PostCompilationAnalysis.maybeAnalyze((IParsedElement)program, (IParsedElement[])new IParsedElement[0]);
                    if (!bDoNotThrowParseResultsException) {
                        this.verifyParsedElement(program);
                    }
                    CompileTimeAnnotationHandler.postDefinitionVerification(mainStatement);
                }
                finally {
                    if (isolatedScope) {
                        this._symTable.popScope();
                    }
                }
            }
            finally {
                this._parsingProgram = null;
            }
            if (assignRuntime) {
                this.assignRuntime(program, isolatedScope, ctx, superType, partId);
            }
        }
        finally {
            this.popScriptPart(partId);
        }
        return program;
    }

    public void setGenerateRootExpressionAccessForProgram(boolean bGenRootExprAccess) {
        this._bGenRootExprAccess = bGenRootExprAccess;
    }

    public boolean isGenerateRootExpressionAccessForProgram() {
        return this._bGenRootExprAccess;
    }

    private void assignRuntime(ParsedElement elem, boolean bIsolatedScope, IFileContext context, IType superType, IScriptPartId partId) throws ParseResultsException {
        if (elem.isCompileTimeConstant()) {
            return;
        }
        if (bIsolatedScope) {
            this._symTable.pushScope();
        }
        try {
            GosuProgramParser programParser = new GosuProgramParser();
            ParserOptions options = new ParserOptions().withTypeUsesMap(this.getTypeUsesMap()).withExpectedType(elem.getReturnType()).withTokenizerInstructor(this.getTokenizerInstructor()).withSuperType(superType).withFileContext(context).withCtxInferenceMgr((Object)this._ctxInferenceMgr.copy()).withGenRootExprAccess(this.isGenerateRootExpressionAccessForProgram()).asThrowawayProgram().withScriptPartId(partId);
            IParseResult result = programParser.parseExpressionOrProgram(this.getScript(), this.getSymbolTable(), options);
            IGosuProgramInternal p = (IGosuProgramInternal)result.getProgram();
            if (p == null) {
                throw new IllegalStateException();
            }
            elem.setGosuProgram(p);
            if (partId != null) {
                partId.setRuntimeType((IGosuClass)p);
            }
        }
        catch (Exception t) {
            if (t instanceof ParseResultsException) {
                if (this.isForStringLiteralTemplate()) {
                    return;
                }
                throw (ParseResultsException)((Object)t);
            }
            throw (RuntimeException)t;
        }
        finally {
            if (bIsolatedScope) {
                this._symTable.popScope();
            }
        }
    }

    private boolean isForStringLiteralTemplate() {
        return this.getScriptPart() != null && this.getScriptPart().getId() != null && (this.getScriptPart().getId().equals("GsTemplate") || this.getScriptPart().getId().equals("GsTemplateParsed")) && this.getScriptPart().getContainingType() instanceof IGosuClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IClasspathStatement> parseProgramClasspathStatements() {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getLineOffset();
        ArrayList<IClasspathStatement> returnList = new ArrayList<IClasspathStatement>();
        while (this.match(null, Keyword.KW_classpath)) {
            ClasspathStatement cpStatement = new ClasspathStatement();
            if (this.parseStringLiteralSeparately()) {
                StringLiteral expression = (StringLiteral)this.popExpression();
                String strVal = (String)expression.evaluate();
                cpStatement.setClasspath(strVal);
                if (strVal.contains(";")) {
                    this.verifyOrWarn(cpStatement, false, true, Res.MSG_COMMA_IS_THE_CLASSPATH_SEPARATOR, new Object[0]);
                }
            } else {
                this.verify((ParsedElement)cpStatement, false, Res.MSG_CLASSPATH_STATEMENT_EXPECTS_A_STRING, new String[0]);
            }
            returnList.add(cpStatement);
            this.pushStatement(cpStatement);
            try {
                this.setLocation(iOffset, iLineNum, iColumn);
                if (this.getGosuClass() != null && ((IGosuProgramInternal)this.getGosuClass()).isParsingExecutableProgramStatements()) {
                    this.getLocationsList().remove(cpStatement.getLocation());
                }
            }
            finally {
                this.popStatement();
            }
            iOffset = this.getTokenizer().getTokenStart();
            iLineNum = this.getTokenizer().getLineNumber();
            iColumn = this.getTokenizer().getLineOffset();
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ITypeLoaderStatement> parseProgramTypeLoaderStatements() {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getLineOffset();
        ArrayList<ITypeLoaderStatement> returnList = new ArrayList<ITypeLoaderStatement>();
        while (this.match(null, Keyword.KW_typeloader)) {
            TypeLoaderStatement stmt = new TypeLoaderStatement();
            this.parseTypeLiteral();
            TypeLiteral expression = (TypeLiteral)this.popExpression();
            stmt.setTypeLoader(expression.getType().getType());
            returnList.add(stmt);
            this.pushStatement(stmt);
            try {
                this.setLocation(iOffset, iLineNum, iColumn);
            }
            finally {
                this.popStatement();
            }
            iOffset = this.getTokenizer().getTokenStart();
            iLineNum = this.getTokenizer().getLineNumber();
            iColumn = this.getTokenizer().getLineOffset();
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISymbol[] parseProgramFunctionsOrPropertyDecls(IScriptPartId partId, boolean bParseProperties, boolean bParseVars) throws ParseResultsException {
        ArrayList<Object> listFunctions;
        Program program = new Program();
        this.pushScriptPart(partId);
        this._tokenizer.nextToken();
        this._symTable.pushScope();
        try {
            listFunctions = new ArrayList<Object>();
            ISymbol function = this.parseFunctionOrPropertyDeclaration(program, bParseProperties, bParseVars);
            while (function != null) {
                if (function instanceof IDynamicPropertySymbol) {
                    IDynamicPropertySymbol property1 = (IDynamicPropertySymbol)function;
                    String propertyName = property1.getName();
                    IDynamicPropertySymbol property2 = null;
                    for (ISymbol iSymbol : listFunctions) {
                        if (!(iSymbol instanceof IDynamicPropertySymbol) || propertyName == null || !propertyName.equals(iSymbol.getName())) continue;
                        property2 = (IDynamicPropertySymbol)iSymbol;
                    }
                    if (property2 == null) {
                        listFunctions.add(property1);
                    } else {
                        property2.setGetterDfs(property1.getGetterDfs() != null ? property1.getGetterDfs() : property2.getGetterDfs());
                        property2.setSetterDfs(property1.getSetterDfs() != null ? property1.getSetterDfs() : property2.getSetterDfs());
                    }
                } else {
                    listFunctions.add(function);
                }
                function = this.parseFunctionOrPropertyDeclaration(program, bParseProperties, bParseVars);
            }
        }
        finally {
            this._symTable.popScope();
            this.popScriptPart(partId);
        }
        return listFunctions.toArray(new ISymbol[listFunctions.size()]);
    }

    public Expression parseExp(IScriptPartId partId) throws ParseResultsException {
        return this.parseExp(partId, true, null, true);
    }

    public Expression parseExp(IScriptPartId partId, IType expectedExpressionType) throws ParseResultsException {
        return this.parseExp(partId, true, expectedExpressionType, true);
    }

    public Expression parseExp(IScriptPartId partId, IType expectedExpressionType, IFileContext context, boolean assignRuntime) throws ParseResultsException {
        return this.parseExp(partId, true, expectedExpressionType, context, assignRuntime);
    }

    private Expression parseExp(IScriptPartId partId, boolean isolatedScope, IType expectedExpressionType, boolean assignRuntime) throws ParseResultsException {
        return this.parseExp(partId, isolatedScope, expectedExpressionType, null, assignRuntime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression parseExp(IScriptPartId partId, boolean isolatedScope, IType expectedExpressionType, IFileContext context, boolean assignRuntime) throws ParseResultsException {
        Expression expression;
        this.pushScriptPart(partId);
        this._tokenizer.nextToken();
        if (isolatedScope) {
            this._symTable.pushScope();
        }
        try {
            this.parseExpression(new ContextType(expectedExpressionType, false));
            expression = this.popExpression();
            this.verify((ParsedElement)expression, this.match(null, -1), Res.MSG_END_OF_EXPRESSION, new String[0]);
            this._bParsed = true;
            this.verifyParsedElement(expression);
        }
        finally {
            if (isolatedScope) {
                this._symTable.popScope();
            }
            this.popScriptPart(partId);
        }
        if (assignRuntime) {
            this.assignRuntime(expression, isolatedScope, context, null, partId);
        }
        CompileTimeAnnotationHandler.postDefinitionVerification(expression);
        return expression;
    }

    public IExpression parseExpOrProgram(IScriptPartId partId) throws ParseResultsException {
        return this.parseExpOrProgram(partId, true, true);
    }

    public IExpression parseExpOrProgram(IScriptPartId partId, boolean isolatedScope, boolean assignRuntime) throws ParseResultsException {
        return this.parseExpOrProgram(partId, null, isolatedScope, assignRuntime);
    }

    public IExpression parseExpOrProgram(IScriptPartId partId, IType typeExpected, boolean isolatedScope, boolean assignRuntime) throws ParseResultsException {
        Expression exp;
        try {
            exp = this.parseExp(partId, isolatedScope, typeExpected, assignRuntime);
        }
        catch (ParseResultsException expressionParseResultException) {
            boolean isProbablyProgram = !this.getTokenizer().isEOF();
            try {
                HashMap<String, List<IFunctionSymbol>> dfsDeclByName = new HashMap<String, List<IFunctionSymbol>>(this._dfsDeclByName);
                this.resetScript();
                this._dfsDeclByName = dfsDeclByName;
                exp = this.parseProgram(partId, isolatedScope, typeExpected);
            }
            catch (ParseResultsException programParseResultsException) {
                if (isProbablyProgram) {
                    throw programParseResultsException;
                }
                HashMap<String, List<IFunctionSymbol>> dfsDeclByName = new HashMap<String, List<IFunctionSymbol>>(this._dfsDeclByName);
                this.resetScript();
                this._dfsDeclByName = dfsDeclByName;
                exp = this.parseExp(partId, isolatedScope, null, assignRuntime);
            }
        }
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeLiteral parseTypeLiteral(IScriptPartId partId) throws ParseResultsException {
        this.pushScriptPart(partId);
        try {
            this._tokenizer.nextToken();
            this._symTable.pushScope();
            try {
                this.parseTypeLiteral();
            }
            finally {
                this._symTable.popScope();
            }
            Expression expression = this.popExpression();
            this.verify((ParsedElement)expression, this.match(null, -1), Res.MSG_END_OF_EXPRESSION, new String[0]);
            this._bParsed = true;
            TypeLiteral typeLiteral = (TypeLiteral)expression;
            return typeLiteral;
        }
        finally {
            this.popScriptPart(partId);
        }
    }

    public boolean isParsed() {
        return this._bParsed;
    }

    protected void setParsed(boolean bParsed) {
        this._bParsed = bParsed;
    }

    @Override
    public final SourceCodeTokenizer getTokenizer() {
        return this._tokenizer;
    }

    @Override
    List<ParseTree> getLocationsList() {
        return this._locations;
    }

    public List<IParseTree> getLocations() {
        return new ArrayList<IParseTree>(this._locations);
    }

    public ParseTree peekLocation() {
        if (this._locations.isEmpty()) {
            return null;
        }
        return this._locations.get(this._locations.size() - 1);
    }

    public boolean hasWarnings() {
        return false;
    }

    public boolean isThrowParseResultsExceptionForWarnings() {
        return this._bThrowForWarnings;
    }

    public void setThrowParseExceptionForWarnings(boolean bThrowParseExceptionForWarnings) {
        this._bThrowForWarnings = bThrowParseExceptionForWarnings;
    }

    void parseExpression() {
        this.parseExpressionNoVerify(ContextType.EMPTY);
    }

    void parseExpression(ContextType contextType) {
        this.parseExpression(contextType, true);
    }

    void parseExpression(ContextType ctxType, boolean bVerify) {
        this.parseExpressionNoVerify(ctxType);
        if (bVerify && ctxType.getType() != null && !ctxType.isMethodScoring()) {
            Expression expr = this.popExpression();
            this.verifyComparable(ctxType.getType(), expr);
            expr = this.possiblyWrapWithImplicitCoercion(expr, ctxType.getType());
            this.pushExpression(expr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseExpressionNoVerify(ContextType ctxType) {
        this.pushInferredContextTypes(ctxType);
        try {
            int iOffset = this._tokenizer.getTokenStart();
            int iLineNum = this._tokenizer.getLineNumber();
            int iColumn = this._tokenizer.getTokenColumn();
            this.parseConditionalExpression();
            if (!ctxType.isMethodScoring()) {
                this.convertNumberLiteralsToContextType(ctxType.getType());
                this.convertNullLiterals(ctxType.getType());
            }
            this.setLocation(iOffset, iLineNum, iColumn);
        }
        finally {
            this.popInferredContextTypes();
        }
    }

    public void setContextInferenceManager(ContextInferenceManager ctxInferenceMgr) {
        this._ctxInferenceMgr = ctxInferenceMgr;
    }

    public void pushInferredContextTypes(ContextType ctxType) {
        if (ctxType == null) {
            ctxType = ContextType.EMPTY;
        }
        if (ctxType.getType() instanceof IBlockType) {
            ((IBlockType)ctxType.getType()).getParameterTypes();
        }
        this._inferredContextStack.push((Object)ctxType);
    }

    public void popInferredContextTypes() {
        this._inferredContextStack.pop();
    }

    public ContextType getContextType() {
        if (this._inferredContextStack.isEmpty()) {
            return ContextType.EMPTY;
        }
        ContextType ctxType = (ContextType)this._inferredContextStack.peek();
        assert (ctxType != null);
        return ctxType;
    }

    private void convertNullLiterals(IType contextType) {
        Expression expression;
        if (!this._stack.isEmpty() && contextType != null && (expression = this.peekExpression()) instanceof NullExpression && !contextType.isPrimitive()) {
            expression.setType(contextType);
        }
    }

    private void convertNumberLiteralsToContextType(IType contextType) {
        Expression subexpr;
        if (this._stack.isEmpty()) {
            return;
        }
        Expression expr = this.peekExpression();
        UnaryExpression unary = null;
        if (expr instanceof UnaryExpression && (subexpr = (unary = (UnaryExpression)expr).getExpression()) instanceof NumericLiteral) {
            expr = subexpr;
        }
        if (expr instanceof NumericLiteral) {
            NumericLiteral literal = (NumericLiteral)expr;
            IType ctxNumberType = this.getNumberTypeFromContextType(contextType);
            if (literal.getType() == ctxNumberType) {
                return;
            }
            if (ctxNumberType != null && !literal.isExplicitlyTyped() && ctxNumberType != null && !literal.isExplicitlyTyped()) {
                block18: {
                    String strValue = literal.getStrValue();
                    try {
                        if (this.isPrefixNumericLiteral(strValue)) {
                            strValue = this.parseIntOrLongOrBigInt(strValue) + "";
                        }
                        if (JavaTypes.pBYTE().equals(ctxNumberType) || JavaTypes.BYTE().equals(ctxNumberType)) {
                            literal.setValue(Byte.parseByte(strValue));
                            break block18;
                        }
                        if (JavaTypes.pSHORT().equals(ctxNumberType) || JavaTypes.SHORT().equals(ctxNumberType)) {
                            literal.setValue(Short.parseShort(strValue));
                            break block18;
                        }
                        if (JavaTypes.pINT().equals(ctxNumberType) || JavaTypes.INTEGER().equals(ctxNumberType)) {
                            literal.setValue(Integer.parseInt(strValue));
                            break block18;
                        }
                        if (JavaTypes.pLONG().equals(ctxNumberType) || JavaTypes.LONG().equals(ctxNumberType)) {
                            literal.setValue(Long.parseLong(strValue));
                            break block18;
                        }
                        if (JavaTypes.pFLOAT().equals(ctxNumberType) || JavaTypes.FLOAT().equals(ctxNumberType)) {
                            literal.setValue(Float.valueOf(Float.parseFloat(strValue)));
                            break block18;
                        }
                        if (JavaTypes.pDOUBLE().equals(ctxNumberType) || JavaTypes.DOUBLE().equals(ctxNumberType)) {
                            literal.setValue(Double.parseDouble(strValue));
                            break block18;
                        }
                        if (JavaTypes.BIG_INTEGER().equals(ctxNumberType)) {
                            literal.setValue(new BigInteger(strValue));
                            break block18;
                        }
                        if (JavaTypes.BIG_DECIMAL().equals(ctxNumberType)) {
                            literal.setValue(new BigDecimal(strValue));
                            break block18;
                        }
                        if (literal.getType().isPrimitive() && (JavaTypes.OBJECT().equals(ctxNumberType) || JavaTypes.NUMBER().equals(ctxNumberType) && ctxNumberType.isAssignableFrom(TypeSystem.getBoxType((IType)literal.getType())))) {
                            ctxNumberType = TypeSystem.getBoxType((IType)literal.getType());
                            break block18;
                        }
                        return;
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                }
                literal.setType(ctxNumberType);
                if (unary != null) {
                    unary.setType(ctxNumberType);
                }
            }
        }
    }

    private IType getNumberTypeFromContextType(IType ctxType) {
        if (ctxType == null) {
            return null;
        }
        IType compType = ctxType.isPrimitive() ? TypeSystem.getBoxType((IType)ctxType) : ctxType;
        return JavaTypes.NUMBER().isAssignableFrom(compType) || JavaTypes.OBJECT().equals(compType) ? ctxType : null;
    }

    void parseConditionalExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this._tokenizer.getTokenColumn();
        this._parseConditionalExpression();
        this.setLocation(iOffset, iLineNum, iColumn);
    }

    void _parseConditionalExpression() {
        this._ctxInferenceMgr.pushCtx();
        this.parseConditionalOrExpression();
        boolean foundCondExpr = false;
        if (this.match(null, "?", -6)) {
            foundCondExpr = true;
            ConditionalTernaryExpression cte = new ConditionalTernaryExpression();
            Expression condition = this.popExpression();
            if (!JavaTypes.pBOOLEAN().equals(condition.getType()) && !JavaTypes.BOOLEAN().equals(condition.getType())) {
                condition.addParseException(Res.MSG_CONDITIONAL_EXPRESSION_EXPECTS_BOOLEAN, new Object[0]);
            }
            condition = this.possiblyWrapWithImplicitCoercion(condition, (IType)JavaTypes.pBOOLEAN());
            this.verifyComparable((IType)JavaTypes.pBOOLEAN(), condition);
            this.parseConditionalExpression();
            Expression first = this.popExpression();
            this.verify((ParsedElement)cte, this.match(null, ":", -6), Res.MSG_EXPECTING_COLON_TERNARY, new String[0]);
            this._ctxInferenceMgr.popCtx(false);
            this.parseConditionalExpression();
            Expression second = this.popExpression();
            this._ctxInferenceMgr.pushCtx();
            IType type = this.findLeastUpperBoundWithCoercions(cte, first, second);
            cte.setType(type);
            cte.setCondition(condition);
            cte.setFirst(this.possiblyWrapWithImplicitCoercion(first, type));
            cte.setSecond(this.possiblyWrapWithImplicitCoercion(second, type));
            this.pushExpression(cte);
        } else if (this.match(null, "?:", -6)) {
            Expression first;
            foundCondExpr = true;
            ConditionalTernaryExpression cte = new ConditionalTernaryExpression();
            this.verify((ParsedElement)first, !(first = this.popExpression()).getType().isPrimitive(), Res.MSG_EXPECTING_REFERENCE_TYPE, new String[0]);
            this._ctxInferenceMgr.popCtx(false);
            this.parseConditionalExpression();
            Expression second = this.popExpression();
            this._ctxInferenceMgr.pushCtx();
            IType type = this.findLeastUpperBoundWithCoercions(cte, first, second);
            cte.setType(type);
            cte.setCondition(null);
            cte.setFirst(this.possiblyWrapWithImplicitCoercion(first, type));
            cte.setSecond(this.possiblyWrapWithImplicitCoercion(second, type));
            this.pushExpression(cte);
        }
        this._ctxInferenceMgr.popCtx(!foundCondExpr);
    }

    private boolean isPrimitiveOrBoxedOrBigIntegerOrBigDecimal(IType type) {
        return type != null && !JavaTypes.pVOID().equals(type) && (type.isPrimitive() || TypeSystem.getPrimitiveType((IType)type) != null || JavaTypes.BIG_INTEGER().equals(type) || JavaTypes.BIG_DECIMAL().equals(type));
    }

    private IType findLeastUpperBoundWithCoercions(ConditionalTernaryExpression cte, Expression first, Expression second) {
        Object type;
        IType firstType = first.getType();
        IType secondType = second.getType();
        if (this.isPrimitiveOrBoxedOrBigIntegerOrBigDecimal(firstType) && this.isPrimitiveOrBoxedOrBigIntegerOrBigDecimal(secondType)) {
            type = TypeLord.getLeastUpperBoundForPrimitiveTypes(firstType, secondType);
            if (!this.verify((ParsedElement)cte, type != null, Res.MSG_LOSS_OF_PRECISION_IN_CONDITIONAL_EXP, new String[0])) {
                type = ErrorType.getInstance();
            }
        } else {
            if (GosuParserTypes.NULL_TYPE().equals(firstType) && GosuParserTypes.NULL_TYPE().equals(secondType)) {
                IType ctxType = this.getContextType().getType();
                return ctxType != null && !ctxType.isPrimitive() ? ctxType : GosuParserTypes.NULL_TYPE();
            }
            if (GosuParserTypes.NULL_TYPE().equals(firstType) && secondType.isPrimitive()) {
                return TypeLord.getBoxedTypeFromPrimitiveType(secondType);
            }
            if (GosuParserTypes.NULL_TYPE().equals(secondType) && firstType.isPrimitive()) {
                return TypeLord.getBoxedTypeFromPrimitiveType(firstType);
            }
            if (this.canCoerceFromString(first, second)) {
                type = secondType;
            } else if (this.canCoerceFromString(second, first)) {
                type = firstType;
            } else {
                if (firstType.isPrimitive() && !GosuParserTypes.NULL_TYPE().equals(firstType) && !secondType.isPrimitive() && !StandardCoercionManager.isBoxed((IType)secondType)) {
                    firstType = TypeLord.getBoxedTypeFromPrimitiveType(firstType);
                } else if (secondType.isPrimitive() && !GosuParserTypes.NULL_TYPE().equals(secondType) && !firstType.isPrimitive() && !StandardCoercionManager.isBoxed((IType)firstType)) {
                    secondType = TypeLord.getBoxedTypeFromPrimitiveType(secondType);
                }
                ArrayList<IType> list = new ArrayList<IType>();
                if (!GosuParserTypes.NULL_TYPE().equals(firstType)) {
                    list.add(firstType);
                }
                if (!GosuParserTypes.NULL_TYPE().equals(secondType)) {
                    list.add(secondType);
                }
                type = TypeLord.findLeastUpperBound(list);
            }
        }
        return type;
    }

    private boolean canCoerceFromString(Expression first, Expression second) {
        return first instanceof ILiteralExpression && !(second instanceof ILiteralExpression) && JavaTypes.STRING().equals(first.getType()) && CommonServices.getCoercionManager().canCoerce(second.getType(), (IType)JavaTypes.STRING());
    }

    private Expression wrapExpressionIfNeeded(Expression first, Expression second) {
        if (first.getType() == JavaTypes.pVOID() && second.getType().isPrimitive()) {
            return this.possiblyWrapWithImplicitCoercion(first, TypeSystem.getBoxType((IType)second.getType()));
        }
        if (second.getType() == JavaTypes.pVOID() && first.getType().isPrimitive()) {
            return this.possiblyWrapWithImplicitCoercion(first, TypeSystem.getBoxType((IType)first.getType()));
        }
        return first;
    }

    void parseConditionalOrExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.parseConditionalAndExpression();
        boolean foundOr = false;
        while (this.match(null, "||", -6) || this.match(null, Keyword.KW_or)) {
            this._ctxInferenceMgr.clear();
            foundOr = true;
            this.parseConditionalAndExpression();
            ConditionalOrExpression e = new ConditionalOrExpression();
            Expression rhs = this.popExpression();
            this.verifyComparable((IType)JavaTypes.pBOOLEAN(), rhs, true, true);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, (IType)JavaTypes.pBOOLEAN());
            Expression lhs = this.popExpression();
            this.verifyComparable((IType)JavaTypes.pBOOLEAN(), lhs, true, true);
            lhs = this.possiblyWrapWithImplicitCoercion(lhs, (IType)JavaTypes.pBOOLEAN());
            e.setLHS(lhs);
            e.setRHS(rhs);
            this.pushExpression(e);
            this.setLocation(iOffset, iLineNum, iColumn);
        }
        if (foundOr) {
            this._ctxInferenceMgr.clear();
        }
    }

    void parseConditionalAndExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.parseBitwiseOrExpression();
        while (this.match(null, "&&", -6) || this.match(null, Keyword.KW_and)) {
            this.parseBitwiseOrExpression();
            ConditionalAndExpression e = new ConditionalAndExpression();
            Expression rhs = this.popExpression();
            this.verifyComparable((IType)JavaTypes.pBOOLEAN(), rhs, true, true);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, (IType)JavaTypes.pBOOLEAN());
            Expression lhs = this.popExpression();
            this.verifyComparable((IType)JavaTypes.pBOOLEAN(), lhs, true, true);
            lhs = this.possiblyWrapWithImplicitCoercion(lhs, (IType)JavaTypes.pBOOLEAN());
            e.setLHS(lhs);
            e.setRHS(rhs);
            this.pushExpression(e);
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    void parseBitwiseOrExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.parseBitwiseXorExpression();
        while (this.match(null, "|", -6)) {
            BitwiseOrExpression e = new BitwiseOrExpression();
            Expression lhs = this.popExpression();
            lhs = this.ensureOperandIntOrLongOrBoolean(lhs);
            this.parseBitwiseXorExpression();
            Expression rhs = this.popExpression();
            rhs = lhs.getType() == JavaTypes.pBOOLEAN() ? this.ensureOperandBoolean(rhs) : this.ensureOperandIntOrLong(rhs);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, lhs.getType());
            e.setLHS(lhs);
            e.setRHS(rhs);
            if (lhs.getType() == JavaTypes.pBOOLEAN()) {
                e.setType(lhs.getType());
            } else {
                e.setType(this.resolveTypeForArithmeticExpression(e, lhs.getType(), "|", rhs.getType()));
            }
            this.pushExpression(e);
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    private Expression ensureOperandIntOrLongOrBoolean(Expression op) {
        IType opType = op.getType();
        if (this.verify((ParsedElement)op, this.isPrimitiveOrBoxedIntegerType(opType) || opType == JavaTypes.BOOLEAN() || opType == JavaTypes.pBOOLEAN(), Res.MSG_BITWISE_OPERAND_MUST_BE_INT_OR_LONG, new String[0])) {
            opType = opType == JavaTypes.LONG() || opType == JavaTypes.pLONG() ? JavaTypes.pLONG() : (opType == JavaTypes.BOOLEAN() || opType == JavaTypes.pBOOLEAN() ? JavaTypes.pBOOLEAN() : JavaTypes.pINT());
            op = this.possiblyWrapWithImplicitCoercion(op, opType);
        }
        return op;
    }

    private boolean isPrimitiveOrBoxedIntegerType(IType type) {
        return type == JavaTypes.LONG() || type == JavaTypes.pLONG() || type == JavaTypes.CHARACTER() || type == JavaTypes.pCHAR() || type == JavaTypes.INTEGER() || type == JavaTypes.pINT() || type == JavaTypes.SHORT() || type == JavaTypes.pSHORT() || type == JavaTypes.BYTE() || type == JavaTypes.pBYTE();
    }

    private Expression ensureOperandBoolean(Expression op) {
        IType opType = op.getType();
        if (this.verify((ParsedElement)op, opType == JavaTypes.BOOLEAN() || opType == JavaTypes.pBOOLEAN(), Res.MSG_CONDITIONAL_EXPRESSION_EXPECTS_BOOLEAN, new String[0])) {
            op = this.possiblyWrapWithImplicitCoercion(op, (IType)JavaTypes.pBOOLEAN());
        }
        return op;
    }

    private Expression ensureOperandIntOrLong(Expression op) {
        IType opType = op.getType();
        if (this.verify((ParsedElement)op, this.isPrimitiveOrBoxedIntegerType(opType), Res.MSG_BITWISE_OPERAND_MUST_BE_INT_OR_LONG, new String[0])) {
            opType = opType == JavaTypes.LONG() || opType == JavaTypes.pLONG() ? JavaTypes.pLONG() : JavaTypes.pINT();
            op = this.possiblyWrapWithImplicitCoercion(op, opType);
        }
        return op;
    }

    void parseBitwiseXorExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.parseBitwiseAndExpression();
        while (this.match(null, "^", -6)) {
            BitwiseXorExpression e = new BitwiseXorExpression();
            Expression lhs = this.popExpression();
            lhs = this.ensureOperandIntOrLongOrBoolean(lhs);
            this.parseBitwiseAndExpression();
            Expression rhs = this.popExpression();
            rhs = lhs.getType() == JavaTypes.pBOOLEAN() ? this.ensureOperandBoolean(rhs) : this.ensureOperandIntOrLong(rhs);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, lhs.getType());
            e.setLHS(lhs);
            e.setRHS(rhs);
            if (lhs.getType() == JavaTypes.pBOOLEAN()) {
                e.setType(lhs.getType());
            } else {
                e.setType(this.resolveTypeForArithmeticExpression(e, lhs.getType(), "^", rhs.getType()));
            }
            this.pushExpression(e);
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    void parseBitwiseAndExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.parseEqualityExpression();
        while (this.match(null, "&", -6)) {
            BitwiseAndExpression e = new BitwiseAndExpression();
            Expression lhs = this.popExpression();
            lhs = this.ensureOperandIntOrLongOrBoolean(lhs);
            this.parseEqualityExpression();
            Expression rhs = this.popExpression();
            rhs = lhs.getType() == JavaTypes.pBOOLEAN() ? this.ensureOperandBoolean(rhs) : this.ensureOperandIntOrLong(rhs);
            this.verifyComparable(lhs.getType(), rhs, true, true);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, lhs.getType());
            e.setLHS(lhs);
            e.setRHS(rhs);
            if (lhs.getType() == JavaTypes.pBOOLEAN()) {
                e.setType(lhs.getType());
            } else {
                e.setType(this.resolveTypeForArithmeticExpression(e, lhs.getType(), "&", rhs.getType()));
            }
            this.pushExpression(e);
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseEqualityExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        boolean matchOldNotEqOp = false;
        this.parseRelationalExpression();
        while (true) {
            Expression rhs;
            Expression lhs;
            ConditionalExpression e;
            boolean bEq;
            Token token = this.getTokenizer().getCurrentToken();
            String value = token.getStringValue();
            if (token.getType() == -6 && value != null && ((bEq = value.equals("===")) || value.equals("!=="))) {
                this.getTokenizer().nextToken();
                e = new IdentityExpression();
                lhs = this.popExpression();
                this.pushInferredContextTypes(new ContextType(lhs.getType()));
                try {
                    this.parseRelationalExpression();
                }
                finally {
                    this.popInferredContextTypes();
                }
                rhs = this.popExpression();
                if (this.verify((ParsedElement)lhs, !lhs.getType().isPrimitive() || JavaTypes.pVOID().isAssignableFrom(lhs.getType()) || JavaTypes.STRING().isAssignableFrom(lhs.getType()), Res.MSG_PRIMITIVES_NOT_ALLOWED_HERE, new String[0]) && this.verify((ParsedElement)rhs, !rhs.getType().isPrimitive() || JavaTypes.pVOID().isAssignableFrom(rhs.getType()) || JavaTypes.STRING().isAssignableFrom(rhs.getType()), Res.MSG_PRIMITIVES_NOT_ALLOWED_HERE, new String[0])) {
                    this.verifyComparable(lhs.getType(), rhs, true, true);
                }
                e.setLHS(lhs);
                e.setRHS(rhs);
                ((IdentityExpression)e).setEquals(bEq);
                this.pushExpression(e);
            } else {
                if (token.getType() != -6 || value == null || !(bEq = value.equals("==")) && !value.equals("!=") && !(matchOldNotEqOp = value.equals("!="))) break;
                this.getTokenizer().nextToken();
                e = new EqualityExpression();
                lhs = this.popExpression();
                this.verify((ParsedElement)e, !matchOldNotEqOp, Res.MSG_OBSOLETE_NOT_EQUAL_OP, new String[0]);
                this.pushInferredContextTypes(new ContextType(lhs.getType()));
                try {
                    this.parseRelationalExpression();
                }
                finally {
                    this.popInferredContextTypes();
                }
                rhs = this.popExpression();
                rhs = this.verifyConditionalTypes(lhs, rhs);
                this.verifyCoercionSymmetry((EqualityExpression)e, lhs, rhs);
                e.setLHS(lhs);
                e.setRHS(rhs);
                ((EqualityExpression)e).setEquals(bEq);
                this.warnOnSuspiciousEqualsOperator((EqualityExpression)e);
                this.pushExpression(e);
            }
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    private void warnOnSuspiciousEqualsOperator(EqualityExpression e) {
        Expression lhs = e.getLHS();
        Expression rhs = e.getRHS();
        if (this.isThisPointer(lhs) && this.isEqualsArgReference(rhs) || this.isEqualsArgReference(lhs) && this.isThisPointer(rhs)) {
            this.warn((ParsedElement)e, false, Res.MSG_WARN_ON_SUSPICIOUS_THIS_COMPARISON, new Object[0]);
        }
    }

    private boolean isThisPointer(Expression expr) {
        return expr != null && expr instanceof Identifier && ((Identifier)expr).getSymbol() != null && Keyword.KW_this.getName().equals(((Identifier)expr).getSymbol().getName());
    }

    private boolean isEqualsArgReference(Expression expr) {
        ISymbol symbol;
        FunctionType functionType;
        return this.isParsingFunction() && expr != null && expr instanceof Identifier && "equals".equals((functionType = this.peekParsingFunction()).getDisplayName()) && functionType.getParameterTypes().length == 1 && functionType.getParameterTypes()[0] == JavaTypes.OBJECT() && (symbol = ((Identifier)expr).getSymbol()) != null && functionType.getParameterNames()[0].equals(symbol.getName());
    }

    private void verifyCoercionSymmetry(EqualityExpression e, Expression lhs, Expression rhs) {
        if (!lhs.hasParseExceptions() && !rhs.hasParseExceptions()) {
            ICoercionManager cocerionManager = CommonServices.getCoercionManager();
            boolean bDontWarn = lhs.getType() != JavaTypes.OBJECT() && rhs.getType() != JavaTypes.OBJECT() || lhs.getType() == JavaTypes.pVOID() || rhs.getType() == JavaTypes.pVOID() || lhs.getType() != null && BeanAccess.isBeanType(lhs.getType()) && rhs.getType() != null && BeanAccess.isBeanType(rhs.getType()) || cocerionManager.resolveCoercerStatically(lhs.getType(), rhs.getType()) == cocerionManager.resolveCoercerStatically(rhs.getType(), lhs.getType());
            this.verifyOrWarn(e, bDontWarn, true, Res.MSG_ASYMMETRICAL_COMPARISON, lhs.getType(), rhs.getType());
        }
    }

    private void verifyRelationalOperandsComparable(BinaryExpression expr) {
        if (!this.verify((ParsedElement)expr, expr.getRHS().getType() != JavaTypes.OBJECT(), Res.MSG_RELATIONAL_OPERATOR_CANNOT_BE_APPLIED_TO_TYPE, expr.getOperator(), Object.class.getName())) {
            return;
        }
        boolean bComparable = false;
        IType lhsType = expr.getLHS().getType();
        IType rhsType = expr.getRHS().getType();
        if (BeanAccess.isNumericType(lhsType)) {
            if ((JavaTypes.IDIMENSION().isAssignableFrom(lhsType) && GosuParser.isFinalDimension(this, lhsType, expr) || JavaTypes.IDIMENSION().isAssignableFrom(rhsType) && GosuParser.isFinalDimension(this, rhsType, expr)) && lhsType != rhsType) {
                this.addError(expr, Res.MSG_DIMENSION_ADDITION_MUST_BE_SAME_TYPE);
                return;
            }
            bComparable = true;
        } else if (lhsType == GosuParserTypes.DATETIME_TYPE()) {
            bComparable = true;
        } else {
            if (BeanAccess.isBeanType(lhsType) && BeanAccess.isBeanType(rhsType) && lhsType.isAssignableFrom(rhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
                bComparable = true;
            }
            if (!bComparable && (JavaTypes.CHAR_SEQUENCE().isAssignableFrom(lhsType) || JavaTypes.CHAR_SEQUENCE().isAssignableFrom(rhsType))) {
                bComparable = true;
            }
            if (!bComparable) {
                bComparable = lhsType.isDynamic() || rhsType.isDynamic();
            }
        }
        this.verify((ParsedElement)expr, bComparable, Res.MSG_RELATIONAL_OPERATOR_CANNOT_BE_APPLIED_TO_TYPE, expr.getOperator(), lhsType);
    }

    private Expression verifyConditionalTypes(Expression lhs, Expression rhs) {
        IType lhsType = lhs.getType();
        IType rhsType = rhs.getType();
        if (lhsType.isPrimitive() && !(lhs instanceof NullExpression) && rhs instanceof NullExpression || rhsType.isPrimitive() && !(rhs instanceof NullExpression) && lhs instanceof NullExpression) {
            rhs.addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), lhsType, Res.MSG_RELATIONAL_OPERATOR_CANNOT_BE_APPLIED_TO_TYPE, new Object[]{"", JavaTypes.pVOID().getName()}));
            return rhs;
        }
        if (this.areMetaTypes(lhsType, rhsType)) {
            this.verify((ParsedElement)rhs, TypeSystem.canCast((IType)lhsType, (IType)rhsType), Res.MSG_TYPE_MISMATCH, lhsType.getName(), rhsType.getName());
            return rhs;
        }
        IType numberType = ParserBase.resolveType(lhsType, 62, rhsType);
        if (numberType instanceof ErrorType || JavaTypes.IDIMENSION().isAssignableFrom(lhsType) || JavaTypes.IDIMENSION().isAssignableFrom(rhsType)) {
            Expression wrappedRhs = this.verifyWithComparableDimension(rhs, lhsType);
            if (wrappedRhs != null) {
                return wrappedRhs;
            }
            this.verifyComparable(lhs.getType(), rhs, true, true);
        } else {
            this.verifyComparable(numberType, rhs, false, true);
            this.verifyComparable(numberType, lhs, false, true);
        }
        return rhs;
    }

    private boolean areMetaTypes(IType lhsType, IType rhsType) {
        return !(!(lhsType instanceof IMetaType) && !(lhsType instanceof ITypeVariableType) || !(rhsType instanceof IMetaType) && !(rhsType instanceof ITypeVariableType));
    }

    private Expression verifyWithComparableDimension(Expression rhs, IType lhsType) {
        if (JavaTypes.IDIMENSION().isAssignableFrom(lhsType) && JavaTypes.COMPARABLE().isAssignableFrom(lhsType)) {
            for (IType iface : lhsType.getInterfaces()) {
                if (!JavaTypes.COMPARABLE().isAssignableFrom(iface.getGenericType())) continue;
                IType type = iface.getTypeParameters()[0];
                this.verifyComparable(type, rhs, true, true);
                if (!rhs.hasParseExceptions()) {
                    rhs = this.possiblyWrapWithImplicitCoercion(rhs, type);
                }
                return rhs;
            }
        }
        return null;
    }

    void parseRelationalExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.parseIntervalExpression();
        while (true) {
            Expression lhs;
            Expression rhs;
            Expression e;
            Token token = this.getTokenizer().getCurrentToken();
            String value = token.getStringValue();
            if (token.getType() == -6 && value != null && (value.equals("<") || value.equals(">") || value.equals("<="))) {
                this.getTokenizer().nextToken();
                if (value.equals(">") && this.match(null, "=", -6, true) && token.getTokenEnd() == this.getTokenizer().getCurrentToken().getTokenStart()) {
                    value = ">=";
                    this.match(null, "=", -6);
                }
                this.parseIntervalExpression();
                e = new RelationalExpression();
                rhs = this.popExpression();
                lhs = this.popExpression();
                rhs = this.verifyConditionalTypes(lhs, rhs);
                ((BinaryExpression)e).setLHS(lhs);
                ((BinaryExpression)e).setRHS(rhs);
                ((RelationalExpression)e).setOperator(value);
                if (!lhs.hasParseExceptions() && !rhs.hasParseExceptions()) {
                    this.verifyRelationalOperandsComparable((BinaryExpression)e);
                }
                this.pushExpression(e);
            } else {
                if (!this.match(null, Keyword.KW_typeis)) break;
                this.parseTypeLiteral();
                e = new TypeIsExpression();
                rhs = this.popExpression();
                lhs = this.popExpression();
                if (this.verify((ParsedElement)rhs, rhs instanceof TypeLiteral, Res.MSG_EXPECTING_TYPELITERAL, new String[0])) {
                    this.verify((ParsedElement)lhs, !lhs.getType().isPrimitive(), Res.MSG_PRIMITIVES_NOT_ALLOWED_HERE, new String[0]);
                    IType rhsType = ((TypeLiteral)rhs).getType().getType();
                    this.verify((ParsedElement)rhs, !rhsType.isPrimitive(), Res.MSG_PRIMITIVES_NOT_ALLOWED_HERE, new String[0]);
                    this.verify((ParsedElement)rhs, TypeLoaderAccess.instance().canCast(lhs.getType(), rhsType), Res.MSG_INCONVERTIBLE_TYPES, lhs.getType().getName(), rhsType.getName());
                    ((TypeIsExpression)e).setRHS((TypeLiteral)rhs);
                    this._ctxInferenceMgr.updateType(ContextInferenceManager.getUnwrappedExpression(lhs), ((TypeIsExpression)e).getRHS().evaluate());
                }
                ((TypeIsExpression)e).setLHS(lhs);
                this.pushExpression(e);
            }
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    void parseIntervalExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this._parseIntervalExpression();
        this.setLocation(iOffset, iLineNum, iColumn);
    }

    void _parseIntervalExpression() {
        boolean bRightOpen;
        this.parseBitshiftExpression();
        Token token = this.getTokenizer().getCurrentToken();
        int mark = this.getTokenizer().mark();
        String value = token.getStringValue();
        boolean bOperator = token.getType() == -6;
        boolean bClosed = bOperator && "..".equals(value);
        boolean bLeftOpen = !bClosed && bOperator && "|..".equals(value);
        boolean bNextTokenIsDotNoWhitespace = false;
        if (bClosed || bLeftOpen) {
            this.getTokenizer().nextToken();
            Token dotToken = this.getTokenizer().getTokenAt(mark + 1);
            bNextTokenIsDotNoWhitespace = dotToken != null && dotToken.getType() == 46;
            if (bNextTokenIsDotNoWhitespace) {
                this.getTokenizer().nextToken();
            }
        }
        boolean bl = bRightOpen = !bClosed && !bLeftOpen && bOperator && "..|".equals(value);
        if (bRightOpen) {
            this.getTokenizer().nextToken();
        } else if (!bClosed && !bLeftOpen && !bRightOpen && bOperator && "|..|".equals(value)) {
            this.getTokenizer().nextToken();
            bRightOpen = true;
            bLeftOpen = true;
        }
        if (bClosed || bLeftOpen || bRightOpen) {
            this.parseBitshiftExpression();
            Expression rhs = this.popExpression();
            Expression lhs = this.popExpression();
            rhs = this.verifyConditionalTypes(lhs, rhs);
            IType type = IntervalExpression.getIntervalType(rhs.getType());
            this.verifyComparable(rhs.getType(), lhs);
            if (!lhs.hasImmediateParseIssue(Res.MSG_IMPLICIT_COERCION_ERROR) && !lhs.hasImmediateParseIssue(Res.MSG_TYPE_MISMATCH)) {
                lhs = this.possiblyWrapWithImplicitCoercion(lhs, rhs.getType());
            } else {
                lhs.removeParseException(Res.MSG_IMPLICIT_COERCION_ERROR);
                lhs.removeParseException(Res.MSG_TYPE_MISMATCH);
                type = IntervalExpression.getIntervalType(lhs.getType());
                this.verifyComparable(lhs.getType(), rhs);
                rhs = this.possiblyWrapWithImplicitCoercion(rhs, lhs.getType());
            }
            IntervalExpression e = new IntervalExpression(bClosed || !bLeftOpen, bClosed || !bRightOpen, lhs, rhs);
            this.verify((ParsedElement)e, !bNextTokenIsDotNoWhitespace, Res.MSG_EXTRA_DOT_FOUND_IN_INTERVAL, new String[0]);
            e.setType(type);
            if (!lhs.hasParseExceptions() && !rhs.hasParseExceptions()) {
                this.verifyRelationalOperandsComparable(e);
            }
            this.pushExpression(e);
        }
    }

    void parseBitshiftExpression() {
        boolean bLeftShift;
        Token token = this._tokenizer.getCurrentToken();
        int iOffset = token.getTokenStart();
        int iLineNum = token.getLine();
        int iColumn = token.getTokenColumn();
        this.parseAdditiveExpression();
        while ((bLeftShift = -6 == (token = this._tokenizer.getCurrentToken()).getType() && "<<".equals(token.getStringValue())) || this.matchRightShift()) {
            Token T = new Token();
            if (bLeftShift) {
                this.match(T, "<<", -6);
            }
            if (T._strValue == null || !T._strValue.equals("<<")) {
                T._strValue = ">>";
                Token gr = new Token();
                int lastEnd = this.getTokenizer().getPriorToken().getTokenEnd();
                if (this.match(gr, ">", -6, true) && lastEnd == gr.getTokenStart()) {
                    T._strValue = ">>>";
                    this.match(null, ">", -6);
                }
            }
            this.parseAdditiveExpression();
            BitshiftExpression e = new BitshiftExpression();
            Expression rhs = this.popExpression();
            Expression lhs = this.popExpression();
            lhs = this.ensureOperandIntOrLong(lhs);
            rhs = this.ensureOperandIntOrLong(rhs);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, (IType)JavaTypes.pINT());
            e.setLHS(lhs);
            e.setRHS(rhs);
            e.setOperator(T._strValue);
            e.setType(lhs.getType());
            this.pushExpression(e);
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    private boolean matchRightShift() {
        int mark;
        SourceCodeTokenizer tokenizer = this.getTokenizer();
        Token t = tokenizer.getTokenAt(mark = tokenizer.mark());
        if (t != null && t.getType() == -6 && ">".equals(t.getStringValue()) && (t = tokenizer.getTokenAt(mark + 1)) != null && t.getType() == -6 && ">".equals(t.getStringValue())) {
            tokenizer.nextToken();
            tokenizer.nextToken();
            return true;
        }
        return false;
    }

    void parseAdditiveExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.parseMultiplicativeExpression();
        while (true) {
            boolean bMinus;
            Token token = this.getTokenizer().getCurrentToken();
            String value = token.getStringValue();
            boolean bOperator = token.getType() == -6 && value != null;
            boolean bPlus = bOperator && (value.equals("+") || value.equals("?+") || value.equals("!+"));
            boolean bl = bMinus = !bPlus && bOperator && (value.equals("-") || value.equals("?-") || value.equals("!-"));
            if (!bPlus && !bMinus) break;
            this.getTokenizer().nextToken();
            this.parseMultiplicativeExpression();
            AdditiveExpression e = new AdditiveExpression();
            Expression rhs = this.popExpression();
            Expression lhs = this.popExpression();
            e.setLHS(lhs);
            e.setRHS(rhs);
            e.setOperator(value);
            IType type = this.resolveTypeForArithmeticExpression(e, lhs.getType(), bPlus ? "+" : "-", rhs.getType());
            e.setType(type);
            this.verify((ParsedElement)e, TypeSystem.isNumericType((IType)type) || value.charAt(0) != '!', Res.MSG_ARITHMETIC_OPERATOR_CANNOT_BE_APPLIED_TO_TYPES, value, lhs.getType().getDisplayName(), rhs.getType().getDisplayName());
            this.verify((ParsedElement)e, !e.isNullSafe() || !e.getType().isPrimitive(), Res.MSG_EXPECTING_REFERENCE_TYPE, new String[0]);
            this.pushExpression(e);
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    void parseMultiplicativeExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.parseTypeAsExpression();
        while (true) {
            Token token = this.getTokenizer().getCurrentToken();
            String value = token.getStringValue();
            if (token.getType() != -6 || value == null || !value.equals("*") && !value.equals("/") && !value.equals("%") && !value.equals("?*") && !value.equals("!*") && !value.equals("?/") && !value.equals("?%")) break;
            this.getTokenizer().nextToken();
            this.parseTypeAsExpression();
            MultiplicativeExpression e = new MultiplicativeExpression();
            Expression rhs = this.popExpression();
            Expression lhs = this.popExpression();
            e.setLHS(lhs);
            e.setRHS(rhs);
            e.setOperator(value);
            IType type = this.resolveTypeForArithmeticExpression(e, lhs.getType(), value, rhs.getType());
            e.setType(type);
            this.verify((ParsedElement)e, TypeSystem.isNumericType((IType)type) || value.charAt(0) != '!', Res.MSG_ARITHMETIC_OPERATOR_CANNOT_BE_APPLIED_TO_TYPES, "!*", lhs.getType().getDisplayName(), rhs.getType().getDisplayName());
            this.verify((ParsedElement)e, !e.isNullSafe() || !e.getType().isPrimitive(), Res.MSG_EXPECTING_REFERENCE_TYPE, new String[0]);
            this.pushExpression(e);
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    void parseTypeAsExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this.parseUnaryExpression();
        while (this.match(null, Keyword.KW_typeas) || this.match(null, Keyword.KW_as)) {
            this.parseTypeLiteral();
            TypeAsExpression e = new TypeAsExpression();
            Expression rhs = this.popExpression();
            Expression lhs = this.popExpression();
            if (!(rhs instanceof TypeLiteral)) {
                rhs.addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_EXPECTING_TYPELITERAL, new Object[0]));
            } else {
                IType rhsType = ((TypeLiteral)rhs).getType().getType();
                this.checkComparableAndCastable(lhs, rhs);
                e.setType(rhsType);
                e.setCoercer(CommonServices.getCoercionManager().resolveCoercerStatically(rhsType, lhs.getType()));
                this.warn((ParsedElement)lhs, lhs.getType() instanceof IErrorType || rhs.getType() instanceof IErrorType || !rhsType.isAssignableFrom(lhs.getType()) || rhsType.isDynamic(), Res.MSG_UNNECESSARY_COERCION, lhs.getType().getRelativeName(), rhsType.getRelativeName());
            }
            e.setLHS(lhs);
            this.pushExpression(e);
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    private boolean checkComparableAndCastable(Expression lhs, Expression rhs) {
        IType lhsType;
        boolean hasExceptions;
        IType rhsType = ((TypeLiteral)rhs).getType().getType();
        this.verify((ParsedElement)rhs, rhsType != JavaTypes.pVOID(), Res.MSG_VOID_NOT_ALLOWED, new String[0]);
        this.verifyComparable(TypeLord.replaceTypeVariableTypeParametersWithBoundingTypes(rhsType), lhs, false, false);
        boolean bl = hasExceptions = rhs.hasParseExceptions() || lhs.hasParseExceptions();
        if (hasExceptions && (!(lhs instanceof TypeLiteral) || ((TypeLiteral)lhs).getType().getType() instanceof TypeVariableType || !(rhsType instanceof IGosuClass) || !((IGosuClass)rhsType).isStructure()) && TypeSystem.canCast((IType)(lhsType = lhs.getType()), (IType)rhsType)) {
            lhs.removeParseException(Res.MSG_TYPE_MISMATCH);
            hasExceptions = false;
        }
        return !hasExceptions;
    }

    void parseUnaryExpression() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this._parseUnaryExpression();
        this.setLocation(iOffset, iLineNum, iColumn);
    }

    void _parseUnaryExpression() {
        Token token = this.getTokenizer().getCurrentToken();
        String value = token.getStringValue();
        if (token.getType() == -6 && value != null && (value.equals("+") || value.equals("-") || value.equals("!-"))) {
            this.getTokenizer().nextToken();
            boolean unchecked = "!-".equals(value);
            boolean negation = value.charAt(0) == '-' || unchecked;
            token = this.getTokenizer().getCurrentToken();
            if (negation && this.atNumberLiteralStart()) {
                this.parseNumberLiteral(token, true);
            } else {
                this.parseUnaryExpressionNotPlusMinus();
                UnaryExpression ue = new UnaryExpression();
                Expression e = this.popExpression();
                IType type = e.getType();
                this.verify((ParsedElement)e, ue.isSupportedType(type), Res.MSG_NUMERIC_TYPE_EXPECTED, new String[0]);
                ue.setNegated(negation);
                ue.setUnchecked(unchecked);
                if (negation) {
                    if (type == JavaTypes.pCHAR() || type == JavaTypes.pBYTE() || type == JavaTypes.pSHORT()) {
                        e = this.possiblyWrapWithCoercion(e, (IType)JavaTypes.pINT(), true);
                    } else if (type == JavaTypes.CHARACTER() || type == JavaTypes.BYTE() || type == JavaTypes.SHORT()) {
                        e = this.possiblyWrapWithCoercion(e, (IType)JavaTypes.INTEGER(), true);
                    }
                }
                ue.setExpression(e);
                ue.setType(e.getType());
                this.pushExpression(ue);
            }
        } else {
            this.parseUnaryExpressionNotPlusMinus();
        }
    }

    void parseUnaryExpressionNotPlusMinus() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this._parseUnaryExpressionNotPlusMinus();
        this.setLocation(iOffset, iLineNum, iColumn);
        this.checkMemberAccessIsReadable();
    }

    private void checkMemberAccessIsReadable() {
        DynamicPropertySymbol dps;
        Expression expr = this.peekExpression();
        if (expr instanceof MemberAccess) {
            IPropertyInfo pi = ((MemberAccess)expr).getPropertyInfoWithoutThrowing();
            if (pi != null) {
                this.verify((ParsedElement)expr, pi.isReadable(), Res.MSG_CLASS_PROPERTY_NOT_READABLE, pi.getName(), pi.getOwnersType().getName());
            }
        } else if (expr instanceof Identifier && ((Identifier)expr).getSymbol() instanceof DynamicPropertySymbol && (dps = (DynamicPropertySymbol)((Identifier)expr).getSymbol()) != null && !dps.isReadable()) {
            this.verify((ParsedElement)expr, dps.isReadable(), Res.MSG_CLASS_PROPERTY_NOT_READABLE, dps.getName(), dps.getScriptPart() == null ? "" : dps.getScriptPart().getContainingType().getName());
        }
    }

    void _parseUnaryExpressionNotPlusMinus() {
        if (this.match(null, "!", -6) || this.match(null, Keyword.KW_not)) {
            this._ctxInferenceMgr.pushCtx();
            try {
                this.parseUnaryExpression();
            }
            finally {
                this._ctxInferenceMgr.popCtx(false);
            }
            UnaryNotPlusMinusExpression ue = new UnaryNotPlusMinusExpression();
            Expression e = this.popExpression();
            IType type = e.getType();
            this.verify((ParsedElement)e, type == JavaTypes.pBOOLEAN() || type == JavaTypes.BOOLEAN() || type.isDynamic(), Res.MSG_TYPE_MISMATCH, "boolean", type.getDisplayName());
            e = this.possiblyWrapWithImplicitCoercion(e, (IType)JavaTypes.pBOOLEAN());
            ue.setExpression(e);
            ue.setNot(true);
            ue.setType((IType)JavaTypes.pBOOLEAN());
            this.pushExpression(ue);
        } else if (this.match(null, "~", -6)) {
            this.pushInferredContextTypes(ContextType.EMPTY);
            this.parseUnaryExpression();
            this.popInferredContextTypes();
            UnaryNotPlusMinusExpression ue = new UnaryNotPlusMinusExpression();
            Expression e = this.popExpression();
            IType type = e.getType();
            if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                e = this.possiblyWrapWithImplicitCoercion(e, (IType)JavaTypes.pLONG());
            } else if (this.verify((ParsedElement)e, !type.isDynamic(), Res.MSG_DYNAMIC_TYPE_NOT_ALLOWED_HERE, new String[0])) {
                e = this.ensureOperandIntOrLong(e);
            }
            ue.setExpression(e);
            ue.setBitNot(true);
            ue.setType(e.getType());
            this.pushExpression(ue);
        } else if (this.match(null, Keyword.KW_typeof)) {
            this.parseUnaryExpression();
            TypeOfExpression toe = new TypeOfExpression();
            Expression e = this.popExpression();
            toe.setExpression(e);
            this.pushExpression(toe);
        } else if (this.match(null, Keyword.KW_statictypeof)) {
            this.parseUnaryExpression();
            StaticTypeOfExpression toe = new StaticTypeOfExpression();
            Expression e = this.popExpression();
            toe.setExpression(e);
            this.pushExpression(toe);
        } else if (this.match(null, "\\", -6)) {
            this.parseBlockExpression();
        } else if (this.match(null, Keyword.KW_eval)) {
            this.parseEvalExpression();
        } else {
            this.parsePrimaryExpression();
        }
    }

    private void parseEvalExpression() {
        EvalExpression evalExpr = new EvalExpression(this.getTypeUsesMap().copy());
        ArrayList<ICapturedSymbol> captured = new ArrayList<ICapturedSymbol>();
        this.captureAllSymbols(null, this.getCurrentEnclosingGosuClass(), captured);
        evalExpr.setCapturedSymbolsForBytecode(captured);
        evalExpr.setCapturedTypeVars(new HashMap<String, ITypeVariableDefinition>(this.getTypeVariables()));
        this.verify((ParsedElement)evalExpr, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_EVAL, new String[0]);
        this.parseExpression();
        this.verify((ParsedElement)evalExpr, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_EVAL, new String[0]);
        Expression e = this.popExpression();
        evalExpr.setExpression(e);
        this.pushExpression(evalExpr);
    }

    public boolean isCaptureSymbolsForEval() {
        return this._bCaptureSymbolsForEval;
    }

    public void setCaptureSymbolsForEval(boolean bCaputreSymbolsForEval) {
        this._bCaptureSymbolsForEval = bCaputreSymbolsForEval;
    }

    void parsePrimaryExpression() {
        Token token = this._tokenizer.getCurrentToken();
        int iOffset = token.getTokenStart();
        int iLineNum = token.getLine();
        int iColumn = token.getTokenColumn();
        boolean bForceRedundancy = this._parsePrimaryExpression();
        this.setLocation(iOffset, iLineNum, iColumn, bForceRedundancy);
        Expression eas = this.peekExpression();
        if (this.recoverFromJavaStyleCast(eas)) {
            this.setLocation(iOffset, iLineNum, iColumn, bForceRedundancy);
            Expression implicitTypeAsFromRecovery = this.peekExpression();
            this.getLocationsList().remove(eas.getLocation());
            implicitTypeAsFromRecovery.getLocation().addChild(eas.getLocation());
            eas.setParent(implicitTypeAsFromRecovery);
        }
        this.parseIndirectMemberAccess(iOffset, iLineNum, iColumn);
    }

    boolean _parsePrimaryExpression() {
        boolean bRet = false;
        Token token = this.getTokenizer().getCurrentToken();
        if (Keyword.KW_block == token.getKeyword()) {
            this.getTokenizer().nextToken();
            this._parseBlockLiteral();
        } else if (Keyword.KW_new == token.getKeyword()) {
            this.getTokenizer().nextToken();
            this.parseNewExpression();
        } else if (!this.parseNameOrMethodCall(token)) {
            if (40 == token.getType()) {
                this.getTokenizer().nextToken();
                this.parseExpressionNoVerify(this.isParenthesisTerminalExpression() ? this.getContextType() : ContextType.EMPTY);
                this._ctxInferenceMgr.restoreLastCtx();
                Expression e = this.popExpression();
                ParenthesizedExpression expr = new ParenthesizedExpression(e);
                this.pushExpression(expr);
                this.verify((ParsedElement)e, this.match(null, 41), Res.MSG_EXPECTING_EXPRESSION_CLOSE, new String[0]);
            } else if (this.parseStandAloneDataStructureInitialization(token)) {
                bRet = true;
            } else {
                this.parseLiteral(token);
            }
        }
        return bRet;
    }

    private boolean parseBooleanLiteral(Token token) {
        if (Keyword.KW_true == token.getKeyword()) {
            this.getTokenizer().nextToken();
            BooleanLiteral e = new BooleanLiteral(true);
            this.pushExpression(e);
            return true;
        }
        if (Keyword.KW_false == token.getKeyword()) {
            this.getTokenizer().nextToken();
            BooleanLiteral e = new BooleanLiteral(false);
            this.pushExpression(e);
            return true;
        }
        return false;
    }

    private boolean parseNullLiteral(Token token) {
        if (Keyword.KW_null == token.getKeyword()) {
            this.getTokenizer().nextToken();
            this.pushExpression(new NullExpression());
            return true;
        }
        return false;
    }

    private boolean parseStandAloneDataStructureInitialization(Token token) {
        return this.parseStandAloneDataStructureInitialization(token, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private boolean parseStandAloneDataStructureInitialization(Token token, boolean bAvoidContextType, boolean bBacktracking) {
        boolean bPlaceholder;
        int mark = this.getTokenizer().mark();
        int iLocationsCount = this._locations.size();
        Token startToken = token;
        if (123 != token.getType()) {
            return false;
        }
        this.getTokenizer().nextToken();
        token = this.getTokenizer().getCurrentToken();
        bAvoidContextType = bAvoidContextType || this.shouldThisExpressionAvoidTheContextType();
        IType ctxType = bAvoidContextType ? null : this.getInitializableType().getType();
        InferredNewExpression e = new InferredNewExpression();
        boolean bl = bPlaceholder = ctxType != null && ctxType.isDynamic();
        if (ctxType == null || bPlaceholder) {
            IType type;
            CollectionInitializerExpression initializer;
            if (125 == token.getType()) {
                initializer = new CollectionInitializerExpression();
                type = JavaTypes.ARRAY_LIST().getParameterizedType(new IType[]{bPlaceholder ? ctxType : JavaTypes.OBJECT()});
            } else {
                Expression initialExpression;
                this.parseExpression(bPlaceholder ? new ContextType(ctxType, false) : ContextType.OBJECT_FALSE);
                Expression actualInitExpr = initialExpression = this.popExpression();
                if (actualInitExpr instanceof ImplicitTypeAsExpression) {
                    actualInitExpr = ((ImplicitTypeAsExpression)actualInitExpr).getLHS();
                }
                this.verify((ParsedElement)actualInitExpr, actualInitExpr.getType() != JavaTypes.pVOID(), Res.MSG_VOID_NOT_ALLOWED, new String[0]);
                if (this.match(null, 44)) {
                    this._parseInitializerExpression(new ContextType(JavaTypes.ARRAY_LIST().getParameterizedType(new IType[]{bPlaceholder ? ctxType : JavaTypes.OBJECT()}), false));
                    CollectionInitializerExpression collectionInit = (CollectionInitializerExpression)this.popExpression();
                    collectionInit.addFirst(initialExpression);
                    IType iType = bPlaceholder ? ctxType : TypeLord.findLeastUpperBound(this.getTypes(collectionInit.getValues()));
                    type = JavaTypes.ARRAY_LIST().getParameterizedType(new IType[]{iType});
                    initializer = collectionInit;
                } else if (this.match(null, "->", -6)) {
                    void var15_31;
                    this.parseExpression(bPlaceholder ? new ContextType(ctxType, false) : ContextType.OBJECT_FALSE);
                    Expression initialValueExpression = this.popExpression();
                    if (this.match(null, 44)) {
                        this.parseMapInitializerList(new ContextType(JavaTypes.HASH_MAP().getParameterizedType(new IType[]{bPlaceholder ? ctxType : JavaTypes.OBJECT(), bPlaceholder ? ctxType : JavaTypes.OBJECT()}), false));
                        MapInitializerExpression mapInitializerExpression = (MapInitializerExpression)this.popExpression();
                    } else {
                        MapInitializerExpression mapInitializerExpression = new MapInitializerExpression();
                    }
                    var15_31.addFirst(initialExpression, initialValueExpression);
                    IType keysLub = TypeLord.findLeastUpperBound(this.getTypes(var15_31.getKeys()));
                    IType valuesLub = TypeLord.findLeastUpperBound(this.getTypes(var15_31.getValues()));
                    type = JavaTypes.HASH_MAP().getParameterizedType(new IType[]{keysLub, valuesLub});
                    initializer = var15_31;
                } else {
                    CollectionInitializerExpression collectionInit = new CollectionInitializerExpression();
                    collectionInit.addFirst(initialExpression);
                    IType iType = bPlaceholder ? ctxType : TypeLord.findLeastUpperBound(this.getTypes(collectionInit.getValues()));
                    type = JavaTypes.ARRAY_LIST().getParameterizedType(new IType[]{iType});
                    initializer = collectionInit;
                }
            }
            this.verify((ParsedElement)e, this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_INITIALIZER, new String[0]);
            this.pushExpression(initializer);
            this.setLocation(startToken.getTokenStart(), startToken.getLine(), startToken.getTokenColumn(), true);
            this.popExpression();
            e.setType(type);
            e.setConstructor(this.getImplicitConstructor(type));
            ((Expression)initializer).setType(type);
            e.setInitializer((IInitializerExpression)initializer);
        } else {
            e.setType(ctxType);
            if (!this.match(null, 125)) {
                ContextType typeToInit = this.getCurrentInitializableContextType();
                if (ctxType.isArray()) {
                    IType ctxComponentType = ctxType.getComponentType();
                    List<Expression> valueExpressions = this.parseArrayValueList(ctxComponentType);
                    e.setValueExpressions(valueExpressions);
                    if (!typeToInit.isMethodScoring()) {
                        ArrayList<IType> types = new ArrayList<IType>();
                        for (Expression expression : valueExpressions) {
                            types.add(expression.getType());
                        }
                        IType componentLeastUpperBound = TypeLord.findLeastUpperBound(types);
                        if (componentLeastUpperBound != GosuParserTypes.NULL_TYPE()) {
                            if (componentLeastUpperBound instanceof CompoundType) {
                                for (IType comp : componentLeastUpperBound.getCompoundTypeComponents()) {
                                    if (!ctxComponentType.isAssignableFrom(comp)) continue;
                                    componentLeastUpperBound = comp;
                                    if (comp.isInterface()) continue;
                                    if (!ctxComponentType.isInterface() || !(comp instanceof IMetaType)) break;
                                    componentLeastUpperBound = ctxComponentType;
                                    break;
                                }
                            }
                            if (!(componentLeastUpperBound instanceof CompoundType)) {
                                e.setType(componentLeastUpperBound.getArrayType());
                            }
                        }
                    }
                    if (!this.verify((ParsedElement)e, this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_INITIALIZER, new String[0]) && !this.verify((ParsedElement)e, !this.match(null, "->", -6), Res.MSG_UNEXPECTED_ARROW, new String[0])) {
                        e.setType((IType)ErrorType.getInstance());
                    }
                } else {
                    this._parseInitializerExpression(new ContextType(e.getType(), false));
                    IInitializerExpression initializerExpression = (IInitializerExpression)this.popExpression();
                    e.setInitializer(initializerExpression);
                    e.setConstructor(ctxType.getTypeInfo().getConstructor(new IType[0]));
                    if (!typeToInit.isMethodScoring()) {
                        CollectionInitializerExpression collectionInitializerExpression;
                        IType valuesLub;
                        IType initializerCtxType = this.getCurrentInitializableContextType().getType();
                        if ((initializerCtxType.equals(JavaTypes.MAP()) || initializerCtxType.equals(JavaTypes.HASH_MAP())) && initializerExpression instanceof MapInitializerExpression) {
                            MapInitializerExpression mapInitializer = (MapInitializerExpression)initializerExpression;
                            IType keysLub = TypeLord.findLeastUpperBound(this.getTypes(mapInitializer.getKeys()));
                            IType iType = TypeLord.findLeastUpperBound(this.getTypes(mapInitializer.getValues()));
                            if (keysLub != GosuParserTypes.NULL_TYPE() && iType != GosuParserTypes.NULL_TYPE()) {
                                e.setType(e.getType().getGenericType().getParameterizedType(new IType[]{keysLub, iType}));
                            }
                        } else if ((JavaTypes.COLLECTION().equals(initializerCtxType.getGenericType()) || JavaTypes.LIST().equals(initializerCtxType.getGenericType()) || JavaTypes.ARRAY_LIST().equals(initializerCtxType.getGenericType()) || JavaTypes.LINKED_LIST().equals(initializerCtxType.getGenericType()) || JavaTypes.SET().equals(initializerCtxType.getGenericType()) || JavaTypes.HASH_SET().equals(initializerCtxType.getGenericType()) || JavaTypes.ITERABLE().equals(initializerCtxType.getGenericType())) && initializerExpression instanceof CollectionInitializerExpression && (valuesLub = TypeLord.findLeastUpperBound(this.getTypes((collectionInitializerExpression = (CollectionInitializerExpression)initializerExpression).getValues()))) != GosuParserTypes.NULL_TYPE()) {
                            e.setType(e.getType().getGenericType().getParameterizedType(new IType[]{valuesLub}));
                        }
                    }
                    if (!this.verify((ParsedElement)e, this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_INITIALIZER, new String[0]) && !this.verify((ParsedElement)e, !this.match(null, "->", -6), Res.MSG_UNEXPECTED_ARROW, new String[0])) {
                        e.setType((IType)ErrorType.getInstance());
                    }
                    this.pushExpression((Expression)initializerExpression);
                    this.setLocation(startToken.getTokenStart(), startToken.getLine(), startToken.getTokenColumn(), true);
                    this.popExpression();
                    if (!bBacktracking && initializerExpression.hasParseExceptions()) {
                        return this.maybeReparseWithoutContextType(mark, iLocationsCount, (Expression)initializerExpression);
                    }
                }
            } else {
                e.setConstructor(ctxType.getTypeInfo().getConstructor(new IType[0]));
            }
        }
        this.pushExpression(e);
        return true;
    }

    private boolean maybeReparseWithoutContextType(int mark, int iLocationsCount, Expression initializerExpression) {
        this.backtrack(mark, iLocationsCount, initializerExpression);
        Token token = this.getTokenizer().getCurrentToken();
        boolean bRes = this.parseStandAloneDataStructureInitialization(token, true, true);
        if (this.peekExpression().hasParseExceptions()) {
            this.backtrack(mark, iLocationsCount, initializerExpression);
            return this.parseStandAloneDataStructureInitialization(token, false, true);
        }
        return bRes;
    }

    private boolean shouldThisExpressionAvoidTheContextType() {
        int mark = this.getTokenizer().mark();
        this.eatBlock('{', '}', false);
        Token token = this.getTokenizer().getCurrentToken();
        String value = token.getStringValue();
        boolean bAvoidContextType = 46 == token.getType() || 91 == token.getType() || token.getType() == -6 && ("?.".equals(value) || "*.".equals(value) || "==".equals(value) || "!=".equals(value) || "===".equals(value) || "!==".equals(value) || "#".equals(value) || "?".equals(value) || "?[".equals(value));
        this.getTokenizer().restoreToMark(mark);
        return bAvoidContextType;
    }

    private List<IType> getTypes(List<? extends IExpression> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<IType> returnList = new ArrayList<IType>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            IExpression expression = list.get(i);
            if (expression instanceof NullExpression && (i != list.size() - 1 || !returnList.isEmpty())) continue;
            returnList.add(expression.getType());
        }
        return returnList;
    }

    private ContextType getInitializableType() {
        ContextType typeToInit = this.getCurrentInitializableContextType();
        if (typeToInit.getType() == null) {
            return typeToInit;
        }
        if (typeToInit.getType().isInterface()) {
            typeToInit = new ContextType(GosuParser.findImpl(typeToInit.getType()), typeToInit.isMethodScoring());
        }
        if (typeToInit.getType() != null && (typeToInit.getType().isArray() || typeToInit.getType().getTypeInfo().getConstructor(new IType[0]) != null)) {
            return typeToInit;
        }
        return ContextType.EMPTY;
    }

    private ContextType getCurrentInitializableContextType() {
        ContextType ctxType = this.getContextType();
        return this.supportsInitializer(ctxType.getType()) ? ctxType : ContextType.EMPTY;
    }

    public static IType findImpl(IType typeToInit) {
        IType genericType = typeToInit.isParameterizedType() ? typeToInit.getGenericType() : typeToInit;
        if (genericType.equals(JavaTypes.LIST()) || genericType.equals(JavaTypes.COLLECTION()) || genericType.equals(JavaTypes.ITERABLE())) {
            IJavaType arrayListType = JavaTypes.ARRAY_LIST();
            if (typeToInit.isParameterizedType()) {
                arrayListType = (IJavaType)arrayListType.getParameterizedType(typeToInit.getTypeParameters());
            }
            return arrayListType;
        }
        if (genericType.equals(JavaTypes.SET())) {
            IJavaType arrayListType = JavaTypes.HASH_SET();
            if (typeToInit.isParameterizedType()) {
                arrayListType = (IJavaType)arrayListType.getParameterizedType(typeToInit.getTypeParameters());
            }
            return arrayListType;
        }
        if (genericType.equals(JavaTypes.MAP())) {
            IJavaType hashMapType = JavaTypes.HASH_MAP();
            if (typeToInit.isParameterizedType()) {
                hashMapType = (IJavaType)hashMapType.getParameterizedType(typeToInit.getTypeParameters());
            }
            return hashMapType;
        }
        return null;
    }

    private boolean supportsInitializer(IType type) {
        if (type == null) {
            return false;
        }
        return type.isArray() || JavaTypes.MAP().isAssignableFrom(type) || JavaTypes.SET().isAssignableFrom(type) || JavaTypes.LIST().isAssignableFrom(type) || JavaTypes.COLLECTION().equals(type.getGenericType()) || JavaTypes.ITERABLE().equals(type.getGenericType()) || type.isDynamic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBlockExpression() {
        ISymbolTable symTable = this.getSymbolTable();
        boolean pushed = false;
        int originaliBreakOk = this._iBreakOk;
        this._iBreakOk = 0;
        int originaliContinueOk = this._iContinueOk;
        this._iContinueOk = 0;
        ++this._iReturnOk;
        try {
            ContextType contextType = this.getContextType();
            IType expectedBlockReturnType = this.inferReturnTypeForBlockArgument(contextType);
            this._blockReturnTypeStack.push((Object)expectedBlockReturnType);
            pushed = true;
            BlockExpression block = new BlockExpression();
            StandardScope blockScope = new StandardScope();
            symTable.pushScope((IScope)blockScope);
            try {
                boolean foundArrow;
                block.setScope(blockScope);
                if (!this.match(null, "->", -6)) {
                    List<IType> inferredContextTypes = this.getContextTypesForBlockArgument(contextType);
                    IType type = contextType.getType();
                    ArrayList<ISymbol> args = this.parseParameterDeclarationList(block, false, inferredContextTypes, false, false, false, type != null && type.isDynamic());
                    args.forEach(arg_0 -> ((ISymbolTable)this._symTable).putSymbol(arg_0));
                    foundArrow = this.verify((ParsedElement)block, this.match(null, "->", -6), Res.MSG_EXPECTING_ARROW_AFTER_BLOCK_ARGS, new String[0]);
                    block.setArgs(args);
                } else {
                    foundArrow = true;
                    block.setArgs(Collections.emptyList());
                }
                this.verify((ParsedElement)block, block.getArgs().size() <= 16, Res.MSG_BLOCKS_CAN_HAVE_A_MOST_SIXTEEN_ARGS, new String[0]);
                this.pushCurrentBlock(block);
                try {
                    if (foundArrow) {
                        int iOffset = this._tokenizer.getTokenStart();
                        int iLineNum = this._tokenizer.getLineNumber();
                        int iColumn = this.getTokenizer().getTokenColumn();
                        if (this.match(null, 123)) {
                            this._ctxInferenceMgr.pushLoopCompromised();
                            try {
                                this.parseStatementBlock();
                            }
                            finally {
                                this._ctxInferenceMgr.popLoopCompromised();
                            }
                            if (this.peekStatement() instanceof StatementList) {
                                this.setLocation(iOffset, iLineNum, iColumn);
                            }
                            Statement blockBody = this.popStatement();
                            if (expectedBlockReturnType != null && expectedBlockReturnType != GosuParserTypes.NULL_TYPE()) {
                                Statement verifyStmt;
                                boolean[] bAbsolute = new boolean[]{false};
                                ITerminalStatement term = blockBody.getLeastSignificantTerminalStatement(bAbsolute);
                                if (blockBody instanceof StatementList && ((StatementList)blockBody).getStatements() != null && ((StatementList)blockBody).getStatements().length > 0) {
                                    StatementList lst = (StatementList)blockBody;
                                    verifyStmt = lst.getStatements()[lst.getStatements().length - 1];
                                } else {
                                    verifyStmt = blockBody;
                                }
                                this.verify((ParsedElement)verifyStmt, term != null && (bAbsolute[0] || term.getTerminalType() == TerminalType.ForeverLoop), Res.MSG_MISSING_RETURN, new String[0]);
                            }
                            block.setBody(blockBody);
                        } else {
                            int tokenizerPostion = this.getTokenizer().getTokenStart();
                            this.parseExpression(expectedBlockReturnType == null ? ContextType.EMPTY : new ContextType(expectedBlockReturnType, false));
                            Expression exprBody = this.popExpression();
                            exprBody.removeParseException(Res.MSG_VOID_EXPRESSION_NOT_ALLOWED);
                            if (this.matchAssignmentOperator() != null) {
                                this.parseExpression();
                                Expression assignmentBody = this.popExpression();
                                this.verify((ParsedElement)assignmentBody, false, Res.MSG_ASSIGNMENTS_MUST_BE_ENCLOSED_IN_CURLIES_IN_BLOCKS, new String[0]);
                            } else if (tokenizerPostion == this.getTokenizer().getTokenStart()) {
                                int mark = this.getTokenizer().mark();
                                if (this.match(null, Keyword.KW_return)) {
                                    String strToken = this.getTokenizer().getTokenAt(mark).getStringValue();
                                    this.parseExpression();
                                    Expression returnBody = this.popExpression();
                                    this.addError(returnBody, Res.MSG_STATEMENTS_MUST_BE_ENCLOSED_IN_CURLIES_IN_BLOCKS, strToken);
                                } else if (this.match(null, Keyword.KW_var) || this.match(null, Keyword.KW_switch) || this.match(null, Keyword.KW_if)) {
                                    String strToken = this.getTokenizer().getTokenAt(mark).getStringValue();
                                    this.addError(exprBody, Res.MSG_STATEMENTS_MUST_BE_ENCLOSED_IN_CURLIES_IN_BLOCKS, strToken);
                                }
                            }
                            if (JavaTypes.pVOID().equals(expectedBlockReturnType)) {
                                exprBody.removeParseException(Res.MSG_TYPE_MISMATCH);
                            }
                            block.setBody(exprBody);
                        }
                    }
                    block.setBlockReturnType(this.getBlockReturnType(block.getBody(), expectedBlockReturnType));
                    block.setScope(null);
                    block.updateGosuClass();
                    this.pushExpression(block);
                }
                finally {
                    this.popCurrentBlock();
                }
            }
            finally {
                symTable.popScope();
            }
        }
        finally {
            this._iBreakOk = originaliBreakOk;
            this._iContinueOk = originaliContinueOk;
            --this._iReturnOk;
            if (pushed) {
                this._blockReturnTypeStack.pop();
            }
        }
    }

    private IType getBlockReturnType(IParsedElement blockBody, IType ctxType) {
        if (blockBody == null) {
            return ErrorType.getInstance();
        }
        if (blockBody instanceof Expression) {
            return ((Expression)blockBody).getType();
        }
        Statement stmt = (Statement)blockBody;
        ArrayList<IParsedElement> returnStatements = new ArrayList<IParsedElement>();
        ArrayList<IType> returnTypes = new ArrayList<IType>();
        stmt.getContainedParsedElementsByTypesWithIgnoreSet(returnStatements, new HashSet<Class<? extends IParsedElement>>(Arrays.asList(BlockExpression.class)), ReturnStatement.class);
        if (returnStatements.size() == 0) {
            return ctxType;
        }
        for (ReturnStatement returnStatement : returnStatements) {
            returnTypes.add(returnStatement.getValue().getType());
        }
        return TypeLord.findLeastUpperBound(returnTypes);
    }

    private List<IType> getContextTypesForBlockArgument(ContextType ctxType) {
        if (ctxType == null) {
            return null;
        }
        IType type = ctxType.getType();
        if (type == null) {
            return null;
        }
        if (type instanceof FunctionType) {
            if (ctxType.getAlternateType() instanceof FunctionType) {
                type = ctxType.getAlternateType();
            }
            return Arrays.asList(((FunctionType)type).getParameterTypes());
        }
        IFunctionType functionType = FunctionToInterfaceCoercer.getRepresentativeFunctionType((IType)type);
        if (functionType != null) {
            ArrayList<IType> paramTypes = new ArrayList<IType>();
            for (IType parameterType : functionType.getParameterTypes()) {
                paramTypes.add(TypeLord.getDefaultParameterizedType(parameterType));
            }
            return paramTypes;
        }
        return null;
    }

    private IType inferReturnTypeForBlockArgument(ContextType contextType) {
        IFunctionType functionType;
        if (contextType.isMethodScoring()) {
            return null;
        }
        IType ctxType = contextType.getType();
        if (ctxType == null) {
            return null;
        }
        IType returnType = null;
        if (ctxType instanceof FunctionType) {
            if (contextType.getAlternateType() instanceof FunctionType) {
                ctxType = contextType.getAlternateType();
            }
            returnType = ((FunctionType)ctxType).getReturnType();
        }
        if ((functionType = FunctionToInterfaceCoercer.getRepresentativeFunctionType((IType)ctxType)) != null) {
            IType iType = functionType.getReturnType();
            if (returnType == null) {
                returnType = iType;
            } else if (!returnType.equals(iType)) {
                return null;
            }
        }
        returnType = TypeLord.boundTypes(returnType, this.getCurrentlyInferringFunctionTypeVars());
        return returnType;
    }

    void parseNewExpression() {
        this.parseNewExpressionOrAnnotation(false);
    }

    void parseNewExpressionOrAnnotation(boolean bAnnotation) {
        this._parseNewExpressionOrAnnotation(bAnnotation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _parseNewExpressionOrAnnotation(boolean bAnnotation, boolean bBacktracking) {
        boolean original = this.isParsingAnnotation();
        this.setParsingAnnotation(bAnnotation);
        try {
            int mark = this.getTokenizer().mark();
            int iLocationsCount = this._locations.size();
            TypeLiteral typeLiteral = null;
            if (this.match(null, null, 40, true) && this.isParenthesisTerminalExpression(true)) {
                typeLiteral = this.maybeInferTypeLiteralFromContextType();
            }
            if (typeLiteral == null) {
                this.parseTypeLiteralIgnoreArrayBrackets();
                typeLiteral = (TypeLiteral)this.popExpression();
                IType type = typeLiteral.getType().getType();
                if (!bBacktracking) {
                    if (type.isParameterizedType() && TypeLord.deriveParameterizedTypeFromContext(type.getGenericType(), null) == type) {
                        typeLiteral.setType((IType)MetaType.getLiteral(type.getGenericType()));
                    }
                } else if (type == TypeLord.getPureGenericType(type)) {
                    typeLiteral.setType((IType)MetaType.getLiteral(TypeLord.deriveParameterizedTypeFromContext(type, null)));
                }
            }
            this.verify((ParsedElement)typeLiteral, !(typeLiteral instanceof BlockLiteral), Res.MSG_BLOCKS_LITERAL_NOT_ALLOWED_IN_NEW_EXPR, new String[0]);
            IType declaringClass = typeLiteral.getType().getType();
            if (this.isParsingStaticFeature()) {
                IType type = typeLiteral.getType().getType();
                while (type.getEnclosingType() != null && type instanceof IGosuClass && this.verify((ParsedElement)typeLiteral, ((IGosuClass)type).isStatic(), Res.MSG_CANNOT_INSTANTIATE_NON_STATIC_CLASSES_HERE, new String[0])) {
                    type = type.getEnclosingType();
                }
            }
            this.verify((ParsedElement)typeLiteral, !declaringClass.isEnum() || this.getTokenizer().getCurrentToken().getType() == 91, Res.MSG_ENUM_CONSTRUCTOR_NOT_ACCESSIBLE, new String[0]);
            this.parseNewExpressionOrAnnotation(declaringClass, bAnnotation, false, typeLiteral, mark);
            if (!bBacktracking && typeLiteral.getType().getType().isGenericType() && !typeLiteral.getType().getType().isParameterizedType()) {
                this.backtrack(mark, iLocationsCount);
                this._parseNewExpressionOrAnnotation(bAnnotation, true);
            }
        }
        finally {
            this.setParsingAnnotation(original);
        }
    }

    private TypeLiteral maybeInferTypeLiteralFromContextType() {
        InferredTypeLiteral typeLiteral = null;
        IType ctxType = this.getContextType().getType();
        if (ctxType != null && !this.getContextType().isMethodScoring()) {
            typeLiteral = new InferredTypeLiteral(ctxType);
            this.pushExpression(typeLiteral);
            int iOffset = this.getTokenizer().getTokenStart();
            int iLineNum = this.getTokenizer().getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            this.setLocation(iOffset, iLineNum, iColumn, true);
            this.popExpression();
        }
        return typeLiteral;
    }

    void parseNewExpressionOrAnnotation(IType declaringClass, boolean bAnnotation, boolean bNoArgNoParenthesis, final TypeLiteral typeLiteral, int mark) {
        int iParenStart = this._tokenizer.getTokenStart();
        NewExpression e = bAnnotation ? new AnnotationExpression() : new NewExpression();
        e.setType((IType)declaringClass);
        e.setTypeLiteral(typeLiteral);
        this.verifyCanConstructInnerClassFromCallSite(e, (IType)declaringClass);
        if (bNoArgNoParenthesis || this.match(null, 40)) {
            boolean bAssumeClosingParenMatch;
            block39: {
                bAssumeClosingParenMatch = true;
                e.setArgPosition(iParenStart + 1);
                List<Object> listConstructorTypes = !declaringClass.isInterface() || this.isAnnotation((IType)declaringClass) ? this.getPreliminaryConstructorTypes((IType)declaringClass, e) : Collections.emptyList();
                this.scrubAnnotationConstructors((IType)declaringClass, (List<IConstructorType>)listConstructorTypes);
                boolean bNoArgsProvided = false;
                if (!bNoArgNoParenthesis && (!(bNoArgsProvided = this.match(null, null, 41, true)) || listConstructorTypes.size() > 0 && ((IConstructorType)listConstructorTypes.get(0)).hasOptionalParams())) {
                    MethodScore bestConst = this.parseArgumentList2(e, listConstructorTypes, null, !(declaringClass instanceof ErrorType), bNoArgsProvided);
                    IConstructorType constructorType = null;
                    if (bestConst.isValid()) {
                        declaringClass = this.maybeChangeToInferredType((IType)declaringClass, typeLiteral, bestConst);
                        constructorType = (IConstructorType)(bestConst.getInferredFunctionType() == null ? bestConst.getRawFunctionType() : bestConst.getInferredFunctionType());
                        List args = bestConst.getArguments();
                        this.verifyArgCount((ParsedElement)e, args.size(), constructorType);
                        e.setArgs(args.toArray(new Expression[args.size()]));
                        e.setType((IType)declaringClass);
                        e.setConstructor(constructorType.getConstructor());
                        IType[] argTypes = constructorType.getParameterTypes();
                        e.setArgTypes(argTypes);
                        e.setNamedArgOrder(bestConst.getNamedArgOrder());
                    } else {
                        this.verify((ParsedElement)e, false, Res.MSG_NO_CONSTRUCTOR_FOUND_FOR_CLASS, declaringClass.getName());
                        e.setType((IType)ErrorType.getInstance());
                    }
                    bAssumeClosingParenMatch = this.verify((ParsedElement)e, this.match(null, 41), Res.MSG_EXPECTING_FUNCTION_CLOSE, new String[0]);
                    boolean bAnonymous = !this.isInitializableType(e.getType()) && this.match(null, null, 123, true);
                    this.verifyConstructorIsAccessible((IType)declaringClass, e, constructorType, bAnonymous);
                } else {
                    if (bNoArgsProvided) {
                        this.match(null, 41);
                    }
                    try {
                        IConstructorType constructorType = this.getConstructorType((IType)declaringClass, new Expression[0], null, this);
                        e.setType((IType)declaringClass);
                        e.setConstructor(constructorType.getConstructor());
                        boolean bAnonymous = !this.isInitializableType(e.getType()) && this.match(null, null, 123, true);
                        this.verifyConstructorIsAccessible((IType)declaringClass, e, constructorType, bAnonymous);
                    }
                    catch (ParseException pe) {
                        boolean possibleAnonymousClassDecl = declaringClass.isInterface() && !this.isInitializableType((IType)declaringClass);
                        boolean possibleDataStructDecl = this.isConcreteInitializableType((IType)declaringClass);
                        if ((possibleAnonymousClassDecl || possibleDataStructDecl) && this.match(null, null, 123, true)) break block39;
                        e.setType((IType)declaringClass);
                        IConstructorInfo firstCtor = this.getConstructor((IType)declaringClass);
                        e.setConstructor(firstCtor);
                        e.addParseException((IParseIssue)pe);
                    }
                }
            }
            if (this.match(null, null, 123, true)) {
                if (this.isInitializableType(e.getType())) {
                    Token startToken = this.getTokenizer().getCurrentToken();
                    this.match(null, 123);
                    if (!this.match(null, 125)) {
                        this._parseInitializerExpression(new ContextType(e.getType()));
                        IInitializerExpression initializerExpression = (IInitializerExpression)this.peekExpression();
                        e.setInitializer(initializerExpression);
                        this.verify((ParsedElement)e, this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_INITIALIZER, new String[0]);
                        this.setLocation(startToken.getTokenStart(), startToken.getLine(), startToken.getTokenColumn());
                        this.popExpression();
                    }
                } else if (!(declaringClass instanceof ErrorType)) {
                    int state = this._tokenizer.mark();
                    if (!declaringClass.isAbstract() && !declaringClass.isInterface() && this.match(null, 123) && this.match(null, ":", -6)) {
                        this._tokenizer.restoreToMark(state);
                        this.parseObjectInitializer(typeLiteral.evaluate());
                        ObjectInitializerExpression expression = (ObjectInitializerExpression)this.popExpression();
                        e.setInitializer((IInitializerExpression)expression);
                    } else if (bAssumeClosingParenMatch) {
                        declaringClass = this.parseAnonymousInnerClass((IType)declaringClass, typeLiteral, e, state, mark);
                    }
                }
            }
            if (e.getConstructor() != null) {
                IType ownersType = e.getConstructor().getOwnersType();
                boolean bAnnotationType = ownersType instanceof ICanBeAnnotation && ((ICanBeAnnotation)ownersType).isAnnotation() && JavaTypes.ANNOTATION().isAssignableFrom(ownersType);
                this.verify((ParsedElement)e, bAnnotationType || !ownersType.isAbstract(), Res.MSG_CANNOT_CONSTRUCT_ABSTRACT_CLASS, declaringClass.getName());
                this.warn((ParsedElement)e, declaringClass instanceof ITypeVariableType || !TypeLord.isRecursiveType(declaringClass), Res.MSG_CANNOT_CONSTRUCT_RECURSIVE_CLASS, declaringClass.getName());
            }
            this.pushExpression(e);
        } else if (!bAnnotation) {
            if (this.verify((ParsedElement)e, this.match(null, 91), Res.MSG_EXPECTING_NEW_ARRAY_OR_CTOR, new String[0])) {
                if (this.match(null, 93)) {
                    int numArrays = 1;
                    while (this.match(null, 91)) {
                        this.verify((ParsedElement)e, this.match(null, 93), Res.MSG_EXPECTING_ARRAY_BRACKET, new String[0]);
                        ++numArrays;
                    }
                    for (int i = 0; i < numArrays; ++i) {
                        declaringClass = declaringClass.getArrayType();
                    }
                    this.verify((ParsedElement)e, this.match(null, 123), Res.MSG_EXPECTING_OPEN_BRACE_FOR_NEW_ARRAY, new String[0]);
                    e.setType((IType)declaringClass);
                    if (this.match(null, 125)) {
                        e.setValueExpressions(null);
                    } else {
                        List<Expression> valueExpressions = this.parseArrayValueList(declaringClass.getComponentType());
                        this.verify((ParsedElement)e, this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_NEW_ARRAY, new String[0]);
                        e.setValueExpressions(valueExpressions);
                    }
                } else {
                    this.parseExpression(ContextType.pINT_FALSE);
                    e.addSizeExpression(this.popExpression());
                    IType arrayType = null;
                    boolean bSizelessDimension = false;
                    while (this.verify((ParsedElement)e, this.match(null, 93), Res.MSG_EXPECTING_ARRAY_BRACKET, new String[0])) {
                        arrayType = declaringClass = declaringClass.getArrayType();
                        if (!this.match(null, 91)) break;
                        if (!bSizelessDimension && !this.match(null, null, 93, true)) {
                            this.parseExpression(ContextType.pINT_FALSE);
                            e.addSizeExpression(this.popExpression());
                            continue;
                        }
                        bSizelessDimension = true;
                    }
                    declaringClass = arrayType != null ? arrayType : ErrorType.getInstance();
                    e.setType((IType)declaringClass);
                }
            }
            this.pushExpression(e);
        } else {
            if (!(declaringClass instanceof ErrorType)) {
                ITypeInfo typeInfo = declaringClass.getTypeInfo();
                if (typeInfo != null) {
                    IConstructorInfo iConstructorInfo = typeInfo.getConstructor(new IType[0]);
                    if (iConstructorInfo == null) {
                        block5: for (IConstructorInfo constructorInfo : typeInfo.getConstructors()) {
                            IExpression[] defaultVals;
                            if (!(constructorInfo instanceof IOptionalParamCapable)) continue;
                            for (IExpression defaultVal : defaultVals = ((IOptionalParamCapable)constructorInfo).getDefaultValueExpressions()) {
                                if (defaultVal == null) continue block5;
                            }
                            iConstructorInfo = constructorInfo;
                            break;
                        }
                    }
                    if (this.verify((ParsedElement)e, iConstructorInfo != null, Res.MSG_NO_DEFAULT_CTOR_IN, declaringClass.getName())) {
                        e.setType((IType)declaringClass);
                        e.setConstructor(iConstructorInfo);
                        e.setArgTypes(new IType[0]);
                        e.setType((IType)declaringClass);
                    } else {
                        e.setType((IType)ErrorType.getInstance());
                    }
                } else {
                    e.setType((IType)ErrorType.getInstance());
                }
            } else {
                e.setType((IType)ErrorType.getInstance());
            }
            this.pushExpression(e);
        }
        IConstructorInfo constructor = e.getConstructor();
        if (constructor != null && constructor.isDeprecated()) {
            IParserState state = typeLiteral == null ? null : new IParserState(){

                public int getLineNumber() {
                    return typeLiteral.getLocation().getLineNum();
                }

                public int getTokenColumn() {
                    return typeLiteral.getLocation().getColumn();
                }

                public String getSource() {
                    return GosuParser.this.getTokenizer().getSource();
                }

                public int getTokenStart() {
                    return typeLiteral.getLocation().getOffset();
                }

                public int getTokenEnd() {
                    return typeLiteral.getLocation().getExtent();
                }

                public int getLineOffset() {
                    return GosuParser.this.getTokenizer().getLineOffset();
                }

                public IParserState cloneWithNewTokenStartAndTokenEnd(int newTokenStart, int newLength) {
                    return null;
                }
            };
            e.addParseWarning((IParseIssue)new ParseWarningForDeprecatedMember(state, TypeInfoUtil.getConstructorSignature((IConstructorInfo)constructor), constructor.getContainer().getName()));
        }
    }

    private IType maybeChangeToInferredType(IType declaringClass, TypeLiteral typeLiteral, MethodScore bestConst) {
        ConstructorType inferredFunctionType = (ConstructorType)bestConst.getInferredFunctionType();
        if (inferredFunctionType != null && !(declaringClass instanceof ITypeVariableType) && declaringClass != inferredFunctionType.getDeclaringType()) {
            declaringClass = inferredFunctionType.getDeclaringType();
            typeLiteral.setType(declaringClass);
        }
        return declaringClass;
    }

    private void scrubAnnotationConstructors(IType declaringClass, List<IConstructorType> listConstructorTypes) {
        block5: {
            if (declaringClass instanceof IGosuClass) {
                return;
            }
            if (!JavaTypes.ANNOTATION().isAssignableFrom(declaringClass)) break block5;
            if (this.match(null, ":", -6, true)) {
                Iterator<IConstructorType> iter = listConstructorTypes.iterator();
                while (iter.hasNext()) {
                    IConstructorType next = iter.next();
                    IConstructorInfo constructor = next.getConstructor();
                    if (constructor instanceof ConstructorInfoBuilder.IBuilt && ((ConstructorInfoBuilder.IBuilt)constructor).getUserData() == AnnotationConstructorGenerator.STANDARD_CTOR_WITH_DEFAULT_PARAM_VALUES) continue;
                    iter.remove();
                }
            } else {
                Iterator<IConstructorType> iter = listConstructorTypes.iterator();
                while (iter.hasNext()) {
                    IConstructorType next = iter.next();
                    IConstructorInfo constructor = next.getConstructor();
                    if (!(constructor instanceof ConstructorInfoBuilder.IBuilt) || ((ConstructorInfoBuilder.IBuilt)constructor).getUserData() != AnnotationConstructorGenerator.STANDARD_CTOR_WITH_DEFAULT_PARAM_VALUES) continue;
                    iter.remove();
                    break;
                }
            }
        }
    }

    private boolean isAnnotation(IType type) {
        return JavaTypes.ANNOTATION().isAssignableFrom(type) || JavaTypes.IANNOTATION().isAssignableFrom(type);
    }

    private ArrayList<IConstructorType> getPreliminaryConstructorTypes(IType declaringClass, NewExpression e) {
        ArrayList<IConstructorType> listConstructorTypes = new ArrayList<IConstructorType>(2);
        try {
            this.getConstructorType(declaringClass, null, listConstructorTypes, this);
        }
        catch (ParseException pe) {
            IConstructorInfo firstCtor = this.getConstructor(declaringClass);
            e.setConstructor(firstCtor);
            e.addParseException((IParseIssue)pe);
        }
        IType[][] argTypesArray = new IType[listConstructorTypes.size()][];
        IParameterInfo[][] paramTypesPossible = new IParameterInfo[listConstructorTypes.size()][];
        for (int i = 0; i < argTypesArray.length; ++i) {
            IConstructorType ctorType = listConstructorTypes.get(i);
            paramTypesPossible[i] = ctorType.getConstructor().getParameters();
            argTypesArray[i] = ctorType.getParameterTypes();
        }
        return listConstructorTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IType parseAnonymousInnerClass(IType declaringClass, TypeLiteral typeLiteral, NewExpression newExpr, int state, int mark) {
        this._tokenizer.restoreToMark(state);
        newExpr.setAnonymousClass(true);
        IGosuClassInternal gsDeclaringClass = null;
        if (declaringClass instanceof IJavaType) {
            gsDeclaringClass = GosuClassProxyFactory.instance().create(declaringClass);
            if (declaringClass.isParameterizedType()) {
                gsDeclaringClass = (IGosuClassInternal)gsDeclaringClass.getParameterizedType(declaringClass.getTypeParameters());
            }
        } else if (declaringClass instanceof IGosuClassInternal) {
            gsDeclaringClass = (IGosuClassInternal)declaringClass;
        } else {
            this.verify((ParsedElement)newExpr, false, Res.MSG_BAD_ANONYMOUS_CLASS_DECLARATION, new String[0]);
        }
        if (gsDeclaringClass != null && typeLiteral != null) {
            declaringClass = TypeLord.makeDefaultParameterizedType(declaringClass);
            ICompilableTypeInternal enclosingType = this.getCurrentEnclosingGosuClass();
            if (this.verify((ParsedElement)newExpr, enclosingType instanceof IGosuClassInternal, Res.MSG_ANONYMOUS_CLASS_NOT_ALLOWED_HERE, new String[0])) {
                int iNameOffset = typeLiteral.getLocation().getOffset();
                int originaliBreakOk = this._iBreakOk;
                this._iBreakOk = 0;
                int originaliContinueOk = this._iContinueOk;
                this._iContinueOk = 0;
                try {
                    this._parseAnonymousInnerClass(declaringClass, gsDeclaringClass, enclosingType, iNameOffset, newExpr, mark);
                }
                finally {
                    this._iBreakOk = originaliBreakOk;
                    this._iContinueOk = originaliContinueOk;
                }
            }
        }
        return declaringClass;
    }

    private void _parseAnonymousInnerClass(IType declaringClass, IGosuClassInternal gsDeclaringClass, ICompilableTypeInternal enclosingType, int iNameOffset, NewExpression newExpr, int mark) {
        List ctors;
        String strAnonymousClass = "AnonymouS__" + enclosingType.getAnonymousInnerClassCount();
        boolean bTestClass = enclosingType instanceof IGosuClassInternal && ((IGosuClassInternal)enclosingType).isTestClass();
        InnerClassFileSystemSourceFileHandle innerSfh = new InnerClassFileSystemSourceFileHandle(ClassType.Class, enclosingType.getName(), strAnonymousClass, bTestClass);
        innerSfh.setOffset(iNameOffset);
        innerSfh.setMark(mark);
        IGosuClassInternal innerGsClass = (IGosuClassInternal)enclosingType.getTypeLoader().makeNewClass((ISourceFileHandle)innerSfh);
        ((IGosuClassInternal)enclosingType).addInnerClass(innerGsClass);
        if (declaringClass != null) {
            if (declaringClass.isInterface()) {
                innerGsClass.addInterface(TypeLord.makeDefaultParameterizedType(declaringClass));
            } else {
                innerGsClass.setSuperType(TypeLord.makeDefaultParameterizedType(declaringClass));
                if (declaringClass.isEnum()) {
                    innerGsClass.setEnum();
                }
            }
        }
        innerGsClass.setEnclosingType((IType)enclosingType);
        innerGsClass.setNamespace(enclosingType.getNamespace());
        innerGsClass.createNewParseInfo();
        if (this.isParsingStaticFeature()) {
            innerGsClass.markStatic();
        }
        if (declaringClass.isInterface()) {
            innerGsClass.addInterface(declaringClass);
            newExpr.setType((IType)innerGsClass);
        } else {
            innerGsClass.setSuperType(declaringClass);
            if (declaringClass.isEnum()) {
                innerGsClass.setEnum();
            }
            newExpr.setType((IType)innerGsClass);
        }
        if (newExpr.getConstructor() != null) {
            GosuConstructorInfo ci = this.getGsConstructorInfo(newExpr.getConstructor(), gsDeclaringClass);
            this.verify((ParsedElement)newExpr, innerGsClass.getParseInfo().addAnonymousConstructor(this._symTable, ci), Res.MSG_NO_CONSTRUCTOR_FOUND_FOR_CLASS, gsDeclaringClass.getName());
        }
        innerGsClass.setCannotCaptureSymbols(this.isParsingBlock() || ((IGosuClassInternal)innerGsClass.getEnclosingType()).isCannotCaptureSymbols());
        GosuClassParser.parseAnonymousInnerClass(this, innerGsClass);
        if (newExpr.getConstructor() != null && !innerGsClass.getTypeInfo().getConstructors().isEmpty()) {
            IConstructorInfo innerCtor = (IConstructorInfo)innerGsClass.getTypeInfo().getConstructors().get(0);
            newExpr.setConstructor(innerCtor);
        }
        if (!this.getContextType().isMethodScoring()) {
            this.popStatement();
        }
        if (declaringClass.isInterface() && (ctors = innerGsClass.getTypeInfo().getConstructors()).size() > 0) {
            newExpr.setConstructor((IConstructorInfo)ctors.get(0));
        }
    }

    public boolean isParsingStaticFeature() {
        return !this._parsingStaticFeature.isEmpty() && (Boolean)this._parsingStaticFeature.peek() != false;
    }

    public void pushParsingStaticMember(Boolean bParsingStaticFeature) {
        this._parsingStaticFeature.push((Object)bParsingStaticFeature);
    }

    public void popParsingStaticMember() {
        this._parsingStaticFeature.pop();
    }

    public boolean isParsingAbstractConstructor() {
        return !this._parsingAbstractConstructor.isEmpty() && (Boolean)this._parsingAbstractConstructor.peek() != false;
    }

    public void pushParsingAbstractConstructor(Boolean bParsingAbstractConstructor) {
        this._parsingAbstractConstructor.push((Object)bParsingAbstractConstructor);
    }

    public void popParsingAbstractConstructor() {
        this._parsingAbstractConstructor.pop();
    }

    private IConstructorInfo getConstructor(IType instanceClass) {
        IConstructorInfo firstCtor = null;
        if (instanceClass.getTypeInfo() instanceof IRelativeTypeInfo) {
            List ctors;
            if (!instanceClass.isInterface() && !(ctors = ((IRelativeTypeInfo)instanceClass.getTypeInfo()).getConstructors(instanceClass)).isEmpty()) {
                firstCtor = (IConstructorInfo)ctors.get(0);
            }
        } else if (!instanceClass.isInterface()) {
            ITypeInfo typeInfo = instanceClass.getTypeInfo();
            if (typeInfo == null) {
                firstCtor = null;
            } else {
                List ctors = typeInfo.getConstructors();
                if (!ctors.isEmpty()) {
                    firstCtor = (IConstructorInfo)ctors.get(0);
                }
            }
        }
        return firstCtor;
    }

    private void verifyConstructorIsAccessible(IType instanceClass, NewExpression e, IConstructorType constructorType, boolean bAnonymous) {
        if (e.getType() instanceof ErrorType) {
            return;
        }
        if (constructorType != null && !(constructorType.getConstructor() instanceof DynamicConstructorInfo)) {
            ITypeInfo typeInfo = instanceClass.getTypeInfo();
            List accessibleCtors = this.getGosuClass() != null && typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getConstructors((IType)this.getGosuClass()) : typeInfo.getConstructors();
            this.verify((ParsedElement)e, accessibleCtors.contains(constructorType.getConstructor()) || bAnonymous && constructorType.getConstructor().isProtected(), Res.MSG_CTOR_HAS_XXX_ACCESS, this.getModifierString(constructorType));
        }
    }

    private String getModifierString(IConstructorType constructorType) {
        return constructorType.getConstructor().isPrivate() ? "private" : (constructorType.getConstructor().isInternal() ? "internal" : (constructorType.getConstructor().isProtected() ? "protected" : "public"));
    }

    private boolean parseObjectInitializer(IType objectType) {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        boolean b = this._parseObjectInitializer(objectType);
        this.setLocation(iOffset, iLineNum, iColumn);
        return b;
    }

    private boolean _parseObjectInitializer(IType objectType) {
        if (this.match(null, 123)) {
            this._doParseObjectInitializer(objectType);
            this.verify((ParsedElement)this.peekExpression(), this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_INITIALIZER, new String[0]);
            return true;
        }
        return false;
    }

    private void _doParseObjectInitializer(IType objectType) {
        ObjectInitializerExpression oie = new ObjectInitializerExpression();
        do {
            if (this.parseInitializerAssignment(objectType)) {
                InitializerAssignment newAssignment = (InitializerAssignment)this.popStatement();
                for (InitializerAssignment existing : oie.getInitializers()) {
                    if (existing.getPropertyName() == null || !existing.getPropertyName().equals(newAssignment.getPropertyName())) continue;
                    newAssignment.addParseException(Res.MSG_REDUNTANT_INITIALIZERS, existing.getPropertyName());
                }
                oie.add(newAssignment);
                continue;
            }
            this.verify((ParsedElement)oie, false, Res.MSG_EXPECTING_NAME_VALUE_PAIR, this.makeLightweightParserState());
        } while (this.match(null, 44));
        oie.setType(objectType);
        this.pushExpression(oie);
    }

    private boolean parseInitializerAssignment(IType objectType) {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this._tokenizer.getTokenColumn();
        if (this.match(null, ":", -6)) {
            boolean bFoundExtraColon = false;
            if (this.match(null, ":", -6)) {
                bFoundExtraColon = true;
            }
            this.parseInitializerIdentifier(objectType);
            Identifier identifier = (Identifier)this.popExpression();
            InitializerAssignment se = new InitializerAssignment(objectType, identifier.getSymbol().getName());
            IPropertyInfo propertyInfo = null;
            try {
                if (se.getPropertyName() != null) {
                    propertyInfo = BeanAccess.getPropertyInfo(objectType, se.getPropertyName(), null, this, this.getVisibilityConstraint());
                }
            }
            catch (ParseException e) {
                se.addParseException((IParseIssue)e);
            }
            ErrorType type = ErrorType.getInstance();
            if (propertyInfo != null) {
                this.verifyCase(se, se.getPropertyName(), propertyInfo.getName(), Res.MSG_PROPERTY_CASE_MISMATCH, false);
                if (!JavaTypes.COLLECTION().isAssignableFrom(propertyInfo.getFeatureType()) && !JavaTypes.MAP().isAssignableFrom(propertyInfo.getFeatureType())) {
                    try {
                        this.verifyPropertyWritable(objectType, se.getPropertyName(), true);
                    }
                    catch (Exception ex) {
                        se.addParseException((IParseIssue)ParseException.wrap((Throwable)ex, (IParserState)this.makeFullParserState()));
                    }
                }
                type = propertyInfo.getFeatureType();
            }
            identifier.setType((IType)type);
            this.verify((ParsedElement)se, this.match(null, "=", -6), Res.MSG_EQUALS_FOR_INITIALIZER_EXPR, new String[0]);
            this.verify((ParsedElement)se, !bFoundExtraColon, Res.MSG_ONLY_ONE_COLON_IN_INITIALIZERS, new String[0]);
            this.parseExpression(new ContextType((IType)type));
            Expression value = this.popExpression();
            if (value.hasParseExceptions()) {
                value.getParseExceptions().get(0).setExpectedType((IType)type);
            }
            se.setRhs(value);
            this.pushStatement(se);
            this.setLocation(iOffset, iLineNum, iColumn);
            return true;
        }
        return false;
    }

    private void parseInitializerIdentifier(IType objectType) {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this._tokenizer.getTokenColumn();
        Identifier i = new Identifier();
        String strToken = null;
        int mark = this.getTokenizer().mark();
        if (this.verify((ParsedElement)i, this.match(null, -5), Res.MSG_EXPECTING_NAME_PROPERTY, new String[0])) {
            strToken = this.getTokenizer().getTokenAt(mark).getStringValue();
        }
        i.setSymbol((ISymbol)new InitializerSymbol(strToken, objectType), null);
        i.setType(objectType);
        this.pushExpression(i);
        this.setLocation(iOffset, iLineNum, iColumn);
    }

    private GosuConstructorInfo getGsConstructorInfo(IConstructorInfo ci, IGosuClassInternal gsInstanceClass) {
        if (ci instanceof GosuConstructorInfo) {
            return (GosuConstructorInfo)ci;
        }
        ArrayList<IType> argTypes = new ArrayList<IType>(2);
        if (ci != null) {
            for (IParameterInfo pi : ci.getParameters()) {
                argTypes.add(pi.getFeatureType());
            }
        }
        return (GosuConstructorInfo)gsInstanceClass.getTypeInfo().getConstructor((IType)gsInstanceClass, argTypes.toArray(new IType[argTypes.size()]));
    }

    private boolean isConcreteInitializableType(IType type) {
        return this.isInitializableType(type) && !type.isAbstract() && !type.isInterface();
    }

    private boolean isInitializableType(IType type) {
        return type != null && (JavaTypes.COLLECTION().isAssignableFrom(type) || JavaTypes.MAP().isAssignableFrom(type));
    }

    private void verifyCanConstructInnerClassFromCallSite(NewExpression e, IType innerClass) {
        if (!(innerClass instanceof IGosuClassInternal) && !(innerClass instanceof IJavaType)) {
            return;
        }
        if (Modifier.isStatic((int)innerClass.getModifiers())) {
            return;
        }
        IType innersEnclosingClass = innerClass.getEnclosingType();
        if (innersEnclosingClass == null) {
            return;
        }
        IGosuClassInternal constructingFromClass = this.getScriptPart() != null && this.getScriptPart().getContainingType() instanceof IGosuClass ? (IGosuClassInternal)this.getScriptPart().getContainingType() : null;
        this.verify((ParsedElement)e, this.isConstructingNonStaticInnerClassFromNonStaticContext(innersEnclosingClass, constructingFromClass), Res.MSG_CANNOT_INSTANTIATE_NON_STATIC_CLASSES_HERE, innersEnclosingClass.getName(), innerClass.getRelativeName());
        this.verify((ParsedElement)e, constructingFromClass != null && this.isNonStaticInnerClassConstructableFromCurrentFunction(innersEnclosingClass, constructingFromClass), Res.MSG_MUST_BE_IN_OUTER_TO_CONSTRUCT_INNER, innersEnclosingClass.getName(), innerClass.getRelativeName());
    }

    private boolean isConstructingNonStaticInnerClassFromNonStaticContext(IType innersEnclosingClass, IGosuClassInternal constructingFromClass) {
        if (!innersEnclosingClass.isAssignableFrom((IType)constructingFromClass)) {
            for (IGosuClassInternal csr = constructingFromClass; csr != null && csr != innersEnclosingClass; csr = (IGosuClassInternal)csr.getEnclosingType()) {
                if (!csr.isStatic()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isNonStaticInnerClassConstructableFromCurrentFunction(IType innersEnclosingClass, IGosuClassInternal constructingFromClass) {
        if (!innersEnclosingClass.isAssignableFrom((IType)constructingFromClass)) {
            IGosuClassInternal csr;
            for (csr = constructingFromClass; csr != null && csr != innersEnclosingClass; csr = (IGosuClassInternal)csr.getEnclosingType()) {
            }
            if (csr != innersEnclosingClass) {
                return false;
            }
        }
        return true;
    }

    private void _parseInitializerExpression(ContextType type) {
        if (type != null && JavaTypes.COLLECTION().isAssignableFrom(type.getType())) {
            this.parseCollectionInitializerList(type.getType());
        } else if (type != null && JavaTypes.MAP().isAssignableFrom(type.getType())) {
            this.parseMapInitializerList(type);
        } else if (type.getType().isDynamic()) {
            this.parseCollectionInitializerList(type.getType());
        } else {
            BadInitializerExpression be = new BadInitializerExpression();
            this.pushExpression(be);
        }
    }

    private IConstructorInfo getImplicitConstructor(IType type) {
        if (type instanceof IErrorType) {
            return null;
        }
        IConstructorInfo constructor = null;
        if (!type.isAbstract()) {
            ITypeInfo typeInfo = type.getTypeInfo();
            constructor = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getConstructor((IType)this.getGosuClass(), IType.EMPTY_ARRAY) : typeInfo.getConstructor(new IType[0]);
        }
        return constructor;
    }

    private void parseCollectionInitializerList(IType type) {
        IType listType;
        CollectionInitializerExpression lie = new CollectionInitializerExpression();
        Object componentType = type.isDynamic() ? type.getComponentType() : ((listType = TypeLord.findParameterizedTypeInHierarchy(type, (IType)JavaTypes.COLLECTION())).isParameterizedType() && !listType.isGenericType() ? listType.getTypeParameters()[0] : JavaTypes.OBJECT());
        do {
            this.parseExpression(new ContextType((IType)componentType));
            Expression e = this.popExpression();
            lie.add(e);
        } while (this.match(null, 44));
        lie.setType(type);
        this.pushExpression(lie);
    }

    private void parseMapInitializerList(ContextType type) {
        MapInitializerExpression mie = new MapInitializerExpression();
        IType listType = TypeLord.findParameterizedTypeInHierarchy(type.getType(), (IType)JavaTypes.MAP());
        IJavaType keyType = JavaTypes.OBJECT();
        IJavaType valueType = JavaTypes.OBJECT();
        if (listType.isParameterizedType()) {
            keyType = listType.getTypeParameters()[0];
            valueType = listType.getTypeParameters()[1];
        }
        do {
            Expression value;
            this.parseExpression(new ContextType((IType)keyType));
            Expression key = this.popExpression();
            if (this.verify((ParsedElement)key, this.match(null, "->", -6), Res.MSG_EXPECTING_ARROW_AFTER_MAP_KEY, new String[0])) {
                this.parseExpression(new ContextType((IType)valueType));
                value = this.popExpression();
            } else {
                value = new NullExpression();
            }
            mie.add(key, value);
        } while (this.match(null, 44));
        this.pushExpression(mie);
    }

    List<Expression> parseArrayValueList(IType componentType) {
        while (componentType instanceof TypeVariableType) {
            componentType = ((TypeVariableType)componentType).getBoundingType();
        }
        ArrayList<Expression> valueExpressions = new ArrayList<Expression>();
        do {
            this.parseExpression(new ContextType(componentType));
            Expression e = this.popExpression();
            valueExpressions.add(e);
        } while (this.match(null, 44));
        return valueExpressions;
    }

    private void parseIndirectMemberAccess(int iOffset, int iLineNum, int iColumn) {
        this.parseIndirectMemberAccess(iOffset, iLineNum, iColumn, false);
    }

    private void parseIndirectMemberAccess(int iOffset, int iLineNum, int iColumn, boolean bParsingTypeLiteralOnly) {
        while (true) {
            IType inferType;
            Expression expr;
            if (!this._parseIndirectMemberAccess(bParsingTypeLiteralOnly)) {
                expr = this.peekExpression();
                if (this.maybeReplaceErrantPackageExprWithEnumConstEpr(iOffset, iLineNum, iColumn, expr)) break;
                this.maybeReplacePackageExprWithTypeLiteral(iOffset, iLineNum, iColumn, expr);
                this.verify((ParsedElement)this.peekExpression(), !(this.peekExpression().getType() instanceof NamespaceType), Res.MSG_EXPECTING_TYPE_TO_FOLLOW_PACKAGE_NAME, new String[0]);
                this.verify((ParsedElement)this.peekExpression(), !(this.peekExpression() instanceof SuperAccess), Res.MSG_MEMBER_ACCESS_REQUIRED_FOR_SUPER, new String[0]);
                break;
            }
            this.setLocation(iOffset, iLineNum, iColumn);
            expr = this.peekExpression();
            if (!(expr instanceof MemberAccess) || (inferType = this._ctxInferenceMgr.infer(expr)) == null) continue;
            this.popExpression();
            expr = this.possiblyWrapWithImplicitCoercion(expr, inferType);
            this.pushExpression(expr);
        }
    }

    private void maybeReplacePackageExprWithTypeLiteral(int iOffset, int iLineNum, int iColumn, Expression expr) {
        if (expr instanceof Identifier && expr.getType() instanceof NamespaceType) {
            String strNamespace = expr.getType().getName();
            if (this.getNamespace() != null) {
                this.popExpression();
                this.tryToMakeTypeLiteral(new String[]{strNamespace}, iOffset, iLineNum, iColumn, strNamespace, expr);
            }
        }
    }

    private boolean maybeReplaceErrantPackageExprWithEnumConstEpr(int iOffset, int iLineNum, int iColumn, Expression expr) {
        MemberAccess enumConstExpr;
        if (expr instanceof Identifier && expr.getType() instanceof NamespaceType && (enumConstExpr = this.parseUnqualifiedEnumConstant(((Identifier)expr).getSymbol().getName())) != null) {
            this.setLocation(iOffset, iLineNum, iColumn);
            enumConstExpr.setStartOffset(iOffset);
            this.getLocationsList().remove(this.peekExpression().getLocation());
            this.popExpression();
            this.pushExpression(enumConstExpr);
            return true;
        }
        return false;
    }

    boolean _parseIndirectMemberAccess(boolean bParseTypeLiteralOnly) {
        ParseTree rootLocation;
        Expression peekRootExpression = this.peekExpression();
        Token token = this.getTokenizer().getCurrentToken();
        int operatorLineNumber = token.getLine();
        String value = token.getStringValue();
        if (46 == token.getType() || token.getType() == -6 && value != null && ("?.".equals(value) || "*.".equals(value))) {
            this.getTokenizer().nextToken();
            MemberAccessKind kind = MemberAccessKind.getForOperator((String)value);
            Expression expression = this.popExpression();
            this.verify((ParsedElement)expression, kind != MemberAccessKind.EXPANSION || TypeLord.getExpandableComponentType(expression.getType()) != null, Res.MSG_TYPE_IS_NOT_ITERABLE, expression.getType().getName());
            Token T = new Token();
            this.verify((ParsedElement)expression, this.match(T, -5) || this.match(T, -7), Res.MSG_EXPECTING_MEMBER_ACCESS_PATH, new String[0]);
            this.parseMemberAccess(expression, kind, T.getTokenStart(), T._strValue == null ? "" : T._strValue, this.makeLazyLightweightParserState(), bParseTypeLiteralOnly);
            this.verifyNonVoidExpression(this.peekExpression());
        } else if (!this.parseFeatureLiteral(token, peekRootExpression)) {
            if (!bParseTypeLiteralOnly && (91 == token.getType() || token.getType() == -6 && "?[".equals(value))) {
                Expression arrayAccess;
                boolean bNullSafe;
                this.getTokenizer().nextToken();
                Expression rootExpression = this.popExpression();
                IType rootType = rootExpression.getType();
                IJavaType indexType = ArrayAccess.supportsArrayAccess(rootType) ? JavaTypes.pINT() : (MapAccess.supportsMapAccess(rootType) ? MapAccess.getKeyType(rootType) : null);
                boolean bDynamicRoot = rootType.isDynamic();
                if (bDynamicRoot) {
                    this.parseExpression();
                } else {
                    this.parseExpression(new ContextType((IType)indexType));
                }
                Expression indexExpression = this.popExpression();
                boolean bl = bNullSafe = !ILanguageLevel.Util.STANDARD_GOSU() || value != null && "?[".equals(value);
                if (ArrayAccess.supportsArrayAccess(rootType)) {
                    ArrayAccess aa = new ArrayAccess();
                    aa.setRootExpression(rootExpression);
                    if (this.verify((ParsedElement)indexExpression, indexExpression.getType() == JavaTypes.pINT() || indexExpression.getType() == JavaTypes.INTEGER() || bDynamicRoot, Res.MSG_ARRAY_INDEX_MUST_BE_INT, new String[0])) {
                        aa.setMemberExpression(indexExpression);
                    }
                    aa.setNullSafe(bNullSafe);
                    this.pushExpression(aa);
                    arrayAccess = aa;
                } else if (MapAccess.supportsMapAccess(rootType)) {
                    MapAccess ma = new MapAccess();
                    ma.setRootExpression(rootExpression);
                    ma.setKeyExpression(indexExpression);
                    ma.setNullSafe(bNullSafe);
                    this.pushExpression(ma);
                    arrayAccess = ma;
                } else if (this.isSuperCall(rootExpression, indexExpression)) {
                    SuperAccess ma = new SuperAccess();
                    ma.setRootExpression((Identifier)rootExpression);
                    ma.setKeyExpression((TypeLiteral)indexExpression);
                    IType superType = this.verifySuperTypeIsDeclaredInCompilingClass((TypeLiteral)indexExpression);
                    ma.setType(superType);
                    this.pushExpression(ma);
                    arrayAccess = ma;
                } else {
                    this.verify((ParsedElement)rootExpression, BeanAccess.isBeanType(rootExpression.getType()) || rootExpression.getType() instanceof MetaType, Res.MSG_EXPECTING_BEAN_TYPE_WITH_REFLECTION_OPERATOR, new String[0]);
                    this.verify((ParsedElement)indexExpression, JavaTypes.CHAR_SEQUENCE().isAssignableFrom(indexExpression.getType()), Res.MSG_PROPERTY_REFLECTION_ONLY_WITH_STRINGS, new String[0]);
                    MemberAccess ma = new MemberAccess();
                    ma.setRootExpression(rootExpression);
                    ma.setMemberExpression(indexExpression);
                    ma.setType((IType)JavaTypes.OBJECT());
                    ma.setMemberAccessKind(bNullSafe ? MemberAccessKind.NULL_SAFE : MemberAccessKind.NORMAL);
                    this.pushExpression(ma);
                    arrayAccess = ma;
                }
                this.verify((ParsedElement)arrayAccess, this.match(null, 93), Res.MSG_EXPECTING_BRACKET_TO_CLOSE_DYNAMIC_MEMBER_ACCESS, new String[0]);
            } else if (this.peekExpression().getType() instanceof IBlockType && this.match(null, 40)) {
                IBlockType iBlockType = (IBlockType)this.peekExpression().getType();
                BlockInvocation bi = new BlockInvocation(this.popExpression());
                boolean bNoArgsProvided = this.match(null, 41);
                if (!bNoArgsProvided || iBlockType.hasOptionalParams()) {
                    MethodScore score = this.parseArgumentList2(bi, Collections.singletonList(iBlockType), IType.EMPTY_ARRAY, true, bNoArgsProvided);
                    bi.setNamedArgOrder(score.getNamedArgOrder());
                    bi.setArgs(score.getArguments());
                    this.verify((ParsedElement)bi, bNoArgsProvided || this.match(null, 41), Res.MSG_EXPECTING_FUNCTION_CLOSE, new String[0]);
                }
                this.verify((ParsedElement)bi, bi.getArgs().size() == iBlockType.getParameterTypes().length, Res.MSG_WRONG_NUM_OF_ARGS, iBlockType.getParameterTypes().length);
                bi.setType(iBlockType.getReturnType());
                this.verifyNonVoidExpression(bi);
                this.pushExpression(bi);
            } else {
                return false;
            }
        }
        if (peekRootExpression != null && !peekRootExpression.hasParseExceptions() && (rootLocation = peekRootExpression.getLocation()) != null) {
            this.getLocationsList().remove(peekRootExpression.getLocation());
            this.setLocation(rootLocation.getOffset(), rootLocation.getLineNum(), rootLocation.getColumn());
            this.peekExpression().getLocation().addChild(peekRootExpression.getLocation());
        }
        this.setOperatorLineNumber(this.peekExpression(), operatorLineNumber);
        return true;
    }

    private IType verifySuperTypeIsDeclaredInCompilingClass(TypeLiteral superTypeLiteral) {
        this.verify((ParsedElement)superTypeLiteral, !superTypeLiteral.getContainedParsedElementsByType(ITypeParameterListClause.class, null), Res.MSG_PARAMETERIZED_TYPE_NOT_ALLOWED_HERE, new String[0]);
        IType type = TypeLord.getPureGenericType(superTypeLiteral.getType().getType());
        ICompilableTypeInternal gosuClass = this.getGosuClass();
        IType superType = gosuClass.getSupertype();
        if (superType != null && TypeLord.getPureGenericType(superType) == type) {
            return superType;
        }
        if (superType == null && type == JavaTypes.OBJECT()) {
            return type;
        }
        for (IType iface : gosuClass.getInterfaces()) {
            if (TypeLord.getPureGenericType(iface) != type) continue;
            return iface;
        }
        this.addError(superTypeLiteral, Res.MSG_NOT_A_SUPERTYPE, type);
        return type;
    }

    private boolean isSuperCall(Expression rootExpression, Expression indexExpression) {
        return indexExpression instanceof TypeLiteral && rootExpression instanceof Identifier && ((Identifier)rootExpression).getSymbol().getName().equals(Keyword.KW_super.getName());
    }

    private boolean parseFeatureLiteral(Token token, Expression root) {
        Token T = new Token();
        if (-6 == token.getType() && "#".equals(token.getStringValue())) {
            this.getTokenizer().nextToken();
            if (root != this.popExpression()) {
                throw new IllegalStateException();
            }
            FeatureLiteral fle = new FeatureLiteral(root);
            boolean foundWord = this.verify((ParsedElement)fle, this.match(T, -5) || this.match(T, Keyword.KW_construct), Res.MSG_FL_EXPECTING_FEATURE_NAME, new String[0]);
            if (foundWord) {
                if (this.match(null, "<", -6, true)) {
                    this.parseErrantFeatureLiteralParameterization(fle);
                }
                if (this.match(null, 40)) {
                    if (!this.match(null, 41)) {
                        MethodScore score = this.parseArgumentList2(fle, fle.getFunctionTypes(T._strValue), IType.EMPTY_ARRAY, true, false);
                        if (this.allTypeLiterals(score.getArguments())) {
                            fle.removeParseException(Res.MSG_AMBIGUOUS_METHOD_INVOCATION);
                            List<IType> types = this.evalTypes(score.getArguments());
                            if (T._strValue.equals(Keyword.KW_construct.getName())) {
                                this.verify((ParsedElement)fle, fle.resolveConstructor(types), Res.MSG_FL_CONSTRUCTOR_NOT_FOUND, StringUtil.join(",", types));
                            } else {
                                this.verify((ParsedElement)fle, fle.resolveMethod(T._strValue, types), Res.MSG_FL_METHOD_NOT_FOUND, T._strValue, StringUtil.join(",", types));
                            }
                        } else {
                            IInvocableType funcType = score.getRawFunctionType();
                            if (funcType == null || funcType.getParameterTypes().length != score.getArguments().size()) {
                                fle.setFeature((IHasParameterInfos)ErrorType.getInstance().getTypeInfo().getMethod((CharSequence)T._strValue, new IType[0]), score.getArguments());
                                this.verify((ParsedElement)fle, false, Res.MSG_FL_METHOD_NOT_FOUND, T._strValue, "");
                            } else if (funcType instanceof IConstructorType) {
                                fle.setFeature((IHasParameterInfos)((IConstructorType)funcType).getConstructor(), score.getArguments());
                            } else {
                                fle.setFeature((IHasParameterInfos)((IFunctionType)funcType).getMethodInfo(), score.getArguments());
                            }
                        }
                        this.verify((ParsedElement)fle, this.match(null, 41), Res.MSG_FL_EXPECTING_RIGHT_PAREN, new String[0]);
                    } else if (T._strValue.equals(Keyword.KW_construct.getName())) {
                        this.verify((ParsedElement)fle, fle.resolveConstructor(Collections.emptyList()), Res.MSG_FL_CONSTRUCTOR_NOT_FOUND, "");
                    } else {
                        this.verify((ParsedElement)fle, fle.resolveMethod(T._strValue, Collections.emptyList()), Res.MSG_FL_METHOD_NOT_FOUND, T._strValue, "");
                    }
                } else {
                    boolean propResolved = fle.resolveProperty(T._strValue);
                    if (!propResolved) {
                        this.verify((ParsedElement)fle, propResolved, Res.MSG_FL_PROPERTY_NOT_FOUND, T._strValue);
                    }
                }
            } else {
                fle.setType((IType)ErrorType.getInstance());
            }
            if (root instanceof FeatureLiteral) {
                this.verify((ParsedElement)fle, fle.isPropertyLiteral(), Res.MSG_FL_ONLY_PROPERTIES_MAY_BE_CHAINED, new String[0]);
                this.verify((ParsedElement)fle, ((FeatureLiteral)root).isPropertyLiteral(), Res.MSG_FL_ONLY_PROPERTIES_MAY_BE_CHAINED, new String[0]);
            }
            if (fle.isStaticish() && !fle.hasParseExceptions()) {
                this.verify((ParsedElement)fle, root instanceof TypeLiteral, Res.MSG_FL_STATIC_FEATURES_MUST_BE_REFERENCED_FROM_THEIR_TYPES, new String[0]);
            }
            this.pushExpression(fle);
            return true;
        }
        return false;
    }

    private void parseErrantFeatureLiteralParameterization(FeatureLiteral fle) {
        while (this.verify((ParsedElement)fle, this.parseTypeLiteral(), (ResourceKey)null, new String[0])) {
            this.popExpression();
            if (this.match(null, 44)) continue;
        }
        this.verify((ParsedElement)fle, this.match(null, ">", -6, true), Res.MSG_FL_EXPECTING_RIGHT_CARET, new String[0]);
        this.verify((ParsedElement)fle, false, Res.MSG_FL_GENERIC_FUNCTION_REFERENCES_NOT_YET_SUPPORTED, new String[0]);
    }

    private List<IType> evalTypes(List<IExpression> arguments) {
        ArrayList<IType> types = new ArrayList<IType>();
        for (IExpression expression : arguments) {
            expression.clearParseExceptions();
            expression.clearParseWarnings();
            if (expression instanceof ImplicitTypeAsExpression) {
                expression = ((ImplicitTypeAsExpression)expression).getLHS();
            }
            types.add(((TypeLiteral)expression).evaluate());
        }
        return types;
    }

    private boolean allTypeLiterals(List<IExpression> args) {
        boolean allTypeLiterals = true;
        for (IExpression arg : args) {
            if (arg instanceof TypeLiteral || arg instanceof ImplicitTypeAsExpression && ((ImplicitTypeAsExpression)arg).getLHS() instanceof TypeLiteral) continue;
            allTypeLiterals = false;
        }
        return allTypeLiterals;
    }

    private void setOperatorLineNumber(Expression expression, int operatorLineNumber) {
        if (expression instanceof IHasOperatorLineNumber) {
            ((IHasOperatorLineNumber)((Object)expression)).setOperatorLineNumber(operatorLineNumber);
        }
    }

    boolean parseNameOrMethodCall(Token token) {
        IType inferType;
        Expression expr;
        if (token.getType() == -7 && (Keyword.KW_true == token.getKeyword() || Keyword.KW_false == token.getKeyword() || Keyword.KW_NaN == token.getKeyword() || Keyword.KW_Infinity == token.getKeyword() || Keyword.KW_null == token.getKeyword())) {
            return false;
        }
        int iOffset = token.getTokenStart();
        int iLineNum = token.getLine();
        int iColumn = token.getTokenColumn();
        boolean bRet = this._parseNameOrMethodCall(token);
        if (bRet) {
            this.verifyNonVoidExpression(this.peekExpression());
            this.setLocation(iOffset, iLineNum, iColumn);
        }
        if ((expr = this.peekExpression()) instanceof Identifier && (inferType = this._ctxInferenceMgr.infer(expr)) != null) {
            Identifier ma = (Identifier)this.popExpression();
            expr = this.possiblyWrapWithImplicitCoercion(ma, inferType);
            this.pushExpression(expr);
        }
        return bRet;
    }

    boolean _parseNameOrMethodCall(Token token) {
        int iOffset = token.getTokenStart();
        int iLineNum = token.getLine();
        int iColumn = token.getTokenColumn();
        LazyLightweightParserState state = this.makeLazyLightweightParserState();
        int markBefore = this.getTokenizer().mark();
        if (this.isWordOrValueKeyword(token) || this.matchPrimitiveType(true)) {
            this.getTokenizer().nextToken();
            String[] strToken = new String[]{this.getTokenizer().getTokenAt(markBefore).getStringValue()};
            MethodCallExpression e = new MethodCallExpression();
            IType[] typeParameters = this.parsePossibleFunctionParameterization(strToken[0], e);
            String strFunction = strToken[0];
            ISymbol functionSymbol = this.possiblyResolveFunctionSymbol(e, strFunction);
            int mark = this._tokenizer.mark();
            if (!this.isBlockSym(functionSymbol) && !this.isInSeparateStringTemplateExpression() && this.match(null, 40)) {
                this.parseMethodCall(strToken, iOffset, iLineNum, iColumn, state, e, typeParameters, strFunction, functionSymbol, mark);
            } else {
                token = this.getTokenizer().getCurrentToken();
                if (!Keyword.KW_super.equals(strToken[0]) || token.getType() == 46 || "#".equals(token.getStringValue()) || token.getType() == 91) {
                    this.parseIdentifierOrTypeLiteralOrEnumConstant(strToken, iOffset, iLineNum, iColumn);
                } else {
                    this.getTokenizer().restoreToMark(markBefore);
                    return false;
                }
            }
            this.verify((ParsedElement)this.peekExpression(), !GosuObjectUtil.equals((Object)strFunction, (Object)Keyword.KW_this.toString()) || !this.isParsingStaticFeature() || this.isParsingConstructor(), Res.MSG_CANNOT_REFERENCE_THIS_IN_STATIC_CONTEXT, new String[0]);
            return true;
        }
        return false;
    }

    private void parseMethodCall(String[] t, int iOffset, int iLineNum, int iColumn, IParserState state, MethodCallExpression e, IType[] typeParameters, String strFunction, ISymbol functionSymbol, int mark) {
        int iLocationsCount = this._locations.size();
        this.parseMethodCall(t, state, e, typeParameters, strFunction, functionSymbol);
        Expression expr = this.peekExpression();
        if (expr.hasParseExceptions()) {
            this.maybeParseIdentifierAssumingOpenParenIsForParenthesizedExpr(t, iOffset, iLineNum, iColumn, state, e, typeParameters, strFunction, functionSymbol, mark, iLocationsCount);
        }
    }

    private void maybeParseIdentifierAssumingOpenParenIsForParenthesizedExpr(String[] t, int iOffset, int iLineNum, int iColumn, IParserState state, MethodCallExpression e, IType[] typeParameters, String strFunction, ISymbol functionSymbol, int mark, int iLocationsCount) {
        if (!this.isOpenParenOnNextLine(mark)) {
            return;
        }
        this.backtrack(mark, iLocationsCount);
        this.parseIdentifierOrTypeLiteralOrEnumConstant(t, iOffset, iLineNum, iColumn);
        Expression expr = this.peekExpression();
        if (expr.hasParseExceptions()) {
            this.backtrack(mark, iLocationsCount);
            this.parseMethodCall(t, state, e, typeParameters, strFunction, functionSymbol);
        }
    }

    private void backtrack(int mark, int iLocationsCount) {
        this.backtrack(mark, iLocationsCount, this.popExpression());
    }

    private void backtrack(int mark, int iLocationsCount, Expression expr) {
        this._tokenizer.restoreToMark(mark);
        this.removeInnerClasses(expr);
        this.removeLocationsFrom(iLocationsCount);
    }

    private void parseMethodCall(String[] t, IParserState state, MethodCallExpression e, IType[] typeParameters, String strFunction, ISymbol functionSymbol) {
        if (functionSymbol == null && this.getGosuClass() != null) {
            functionSymbol = this.getGosuClass().getExternalSymbol(strFunction);
        }
        if (functionSymbol != null) {
            IType symbolType = functionSymbol.getType();
            if (symbolType instanceof IFunctionType) {
                int mark = this.getTokenizer().mark();
                int iLocationsCount = this._locations.size();
                this.parsePlainFunction((IFunctionSymbol)functionSymbol);
                this.verifyCase(this.peekExpression(), strFunction, functionSymbol.getName(), state, Res.MSG_FUNCTION_CASE_MISMATCH, false);
                if (this.peekExpression().hasParseException(Res.MSG_WRONG_NUMBER_OF_ARGS_TO_FUNCTION)) {
                    this.backtrack(mark, iLocationsCount);
                } else {
                    return;
                }
            }
            if (symbolType.isDynamic()) {
                this.parseDynamicFunction((Symbol)functionSymbol);
                this.verifyCase(this.peekExpression(), strFunction, functionSymbol.getName(), state, Res.MSG_FUNCTION_CASE_MISMATCH, false);
                return;
            }
        }
        int iParenStart = this._tokenizer.getTokenStart();
        e.setArgPosition(iParenStart);
        List<IFunctionType> listFunctionTypes = null;
        boolean bThis = GosuObjectUtil.equals((Object)strFunction, (Object)Keyword.KW_this.getName());
        boolean isRecursiveConstructorCall = false;
        boolean bNoArgsProvided = this.match(null, 41);
        if (!bNoArgsProvided || (listFunctionTypes = this.getFunctionTypesForName(strFunction)).size() == 1 && listFunctionTypes.get(0).hasOptionalParams()) {
            if (listFunctionTypes == null) {
                listFunctionTypes = this.getFunctionTypesForName(strFunction);
            }
            if (typeParameters != null) {
                listFunctionTypes = this.parameterizeFunctionTypes(e, typeParameters, listFunctionTypes);
            }
            MethodScore bestMethod = this.parseArgumentList2(e, listFunctionTypes, typeParameters, true, bNoArgsProvided);
            Expression[] eArgs = bestMethod.getArguments().toArray(new Expression[bestMethod.getArguments().size()]);
            e.setArgs(eArgs);
            boolean bMatched = bestMethod.isValid() && bestMethod.getRawFunctionType().getParameterTypes().length == eArgs.length;
            for (Expression arg : eArgs) {
                if (!arg.hasParseExceptions()) continue;
                bMatched = false;
                break;
            }
            if (!bMatched && listFunctionTypes.isEmpty()) {
                if (this.staticRefToNonStaticFunc(strFunction, eArgs)) {
                    this.verify((ParsedElement)e, false, state, Res.MSG_CANNOT_CALL_NON_STATIC_METHOD_FROM_STATIC_CONTEXT, strFunction);
                } else {
                    this.verify((ParsedElement)e, false, state, Res.MSG_NO_SUCH_FUNCTION, strFunction);
                }
            }
            if (bestMethod.isValid()) {
                IFunctionType rawFunctionType = (IFunctionType)bestMethod.getRawFunctionType();
                this.verifyArgCount((ParsedElement)e, bestMethod.getArguments().size(), rawFunctionType);
                if (!bThis && !GosuObjectUtil.equals((Object)strFunction, (Object)Keyword.KW_super.getName())) {
                    this.verifyCase(e, strFunction, rawFunctionType.getName(), state, Res.MSG_FUNCTION_CASE_MISMATCH, false);
                } else if (bThis) {
                    Object[] parameterTypes1;
                    Object[] parameterTypes0 = this.peekParsingFunction().getParameterTypes();
                    isRecursiveConstructorCall = parameterTypes0.length == (parameterTypes1 = rawFunctionType.getParameterTypes()).length && Arrays.equals(parameterTypes0, parameterTypes1);
                }
                e.setFunctionSymbol((IFunctionSymbol)this.getDFSForFunctionType(strFunction, bestMethod));
                e.setNamedArgOrder(bestMethod.getNamedArgOrder());
                IFunctionType inferredFunctionType = (IFunctionType)bestMethod.getInferredFunctionType();
                if (inferredFunctionType instanceof FunctionType) {
                    ((FunctionType)inferredFunctionType).setScriptPart(rawFunctionType.getScriptPart());
                }
                e.setType(inferredFunctionType.getReturnType());
                e.setFunctionType(inferredFunctionType);
            } else {
                e.setType((IType)ErrorType.getInstance());
            }
            this.verify((ParsedElement)e, bNoArgsProvided || this.match(null, 41), Res.MSG_EXPECTING_FUNCTION_CLOSE, new String[0]);
        } else {
            IFunctionSymbol function;
            if (bThis && bNoArgsProvided && this.peekParsingFunction().getParameterTypes().length == 0 && this.getScriptPart().getContainingType().getName().endsWith(this.peekParsingFunction().getName())) {
                isRecursiveConstructorCall = true;
            }
            if ((function = (IFunctionSymbol)this.getSymbolTable().getSymbol((CharSequence)(strFunction + "()"))) == null) {
                function = (IFunctionSymbol)this.getSymbolTable().getSymbol((CharSequence)strFunction);
            }
            if (function == null || !(function.getType() instanceof IFunctionType)) {
                boolean bPossiblePropertyName;
                String strPropertyName = this.getPropertyNameFromMethodName(strFunction);
                boolean bl = bPossiblePropertyName = this.getGosuClass() != null && strPropertyName != null;
                if (bPossiblePropertyName) {
                    t[0] = strPropertyName;
                    this.parseIdentifier(new PropertyAsMethodCallIdentifier(strFunction), t);
                    Expression expression = this.peekExpression();
                    if (!expression.hasParseExceptions()) {
                        return;
                    }
                    this.popExpression();
                }
            }
            if (function == null) {
                List<IFunctionSymbol> possibleMatches;
                listFunctionTypes = this.getFunctionTypesForName(strFunction);
                if (!listFunctionTypes.isEmpty()) {
                    this.verifyArgCount((ParsedElement)e, 0, listFunctionTypes.get(0));
                }
                if (!(possibleMatches = this.getDfsDeclsForFunction(strFunction)).isEmpty()) {
                    function = possibleMatches.get(0);
                    e.setFunctionSymbol(function);
                }
            }
            if (function == null || !(function.getType() instanceof IFunctionType)) {
                if (this.staticRefToNonStaticFunc(strFunction, new Expression[0])) {
                    this.verify((ParsedElement)e, false, state, Res.MSG_CANNOT_CALL_NON_STATIC_METHOD_FROM_STATIC_CONTEXT, strFunction);
                } else {
                    this.verify((ParsedElement)e, false, state, Res.MSG_NO_SUCH_FUNCTION, strFunction);
                }
                e.setType((IType)ErrorType.getInstance());
            } else {
                IFunctionType parameterizedFuncType;
                e.setFunctionSymbol(function);
                this.verifyCase(e, strFunction, function.getDisplayName(), state, Res.MSG_FUNCTION_CASE_MISMATCH, false);
                IFunctionType funcType = (IFunctionType)function.getType();
                if (typeParameters != null && this.verifyCanParameterizeType(e, (IType)funcType, typeParameters) && this.verify((ParsedElement)e, (parameterizedFuncType = (IFunctionType)funcType.getParameterizedType(typeParameters)) != null, Res.MSG_COULD_NOT_PARAMETERIZE, new String[0])) {
                    funcType = parameterizedFuncType;
                }
                assert (funcType != null);
                if (this.isEndOfExpression()) {
                    funcType = this.maybeParameterizeOnCtxType(funcType);
                }
                IFunctionType boundFuncType = this.boundFunctionType(funcType);
                e.setType(boundFuncType.getReturnType());
                e.setFunctionType(boundFuncType);
            }
            e.setArgs(null);
        }
        this.verify((ParsedElement)e, !isRecursiveConstructorCall, Res.MSG_RECURSIVE_CONSTRUCTOR, new String[0]);
        if (this.isParsingAbstractConstructor() && e.getFunctionSymbol() instanceof DynamicFunctionSymbol && e.getFunctionSymbol().isAbstract()) {
            e.addParseException((IParseIssue)new ParseException(state, Res.MSG_NO_ABSTRACT_METHOD_CALL_IN_CONSTR, new Object[]{e.getFunctionSymbol().getDisplayName()}));
        }
        if (e instanceof MethodCallExpression) {
            this.verifyNotCallingOverridableFunctionFromCtor(e);
            if (this.getGosuClass() != null && this.getGosuClass().isAnonymous() && this.getGosuClass().getEnclosingType() instanceof IGosuEnhancement) {
                this.verify((ParsedElement)e, false, Res.MSG_CANNOT_REFERENCE_ENCLOSING_METHODS_WITHIN_ENHANCEMENTS, new String[0]);
            }
        }
        this.pushExpression(e);
    }

    private boolean isInSeparateStringTemplateExpression() {
        if (this.getTokenizerInstructor() != null) {
            Token priorToken = this.getTokenizer().getTokenAt(this.getTokenizer().getState() - 1);
            return priorToken != null && priorToken.getType() == -2 && (priorToken.getStringValue().indexOf(125) >= 0 || priorToken.getStringValue().indexOf(62) >= 0);
        }
        return false;
    }

    private ISymbol possiblyResolveFunctionSymbol(MethodCallExpression e, String strFunction) {
        ISymbol functionSymbol = this._symTable.getSymbol((CharSequence)strFunction);
        if (functionSymbol == null) {
            functionSymbol = this.resolveSymbol(e, strFunction, false);
            e.removeParseException(Res.MSG_BAD_IDENTIFIER_NAME);
            if (!(functionSymbol instanceof CapturedSymbol)) {
                functionSymbol = null;
            }
        }
        return functionSymbol;
    }

    private boolean isBlockSym(ISymbol functionSymbol) {
        return functionSymbol != null && functionSymbol.getType() instanceof IBlockType;
    }

    private boolean staticRefToNonStaticFunc(String stFunction, Expression[] eArgs) {
        if (this.isParsingStaticFeature() && this.getGosuClass() != null) {
            List<? extends IDynamicFunctionSymbol> matchingDFSs = this.getGosuClass().getMemberFunctions(stFunction);
            for (IDynamicFunctionSymbol iDynamicFunctionSymbol : matchingDFSs) {
                if (iDynamicFunctionSymbol.isStatic() || iDynamicFunctionSymbol.getArgs().size() != eArgs.length) continue;
                return true;
            }
        }
        return false;
    }

    private boolean staticRefToNonStaticProp(String name) {
        IDynamicPropertySymbol dps;
        return this.isParsingStaticFeature() && this.getGosuClass() != null && (dps = this.getGosuClass().getMemberProperty(name)) != null && !dps.isStatic();
    }

    private IFunctionType boundFunctionType(IFunctionType funcType) {
        if (funcType.isGenericType()) {
            IGenericTypeVariable[] typeVariables = funcType.getGenericTypeVariables();
            ArrayList<IType> functionTypeVars = new ArrayList<IType>();
            this.addTypeVarsToList(functionTypeVars, typeVariables);
            return (IFunctionType)TypeLord.boundTypes((IType)funcType, functionTypeVars);
        }
        return funcType;
    }

    private IDynamicFunctionSymbol getDFSForFunctionType(String strFunction, MethodScore bestMethod) {
        List<IFunctionSymbol> list = this.getDfsDeclsForFunction(strFunction);
        IInvocableType rawFunctionType = bestMethod.getRawFunctionType();
        for (IFunctionSymbol dfs : list) {
            IType dfsType = dfs.getType();
            if (!dfsType.equals(rawFunctionType) && !dfsType.equals(rawFunctionType.getGenericType())) continue;
            return (IDynamicFunctionSymbol)dfs;
        }
        throw new IllegalStateException("Could not find matching DFS in " + list + " for type " + rawFunctionType);
    }

    private void verifyNotCallingOverridableFunctionFromCtor(MethodCallExpression mce) {
        if (!this.isParsingConstructor() || this.isParsingBlock()) {
            return;
        }
        IFunctionSymbol fs = mce.getFunctionSymbol();
        if (fs instanceof DynamicFunctionSymbol && !(fs instanceof SuperConstructorFunctionSymbol) && !(fs instanceof ThisConstructorFunctionSymbol)) {
            DynamicFunctionSymbol dfs = (DynamicFunctionSymbol)fs;
            this.verifyOrWarn(mce, dfs.isPrivate() || dfs.isFinal() || dfs.isStatic(), true, Res.MSG_CALLING_OVERRIDABLE_FROM_CTOR, dfs.getName());
        }
    }

    private void verifyNotCallingOverridableFunctionFromCtor(BeanMethodCallExpression mce) {
        IMethodInfo mi;
        if (!this.isParsingConstructor() || this.isParsingBlock()) {
            return;
        }
        if (mce.getRootExpression() instanceof Identifier && ((Identifier)mce.getRootExpression()).getSymbol() != null && Keyword.KW_this.equals(((Identifier)mce.getRootExpression()).getSymbol().getName()) && (mi = mce.getMethodDescriptor()) instanceof AbstractGenericMethodInfo) {
            ReducedDynamicFunctionSymbol dfs = ((AbstractGenericMethodInfo)mi).getDfs();
            if (!((AbstractGenericMethodInfo)mi).getDfs().isSuperOrThisConstructor()) {
                this.verifyOrWarn(mce, dfs.isPrivate() || dfs.isFinal() || dfs.isStatic(), true, Res.MSG_CALLING_OVERRIDABLE_FROM_CTOR, dfs.getName());
            }
        }
    }

    private boolean isParsingConstructor() {
        if (!this.isParsingFunction()) {
            return false;
        }
        FunctionType funcType = this.peekParsingFunction();
        return funcType.getReturnType() == this.getGosuClass() && funcType.getName().equals(funcType.getReturnType().getRelativeName());
    }

    private IType[] parsePossibleFunctionParameterization(String name, MethodCallExpression e) {
        if (this.match(null, "<", -6, true)) {
            List<IFunctionType> listFunctionTypes = this.getFunctionTypesForName(name);
            for (IFunctionType ftype : listFunctionTypes) {
                if (!ftype.isGenericType()) continue;
                return this.parseFunctionParameterization(e);
            }
        }
        return null;
    }

    private void parseIdentifier(String[] T) {
        this.parseIdentifier(new Identifier(), T);
    }

    private void parseIdentifier(Identifier e, String[] T) {
        String name = T[0];
        ISymbol s = this.resolveSymbol(e, name, true);
        if (s instanceof DynamicFunctionSymbol) {
            s = this.resolveNamespaceSymbol(e, name);
        } else if (s instanceof DynamicPropertySymbol) {
            e = new PropertyAccessIdentifier(e);
        }
        IType type = s.getType();
        e.setSymbol(s, this._symTable);
        e.setType(type);
        if (s instanceof DynamicPropertySymbol) {
            if (this.getGosuClass() != null && !(this.getGosuClass() instanceof IGosuProgram) && this.getGosuClass().isAnonymous() && this.getGosuClass().getEnclosingType() instanceof IGosuEnhancement) {
                if (s.getName().equals(Keyword.KW_outer.toString())) {
                    this.verify((ParsedElement)e, false, Res.MSG_CANNOT_REFERENCE_OUTER_SYMBOL_WITHIN_ENHANCEMENTS, new String[0]);
                } else {
                    this.verify((ParsedElement)e, false, Res.MSG_CANNOT_REFERENCE_ENCLOSING_PROPERTIES_WITHIN_ENHANCEMENTS, new String[0]);
                }
            } else if (this.getGosuClass() != null && this.getGosuClass().getEnclosingType() != null && this.getGosuClass().getEnclosingType().isInterface() && s.getName().equals(Keyword.KW_outer.toString())) {
                this.verify((ParsedElement)e, false, Res.MSG_BAD_IDENTIFIER_NAME, name);
            }
        }
        this.verify((ParsedElement)e, !(s instanceof AmbiguousSymbol), Res.MSG_AMBIGUOUS_SYMBOL_REFERENCE, name);
        this.pushExpression(e);
        this.verify((ParsedElement)e, !(this.getCurrentEnclosingGosuClass() instanceof IBlockClass) || !Keyword.KW_super.equals(s.getName()), Res.MSG_SUPER_NOT_ACCESSIBLE_FROM_BLOCK, new String[0]);
        if (!(type instanceof ErrorType) && !(type instanceof IFunctionType)) {
            this.verifyCase(e, name, s.getName(), Res.MSG_VAR_CASE_MISMATCH, false);
        }
    }

    private void parseIdentifierOrTypeLiteralOrEnumConstant(String[] T, int iOffset, int iLineNum, int iColumn) {
        String name = T[0];
        this.parseIdentifier(T);
        Expression identifier = this.peekExpression();
        IType type = identifier.getType();
        if (type instanceof ErrorType || type instanceof IFunctionType && !(type instanceof IBlockType)) {
            this.setLocation(iOffset, iLineNum, iColumn);
            this.getLocationsList().remove(this.peekExpression().getLocation());
            Expression errantExpression = this.popExpression();
            MemberAccess enumConstExpr = this.parseUnqualifiedEnumConstant(T[0]);
            if (enumConstExpr != null) {
                this.pushExpression(enumConstExpr);
                enumConstExpr.setStartOffset(iOffset);
            } else {
                this.tryToMakeTypeLiteral(T, iOffset, iLineNum, iColumn, name, errantExpression);
            }
        }
    }

    private void tryToMakeTypeLiteral(String[] T, int iOffset, int iLineNum, int iColumn, String name, Expression errantExpression) {
        TypeLiteral tl = this.resolveTypeLiteral(T);
        boolean bArrayOrParameterzied = this.resolveArrayOrParameterizationPartOfTypeLiteral(T, false, tl);
        if (!bArrayOrParameterzied && ((TypeLiteral)this.peekExpression()).getType().getType() instanceof ErrorType) {
            this.popExpression();
            if (this.staticRefToNonStaticProp(name)) {
                errantExpression.clearParseExceptions();
                this.verify((ParsedElement)errantExpression, false, Res.MSG_CANNOT_REFERENCE_NON_STATIC_PROPERTY_FROM_STATIC_CONTEXT, new String[0]);
            }
            this.pushExpression(errantExpression);
        } else if (this.match(null, "&", -6, true)) {
            this.setLocation(iOffset, iLineNum, iColumn);
            this.parseAggregateTypeLiteral(false);
        }
    }

    private void parseNamespaceStartOrRelativeType(String[] T, boolean bInterface) {
        INamespaceType type = this.resolveNamespace(T[0]);
        if (type != null) {
            Identifier e = new Identifier();
            Symbol s = new Symbol(T[0], (IType)type, null);
            e.setSymbol((ISymbol)s, this._symTable);
            e.setType((IType)type);
            this.pushExpression(e);
        } else {
            TypeLiteral tl = this.resolveTypeLiteral(T, true, bInterface);
            this.resolveArrayOrParameterizationPartOfTypeLiteral(T, true, tl);
        }
    }

    private MemberAccess parseUnqualifiedEnumConstant(String strConstValue) {
        IType contextType = this.getContextType().getType();
        if (contextType != null && (contextType.isEnum() || TypeSystem.get(IEnumValue.class).isAssignableFrom(contextType))) {
            try {
                IPropertyInfo property = contextType.getTypeInfo().getProperty((CharSequence)strConstValue);
                if (property != null && property.isStatic()) {
                    UnqualifiedEnumMemberAccess ma = new UnqualifiedEnumMemberAccess();
                    TypeLiteral e = new TypeLiteral((IType)MetaType.getLiteral(property.getOwnersType()));
                    ma.setRootExpression(e);
                    ma.setMemberName(property.getName());
                    ma.setType(property.getFeatureType());
                    ma.setMemberAccessKind(MemberAccessKind.NORMAL);
                    return ma;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private void verifyArgCount(ParsedElement element, int iArgs, IFunctionType funcType) {
        int expectedArgs = funcType.getParameterTypes().length;
        if (iArgs != expectedArgs) {
            WrongNumberOfArgsException pe = new WrongNumberOfArgsException((IParserState)this.makeFullParserState(), Res.MSG_WRONG_NUMBER_OF_ARGS_TO_FUNCTION, funcType.getParamSignature(), expectedArgs, iArgs);
            pe.setParamTypesExpected(funcType.getParameterTypes());
            pe.setCausedByArgumentList(true);
            element.addParseException((IParseIssue)pe);
        }
    }

    private void verifyOverrideNotOnMethodThatDoesNotExtend(ParsedElement element, DynamicFunctionSymbol dfs) {
        String strPotentialProperty;
        if (!dfs.isOverride()) {
            return;
        }
        DoesNotOverrideFunctionException pe = null;
        ICompilableTypeInternal gsClass = this.getGosuClass();
        if (gsClass != null && (strPotentialProperty = this.getPropertyNameFromMethodNameIncludingSetter(dfs.getDisplayName())) != null) {
            pe = new DoesNotOverrideFunctionException((IParserState)this.makeFullParserState(), Res.MSG_FUNCTION_NOT_OVERRIDE_PROPERTY, new CharSequence[]{dfs.getName(), strPotentialProperty});
        }
        if (pe == null) {
            pe = new DoesNotOverrideFunctionException((IParserState)this.makeFullParserState(), Res.MSG_FUNCTION_NOT_OVERRIDE, new CharSequence[]{dfs.getName()});
        }
        element.addParseException((IParseIssue)pe);
    }

    private void verifyArgCount(ParsedElement element, int iArgs, IConstructorType ctorType) {
        if (ctorType.getConstructor() instanceof DynamicConstructorInfo) {
            return;
        }
        int expectedArgs = ctorType.getParameterTypes().length;
        if (iArgs != expectedArgs) {
            ParseException pe = new ParseException((IParserState)this.makeFullParserState(), Res.MSG_WRONG_NUMBER_OF_ARGS_TO_CONSTRUCTOR, new Object[]{ctorType.getArgSignature(), expectedArgs, iArgs});
            pe.setParamTypesExpected(ctorType.getParameterTypes());
            pe.setCausedByArgumentList(true);
            element.addParseException((IParseIssue)pe);
        }
    }

    private void parsePlainFunction(IFunctionSymbol functionSymbol) {
        MethodCallExpression e = new MethodCallExpression();
        e.setFunctionSymbol(functionSymbol);
        IFunctionType funcType = (IFunctionType)functionSymbol.getType();
        e.setType(funcType.getReturnType());
        IType[] argTypes = funcType.getParameterTypes();
        boolean bNoArgsProvided = this.match(null, 41);
        if (!bNoArgsProvided || funcType.hasOptionalParams()) {
            this.verify((ParsedElement)e, argTypes != null && argTypes.length > 0, Res.MSG_NO_ARGUMENTS, functionSymbol.getName());
            MethodScore score = this.parseArgumentList2(e, Collections.singletonList(funcType), null, true, bNoArgsProvided);
            if (score.isValid()) {
                List scoreArgs = score.getArguments();
                this.verifyArgCount((ParsedElement)e, scoreArgs.size(), funcType);
                e.setArgs(scoreArgs.toArray(new Expression[scoreArgs.size()]));
                e.setNamedArgOrder(score.getNamedArgOrder());
            }
            this.verify((ParsedElement)e, bNoArgsProvided || this.match(null, 41), Res.MSG_EXPECTING_FUNCTION_CLOSE, new String[0]);
        } else {
            this.verify((ParsedElement)e, argTypes == null || argTypes.length == 0, Res.MSG_EXPECTING_ARGS, functionSymbol.getName());
            e.setArgs(null);
        }
        this.pushExpression(e);
    }

    private void parseDynamicFunction(Symbol dynamcSymbol) {
        MethodCallExpression e = new MethodCallExpression();
        e.setFunctionSymbol(dynamcSymbol);
        e.setType(dynamcSymbol.getType());
        if (!this.match(null, 41)) {
            MethodScore score = this.parseArgumentList2(e, Collections.singletonList(new FunctionType(dynamcSymbol.getName(), dynamcSymbol.getType(), IType.EMPTY_ARRAY)), null, true, false);
            List scoreArgs = score.getArguments();
            e.setArgs(scoreArgs.toArray(new Expression[scoreArgs.size()]));
            e.setNamedArgOrder(score.getNamedArgOrder());
            this.verify((ParsedElement)e, this.match(null, 41), Res.MSG_EXPECTING_FUNCTION_CLOSE, new String[0]);
        } else {
            e.setArgs(null);
        }
        this.pushExpression(e);
    }

    private void parseMemberAccess(Expression rootExpression, MemberAccessKind kind, int iTokenStart, String strMemberName, LazyLightweightParserState state, boolean bParseTypeLiteralOnly) {
        this.parseMemberAccess(rootExpression, kind, iTokenStart, strMemberName, state, bParseTypeLiteralOnly, false);
    }

    private void parseMemberAccess(Expression rootExpression, MemberAccessKind kind, int iTokenStart, String strMemberName, LazyLightweightParserState state, boolean bParseTypeLiteralOnly, boolean createSynthesizedProperty) {
        IType[] typeParameters;
        boolean bExpansion;
        IType rootType;
        BeanMethodCallExpression e;
        block6: {
            e = new BeanMethodCallExpression();
            rootType = rootExpression.getType();
            rootType = IGosuClass.ProxyUtil.isProxy((IType)rootType) && rootType instanceof IGosuClass ? ((IGosuClass)rootType).getJavaType() : rootType;
            bExpansion = kind == MemberAccessKind.EXPANSION;
            IType iType = rootType = bExpansion ? TypeLord.getExpandableComponentType(rootType) : rootType;
            if (rootType != null && !rootType.isArray()) {
                boolean bAcceptableType = BeanAccess.isBeanType(rootType) || rootType == GosuParserTypes.BOOLEAN_TYPE() || rootType == GosuParserTypes.STRING_TYPE() || rootType == GosuParserTypes.NUMBER_TYPE() || rootType instanceof IBlockType || rootType instanceof MetaType;
                this.verify((ParsedElement)e, bAcceptableType, Res.MSG_EXPECTING_BEANTYPE, rootType.getName());
            }
            typeParameters = null;
            try {
                if (bParseTypeLiteralOnly || rootType instanceof ErrorType || !this.match(null, "<", -6, true)) break block6;
                ArrayList<IFunctionType> list = new ArrayList<IFunctionType>();
                this.getFunctionType(rootType, strMemberName, null, list, this, true);
                for (IFunctionType ftype : list) {
                    if (!ftype.isGenericType()) continue;
                    typeParameters = this.parseFunctionParameterization(e);
                    break;
                }
            }
            catch (ParseException pe) {
                e.addParseException((IParseIssue)pe);
            }
        }
        int iParenStart = this._tokenizer.getTokenStart();
        int mark = this._tokenizer.mark();
        if (!bParseTypeLiteralOnly && !this.isInSeparateStringTemplateExpression() && this.match(null, null, 40, true) && !this.isBlockInvoke(rootExpression, strMemberName, rootType)) {
            this.match(null, 40);
            this.parseMethodMember(rootExpression, kind, iTokenStart, strMemberName, state, bParseTypeLiteralOnly, createSynthesizedProperty, e, rootType, bExpansion, typeParameters, iParenStart, mark);
        } else {
            this.parsePropertyMember(rootExpression, kind, iTokenStart, strMemberName, state, bParseTypeLiteralOnly, createSynthesizedProperty, rootType, bExpansion);
        }
    }

    private void parseMethodMember(Expression rootExpression, MemberAccessKind kind, int iTokenStart, String strMemberName, LazyLightweightParserState state, boolean bParseTypeLiteralOnly, boolean createSynthesizedProperty, BeanMethodCallExpression e, IType rootType, boolean bExpansion, IType[] typeParameters, int iParenStart, int mark) {
        int iLocationsCount = this._locations.size();
        this.parseMethodMember(rootExpression, kind, iTokenStart, strMemberName, state, bParseTypeLiteralOnly, e, rootType, bExpansion, typeParameters, iParenStart);
        Expression expr = this.peekExpression();
        if (expr.hasParseExceptions()) {
            this.maybeOpenParenIsForParenthesizedExpr(rootExpression, kind, iTokenStart, strMemberName, state, bParseTypeLiteralOnly, createSynthesizedProperty, e, rootType, bExpansion, typeParameters, iParenStart, mark, iLocationsCount);
        }
    }

    private void maybeOpenParenIsForParenthesizedExpr(Expression rootExpression, MemberAccessKind kind, int iTokenStart, String strMemberName, LazyLightweightParserState state, boolean bParseTypeLiteralOnly, boolean createSynthesizedProperty, BeanMethodCallExpression e, IType rootType, boolean bExpansion, IType[] typeParameters, int iParenStart, int mark, int iLocationsCount) {
        if (!this.isOpenParenOnNextLine(mark)) {
            return;
        }
        this.backtrack(mark, iLocationsCount);
        this.parsePropertyMember(rootExpression, kind, iTokenStart, strMemberName, state, bParseTypeLiteralOnly, createSynthesizedProperty, rootType, bExpansion);
        Expression expr = this.peekExpression();
        if (expr.hasParseExceptions()) {
            this._tokenizer.restoreToMark(mark);
            expr = this.popExpression();
            this.removeInnerClasses(expr);
            this.removeLocationsFrom(iLocationsCount);
            this.parseMethodMember(rootExpression, kind, iTokenStart, strMemberName, state, bParseTypeLiteralOnly, e, rootType, bExpansion, typeParameters, iParenStart);
        }
    }

    private boolean isOpenParenOnNextLine(int mark) {
        if (mark <= 0) {
            return false;
        }
        Token priorMarkToken = this._tokenizer.getTokenAt(mark - 1);
        return priorMarkToken != null && priorMarkToken.getType() == -2 && priorMarkToken.getText().indexOf(10) >= 0;
    }

    private void parseMethodMember(Expression rootExpression, MemberAccessKind kind, int iTokenStart, String strMemberName, LazyLightweightParserState state, boolean bParseTypeLiteralOnly, BeanMethodCallExpression e, IType rootType, boolean bExpansion, IType[] typeParameters, int iParenStart) {
        e.setArgPosition(iParenStart + 1);
        e.setRootExpression(rootExpression);
        IMethodInfo md = null;
        List<IFunctionType> listFunctionTypes = this.getPreliminaryFunctionTypes(strMemberName, e, rootType, typeParameters);
        boolean bNoArgsProvided = this.match(null, 41);
        if (!bNoArgsProvided || listFunctionTypes.size() == 1 && listFunctionTypes.get(0).hasOptionalParams()) {
            MethodScore methodScore = this.parseArgumentList2(e, listFunctionTypes, typeParameters, !(rootType instanceof ErrorType), bNoArgsProvided);
            Expression[] eArgs = methodScore.getArguments().toArray(new Expression[methodScore.getArguments().size()]);
            e.setArgs(eArgs);
            if (methodScore.isValid()) {
                IFunctionType funcType = (IFunctionType)methodScore.getInferredFunctionType();
                this.verifyArgCount((ParsedElement)e, eArgs.length, funcType);
                assert (funcType != null);
                e.setType(!bExpansion || funcType.getReturnType().isArray() || funcType.getReturnType() == JavaTypes.pVOID() ? funcType.getReturnType() : funcType.getReturnType().getArrayType());
                e.setFunctionType(funcType);
                IType[] argTypes = funcType.getParameterTypes();
                e.setArgTypes(argTypes);
                IFunctionType rawFunctionType = (IFunctionType)methodScore.getRawFunctionType();
                md = rawFunctionType.getMethodInfo();
                if (!md.isVisible(this.getVisibilityConstraint())) {
                    this.verify((ParsedElement)e, false, Res.MSG_METHOD_NOT_VISIBLE, strMemberName);
                }
                e.setMethodDescriptor(bExpansion ? new ArrayExpansionMethodInfo(md) : md);
                e.setMemberAccessKind(kind);
                e.setNamedArgOrder(methodScore.getNamedArgOrder());
                this.verifyCase(e, strMemberName, funcType.getName(), state, Res.MSG_FUNCTION_CASE_MISMATCH, false);
                this.verifySuperAccess(rootExpression, e, (IAttributedFeatureInfo)funcType.getMethodInfo(), strMemberName);
            } else {
                if (!(rootType instanceof ErrorType) && !e.hasParseException(Res.MSG_AMBIGUOUS_METHOD_INVOCATION)) {
                    this.verify((ParsedElement)e, false, state, Res.MSG_NO_SUCH_FUNCTION, strMemberName);
                }
                e.setType((IType)ErrorType.getInstance());
            }
            e.setAccessPath(strMemberName);
            this.verify((ParsedElement)e, bNoArgsProvided || this.match(null, 41), Res.MSG_EXPECTING_FUNCTION_CLOSE, new String[0]);
        } else if (rootType instanceof ErrorType) {
            e.setType((IType)ErrorType.getInstance());
            e.setArgTypes(IType.EMPTY_ARRAY);
            e.setAccessPath(strMemberName);
            md = null;
            e.setMethodDescriptor(md);
            e.setArgs(null);
        } else {
            IFunctionType parameterizedFuncType;
            IFunctionType funcType;
            try {
                funcType = this.getFunctionType(rootType, strMemberName, new Expression[0], null, this, true);
            }
            catch (ParseException pe) {
                String strPropertyName = this.getPropertyNameFromMethodName(strMemberName);
                if (strPropertyName == null) {
                    try {
                        funcType = this.getFunctionType(rootType, strMemberName, new Expression[0], null, this, false);
                        e.addParseException((IParseIssue)pe);
                    }
                    catch (ParseException e1) {
                        e.addParseException((IParseIssue)pe);
                        e.setType((IType)ErrorType.getInstance());
                        e.setStartOffset(iTokenStart);
                        this.pushExpression(e);
                        return;
                    }
                }
                this.parseMemberAccess(rootExpression, kind, iTokenStart, strPropertyName, state, bParseTypeLiteralOnly, true);
                Expression expression = this.peekExpression();
                if (expression instanceof MemberAccess) {
                    MemberAccess ma = (MemberAccess)expression;
                    ma.setMethodNameForSyntheticAccess(strMemberName);
                }
                if (this.peekExpression().hasParseExceptions()) {
                    e.addParseException((IParseIssue)pe);
                    e.addParseExceptions(this.peekExpression().getParseExceptions());
                    this.popExpression();
                    e.setType((IType)ErrorType.getInstance());
                    e.setStartOffset(iTokenStart);
                    this.pushExpression(e);
                }
                return;
            }
            if (typeParameters != null && this.verifyCanParameterizeType(e, (IType)funcType, typeParameters) && this.verify((ParsedElement)e, (parameterizedFuncType = (IFunctionType)funcType.getParameterizedType(typeParameters)) != null, Res.MSG_COULD_NOT_PARAMETERIZE, new String[0])) {
                funcType = parameterizedFuncType;
            }
            assert (funcType != null);
            if (this.isEndOfExpression()) {
                funcType = this.maybeParameterizeOnCtxType(funcType);
            }
            IFunctionType boundType = this.boundFunctionType(funcType);
            e.setType(!bExpansion || funcType.getReturnType().isArray() || funcType.getReturnType() == JavaTypes.pVOID() ? boundType.getReturnType() : boundType.getReturnType().getArrayType());
            e.setFunctionType(funcType);
            IType[] argTypes = funcType.getParameterTypes();
            e.setArgTypes(argTypes);
            e.setAccessPath(strMemberName);
            md = funcType.getMethodInfo();
            this.verify((ParsedElement)e, md.isVisible(this.getVisibilityConstraint()), Res.MSG_METHOD_NOT_VISIBLE, strMemberName);
            this.verify((ParsedElement)e, !md.isAbstract() || !(rootExpression instanceof Identifier) || !((Identifier)rootExpression).getSymbol().getName().equals(Keyword.KW_super.toString()) || GosuClass.isObjectMethod(md), Res.MSG_ABSTRACT_METHOD_CANNOT_BE_ACCESSED_DIRECTLY, strMemberName);
            e.setMethodDescriptor(bExpansion ? new ArrayExpansionMethodInfo(md) : md);
            e.setMemberAccessKind(kind);
            this.verifyCase(e, strMemberName, md.getDisplayName(), state, Res.MSG_FUNCTION_CASE_MISMATCH, false);
            this.verifyArgCount((ParsedElement)e, 0, funcType);
            this.verifySuperAccess(rootExpression, e, (IAttributedFeatureInfo)funcType.getMethodInfo(), strMemberName);
            e.setArgs(null);
        }
        e.setStartOffset(iTokenStart);
        if (md != null && md.isDeprecated()) {
            e.addParseWarning((IParseIssue)new ParseWarningForDeprecatedMember(state.cloneWithNewTokenStartAndTokenEnd(iTokenStart, md.getDisplayName().length()), TypeInfoUtil.getMethodSignature(md), e.getRootType().getName()));
        }
        if (this.isParsingAbstractConstructor()) {
            this.handleAbstractCtor(iTokenStart, strMemberName, e, state);
        }
        this.verifyNotCallingOverridableFunctionFromCtor(e);
        this.pushExpression(e);
    }

    private void parsePropertyMember(Expression rootExpression, MemberAccessKind kind, int iTokenStart, String strMemberName, LazyLightweightParserState state, boolean bParseTypeLiteralOnly, boolean createSynthesizedProperty, IType rootType, boolean bExpansion) {
        IPropertyInfo pi = null;
        MemberAccess ma = bExpansion ? new MemberExpansionAccess() : (createSynthesizedProperty ? new SynthesizedMemberAccess() : new MemberAccess());
        ma.setRootExpression(rootExpression);
        ma.setMemberAccessKind(kind);
        ErrorType memberType = null;
        try {
            TypeLiteral tl;
            String[] T;
            Identifier identifier;
            INamespaceType namespaceType;
            if (rootType instanceof IFunctionType && rootExpression instanceof Identifier && (namespaceType = this.resolveNamespace((identifier = (Identifier)rootExpression).getSymbol().getName())) != null) {
                Symbol sym = new Symbol(namespaceType.getRelativeName(), (IType)namespaceType, null);
                identifier.setSymbol((ISymbol)sym, this.getSymbolTable());
                identifier.setType((IType)namespaceType);
                rootType = namespaceType;
            }
            if (rootType instanceof INamespaceType) {
                String strType;
                if (!strMemberName.equals("*") && (memberType = TypeSystem.getNamespace((String)(strType = rootType.getName() + '.' + strMemberName))) == null) {
                    memberType = this.resolveTypeName(strType, true);
                    if (memberType == null) {
                        memberType = this.resolveNamespace(strType);
                    } else if (memberType != null) {
                        T = new String[]{strType};
                        tl = this.resolveTypeLiteral(T);
                        this.resolveArrayOrParameterizationPartOfTypeLiteral(T, bParseTypeLiteralOnly, tl);
                        tl.setPackageExpression(rootExpression);
                        return;
                    }
                }
            } else if (rootExpression instanceof TypeLiteral) {
                IType typeLiteralType = ((MetaType)rootType).getType();
                if (typeLiteralType instanceof IHasInnerClass) {
                    if ((memberType = this.getInnerClass(strMemberName, (IType)memberType, (IHasInnerClass)typeLiteralType)) != null && !this.shouldParseMemberInstead(strMemberName, rootType, (IType)memberType)) {
                        T = new String[]{memberType.getName()};
                        tl = this.resolveTypeLiteral(T);
                        this.resolveArrayOrParameterizationPartOfTypeLiteral(T, bParseTypeLiteralOnly, tl);
                        this.verifyTypeAccessible(tl, (IType)memberType);
                        tl.setPackageExpression(rootExpression);
                        return;
                    }
                } else if (typeLiteralType instanceof ErrorType) {
                    memberType = ErrorType.getInstance();
                }
            }
            if (memberType == null) {
                if (bParseTypeLiteralOnly && !(rootType instanceof ErrorType)) {
                    if (rootType instanceof INamespaceType) {
                        this.verify((ParsedElement)ma, false, Res.MSG_NO_TYPE_ON_NAMESPACE, strMemberName, rootType == null ? "<no type specified>" : rootType.getName());
                    } else {
                        IType errRootType = rootType instanceof IMetaType ? ((IMetaType)rootType).getType() : rootType;
                        this.addError(ma, Res.MSG_INVALID_INNER_TYPE, strMemberName, TypeLord.getPureGenericType(errRootType).getRelativeName());
                    }
                    memberType = ErrorType.getInstance();
                } else {
                    pi = BeanAccess.getPropertyInfo(rootType, strMemberName, null, this, this.getVisibilityConstraint());
                    Object object = memberType = bExpansion ? new ArrayExpansionPropertyInfo(pi).getFeatureType() : pi.getFeatureType();
                    if (pi != null) {
                        this.verifyCase(ma, strMemberName, pi.getName(), state, Res.MSG_PROPERTY_CASE_MISMATCH, false);
                    }
                    if (pi.isStatic() && !JavaTypes.ITYPE().isAssignableFrom(rootType)) {
                        IType intrinsicType = rootExpression.getType();
                        if (rootExpression instanceof Identifier && intrinsicType.getRelativeName().equals(((Identifier)rootExpression).getSymbol().getName())) {
                            this.warn((ParsedElement)ma, false, Res.MSG_NON_STATIC_ACCESS_WITH_IDENTIFIER_OF_STATIC_MEMBER, pi.getName(), intrinsicType.getName(), ((Identifier)rootExpression).getSymbol().getName(), intrinsicType.getName());
                        } else {
                            this.warn((ParsedElement)ma, false, Res.MSG_NON_STATIC_ACCESS_OF_STATIC_MEMBER, pi.getName(), intrinsicType.getName());
                        }
                    }
                }
            }
        }
        catch (ParseException e1) {
            Identifier identifier;
            INamespaceType namespaceType;
            if (rootExpression instanceof Identifier && !(rootType instanceof INamespaceType) && (namespaceType = this.resolveNamespace((identifier = (Identifier)rootExpression).getSymbol().getName().toLowerCase())) != null) {
                ISymbol oldSymbol = identifier.getSymbol();
                Symbol sym = new Symbol(namespaceType.getRelativeName(), (IType)namespaceType, null);
                identifier.setSymbol((ISymbol)sym, this.getSymbolTable());
                identifier.setType((IType)namespaceType);
                this.parseMemberAccess(rootExpression, kind, iTokenStart, strMemberName, state, bParseTypeLiteralOnly);
                Expression namespaceExpr = this.peekExpression();
                if (namespaceExpr.hasParseExceptions()) {
                    ((Identifier)rootExpression).setSymbol(oldSymbol, this.getSymbolTable());
                    rootExpression.setType(oldSymbol.getType());
                } else {
                    return;
                }
            }
            if (rootType instanceof INamespaceType) {
                this.verify((ParsedElement)ma, false, Res.MSG_NO_TYPE_ON_NAMESPACE, strMemberName, rootType == null ? "<no type specified>" : rootType.getName());
            } else {
                ma.addParseException((IParseIssue)e1);
            }
            memberType = ErrorType.getInstance();
        }
        ma.setType((IType)memberType);
        ma.setMemberName(strMemberName);
        ma.setStartOffset(iTokenStart);
        if (pi != null && pi.isDeprecated()) {
            ma.addParseWarning((IParseIssue)new ParseWarningForDeprecatedMember(state.cloneWithNewTokenStartAndTokenEnd(iTokenStart, pi.getName().length()), pi.getName(), ma.getRootType().getName()));
        }
        if (pi != null) {
            this.verify((ParsedElement)ma, !pi.isAbstract() || !(rootExpression instanceof Identifier) || !((Identifier)rootExpression).getSymbol().getName().equals(Keyword.KW_super.toString()), Res.MSG_ABSTRACT_METHOD_CANNOT_BE_ACCESSED_DIRECTLY, strMemberName);
        }
        this.verifySuperAccess(rootExpression, ma, (IAttributedFeatureInfo)pi, strMemberName);
        this.pushExpression(ma);
    }

    private void verifySuperAccess(Expression rootExpression, Expression memberExpr, IAttributedFeatureInfo feature, String strMemberName) {
        if (feature == null) {
            return;
        }
        this.verify((ParsedElement)memberExpr, !(rootExpression instanceof SuperAccess) || !feature.isAbstract(), Res.MSG_ABSTRACT_METHOD_CANNOT_BE_ACCESSED_DIRECTLY, strMemberName);
    }

    private boolean shouldParseMemberInstead(String strMemberName, IType rootType, IType memberType) {
        IType ctxType = this.getOwner().getContextType().getType();
        if (!(ctxType instanceof IMetaType) && memberType != null) {
            try {
                BeanAccess.getPropertyInfo(rootType, strMemberName, null, this, this.getVisibilityConstraint());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isEndOfArgExpression() {
        int mark = this._tokenizer.mark();
        try {
            boolean bl = this.match(null, 41) && this.isEndOfExpression();
            return bl;
        }
        finally {
            this._tokenizer.restoreToMark(mark);
        }
    }

    private boolean isParenthesisTerminalExpression() {
        return this.isParenthesisTerminalExpression(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isParenthesisTerminalExpression(boolean bMatchOpeningParen) {
        int mark = this._tokenizer.mark();
        try {
            if (bMatchOpeningParen) {
                boolean b = this.match(null, 40);
                assert (b);
            }
            this.eatBlock('(', ')', false);
            boolean bl = this.isEndOfExpression();
            return bl;
        }
        finally {
            this._tokenizer.restoreToMark(mark);
        }
    }

    private boolean isEndOfExpression() {
        return !this.match(null, null, 46, true) && !this.match(null, "?.", -6, true) && !this.match(null, "*.", -6, true);
    }

    private IType getInnerClass(String strMemberName, IType memberType, IHasInnerClass typeLiteralType) {
        try {
            memberType = typeLiteralType.getInnerClass((CharSequence)strMemberName);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return memberType;
    }

    private IFunctionType maybeParameterizeOnCtxType(IFunctionType funcType) {
        if (funcType.isGenericType()) {
            funcType = funcType.inferParameterizedTypeFromArgTypesAndContextType(IType.EMPTY_ARRAY, this.getContextType().getType());
        }
        return funcType;
    }

    private List<IFunctionType> getPreliminaryFunctionTypes(String strMemberName, BeanMethodCallExpression e, IType rootType, IType[] typeParameters) {
        ArrayList<IFunctionType> listFunctionTypes = new ArrayList<IFunctionType>(8);
        try {
            if (!(rootType instanceof ErrorType)) {
                this.getFunctionType(rootType, strMemberName, null, listFunctionTypes, this, true);
            }
        }
        catch (ParseException pe) {
            e.addParseException((IParseIssue)pe);
        }
        if (typeParameters != null) {
            listFunctionTypes = this.parameterizeFunctionTypes(e, typeParameters, listFunctionTypes);
        }
        return listFunctionTypes;
    }

    private boolean isBlockInvoke(Expression rootExpression, String strMemberName, IType rootType) {
        IPropertyInfo pi;
        IType typeLiteralType;
        if (rootExpression instanceof TypeLiteral && (typeLiteralType = ((MetaType)rootType).getType()) instanceof IHasInnerClass && ((IHasInnerClass)typeLiteralType).getInnerClass((CharSequence)strMemberName) != null) {
            return false;
        }
        if (!(this.isErrorType(rootType) || rootType instanceof INamespaceType || rootType instanceof IFunctionType || (pi = BeanAccess.getPropertyInfo_NoException(rootType, strMemberName, null, this, this.getVisibilityConstraint())) == null)) {
            return pi.getFeatureType() instanceof IBlockType;
        }
        return false;
    }

    private boolean isErrorType(IType rootType) {
        return rootType instanceof IErrorType || rootType instanceof IMetaType && ((IMetaType)rootType).getType() instanceof IErrorType;
    }

    private ArrayList<IFunctionType> parameterizeFunctionTypes(Expression expression, IType[] typeParameters, List<IFunctionType> listFunctionTypes) {
        ArrayList<IFunctionType> parameterizedFunctionTypes = new ArrayList<IFunctionType>(8);
        for (IFunctionType funcType : listFunctionTypes) {
            IFunctionType parameterizedFuncType;
            if (!funcType.isGenericType() || !this.verifyCanParameterizeType(expression, (IType)funcType, typeParameters) || !this.verify((ParsedElement)expression, (parameterizedFuncType = (IFunctionType)funcType.getParameterizedType(typeParameters)) != null, Res.MSG_COULD_NOT_PARAMETERIZE, new String[0]) || parameterizedFuncType == null) continue;
            parameterizedFunctionTypes.add(parameterizedFuncType);
        }
        return parameterizedFunctionTypes;
    }

    private void handleAbstractCtor(final int iTokenStart, final String strMemberName, BeanMethodCallExpression e, final IParserState state) {
        IMethodInfo methodInfo = e.getMethodDescriptor();
        if (methodInfo instanceof GosuMethodInfo && methodInfo.isAbstract()) {
            e.addParseException((IParseIssue)new ParseException(new IParserState(){

                public int getLineNumber() {
                    return state.getLineNumber();
                }

                public int getTokenColumn() {
                    return state.getTokenColumn();
                }

                public String getSource() {
                    return state.getSource();
                }

                public int getTokenStart() {
                    return iTokenStart;
                }

                public int getTokenEnd() {
                    return iTokenStart + strMemberName.length();
                }

                public int getLineOffset() {
                    return state.getLineOffset();
                }

                public IParserState cloneWithNewTokenStartAndTokenEnd(int newTokenStart, int newLength) {
                    return null;
                }
            }, Res.MSG_NO_ABSTRACT_METHOD_CALL_IN_CONSTR, new Object[]{methodInfo.getDisplayName()}));
        }
    }

    private boolean verifyCanParameterizeType(ParsedElement elem, IType type, IType[] typeParam) {
        if (!this.verify(elem, type.isGenericType(), Res.MSG_CANNOT_PARAMETERIZE_NONGENERIC, new String[0])) {
            return false;
        }
        ICompilableTypeInternal gsClass = this.getGosuClass();
        if (gsClass instanceof IGosuClass && !((IGosuClass)gsClass).isHeaderCompiled()) {
            return true;
        }
        IGenericTypeVariable[] typeVars = type.getGenericTypeVariables();
        if (this.verify(elem, typeParam != null && typeParam.length == typeVars.length, Res.MSG_WRONG_NUM_OF_ARGS, "")) {
            assert (typeParam != null);
            boolean bRet = true;
            TypeVarToTypeMap typeVarToTypeMap = new TypeVarToTypeMap();
            for (int i = 0; i < typeVars.length; ++i) {
                if (typeVars[i].getTypeVariableDefinition() != null) {
                    typeVarToTypeMap.put(typeVars[i].getTypeVariableDefinition().getType(), typeParam[i]);
                }
                IType boundingType = typeVars[i].getBoundingType();
                boundingType = TypeLord.getActualType(boundingType, typeVarToTypeMap, true);
                bRet = bRet && this.verify(elem, this.isTypeParamHeaderCompiling(typeParam[i]) || this.isErrorType(typeParam[i]) || typeVars[i].getTypeVariableDefinition() != null && typeVars[i].getTypeVariableDefinition().getType().isAssignableFrom(typeParam[i]) || boundingType.isAssignableFrom(typeParam[i]) || boundingType instanceof IGosuClass && ((IGosuClass)boundingType).isStructure() && StandardCoercionManager.isStructurallyAssignable((IType)TypeLord.getPureGenericType(boundingType), (IType)typeParam[i]), Res.MSG_TYPE_PARAM_NOT_ASSIGNABLE_TO, typeParam[i], boundingType);
            }
            return bRet;
        }
        return false;
    }

    private boolean isTypeParamHeaderCompiling(IType typeParam) {
        return typeParam instanceof IGosuClass && ((IGosuClass)typeParam).isCompilingHeader() || typeParam instanceof TypeVariableType && this.isTypeParamHeaderCompiling(((TypeVariableType)typeParam).getBoundingType()) || typeParam instanceof TypeVariableType && ((TypeVariableType)typeParam).getBoundingType() == PENDING_BOUNDING_TYPE;
    }

    private IType[] parseFunctionParameterization(Expression e) {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        if (this.match(null, "<", -6)) {
            List<TypeLiteral> paramTypes = this.parseTypeParameters(null);
            this.verify((ParsedElement)e, this.match(null, ">", -6), Res.MSG_EXPECTING_CLOSING_ANGLE_BRACKET_FOR_TYPE, new String[0]);
            if (paramTypes.isEmpty()) {
                return null;
            }
            this.makeTypeParameterListClause(iOffset, iLineNum, iColumn, paramTypes);
            IType[] types = new IType[paramTypes.size()];
            for (int i = 0; i < paramTypes.size(); ++i) {
                TypeLiteral typeLiteral = paramTypes.get(i);
                types[i] = typeLiteral.getType().getType();
            }
            return types;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodScore parseArgumentList2(ParsedElement element, List<? extends IInvocableType> listFunctionTypes, IType[] typeParams, boolean bVerifyArgs, boolean bNoArgsProvided) {
        MethodScore parserStates;
        boolean bShouldScoreMethods = (listFunctionTypes = this.maybeAvoidNestedMethodScoring(listFunctionTypes)).size() > 1;
        List<MethodScore> scoredMethods = new ArrayList<MethodScore>();
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this._tokenizer.getTokenColumn();
        listFunctionTypes = this.maybeRemoveNonGenericMethods(listFunctionTypes, typeParams);
        TypeVarToTypeMap inferenceMap = new TypeVarToTypeMap();
        List<Integer> namedArgOrder = null;
        HashSet<String> namedArgs = new HashSet<String>();
        int mark = this.getTokenizer().mark();
        int iLocationsCount = this._locations.size();
        MethodScore score = null;
        ArrayList<Expression> argExpressions = null;
        for (int i = 0; i < listFunctionTypes.size() || i == 0 && listFunctionTypes.isEmpty(); ++i) {
            int iArgs = 0;
            argExpressions = new ArrayList<Expression>(4);
            parserStates = new ArrayList(4);
            IInvocableType funcType = listFunctionTypes.isEmpty() ? null : listFunctionTypes.get(i);
            this.maybeInferFunctionTypeVarsFromReturnType(funcType, inferenceMap);
            this.pushTypeVariableTypesToInfer(funcType);
            try {
                if (!bNoArgsProvided) {
                    if (score != null) {
                        this.backtrackArgParsing(mark, iLocationsCount, score.getArguments());
                    }
                    do {
                        parserStates.add(this.makeLightweightParserState());
                        int iArgPos = this.parseArgExpression(funcType, iArgs, (List<Expression>)argExpressions, inferenceMap, (List<LightweightParserState>)parserStates, (Set<String>)namedArgs, bShouldScoreMethods || this.getContextType().isMethodScoring());
                        namedArgOrder = this.assignArgExprPosition(listFunctionTypes, iArgs, namedArgOrder, iArgPos);
                        ++iArgs;
                    } while (this.match(null, 44));
                }
                this.addMisingArgsWithDefaultValues(element, funcType, (List<Expression>)argExpressions, (List<LightweightParserState>)parserStates, bShouldScoreMethods);
                if (!bVerifyArgs) {
                    score = new MethodScore();
                    score.setValid(false);
                    score.setArguments(argExpressions);
                    score.setNamedArgOrder(namedArgOrder);
                    if (i == listFunctionTypes.size() - 1) {
                        this.maybeReassignOffsetForArgumentListClause(iArgs, argExpressions, iOffset, iLineNum, iColumn);
                    }
                    MethodScore methodScore = score;
                    return methodScore;
                }
                if (this.isDynamicMethod(listFunctionTypes)) {
                    if (i == listFunctionTypes.size() - 1) {
                        this.maybeReassignOffsetForArgumentListClause(iArgs, argExpressions, iOffset, iLineNum, iColumn);
                    }
                    MethodScore methodScore = this.makeDynamicMethodScore(listFunctionTypes, argExpressions);
                    return methodScore;
                }
                score = this.scoreMethod(funcType, listFunctionTypes, argExpressions, !bShouldScoreMethods, !this.hasContextSensitiveExpression(argExpressions));
            }
            finally {
                if (funcType != null) {
                    this.popInferringFunctionTypeVariableTypes();
                }
            }
            score.setArguments(argExpressions);
            score.setParserStates((List)parserStates);
            scoredMethods.add(score);
            if (score.getScore() != 0L || this.hasContextSensitiveExpression(argExpressions)) continue;
            if (scoredMethods.size() <= 1) break;
            scoredMethods.clear();
            scoredMethods.add(score);
            break;
        }
        if (scoredMethods.size() > 1) {
            Collections.sort(scoredMethods);
        }
        if (scoredMethods.size() > 1 && (scoredMethods = this.factorInParseErrors(scoredMethods)).size() > 1) {
            MethodScore score0 = scoredMethods.get(0);
            MethodScore score1 = scoredMethods.get(1);
            if (score0.getScore() == score1.getScore() && score0.matchesArgSize()) {
                this.addError(element, Res.MSG_AMBIGUOUS_METHOD_INVOCATION);
                score0.setValid(false);
                return score0;
            }
        }
        if (scoredMethods.size() > 0) {
            MethodScore bestScore = scoredMethods.get(0);
            if (listFunctionTypes.isEmpty()) {
                bestScore.setValid(false);
                return bestScore;
            }
            IInvocableType rawFunctionType = bestScore.getRawFunctionType();
            this.pushTypeVariableTypesToInfer(rawFunctionType);
            try {
                if (bShouldScoreMethods) {
                    this.backtrackArgParsing(mark, iLocationsCount, argExpressions);
                    MethodScorer.instance().putCachedMethodScore(bestScore);
                    parserStates = this.parseArgumentList2(element, Arrays.asList(bestScore.getRawFunctionType()), typeParams, bVerifyArgs, bNoArgsProvided);
                    return parserStates;
                }
                this.maybeReassignOffsetForArgumentListClause(argExpressions.size(), argExpressions, iOffset, iLineNum, iColumn);
                IInvocableType inferredFunctionType = this.inferFunctionType(rawFunctionType, bestScore.getArguments(), this.isEndOfArgExpression(), inferenceMap);
                if (!this.getContextType().isMethodScoring()) {
                    this.verifyArgTypes(inferredFunctionType.getParameterTypes(), bestScore.getArguments(), bestScore.getParserStates());
                    if (bestScore.isValid()) {
                        inferredFunctionType = this.maybeBoundFunctionTypeVars(inferredFunctionType, inferenceMap);
                        this.handleImplicitCoercionsInArgs(inferredFunctionType.getParameterTypes(), rawFunctionType.getParameterTypes(), bestScore.getArguments());
                    }
                }
                bestScore.setArguments(bestScore.getArguments());
                bestScore.setInferredFunctionType(inferredFunctionType);
                bestScore.setNamedArgOrder(namedArgOrder);
                MethodScore methodScore = bestScore;
                return methodScore;
            }
            finally {
                this.popInferringFunctionTypeVariableTypes();
            }
        }
        MethodScore errScore = new MethodScore();
        errScore.setValid(false);
        errScore.setArguments(Collections.emptyList());
        return errScore;
    }

    private void maybeInferFunctionTypeVarsFromReturnType(IInvocableType invType, TypeVarToTypeMap inferenceMap) {
        if (!(invType instanceof IFunctionType)) {
            return;
        }
        IFunctionType funcType = (IFunctionType)invType;
        if (funcType.isGenericType() && TypeLord.hasTypeVariable(funcType.getReturnType()) && !this.getContextType().isMethodScoring() && this.getContextType().getType() != null && this.getContextType() != ContextType.EMPTY && (this.getContextType().getUnboundType() == null || !this.boundCtxType(this.getContextType().getUnboundType()).equals(this.getContextType().getType())) && this.isParenthesisTerminalExpression()) {
            TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType_Reverse(funcType.getReturnType(), this.getContextType().getType(), inferenceMap);
        }
    }

    private List<MethodScore> factorInParseErrors(List<MethodScore> scoredMethods) {
        ArrayList<MethodScore> factored = new ArrayList<MethodScore>(scoredMethods.size());
        ArrayList<MethodScore> noErrors = new ArrayList<MethodScore>(scoredMethods.size());
        long bestScore = -1L;
        for (MethodScore score : scoredMethods) {
            boolean bErrors = false;
            for (IExpression arg : score.getArguments()) {
                if (!arg.hasParseExceptions()) continue;
                score.incScore(1);
                bErrors = true;
            }
            if (!bErrors) {
                noErrors.add(score);
            }
            bestScore = bestScore >= 0L ? Math.min(bestScore, score.getScore()) : score.getScore();
        }
        if (noErrors.size() > 0) {
            return noErrors;
        }
        for (MethodScore score : scoredMethods) {
            if (score.getScore() != bestScore) continue;
            factored.add(score);
        }
        return factored;
    }

    private boolean hasContextSensitiveExpression(List<Expression> argExpressions) {
        for (Expression e : argExpressions) {
            if (!(e instanceof IInferredNewExpression) && !(e instanceof UnqualifiedEnumMemberAccess) && !this.isGenericMethodCall(e) && (!(e instanceof Identifier) || !e.hasParseExceptions())) continue;
            return true;
        }
        return false;
    }

    private boolean isGenericMethodCall(Expression e) {
        if (e instanceof MethodCallExpression) {
            IFunctionType functionType = ((MethodCallExpression)e).getFunctionType();
            return functionType != null && (functionType.isGenericType() || functionType.isParameterizedType());
        }
        return false;
    }

    private List<? extends IInvocableType> maybeAvoidNestedMethodScoring(List<? extends IInvocableType> listFunctionTypes) {
        if (listFunctionTypes.size() < 2) {
            return listFunctionTypes;
        }
        if (!this.getContextType().isMethodScoring()) {
            return listFunctionTypes;
        }
        IType retType = null;
        for (IInvocableType iInvocableType : listFunctionTypes) {
            if (!(iInvocableType instanceof IFunctionType)) {
                return listFunctionTypes;
            }
            IType csr = ((IFunctionType)iInvocableType).getReturnType();
            if (retType != null && csr != retType) {
                return listFunctionTypes;
            }
            retType = csr;
        }
        return Collections.singletonList(listFunctionTypes.get(0));
    }

    private void backtrackArgParsing(int mark, int iLocationsCount, List<Expression> argExpressions) {
        for (int i = argExpressions.size() - 1; i >= 0; --i) {
            this.backtrack(mark, iLocationsCount, argExpressions.get(i));
        }
    }

    private List<? extends IInvocableType> maybeRemoveNonGenericMethods(List<? extends IInvocableType> listFunctionTypes, IType[] typeParams) {
        if (typeParams != null && typeParams.length > 0) {
            ArrayList<? extends IInvocableType> genericFunctions = new ArrayList<IInvocableType>();
            for (IInvocableType iInvocableType : listFunctionTypes) {
                if (!iInvocableType.isGenericType()) continue;
                genericFunctions.add((IInvocableType)iInvocableType);
            }
            if (!genericFunctions.isEmpty()) {
                listFunctionTypes = genericFunctions;
            }
        }
        return listFunctionTypes;
    }

    private void maybeReassignOffsetForArgumentListClause(int iArgs, List<Expression> argExpressions, int iOffset, int iLineNum, int iColumn) {
        boolean noLocations = true;
        if (iArgs > 0) {
            for (Expression argExpr : argExpressions) {
                if (argExpr.getLocation() == null) continue;
                noLocations = false;
                int iExpressionOffset = argExpr.getLocation().getOffset();
                if (iExpressionOffset >= iOffset) continue;
                iOffset = iExpressionOffset;
                iLineNum = argExpr.getLocation().getLineNum();
                iColumn = argExpr.getLocation().getColumn();
            }
            if (!noLocations) {
                ArgumentListClause e = new ArgumentListClause();
                this.pushExpression(e);
                this.setLocation(iOffset, iLineNum, iColumn, true);
                this.popExpression();
            }
        }
    }

    private IInvocableType maybeBoundFunctionTypeVars(IInvocableType inferredFunctionType, TypeVarToTypeMap inferenceMap) {
        ArrayList<IType> types = new ArrayList<IType>();
        for (IType typeVarType : this.getCurrentlyInferringFunctionTypeVars()) {
            IType encType;
            if (inferenceMap.get((ITypeVariableType)typeVarType) != null || (encType = TypeLord.getPureGenericType(typeVarType.getEnclosingType())) == null || !TypeLord.getPureGenericType(inferredFunctionType).isAssignableFrom(typeVarType.getEnclosingType())) continue;
            types.add(typeVarType);
        }
        return (IInvocableType)TypeLord.boundTypes((IType)inferredFunctionType, types);
    }

    private List<Integer> assignArgExprPosition(List<? extends IInvocableType> listFunctionTypes, int iArgs, List<Integer> namedArgOrder, int iArgPos) {
        if ((namedArgOrder != null || iArgPos != iArgs) && listFunctionTypes.size() > 0) {
            if (namedArgOrder == null) {
                int iSize = listFunctionTypes.get(0).getParameterTypes().length;
                namedArgOrder = new ArrayList<Integer>(iSize);
                for (int i = 0; i < iSize; ++i) {
                    namedArgOrder.add(i);
                }
            }
            namedArgOrder.remove((Object)iArgPos);
            if (namedArgOrder.size() >= iArgs) {
                namedArgOrder.add(iArgs, iArgPos);
            } else {
                namedArgOrder.add(iArgPos);
            }
        }
        return namedArgOrder;
    }

    void addMisingArgsWithDefaultValues(ParsedElement element, IInvocableType funcType, List<Expression> argExpressions, List<LightweightParserState> parserStates, boolean bShouldScoreMethods) {
        block4: {
            if (funcType == null || !funcType.hasOptionalParams()) break block4;
            for (int i = argExpressions.size(); i < funcType.getParameterTypes().length; ++i) {
                if (parserStates != null) {
                    parserStates.add(this.makeLightweightParserState());
                }
                argExpressions.add(i, this.getDefaultValueOrPlaceHolderForParam(i, funcType));
            }
            if (!bShouldScoreMethods) {
                for (Expression argExpr : argExpressions) {
                    if (!this.verify(element, argExpr != DefaultParamValueLiteral.instance(), Res.MSG_MISSING_REQUIRED_ARGUMENTS, new String[0])) break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int parseArgExpression(IInvocableType funcType, int iArgs, List<Expression> argExpressions, TypeVarToTypeMap inferenceMap, List<LightweightParserState> parserStates, Set<String> namedArgs, boolean bMethodScoring) {
        this.pushTypeVariableTypesToInfer(funcType);
        try {
            IType boundCtxType;
            IType rawCtxType;
            boolean bError_AnonymousArgFollowsNamedArg = false;
            int iArgPos = iArgs;
            boolean bAlreadyDef = false;
            IType[] paramTypes = funcType == null ? IType.EMPTY_ARRAY : funcType.getParameterTypes();
            IBlockType retainTypeVarsCtxType = null;
            if (this.match(null, ":", -6, true)) {
                iArgPos = this.parseNamedParamExpression(funcType, bMethodScoring);
                if (iArgPos == -1) {
                    namedArgs.add("err");
                } else if (funcType != null) {
                    String[] parameterNames = funcType.getParameterNames();
                    bAlreadyDef = namedArgs.add(parameterNames[iArgPos]);
                }
                if (argExpressions.size() < iArgPos + 1) {
                    for (int i = argExpressions.size(); i < iArgPos; ++i) {
                        argExpressions.add(i, this.getDefaultValueOrPlaceHolderForParam(i, funcType));
                        parserStates.add(i, this.makeLightweightParserState());
                    }
                    assert (argExpressions.size() == iArgPos);
                }
            } else if (!namedArgs.isEmpty()) {
                bError_AnonymousArgFollowsNamedArg = true;
            }
            ErrorType ctxType = iArgPos < 0 ? ErrorType.getInstance() : (iArgPos < paramTypes.length ? paramTypes[iArgPos] : null);
            ctxType = ctxType == null ? this.useDynamicTypeIfDynamicRoot(funcType, (IType)ctxType) : ctxType;
            IType iType = rawCtxType = ctxType == null ? null : this.inferArgType((IType)ctxType, inferenceMap);
            if (ctxType == null) {
                boundCtxType = null;
            } else if (rawCtxType.isGenericType() && !rawCtxType.isParameterizedType()) {
                boundCtxType = TypeLord.getDefaultParameterizedType(rawCtxType);
            } else {
                boundCtxType = this.boundCtxType(rawCtxType);
                if (rawCtxType instanceof IBlockType) {
                    retainTypeVarsCtxType = (IBlockType)this.boundCtxType(rawCtxType, true);
                }
            }
            ContextType ctx = retainTypeVarsCtxType != null ? ContextType.makeBlockContexType((IType)ctxType, retainTypeVarsCtxType, bMethodScoring) : new ContextType(boundCtxType, (IType)ctxType, bMethodScoring);
            this.parseExpressionNoVerify(ctx);
            Expression expression = this.popExpression();
            this.verify((ParsedElement)expression, !bError_AnonymousArgFollowsNamedArg, Res.MSG_EXPECTING_NAMED_ARG, new String[0]);
            this.inferFunctionTypeVariables(rawCtxType, boundCtxType, expression.getType(), inferenceMap);
            if (retainTypeVarsCtxType != null) {
                IType actualType = TypeLord.getActualType(expression.getType(), inferenceMap, true);
                actualType = this.boundCtxType(actualType, false);
                expression.setType(actualType);
            }
            int n = iArgPos = iArgPos < 0 ? iArgs : iArgPos;
            if (iArgPos >= 0) {
                if (iArgPos == argExpressions.size()) {
                    argExpressions.add(iArgPos, expression);
                } else if (iArgPos >= 0 && iArgPos < argExpressions.size() && bAlreadyDef) {
                    Expression existingExpr = argExpressions.set(iArgPos, expression);
                    this.verify((ParsedElement)expression, existingExpr == DefaultParamValueLiteral.instance() || existingExpr instanceof DefaultArgLiteral || existingExpr instanceof NullExpression, Res.MSG_ARGUMENT_ALREADY_DEFINED, new String[0]);
                }
            }
            int n2 = iArgPos;
            return n2;
        }
        finally {
            if (funcType != null) {
                this.popInferringFunctionTypeVariableTypes();
            }
        }
    }

    private IType useDynamicTypeIfDynamicRoot(IInvocableType funcType, IType ctxType) {
        IMethodInfo mi;
        if (funcType instanceof FunctionType && ((FunctionType)funcType).getMethodInfo() != null && (mi = ((FunctionType)funcType).getMethodInfo()).getOwnersType().isDynamic()) {
            ctxType = ((FunctionType)funcType).getReturnType();
        }
        return ctxType;
    }

    private Expression getDefaultValueOrPlaceHolderForParam(int iParam, IInvocableType invType) {
        if (invType == null) {
            return DefaultParamValueLiteral.instance();
        }
        IExpression[] defValues = invType.getDefaultValueExpressions();
        if (defValues == null || defValues.length == 0) {
            return DefaultParamValueLiteral.instance();
        }
        IExpression defValue = defValues[iParam];
        if (defValue != null) {
            return new DefaultArgLiteral(invType.getParameterTypes()[iParam], defValue);
        }
        return DefaultParamValueLiteral.instance();
    }

    private int parseNamedParamExpression(IInvocableType invType, boolean bMethodScoring) {
        this.match(null, ":", -6);
        this.parseNamedParamIdentifier();
        Identifier identifier = (Identifier)this.popExpression();
        int[] iPos = new int[]{-1};
        IType type = this.getParamTypeFromParamName(invType, identifier.getSymbol().getName(), iPos);
        identifier.setType(type);
        this.verify((ParsedElement)identifier, !(type instanceof ErrorType), Res.MSG_PARAM_NOT_FOUND, new String[0]);
        this.verify((ParsedElement)identifier, this.match(null, "=", -6), Res.MSG_EXPECTING_EQUALS_ASSIGN, new String[0]);
        return iPos[0];
    }

    private IType getParamTypeFromParamName(IInvocableType invType, String strParam, int[] iPos) {
        if (invType == null) {
            return ErrorType.getInstance();
        }
        String[] names = invType.getParameterNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(strParam)) continue;
            iPos[0] = i;
            return invType.getParameterTypes()[i];
        }
        return ErrorType.getInstance();
    }

    private void parseNamedParamIdentifier() {
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this._tokenizer.getTokenColumn();
        Token t = new Token();
        Identifier expr = new Identifier();
        this.verify((ParsedElement)expr, this.match(t, -5) || this.match(t, -7), Res.MSG_EXPECTING_NAME_PARAM, new String[0]);
        expr.setSymbol((ISymbol)new TypedSymbol(t._strValue, null, null, null, SymbolType.NAMED_PARAMETER), null);
        this.pushExpression(expr);
        this.setLocation(iOffset, iLineNum, iColumn);
    }

    private boolean isDynamicMethod(List<? extends IInvocableType> listFunctionTypes) {
        IMethodInfo mi;
        if (listFunctionTypes == null || listFunctionTypes.isEmpty()) {
            return false;
        }
        IInvocableType invoType = listFunctionTypes.get(0);
        return invoType instanceof FunctionType && (mi = ((FunctionType)invoType).getMethodInfo()) != null && (mi.getOwnersType() instanceof IPlaceholder || mi instanceof DynamicMethodInfo);
    }

    private MethodScore makeDynamicMethodScore(List<? extends IInvocableType> listFunctionTypes, List<Expression> argExpressions) {
        MethodScore score = new MethodScore();
        score.setValid(true);
        score.setArguments(argExpressions);
        IMethodInfo mi = ((FunctionType)listFunctionTypes.get(0)).getMethodInfo();
        mi = ((ITypeInfo)mi.getContainer()).getMethod((CharSequence)mi.getName(), this.getTypes(argExpressions).toArray(new IType[argExpressions.size()]));
        score.setInferredFunctionType((IInvocableType)new FunctionType(mi));
        score.setRawFunctionType(score.getInferredFunctionType());
        score.setScore(1L);
        return score;
    }

    private MethodScore scoreMethod(IInvocableType funcType, List<? extends IInvocableType> listFunctionTypes, List<Expression> argExpressions, boolean bSimple, boolean bLookInCache) {
        ArrayList<IType> argTypes = new ArrayList<IType>(argExpressions.size());
        for (Expression argExpression : argExpressions) {
            argTypes.add(argExpression.getType());
        }
        return MethodScorer.instance().scoreMethod(funcType, listFunctionTypes, argTypes, this.getCurrentlyInferringFunctionTypeVars(), bSimple, bLookInCache);
    }

    private IType boundCtxType(IType ctxType) {
        return this.boundCtxType(ctxType, false);
    }

    private IType boundCtxType(IType ctxType, boolean bKeepTypeVars) {
        List<IType> inferringTypes = this.getCurrentlyInferringFunctionTypeVars();
        return TypeLord.boundTypes(ctxType, inferringTypes, bKeepTypeVars);
    }

    private void inferFunctionTypeVariables(IType rawContextType, IType boundContextType, IType expressionType, TypeVarToTypeMap inferenceMap) {
        if (rawContextType != null && boundContextType != null) {
            ICoercer iCoercer = CommonServices.getCoercionManager().resolveCoercerStatically(boundContextType, expressionType);
            if (iCoercer instanceof IResolvingCoercer) {
                IType resolvedType = ((IResolvingCoercer)iCoercer).resolveType(rawContextType, expressionType);
                TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(rawContextType, resolvedType, inferenceMap);
            } else {
                TypeLord.inferTypeVariableTypesFromGenParamTypeAndConcreteType(rawContextType, expressionType, inferenceMap);
            }
        }
    }

    private IType inferArgType(IType contextType, TypeVarToTypeMap inferenceMap) {
        TypeLord.addReferencedTypeVarsThatAreNotInMap(contextType, inferenceMap);
        return TypeLord.getActualType(contextType, inferenceMap, true);
    }

    private void handleImplicitCoercionsInArgs(IType[] argTypes, IType[] rawArgTypes, List<Expression> args) {
        for (int i = 0; i < argTypes.length && i < args.size(); ++i) {
            IType argType = argTypes[i];
            Expression expr = args.get(i);
            if (argType != rawArgTypes[i] && (argType instanceof IGosuArrayClass || argType instanceof TypeVariableArrayType) && !(rawArgTypes[i] instanceof IGosuArrayClass)) {
                argType = rawArgTypes[i];
            }
            if (expr instanceof DefaultParamValueLiteral) continue;
            args.set(i, this.possiblyWrapWithImplicitCoercion(expr, argType));
        }
    }

    private List<List<IType>> extractContextTypes(List<? extends IInvocableType> funcTypes) {
        if (funcTypes != null) {
            ArrayList<List<IType>> returnList = new ArrayList<List<IType>>();
            for (IInvocableType iInvocableType : funcTypes) {
                for (int i = 0; i < iInvocableType.getParameterTypes().length; ++i) {
                    List<IType> paramTypeList;
                    IType paramType = iInvocableType.getParameterTypes()[i];
                    if (i >= returnList.size()) {
                        returnList.add(new ArrayList());
                    }
                    if ((paramTypeList = returnList.get(i)).contains(paramType)) continue;
                    paramTypeList.add(paramType);
                }
            }
            return returnList;
        }
        return Collections.emptyList();
    }

    private void verifyArgTypes(IType[] argTypes, List<Expression> argExpressions, List<LightweightParserState> parserStates) {
        if (argTypes == null || argTypes.length == 0 || argExpressions == null || argExpressions.size() == 0) {
            return;
        }
        for (int i = 0; i < argTypes.length && i < argExpressions.size(); ++i) {
            IParseIssue pe;
            Expression e = argExpressions.get(i);
            LightweightParserState state = parserStates.get(i);
            this.verifyComparable(argTypes[i], e, false, true, state);
            if (argTypes[i] instanceof FunctionType && e.getType() instanceof FunctionType) {
                FunctionType expectedFunType = (FunctionType)argTypes[i];
                FunctionType foundFunType = (FunctionType)e.getType();
                if (expectedFunType.getReturnType() != GosuParserTypes.NULL_TYPE() && foundFunType.getReturnType() == GosuParserTypes.NULL_TYPE()) {
                    this.warn((ParsedElement)e, false, Res.MSG_VOID_RETURN_IN_CTX_EXPECTING_VALUE, new Object[0]);
                }
            }
            if (!e.hasParseExceptions() || (pe = e.getParseExceptions().get(0)).getExpectedType() != null) continue;
            pe.setExpectedType(argTypes[i]);
        }
    }

    void parseLiteral(Token token) {
        int iOffset = token.getTokenStart();
        int iLineNum = token.getLine();
        int iColumn = token.getTokenColumn();
        this._parseLiteral(token);
        this.setLocation(iOffset, iLineNum, iColumn);
    }

    void _parseLiteral(Token token) {
        if (!(this.parseNumberLiteral(token) || this.parseRelativeFeatureLiteral(token) || this.parseStringLiteral(token) || this.parseCharLiteral(token) || this.parseBooleanLiteral(token) || this.parseNullLiteral(token) || this.parseTypeLiteral(token))) {
            Expression expr = this.popExpression();
            this.getLocationsList().remove(expr.getLocation());
            NotAWordExpression notAWord = new NotAWordExpression();
            this.pushExpression(notAWord);
            this.verify((ParsedElement)notAWord, false, Res.MSG_SYNTAX_ERROR, new String[0]);
            Token T = this.getTokenizer().getPriorToken();
            this.setLocation(T.getTokenEnd(), T.getLine(), T.getTokenColumn(), true);
        }
    }

    private boolean parseRelativeFeatureLiteral(Token token) {
        if (this.getGosuClass() != null && -6 == token.getType() && "#".equals(token.getStringValue())) {
            TypeLiteral root = new TypeLiteral((IType)this.getGosuClass());
            this.pushExpression(root);
            if (this.parseFeatureLiteral(token, root)) {
                return true;
            }
            this.popExpression();
        }
        return false;
    }

    private boolean parseNumberLiteral(Token token) {
        return this.parseNumberLiteral(token, false);
    }

    private boolean atNumberLiteralStart() {
        return this.match(null, null, -9, true) || this.match(null, null, 46, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseNumberLiteral(Token token, boolean negated) {
        if (Keyword.KW_NaN == token.getKeyword()) {
            this.getTokenizer().nextToken();
            this.pushExpression(((NumericLiteral)NumericLiteral.NaN.get()).copy());
            return true;
        }
        if (Keyword.KW_Infinity == token.getKeyword()) {
            this.getTokenizer().nextToken();
            this.pushExpression(((NumericLiteral)NumericLiteral.INFINITY.get()).copy());
            return true;
        }
        int mark = this.getTokenizer().mark();
        Token T = new Token();
        if (this.match(T, -9)) {
            String strValue = (negated ? "-" : "") + T._strValue;
            if (this.getNumericTypeFrom(strValue) == null && this.match(null, 46)) {
                strValue = this.maybeStripTypeModifier(strValue, null);
                Token tmp = new Token();
                if (this.match(tmp, null, -9, true)) {
                    if (!this.isPrefixNumericLiteral(tmp._strValue)) {
                        this.match(T, -9);
                        strValue = strValue + '.';
                        strValue = strValue + T._strValue;
                    } else {
                        strValue = strValue + ".0";
                    }
                } else {
                    this.match(T, -9);
                    strValue = strValue + ".0";
                }
            }
            int lastPos = T.getTokenEnd();
            if (this.match(T, null, -5, true) && lastPos >= T.getTokenStart() && (T._strValue.charAt(0) == 'e' || T._strValue.charAt(0) == 'E')) {
                this.match(T, -5);
                if (T._strValue.length() == 1) {
                    strValue = strValue + "e";
                    if (this.match(T, "+", -6) || this.match(T, "-", -6)) {
                        strValue = strValue + T._strValue;
                    }
                    if (!this.match(T, -9)) {
                        this.getTokenizer().restoreToMark(mark);
                        return false;
                    }
                    strValue = strValue + T._strValue;
                } else {
                    strValue = strValue + T._strValue;
                }
                int end = strValue.length() - 1;
                char suffix = ' ';
                if (!Character.isDigit(strValue.charAt(end))) {
                    suffix = strValue.charAt(end);
                    strValue = strValue.substring(0, end);
                }
                try {
                    BigDecimal bigNum = new BigDecimal(strValue);
                    strValue = bigNum.toPlainString();
                    if (bigNum.scale() <= 0) {
                        strValue = strValue + ".0";
                    }
                }
                catch (NumberFormatException e) {
                    this.getTokenizer().restoreToMark(mark);
                    return false;
                }
                if (suffix != ' ') {
                    strValue = strValue + suffix;
                }
            }
            this.parseNumericValue(strValue);
            return true;
        }
        if (46 != token.getType()) return false;
        this.getTokenizer().nextToken();
        String strValue = (negated ? "-" : "") + ".";
        if (this.match(T, -9)) {
            strValue = strValue + T._strValue;
            this.parseNumericValue(strValue);
            return true;
        }
        this.pushErrorNumberLiteral(Res.MSG_EXPECTING_NUMBER_TO_FOLLOW_DECIMAL, new Object[0]);
        return true;
    }

    private void parseNumericValue(String strValue) {
        if (this.isPrefixNumericLiteral(strValue) && strValue.indexOf(46) != -1) {
            this.pushErrorNumberLiteral(Res.MSG_IMPROPER_VALUE_FOR_NUMERIC_TYPE, strValue, JavaTypes.pINT());
        } else {
            IType numericTypeFrom = this.getNumericTypeFrom(strValue);
            if (numericTypeFrom != null) {
                this.parseExplicitlyTypedNumericLiteral(strValue, numericTypeFrom);
            } else {
                NumericLiteral e;
                IType ctxType = this.getNumberTypeFromContextType(this.getContextType().isMethodScoring() ? null : this.getContextType().getType());
                if (strValue.indexOf(46) != -1) {
                    e = ctxType == JavaTypes.BIG_DECIMAL() ? new NumericLiteral(strValue, new BigDecimal(strValue), (IType)JavaTypes.BIG_DECIMAL()) : (ctxType == JavaTypes.pFLOAT() ? this.parseFloat(strValue) : (ctxType == JavaTypes.pDOUBLE() ? this.parseDouble(strValue) : this.parseDoubleOrBigDec(strValue)));
                } else if (ctxType == JavaTypes.BIG_INTEGER()) {
                    if (this.isPrefixNumericLiteral(strValue)) {
                        strValue = this.stripPrefix(strValue);
                    }
                    e = new NumericLiteral(strValue, new BigInteger(strValue), (IType)JavaTypes.BIG_INTEGER());
                } else {
                    try {
                        e = !strValue.startsWith("0") ? (ctxType == JavaTypes.pFLOAT() ? this.parseFloat(strValue) : (ctxType == JavaTypes.pDOUBLE() ? this.parseDouble(strValue) : this.parseIntOrLongOrBigInt(strValue))) : this.parseIntOrLongOrBigInt(strValue);
                    }
                    catch (NumberFormatException ex) {
                        this.pushErrorNumberLiteral(Res.MSG_IMPROPER_VALUE_FOR_NUMERIC_TYPE, strValue, JavaTypes.pINT());
                        return;
                    }
                }
                this.pushExpression(e);
            }
        }
    }

    private NumericLiteral parseIntOrLongOrBigInt(String strValue) {
        NumericLiteral e;
        int radix = 10;
        String strippedValue = strValue;
        if (this.isPrefixNumericLiteral(strValue)) {
            strippedValue = this.stripPrefix(strValue);
            if (this.isHexLiteral(strValue)) {
                radix = 16;
            } else if (this.isBinLiteral(strValue)) {
                radix = 2;
            }
        }
        try {
            e = new NumericLiteral(strValue, Integer.parseInt(strippedValue, radix), (IType)JavaTypes.pINT());
        }
        catch (NumberFormatException nfe) {
            try {
                e = new NumericLiteral(strValue, Long.parseLong(strippedValue, radix), (IType)JavaTypes.pLONG());
            }
            catch (NumberFormatException nfe2) {
                e = new NumericLiteral(strValue, new BigInteger(strippedValue, radix), (IType)JavaTypes.BIG_INTEGER());
            }
        }
        return e;
    }

    private String stripPrefix(String strValue) {
        String strippedValue = strValue.startsWith("-") ? "-" + strValue.substring(3) : strValue.substring(2);
        return strippedValue;
    }

    private NumericLiteral parseDoubleOrBigDec(String strValue) {
        double dValue = Double.parseDouble(strValue);
        if (dValue == Double.POSITIVE_INFINITY || dValue == Double.NEGATIVE_INFINITY) {
            return new NumericLiteral(strValue, new BigDecimal(strValue), (IType)JavaTypes.BIG_DECIMAL());
        }
        return new NumericLiteral(strValue, dValue, (IType)JavaTypes.pDOUBLE());
    }

    private NumericLiteral parseFloat(String strValue) {
        float fValue = Float.parseFloat(strValue);
        NumericLiteral floatLiteral = new NumericLiteral(strValue, Float.valueOf(fValue), (IType)JavaTypes.pFLOAT());
        this.verify((ParsedElement)floatLiteral, fValue != Float.POSITIVE_INFINITY && fValue != Float.NEGATIVE_INFINITY, Res.MSG_NUMBER_LITERAL_TOO_LARGE, new String[0]);
        return floatLiteral;
    }

    private NumericLiteral parseDouble(String strValue) {
        double dValue = Double.parseDouble(strValue);
        NumericLiteral doubleLiteral = new NumericLiteral(strValue, dValue, (IType)JavaTypes.pDOUBLE());
        this.verify((ParsedElement)doubleLiteral, dValue != Double.POSITIVE_INFINITY && dValue != Double.NEGATIVE_INFINITY, Res.MSG_NUMBER_LITERAL_TOO_LARGE, new String[0]);
        return doubleLiteral;
    }

    private void parseExplicitlyTypedNumericLiteral(String strValue, IType numericTypeFrom) {
        if (this.isPrefixNumericLiteral(strValue)) {
            this.parsePrefixNumericLiteral(strValue, numericTypeFrom);
        } else {
            this.parsePostfixNumericLiteral(strValue, numericTypeFrom, 10);
        }
    }

    private boolean isPrefixNumericLiteral(String strValue) {
        return !strValue.equalsIgnoreCase("0b") && !strValue.equalsIgnoreCase("0bi") && !strValue.equalsIgnoreCase("0bd") && !strValue.equalsIgnoreCase("-0b") && !strValue.equalsIgnoreCase("-0bi") && !strValue.equalsIgnoreCase("-0bd") && (strValue.startsWith("0x") || strValue.startsWith("0X") || strValue.startsWith("0b") || strValue.startsWith("0B") || strValue.startsWith("-0x") || strValue.startsWith("-0X") || strValue.startsWith("-0b") || strValue.startsWith("-0B"));
    }

    private void parsePrefixNumericLiteral(String strValue, IType numericTypeFrom) {
        int radix = 10;
        String strippedValue = this.stripPrefix(strValue);
        if (this.isHexLiteral(strValue)) {
            radix = 16;
        } else if (this.isBinLiteral(strValue)) {
            radix = 2;
        }
        this.parsePostfixNumericLiteral(strippedValue, numericTypeFrom, radix);
    }

    private boolean isHexLiteral(String num) {
        return (num = num.toLowerCase()).startsWith("0x") || num.startsWith("-0x");
    }

    private boolean isBinLiteral(String num) {
        boolean hasPrefix = (num = num.toLowerCase()).startsWith("0b") || num.startsWith("-0b");
        int b = num.indexOf("b") + 1;
        boolean hasDigit = b < num.length() && Character.isDigit(num.charAt(b));
        return hasPrefix && hasDigit;
    }

    private void parsePostfixNumericLiteral(String num, IType numericTypeFrom, int radix) {
        String strValue = this.maybeStripTypeModifier(num, numericTypeFrom);
        try {
            NumericLiteral e;
            if (JavaTypes.pBYTE().equals(numericTypeFrom)) {
                e = new NumericLiteral(strValue, Byte.parseByte(strValue, radix), (IType)JavaTypes.pBYTE());
            } else if (JavaTypes.pSHORT().equals(numericTypeFrom)) {
                e = new NumericLiteral(strValue, Short.parseShort(strValue, radix), (IType)JavaTypes.pSHORT());
            } else if (JavaTypes.pINT().equals(numericTypeFrom)) {
                e = new NumericLiteral(strValue, Integer.parseInt(strValue, radix), (IType)JavaTypes.pINT());
            } else if (JavaTypes.pLONG().equals(numericTypeFrom)) {
                e = new NumericLiteral(strValue, Long.parseLong(strValue, radix), (IType)JavaTypes.pLONG());
            } else if (JavaTypes.pFLOAT().equals(numericTypeFrom)) {
                float value = Float.parseFloat(strValue);
                e = new NumericLiteral(strValue, Float.valueOf(value), (IType)JavaTypes.pFLOAT());
                this.verify((ParsedElement)e, !Float.isInfinite(value), Res.MSG_NUMBER_LITERAL_TOO_LARGE, new String[0]);
            } else if (JavaTypes.pDOUBLE().equals(numericTypeFrom)) {
                double value = Double.parseDouble(strValue);
                e = new NumericLiteral(strValue, value, (IType)JavaTypes.pDOUBLE());
                this.verify((ParsedElement)e, !Double.isInfinite(value), Res.MSG_NUMBER_LITERAL_TOO_LARGE, new String[0]);
            } else if (JavaTypes.BIG_INTEGER().equals(numericTypeFrom)) {
                e = new NumericLiteral(strValue, new BigInteger(strValue, radix), (IType)JavaTypes.BIG_INTEGER());
            } else if (JavaTypes.BIG_DECIMAL().equals(numericTypeFrom)) {
                e = new NumericLiteral(strValue, new BigDecimal(strValue), (IType)JavaTypes.BIG_DECIMAL());
            } else {
                throw new IllegalStateException("Do not know how to parse a numeric type of value " + numericTypeFrom);
            }
            if (this.hasTypeModifier(num)) {
                e.setExplicitlyTyped(true);
            }
            this.pushExpression(e);
        }
        catch (NumberFormatException ex) {
            this.pushErrorNumberLiteral(Res.MSG_IMPROPER_VALUE_FOR_NUMERIC_TYPE, strValue, numericTypeFrom.getName());
        }
    }

    private String maybeStripTypeModifier(String strValue, IType numericTypeFrom) {
        if (this.hasTypeModifier(strValue)) {
            int modifierLen = JavaTypes.BIG_DECIMAL().equals(numericTypeFrom) || JavaTypes.BIG_INTEGER().equals(numericTypeFrom) ? 2 : 1;
            strValue = strValue.substring(0, strValue.length() - modifierLen);
        }
        return strValue;
    }

    private boolean hasTypeModifier(String strValue) {
        boolean hex = this.isHexLiteral(strValue);
        char ch = strValue.toLowerCase().charAt(strValue.length() - 1);
        if (hex && ch == 's' || ch == 'l') {
            return true;
        }
        return !hex && !Character.isDigit(ch);
    }

    private void pushErrorNumberLiteral(ResourceKey key, Object ... args) {
        NumericLiteral error = new NumericLiteral("0", 0, (IType)JavaTypes.pINT());
        this.addError(error, key, args);
        this.pushExpression(error);
    }

    private IType getNumericTypeFrom(String strValue) {
        boolean hex = this.isHexLiteral(strValue);
        boolean bin = this.isBinLiteral(strValue);
        if (!hex && (strValue.endsWith("b") || strValue.endsWith("B"))) {
            return JavaTypes.pBYTE();
        }
        if (strValue.endsWith("s") || strValue.endsWith("S")) {
            return JavaTypes.pSHORT();
        }
        if (strValue.endsWith("l") || strValue.endsWith("L")) {
            return JavaTypes.pLONG();
        }
        if (!hex && !bin && (strValue.endsWith("f") || strValue.endsWith("F"))) {
            return JavaTypes.pFLOAT();
        }
        if (!hex && (strValue.endsWith("bi") || strValue.endsWith("BI"))) {
            return JavaTypes.BIG_INTEGER();
        }
        if (!hex && !bin && (strValue.endsWith("bd") || strValue.endsWith("BD"))) {
            return JavaTypes.BIG_DECIMAL();
        }
        if (!hex && !bin && (strValue.endsWith("d") || strValue.endsWith("D"))) {
            return JavaTypes.pDOUBLE();
        }
        return null;
    }

    private boolean parseCharLiteral(Token token) {
        if (39 == token.getType()) {
            this.getTokenizer().nextToken();
            if (token._strValue.length() != 1) {
                this._parseStringLiteral(token._bUnterminated, token);
            } else {
                char c = token._strValue.charAt(0);
                IType ctxType = this.getContextType().getType();
                Literal e = !this.getContextType().isMethodScoring() && c >= '\u0000' && c <= '\u007f' && (ctxType == JavaTypes.pBYTE() || ctxType == JavaTypes.BYTE()) ? new NumericLiteral(token._strValue, (byte)c, ctxType) : new CharLiteral(c);
                this.verify((ParsedElement)e, token.getInvalidCharPos() < 0, Res.MSG_INVALID_CHAR_AT, token.getInvalidCharPos());
                this.verify((ParsedElement)e, !token._bUnterminated, Res.MSG_UNTERMINATED_STRING_LITERAL, new String[0]);
                this.pushExpression(e);
            }
            return true;
        }
        return false;
    }

    private boolean parseStringLiteralSeparately() {
        Token token = this.getTokenizer().getCurrentToken();
        int iOffset = token.getTokenStart();
        int iLineNum = token.getLine();
        int iColumn = token.getTokenColumn();
        if (this.parseStringLiteral(token)) {
            this.setLocation(iOffset, iLineNum, iColumn);
            return true;
        }
        return false;
    }

    private boolean parseStringLiteral(Token token) {
        if (34 == token.getType()) {
            this.getTokenizer().nextToken();
            this._parseStringLiteral(token._bUnterminated, token);
            return true;
        }
        return false;
    }

    private void _parseStringLiteral(boolean bUnterminatedLiteral, Token t) {
        Expression e;
        if (t._strValue.contains("<%") || t._strValue.contains("${")) {
            e = this.parseTemplatizedStringLiteral(t);
        } else {
            String strValue = t._strValue;
            if (strValue.length() > 0 && strValue.charAt(0) == '\uffe0') {
                strValue = strValue.substring(1).replace('\uffe1', '<').replace('\uffe2', '$');
            }
            e = new StringLiteral(strValue);
        }
        if (bUnterminatedLiteral) {
            e.addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_UNTERMINATED_STRING_LITERAL, new Object[0]));
        }
        this.verify((ParsedElement)e, t.getInvalidCharPos() < 0, Res.MSG_INVALID_CHAR_AT, t.getInvalidCharPos());
        this.pushExpression(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateStringLiteral parseTemplatizedStringLiteral(Token t) {
        TemplateGenerator template = TemplateGenerator.getTemplate(new StringReader(t._strValue));
        template.setContextInferenceManager(this._ctxInferenceMgr);
        template.setForStringLiteral(true);
        TemplateStringLiteral e = new TemplateStringLiteral(template);
        GosuParser parser = (GosuParser)GosuParserFactory.createParser((ISymbolTable)this._symTable, (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE);
        IScriptPartId scriptPart = this.getScriptPart();
        parser.pushScriptPart(scriptPart);
        try {
            block10: {
                parser.setEditorParser(this.isEditorParser());
                parser._ctxInferenceMgr = this._ctxInferenceMgr;
                template.setUseStudioEditorParser(this.isEditorParser());
                this.copyBlockStackTo(parser);
                try {
                    template.verify(parser, this._dfsDeclByName, this._typeUsesMap);
                }
                catch (ParseResultsException parseResultsException) {
                    // empty catch block
                }
                boolean hasIssues = false;
                for (IParseTree location : parser.getLocations()) {
                    ((ParseTree)location).adjustOffset(1, 0, 0);
                    for (IParseIssue parseIssue : location.getParsedElement().getParseIssues()) {
                        ((ParseIssue)parseIssue).setStateSource(this._tokenizer.getSource());
                        hasIssues = true;
                    }
                }
                this.setSubTree(parser.getLocations());
                try {
                    template.compile(this._scriptPartIdStack, this._symTable instanceof ThreadSafeSymbolTable ? this._symTable : this._symTable.copy(), this._dfsDeclByName, this._typeUsesMap, (Stack<BlockExpression>)this._blocks, this._ctxInferenceMgr);
                }
                catch (TemplateParseException exc) {
                    if (hasIssues || exc.getParseException() == null || this.getScriptPart().getContainingType() instanceof IGosuFragment) break block10;
                    List parseExceptions = exc.getParseException().getParseExceptions();
                    for (IParseIssue p : parseExceptions) {
                        e.addParseException(p);
                    }
                }
            }
            TemplateStringLiteral templateStringLiteral = e;
            return templateStringLiteral;
        }
        finally {
            parser.popScriptPart(scriptPart);
        }
    }

    public boolean parseTypeLiteral() {
        return this.parseTypeLiteral(this.getTokenizer().getCurrentToken(), false);
    }

    public boolean parseTypeLiteral(Token token) {
        return this.parseTypeLiteral(token, false);
    }

    boolean parseTypeLiteral(boolean bInterface) {
        return this.parseTypeLiteral(this.getTokenizer().getCurrentToken(), bInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean parseTypeLiteral(Token token, boolean bInterface) {
        boolean bNoContextType;
        boolean bl = bNoContextType = this.getContextType().getType() == null;
        if (bNoContextType) {
            this.pushInferredContextTypes(new ContextType((IType)MetaType.DEFAULT_TYPE_TYPE.get()));
        }
        try {
            int iOffset = token.getTokenStart();
            int iLineNum = token.getLine();
            int iColumn = token.getTokenColumn();
            boolean bSuccess = this._parseTypeLiteralWithAggregateSyntax(token, false, bInterface);
            if (bSuccess) {
                Expression e = this.peekExpression();
                if (e instanceof TypeLiteral) {
                    IType monitorLockType = GosuTypes.IMONITORLOCK();
                    this.verify((ParsedElement)e, monitorLockType == null || !monitorLockType.equals(((TypeLiteral)e).getType().getType()), Res.MSG_IMONITOR_LOCK_SHOULD_ONLY_BE_USED_WITHIN_USING_STMTS, new String[0]);
                }
                this.setLocation(iOffset, iLineNum, iColumn, true);
            }
            boolean bl2 = bSuccess;
            return bl2;
        }
        finally {
            if (bNoContextType) {
                this.popInferredContextTypes();
            }
        }
    }

    void parseTypeLiteralIgnoreArrayBrackets() {
        Token token = this.getTokenizer().getCurrentToken();
        int iOffset = token.getTokenStart();
        int iLineNum = token.getLine();
        int iColumn = token.getTokenColumn();
        if (this._parseTypeLiteralWithAggregateSyntax(token, true, false)) {
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    boolean _parseTypeLiteralWithAggregateSyntax(Token token, boolean bIgnoreArrayBrackets, boolean bInterface) {
        boolean bRet = this._parseTypeLiteral(token, bIgnoreArrayBrackets, bInterface);
        token = this.getTokenizer().getCurrentToken();
        if (-6 == token.getType() && "&".equals(token.getStringValue())) {
            this.parseAggregateTypeLiteral(bInterface);
        }
        return bRet;
    }

    boolean _parseTypeLiteral(Token token, boolean bIgnoreArrayBrackets, boolean bInterface) {
        int iOffset = token.getTokenStart();
        int iLineNum = token.getLine();
        int iColumn = token.getTokenColumn();
        if (-7 == token.getType() && Keyword.KW_block == token.getKeyword()) {
            this.getTokenizer().nextToken();
            this._parseBlockLiteral();
            this.setLocation(iOffset, iLineNum, iColumn, true);
        } else {
            if (!this.isWordOrValueKeyword(token) && !this.matchPrimitiveType(false)) {
                TypeLiteral typeLiteral = bInterface ? new InterfaceTypeLiteral((IType)ErrorType.getInstance()) : new TypeLiteral((IType)ErrorType.getInstance());
                this.verify((ParsedElement)typeLiteral, false, Res.MSG_EXPECTING_TYPE_NAME, new String[0]);
                this.pushExpression(typeLiteral);
                Token priorT = this.getTokenizer().getPriorToken();
                this.setLocation(priorT.getTokenEnd(), priorT.getLine(), priorT.getTokenColumn(), true, true);
                return false;
            }
            this.getTokenizer().nextToken();
            this.parseTypeLiteral(new String[]{token.getStringValue()}, bIgnoreArrayBrackets, bInterface, iOffset, iLineNum, iColumn);
        }
        return true;
    }

    private boolean matchPrimitiveType(boolean bSuperThis) {
        Token token = this.getTokenizer().getCurrentToken();
        if (token.getType() == -7) {
            boolean bMatch;
            boolean bl = bMatch = Keyword.KW_void == token.getKeyword() || Keyword.KW_boolean == token.getKeyword() || Keyword.KW_char == token.getKeyword() || Keyword.KW_byte == token.getKeyword() || Keyword.KW_short == token.getKeyword() || Keyword.KW_int == token.getKeyword() || Keyword.KW_long == token.getKeyword() || Keyword.KW_float == token.getKeyword() || Keyword.KW_double == token.getKeyword() || bSuperThis && (Keyword.KW_this == token.getKeyword() || Keyword.KW_super == token.getKeyword());
            if (bMatch) {
                return true;
            }
        }
        return false;
    }

    private void parseAggregateTypeLiteral(boolean bInterface) {
        CompoundTypeLiteral typeLiteral = new CompoundTypeLiteral();
        ArrayList<IType> types = new ArrayList<IType>();
        TypeLiteral typeLiteralComponent = (TypeLiteral)this.peekExpression();
        while (true) {
            this.addToCompoundType(types);
            if (!this.match(null, "&", -6)) break;
            this._parseTypeLiteral(this.getTokenizer().getCurrentToken(), false, bInterface);
        }
        this.verify((ParsedElement)typeLiteral, types.size() > 1, Res.MSG_AGGREGATES_MUST_CONTAIN_MORE, new String[0]);
        this.verify((ParsedElement)typeLiteral, !(typeLiteralComponent.getType().getType() instanceof TypeVariableType), Res.MSG_ONLY_ONE_TYPE_VARIABLE, new String[0]);
        typeLiteral.setType(CompoundType.get(new HashSet<IType>(types)));
        this.pushExpression(typeLiteral);
    }

    private void addToCompoundType(List<IType> types) {
        TypeLiteral typeLiteralComponent;
        IType t = (typeLiteralComponent = (TypeLiteral)this.popExpression()).getType().getType();
        this.verify((ParsedElement)typeLiteralComponent, t != JavaTypes.pVOID(), Res.MSG_VOID_NOT_ALLOWED, new String[0]);
        Set<IType> componentTypes = t.isCompoundType() ? t.getCompoundTypeComponents() : Collections.singleton(t);
        for (IType componentType : componentTypes) {
            boolean bFoundClassAlready = false;
            for (IType csr : types) {
                if (!(csr instanceof ErrorType) && this.verify((ParsedElement)typeLiteralComponent, csr != componentType, Res.MSG_ALREADY_CONTAINS_TYPE, componentType)) {
                    this.verify((ParsedElement)typeLiteralComponent, !csr.isAssignableFrom(componentType) && !StandardCoercionManager.isStructurallyAssignable((IType)csr, (IType)componentType), Res.MSG_INTERFACE_REDUNDANT, csr, componentType);
                    this.verify((ParsedElement)typeLiteralComponent, !componentType.isAssignableFrom(csr) && !StandardCoercionManager.isStructurallyAssignable((IType)componentType, (IType)csr), Res.MSG_INTERFACE_REDUNDANT, componentType, csr);
                }
                if (!csr.isInterface()) {
                    bFoundClassAlready = true;
                }
                this.verify((ParsedElement)typeLiteralComponent, componentType.isInterface() || !bFoundClassAlready, Res.MSG_ONLY_ONE_CLASS_IN_COMPONENT_TYPE, new String[0]);
            }
            this.verify((ParsedElement)typeLiteralComponent, !componentType.isArray(), Res.MSG_NO_ARRAY_IN_COMPONENT_TYPE, new String[0]);
            this.verify((ParsedElement)typeLiteralComponent, !componentType.isPrimitive(), Res.MSG_NO_PRIMITIVE_IN_COMPONENT_TYPE, new String[0]);
            types.add(componentType);
        }
    }

    void parseBlockLiteral() {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        this._parseBlockLiteral();
        this.setLocation(iOffset, iLineNum, iColumn);
    }

    void _parseBlockLiteral() {
        TypeLiteral returnType;
        BlockLiteral literal = new BlockLiteral();
        this.verify((ParsedElement)literal, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_BLOCK, new String[0]);
        ArrayList<IType> argTypes = new ArrayList<IType>();
        ArrayList<String> argNames = new ArrayList<String>();
        ArrayList<IExpression> defValues = new ArrayList<IExpression>();
        if (!this.match(null, 41)) {
            do {
                String result;
                int state = this._tokenizer.mark();
                Token t = new Token();
                boolean bEquals = false;
                Expression defExpr = null;
                TypeLiteral blockLiteral = null;
                if (this.match(t, -5)) {
                    if (this.match(null, ":", -6)) {
                        result = t._strValue;
                    } else {
                        bEquals = this.match(null, "=", -6);
                        if (bEquals) {
                            result = t._strValue;
                            this.parseExpression();
                            defExpr = this.popExpression();
                        } else if (this.match(null, null, 40, true)) {
                            result = t._strValue;
                            this.parseBlockLiteral();
                            blockLiteral = (TypeLiteral)this.popExpression();
                        } else {
                            this._tokenizer.restoreToMark(state);
                            result = null;
                        }
                    }
                } else {
                    this._tokenizer.restoreToMark(state);
                    result = null;
                }
                String name = result;
                TypeLiteral typeLiteral = null;
                if (!bEquals) {
                    if (blockLiteral == null) {
                        this.parseTypeLiteral();
                        typeLiteral = (TypeLiteral)this.popExpression();
                        if (this.match(null, "=", -6)) {
                            this.parseExpression(new ContextType(typeLiteral.getType().getType(), false));
                            defExpr = this.popExpression();
                        }
                    } else {
                        typeLiteral = blockLiteral;
                    }
                    argTypes.add(typeLiteral.getType().getType());
                    this.verifyOrWarn(typeLiteral, name != null, true, Res.MSG_BLOCK_TYPES_SHOULD_HAVE_ARG_NAMES, new Object[0]);
                    this.verify((ParsedElement)typeLiteral, typeLiteral.getType().getType() != JavaTypes.pVOID(), Res.MSG_VOID_NOT_ALLOWED, new String[0]);
                } else {
                    argTypes.add(defExpr.getType());
                    this.verifyOrWarn(literal, name != null, true, Res.MSG_BLOCK_TYPES_SHOULD_HAVE_ARG_NAMES, new Object[0]);
                    this.verify((ParsedElement)literal, defExpr.getType() != JavaTypes.pVOID(), Res.MSG_VOID_NOT_ALLOWED, new String[0]);
                }
                if (defExpr != null) {
                    if (this.verify((ParsedElement)defExpr, defExpr.isCompileTimeConstant(), Res.MSG_COMPILE_TIME_CONSTANT_REQUIRED, new String[0])) {
                        defValues.add(defExpr);
                    }
                } else {
                    defValues.add(null);
                }
                if (name != null && argNames.contains(name)) {
                    this.verify((ParsedElement)(typeLiteral == null ? literal : typeLiteral), false, Res.MSG_VARIABLE_ALREADY_DEFINED, name);
                }
                argNames.add(name == null ? "" : name);
            } while (this.match(null, 44));
            this.verify((ParsedElement)literal, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_BLOCK, new String[0]);
        }
        argNames.trimToSize();
        argTypes.trimToSize();
        literal.setArgTypes(argTypes);
        literal.setArgNames(argNames);
        literal.setDefValueExpressions(defValues);
        if (this.match(null, ":", -6)) {
            this.parseTypeLiteral();
            returnType = (TypeLiteral)this.popExpression();
        } else {
            returnType = new TypeLiteral((IType)JavaTypes.pVOID());
            returnType.setType((IType)JavaTypes.pVOID());
        }
        this.verify((ParsedElement)literal, argNames.size() <= 16, Res.MSG_BLOCKS_CAN_HAVE_A_MOST_SIXTEEN_ARGS, new String[0]);
        literal.setReturnType(returnType);
        this.pushExpression(literal);
    }

    void parseTypeLiteral(String[] T, boolean bIgnoreArrayBrackets, boolean bInterface, int iOffset, int iLineNum, int iColumn) {
        TypeLiteral e;
        this.parseCompoundTypeLiteralExpression(T, bInterface, iOffset, iLineNum, iColumn);
        Expression expr = this.popExpression();
        if (expr instanceof Identifier && !(expr.getType() instanceof ErrorType)) {
            e = bInterface ? new InterfaceTypeLiteral((IType)MetaType.getLiteral(expr.getType())) : new TypeLiteral((IType)MetaType.getLiteral(expr.getType()));
            e.setPackageExpression(expr);
            expr = e;
        } else if (!(expr instanceof TypeLiteral)) {
            e = bInterface ? new InterfaceTypeLiteral((IType)ErrorType.getInstance()) : new TypeLiteral((IType)ErrorType.getInstance());
            e.setPackageExpression(expr);
            e.addParseException((IParseIssue)new ParseException(null, Res.MSG_EXPECTING_TYPE_NAME, new Object[0]));
            expr = e;
        }
        IType type = ((TypeLiteral)expr).getType().getType();
        this.verifyTypeAccessible((TypeLiteral)expr, type);
        T[0] = type.getName();
        this.resolveArrayOrParameterizationPartOfTypeLiteral(T, bIgnoreArrayBrackets, (TypeLiteral)expr);
    }

    private void verifyTypeAccessible(TypeLiteral expr, IType type) {
        ICompilableTypeInternal gsClass = this.getGosuClass();
        if (gsClass == null || Modifier.isPublic((int)type.getModifiers())) {
            return;
        }
        IRelativeTypeInfo.Accessibility acc = FeatureManager.getAccessibilityForClass((IType)type, (IType)gsClass);
        if (Modifier.isPrivate((int)type.getModifiers())) {
            this.verify((ParsedElement)expr, acc == IRelativeTypeInfo.Accessibility.PRIVATE, Res.MSG_TYPE_HAS_XXX_ACCESS, type.getName(), Keyword.KW_private.toString());
        } else if (Modifier.isProtected((int)type.getModifiers())) {
            this.verify((ParsedElement)expr, acc == IRelativeTypeInfo.Accessibility.PROTECTED || acc == IRelativeTypeInfo.Accessibility.INTERNAL || acc == IRelativeTypeInfo.Accessibility.PRIVATE, Res.MSG_TYPE_HAS_XXX_ACCESS, type.getName(), Keyword.KW_protected.toString());
        } else if (!Modifier.isPublic((int)type.getModifiers()) && !Modifier.isProtected((int)type.getModifiers())) {
            this.verify((ParsedElement)expr, acc == IRelativeTypeInfo.Accessibility.INTERNAL || acc == IRelativeTypeInfo.Accessibility.PRIVATE, Res.MSG_TYPE_HAS_XXX_ACCESS, type.getName(), Keyword.KW_internal.toString());
        }
    }

    private void parseCompoundTypeLiteralExpression(String[] T, boolean bInterface, int iOffset, int iLineNum, int iColumn) {
        List<IParseIssue> exceptions;
        this.parseNamespaceStartOrRelativeType(T, bInterface);
        Expression expr = this.peekExpression();
        if (expr.hasParseExceptions() && ((exceptions = expr.getParseExceptions()).size() != 1 || exceptions.get(0).getMessageKey() != Res.MSG_CANNOT_REFERENCE_CLASS_TYPE_VAR_IN_STATIC_CONTEXT && exceptions.get(0).getMessageKey() != Res.MSG_TYPE_PARAM_NOT_ASSIGNABLE_TO && exceptions.get(0).getMessageKey() != Res.MSG_EXPECTING_CLOSING_ANGLE_BRACKET_FOR_TYPE)) {
            ParseException pe = expr.removeParseException(null);
            pe.setMessage(Res.MSG_INVALID_TYPE, new Object[]{T[0]});
            expr.addParseException((IParseIssue)pe);
        }
        this.setLocation(iOffset, iLineNum, iColumn);
        this.parseIndirectMemberAccess(iOffset, iLineNum, iColumn, true);
    }

    private boolean isTypeParameterErrorMsg(Expression expr, List<IParseIssue> exceptions) {
        return exceptions.get(0).getMessageKey() == Res.MSG_TYPE_PARAM_NOT_ASSIGNABLE_TO && expr instanceof TypeLiteral && !this.isErrorType(((TypeLiteral)expr).getType().getType());
    }

    private boolean resolveArrayOrParameterizationPartOfTypeLiteral(String[] T, boolean bIgnoreArrayBrackets, TypeLiteral e) {
        boolean bArrayOrParameterization = false;
        if (!bIgnoreArrayBrackets) {
            bArrayOrParameterization = this.parseArrayType(e);
        }
        this.pushExpression(e);
        if (!T[0].endsWith("[]")) {
            int iOffset = this._tokenizer.getTokenStart();
            int iLineNum = this._tokenizer.getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            if (this.match(null, "<", -6)) {
                TypeLiteral typeLiteral = (TypeLiteral)this.peekExpression();
                IType type = typeLiteral.getType().getType();
                this.verify((ParsedElement)e, type.isGenericType(), Res.MSG_PARAMETERIZATION_NOT_SUPPORTED_FOR_TYPE, type.getName());
                List<TypeLiteral> paramTypes = this.parseTypeParameters(type);
                this.verify((ParsedElement)e, this.match(null, ">", -6), Res.MSG_EXPECTING_CLOSING_ANGLE_BRACKET_FOR_TYPE, new String[0]);
                this.makeTypeParameterListClause(iOffset, iLineNum, iColumn, paramTypes);
                int numArrays = 0;
                while (!bIgnoreArrayBrackets && this.match(null, 91)) {
                    this.verify((ParsedElement)e, this.match(null, 93), Res.MSG_EXPECTING_ARRAY_BRACKET, new String[0]);
                    ++numArrays;
                }
                if (!(type instanceof ErrorType)) {
                    int i;
                    IType[] types = new IType[paramTypes.size()];
                    for (i = 0; i < paramTypes.size(); ++i) {
                        TypeLiteral tl = paramTypes.get(i);
                        types[i] = tl.getType().getType();
                    }
                    this.verifyCanParameterizeType(e, type, types);
                    typeLiteral.setParameterTypes(types);
                    type = typeLiteral.getType().getType();
                    if (numArrays > 0) {
                        for (i = 0; i < numArrays; ++i) {
                            type = type.getArrayType();
                        }
                        typeLiteral.setType((IType)MetaType.getLiteral(type));
                    }
                }
                bArrayOrParameterization = true;
            } else {
                TypeLiteral typeLiteral = (TypeLiteral)this.peekExpression();
                IType type = typeLiteral.getType().getType();
                try {
                    if (type.isGenericType() && !type.isParameterizedType() && !this.isParsingCompileTimeConstantExpression()) {
                        type = TypeLord.deriveParameterizedTypeFromContext(type, this.getContextType().getType());
                        typeLiteral.setType((IType)MetaType.getLiteral(type));
                    }
                }
                catch (Exception ex) {
                    throw GosuExceptionUtil.forceThrow((Throwable)ex, (String)type.getName());
                }
            }
        }
        return bArrayOrParameterization;
    }

    private boolean isParsingCompileTimeConstantExpression() {
        return this.getContextType() != null && this.getContextType().isCompileTimeConstant();
    }

    private boolean parseArrayType(TypeLiteral tl) {
        boolean bBalancedBrackets = true;
        Object baseType = tl.getType().getType();
        while (this.match(null, 91)) {
            bBalancedBrackets = this.match(null, 93);
            if (!bBalancedBrackets) {
                this.advanceToNextTokenSilently();
            }
            try {
                baseType = baseType.getArrayType();
            }
            catch (IllegalArgumentException iae) {
                tl.addParseException(Res.MSG_ARRAY_NOT_SUPPORTED, baseType.getName());
                baseType = ErrorType.getInstance();
            }
        }
        if (baseType != tl.getType().getType()) {
            this.warn((ParsedElement)tl, !tl.getType().getType().isParameterizedType() || TypeLord.getDefaultParameterizedType(tl.getType().getType()) == tl.getType().getType(), Res.MSG_PARAMETERIZED_ARRAY_COMPONENT, new Object[0]);
            tl.setType((IType)MetaType.getLiteral(baseType));
            this.verify((ParsedElement)tl, bBalancedBrackets, Res.MSG_EXPECTING_ARRAY_BRACKET, new String[0]);
            return true;
        }
        return false;
    }

    List<TypeLiteral> parseTypeParameters(IType enclosingType) {
        ArrayList<TypeLiteral> paramTypes = new ArrayList<TypeLiteral>();
        int i = 0;
        do {
            IGenericTypeVariable[] typeVars;
            IJavaType boundingType = JavaTypes.OBJECT();
            if (enclosingType != null && enclosingType.isGenericType() && (typeVars = enclosingType.getGenericTypeVariables()) != null && typeVars.length > i) {
                boundingType = typeVars[i].getBoundingType();
            }
            this.parseParameterType((IType)boundingType);
            paramTypes.add((TypeLiteral)this.popExpression());
        } while (this.match(null, 44) && ++i > 0);
        return paramTypes;
    }

    private void makeTypeParameterListClause(int iOffset, int iLineNum, int iColumn, List<TypeLiteral> paramTypes) {
        if (paramTypes.size() > 0) {
            boolean bZeroLength;
            TypeParameterListClause e = new TypeParameterListClause(paramTypes.toArray(new ITypeLiteralExpression[paramTypes.size()]));
            this.pushExpression(e);
            boolean bl = bZeroLength = this._tokenizer.getTokenStart() == iOffset;
            if (bZeroLength) {
                Token priorToken = this.getTokenizer().getPriorToken();
                iOffset = priorToken.getTokenEnd();
                iLineNum = priorToken.getLine();
                iColumn = priorToken.getTokenColumn();
            }
            this.setLocation(iOffset, iLineNum, iColumn, true);
            this.popExpression();
        }
    }

    boolean parseParameterType(IType boundingType) {
        boolean isWildcard = false;
        Expression superTypeLiteral = null;
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        if (this.match(null, "?", -6)) {
            isWildcard = true;
            if (this.match(null, Keyword.KW_extends)) {
                if (this.match(null, "?", -6, true)) {
                    if (!this.parseParameterType(boundingType)) {
                        return false;
                    }
                } else {
                    this.parseTypeLiteral();
                }
            } else if (this.match(null, Keyword.KW_super)) {
                if (this.match(null, "?", -6, true)) {
                    if (!this.parseParameterType(boundingType)) {
                        return false;
                    }
                } else {
                    this.parseTypeLiteral();
                    superTypeLiteral = this.popExpression();
                    TypeLiteral typeLiteral = new TypeLiteral((IType)MetaType.getLiteral(boundingType));
                    this.pushExpression(typeLiteral);
                }
            } else {
                this.pushExpression(new TypeLiteral((IType)JavaTypes.OBJECT()));
                this.setLocation(iOffset, iLineNum, iColumn);
            }
        } else {
            this.parseTypeLiteral();
        }
        TypeLiteral tl = (TypeLiteral)this.peekExpression();
        if (!this.isAllowingWildcards()) {
            if (superTypeLiteral != null) {
                this.verify((ParsedElement)superTypeLiteral, !isWildcard, Res.MSG_NO_WILDCARDS, tl.getType().getType().getRelativeName());
            }
            this.verify((ParsedElement)tl, !isWildcard, Res.MSG_NO_WILDCARDS, tl.getType().getType().getRelativeName());
        }
        this.boxTypeLiteralsType(tl);
        return true;
    }

    private void boxTypeLiteralsType(TypeLiteral tl) {
        IType tlType = tl.getType().getType();
        if (!this.warn((ParsedElement)tl, !tlType.isPrimitive(), Res.MSG_PRIMITIVE_TYPE_PARAM, tlType.getName(), TypeSystem.getBoxType((IType)tlType))) {
            tl.setType(TypeSystem.getBoxType((IType)tlType));
        }
    }

    boolean parseStatement() {
        return this.parseStatement(false);
    }

    boolean parseStatement(boolean bAsStmtBlock) {
        return this.parseStatement(false, bAsStmtBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean parseStatement(boolean forceKeepStmtBlock, boolean bAsStmtBlock) {
        this.incStatementDepth();
        try {
            boolean bRet;
            boolean bMatchedBrace;
            int iOffset = this._tokenizer.getTokenStart();
            int iLineNum = this._tokenizer.getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            this.checkInstruction(true);
            ParseTree prevLocation = this.peekLocation();
            ParsedElement prevStmt = prevLocation != null && prevLocation.getParsedElement() != null ? (prevLocation.getParsedElement() instanceof Statement ? prevLocation.getParsedElement() : null) : null;
            boolean bSetLocation = true;
            boolean bl = bMatchedBrace = !bAsStmtBlock && this.match(null, 123);
            if (bMatchedBrace || bAsStmtBlock) {
                this.parseStatementBlock(forceKeepStmtBlock, bMatchedBrace || !bAsStmtBlock);
                bRet = true;
                bSetLocation = this.peekStatement() instanceof StatementList;
            } else {
                bRet = this._parseStatement();
            }
            if (bRet && bSetLocation) {
                this.match(null, 59);
                this.setLocation(iOffset, iLineNum, iColumn, bAsStmtBlock);
                Statement currentStmt = this.peekStatement();
                if (!(currentStmt instanceof NoOpStatement) && !(prevStmt instanceof NoOpStatement)) {
                    this.warn((ParsedElement)currentStmt, prevStmt == null || prevStmt.getLineNum() != currentStmt.getLineNum() || prevStmt.hasParseExceptions() || currentStmt.hasParseExceptions(), Res.MSG_STATEMENT_ON_SAME_LINE, new Object[0]);
                }
            }
            boolean bl2 = bRet;
            return bl2;
        }
        finally {
            this.decStatementDepth();
        }
    }

    boolean parseLoopStatement() {
        ++this._iBreakOk;
        ++this._iContinueOk;
        try {
            boolean bl = this.parseStatement();
            return bl;
        }
        finally {
            --this._iBreakOk;
            --this._iContinueOk;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean _parseStatement() {
        Token token = this.getTokenizer().getCurrentToken();
        Keyword keyword = token.getKeyword();
        if (this.areUsingStatementsAllowedInStatementLists() && Keyword.KW_uses == keyword) {
            this._tokenizer.nextToken();
            this.parseUsesStatement();
            return true;
        } else if (Keyword.KW_if == keyword) {
            this._tokenizer.nextToken();
            this.parseIfStatement();
            return true;
        } else if (Keyword.KW_try == keyword) {
            this._tokenizer.nextToken();
            this.parseTryCatchFinallyStatement();
            return true;
        } else if (Keyword.KW_throw == keyword) {
            this._tokenizer.nextToken();
            this.parseThrowStatement();
            return true;
        } else if (Keyword.KW_continue == keyword) {
            this._tokenizer.nextToken();
            ContinueStatement stmt = new ContinueStatement();
            this.verify((ParsedElement)stmt, this._iContinueOk > 0, Res.MSG_CONTINUE_OUTSIDE_LOOP, new String[0]);
            this.pushStatement(stmt);
            return true;
        } else if (Keyword.KW_break == keyword) {
            this._tokenizer.nextToken();
            BreakStatement stmt = new BreakStatement();
            this.verify((ParsedElement)stmt, this._iBreakOk > 0, Res.MSG_BREAK_OUTSIDE_SWITCH_OR_LOOP, new String[0]);
            this.pushStatement(stmt);
            return true;
        } else if (Keyword.KW_return == keyword) {
            this._tokenizer.nextToken();
            this.parseReturnStatement();
            return true;
        } else if (Keyword.KW_foreach == keyword || Keyword.KW_for == keyword) {
            this._tokenizer.nextToken();
            this.parseForEachStatement();
            return true;
        } else if (Keyword.KW_while == keyword) {
            this._tokenizer.nextToken();
            this.parseWhileStatement();
            return true;
        } else if (Keyword.KW_do == keyword) {
            this._tokenizer.nextToken();
            this.parseDoWhileStatement();
            return true;
        } else if (Keyword.KW_switch == keyword) {
            this._tokenizer.nextToken();
            this.parseSwitchStatement();
            return true;
        } else if (Keyword.KW_using == keyword) {
            this._tokenizer.nextToken();
            this.parseUsingStatement();
            return true;
        } else if (Keyword.KW_assert == keyword) {
            this._tokenizer.nextToken();
            this.parseAssertStatement();
            return true;
        } else if (Keyword.KW_final == keyword) {
            this._tokenizer.nextToken();
            VarStatement varStmt = new VarStatement();
            varStmt.setModifierInfo(new ModifierInfo(0));
            varStmt.setFinal(true);
            this.parseLocalVarStatement(varStmt);
            return true;
        } else if (Keyword.KW_var == keyword) {
            VarStatement varStmt = new VarStatement();
            this.parseLocalVarStatement(varStmt);
            return true;
        } else if (59 == token.getType()) {
            this._tokenizer.nextToken();
            this.pushStatement(new NoOpStatement());
            return true;
        } else if (this.getGosuClass() instanceof IGosuProgram && this.getStatementDepth() == 1 && !this.isParsingBlock() && !((IGosuProgramInternal)this.getGosuClass()).isStatementsOnly() && this.maybeAdvanceTokenizerToEndOfSavedLocation()) {
            this.pushStatement(new NoOpStatement());
            return true;
        } else {
            if (!this.isParsingFunction() && this.parseFunctionDefinition()) {
                return true;
            }
            if (!this.isParsingFunction() && this.parsePropertyDefinition()) {
                return true;
            }
            if (Keyword.KW_eval == keyword) {
                int iOffset = token.getTokenStart();
                int iLineNum = token.getLine();
                int iColumn = token.getTokenColumn();
                this._tokenizer.nextToken();
                this.parseEvalExpression();
                this.setLocation(iOffset, iLineNum, iColumn, true);
                this.pushStatement(new EvalStatement((EvalExpression)this.popExpression()));
                return true;
            } else {
                if (this.parseAssignmentOrMethodCall()) return true;
                if (-1 == token.getType()) return false;
                int iOffset = token.getTokenStart();
                int iLineNum = token.getLine();
                int iColumn = token.getTokenColumn();
                if (125 != token.getType() && 59 != token.getType()) {
                    if (this.isParsingFunction()) {
                        if (this.maybeAdvanceTokenizerToEndOfSavedLocation()) {
                            this.pushStatement(new NoOpStatement());
                            this.setLocation(iOffset, iLineNum, iColumn, true, true);
                            this.popStatement();
                            return false;
                        }
                        if (Keyword.KW_construct == token.getKeyword() || Keyword.KW_function == token.getKeyword() || Keyword.KW_property == token.getKeyword()) {
                            NoOpStatement noop = new NoOpStatement();
                            this.getTokenizer().nextToken();
                            this.eatStatementBlock(noop, Res.MSG_SYNTAX_ERROR);
                            this.pushStatement(noop);
                            this.setLocation(iOffset, iLineNum, iColumn, true, true);
                            this.popStatement();
                            return false;
                        }
                    }
                    String str = this._tokenizer.getTokenAsString();
                    TypeLiteral type = this.resolveTypeLiteral(str);
                    this._tokenizer.nextToken();
                    NoOpStatement noop = new NoOpStatement();
                    if (!(type.evaluate() instanceof ErrorType)) {
                        int state = this._tokenizer.mark();
                        int iLocationsCount = this._locations.size();
                        this.parsePrimaryExpression();
                        Expression expression = this.popExpression();
                        if (expression instanceof Identifier && this.match(null, "=", -6)) {
                            expression.clearParseExceptions();
                            this.parseExpression();
                            this.popExpression();
                            this.verify((ParsedElement)noop, false, Res.MSG_JAVA_STYLE_VARIABLE_DECLARATION, str);
                        } else {
                            this._tokenizer.restoreToMark(state);
                            this.removeLocationsFrom(iLocationsCount);
                            this.verify((ParsedElement)noop, false, Res.MSG_UNEXPECTED_TOKEN, str);
                        }
                    } else {
                        this.verify((ParsedElement)noop, false, Res.MSG_UNEXPECTED_TOKEN, str);
                    }
                    this.pushStatement(noop);
                    return true;
                } else {
                    if (this.getStatementDepth() != 1 || this.isParsingBlock() || !(this.getGosuClass() instanceof IGosuProgram) || !((IGosuProgramInternal)this.getGosuClass()).isParsingExecutableProgramStatements()) return false;
                    NoOpStatement noop = new NoOpStatement();
                    this.verify((ParsedElement)noop, false, Res.MSG_UNEXPECTED_TOKEN, this._tokenizer.getTokenAsString());
                    this.pushStatement(noop);
                    this._tokenizer.nextToken();
                }
            }
        }
        return true;
    }

    private void parseAssertStatement() {
        AssertStatement assertStmt = new AssertStatement();
        if (this.verify((ParsedElement)assertStmt, this.getGosuClass() instanceof IGosuClassInternal, Res.MSG_ASSERTIONS_NOT_ALLOWED_HERE, new String[0])) {
            ((IGosuClassInternal)this.getGosuClass()).setHasAssertions(true);
        }
        this.parseExpression(ContextType.pBOOLEAN_FALSE);
        Expression condition = this.popExpression();
        if (!this.verify((ParsedElement)condition, !(condition instanceof NotAWordExpression), Res.MSG_EXPECTING_CONDITION_FOR_ASSERT, new String[0])) {
            condition.removeParseException(Res.MSG_SYNTAX_ERROR);
        }
        assertStmt.setCondition(condition);
        if (this.match(null, ":", -6)) {
            this.parseExpression(ContextType.OBJECT_FALSE);
            Expression detail = this.popExpression();
            if (!this.verify((ParsedElement)detail, !(detail instanceof NotAWordExpression), Res.MSG_EXPECTING_MESSAGE_FOR_ASSERT, new String[0])) {
                detail.removeParseException(Res.MSG_SYNTAX_ERROR);
            }
            assertStmt.setDetail(detail);
        }
        this.pushStatement(assertStmt);
    }

    private boolean areUsingStatementsAllowedInStatementLists() {
        if (this._bAreUsingStatementsAllowedInStatementLists == null) {
            this._bAreUsingStatementsAllowedInStatementLists = this.getGosuClass() == null || this.getGosuClass() instanceof IGosuProgramInternal && ((IGosuProgramInternal)this.getGosuClass()).allowsUses() || CommonServices.getEntityAccess().areUsesStatementsAllowedInStatementLists((ICompilableType)this.getGosuClass());
        }
        return this._bAreUsingStatementsAllowedInStatementLists;
    }

    private int getStatementDepth() {
        return this._iStmtDepth;
    }

    private void incStatementDepth() {
        ++this._iStmtDepth;
    }

    private void decStatementDepth() {
        --this._iStmtDepth;
    }

    void parseLocalVarStatement(VarStatement varStmt) {
        Token t = new Token();
        this.verify((ParsedElement)varStmt, this.match(t, Keyword.KW_var), Res.MSG_EXPECTING_VAR_STMT, new String[0]);
        int iNameOffset = this.getTokenizer().getTokenStart();
        if (this.verify((ParsedElement)varStmt, this.match(t, -5), Res.MSG_EXPECTING_IDENTIFIER_VAR, new String[0])) {
            varStmt.setNameOffset(iNameOffset, t._strValue);
            this.warn((ParsedElement)varStmt, !Keyword.isKeyword((String)t._strValue), Res.MSG_IMPROPER_USE_OF_KEYWORD, t._strValue);
        } else {
            t._strValue = null;
        }
        this.parseVarStatement(varStmt, t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseVarStatement(VarStatement varStmt, Token idToken, boolean bClassMember) {
        boolean bHideFieldForEditorParsing;
        Object symbol;
        IPropertyInfo varProperty;
        String strIdentifier = idToken._strValue == null ? "" : idToken._strValue;
        this.warn((ParsedElement)varStmt, !Keyword.isKeyword((String)strIdentifier), Res.MSG_IMPROPER_USE_OF_KEYWORD, strIdentifier);
        Token priorToken = this.getTokenizer().getPriorToken();
        boolean bZeroLength = strIdentifier.length() <= 0;
        this.addNameInDeclaration(strIdentifier, bZeroLength ? priorToken.getTokenEnd() : idToken._iDocPosition, priorToken.getLine(), priorToken.getTokenColumn(), !bZeroLength);
        ISymbol existingSymbol = this._symTable.getSymbol((CharSequence)strIdentifier);
        if ((this.isParsingBlock() || this.getParsingAnonymousClass() != null) && !this.isParsingAnnotation()) {
            existingSymbol = this.captureSymbol(this.getCurrentEnclosingGosuClass(), strIdentifier, null);
        }
        boolean bFieldSymbolFromProgram = false;
        if (!bClassMember && existingSymbol != null) {
            boolean bl = bFieldSymbolFromProgram = this.getGosuClass() instanceof IGosuProgram && (bClassMember || this.isLocalVarTopLevelFunctionBodyStmt()) && ((IGosuProgramInternal)this.getGosuClass()).isParsingExecutableProgramStatements() && existingSymbol instanceof DynamicSymbol;
            if (this.verify((ParsedElement)varStmt, bFieldSymbolFromProgram, Res.MSG_VARIABLE_ALREADY_DEFINED, strIdentifier)) {
                varStmt.setSymbol(existingSymbol);
            }
        }
        if (varStmt.getModifierInfo() == null) {
            varStmt.setModifierInfo(new ModifierInfo(0));
        }
        TypeLiteral typeLiteral = null;
        if (this.match(null, ":", -6)) {
            this.parseTypeLiteral();
            typeLiteral = (TypeLiteral)this.popExpression();
        } else if (!this.match(null, "=", -6, true) && this.match(null, null, 40, true)) {
            this.parseBlockLiteral();
            typeLiteral = (TypeLiteral)this.popExpression();
        }
        if (!bClassMember && this.getGosuClass() instanceof IGosuProgram && this.getGosuClass().getMemberField(strIdentifier) != null && this.match(null, Keyword.KW_as)) {
            this.match(null, Keyword.KW_readonly);
            this.match(null, -5);
        }
        Expression eas = null;
        if (this.match(null, "=", -6)) {
            this.pushParsingFieldInitializer(varStmt);
            this.putThisAndSuperSymbols(varStmt.getModifierInfo());
            try {
                this.parseExpression(typeLiteral == null ? ContextType.EMPTY : new ContextType(typeLiteral.getType().getType()));
            }
            finally {
                this.popParsingFieldInitializer();
            }
            eas = this.popExpression();
            if (eas.hasParseExceptions() && typeLiteral != null) {
                IType typeCast = typeLiteral.getType().getType();
                eas.getParseExceptions().get(0).setExpectedType(typeCast);
            }
            this.detectLikelyJavaCast(eas);
        }
        this.verify((ParsedElement)varStmt, eas != null || typeLiteral != null, Res.MSG_VARIABLE_TYPE_OR_VALUE_REQUIRED, new String[0]);
        if (typeLiteral != null) {
            this.verify((ParsedElement)typeLiteral, typeLiteral.getType().getType() != JavaTypes.pVOID(), Res.MSG_VOID_NOT_ALLOWED, new String[0]);
        }
        Object type = null;
        if (eas != null && (type = eas.getType()) == null) {
            type = ErrorType.getInstance();
        }
        if (typeLiteral != null) {
            type = typeLiteral.getType().getType();
        } else if (bClassMember && eas != null && (varProperty = this.getGosuClass().getTypeInfo().getProperty((IType)this.getGosuClass(), (CharSequence)strIdentifier)) instanceof IGosuVarPropertyInfo) {
            IGosuVarPropertyInfo vpi = (IGosuVarPropertyInfo)varProperty;
            vpi.assignActualType(eas.getType());
            vpi.assignSymbolType(eas.getType());
        }
        this.verify((ParsedElement)varStmt, !JavaTypes.pVOID().equals(type) && !JavaTypes.VOID().equals(type), Res.MSG_VARIABLE_MUST_HAVE_NON_NULL_TYPE, new String[0]);
        if (type == null) {
            type = ErrorType.getInstance();
        }
        if (bClassMember || bFieldSymbolFromProgram) {
            symbol = varStmt.getSymbol();
            symbol.setType(type);
            varStmt.setType((IType)type);
        } else {
            Symbol newSym = new Symbol(strIdentifier, (IType)type, (IStackProvider)this._symTable, null);
            newSym.setModifierInfo(varStmt.getModifierInfo());
            symbol = newSym;
            varStmt.setSymbol((ISymbol)newSym);
        }
        if (existingSymbol == null) {
            this._symTable.putSymbol(symbol);
        }
        eas = this.possiblyWrapWithImplicitCoercion(eas, (IType)type);
        varStmt.setAsExpression(eas);
        varStmt.setTypeLiteral(typeLiteral);
        varStmt.setScriptPart(this.getScriptPart());
        varStmt.setDefinitionParsed(true);
        boolean bl = bHideFieldForEditorParsing = this.getGosuClass() != null && this.getGosuClass().isCreateEditorParser() && bFieldSymbolFromProgram;
        if (bHideFieldForEditorParsing) {
            this.pushStatement(new HideFieldNoOpStatement(varStmt));
        } else {
            this.pushStatement(varStmt);
        }
    }

    private boolean isLocalVarTopLevelFunctionBodyStmt() {
        if (this._symTable.getScopeCount() > 1) {
            return this._symTable.peekScope(1).getActivationCtx() != null;
        }
        return false;
    }

    private void detectLikelyJavaCast(Expression eas) {
        IParenthesizedExpression parenExpr;
        if ((eas instanceof IParenthesizedExpression || eas instanceof IImplicitTypeAsExpression && ((IImplicitTypeAsExpression)eas).getLHS() instanceof IParenthesizedExpression) && (parenExpr = eas instanceof IParenthesizedExpression ? (IParenthesizedExpression)eas : (IParenthesizedExpression)((IImplicitTypeAsExpression)eas).getLHS()).getExpression() instanceof TypeLiteral) {
            IType castType = eas.getType();
            if (castType instanceof IMetaType) {
                castType = ((IMetaType)castType).getType();
            }
            eas.addParseWarning((IParseIssue)new ParseWarning((IParserState)this.makeFullParserState(), Res.MSG_LIKELY_JAVA_CAST, new Object[]{castType.getName()}));
        }
    }

    private boolean recoverFromJavaStyleCast(Expression eas) {
        if (eas instanceof IParenthesizedExpression && ((IParenthesizedExpression)eas).getExpression() instanceof TypeLiteral && this.getTokenizer().getLineNumber() == eas.getLocation().getLineNum()) {
            IType castType = eas.getType();
            if (castType instanceof IMetaType) {
                castType = ((IMetaType)castType).getType();
            }
            int mark = this.getTokenizer().mark();
            this.parseUnaryExpression();
            Expression maybeRealEas = this.popExpression();
            if (maybeRealEas.hasParseExceptions()) {
                this._locations.remove(maybeRealEas.getLocation());
                this.getTokenizer().restoreToMark(mark);
            } else {
                this.popExpression();
                eas.addParseWarning((IParseIssue)new ParseWarning((IParserState)this.makeFullParserState(), Res.MSG_LIKELY_JAVA_CAST, new Object[]{castType.getName()}));
                eas = this.possiblyWrapWithImplicitCoercion(maybeRealEas, castType);
                this.pushExpression(eas);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DynamicPropertySymbol parseVarPropertyClause(VarStatement varStmt, String strVarIdentifier, IType varType, boolean parseInitializer) {
        VarPropertyGetFunctionSymbol getFunctionSymbol;
        DynamicPropertySymbol dps;
        if (!this.match(null, Keyword.KW_as)) {
            return null;
        }
        boolean bReadonly = this.match(null, Keyword.KW_readonly) || varStmt.isFinal();
        int iNameStart = this.getTokenizer().getTokenStart();
        Token T = new Token();
        varStmt.setHasProperty(true);
        String strPropertyName = null;
        if (this.verify((ParsedElement)varStmt, this.match(T, -5), Res.MSG_EXPECTING_NAME_PROPERTY, new String[0])) {
            strPropertyName = T._strValue;
            this.warn((ParsedElement)varStmt, !Keyword.isKeyword((String)strPropertyName), Res.MSG_IMPROPER_USE_OF_KEYWORD, strPropertyName);
        }
        String strIdentifier = strPropertyName == null ? "" : strPropertyName;
        Token restoreState = this.getTokenizer().getPriorToken();
        this.addNameInDeclaration(strIdentifier, T._iDocPosition, restoreState.getLine(), restoreState.getTokenColumn(), strIdentifier.length() > 0);
        varStmt.setPropertyName(strPropertyName);
        varStmt.setNameOffset(iNameStart, strPropertyName);
        ISymbol symbol = this.getSymbolTable().getSymbol((CharSequence)strPropertyName);
        if (symbol != null && !symbol.getDisplayName().equals(strPropertyName)) {
            symbol = null;
        }
        if (symbol instanceof DynamicPropertySymbol && symbol.getGosuClass() == this.getGosuClass() && ((DynamicPropertySymbol)symbol).getVarIdentifier() != null && !((DynamicPropertySymbol)symbol).getVarIdentifier().equals(strVarIdentifier)) {
            varStmt.addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_PROPERTY_ALREADY_DEFINED, new Object[]{strPropertyName}));
        }
        ICompilableTypeInternal gsClass = this.getGosuClass();
        if (symbol instanceof DynamicPropertySymbol) {
            dps = new DynamicPropertySymbol((DynamicPropertySymbol)symbol);
            if (dps.getGetterDfs() == null || dps.getGetterDfs().getScriptPart().getContainingType() != gsClass) {
                getFunctionSymbol = new VarPropertyGetFunctionSymbol(gsClass, this.getSymbolTable(), strPropertyName, strVarIdentifier, varType);
                getFunctionSymbol.getModifierInfo().setAnnotations(varStmt.getAnnotations());
                getFunctionSymbol.getModifierInfo().setDescription(varStmt.getModifierInfo().getDescription());
                getFunctionSymbol.setClassMember(true);
                if (dps.getGetterDfs() != null) {
                    getFunctionSymbol.setOverride(true);
                    getFunctionSymbol.setSuperDfs(dps.getGetterDfs());
                }
                getFunctionSymbol.setStatic(varStmt.isStatic());
                dps.setGetterDfs(getFunctionSymbol);
                this.verifyFunction(getFunctionSymbol, varStmt);
            }
        } else {
            getFunctionSymbol = new VarPropertyGetFunctionSymbol(gsClass, this.getSymbolTable(), strPropertyName, strVarIdentifier, varType);
            getFunctionSymbol.getModifierInfo().setAnnotations(varStmt.getAnnotations());
            getFunctionSymbol.getModifierInfo().setDescription(varStmt.getModifierInfo().getDescription());
            getFunctionSymbol.setClassMember(true);
            getFunctionSymbol.setStatic(varStmt.isStatic());
            this.verifyFunction(getFunctionSymbol, varStmt);
            dps = new DynamicPropertySymbol(getFunctionSymbol, true);
        }
        if (!(bReadonly || dps.getSetterDfs() != null && dps.getSetterDfs().getScriptPart().getContainingType() == gsClass)) {
            VarPropertySetFunctionSymbol setFunctionSymbol = new VarPropertySetFunctionSymbol(gsClass, this.getSymbolTable(), strPropertyName, strVarIdentifier, varType);
            setFunctionSymbol.getModifierInfo().setAnnotations(varStmt.getAnnotations());
            setFunctionSymbol.getModifierInfo().setDescription(varStmt.getModifierInfo().getDescription());
            setFunctionSymbol.setClassMember(true);
            setFunctionSymbol.setStatic(varStmt.isStatic());
            if (dps.getSetterDfs() != null) {
                setFunctionSymbol.setOverride(true);
                setFunctionSymbol.setSuperDfs(dps.getSetterDfs());
            }
            dps.setSetterDfs(setFunctionSymbol);
            this.verifyFunction(setFunctionSymbol, varStmt);
        }
        dps.setScriptPart(this.getOwner().getScriptPart());
        dps.setVarIdentifier(strVarIdentifier);
        if (parseInitializer && this.match(null, "=", -6, false)) {
            this.pushParsingFieldInitializer(varStmt);
            try {
                this.parseExpression(new ContextType(varType));
            }
            finally {
                this.popParsingFieldInitializer();
            }
            Expression expression = this.popExpression();
            this.verifyComparable(varType, expression);
            expression = this.possiblyWrapWithImplicitCoercion(expression, varType);
            varStmt.setAsExpression(expression);
        }
        return dps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseDelegateStatement(DelegateStatement delegateStmt, String strIdentifier) {
        Object symbol;
        if (delegateStmt.getModifierInfo() == null) {
            delegateStmt.setModifierInfo(new ModifierInfo(0));
        }
        TypeLiteral typeLiteral = null;
        if (this.match(null, ":", -6)) {
            this.parseTypeLiteral();
            typeLiteral = (TypeLiteral)this.popExpression();
            this.warn((ParsedElement)delegateStmt, typeLiteral.getType().getType() != null && !typeLiteral.getType().getType().equals(this.getCurrentEnclosingGosuClass()), Res.MSG_DELEGATES_SHOULD_NOT_SELF_DELEGATE, new Object[0]);
        }
        ICompilableTypeInternal gsClass = this.getGosuClass();
        ArrayList<IType> constituents = new ArrayList<IType>();
        if (this.verify((ParsedElement)delegateStmt, this.match(null, Keyword.KW_represents), Res.MSG_EXPECTING_REPRESENTS, new String[0])) {
            do {
                this.getOwner().parseTypeLiteral();
                TypeLiteral ifaceLiteral = (TypeLiteral)this.popExpression();
                IType iface = ifaceLiteral.getType().getType();
                if (!(iface instanceof ErrorType)) {
                    this.verify((ParsedElement)ifaceLiteral, iface.isInterface() && !iface.isCompoundType(), Res.MSG_DELEGATES_REPRESENT_INTERFACES_ONLY, new String[0]);
                    this.verify((ParsedElement)ifaceLiteral, TypeLord.isDelegatableInterface((IType)gsClass, iface), Res.MSG_CLASS_DOES_NOT_IMPL, iface);
                    this.verify((ParsedElement)typeLiteral, typeLiteral == null || TypeLord.isDelegatableInterface(typeLiteral.getType().getType(), iface), Res.MSG_CLASS_DOES_NOT_IMPL, iface);
                }
                constituents.add(iface);
            } while (this.match(null, 44));
        }
        delegateStmt.setConstituents(constituents);
        Expression eas = null;
        if (this.match(null, "=", -6)) {
            this.pushParsingFieldInitializer(delegateStmt);
            try {
                this.parseExpression(typeLiteral == null ? ContextType.EMPTY : new ContextType(typeLiteral.getType().getType()));
            }
            finally {
                this.popParsingFieldInitializer();
            }
            eas = this.popExpression();
            if (eas.hasParseExceptions() && typeLiteral != null) {
                IType typeCast = typeLiteral.getType().getType();
                eas.getParseExceptions().get(0).setExpectedType(typeCast);
            }
            if (eas instanceof IParenthesizedExpression && ((IParenthesizedExpression)eas).getExpression() instanceof TypeLiteral) {
                IType castType = eas.getType();
                if (castType instanceof IMetaType) {
                    castType = ((IMetaType)castType).getType();
                }
                eas.addParseWarning((IParseIssue)new ParseWarning((IParserState)this.makeFullParserState(), Res.MSG_LIKELY_JAVA_CAST, new Object[]{castType.getName()}));
            }
        }
        Object type = null;
        if (eas != null && (type = eas.getType()) == null) {
            type = ErrorType.getInstance();
        }
        if (typeLiteral != null) {
            IType typeCast = typeLiteral.getType().getType();
            if (eas != null && type != null) {
                this.verifyComparable(typeCast, eas, false, true);
            }
            type = typeCast;
        } else if (!(type instanceof ErrorType)) {
            type = constituents.isEmpty() ? ErrorType.getInstance() : (constituents.size() == 1 ? (IType)constituents.get(0) : CompoundType.get(new HashSet<IType>(constituents)));
        }
        if (type == null) {
            type = ErrorType.getInstance();
        }
        if ((symbol = delegateStmt.getSymbol()) == null) {
            symbol = new Symbol(strIdentifier, (IType)type, (IStackProvider)this._symTable);
            delegateStmt.setSymbol((ISymbol)symbol);
        } else {
            symbol.setType(type);
        }
        this._symTable.putSymbol(symbol);
        delegateStmt.setType((IType)type);
        eas = this.possiblyWrapWithImplicitCoercion(eas, (IType)type);
        delegateStmt.setAsExpression(eas);
        delegateStmt.setTypeLiteral(typeLiteral);
        delegateStmt.setScriptPart(this.getScriptPart());
        this.pushStatement(delegateStmt);
    }

    private void parseSwitchStatement() {
        SwitchStatement switchStmt = new SwitchStatement();
        this.verify((ParsedElement)switchStmt, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_SWITCH, new String[0]);
        this.parseExpression();
        this.verify((ParsedElement)switchStmt, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_SWITCH, new String[0]);
        this.verify((ParsedElement)switchStmt, this.match(null, 123), Res.MSG_EXPECTING_OPEN_BRACE_FOR_SWITCH, new String[0]);
        Expression e = this.popExpression();
        switchStmt.setSwitchExpression(e);
        ++this._iBreakOk;
        try {
            this.parseCaseClauses(switchStmt);
            this.parseDefaultClause(switchStmt, Arrays.asList(switchStmt.getCases()));
        }
        finally {
            --this._iBreakOk;
        }
        this.verify((ParsedElement)switchStmt, this.match(null, 125), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_SWITCH, new String[0]);
        this.pushStatement(switchStmt);
    }

    private void parseDoWhileStatement() {
        boolean loopStmtParsed;
        DoWhileStatement whileStmt = new DoWhileStatement();
        this._ctxInferenceMgr.pushLoopCompromised();
        try {
            loopStmtParsed = this.parseLoopStatement();
        }
        finally {
            this._ctxInferenceMgr.popLoopCompromised();
        }
        if (this.verify((ParsedElement)whileStmt, loopStmtParsed, Res.MSG_EXPECTING_STATEMENT, new String[0])) {
            this.verify((ParsedElement)whileStmt, this.match(null, Keyword.KW_while), Res.MSG_EXPECTING_WHILE_DO, new String[0]);
            Statement stmt = this.popStatement();
            this.verify((ParsedElement)whileStmt, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_IF, new String[0]);
            this.parseExpression(ContextType.pBOOLEAN_FALSE);
            if (this.match(null, "=", -6)) {
                this.parseExpression();
                this.popExpression();
                this.verify((ParsedElement)whileStmt, false, Res.MSG_ASSIGNMENT_IN_LOOP_STATEMENT, new String[0]);
            }
            this.verify((ParsedElement)whileStmt, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_IF, new String[0]);
            Expression e = this.popExpression();
            whileStmt.setExpression(e);
            this.verifyLoopConditionNotAlwaysFalse(e);
            whileStmt.setStatement(stmt);
        }
        this.pushStatement(whileStmt);
    }

    private void verifyLoopConditionNotAlwaysFalse(Expression e) {
        this.verify((ParsedElement)e, !e.isCompileTimeConstant() || e.hasParseExceptions() || (Boolean)e.evaluate() != false, Res.MSG_CONDITION_IS_ALWAYS_TRUE_FALSE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseWhileStatement() {
        WhileStatement whileStmt = new WhileStatement();
        this._ctxInferenceMgr.pushLoopCompromised();
        this.verify((ParsedElement)whileStmt, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_WHILE, new String[0]);
        this.parseExpression(ContextType.pBOOLEAN_FALSE);
        if (this.match(null, "=", -6)) {
            this.parseExpression();
            this.popExpression();
            this.verify((ParsedElement)whileStmt, false, Res.MSG_ASSIGNMENT_IN_LOOP_STATEMENT, new String[0]);
        }
        this.verify((ParsedElement)whileStmt, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_WHILE, new String[0]);
        Expression e = this.popExpression();
        this._ctxInferenceMgr.pushLastCtx();
        try {
            whileStmt.setExpression(e);
            this.verifyLoopConditionNotAlwaysFalse(e);
            if (this.verify((ParsedElement)whileStmt, this.parseLoopStatement(), Res.MSG_EXPECTING_STATEMENT, new String[0])) {
                Statement stmt = this.popStatement();
                whileStmt.setStatement(stmt);
            }
            this.pushStatement(whileStmt);
        }
        finally {
            this._ctxInferenceMgr.popCtx(false);
            this._ctxInferenceMgr.popLoopCompromised();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseForEachStatement() {
        Token t = new Token();
        ForEachStatement forEachStmt = new ForEachStatement(this._symTable);
        this.verify((ParsedElement)forEachStmt, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_FE, new String[0]);
        boolean bLoneInterval = false;
        Expression ein = null;
        if (!this.match(null, Keyword.KW_var)) {
            int state = this._tokenizer.mark();
            int iLocationsCount = this._locations.size();
            this.parseExpression();
            ein = this.popExpression();
            bLoneInterval = JavaTypes.NUMBER_INTERVAL().isAssignableFrom(ein.getType());
            if (!bLoneInterval) {
                this._tokenizer.restoreToMark(state);
                this.removeLocationsFrom(iLocationsCount);
            }
        }
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        if (!bLoneInterval && this.verify((ParsedElement)forEachStmt, this.match(t, -5), Res.MSG_EXPECTING_IDENTIFIER_FOREACH, new String[0])) {
            forEachStmt.setNameOffset(iOffset, t._strValue);
            this.warn((ParsedElement)forEachStmt, !Keyword.isKeyword((String)t._strValue), Res.MSG_IMPROPER_USE_OF_KEYWORD, t._strValue);
        } else {
            t._strValue = null;
        }
        this._symTable.pushScope();
        try {
            IType typeIn;
            String strIdentifier = t._strValue == null ? "" : t._strValue;
            LocalVarDeclaration varDecl = null;
            if (strIdentifier.length() > 0) {
                varDecl = new LocalVarDeclaration(strIdentifier);
                this.verify((ParsedElement)forEachStmt, this._symTable.getSymbol((CharSequence)strIdentifier) == null, Res.MSG_VARIABLE_ALREADY_DEFINED, strIdentifier);
                varDecl.setType((IType)ErrorType.getInstance());
                this.pushExpression(varDecl);
                this.setLocation(iOffset, iLineNum, iColumn, strIdentifier == null, true);
                this.popExpression();
            }
            if (!bLoneInterval) {
                this.verify((ParsedElement)forEachStmt, this.match(null, Keyword.KW_in), Res.MSG_EXPECTING_IN_FOREACH, new String[0]);
                this.parseExpression();
                ein = this.popExpression();
            }
            this.verify((ParsedElement)ein, LoopStatement.isIteratorType(typeIn = ein.getType()) || typeIn instanceof ErrorType, Res.MSG_EXPECTING_ARRAYTYPE_FOREACH, typeIn.getName());
            forEachStmt.setInExpression(ein);
            forEachStmt.setStructuralIterable(StandardCoercionManager.isStructurallyAssignable_Laxed((IType)JavaTypes.ITERABLE(), (IType)typeIn));
            if (strIdentifier != null) {
                IType typeIdentifier = LoopStatement.getArrayComponentType(typeIn);
                if (strIdentifier.length() > 0) {
                    varDecl.setType(typeIdentifier);
                }
                Symbol symbol = new Symbol(bLoneInterval ? "_unused_loop_var_" + iOffset : strIdentifier, typeIdentifier, (IStackProvider)this._symTable, null);
                this._symTable.putSymbol((ISymbol)symbol);
                forEachStmt.setIdentifier(symbol);
            }
            boolean foundIterator = false;
            if (this.match(null, Keyword.KW_iterator)) {
                foundIterator = true;
                this.parseIteratorVar(forEachStmt, typeIn);
            }
            if (this.match(null, Keyword.KW_index)) {
                this.parseIndexVar(forEachStmt);
            }
            if (!foundIterator && this.match(null, Keyword.KW_iterator)) {
                foundIterator = true;
                this.parseIteratorVar(forEachStmt, typeIn);
            }
            if (bLoneInterval && foundIterator) {
                this.addError(forEachStmt, Res.MSG_FOREACH_ITERATOR_NOT_ALLOWED);
            }
            this.verify((ParsedElement)forEachStmt, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_FE, new String[0]);
            if (strIdentifier != null) {
                boolean bHasBody;
                this._ctxInferenceMgr.pushLoopCompromised();
                try {
                    bHasBody = this.parseLoopStatement();
                }
                finally {
                    this._ctxInferenceMgr.popLoopCompromised();
                }
                this.verify((ParsedElement)forEachStmt, bHasBody, Res.MSG_EXPECTING_STATEMENT, new String[0]);
                if (bHasBody) {
                    Statement stmt = this.popStatement();
                    forEachStmt.setStatement(stmt);
                }
            }
            this.pushStatement(forEachStmt);
        }
        finally {
            this._symTable.popScope();
        }
    }

    private void parseIndexVar(ForEachStatement forEachStmt) {
        String strIndexIdentifier;
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        Token Tindex = new Token();
        if (this.verify((ParsedElement)forEachStmt, this.match(Tindex, -5), Res.MSG_EXPECTING_IDENTIFIER_FOREACH_INDEX, new String[0])) {
            this.warn((ParsedElement)forEachStmt, !Keyword.isKeyword((String)Tindex._strValue), Res.MSG_IMPROPER_USE_OF_KEYWORD, Tindex._strValue);
        }
        LocalVarDeclaration varIndexDecl = new LocalVarDeclaration((strIndexIdentifier = Tindex._strValue) == null ? "#err" : strIndexIdentifier);
        varIndexDecl.setType((IType)JavaTypes.pINT());
        this.verify((ParsedElement)forEachStmt, this._symTable.getSymbol((CharSequence)strIndexIdentifier) == null, Res.MSG_VARIABLE_ALREADY_DEFINED, strIndexIdentifier);
        forEachStmt.setIndexNameOffset(Tindex.getTokenStart());
        TypedSymbol indexIdentifier = new TypedSymbol(strIndexIdentifier, (IType)JavaTypes.pINT(), this._symTable, null, SymbolType.FOREACH_VARIABLE);
        indexIdentifier.setFinal(true);
        this._symTable.putSymbol((ISymbol)indexIdentifier);
        forEachStmt.setIndexIdentifier(indexIdentifier);
        this.pushExpression(varIndexDecl);
        this.setLocation(iOffset, iLineNum, iColumn, strIndexIdentifier == null, false);
        this.popExpression();
    }

    private void parseIteratorVar(ForEachStatement forEachStmt, IType type) {
        ErrorType iterType;
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        Token Titer = new Token();
        if (this.verify((ParsedElement)forEachStmt, this.match(Titer, -5), Res.MSG_EXPECTING_IDENTIFIER_FOREACH_ITERATOR, new String[0])) {
            this.warn((ParsedElement)forEachStmt, !Keyword.isKeyword((String)Titer._strValue), Res.MSG_IMPROPER_USE_OF_KEYWORD, Titer._strValue);
        }
        String strIterIdentifier = Titer._strValue;
        boolean bIterable = JavaTypes.ITERABLE().isAssignableFrom(type) || forEachStmt.isStructuralIterable();
        this.verify((ParsedElement)forEachStmt, bIterable, Res.MSG_ITERATOR_SYMBOL_ONLY_SUPPORTED_ON_ITERABLE_OBJECTS, new String[0]);
        if (bIterable) {
            IType iterParam = LoopStatement.getArrayComponentType(type);
            iterType = JavaTypes.ITERATOR().getParameterizedType(new IType[]{iterParam});
        } else {
            iterType = ErrorType.getInstance();
        }
        LocalVarDeclaration varIteratorDecl = new LocalVarDeclaration(strIterIdentifier == null ? "#err" : strIterIdentifier);
        varIteratorDecl.setType((IType)iterType);
        this.verify((ParsedElement)forEachStmt, this._symTable.getSymbol((CharSequence)strIterIdentifier) == null, Res.MSG_VARIABLE_ALREADY_DEFINED, strIterIdentifier);
        forEachStmt.setIndexNameOffset(Titer.getTokenStart());
        TypedSymbol iteratorIdentifier = new TypedSymbol(strIterIdentifier, (IType)iterType, this._symTable, null, SymbolType.FOREACH_VARIABLE);
        iteratorIdentifier.setFinal(true);
        this._symTable.putSymbol((ISymbol)iteratorIdentifier);
        forEachStmt.setIteratorIdentifier(iteratorIdentifier);
        this.pushExpression(varIteratorDecl);
        this.setLocation(iOffset, iLineNum, iColumn, strIterIdentifier == null, false);
        this.popExpression();
    }

    private void parseReturnStatement() {
        ReturnStatement returnStmt = new ReturnStatement();
        IType returnType = null;
        if (this.isParsingBlock()) {
            returnType = (IType)this._blockReturnTypeStack.peek();
        } else if (this.isParsingFunction()) {
            if (this._bProgramCallFunction && this.getGosuClass() instanceof IGosuProgram) {
                returnType = ((IGosuProgram)this.getGosuClass()).getExpectedReturnType();
            }
            if (returnType == null) {
                returnType = this.peekParsingFunction().getReturnType();
            }
        } else if (this.isParsingProgram()) {
            returnType = this.peekParsingProgram().getDeclaredReturnType();
        }
        this.verify((ParsedElement)returnStmt, this._iReturnOk > 0, Res.MSG_RETURN_NOT_ALLOWED_HERRE, new String[0]);
        if (this.match(null, 59) || this.match(null, null, 125, true)) {
            boolean bShouldNotHaveReturnValue = this._bProgramCallFunction || returnType == null || returnType == GosuParserTypes.NULL_TYPE();
            FunctionType functionType = this.isParsingFunction() ? this.peekParsingFunction() : null;
            boolean bConstructor = !bShouldNotHaveReturnValue && functionType != null && functionType.getMethodOrConstructorInfo() instanceof IConstructorInfo;
            this.verify((ParsedElement)returnStmt, bShouldNotHaveReturnValue || bConstructor, Res.MSG_MISSING_RETURN_VALUE, new String[0]);
            this.setReturnNullExpr(returnStmt, this._bProgramCallFunction);
        } else if (returnType != GosuParserTypes.NULL_TYPE() && !this.inConstructorCtx()) {
            this.parseExpression(new ContextType(returnType));
            Expression retValue = this.popExpression();
            if (returnType != null && !this.isParsingBlock()) {
                boolean bVoidReturnType;
                Expression actualReturnExpr = retValue;
                if (retValue instanceof ImplicitTypeAsExpression) {
                    actualReturnExpr = ((ImplicitTypeAsExpression)retValue).getLHS();
                }
                boolean bl = bVoidReturnType = actualReturnExpr.getType() == GosuParserTypes.NULL_TYPE() && !(actualReturnExpr instanceof NullExpression);
                if (bVoidReturnType) {
                    actualReturnExpr.removeParseWarning(Res.MSG_USING_VOID_RETURN_TYPE_FROM_NON_NULL_EXPR);
                    this.verify((ParsedElement)actualReturnExpr, !bVoidReturnType, Res.MSG_USING_VOID_RETURN_TYPE_FROM_NON_NULL_EXPR, new String[0]);
                }
            }
            returnStmt.setValue(retValue);
            if ((returnType == null || this._bProgramCallFunction) && retValue.getType() == JavaTypes.pVOID()) {
                retValue.setType((IType)JavaTypes.OBJECT());
            }
        } else {
            this.setReturnNullExpr(returnStmt, this._bProgramCallFunction);
        }
        this.pushStatement(returnStmt);
    }

    private boolean inConstructorCtx() {
        if (this.isParsingConstructor()) {
            return this._blocks == null || this._blocks.isEmpty();
        }
        return false;
    }

    private void setReturnNullExpr(ReturnStatement returnStmt, boolean bProgramCallFunction) {
        if (bProgramCallFunction) {
            NullExpression nullExpr = new NullExpression();
            nullExpr.setType((IType)JavaTypes.OBJECT());
            returnStmt.setValue(nullExpr);
        } else {
            returnStmt.setValue(NullExpression.instance());
        }
    }

    private void parseThrowStatement() {
        this.parseExpression();
        Expression e = this.popExpression();
        if (!JavaTypes.THROWABLE().isAssignableFrom(e.getType())) {
            this.verifyComparable((IType)JavaTypes.STRING(), e);
            e = this.possiblyWrapWithImplicitCoercion(e, (IType)JavaTypes.STRING());
        }
        ThrowStatement throwStmt = new ThrowStatement();
        throwStmt.setExpression(e);
        this.pushStatement(throwStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTryCatchFinallyStatement() {
        Token t = new Token();
        TryCatchFinallyStatement tryCatchFinallyStmt = new TryCatchFinallyStatement();
        if (this.verify((ParsedElement)tryCatchFinallyStmt, this.match(null, null, 123, true), Res.MSG_EXPECTING_LEFTBRACE_STMTBLOCK, new String[0])) {
            this.parseStatement();
            Statement tryStmt = this.popStatement();
            tryCatchFinallyStmt.setTryStatement(tryStmt);
        }
        int iCatchOffset = this._tokenizer.getTokenStart();
        int iCatchLineNum = this._tokenizer.getLineNumber();
        int iCatchColumn = this.getTokenizer().getTokenColumn();
        while (this.match(null, Keyword.KW_catch)) {
            CatchClause catchClause = new CatchClause();
            this._symTable.pushScope();
            try {
                IType iIntrinsicType;
                String strIdentifier;
                this.verify((ParsedElement)tryCatchFinallyStmt, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_CATCH, new String[0]);
                this.match(null, Keyword.KW_var);
                int iOffset = this._tokenizer.getTokenStart();
                int iLineNum = this._tokenizer.getLineNumber();
                int iColumn = this.getTokenizer().getTokenColumn();
                if (this.verify((ParsedElement)tryCatchFinallyStmt, this.match(t, -5), Res.MSG_EXPECTING_IDENTIFIER_CATCH, new String[0])) {
                    catchClause.setNameOffset(iOffset, t._strValue);
                }
                LocalVarDeclaration localVarDecl = new LocalVarDeclaration((strIdentifier = t._strValue) == null ? "#err" : strIdentifier);
                if (this.match(null, ":", -6)) {
                    this.parseTypeLiteral();
                    TypeLiteral typeLiteral = (TypeLiteral)this.popExpression();
                    iIntrinsicType = typeLiteral.getType().getType();
                    this.verify((ParsedElement)typeLiteral, JavaTypes.THROWABLE().isAssignableFrom(iIntrinsicType) && !(iIntrinsicType instanceof ITypeVariableType) || iIntrinsicType instanceof IErrorType, Res.MSG_NOT_A_VALID_EXCEPTION_TYPE, iIntrinsicType.getName());
                } else {
                    if (!CommonServices.getEntityAccess().getLanguageLevel().supportsNakedCatchStatements()) {
                        this.warn((ParsedElement)localVarDecl, false, Res.MSG_EXPLICIT_TYPE_RECOMMENDED_FOR_CATCH_STMTS, new Object[0]);
                    }
                    iIntrinsicType = null;
                }
                this.pushExpression(localVarDecl);
                localVarDecl.setType((IType)(iIntrinsicType == null ? ErrorType.getInstance() : iIntrinsicType));
                this.setLocation(iOffset, iLineNum, iColumn, strIdentifier == null, false);
                this.popExpression();
                this.verify((ParsedElement)tryCatchFinallyStmt, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_CATCH, new String[0]);
                this.verify((ParsedElement)tryCatchFinallyStmt, this._symTable.getSymbol((CharSequence)strIdentifier) == null, Res.MSG_VARIABLE_ALREADY_DEFINED, strIdentifier);
                TypedSymbol symbol = new TypedSymbol(strIdentifier, (IType)(iIntrinsicType != null ? iIntrinsicType : JavaTypes.THROWABLE()), this._symTable, null, SymbolType.CATCH_VARIABLE);
                this._symTable.putSymbol((ISymbol)symbol);
                if (tryCatchFinallyStmt.getCatchStatements() != null) {
                    for (CatchClause c : tryCatchFinallyStmt.getCatchStatements()) {
                        IType currentCatchType;
                        IType earlierCatchType = c.getCatchType() != null ? c.getCatchType() : CatchClause.getNakedCatchExceptionType();
                        if (!earlierCatchType.isAssignableFrom(currentCatchType = iIntrinsicType != null ? iIntrinsicType : CatchClause.getNakedCatchExceptionType())) continue;
                        this.verify((ParsedElement)catchClause, false, Res.MSG_CATCH_STMT_CANNOT_EXECUTE, new String[0]);
                    }
                }
                if (this.verify((ParsedElement)tryCatchFinallyStmt, this.match(null, null, 123, true), Res.MSG_EXPECTING_LEFTBRACE_STMTBLOCK, new String[0])) {
                    this.parseStatement();
                    Statement catchStmt = this.popStatement();
                    catchClause.init(iIntrinsicType, catchStmt, symbol);
                    this.pushStatement(catchClause);
                    this.setLocation(iCatchOffset, iCatchLineNum, iCatchColumn);
                    this.popStatement();
                    tryCatchFinallyStmt.addCatchClause(catchClause);
                }
            }
            finally {
                this._symTable.popScope();
            }
            iCatchOffset = this._tokenizer.getTokenStart();
            iCatchLineNum = this._tokenizer.getLineNumber();
            iCatchColumn = this.getTokenizer().getTokenColumn();
        }
        if (this.match(null, Keyword.KW_finally)) {
            int originaliBreakOk = this._iBreakOk;
            this._iBreakOk = 0;
            int originaliContinueOk = this._iContinueOk;
            this._iContinueOk = 0;
            int originalReturnOk = this._iReturnOk;
            this._iReturnOk = 0;
            try {
                if (this.verify((ParsedElement)tryCatchFinallyStmt, this.match(null, null, 123, true), Res.MSG_EXPECTING_LEFTBRACE_STMTBLOCK, new String[0])) {
                    this.parseStatement();
                    Statement finallyStmt = this.popStatement();
                    tryCatchFinallyStmt.setFinallyStatement(finallyStmt);
                }
            }
            finally {
                this._iBreakOk = originaliBreakOk;
                this._iContinueOk = originaliContinueOk;
                this._iReturnOk = originalReturnOk;
            }
        }
        if (tryCatchFinallyStmt.getCatchStatements() == null && tryCatchFinallyStmt.getFinallyStatement() == null) {
            tryCatchFinallyStmt.addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_CATCH_OR_FINALLY_REQUIRED, new Object[0]));
        }
        this.pushStatement(tryCatchFinallyStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseIfStatement() {
        IfStatement ifStmt = new IfStatement();
        this.verify((ParsedElement)ifStmt, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_IF, new String[0]);
        this.parseExpression(ContextType.pBOOLEAN_FALSE);
        Expression e = this.popExpression();
        if (this.match(null, "=", -6)) {
            this.parseExpression();
            this.popExpression();
            this.verify((ParsedElement)ifStmt, false, Res.MSG_ASSIGNMENT_IN_IF_STATEMENT, new String[0]);
        }
        this.verify((ParsedElement)ifStmt, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_IF, new String[0]);
        this.getSymbolTable().pushScope();
        boolean statementParsed = false;
        try {
            this._ctxInferenceMgr.pushLastCtx();
            statementParsed = this.parseStatement();
        }
        finally {
            this.getSymbolTable().popScope();
            this._ctxInferenceMgr.popCtx(false);
        }
        this.verify((ParsedElement)ifStmt, statementParsed, Res.MSG_EXPECTING_STATEMENT, new String[0]);
        if (statementParsed) {
            Statement stmt = this.popStatement();
            ifStmt.setExpression(e);
            ifStmt.setStatement(stmt);
            this.match(null, 59);
            if (this.match(null, Keyword.KW_else)) {
                boolean elseStmtParsed;
                this.getSymbolTable().pushScope();
                try {
                    elseStmtParsed = this.parseStatement();
                }
                finally {
                    this.getSymbolTable().popScope();
                }
                this.verify((ParsedElement)ifStmt, elseStmtParsed, Res.MSG_EXPECTING_STATEMENT, new String[0]);
                if (elseStmtParsed) {
                    ifStmt.setElseStatement(this.popStatement());
                }
            }
        }
        this.pushStatement(ifStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseUsingStatement() {
        UsingStatement usingStmt = new UsingStatement();
        this.verify((ParsedElement)usingStmt, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_USING, new String[0]);
        this._symTable.pushScope();
        try {
            this.parseVarStatementsInUsingStatement(usingStmt);
            List<IVarStatement> varStatements = usingStmt.getVarStatements();
            for (IVarStatement vs : varStatements) {
                ((VarStatement)vs).setFinal(true);
                this.verify((ParsedElement)usingStmt, vs.getHasInitializer(), Res.MSG_VAR_MIGHT_NOT_HAVE_BEEN_INIT, vs.getSymbol().getName());
            }
            if (usingStmt.getVarStatements().isEmpty()) {
                this.parseExpression();
                Expression expr = this.popExpression();
                usingStmt.setExpression(expr);
                this.verifyTypeForUsingStatementPredicate(expr, expr.getType());
            }
            this.verify((ParsedElement)usingStmt, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_USING, new String[0]);
            if (this.verify((ParsedElement)usingStmt, this.match(null, null, 123, true), Res.MSG_EXPECTING_LEFTBRACE_STMTBLOCK, new String[0])) {
                this.parseStatement();
                usingStmt.setStatement(this.popStatement());
            }
            if (this.match(null, Keyword.KW_finally) && this.verify((ParsedElement)usingStmt, this.match(null, null, 123, true), Res.MSG_EXPECTING_LEFTBRACE_STMTBLOCK, new String[0])) {
                this.parseStatement();
                Statement finallyStmt = this.popStatement();
                usingStmt.setFinallyStatement(finallyStmt);
            }
            this.pushStatement(usingStmt);
        }
        finally {
            this._symTable.popScope();
        }
    }

    private void parseVarStatementsInUsingStatement(UsingStatement usingStmt) {
        int iLineNum;
        Token T = new Token();
        ArrayList<IVarStatement> varStmts = new ArrayList<IVarStatement>();
        do {
            int iOffset = this.getTokenizer().getTokenStart();
            iLineNum = this.getTokenizer().getLineNumber();
            int iColumn = this.getTokenizer().getTokenColumn();
            if (!this.match(null, Keyword.KW_var)) break;
            VarStatement varStmt = new VarStatement();
            int iNameOffset = this.getTokenizer().getTokenStart();
            if (this.verify((ParsedElement)varStmt, this.match(T, -5), Res.MSG_EXPECTING_IDENTIFIER_VAR, new String[0])) {
                varStmt.setNameOffset(iNameOffset, null);
            } else {
                T._strValue = null;
            }
            this.parseVarStatement(varStmt, T, false);
            this.setLocation(iOffset, iLineNum, iColumn);
            varStmt = (VarStatement)this.popStatement();
            this.verifyTypeForUsingStatementPredicate(varStmt, varStmt.getType());
            varStmts.add(varStmt);
        } while (this.match(null, 44));
        if (varStmts.size() > 0) {
            usingStmt.setVarStatements(varStmts);
            this.pushStatement(new NoOpStatement());
            this.setLocation(this.getTokenizer().getTokenStart(), iLineNum, this.getTokenizer().getTokenColumn(), true);
            this.popStatement();
        }
    }

    private void verifyTypeForUsingStatementPredicate(ParsedElement pe, IType type) {
        this.maybeRemoveIMonitorLockError(pe);
        boolean bAssignableFromUsingType = this.isAssignableFrom((IType)JavaTypes.LOCK(), type) || this.isAssignableFrom((IType)JavaTypes.getJreType(Closeable.class), type) || this.isAssignableFrom((IType)JavaTypes.getGosuType(IReentrant.class), type) || this.isAssignableFrom(GosuTypes.IDISPOSABLE(), type) || type == GosuTypes.IMONITORLOCK() || type.getTypeInfo().getMethod((CharSequence)"dispose", new IType[0]) != null || type.getTypeInfo().getMethod((CharSequence)"close", new IType[0]) != null || type.getTypeInfo().getMethod((CharSequence)"lock", new IType[0]) != null && type.getTypeInfo().getMethod((CharSequence)"unlock", new IType[0]) != null;
        this.verify(pe, bAssignableFromUsingType, Res.MSG_BAD_TYPE_FOR_USING_STMT, new String[0]);
    }

    private boolean isAssignableFrom(IType type1, IType type2) {
        return type1 != null && type1.isAssignableFrom(type2);
    }

    private void maybeRemoveIMonitorLockError(ParsedElement pe) {
        if (pe instanceof TypeAsExpression) {
            ParseTree after = pe.getLocation().getChildAfter(((TypeAsExpression)pe).getLHS().getLocation());
            if (after != null && after.getParsedElement() instanceof TypeLiteral) {
                after.getParsedElement().removeParseException(Res.MSG_IMONITOR_LOCK_SHOULD_ONLY_BE_USED_WITHIN_USING_STMTS);
            }
        } else if (pe instanceof VarStatement) {
            this.maybeRemoveIMonitorLockError(((VarStatement)pe).getAsExpression());
        } else if (pe instanceof ParenthesizedExpression) {
            this.maybeRemoveIMonitorLockError(((ParenthesizedExpression)pe).getExpression());
        }
    }

    private void parseStatementBlock() {
        this.parseStatementBlock(true);
    }

    private void parseStatementBlock(boolean bMatchClosingBrace) {
        this.parseStatementBlock(false, bMatchClosingBrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseStatementBlock(boolean forceKeepStmtBlock, boolean bMatchClosingBrace) {
        this._symTable.pushScope();
        if (!bMatchClosingBrace) {
            this.decStatementDepth();
        }
        try {
            ArrayList<Statement> statements = new ArrayList<Statement>();
            this.parseStatementsAndDetectUnreachable(statements);
            StatementList stmtList = new StatementList((IStackProvider)this._symTable);
            Token closingBraceToken = bMatchClosingBrace ? new Token() : null;
            this.verify((ParsedElement)stmtList, !bMatchClosingBrace || this.match(closingBraceToken, 125), Res.MSG_EXPECTING_RIGHTBRACE_STMTBLOCK, new String[0]);
            if (closingBraceToken != null) {
                stmtList.setLastLineNumber(closingBraceToken.getLine());
            }
            stmtList.setStatements(statements);
            boolean dontOptimizeStatementLists = forceKeepStmtBlock || this.isDontOptimizeStatementLists();
            this.pushStatement(dontOptimizeStatementLists ? stmtList : stmtList.getSelfOrSingleStatement());
        }
        finally {
            if (!bMatchClosingBrace) {
                this.incStatementDepth();
            }
            this._symTable.popScope();
        }
    }

    void parseNamespaceStatement() {
        if (this.isEditorParser()) {
            this.parseNamespaceStatement_editor();
        } else {
            this.parseNamespaceStatement_normal();
        }
    }

    void parseNamespaceStatement_editor() {
        NamespaceStatement namespaceStmt = new NamespaceStatement();
        this.parseExpression();
        Expression namespace = this.popExpression();
        namespace.clearParseExceptions();
        IGosuClassInternal gsClass = (IGosuClassInternal)this.getScriptPart().getContainingType();
        String strNamespace = namespace.toString();
        this.verify((ParsedElement)namespaceStmt, strNamespace.equals(gsClass.getNamespace()), Res.MSG_WRONG_NAMESPACE, strNamespace, gsClass.getNamespace());
        this.setNamespace(strNamespace);
        namespaceStmt.setNamespace(strNamespace);
        this.pushStatement(namespaceStmt);
        while (this.match(null, 59)) {
        }
    }

    void parseNamespaceStatement_normal() {
        String strNamespace;
        NamespaceStatement namespaceStmt = new NamespaceStatement();
        int mark = this.getTokenizer().mark();
        String strToken = null;
        if (this.verify((ParsedElement)namespaceStmt, this.match(null, -5), Res.MSG_EXPECTING_TYPELITERAL_OR_NAMESPACE, new String[0])) {
            strToken = this.getTokenizer().getTokenAt(mark).getStringValue();
        }
        strNamespace = (strNamespace = this.parseDotPathWord(strToken)) == null ? "" : strNamespace;
        IGosuClassInternal gsClass = (IGosuClassInternal)this.getScriptPart().getContainingType();
        this.verify((ParsedElement)namespaceStmt, strNamespace.equals(gsClass.getNamespace()), Res.MSG_WRONG_NAMESPACE, strNamespace, gsClass.getNamespace());
        this.setNamespace(strNamespace);
        namespaceStmt.setNamespace(strNamespace);
        this.pushStatement(namespaceStmt);
        while (this.match(null, 59)) {
        }
    }

    public UsesStatementList parseUsesStatementList(boolean bResolveUsesTypes) {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        int iUsesListOffset = iOffset;
        int iUsesListLineNum = iLineNum;
        if (this.match(null, Keyword.KW_uses, true)) {
            ArrayList<IUsesStatement> usesList = new ArrayList<IUsesStatement>();
            UsesStatementList stmtList = new UsesStatementList();
            stmtList.setUsesStatements(usesList);
            while (this.match(null, Keyword.KW_uses)) {
                this.getOwner().parseUsesStatement(bResolveUsesTypes);
                this.setLocation(iOffset, iLineNum, iColumn);
                UsesStatement stmt = (UsesStatement)this.popStatement();
                stmt.removeParseWarningRecursively(Res.MSG_DEPRECATED_MEMBER);
                IUsesStatement duplicate = stmtList.conflicts(stmt);
                if (duplicate != null && this.warn((ParsedElement)stmt, !duplicate.getTypeName().equals(stmt.getTypeName()), Res.MSG_USES_STMT_DUPLICATE, new Object[0])) {
                    this.verify((ParsedElement)stmt, false, Res.MSG_USES_STMT_CONFLICT, duplicate.getTypeName());
                }
                usesList.add(stmt);
                this.getOwner().checkInstruction(true);
                iOffset = this.getTokenizer().getTokenStart();
                iLineNum = this.getTokenizer().getLineNumber();
            }
            this.pushStatement(stmtList);
            this.setLocation(iUsesListOffset, iUsesListLineNum, iColumn, true);
            this.popStatement();
            return stmtList;
        }
        return null;
    }

    void parseUsesStatement() {
        this.parseUsesStatement(true);
    }

    void parseUsesStatement(boolean bResolveTypes) {
        if (this.isEditorParser()) {
            this.parseUsesStatement_editor(bResolveTypes);
        } else {
            this.parseUsesStatement_normal(bResolveTypes);
        }
    }

    void parseUsesStatement_editor(boolean bResolveTypes) {
        UsesStatement usesStmt = new UsesStatement();
        this.parseTypeLiteral();
        TypeLiteral typeLiteral = (TypeLiteral)this.popExpression();
        String t = typeLiteral.getType().getType() instanceof ErrorType && typeLiteral.getPackageExpression() != null ? typeLiteral.getPackageExpression().toString() : TypeLord.getPureGenericType(typeLiteral.getType().getType()).getName();
        boolean bForwardRefToInnerClass = this.getGosuClass() instanceof IGosuClassInternal && t != null && t.startsWith(this.getGosuClass().getName());
        this.verify((ParsedElement)usesStmt, t == null || !t.endsWith("]"), Res.MSG_BAD_NAMESPACE, t);
        if (!bForwardRefToInnerClass || ((IGosuClassInternal)this.getGosuClass()).isHeaderCompiled()) {
            if (t.endsWith("*") && this.match(null, "*", -6)) {
                typeLiteral.clearParseExceptions();
                usesStmt.setTypeName(t);
                if (this.verify((ParsedElement)usesStmt, t.endsWith(".*"), Res.MSG_BAD_NAMESPACE, t)) {
                    String namespace = t.substring(0, t.length() - 2);
                    INamespaceType type = TypeSystem.getNamespace((String)namespace);
                    if (type == null) {
                        type = TypeSystem.getByFullNameIfValid((String)namespace);
                    }
                    this.verify((ParsedElement)usesStmt, type != null, Res.MSG_BAD_NAMESPACE, namespace);
                }
                this.getTypeUsesMap().addToTypeUses((IUsesStatement)usesStmt);
            } else if (bResolveTypes) {
                String strTypeName = TypeLord.getPureGenericType(typeLiteral.getType().getType()).getName();
                usesStmt.setTypeName(strTypeName);
                if (typeLiteral.hasParseExceptions()) {
                    IParseIssue first = typeLiteral.getParseExceptions().get(0);
                    usesStmt.addParseException(first);
                    typeLiteral.removeParseException(first.getMessageKey());
                } else {
                    this.getTypeUsesMap().addToTypeUses((IUsesStatement)usesStmt);
                    ICompilableTypeInternal gsClass = this.getGosuClass();
                    if (gsClass != null) {
                        this.verify((ParsedElement)typeLiteral, !typeLiteral.getType().getType().getRelativeName().equals(gsClass.getRelativeName()), Res.MSG_SAME_NAME_AS_CLASS, gsClass.getRelativeName());
                    }
                }
            } else {
                usesStmt.setTypeName(t);
                this.getTypeUsesMap().addToTypeUses((IUsesStatement)usesStmt);
            }
        }
        this.pushStatement(usesStmt);
        while (this.match(null, 59)) {
        }
    }

    void parseUsesStatement_normal(boolean bResolveTypes) {
        boolean bForwardRefToInnerClass;
        UsesStatement usesStmt = new UsesStatement();
        int iOffset = this._tokenizer.getTokenStart();
        int iLineNum = this._tokenizer.getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        int mark = this.getTokenizer().mark();
        String t = "";
        if (this.verify((ParsedElement)usesStmt, this.match(null, -5), Res.MSG_EXPECTING_TYPELITERAL_OR_NAMESPACE, new String[0])) {
            t = this.getTokenizer().getTokenAt(mark).getStringValue();
        }
        t = this.parseDotPathWord(t);
        boolean bl = bForwardRefToInnerClass = this.getGosuClass() instanceof IGosuClassInternal && t != null && t.startsWith(this.getGosuClass().getName());
        if (!bForwardRefToInnerClass || ((IGosuClassInternal)this.getGosuClass()).isHeaderCompiled()) {
            IType type;
            if (this.match(null, "*", -6)) {
                usesStmt.setTypeName(t + "*");
                if (this.verify((ParsedElement)usesStmt, t.endsWith("."), Res.MSG_BAD_NAMESPACE, t)) {
                    String namespace = t.substring(0, t.length() - 1);
                    type = TypeSystem.getNamespace((String)namespace);
                    if (type == null) {
                        type = TypeSystem.getByFullNameIfValid((String)namespace);
                    }
                    this.verify((ParsedElement)usesStmt, type != null, Res.MSG_BAD_NAMESPACE, namespace);
                }
                this.getTypeUsesMap().addToTypeUses((IUsesStatement)usesStmt);
            } else if (bResolveTypes) {
                TypeLiteral typeLiteral = this.resolveTypeLiteral(t, false, false);
                this.pushExpression(typeLiteral);
                this.setLocation(iOffset, iLineNum, iColumn);
                this.popExpression();
                type = TypeLord.getPureGenericType(typeLiteral.getType().getType());
                String strTypeName = type.getName();
                usesStmt.setTypeName(strTypeName);
                if (typeLiteral.hasParseExceptions()) {
                    IParseIssue first = typeLiteral.getParseExceptions().get(0);
                    usesStmt.addParseException(first);
                    typeLiteral.removeParseException(first.getMessageKey());
                } else {
                    this.getTypeUsesMap().addToTypeUses((IUsesStatement)usesStmt);
                    ICompilableTypeInternal gsClass = this.getGosuClass();
                    if (gsClass != null) {
                        this.verify((ParsedElement)typeLiteral, !typeLiteral.getType().getType().getRelativeName().equals(gsClass.getRelativeName()), Res.MSG_SAME_NAME_AS_CLASS, gsClass.getRelativeName());
                    }
                }
            } else {
                usesStmt.setTypeName(t);
                this.getTypeUsesMap().addToTypeUses((IUsesStatement)usesStmt);
            }
        }
        this.pushStatement(usesStmt);
        while (this.match(null, 59)) {
        }
    }

    void parseCaseClauses(SwitchStatement switchStmt) {
        ArrayList<CaseClause> cases = new ArrayList<CaseClause>();
        while (this.parseCaseClause(switchStmt, cases)) {
        }
        switchStmt.setCases(cases.toArray(new CaseClause[cases.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean parseCaseClause(SwitchStatement switchStmt, List<CaseClause> cases) {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLine = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        if (!this.match(null, Keyword.KW_case)) {
            return false;
        }
        if (!cases.isEmpty()) {
            this.warnIfCaseNotTerminated(cases.get(cases.size() - 1).getStatements());
        }
        Expression switchExpr = switchStmt.getSwitchExpression();
        this.parseExpression(new ContextType(switchExpr.getType()));
        this.verify((ParsedElement)switchStmt, this.match(null, ":", -6), Res.MSG_EXPECTING_CASE_COLON, new String[0]);
        Expression e = this.popExpression();
        this.verifyCaseIsUnique(e, cases);
        boolean typeInferred = switchExpr instanceof TypeOfExpression && e instanceof TypeLiteral && this.isIsolatedCase(cases);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        CaseClause caseClause = new CaseClause(e, statements);
        cases.add(caseClause);
        if (typeInferred) {
            IType caseExprType = (IType)e.evaluate();
            Expression typeOfExpr = ((TypeOfExpression)switchExpr).getExpression();
            typeInferred = this.checkComparableAndCastable(typeOfExpr, e);
            if (this.verify((ParsedElement)e, typeInferred, Res.MSG_TYPE_MISMATCH, typeOfExpr.getType().getDisplayName(), caseExprType.getDisplayName())) {
                TypeOfExpression toe = (TypeOfExpression)switchExpr;
                this._ctxInferenceMgr.pushCtx();
                this._ctxInferenceMgr.updateType(toe.getExpression(), caseExprType);
            }
        }
        this._symTable.pushScope();
        boolean typeInferenceCancelled = false;
        try {
            Statement stmt = null;
            while (true) {
                if (this.match(null, Keyword.KW_case, true) || this.match(null, Keyword.KW_default, true)) {
                    if (typeInferred) {
                        this._ctxInferenceMgr.popCtx(false);
                        typeInferenceCancelled = true;
                    }
                    break;
                }
                if (!this.parseStatement()) {
                    break;
                }
                stmt = this.popStatementAndDetectUnreachable(stmt, statements);
            }
        }
        finally {
            this._symTable.popScope();
            if (typeInferred && !typeInferenceCancelled) {
                this._ctxInferenceMgr.popCtx(false);
            }
        }
        this.pushExpression(caseClause);
        this.setLocation(iOffset, iLine, iColumn, true);
        this.popExpression();
        return true;
    }

    private void verifyCaseIsUnique(Expression e, List<CaseClause> cases) {
        Object value;
        if (e.getType() instanceof IErrorType || !e.isCompileTimeConstant() && !(e instanceof Literal)) {
            if (e instanceof ImplicitTypeAsExpression) {
                this.verifyCaseIsUnique(((ImplicitTypeAsExpression)e).getLHS(), cases);
            }
            return;
        }
        try {
            value = e.evaluate();
            if (value == null && e instanceof TypeAsExpression) {
                return;
            }
        }
        catch (Exception err) {
            return;
        }
        for (CaseClause cc : cases) {
            Object csr;
            Expression expr = cc.getExpression();
            if (expr instanceof ImplicitTypeAsExpression) {
                expr = ((ImplicitTypeAsExpression)expr).getLHS();
            }
            if (expr == null || expr.hasParseExceptions() || !expr.isCompileTimeConstant() && !(expr instanceof Literal)) continue;
            try {
                csr = expr.evaluate();
            }
            catch (Exception err) {
                continue;
            }
            this.verify((ParsedElement)e, !GosuObjectUtil.equals((Object)csr, (Object)value), Res.MSG_DUPLICATE_CASE_EXPRESSION, new String[0]);
        }
    }

    private boolean isIsolatedCase(List<CaseClause> cases) {
        int i;
        if (cases.isEmpty()) {
            return true;
        }
        CaseClause caseClause = cases.get(cases.size() - 1);
        List<Statement> statements = caseClause.getStatements();
        for (i = statements.size() - 1; i >= 0 && statements.get(i) instanceof NoOpStatement; --i) {
        }
        if (i >= 0) {
            boolean[] bAbsolute = new boolean[]{false};
            return statements.get(i).getLeastSignificantTerminalStatement(bAbsolute) != null && bAbsolute[0];
        }
        return false;
    }

    private void warnIfCaseNotTerminated(List<Statement> statements) {
        int i;
        for (i = statements.size() - 1; i >= 0 && statements.get(i) instanceof NoOpStatement; --i) {
        }
        if (i >= 0) {
            Statement lastStmt = statements.get(i);
            boolean[] bAbsolute = new boolean[]{false};
            this.verifyOrWarn(lastStmt, lastStmt.hasParseExceptions() || lastStmt.getLeastSignificantTerminalStatement(bAbsolute) != null && bAbsolute[0], true, Res.MSG_NONTERMINAL_CASE_CLAUSE, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean parseDefaultClause(SwitchStatement switchStmt, List<CaseClause> cases) {
        if (!this.match(null, Keyword.KW_default)) {
            return false;
        }
        if (cases.size() > 0) {
            this.warnIfCaseNotTerminated(cases.get(cases.size() - 1).getStatements());
        }
        this.verify((ParsedElement)switchStmt, this.match(null, ":", -6), Res.MSG_EXPECTING_CASE_COLON, new String[0]);
        this.verify((ParsedElement)switchStmt, switchStmt.getDefaultStatements() == null, Res.MSG_MULTIPLE_DEFAULT_CLAUSES_NOT_PERMITTED, new String[0]);
        this._symTable.pushScope();
        try {
            ArrayList<Statement> defaultStatements = new ArrayList<Statement>();
            this.parseStatementsAndDetectUnreachable(defaultStatements);
            switchStmt.setDefaultStatements(defaultStatements);
        }
        finally {
            this._symTable.popScope();
        }
        return true;
    }

    void checkInstruction(boolean bProcessDirectives) {
        this.checkUnexpectedEof();
        while (!this._tokenizer.isEOF() && (this._tokenizer.isAnalyzingSeparately() || this._tokenizer.isAnalyzingDirective())) {
            if (this._tokenizer.isAnalyzingDirective()) {
                this.parseDirective(bProcessDirectives);
                continue;
            }
            if (this.getGosuClass() instanceof IGosuClass && ((CompilationState)((IGosuClass)this.getGosuClass()).getCompilationState()).isReparsingHeader()) break;
            int iOffset = this._tokenizer.getTokenStart();
            this.parseExpression();
            Expression e = this.popExpression();
            this.clearExpressionInTemplateUnlessParsingEvaluateFunctionBody(e);
            if (iOffset != this._tokenizer.getTokenStart()) continue;
            break;
        }
    }

    private void checkUnexpectedEof() {
        if (this._tokenizer.isEOF() && this._tokenizer.isAnalyzingSeparately() && this.getGosuClass() != null) {
            ((ParsedElement)this.getGosuClass().getClassStatement()).addParseException(this.makeFullParserState(), Res.MSG_UNEXPECTED_EOF, new Object[0]);
        }
    }

    private void clearExpressionInTemplateUnlessParsingEvaluateFunctionBody(Expression e) {
        if (!this.isParsingProgram() && this.getGosuClass() instanceof IGosuClass && ((IGosuClass)this.getGosuClass()).getCompilationState().isDeclarationsCompiled() && !((CompilationState)((IGosuClass)this.getGosuClass()).getCompilationState()).isReparsingHeader() && (!this.isParsingFunction() || this.getProgramEntryPointDfs() != null && !this.peekParsingFunction().equals((Object)this.getProgramEntryPointDfs().getType()))) {
            e.clearParseExceptions();
            this.removeLocation(e.getLocation());
            this.removeInnerClasses(e);
        }
    }

    private void removeInnerClasses(IParsedElement e) {
        IGosuClassInternal anon;
        if (e == null) {
            return;
        }
        if (e instanceof BlockExpression) {
            IBlockClass blockGosuClass = ((BlockExpression)e).getBlockGosuClass();
            if (blockGosuClass != null && blockGosuClass.getEnclosingType() != null) {
                ICompilableTypeInternal enclosingType = (ICompilableTypeInternal)blockGosuClass.getEnclosingType();
                enclosingType.removeBlock(blockGosuClass);
            }
        } else if (e instanceof NewExpression && ((NewExpression)e).isAnonymousClass() && (anon = (IGosuClassInternal)((Expression)e).getType()) != null) {
            ((IGosuClassInternal)anon.getEnclosingType()).removeInnerClass(anon);
        }
        IParseTree location = e.getLocation();
        if (location != null) {
            for (IParseTree pt : location.getChildren()) {
                this.removeInnerClasses(pt.getParsedElement());
            }
        }
    }

    private void removeLocation(ParseTree location) {
        if (location.getParent() != null) {
            location.getParent().removeChild((IParseTree)location);
        }
        this.getLocationsList().remove(location);
    }

    private void parseDirective(boolean processDirectives) {
        Token token = this._tokenizer.getCurrentToken();
        int iOffset = token.getTokenStart();
        int iLineNum = token.getLine();
        int iColumn = token.getTokenColumn();
        DirectiveExpression e = new DirectiveExpression();
        if (Keyword.KW_extends == token.getKeyword()) {
            IType extendsType;
            this._tokenizer.nextToken();
            this.parseTypeLiteral();
            Expression typeLiteral = this.peekExpression();
            if (typeLiteral instanceof TypeLiteral && (extendsType = ((TypeLiteral)typeLiteral).getType().getType()) instanceof IGosuClassInternal) {
                IGosuClassInternal supertype = (IGosuClassInternal)extendsType;
                supertype.putClassMembers(this, this._symTable, supertype, true);
                List typeLoaders = TypeSystem.getCurrentModule().getTypeLoaders(GosuClassTypeLoader.class);
                for (GosuClassTypeLoader gosuClassTypeLoader : typeLoaders) {
                    List enhancementsForType = gosuClassTypeLoader.getEnhancementIndex().getEnhancementsForType((IType)supertype);
                    for (IGosuEnhancement enhancement : enhancementsForType) {
                        if (!(enhancement instanceof IGosuEnhancementInternal)) continue;
                        ((IGosuEnhancementInternal)enhancement).putClassMembers(this, this._symTable, supertype, true);
                    }
                }
                for (Object object : this._symTable.getSymbols().entrySet()) {
                    Map.Entry entry = (Map.Entry)object;
                    if (!((ISymbol)entry.getValue()).isPrivate()) continue;
                    this._symTable.removeSymbol((CharSequence)entry.getKey());
                }
            }
        } else if ("params".equals(token.getStringValue())) {
            this._tokenizer.nextToken();
            this.verify((ParsedElement)e, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_FUNCTION_DEF, new String[0]);
            ArrayList<ISymbol> params = this.parseParameterDeclarationList(e, false, null);
            if (processDirectives) {
                for (ISymbol param : params) {
                    this.getSymbolTable().putSymbol(param);
                }
            }
            this.verify((ParsedElement)e, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_FUNCTION_DEF, new String[0]);
        } else {
            this.advanceToNextTokenSilently();
            e.addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_BAD_TEMPLATE_DIRECTIVE, new Object[0]));
        }
        this.pushExpression(e);
        this.setLocation(iOffset, iLineNum, iColumn);
        this.popExpression();
    }

    boolean parseAssignmentOrMethodCall() {
        boolean bRet = true;
        Token token = this.getTokenizer().getCurrentToken();
        switch (token.getType()) {
            case -7: 
            case -5: 
            case 34: 
            case 40: {
                break;
            }
            default: {
                return false;
            }
        }
        int initialMark = this._tokenizer.mark();
        this.parsePrimaryExpression();
        Expression e = this.popExpression();
        if (e instanceof NewExpression) {
            NewStatement stmt = new NewStatement();
            stmt.setNewExpression((NewExpression)e);
            this.pushStatement(stmt);
        } else if (e instanceof MethodCallExpression) {
            MethodCallStatement stmt = new MethodCallStatement();
            stmt.setMethodCall((MethodCallExpression)e);
            this.pushStatement(stmt);
            e.removeParseException(Res.MSG_VOID_EXPRESSION_NOT_ALLOWED);
        } else if (e instanceof BeanMethodCallExpression) {
            BeanMethodCallStatement stmt = new BeanMethodCallStatement();
            stmt.setBeanMethodCall((BeanMethodCallExpression)e);
            this.pushStatement(stmt);
            e.removeParseException(Res.MSG_VOID_EXPRESSION_NOT_ALLOWED);
        } else if (e instanceof IBlockInvocation) {
            this.pushStatement(new BlockInvocationStatement((IBlockInvocation)e));
            e.removeParseException(Res.MSG_VOID_EXPRESSION_NOT_ALLOWED);
        } else if (e instanceof Identifier || e instanceof ImplicitTypeAsExpression && ((ImplicitTypeAsExpression)e).getLHS() instanceof Identifier) {
            Statement statement;
            String assignOp = this.matchAssignmentOperator();
            if (assignOp != null) {
                IType settersOwningType;
                DynamicPropertySymbol symbol;
                DynamicFunctionSymbol setter;
                ISymbol idSym;
                Identifier id;
                if (e instanceof ImplicitTypeAsExpression) {
                    id = (Identifier)((ImplicitTypeAsExpression)e).getLHS();
                    IParsedElement parent = ContextInferenceManager.unwrapImplicitTypeAs(((ImplicitTypeAsExpression)e).getLHS());
                    this._locations.remove(e.getLocation());
                    if (parent == null) {
                        this._locations.add(id.getLocation());
                    }
                } else {
                    id = (Identifier)e;
                }
                AssignmentStatement as = new AssignmentStatement();
                statement = as;
                as.setIdentifier(id);
                boolean incrOrDecr = "++".equals(assignOp) || "--".equals(assignOp);
                Expression rhs = this.parseAssignmentRhs(assignOp, e.getType(), e);
                rhs = this.buildRhsOfCompoundOperator(e, assignOp, rhs);
                if (rhs.hasParseExceptions()) {
                    rhs.getParseExceptions().get(0).setExpectedType(id.getType());
                }
                this.verify((ParsedElement)as, (idSym = id.getSymbol()).isWritable() || idSym.isFinal() && !idSym.isStatic() && !(idSym instanceof CapturedSymbol) && (idSym.isLocal() && !((Symbol)idSym).isImplicitlyInitialized() || (this.isParsingConstructor() || this.isParsingProgramEvaluateMethod()) && this.isSymbolInScopeDirectly(idSym)), Res.MSG_PROPERTY_NOT_WRITABLE, idSym.getDisplayName());
                if (id instanceof PropertyAccessIdentifier && (setter = (symbol = (DynamicPropertySymbol)idSym).getSetterDfs()) != null && setter.getScriptPart() != null && (settersOwningType = setter.getScriptPart().getContainingType()) instanceof IGosuClassInternal) {
                    IGosuClassInternal ctxClass;
                    IGosuClassInternal settersOwningClass = (IGosuClassInternal)settersOwningType;
                    ICompilableTypeInternal ctxType = this.getGosuClass();
                    if (ctxType instanceof IGosuClassInternal && !settersOwningClass.isAccessible(ctxClass = (IGosuClassInternal)ctxType, setter)) {
                        id.addParseException(Res.MSG_PROPERTY_NOT_VISIBLE, idSym.getDisplayName());
                    }
                }
                if (rhs instanceof Identifier) {
                    DynamicPropertySymbol dps;
                    Identifier identifier = (Identifier)rhs;
                    if (idSym != null && idSym.equals(identifier.getSymbol())) {
                        as.addParseWarning((IParseIssue)new ParseWarning((IParserState)this.makeFullParserState(), Res.MSG_SILLY_ASSIGNMENT, new Object[]{idSym.getName()}));
                    }
                    if (identifier.getSymbol() instanceof DynamicPropertySymbol && (dps = (DynamicPropertySymbol)identifier.getSymbol()).getVarIdentifier() != null && dps.getVarIdentifier().equals(idSym.getName())) {
                        as.addParseWarning((IParseIssue)new ParseWarning((IParserState)this.makeFullParserState(), Res.MSG_SILLY_ASSIGNMENT, new Object[]{idSym.getName()}));
                    }
                }
                e.removeParseException(Res.MSG_CANNOT_READ_A_WRITE_ONLY_PROPERTY);
                this._ctxInferenceMgr.cancelInferences(id, rhs);
                if (!(incrOrDecr && this.isPrimitiveOrBoxedIntegerType(rhs.getType()) && this.isPrimitiveOrBoxedIntegerType(id.getType()))) {
                    this.verifyComparable(id.getType(), rhs);
                }
                rhs = this.possiblyWrapWithImplicitCoercion(rhs, id.getType());
                as.setExpression(rhs);
            } else {
                NotAStatement nas;
                statement = nas = new NotAStatement();
                nas.setExpression(e);
                this.verify((ParsedElement)nas, false, Res.MSG_NOT_A_STATEMENT, new String[0]);
            }
            this.pushStatement(statement);
        } else if (e instanceof ParenthesizedExpression) {
            NotAStatement nas = new NotAStatement();
            nas.setExpression(e);
            this.verify((ParsedElement)nas, false, Res.MSG_EXPECTING_OPERATOR_TO_FOLLOW_EXPRESSION, new String[0]);
            this.pushStatement(nas);
        } else if (e instanceof SynthesizedMemberAccess) {
            SyntheticMemberAccessStatement stmt = new SyntheticMemberAccessStatement((ISynthesizedMemberAccessExpression)e);
            this.pushStatement(stmt);
        } else if (e instanceof MemberAccess || e instanceof ImplicitTypeAsExpression && ((ImplicitTypeAsExpression)e).getLHS() instanceof MemberAccess) {
            MemberAccess ma;
            MemberAssignmentStatement as = new MemberAssignmentStatement();
            if (e instanceof ImplicitTypeAsExpression) {
                ma = (MemberAccess)((ImplicitTypeAsExpression)e).getLHS();
                IParsedElement parent = ContextInferenceManager.unwrapImplicitTypeAs(((ImplicitTypeAsExpression)e).getLHS());
                this._locations.remove(e.getLocation());
                if (parent == null) {
                    this._locations.add(ma.getLocation());
                }
            } else {
                ma = (MemberAccess)e;
            }
            IType typeExpected = ma.getType();
            String assignOp = this.matchAssignmentOperator();
            if (this.verify((ParsedElement)as, assignOp != null, Res.MSG_EXPECTING_EQUALS_ASSIGN, new String[0])) {
                IPropertyInfo lhsPi;
                try {
                    if (ma.getMemberName() != null) {
                        this.verifyPropertyWritable(ma.getRootType(), ma.getMemberName(), false);
                    }
                }
                catch (Exception ex) {
                    ma.addParseException((IParseIssue)ParseException.wrap((Throwable)ex, (IParserState)this.makeFullParserState()));
                }
                Expression rhs = this.parseAssignmentRhs(assignOp, typeExpected, e);
                this._ctxInferenceMgr.cancelInferences(ma, rhs);
                typeExpected = ma.getType();
                if (!(typeExpected instanceof ErrorType) && (lhsPi = ma.getPropertyInfo()) instanceof IJavaPropertyInfo && ((IJavaPropertyInfo)lhsPi).getWriteMethodInfo() == null && ((IJavaPropertyInfo)lhsPi).getPublicField() != null) {
                    typeExpected = TypeSystem.get((IJavaClassInfo)((IJavaPropertyInfo)lhsPi).getPublicField().getType());
                }
                this.verifyComparable(typeExpected, rhs);
                rhs = this.buildRhsOfCompoundOperator(e, assignOp, rhs);
                if (rhs.hasParseExceptions()) {
                    rhs.getParseExceptions().get(0).setExpectedType(typeExpected);
                }
                rhs = this.possiblyWrapWithImplicitCoercion(rhs, typeExpected);
                as.setExpression(rhs);
                as.setCompoundStatement(!"=".equals(assignOp));
            }
            ma.removeParseException(Res.MSG_CANNOT_READ_A_WRITE_ONLY_PROPERTY);
            as.setRootExpression(ma.getRootExpression());
            as.setMemberName(ma.getMemberName());
            as.setMemberExpression(ma.getMemberExpression());
            as.setMemberAccess(ma);
            this.pushStatement(as);
        } else if (e instanceof ArrayAccess) {
            Statement statement;
            ArrayAccess aa = (ArrayAccess)e;
            IType typeExpected = aa.getComponentType();
            Token T = new Token();
            ArrayAssignmentStatement as = new ArrayAssignmentStatement();
            String assignOp = this.matchAssignmentOperator();
            if (this.verify((ParsedElement)as, assignOp != null, Res.MSG_EXPECTING_EQUALS_ASSIGN, new String[0])) {
                IType type = aa.getRootExpression().getType();
                this.verify((ParsedElement)as, type != JavaTypes.STRING() && (!JavaTypes.CHAR_SEQUENCE().isAssignableFrom(type) || JavaTypes.STRING_BUILDER().isAssignableFrom(type) || JavaTypes.STRING_BUFFER().isAssignableFrom(type)), Res.MSG_STR_IMMUTABLE, new String[0]);
                Expression rhs = this.parseAssignmentRhs(assignOp, typeExpected, aa);
                this.verifyComparable(typeExpected, rhs);
                rhs = this.buildRhsOfCompoundOperator(e, assignOp, rhs);
                rhs = this.possiblyWrapWithImplicitCoercion(rhs, typeExpected);
                as.setExpression(rhs);
                as.setArrayAccessExpression(aa);
                as.setCompoundStatement(!"=".equals(T._strValue));
                statement = as;
            } else {
                NotAStatement nas;
                statement = nas = new NotAStatement();
                nas.setExpression(aa);
                this.verify((ParsedElement)nas, false, Res.MSG_NOT_A_STATEMENT, new String[0]);
            }
            this.pushStatement(statement);
        } else if (e instanceof MapAccess) {
            Statement statement;
            MapAccess ma = (MapAccess)e;
            IType typeExpected = ma.getComponentType();
            Token T = new Token();
            MapAssignmentStatement as = new MapAssignmentStatement();
            String assignOp = this.matchAssignmentOperator();
            if (this.verify((ParsedElement)as, assignOp != null, Res.MSG_EXPECTING_EQUALS_ASSIGN, new String[0])) {
                Expression rhs = this.parseAssignmentRhs(assignOp, typeExpected, e);
                this.verifyComparable(typeExpected, rhs);
                rhs = this.buildRhsOfCompoundOperator(e, assignOp, rhs);
                rhs = this.possiblyWrapWithImplicitCoercion(rhs, ma.getComponentType());
                as.setExpression(rhs);
                as.setMapAccessExpression(ma);
                as.setCompoundStatement(!"=".equals(T._strValue));
                statement = as;
            } else {
                NotAStatement nas;
                statement = nas = new NotAStatement();
                nas.setExpression(ma);
                this.verify((ParsedElement)nas, false, Res.MSG_NOT_A_STATEMENT, new String[0]);
            }
            this.pushStatement(statement);
        } else if (e instanceof FeatureLiteral) {
            NotAStatement nas = new NotAStatement();
            nas.setExpression(e);
            this.verify((ParsedElement)nas, false, Res.MSG_NOT_A_STATEMENT, new String[0]);
            this.pushStatement(nas);
        } else {
            this._tokenizer.restoreToMark(initialMark);
            this._locations.remove(e.getLocation());
            bRet = false;
        }
        return bRet;
    }

    private boolean isParsingProgramEvaluateMethod() {
        return this.isParsingFunction() && this.getProgramEntryPointDfs() != null && this.peekParsingFunction().equals((Object)this.getProgramEntryPointDfs().getType());
    }

    private boolean isSymbolInScopeDirectly(ISymbol idSym) {
        if (!(idSym instanceof DynamicSymbol)) {
            return true;
        }
        DynamicSymbol fieldSym = (DynamicSymbol)idSym;
        IGosuClassInternal declaringClass = fieldSym.getGosuClass();
        return this.getGosuClass() == declaringClass && !this.isParsingBlock();
    }

    private Expression parseAssignmentRhs(String operation, IType typeExpected, Expression lhs) {
        Expression rhs;
        if ("++".equals(operation) || "--".equals(operation)) {
            AdditiveExpression add = new AdditiveExpression();
            add.setLHS(lhs);
            Expression one = new NumericLiteral("1", 1, (IType)JavaTypes.pINT());
            IType type = this.resolveTypeForArithmeticExpression(lhs, lhs.getType(), operation, lhs.getType());
            this.pushExpression(one);
            this.setLocation(lhs.getLocation().getExtent() + 1, lhs.getLineNum(), lhs.getLocation().getColumn() + 1);
            this.popExpression();
            one = this.possiblyWrapWithImplicitCoercion(one, type);
            add.setRHS(one);
            add.setOperator("++".equals(operation) ? "+" : "-");
            add.setType(type);
            this.pushExpression(add);
            this.setLocation(lhs.getLocation().getOffset(), lhs.getLineNum(), lhs.getLocation().getColumn() + 1);
            this.popExpression();
            rhs = add;
        } else {
            this.parseExpression(new ContextType(typeExpected), false);
            rhs = this.popExpression();
            this.detectLikelyJavaCast(rhs);
        }
        return rhs;
    }

    private Expression buildRhsOfCompoundOperator(Expression lhs, String assignOp, Expression rhs) {
        Expression or;
        Expression and;
        Expression synthetic = null;
        if ("+=".equals(assignOp) || "-=".equals(assignOp)) {
            AdditiveExpression add = new AdditiveExpression();
            add.setLHS(lhs);
            add.setRHS(rhs);
            add.setOperator(assignOp.charAt(0) == '+' ? "+" : "-");
            add.setType(this.resolveTypeForArithmeticExpression(add, lhs.getType(), assignOp, rhs.getType()));
            synthetic = add;
        } else if ("*=".equals(assignOp) || "/=".equals(assignOp) || "%=".equals(assignOp)) {
            MultiplicativeExpression mult = new MultiplicativeExpression();
            mult.setLHS(lhs);
            mult.setRHS(rhs);
            mult.setOperator(String.valueOf(assignOp.charAt(0)));
            mult.setType(this.resolveTypeForArithmeticExpression(mult, lhs.getType(), assignOp, rhs.getType()));
            synthetic = mult;
        } else if ("&=".equals(assignOp)) {
            and = new BitwiseAndExpression();
            lhs = this.ensureOperandIntOrLong(lhs);
            rhs = this.ensureOperandIntOrLong(rhs);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, lhs.getType());
            ((ArithmeticExpression)and).setLHS(lhs);
            ((ArithmeticExpression)and).setRHS(rhs);
            and.setType(this.resolveTypeForArithmeticExpression(and, lhs.getType(), assignOp, rhs.getType()));
            synthetic = and;
        } else if ("&&=".equals(assignOp)) {
            and = new ConditionalAndExpression();
            this.verifyComparable((IType)JavaTypes.pBOOLEAN(), rhs, true, true);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, (IType)JavaTypes.pBOOLEAN());
            this.verifyComparable((IType)JavaTypes.pBOOLEAN(), lhs, true, true);
            lhs = this.possiblyWrapWithImplicitCoercion(lhs, (IType)JavaTypes.pBOOLEAN());
            ((BinaryExpression)and).setLHS(lhs);
            ((BinaryExpression)and).setRHS(rhs);
            synthetic = and;
        } else if ("^=".equals(assignOp)) {
            BitwiseXorExpression xor = new BitwiseXorExpression();
            lhs = this.ensureOperandIntOrLong(lhs);
            rhs = this.ensureOperandIntOrLong(rhs);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, lhs.getType());
            xor.setLHS(lhs);
            xor.setRHS(rhs);
            xor.setType(this.resolveTypeForArithmeticExpression(xor, lhs.getType(), assignOp, rhs.getType()));
            synthetic = xor;
        } else if ("|=".equals(assignOp)) {
            or = new BitwiseOrExpression();
            lhs = this.ensureOperandIntOrLong(lhs);
            rhs = this.ensureOperandIntOrLong(rhs);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, lhs.getType());
            ((ArithmeticExpression)or).setLHS(lhs);
            ((ArithmeticExpression)or).setRHS(rhs);
            or.setType(this.resolveTypeForArithmeticExpression(or, lhs.getType(), assignOp, rhs.getType()));
            synthetic = or;
        } else if ("||=".equals(assignOp)) {
            or = new ConditionalOrExpression();
            this.verifyComparable((IType)JavaTypes.pBOOLEAN(), rhs, true, true);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, (IType)JavaTypes.pBOOLEAN());
            this.verifyComparable((IType)JavaTypes.pBOOLEAN(), lhs, true, true);
            lhs = this.possiblyWrapWithImplicitCoercion(lhs, (IType)JavaTypes.pBOOLEAN());
            ((BinaryExpression)or).setLHS(lhs);
            ((BinaryExpression)or).setRHS(rhs);
            synthetic = or;
        } else if ("<<=".equals(assignOp) || ">>=".equals(assignOp) || ">>>=".equals(assignOp)) {
            BitshiftExpression shift = new BitshiftExpression();
            this.verifyTypesComparable(rhs, (IType)JavaTypes.pINT(), rhs.getType(), false, true);
            rhs = this.possiblyWrapWithImplicitCoercion(rhs, (IType)JavaTypes.pINT());
            IType lhsType = lhs.getType();
            if (this.verify((ParsedElement)lhs, lhsType == JavaTypes.LONG() || lhsType == JavaTypes.pLONG() || lhsType == JavaTypes.INTEGER() || lhsType == JavaTypes.pINT() || lhsType == JavaTypes.SHORT() || lhsType == JavaTypes.pSHORT() || lhsType == JavaTypes.BYTE() || lhsType == JavaTypes.pBYTE(), Res.MSG_BITSHIFT_LHS_MUST_BE_INT_OR_LONG, new String[0])) {
                lhsType = lhsType == JavaTypes.LONG() || lhsType == JavaTypes.pLONG() ? JavaTypes.pLONG() : JavaTypes.pINT();
                lhs = this.possiblyWrapWithImplicitCoercion(lhs, lhsType);
            }
            shift.setLHS(lhs);
            shift.setRHS(rhs);
            shift.setOperator(assignOp);
            shift.setType(this.resolveTypeForArithmeticExpression(shift, lhs.getType(), assignOp, rhs.getType()));
            synthetic = shift;
        }
        if (synthetic != null) {
            this.pushExpression(synthetic);
            ParseTree rhsLoc = rhs.getLocation();
            this.setLocation(rhsLoc.getOffset(), rhs.getLineNum(), rhsLoc.getColumn(), true);
            this.popExpression();
            rhs = synthetic;
        }
        return rhs;
    }

    private String matchAssignmentOperator() {
        Token token = this.getTokenizer().getCurrentToken();
        if (token.getType() == -6) {
            String value;
            switch (value = token.getStringValue()) {
                case "=": 
                case "+=": 
                case "-=": 
                case "++": 
                case "--": 
                case "*=": 
                case "%=": 
                case "/=": 
                case "&=": 
                case "&&=": 
                case "^=": 
                case "|=": 
                case "||=": 
                case "<<=": {
                    this.getTokenizer().nextToken();
                    return value;
                }
            }
            return this.matchRightShiftAssign();
        }
        return null;
    }

    private String matchRightShiftAssign() {
        int mark = this.getTokenizer().mark();
        if (this.match(null, ">", -6)) {
            if (this.match(null, ">", -6)) {
                if (this.match(null, ">", -6)) {
                    if (this.match(null, "=", -6)) {
                        return ">>>=";
                    }
                } else if (this.match(null, "=", -6)) {
                    return ">>=";
                }
            }
            this.getTokenizer().restoreToMark(mark);
        }
        return null;
    }

    ISymbol parseFunctionOrPropertyDeclaration(ParsedElement element, boolean bParseProperties, boolean bParseVars) {
        while (true) {
            if (this.match(null, Keyword.KW_uses)) {
                this.parseUsesStatement();
                this.popStatement();
                continue;
            }
            ModifierInfo modifiers = this.parseModifiers();
            if (this.match(null, Keyword.KW_function)) {
                DynamicFunctionSymbol symbol = this.parseFunctionDecl(element, modifiers);
                this.eatStatementBlock(symbol != null && symbol.getDeclFunctionStmt() != null ? symbol.getDeclFunctionStmt() : element, Res.MSG_EXPECTING_OPEN_BRACE_FOR_FUNCTION_DEF);
                return symbol;
            }
            if (bParseProperties && this.match(null, Keyword.KW_property)) {
                boolean bGetter = this.match(null, Keyword.KW_get);
                boolean bSetter = this.match(null, Keyword.KW_set);
                if (bGetter || bSetter) {
                    FunctionStatement fs = new FunctionStatement();
                    DynamicFunctionSymbol dfs = this.getOwner().parseFunctionDecl(fs, true, bGetter, modifiers);
                    if (dfs == null) {
                        element.addParseException((IParseIssue)new ParseException((IParserState)this.makeFullParserState(), Res.MSG_EXPECTING_DECL, new Object[0]));
                        return null;
                    }
                    fs.setDynamicFunctionSymbol(dfs);
                    this.pushStatement(fs);
                    dfs.setClassMember(true);
                    this.eatStatementBlock(fs, Res.MSG_EXPECTING_OPEN_BRACE_FOR_FUNCTION_DEF);
                    DynamicPropertySymbol dps = this.getOrCreateDynamicPropertySymbol(element, null, dfs, bGetter);
                    dps.setClassMember(false);
                    return dps;
                }
            }
            if (bParseVars && this.match(null, Keyword.KW_var)) {
                VarStatement var = new VarStatement();
                Token T = new Token();
                if (!this.verify((ParsedElement)var, this.match(T, -5), Res.MSG_EXPECTING_IDENTIFIER_VAR, new String[0])) {
                    T._strValue = null;
                }
                this.parseVarStatement(var, T, false);
                return var.getSymbol();
            }
            if (this.match(null, -1)) {
                return null;
            }
            this._tokenizer.nextToken();
        }
    }

    boolean parsePropertyDefinition() {
        if (this.isParsingBlock()) {
            return false;
        }
        ModifierInfo modifiers = this.parseModifiers();
        Token token = this.getTokenizer().getCurrentToken();
        if (Keyword.KW_property == token.getKeyword()) {
            this.getTokenizer().nextToken();
            boolean bGetter = this.match(null, Keyword.KW_get);
            boolean bSetter = !bGetter && this.match(null, Keyword.KW_set);
            token = this.getTokenizer().getCurrentToken();
            int iOffset = token.getTokenStart();
            int iLineNum = token.getLine();
            int iColumn = token.getTokenColumn();
            FunctionStatement functionStmt = this.parseBaseFunctionDefinition(null, true, bGetter, modifiers);
            this.verify((ParsedElement)functionStmt, bGetter || bSetter, Res.MSG_EXPECTING_PROPERTY_GET_OR_SET_MODIFIER, new String[0]);
            this.setLocation(iOffset, iLineNum, iColumn);
            this.getOwner().popStatement();
            DynamicFunctionSymbol dfs = functionStmt.getDynamicFunctionSymbol();
            if (dfs == null) {
                dfs = new DynamicFunctionSymbol(this._symTable, (CharSequence)"@", (IFunctionType)new FunctionType("@", (IType)JavaTypes.pVOID(), null, (IGenericTypeVariable[])GenericTypeVariable.EMPTY_TYPEVARS), Collections.emptyList(), (IStatement)null);
                functionStmt.setDynamicFunctionSymbol(dfs);
            }
            IType returnType = functionStmt.getDynamicFunctionSymbol().getReturnType();
            this.verify((ParsedElement)functionStmt, bGetter || returnType == JavaTypes.pVOID(), Res.MSG_PROPERTY_SET_MUST_RETURN_VOID, new String[0]);
            dfs.setClassMember(false);
            if (bGetter && dfs.getArgTypes() != null && dfs.getArgTypes().length > 0) {
                List<IParseTree> children = functionStmt.getLocation().getChildren();
                for (IParseTree child : children) {
                    if (!(child.getParsedElement() instanceof ParameterDeclaration)) continue;
                    child.getParsedElement().addParseException(Res.MSG_GETTER_CANNOT_HAVE_PARAMETERS, new Object[0]);
                }
            }
            DynamicPropertySymbol dps = this.getOrCreateDynamicPropertySymbol(functionStmt, null, dfs, bGetter);
            dps.setClassMember(false);
            this.getOwner().pushStatement(new PropertyStatement(functionStmt, dps));
            return true;
        }
        return false;
    }

    DynamicPropertySymbol getOrCreateDynamicPropertySymbol(ParsedElement parsedElement, IGosuClassInternal gsClass, DynamicFunctionSymbol dfs, boolean bGetter) {
        String strPropertyName = dfs.getDisplayName().substring(1);
        ISymbol symbol = this.getSymbolTable().getSymbol((CharSequence)strPropertyName);
        if (!this.verify(parsedElement, symbol == null || symbol instanceof DynamicPropertySymbol, Res.MSG_VARIABLE_ALREADY_DEFINED, strPropertyName)) {
            return new DynamicPropertySymbol(dfs, bGetter);
        }
        if (symbol == null || gsClass != null && gsClass.getMemberProperty(strPropertyName) == null && gsClass.getStaticProperty(strPropertyName) == null) {
            DynamicPropertySymbol dps = new DynamicPropertySymbol(dfs, bGetter);
            if (symbol != null) {
                assert (symbol instanceof DynamicPropertySymbol);
                dps.setParent((DynamicPropertySymbol)symbol);
            }
            return dps;
        }
        assert (symbol instanceof DynamicPropertySymbol);
        DynamicPropertySymbol dps = (DynamicPropertySymbol)symbol;
        if (bGetter) {
            this.verify(parsedElement, dps.getImmediateGetterDfs() == null || dps.getImmediateGetterDfs() instanceof VarPropertyGetFunctionSymbol || dps.getImmediateGetterDfs().getValueDirectly() != null || dps.getImmediateGetterDfs().isAbstract() || gsClass != null && gsClass.isInterface(), Res.MSG_GETTER_FOR_PROPERTY_ALREADY_DEFINED, strPropertyName);
            dps.setGetterDfs(dfs);
        } else {
            this.verify(parsedElement, dps.getImmediateSetterDfs() == null || dps.getImmediateSetterDfs() instanceof VarPropertySetFunctionSymbol || dps.getImmediateSetterDfs().getValueDirectly() != null || dps.getImmediateSetterDfs().isAbstract() || gsClass != null && gsClass.isInterface(), Res.MSG_SETTER_FOR_PROPERTY_ALREADY_DEFINED, strPropertyName);
            dps.setSetterDfs(dfs);
        }
        return dps;
    }

    boolean parseFunctionDefinition() {
        ModifierInfo modifiers = this.parseModifiers();
        if (!this.isParsingBlock() && this.match(null, Keyword.KW_function)) {
            this.parseBaseFunctionDefinition(new FunctionStatement(), false, false, modifiers);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionStatement parseBaseFunctionDefinition(FunctionStatement functionStmt, boolean bProperty, boolean bGetter, ModifierInfo modifiers) {
        boolean bNullFunctionStmt = functionStmt == null;
        functionStmt = bNullFunctionStmt ? new FunctionStatement() : functionStmt;
        Token token = this.getTokenizer().getCurrentToken();
        int iOffsetName = token.getTokenStart();
        int iLineNumName = token.getLine();
        int iColumnName = token.getTokenColumn();
        String strFunctionName = token.getStringValue();
        boolean bHasName = this.verify((ParsedElement)functionStmt, this.isWordOrValueKeyword(token), Res.MSG_EXPECTING_NAME_FUNCTION_DEF, new String[0]);
        if (bHasName) {
            this.getTokenizer().nextToken();
            functionStmt.setNameOffset(iOffsetName, strFunctionName);
        }
        this.addNameInDeclaration(strFunctionName, iOffsetName, iLineNumName, iColumnName, bHasName);
        this.maybeEatNonDeclKeyword(bHasName, strFunctionName);
        strFunctionName = strFunctionName == null ? "" : (bProperty ? "@" + strFunctionName : strFunctionName);
        DynamicFunctionSymbol dfsDecl = this.findCorrespondingDeclDfs(iOffsetName, modifiers.getModifiers());
        List<TypeVariableDefinitionImpl> defsFromDecl = this.getTypeVarDefsFromDecl(dfsDecl);
        List<ITypeVariableDefinitionExpression> typeVarDefs = this.parseTypeVariableDefs(functionStmt, true, defsFromDecl);
        IGenericTypeVariable[] typeVars = TypeVariableDefinition.getTypeVars(typeVarDefs);
        if (bProperty && !typeVarDefs.isEmpty()) {
            this.verify((ParsedElement)functionStmt, false, Res.MSG_GENERIC_PROPERTIES_NOT_SUPPORTED, new String[0]);
        }
        Expression annotationDefault = null;
        try {
            FunctionStatement funcStmtFromDecl;
            String functionNameWithArgs;
            ICompilableTypeInternal gsClass = this.getGosuClass();
            boolean bAnnotation = gsClass instanceof IGosuClass && ((IGosuClass)gsClass).isAnnotation() && JavaTypes.ANNOTATION().isAssignableFrom((IType)gsClass);
            this.verify((ParsedElement)functionStmt, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_FUNCTION_DEF, new String[0]);
            ArrayList<ISymbol> args = null;
            Statement statement = null;
            boolean functionBodyParsed = true;
            IScriptPartId scriptPart = this.getScriptPart();
            this._symTable.pushIsolatedScope((IActivationContext)new GosuParserTransparentActivationContext(scriptPart));
            try {
                FunctionType type;
                TypeLiteral typeLiteral;
                IType[] argTypes = null;
                if (!this.match(null, null, 41, true)) {
                    args = this.parseParameterDeclarationList(functionStmt, Modifier.isStatic((int)modifiers.getModifiers()), null, bProperty, bGetter, false, false);
                    argTypes = new IType[args.size()];
                    for (int i = 0; i < args.size(); ++i) {
                        this._symTable.putSymbol(args.get(i));
                        argTypes[i] = args.get(i).getType();
                    }
                } else {
                    this.parseParameterDeclarationList(functionStmt, Modifier.isStatic((int)modifiers.getModifiers()), null, bProperty, bGetter, true, false);
                    this.verify((ParsedElement)functionStmt, !bProperty || bGetter, Res.MSG_PROPERTY_SET_MUST_HAVE_ONE_PARAMETER, new String[0]);
                }
                this.verify((ParsedElement)functionStmt, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_FUNCTION_DEF, new String[0]);
                if (this.match(null, ":", -6)) {
                    IType returnType;
                    this.parseTypeLiteral();
                    typeLiteral = (TypeLiteral)this.popExpression();
                    if (bGetter) {
                        returnType = typeLiteral.getType().getType();
                        this.verify((ParsedElement)typeLiteral, returnType != JavaTypes.pVOID(), Res.MSG_VOID_NOT_ALLOWED, new String[0]);
                    }
                    if (bAnnotation) {
                        returnType = typeLiteral.getType().getType();
                        this.verify((ParsedElement)typeLiteral, this.isValidAnnotationMethodReturnType(returnType), Res.MSG_INVALID_TYPE_FOR_ANNOTATION_MEMBER, new String[0]);
                    }
                } else {
                    this.verify((ParsedElement)functionStmt, !bAnnotation, Res.MSG_EXPECTING_RETURN_TYPE_OR_FUN_BODY, new String[0]);
                    String[] fabricatedT = new String[]{Keyword.KW_void.toString()};
                    typeLiteral = this.resolveTypeLiteral(fabricatedT);
                    this.verify((ParsedElement)functionStmt, !bGetter, Res.MSG_MISSING_PROPERTY_RETURN, new String[0]);
                }
                if (bAnnotation && this.match(null, "=", -6)) {
                    IType ctxType = typeLiteral.getType().getType();
                    if (JavaTypes.ANNOTATION().isAssignableFrom(ctxType)) {
                        ArrayList<IGosuAnnotation> anno = new ArrayList<IGosuAnnotation>(1);
                        this.getOwner().parseAnnotation(anno);
                        annotationDefault = (Expression)((IGosuAnnotation)anno.get(0)).getExpression();
                    } else {
                        this.parseExpression(new ContextType(ctxType, false, true));
                        annotationDefault = this.popExpression();
                    }
                    if (!annotationDefault.hasParseExceptions()) {
                        this.verify((ParsedElement)annotationDefault, annotationDefault.isCompileTimeConstant(), Res.MSG_COMPILE_TIME_CONSTANT_REQUIRED, new String[0]);
                    }
                }
                if (!bProperty && dfsDecl == null) {
                    functionNameWithArgs = DynamicFunctionSymbol.getSignatureName(strFunctionName == null ? "" : strFunctionName, args);
                    DynamicFunctionSymbol dfsInSymTable = (DynamicFunctionSymbol)this._symTable.getSymbol((CharSequence)functionNameWithArgs);
                    if (dfsInSymTable == null) {
                        dfsDecl = dfsInSymTable;
                    } else if (dfsInSymTable.getGosuClass() == gsClass) {
                        dfsDecl = dfsInSymTable;
                        dfsDecl = GosuParser.assignPossibleDuplicateDfs(dfsDecl, this._symTable.getSymbols().values());
                    }
                }
                FunctionType functionType = type = dfsDecl == null ? new FunctionType(strFunctionName, (IType)JavaTypes.pVOID(), null, typeVars) : (FunctionType)dfsDecl.getType();
                if (!bProperty && dfsDecl != null) {
                    type = (FunctionType)dfsDecl.getType();
                    if (typeVarDefs != null) {
                        for (ITypeVariableDefinitionExpression tvd : typeVarDefs) {
                            ((ITypeVariableDefinition)tvd).setEnclosingType((IType)type);
                        }
                    }
                } else {
                    type.setRetType(typeLiteral.getType().getType());
                    type.setArgumentTypes(argTypes);
                }
                type.setScriptPart(scriptPart);
                type.setModifiers(modifiers.getModifiers());
                this.putThisAndSuperSymbols(modifiers);
                if (!(Modifier.isAbstract((int)modifiers.getModifiers()) || Modifier.isNative((int)modifiers.getModifiers()) || scriptPart != null && scriptPart.getContainingType() instanceof IGosuClassInternal && scriptPart.getContainingType().isInterface() && !this.match(null, null, 123, true))) {
                    if (this.parseFunctionBody(functionStmt, type)) {
                        statement = this.popStatement();
                    } else {
                        functionBodyParsed = false;
                    }
                }
            }
            finally {
                this._symTable.popScope();
            }
            ISymbol functionSymbol = this._symTable.getSymbol((CharSequence)strFunctionName);
            if (bProperty) {
                if (functionSymbol instanceof DynamicPropertySymbol) {
                    DynamicPropertySymbol dps = (DynamicPropertySymbol)functionSymbol;
                    functionNameWithArgs = DynamicFunctionSymbol.getSignatureName(strFunctionName, args);
                    dfsDecl = dps == null || !dps.getName().equals(strFunctionName) ? (DynamicFunctionSymbol)this._symTable.getSymbol((CharSequence)functionNameWithArgs) : dps.getFunction(functionNameWithArgs);
                } else if (gsClass == null) {
                    dfsDecl = this.findProgramPropertyDfs(strFunctionName, args);
                }
            }
            if (dfsDecl != null && dfsDecl.getDeclFunctionStmt() != null && bNullFunctionStmt && (funcStmtFromDecl = dfsDecl.getDeclFunctionStmt()).getParent() != null && funcStmtFromDecl.getGosuClass() == gsClass) {
                functionStmt = dfsDecl.getDeclFunctionStmt();
            }
            this.verify((ParsedElement)functionStmt, functionBodyParsed, Res.MSG_EXPECTING_RETURN_TYPE_OR_FUN_BODY, new String[0]);
            this.verify((ParsedElement)functionStmt, gsClass != null && gsClass.isAbstract() || !Modifier.isAbstract((int)modifiers.getModifiers()), Res.MSG_ABSTRACT_MEMBER_NOT_IN_ABSTRACT_CLASS, new String[0]);
            this.verify((ParsedElement)functionStmt, dfsDecl != null, Res.MSG_EXPECTING_NAME_FUNCTION_DEF, new String[0]);
            this.verify((ParsedElement)functionStmt, this.parsingFunctionsEncloseMyClass(), Res.MSG_EXPECTING_CLOSE_BRACE_FOR_FUNCTION_DEF, new String[0]);
            if (dfsDecl != null) {
                if (args != null) {
                    dfsDecl.getArgs().clear();
                    dfsDecl.getArgs().addAll(args);
                }
                dfsDecl.getModifierInfo().setAnnotations(modifiers.getAnnotations());
                dfsDecl.setAnnotationDefault(annotationDefault);
                dfsDecl.setValueDirectly(statement);
                this.pushDynamicFunctionSymbol(dfsDecl);
                functionStmt.setDynamicFunctionSymbol(dfsDecl);
                this.verifyOrWarn(functionStmt, this.isTerminal(statement, dfsDecl.getReturnType()), !CommonServices.getEntityAccess().isUnreachableCodeDetectionOn(), Res.MSG_MISSING_RETURN, new Object[0]);
            }
            this.pushStatement(functionStmt);
            DynamicFunctionSymbol dynamicFunctionSymbol = functionStmt.getDynamicFunctionSymbol();
            if (dynamicFunctionSymbol != null && dynamicFunctionSymbol.getDeclFunctionStmt() == null) {
                dynamicFunctionSymbol.setDeclFunctionStmt(functionStmt);
            }
            FunctionStatement functionStatement = functionStmt;
            return functionStatement;
        }
        finally {
            for (ITypeVariableDefinitionExpression typeVarDef : typeVarDefs) {
                Map<String, ITypeVariableDefinition> typeVarMap = this.getTypeVariables();
                if (!typeVarMap.containsValue(typeVarDef)) continue;
                typeVarMap.remove(((ITypeVariableDefinition)typeVarDef).getName());
            }
        }
    }

    private boolean isValidAnnotationMethodReturnType(IType returnType) {
        return returnType.isPrimitive() && returnType != JavaTypes.pVOID() || returnType == JavaTypes.STRING() || returnType.getGenericType() == JavaTypes.CLASS() || JavaTypes.ANNOTATION().isAssignableFrom(returnType) || returnType.isEnum() || returnType.isArray() && this.isValidAnnotationMethodReturnType(returnType.getComponentType());
    }

    private void putThisAndSuperSymbols(ModifierInfo modifiers) {
        if (!Modifier.isStatic((int)modifiers.getModifiers()) && this.getScriptPart() != null && this.getScriptPart().getContainingType() instanceof IGosuClassInternal) {
            IGosuClassInternal gsClass;
            IGosuClassInternal thisType = gsClass = (IGosuClassInternal)this.getScriptPart().getContainingType();
            if (gsClass instanceof IGosuEnhancementInternal) {
                thisType = ((IGosuEnhancementInternal)gsClass).getEnhancedType();
            }
            if (thisType != null) {
                thisType = TypeLord.getConcreteType((IType)thisType);
                this.getSymbolTable().putSymbol((ISymbol)new ThisSymbol((IType)thisType, this._symTable));
                if (!(gsClass instanceof IGosuEnhancementInternal)) {
                    IGosuClassInternal superClass = gsClass.getSuperClass();
                    if (superClass == null) {
                        superClass = IGosuClassInternal.Util.getGosuClassFrom((IType)JavaTypes.OBJECT());
                    }
                    this.getSymbolTable().putSymbol((ISymbol)new Symbol(Keyword.KW_super.getName(), (IType)superClass, (IStackProvider)this._symTable, null));
                }
            }
        }
    }

    private DynamicFunctionSymbol findProgramPropertyDfs(String strFunctionName, ArrayList<ISymbol> args) {
        List<IFunctionSymbol> list = this.getDfsDeclsForFunction(strFunctionName);
        String propertyNameWithArgs = DynamicFunctionSymbol.getSignatureName(strFunctionName == null ? "" : strFunctionName, args);
        for (IFunctionSymbol func : list) {
            DynamicFunctionSymbol dfs;
            String sig;
            if (!(func instanceof DynamicFunctionSymbol) || !propertyNameWithArgs.equals(sig = DynamicFunctionSymbol.getSignatureName((dfs = (DynamicFunctionSymbol)func).getDisplayName(), dfs.getArgs()))) continue;
            return dfs;
        }
        return null;
    }

    private List<TypeVariableDefinitionImpl> getTypeVarDefsFromDecl(DynamicFunctionSymbol dfsDecl) {
        if (dfsDecl == null) {
            return Collections.emptyList();
        }
        IGenericTypeVariable[] typeVars = dfsDecl.getType().getGenericTypeVariables();
        if (typeVars == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeVariableDefinitionImpl> result = new ArrayList<TypeVariableDefinitionImpl>(typeVars.length);
        for (IGenericTypeVariable typeVar : typeVars) {
            result.add((TypeVariableDefinitionImpl)typeVar.getTypeVariableDefinition());
        }
        return result;
    }

    private DynamicFunctionSymbol findCorrespondingDeclDfs(int iOffsetName, int iModifiers) {
        ICompilableTypeInternal gsClass = this.getGosuClass();
        if (gsClass == null) {
            return null;
        }
        Collection<DynamicFunctionSymbol> functions = Modifier.isStatic((int)iModifiers) ? gsClass.getParseInfo().getStaticFunctions() : gsClass.getParseInfo().getMemberFunctions().values();
        for (DynamicFunctionSymbol dfs : functions) {
            FunctionStatement funcStmt = dfs.getDeclFunctionStmt();
            if (funcStmt == null || funcStmt.getNameOffset(null) != iOffsetName) continue;
            return dfs;
        }
        return null;
    }

    boolean isDeclarationKeyword(String strKeyword) {
        return strKeyword != null && (Keyword.KW_function.equals(strKeyword) || Keyword.KW_construct.equals(strKeyword) || Keyword.KW_property.equals(strKeyword) || Keyword.KW_delegate.equals(strKeyword) || Keyword.KW_class.equals(strKeyword) || Keyword.KW_interface.equals(strKeyword) || Keyword.KW_annotation.equals(strKeyword) || Keyword.KW_structure.equals(strKeyword) || Keyword.KW_enum.equals(strKeyword));
    }

    static DynamicFunctionSymbol assignPossibleDuplicateDfs(DynamicFunctionSymbol dfsDecl, Iterable symbols) {
        DynamicFunctionSymbol result = dfsDecl;
        if (dfsDecl != null && dfsDecl.getValueDirectly() != null) {
            int iMin = Integer.MAX_VALUE;
            for (Object csr : symbols) {
                int iIndex;
                DynamicFunctionSymbol dfsCsr;
                if (!(csr instanceof DynamicFunctionSymbol) || !(dfsCsr = (DynamicFunctionSymbol)csr).getName().toLowerCase().contains("_duplicate_" + dfsDecl.getName().toLowerCase()) || dfsCsr.getGosuClass() != dfsDecl.getGosuClass()) continue;
                String strName = dfsCsr.getName();
                if (dfsCsr.getValueDirectly() != null || (iIndex = Integer.parseInt(strName.substring(0, strName.indexOf(95)))) >= iMin) continue;
                iMin = iIndex;
                result = (DynamicFunctionSymbol)csr;
            }
        }
        return result;
    }

    void addNameInDeclaration(String strName, int iOffsetName, int iLineNumName, int iColumnName, boolean bHasName) {
        NameInDeclaration name = new NameInDeclaration(strName);
        this.pushExpression(name);
        this.setLocation(bHasName ? iOffsetName : this.getTokenizer().getPriorToken().getTokenEnd(), iLineNumName, iColumnName, !bHasName, true);
        this.popExpression();
    }

    private boolean parsingFunctionsEncloseMyClass() {
        if (this._parsingFunctions.isEmpty()) {
            return true;
        }
        for (FunctionType ft : this._parsingFunctions) {
            if (ft.getScriptPart().getContainingType() != this.getGosuClass()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionStatement parseProgramEntryPointBody() {
        DynamicFunctionSymbol dfsDecl = this.getProgramEntryPointDfs();
        this._symTable.pushIsolatedScope((IActivationContext)new GosuParserTransparentActivationContext(this.getScriptPart()));
        boolean bFunctionBodyParsed = true;
        StatementList stmtList = null;
        this._bProgramCallFunction = true;
        try {
            if (dfsDecl != null && this.parseProgramFunctionBody((FunctionType)dfsDecl.getType())) {
                stmtList = (StatementList)this.popStatement();
            } else {
                bFunctionBodyParsed = false;
            }
        }
        finally {
            this._bProgramCallFunction = false;
            this._symTable.popScope();
        }
        FunctionStatement fs = new FunctionStatement();
        fs.setDynamicFunctionSymbol(dfsDecl);
        this.verify((ParsedElement)fs, bFunctionBodyParsed, Res.MSG_EXPECTING_RETURN_TYPE_OR_FUN_BODY, new String[0]);
        if (dfsDecl != null) {
            dfsDecl.setValueDirectly(stmtList);
        }
        this.pushDynamicFunctionSymbol(dfsDecl);
        fs.setDynamicFunctionSymbol(dfsDecl);
        this.addDefaultReturnStmt(dfsDecl, stmtList);
        this.pushStatement(fs);
        return fs;
    }

    private DynamicFunctionSymbol getProgramEntryPointDfs() {
        String functionNameWithArgs = DynamicFunctionSymbol.getSignatureName("evaluate", Collections.singletonList(new Symbol("symbols", JavaTypes.IEXTERNAL_SYMBOL_MAP(), null)));
        return (DynamicFunctionSymbol)this._symTable.getSymbol((CharSequence)functionNameWithArgs);
    }

    private StatementList handleExpressionStatementList(Expression expr) {
        Statement stmt;
        if (expr.hasParseExceptions() || expr.getType() != JavaTypes.pVOID() || expr instanceof NullExpression) {
            stmt = this.wrapProgramExpressionInReturnStmt(expr);
        } else if (expr instanceof MethodCallExpression) {
            stmt = new MethodCallStatement();
            ((MethodCallStatement)stmt).setMethodCall((MethodCallExpression)expr);
        } else if (expr instanceof BeanMethodCallExpression) {
            stmt = new BeanMethodCallStatement();
            ((BeanMethodCallStatement)stmt).setBeanMethodCall((BeanMethodCallExpression)expr);
        } else if (expr instanceof BlockInvocation) {
            stmt = new BlockInvocationStatement((BlockInvocation)expr);
        } else {
            throw new UnsupportedOperationException("Did not expect expression of type: " + expr.getClass().getName());
        }
        this.pushStatement(stmt);
        ParseTree exprLoc = expr.getLocation();
        this.setLocation(exprLoc.getOffset(), exprLoc.getLineNum(), exprLoc.getColumn(), true);
        this.popStatement();
        StatementList stmtList = new StatementList((IStackProvider)this._symTable);
        List<Statement> stmts = Collections.singletonList(stmt);
        stmtList.setStatements(stmts);
        this.pushStatement(stmtList);
        this.setLocation(exprLoc.getOffset(), exprLoc.getLineNum(), exprLoc.getColumn(), true);
        return stmtList;
    }

    private ReturnStatement wrapProgramExpressionInReturnStmt(Expression e) {
        ReturnStatement retStmt = new ReturnStatement();
        retStmt.setSynthetic(true);
        e = this.possiblyWrapWithImplicitCoercion(e, (IType)JavaTypes.OBJECT());
        if (e.getType() == JavaTypes.pVOID()) {
            e.setType((IType)JavaTypes.OBJECT());
        }
        retStmt.setValue(e);
        return retStmt;
    }

    private void addDefaultReturnStmt(DynamicFunctionSymbol dfsDecl, StatementList stmtList) {
        if (dfsDecl != null && !this.isTerminal(stmtList, dfsDecl.getReturnType())) {
            ReturnStatement defaultReturnStmt = new ReturnStatement();
            ImplicitTypeAsExpression ta = new ImplicitTypeAsExpression();
            ta.setLHS(new NullExpression());
            ta.setType((IType)JavaTypes.OBJECT());
            ta.setCoercer((ICoercer)IdentityCoercer.instance());
            defaultReturnStmt.setValue(ta);
            ArrayList<Statement> stmts = stmtList.getStatements() == null ? new ArrayList<ReturnStatement>(2) : new ArrayList<Statement>(Arrays.asList(stmtList.getStatements()));
            stmts.add(defaultReturnStmt);
            stmtList.setStatements(stmts);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean parseProgramFunctionBody(FunctionType type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void maybeSetExternalSymbols() {
        ISymbolTable extSyms;
        ISourceFileHandle sfh;
        if (this.getGosuClass() instanceof IGosuProgram && (sfh = this.getGosuClass().getSourceFileHandle()) instanceof StringSourceFileHandle && (extSyms = ((StringSourceFileHandle)sfh).getExternalSymbols()) != null) {
            HashMap<String, Symbol> map = new HashMap<String, Symbol>();
            for (Symbol s : extSyms.getSymbols().values()) {
                map.put(s.getName(), s);
            }
            ExternalSymbolMapForMap extMap = new ExternalSymbolMapForMap(map);
            ((GosuProgramParseInfo)this.getGosuClass().getParseInfo()).setExternalSymbols(extMap);
        }
    }

    private void removeLocationsFrom(int iLocationsCount) {
        for (int i = this._locations.size(); i > iLocationsCount; --i) {
            this._locations.remove(i - 1);
        }
    }

    private boolean isTerminal(Statement statement, IType returnType) {
        boolean[] bAbsolute = new boolean[]{false};
        return returnType == JavaTypes.pVOID() || statement == null || statement.getLeastSignificantTerminalStatement(bAbsolute) != null && bAbsolute[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseFunctionBody(FunctionStatement functionStmt, FunctionType type) {
        this.pushParsingFunction(type);
        try {
            if (!(this.getGosuClass() instanceof IGosuProgram && ((IGosuProgramInternal)this.getGosuClass()).isParsingExecutableProgramStatements() || this.match(null, null, 123, true))) {
                Token T = this.getTokenizer().getCurrentToken();
                this.eatStatementBlock(functionStmt, Res.MSG_EXPECTING_OPEN_BRACE_FOR_FUNCTION_DEF);
                NotAStatement nas = new NotAStatement();
                this.pushStatement(nas);
                this.setLocation(T.getTokenStart(), T.getLine(), T.getTokenColumn());
            } else if (!this.parseStatement(true, false)) {
                boolean T = false;
                return T;
            }
            Statement body = this.peekStatement();
            if (body instanceof StatementList) {
                ((StatementList)body).setNoScope();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.popParsingFunction();
        }
    }

    DynamicFunctionSymbol parseFunctionDecl(ParsedElement element, ModifierInfo modifiers) {
        return this.parseFunctionDecl(element, false, false, modifiers);
    }

    DynamicFunctionSymbol parseFunctionDecl(ParsedElement element, boolean bProperty, boolean bGetter, ModifierInfo modifiers) {
        return this.parseFunctionDecl(element, null, bProperty, bGetter, modifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DynamicFunctionSymbol parseFunctionDecl(ParsedElement element, String T, boolean bProperty, boolean bGetter, ModifierInfo modifiers) {
        this._symTable.pushIsolatedScope((IActivationContext)new FunctionDeclTransparentActivationContext(this.getScriptPart()));
        try {
            DynamicFunctionSymbol dynamicFunctionSymbol;
            int iTokenStart;
            boolean bHasName = true;
            if (T == null) {
                int mark = this.getTokenizer().mark();
                bHasName = this.verify(element, this.match(null, -5), Res.MSG_EXPECTING_NAME_FUNCTION_DEF, new String[0]);
                Token token = this.getTokenizer().getTokenAt(mark);
                int n = iTokenStart = token == null ? 0 : token.getTokenStart();
                if (bHasName) {
                    T = token.getStringValue();
                }
            } else {
                iTokenStart = this.getTokenizer().getPriorToken(true).getTokenStart();
            }
            if (element instanceof IParsedElementWithAtLeastOneDeclaration) {
                ((IParsedElementWithAtLeastOneDeclaration)element).setNameOffset(iTokenStart, T);
            }
            String strFunctionName = T;
            this.maybeEatNonDeclKeyword(bHasName, strFunctionName);
            strFunctionName = strFunctionName == null ? "" : strFunctionName;
            this.warn(element, !Keyword.isReservedKeyword((String)strFunctionName), Res.MSG_IMPROPER_USE_OF_KEYWORD, strFunctionName);
            ICompilableTypeInternal gsClass = this.getGosuClass();
            if (gsClass != null && strFunctionName.equals(gsClass.getRelativeName()) && gsClass.isEnum()) {
                this.verify(element, Modifier.isPrivate((int)modifiers.getModifiers()), Res.MSG_ENUM_CONSTRUCTOR_MUST_BE_PRIVATE, new String[0]);
            }
            List<ITypeVariableDefinitionExpression> typeVarDefs = this.parseTypeVariableDefs(element, true, null);
            IGenericTypeVariable[] typeVars = TypeVariableDefinition.getTypeVars(typeVarDefs);
            strFunctionName = !bProperty ? strFunctionName : '@' + strFunctionName;
            FunctionType type = new FunctionType(strFunctionName, (IType)JavaTypes.pVOID(), null, typeVars);
            type.setEnclosingType((IType)this.getGosuClass());
            if (bProperty && !typeVarDefs.isEmpty()) {
                this.verify(element, false, Res.MSG_GENERIC_PROPERTIES_NOT_SUPPORTED, new String[0]);
            }
            try {
                TypeLiteral typeLiteral;
                boolean bAnnotation = gsClass instanceof IGosuClass && ((IGosuClass)gsClass).isAnnotation() && JavaTypes.ANNOTATION().isAssignableFrom((IType)gsClass);
                this.verify(element, this.match(null, 40), Res.MSG_EXPECTING_LEFTPAREN_FUNCTION_DEF, new String[0]);
                ArrayList<ISymbol> params = null;
                IType[] paramTypes = null;
                if (!this.match(null, 41)) {
                    params = this.parseParameterDeclarationList(element, Modifier.isStatic((int)modifiers.getModifiers()), null, bProperty, bGetter, false, false);
                    paramTypes = new IType[params.size()];
                    for (int i = 0; i < params.size(); ++i) {
                        this._symTable.putSymbol(params.get(i));
                        paramTypes[i] = params.get(i).getType();
                    }
                    this.verify(element, this.match(null, 41), Res.MSG_EXPECTING_RIGHTPAREN_FUNCTION_DEF, new String[0]);
                } else {
                    this.verify(element, !bProperty || bGetter, Res.MSG_PROPERTY_SET_MUST_HAVE_ONE_PARAMETER, new String[0]);
                }
                if (this.match(null, ":", -6)) {
                    this.parseTypeLiteral();
                    typeLiteral = (TypeLiteral)this.popExpression();
                    if (bGetter) {
                        IType returnType = typeLiteral.getType().getType();
                        this.verify((ParsedElement)typeLiteral, returnType != JavaTypes.pVOID(), Res.MSG_VOID_NOT_ALLOWED, new String[0]);
                    }
                } else {
                    this.verify(element, !bAnnotation, Res.MSG_EXPECTING_RETURN_TYPE_OR_FUN_BODY, new String[0]);
                    String[] fakeT = new String[]{Keyword.KW_void.toString()};
                    typeLiteral = this.resolveTypeLiteral(fakeT);
                    this.verify(element, !bGetter, Res.MSG_MISSING_PROPERTY_RETURN, new String[0]);
                }
                Expression annotationDefault = null;
                if (gsClass instanceof IGosuClass && ((IGosuClass)gsClass).isAnnotation() && JavaTypes.ANNOTATION().isAssignableFrom((IType)gsClass) && this.match(null, "=", -6)) {
                    IType ctxType = typeLiteral.getType().getType();
                    if (JavaTypes.ANNOTATION().isAssignableFrom(ctxType)) {
                        ArrayList<IGosuAnnotation> anno = new ArrayList<IGosuAnnotation>(1);
                        this.getOwner().parseAnnotation(anno);
                        annotationDefault = (Expression)((IGosuAnnotation)anno.get(0)).getExpression();
                    } else {
                        this.parseExpression(new ContextType(ctxType, false, true));
                        annotationDefault = this.popExpression();
                    }
                    if (!annotationDefault.hasParseExceptions()) {
                        this.verify((ParsedElement)annotationDefault, annotationDefault.isCompileTimeConstant(), Res.MSG_COMPILE_TIME_CONSTANT_REQUIRED, new String[0]);
                    }
                }
                type.setArgumentTypes(paramTypes);
                type.setRetType(typeLiteral.getType().getType());
                type.setScriptPart(this.getScriptPart());
                DynamicFunctionSymbol dfs = new DynamicFunctionSymbol(this._symTable, (CharSequence)strFunctionName, (IFunctionType)type, (List<ISymbol>)params, (IStatement)null);
                dfs.setScriptPart(this.getScriptPart());
                dfs.setModifierInfo(modifiers);
                dfs.setAnnotationDefault(annotationDefault);
                if (element instanceof FunctionStatement) {
                    dfs.setDeclFunctionStmt((FunctionStatement)element);
                }
                this.verifyFunction(dfs, element);
                int iDupIndex = this.nextIndexOfErrantDuplicateDynamicSymbol(dfs, (Collection<? extends ISymbol>)this._dfsDeclByName.get(dfs.getDisplayName()), true);
                if (iDupIndex >= 0) {
                    dfs.renameAsErrantDuplicate(iDupIndex);
                }
                this.putDfsDeclInSetByName(dfs);
                dynamicFunctionSymbol = dfs;
            }
            catch (Throwable throwable) {
                for (ITypeVariableDefinitionExpression typeVarDef : typeVarDefs) {
                    Map<String, ITypeVariableDefinition> typeVarMap = this.getTypeVariables();
                    if (!typeVarMap.containsValue(typeVarDef)) continue;
                    typeVarMap.remove(((ITypeVariableDefinition)typeVarDef).getName());
                }
                throw throwable;
            }
            for (ITypeVariableDefinitionExpression typeVarDef : typeVarDefs) {
                Map<String, ITypeVariableDefinition> typeVarMap = this.getTypeVariables();
                if (!typeVarMap.containsValue(typeVarDef)) continue;
                typeVarMap.remove(((ITypeVariableDefinition)typeVarDef).getName());
            }
            return dynamicFunctionSymbol;
        }
        finally {
            this._symTable.popScope();
        }
    }

    boolean maybeEatNonDeclKeyword(boolean bHasName, String strFunctionName) {
        return !bHasName && strFunctionName != null && strFunctionName.length() > 0 && !this.isDeclarationKeyword(strFunctionName) && this.match(null, -7);
    }

    private void verifyFunction(DynamicFunctionSymbol dfs, ParsedElement element) {
        boolean bValidOverrideFound = false;
        for (IFunctionSymbol existing : this.getDfsDeclsForFunction(dfs.getDisplayName())) {
            if (!(existing instanceof DynamicFunctionSymbol)) continue;
            DynamicFunctionSymbol dfsExisting = (DynamicFunctionSymbol)existing;
            if (!existing.getDisplayName().equals(dfs.getDisplayName()) || !this.areDFSsInSameNameSpace(dfs, dfsExisting)) continue;
            if (this.areParametersEquivalent(dfs, dfsExisting, new IType[0]) || !dfs.isStatic() && dfsExisting.isStatic() && dfs.getDeclaringTypeInfo().getOwnersType() instanceof IGosuEnhancement && this.areParametersEquivalent(dfs, dfsExisting, ((IGosuEnhancement)dfs.getDeclaringTypeInfo().getOwnersType()).getEnhancedType()) || !dfsExisting.isStatic() && dfs.isStatic() && dfsExisting.getDeclaringTypeInfo().getOwnersType() instanceof IGosuEnhancement && this.areParametersEquivalent(dfsExisting, dfs, ((IGosuEnhancement)dfsExisting.getDeclaringTypeInfo().getOwnersType()).getEnhancedType())) {
                boolean bClassAndReturnTypesCompatible;
                boolean bSameButNotInSameClass;
                IGosuClass owningTypeForDfs = this.getOwningTypeForDfs(dfsExisting);
                ICompilableTypeInternal gsClass = this.getGosuClass();
                if (owningTypeForDfs instanceof IGosuEnhancement) {
                    if (dfs.isOverride() || owningTypeForDfs == gsClass) {
                        this.addError(element, Res.MSG_CANNOT_OVERRIDE_FUNCTION_FROM_ENHANCEMENT);
                        continue;
                    }
                    this.warn(element, false, Res.MSG_MASKING_ENHANCEMENT_METHODS_MAY_BE_CONFUSING, new Object[0]);
                    continue;
                }
                boolean bl = bSameButNotInSameClass = !GosuObjectUtil.equals((Object)dfsExisting.getScriptPart(), (Object)dfs.getScriptPart());
                if (!this.verify(element, bSameButNotInSameClass, Res.MSG_FUNCTION_ALREADY_DEFINED, dfs.getMethodSignature(), this.getScriptPart())) {
                    return;
                }
                if (!this.verify(element, dfs.isStatic() || !dfsExisting.isStatic(), Res.MSG_FUNCTION_ALREADY_DEFINED, dfs.getMethodSignature(), this.getScriptPart())) {
                    return;
                }
                boolean bl2 = bClassAndReturnTypesCompatible = !GosuObjectUtil.equals((Object)dfsExisting.getScriptPart(), (Object)dfs.getScriptPart()) && this.returnTypesCompatible(dfsExisting, dfs);
                if (!this.verify(element, bClassAndReturnTypesCompatible, Res.MSG_FUNCTION_CLASH, dfs.getName(), dfs.getScriptPart(), dfsExisting.getName(), dfsExisting.getScriptPart())) continue;
                boolean b = !dfsExisting.isFinal() && (gsClass == null || gsClass.getSupertype() == null || !gsClass.getSupertype().isFinal());
                this.verify(element, b, Res.MSG_CANNOT_OVERRIDE_FINAL, dfsExisting.getName(), dfsExisting.getScriptPart());
                if (!this.verify(element, !dfs.isStatic() || dfsExisting.isStatic(), Res.MSG_STATIC_METHOD_CANNOT_OVERRIDE, dfs.getName(), dfsExisting.getDeclaringTypeInfo().getName()) || dfs.isStatic() || dfsExisting.isStatic()) continue;
                IGosuClassInternal existingDeclaringClass = dfsExisting.getGosuClass();
                boolean bDefaultMethodOverridesClassMethod = gsClass.isInterface() && !dfs.isAbstract() && existingDeclaringClass != null && existingDeclaringClass.isProxy() && existingDeclaringClass.getJavaType() == JavaTypes.IGOSU_OBJECT();
                if (!this.verify(element, !bDefaultMethodOverridesClassMethod, Res.MSG_OVERRIDES_OBJECT_METHOD, dfs.getName(), dfsExisting.getDeclaringTypeInfo().getName())) continue;
                if (!dfs.isOverride()) {
                    boolean bIsConstructorName = gsClass != null && gsClass.getRelativeName().equals(dfs.getDisplayName());
                    this.warn(element, bIsConstructorName, Res.MSG_MISSING_OVERRIDE_MODIFIER, dfsExisting.getName(), dfsExisting.getScriptPart().getContainingTypeName());
                    if (!bIsConstructorName) {
                        dfs.setOverride(true);
                    }
                }
                this.verifyNotWeakerAccess(element, dfs, dfsExisting);
                this.verifySameNumberOfFunctionTypeVars(element, dfs, dfsExisting);
                dfs.setSuperDfs(dfsExisting);
                bValidOverrideFound = true;
                continue;
            }
            this.verify(element, !this.doParametersReifyToSameBytecodeType(dfs, dfsExisting), Res.MSG_METHOD_REIFIES_TO_SAME_SIGNATURE_AS_ANOTHER_METHOD, new String[0]);
            this.verify(element, !this.propertyTypeDiffers(dfs, dfsExisting), Res.MSG_PROPERTY_OVERRIDES_WITH_INCOMPATIBLE_TYPE, new String[0]);
            this.verify(element, dfs.getName().startsWith("@") || !dfs.hasOptionalParameters() && !dfsExisting.hasOptionalParameters(), Res.MSG_OVERLOADING_NOT_ALLOWED_WITH_OPTIONAL_PARAMS, new String[0]);
        }
        if (!bValidOverrideFound) {
            this.verifyOverrideNotOnMethodThatDoesNotExtend(element, dfs);
        }
        this.verifyNoImplicitPropertyMethodConflicts(element, dfs);
    }

    private boolean propertyTypeDiffers(DynamicFunctionSymbol dfs, DynamicFunctionSymbol dfsExisting) {
        return dfs.getDisplayName().startsWith("@") && dfs.getArgTypes().length > 0 && dfsExisting.getArgTypes().length > 0 && dfs.getArgTypes()[0] != dfsExisting.getArgTypes()[0];
    }

    private void verifySameNumberOfFunctionTypeVars(ParsedElement element, DynamicFunctionSymbol dfs, DynamicFunctionSymbol dfsExisting) {
        FunctionType dfsType = (FunctionType)dfs.getType();
        FunctionType existingDfsType = (FunctionType)dfsExisting.getType();
        IGenericTypeVariable[] typeVars = dfsType.getTypeVariables();
        IGenericTypeVariable[] existingTypeVars = existingDfsType.getTypeVariables();
        this.verify(element, existingTypeVars.length == typeVars.length, Res.MSG_OVERRIDING_FUNCTION_MUST_HAVE_SAME_NUMBER_OF_TYPE_VARS, existingTypeVars.length);
    }

    private boolean areDFSsInSameNameSpace(IDynamicSymbol newDfs, IDynamicSymbol existingDfs) {
        IGosuClass newType = this.getOwningTypeForDfs(newDfs);
        IGosuClass existingType = this.getOwningTypeForDfs(existingDfs);
        if (newType == null) {
            return existingType == null;
        }
        if (newType.isAnonymous() || newType.getEnclosingType() != null) {
            if (existingType instanceof IGosuEnhancement) {
                existingType = ((IGosuEnhancement)existingType).getEnhancedType();
            }
            if (IGosuClass.ProxyUtil.isProxy((IType)existingType)) {
                IType type = IGosuClass.ProxyUtil.getProxiedType((IType)existingType);
                return type.isAssignableFrom((IType)newType) || JavaTypes.IGOSU_OBJECT().equals(type);
            }
            return existingType.isAssignableFrom((IType)newType);
        }
        return true;
    }

    private void verifyNoImplicitPropertyMethodConflicts(ParsedElement element, DynamicFunctionSymbol dfs) {
        String name = dfs.getDisplayName();
        if (name.startsWith("@")) {
            String propName = name.substring(1);
            if (dfs.getArgs().size() == 0) {
                for (IFunctionSymbol func : this.getDfsDeclsForFunction("get" + propName)) {
                    DynamicFunctionSymbol existingDfs;
                    if (!(func instanceof DynamicFunctionSymbol) || !this.areDFSsInSameNameSpace(dfs, existingDfs = (DynamicFunctionSymbol)func)) continue;
                    this.verify(element, existingDfs.getArgs().size() != 0, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT, existingDfs.getName(), propName);
                }
            } else {
                for (IFunctionSymbol func : this.getDfsDeclsForFunction("set" + propName)) {
                    DynamicFunctionSymbol existingDfs;
                    if (!(func instanceof DynamicFunctionSymbol) || !this.areDFSsInSameNameSpace(dfs, existingDfs = (DynamicFunctionSymbol)func)) continue;
                    this.verifyPropertySetterConflictsWithFunction(element, dfs, propName, existingDfs);
                }
            }
        } else if (name.startsWith("set") && dfs.getArgs().size() == 1) {
            DynamicPropertySymbol dps;
            ISymbol symbol = this.getSymbolTable().getSymbol((CharSequence)name.substring(3, name.length()));
            if (symbol instanceof DynamicPropertySymbol && this.areDFSsInSameNameSpace(dfs, dps = (DynamicPropertySymbol)symbol)) {
                this.verifyFunctionConflictsWithPropoertySetter(element, dfs, dps);
            }
        } else {
            DynamicPropertySymbol dps;
            ISymbol symbol;
            boolean bIs = name.startsWith("is");
            if ((bIs || name.startsWith("get")) && dfs.getArgs().size() == 0 && (symbol = this.getSymbolTable().getSymbol((CharSequence)name.substring(bIs ? 2 : 3, name.length()))) instanceof DynamicPropertySymbol && this.areDFSsInSameNameSpace(dfs, dps = (DynamicPropertySymbol)symbol)) {
                DynamicFunctionSymbol getterDfs = dps.getGetterDfs();
                this.verify(element, getterDfs == null || !NameResolver.getFunctionName(dfs).equals(NameResolver.getFunctionName(getterDfs)), Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT, dfs.getName(), dps.getName());
            }
        }
    }

    void verifyFunctionConflictsWithPropoertySetter(ParsedElement element, DynamicFunctionSymbol dfs, DynamicPropertySymbol dps) {
        if (dps.getSetterDfs() != null) {
            IType argType = dfs.getArgs().get(0).getType();
            if (argType.equals(dps.getType())) {
                this.verify(element, false, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT, dfs.getName(), dps.getName());
            } else if (this.doTypesReifyToTheSameBytecodeType(argType, dps.getType())) {
                this.verify(element, false, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT_UPON_REIFICATION, dfs.getName(), dps.getName());
            }
        }
    }

    void verifyPropertySetterConflictsWithFunction(ParsedElement element, DynamicFunctionSymbol dfs, String propName, DynamicFunctionSymbol existingDfs) {
        if (existingDfs.getArgs().size() == 1) {
            IType existingArgType;
            IType argType = dfs.getArgs().get(0).getType();
            if (argType.equals(existingArgType = existingDfs.getArgs().get(0).getType())) {
                this.verify(element, false, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT, existingDfs.getName(), propName);
            }
            if (this.doTypesReifyToTheSameBytecodeType(argType, existingArgType)) {
                this.verify(element, false, Res.MSG_PROPERTY_AND_FUNCTION_CONFLICT_UPON_REIFICATION, existingDfs.getName(), propName);
            }
        }
    }

    private boolean returnTypesCompatible(DynamicFunctionSymbol dfsExisting, DynamicFunctionSymbol dfs) {
        IType overrideReturnType;
        IType existingReturnType = this.maybeResolveFunctionTypeVars(dfsExisting, dfsExisting.getReturnType());
        if (existingReturnType.isAssignableFrom(overrideReturnType = this.maybeResolveFunctionTypeVars(dfs, dfs.getReturnType())) || StandardCoercionManager.isStructurallyAssignable((IType)existingReturnType, (IType)overrideReturnType)) {
            return true;
        }
        return dfs.getReturnType() instanceof ErrorType;
    }

    private boolean areParametersEquivalent(IDynamicFunctionSymbol dfs, IDynamicFunctionSymbol dfsExisting, IType ... extraParams) {
        IType[] args = ((FunctionType)dfs.getType()).getParameterTypes();
        IType[] toArgs = ((FunctionType)dfsExisting.getType()).getParameterTypes();
        if (extraParams != null && extraParams.length > 0) {
            IType[] argsPlus = new IType[args.length + extraParams.length];
            System.arraycopy(extraParams, 0, argsPlus, 0, extraParams.length);
            System.arraycopy(args, 0, argsPlus, extraParams.length, args.length);
            args = argsPlus;
        }
        return this._areParametersEquivalent(dfs, dfsExisting, args, toArgs);
    }

    private boolean _areParametersEquivalent(IDynamicFunctionSymbol dfs1, IDynamicFunctionSymbol dfs2, IType[] args, IType[] toArgs) {
        if (args == null || args.length == 0) {
            return toArgs == null || toArgs.length == 0;
        }
        if (toArgs == null) {
            return false;
        }
        if (args.length != toArgs.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            IType toArgType;
            IType argType = this.maybeResolveFunctionTypeVars(dfs1, args[i]);
            if (argType.equals(toArgType = this.maybeResolveFunctionTypeVars(dfs2, toArgs[i]))) continue;
            return false;
        }
        return true;
    }

    private IType maybeResolveFunctionTypeVars(IDynamicFunctionSymbol dfs, IType type) {
        ArrayList<IType> functionTypeVars;
        block4: {
            FunctionType funcType;
            block3: {
                boolean bConstructor;
                if (TypeSystem.isDeleted((IType)type)) {
                    return TypeSystem.getErrorType();
                }
                funcType = (FunctionType)dfs.getType();
                functionTypeVars = new ArrayList<IType>();
                IType declaringType = dfs.getScriptPart() == null ? null : dfs.getScriptPart().getContainingType();
                boolean bl = bConstructor = declaringType != null && dfs.getDisplayName().equals(declaringType.getRelativeName());
                if (!bConstructor) break block3;
                if (!declaringType.isGenericType() || declaringType.isParameterizedType()) break block4;
                for (IGenericTypeVariable tv : declaringType.getGenericTypeVariables()) {
                    functionTypeVars.add((IType)tv.getTypeVariableDefinition().getType());
                }
                break block4;
            }
            for (IGenericTypeVariable tv : funcType.getTypeVariables()) {
                functionTypeVars.add((IType)tv.getTypeVariableDefinition().getType());
            }
        }
        return TypeLord.boundTypes(type, functionTypeVars);
    }

    public boolean doParametersReifyToSameBytecodeType(IDynamicFunctionSymbol dfs, IDynamicFunctionSymbol dfsExisting) {
        IType[] toArgs = ((FunctionType)dfsExisting.getType()).getParameterTypes();
        IType[] args = ((FunctionType)dfs.getType()).getParameterTypes();
        if (args == null || args.length == 0) {
            return toArgs == null || toArgs.length == 0;
        }
        if (toArgs == null) {
            return false;
        }
        if (args.length != toArgs.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (this.doTypesReifyToTheSameBytecodeType(toArgs[i], args[i])) continue;
            return false;
        }
        return true;
    }

    boolean doTypesReifyToTheSameBytecodeType(IType toArg, IType arg) {
        IRType toArgType = IRElement.maybeEraseStructuralType(null, (IRType)IRTypeResolver.getDescriptor(toArg));
        IRType argType = IRElement.maybeEraseStructuralType(null, (IRType)IRTypeResolver.getDescriptor(arg));
        return argType.equals(toArgType);
    }

    private IGosuClass getOwningTypeForDfs(IDynamicSymbol dfs) {
        if (dfs.getScriptPart() != null && dfs.getScriptPart().getContainingType() instanceof IGosuClass) {
            return (IGosuClass)dfs.getScriptPart().getContainingType();
        }
        return null;
    }

    private void verifyNotWeakerAccess(ParsedElement element, DynamicFunctionSymbol dfs, DynamicFunctionSymbol dfsExisting) {
        if (dfsExisting.isPublic()) {
            this.verify(element, dfs.isPublic(), Res.MSG_ATTEMPTING_TO_ASSIGN_WEAKER_ACCESS_PRIVILEGES, dfs.getName(), dfs.getScriptPart(), dfsExisting.getName(), dfsExisting.getScriptPart());
        } else if (dfsExisting.isProtected()) {
            this.verify(element, dfs.isPublic() || dfs.isProtected(), Res.MSG_ATTEMPTING_TO_ASSIGN_WEAKER_ACCESS_PRIVILEGES, dfs.getName(), dfs.getScriptPart(), dfsExisting.getName(), dfsExisting.getScriptPart());
        } else if (dfsExisting.isInternal()) {
            this.verify(element, dfs.isPublic() || dfs.isProtected() || dfs.isInternal(), Res.MSG_ATTEMPTING_TO_ASSIGN_WEAKER_ACCESS_PRIVILEGES, dfs.getName(), dfs.getScriptPart(), dfsExisting.getName(), dfsExisting.getScriptPart());
        }
    }

    public ArrayList<ISymbol> parseParameterDeclarationList(IParsedElement element, boolean bStatic, List<IType> inferredArgumentTypes) {
        return this.parseParameterDeclarationList(element, bStatic, inferredArgumentTypes, false, false, false, false);
    }

    public ArrayList<ISymbol> parseParameterDeclarationList(IParsedElement element, boolean bStatic, List<IType> inferredArgumentTypes, boolean bProperty, boolean bGetter, boolean bEmpty, boolean bVarDynamicArg) {
        ArrayList<ISymbol> params = new ArrayList<ISymbol>();
        Token T = new Token();
        int iParamPos = -1;
        boolean bOptionalParamsStarted = false;
        int iOffsetList = this.getTokenizer().getTokenStart();
        int iLineNumList = this.getTokenizer().getLineNumber();
        int iColumnList = this.getTokenizer().getTokenColumn();
        do {
            Object argType;
            IGosuClassInternal anonClass;
            boolean bSymbolConflict;
            ++iParamPos;
            int iOffsetParam = this.getTokenizer().getTokenStart();
            int iLineNumParam = this.getTokenizer().getLineNumber();
            int iColumnParam = this.getTokenizer().getTokenColumn();
            List<IGosuAnnotation> annotations = this.parseLocalAnnotations(Collections.emptyList());
            boolean bFinal = this.match(T, Keyword.KW_final);
            int iOffsetArgIdentifier = this.getTokenizer().getTokenStart();
            int iColumnArgIdentifier = this.getTokenizer().getTokenColumn();
            int iLineArgIdentifier = this.getTokenizer().getLineNumber();
            Token tokenBeforeParam = this.getTokenizer().getCurrentToken();
            boolean bMatchColonWithoutName = false;
            if (bEmpty || !this.verify((ParsedElement)element, this.match(T, -5), Res.MSG_EXPECTING_ARGS, "")) {
                bMatchColonWithoutName = this.match(null, ":", -6, true);
                if (!bMatchColonWithoutName) break;
                T._strValue = "";
            }
            ModifierListClause e = new ModifierListClause();
            this.pushExpression(e);
            boolean bZeroLength = tokenBeforeParam.getTokenStart() <= iOffsetParam;
            this.setLocation(iOffsetParam, iLineNumParam, iColumnParam, bZeroLength, true);
            this.popExpression();
            String strArgIdentifier = T._strValue;
            ParameterDeclaration parameterIdentifier = new ParameterDeclaration(strArgIdentifier);
            this.addNameInDeclaration(strArgIdentifier, iOffsetArgIdentifier, iLineArgIdentifier, iColumnArgIdentifier, strArgIdentifier.length() > 0 || bMatchColonWithoutName);
            ISymbol existingSymbol = this._symTable.getSymbol((CharSequence)strArgIdentifier);
            if (existingSymbol == null) {
                for (ISymbol symbol : params) {
                    if (!symbol.getName().equals(strArgIdentifier)) continue;
                    existingSymbol = symbol;
                }
            }
            boolean bl = bSymbolConflict = existingSymbol != null;
            if (bStatic && existingSymbol instanceof DynamicSymbol) {
                bSymbolConflict = existingSymbol.isStatic();
            }
            if (!bSymbolConflict && (anonClass = this.getParsingAnonymousClass()) != null && !this.isParsingAnnotation()) {
                bSymbolConflict = this.captureSymbol(anonClass, strArgIdentifier, null) != null;
            }
            this.verify((ParsedElement)parameterIdentifier, !bSymbolConflict, Res.MSG_VARIABLE_ALREADY_DEFINED, strArgIdentifier);
            this.verify((ParsedElement)parameterIdentifier, !bProperty || bGetter || iParamPos == 0, Res.MSG_PROPERTY_SET_MUST_HAVE_ONE_PARAMETER, new String[0]);
            Expression defExpr = null;
            boolean bColonFound = this.match(null, ":", -6);
            boolean bEqualsFound = this.match(null, "=", -6);
            boolean bParenFound = this.match(null, null, 40, true);
            if (!(inferredArgumentTypes == null && !bVarDynamicArg || bColonFound || bEqualsFound || bParenFound)) {
                argType = inferredArgumentTypes != null && inferredArgumentTypes.size() > iParamPos ? inferredArgumentTypes.get(iParamPos) : (bVarDynamicArg ? IDynamicType.instance() : ErrorType.getInstance());
            } else {
                if (bParenFound) {
                    this.parseBlockLiteral();
                } else {
                    this.verify((ParsedElement)parameterIdentifier, bColonFound || bEqualsFound, Res.MSG_EXPECTING_TYPE_FUNCTION_DEF, new String[0]);
                    if (bEqualsFound) {
                        this.parseExpression(new ContextType(null, false, true));
                    } else {
                        this.parseTypeLiteral();
                    }
                }
                Expression expr = this.popExpression();
                if (bEqualsFound) {
                    defExpr = expr;
                    argType = defExpr.hasParseExceptions() ? JavaTypes.pVOID() : expr.getType();
                    this.verify((ParsedElement)expr, !(expr instanceof NullExpression), Res.MSG_VARIABLE_MUST_HAVE_NON_NULL_TYPE, new String[0]);
                } else {
                    argType = ((TypeLiteral)expr).getType().getType();
                }
                this.verify((ParsedElement)expr, bEqualsFound || argType != JavaTypes.pVOID(), Res.MSG_VOID_NOT_ALLOWED, new String[0]);
                if (bColonFound && this.match(null, "=", -6)) {
                    int iOffsetDef = this.getTokenizer().getTokenStart();
                    int iLineNumDef = this.getTokenizer().getLineNumber();
                    int iColumnDef = this.getTokenizer().getTokenColumn();
                    this.parseExpression(new ContextType((IType)argType, false, true));
                    defExpr = this.popExpression();
                    defExpr = this.possiblyWrapWithImplicitCoercion(defExpr, (IType)argType);
                    this.pushExpression(defExpr);
                    this.setLocation(iOffsetDef, iLineNumDef, iColumnDef);
                    this.popExpression();
                }
                this.verify((ParsedElement)defExpr, defExpr == null || !bProperty, Res.MSG_DEFAULT_VALUE_NOT_ALLOWED, new String[0]);
            }
            if (strArgIdentifier == null) continue;
            TypedSymbol symbol = new TypedSymbol(strArgIdentifier, (IType)argType, this._symTable, null, SymbolType.PARAMETER_DECLARATION);
            if (defExpr != null) {
                this.verifyComparable((IType)argType, defExpr);
                this.verify((ParsedElement)defExpr, defExpr.isCompileTimeConstant(), Res.MSG_COMPILE_TIME_CONSTANT_REQUIRED, new String[0]);
                this.verify((ParsedElement)element, argType != JavaTypes.pVOID() || !defExpr.hasParseExceptions(), Res.MSG_PARAM_TYPE_CANT_BE_INFERRED_FROM_LATE_BOUND_EXPRESSION, new String[0]);
                symbol.setDefaultValueExpression(defExpr);
                bOptionalParamsStarted = true;
            } else {
                this.verify((ParsedElement)parameterIdentifier, !bOptionalParamsStarted, Res.MSG_EXPECTING_DEFAULT_VALUE, new String[0]);
            }
            symbol.setFinal(bFinal);
            symbol.getModifierInfo().setAnnotations(annotations);
            params.add((ISymbol)symbol);
            parameterIdentifier.setType((IType)argType);
            this.pushExpression(parameterIdentifier);
            this.setLocation(iOffsetParam, iLineNumParam, iColumnParam, true);
            this.popExpression();
            if (!(this.getGosuClass() instanceof IGosuClassInternal) || !((IGosuClassInternal)this.getGosuClass()).isCompilingDefinitions()) continue;
            this.verifyModifiers(parameterIdentifier, symbol.getModifierInfo(), UsageTarget.ParameterTarget);
        } while (this.match(null, 44));
        ParameterListClause e = new ParameterListClause();
        this.pushExpression(e);
        boolean bZeroLength = this.getTokenizer().getTokenStart() <= iOffsetList;
        this.setLocation(bZeroLength ? this.getTokenizer().getPriorToken().getTokenEnd() : iOffsetList, iLineNumList, iColumnList, bZeroLength, true);
        this.popExpression();
        params.trimToSize();
        return params;
    }

    private List<IGosuAnnotation> parseLocalAnnotations(List<IGosuAnnotation> annotations) {
        while (this.match(null, null, 64, true)) {
            if (this.getOwner() == null) {
                this.match(null, 64);
                throw new IllegalStateException("Found null owning parser");
            }
            if (annotations.isEmpty()) {
                annotations = new ArrayList<IGosuAnnotation>(2);
            }
            this.parseAnnotation(annotations);
        }
        return annotations;
    }

    List<ITypeVariableDefinitionExpression> parseTypeVariableDefs(ParsedElement parsedElem, boolean bFunction, List<TypeVariableDefinitionImpl> typeVarDefListFromDecl) {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        if (!this.match(null, "<", -6)) {
            return Collections.emptyList();
        }
        List<ITypeVariableDefinitionExpression> typeVarDefList = this.parseTypeVariableDefList(parsedElem, bFunction, typeVarDefListFromDecl);
        if (this.verify(parsedElem, this.match(null, ">", -6), Res.MSG_EXPECTING_CLOSING_ANGLE_BRACKET_FOR_TYPE_VAR_LIST, new String[0])) {
            this.verify(parsedElem, this.getGosuClass() == null || !((IGosuClass)this.getGosuClass()).isAnnotation() || !JavaTypes.ANNOTATION().isAssignableFrom((IType)this.getGosuClass()), Res.MSG_GENERIC_ANNOTATIONS_NOT_SUPPORTED, new String[0]);
        }
        TypeVariableListClause e = new TypeVariableListClause(typeVarDefList);
        this.pushExpression(e);
        this.setLocation(iOffset, iLineNum, iColumn, true);
        this.popExpression();
        return typeVarDefList;
    }

    List<ITypeVariableDefinitionExpression> parseTypeVariableDefList(ParsedElement parsedElem, boolean bForFunction, List<TypeVariableDefinitionImpl> typeVarDefListFromDecl) {
        ArrayList<ITypeVariableDefinitionExpression> typeVarDefList = new ArrayList<ITypeVariableDefinitionExpression>();
        int i = 0;
        do {
            TypeVariableDefinition typeVarDef = new TypeVariableDefinition(this.getEnclosingType(), bForFunction);
            if (typeVarDefListFromDecl != null && !typeVarDefListFromDecl.isEmpty()) {
                typeVarDef.setTypeVarDef(typeVarDefListFromDecl.get(i++));
            }
            this.parseTypeVariableDefinition(parsedElem, typeVarDef);
            typeVarDef = (TypeVariableDefinition)this.popExpression();
            for (ITypeVariableDefinition csr : this._typeVarsByName.values()) {
                if (!this.verify((ParsedElement)typeVarDef, !csr.getName().equals(typeVarDef.getName()) || ((TypeVariableDefinition)csr).getLocation().getExtent() == typeVarDef.getLocation().getExtent(), Res.MSG_VARIABLE_ALREADY_DEFINED, typeVarDef.getName())) break;
            }
            typeVarDefList.add(typeVarDef);
        } while (this.match(null, 44));
        return typeVarDefList;
    }

    void parseTypeVariableDefinition(ParsedElement parsedElem, TypeVariableDefinition typeVarDef) {
        int iOffset = this.getTokenizer().getTokenStart();
        int iLineNum = this.getTokenizer().getLineNumber();
        int iColumn = this.getTokenizer().getTokenColumn();
        if (this._parseTypeVariableDefinition(parsedElem, typeVarDef)) {
            this.setLocation(iOffset, iLineNum, iColumn);
        }
    }

    boolean _parseTypeVariableDefinition(ParsedElement parsedElem, TypeVariableDefinition typeVarDef) {
        boolean bExtends;
        IType boundingType;
        int iColumn;
        int iLineNum;
        int iOffset;
        Token T = new Token();
        this.parseVariance(parsedElem, typeVarDef);
        if (this.verify(parsedElem, this.match(T, -5), Res.MSG_EXPECTING_IDENTIFIER_EXISTS, new String[0])) {
            typeVarDef.setName(T._strValue);
            Map<String, ITypeVariableDefinition> typeVarMap = this.getTypeVariables();
            if (!typeVarMap.containsKey(typeVarDef.getName())) {
                this.getTypeVariables().put(typeVarDef.getName(), typeVarDef);
            }
            iOffset = this.getTokenizer().getTokenStart();
            iLineNum = this.getTokenizer().getLineNumber();
            iColumn = this.getTokenizer().getTokenColumn();
            boundingType = null;
            bExtends = this.match(null, Keyword.KW_extends);
            if (bExtends) {
                typeVarDef.setBoundingType(PENDING_BOUNDING_TYPE);
                this.parseTypeLiteral();
                this.boxTypeLiteralsType((TypeLiteral)this.peekExpression());
                TypeLiteral typeLiteral = (TypeLiteral)this.popExpression();
                boundingType = typeLiteral.getType().getType();
                if (this.verify((ParsedElement)typeLiteral, boundingType != typeVarDef.getType(), Res.MSG_CYCLIC_INHERITANCE, boundingType.getRelativeName())) {
                    typeVarDef.setBoundingType(boundingType);
                }
            }
        } else {
            typeVarDef.setName("");
            this.verify((ParsedElement)typeVarDef, false, Res.MSG_ERRANT_TYPE_VAR, new String[0]);
            Map<String, ITypeVariableDefinition> typeVarMap = this.getTypeVariables();
            if (!typeVarMap.containsKey(typeVarDef.getName())) {
                this.getTypeVariables().put(typeVarDef.getName(), typeVarDef);
            }
            this.pushExpression(typeVarDef);
            Token priorT = this.getTokenizer().getPriorToken();
            this.setLocation(priorT.getTokenEnd(), priorT.getLine(), priorT.getTokenColumn());
            return false;
        }
        TypeVariableExtendsListClause e = new TypeVariableExtendsListClause(boundingType);
        this.pushExpression(e);
        this.setLocation(iOffset - (bExtends ? 0 : 1), iLineNum, iColumn, !bExtends, true);
        this.popExpression();
        this.pushExpression(typeVarDef);
        return true;
    }

    private void parseVariance(ParsedElement parsedElem, TypeVariableDefinition typeVarDef) {
        int iOffsetList = this.getTokenizer().getTokenStart();
        int iLineNumList = this.getTokenizer().getLineNumber();
        int iColumnList = this.getTokenizer().getTokenColumn();
        boolean bCovariant = false;
        boolean bContravariant = false;
        while (true) {
            Token token;
            if (Keyword.KW_in == (token = this.getTokenizer().getCurrentToken()).getKeyword()) {
                this.getTokenizer().nextToken();
                if (!this.verify(parsedElem, !typeVarDef.getType().isFunctionStatement(), Res.MSG_UNEXPECTED_TOKEN, Keyword.KW_in) || !this.verify(parsedElem, !bContravariant, Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_in, Keyword.KW_in)) continue;
                bContravariant = true;
                if (typeVarDef.getVariance() == Variance.COVARIANT) {
                    typeVarDef.setVariance(Variance.INVARIANT);
                    continue;
                }
                typeVarDef.setVariance(Variance.CONTRAVARIANT);
                continue;
            }
            if (Keyword.KW_out != token.getKeyword()) break;
            this.getTokenizer().nextToken();
            if (!this.verify(parsedElem, !typeVarDef.getType().isFunctionStatement(), Res.MSG_UNEXPECTED_TOKEN, Keyword.KW_out) || !this.verify(parsedElem, !bCovariant, Res.MSG_ILLEGAL_USE_OF_MODIFIER, Keyword.KW_out, Keyword.KW_out)) continue;
            bCovariant = true;
            if (typeVarDef.getVariance() == Variance.CONTRAVARIANT) {
                typeVarDef.setVariance(Variance.INVARIANT);
                continue;
            }
            typeVarDef.setVariance(Variance.COVARIANT);
        }
        this.pushModifierList(iOffsetList, iLineNumList, iColumnList);
    }

    private IType getEnclosingType() {
        if (this.isParsingFunction()) {
            return this.peekParsingFunction();
        }
        return this.getScriptPart() == null ? null : this.getScriptPart().getContainingType();
    }

    @Override
    protected void pushExpression(Expression e) {
        assert (e != null);
        this.maybeVerifyDoubleLiterals(e);
        this._stack.push((Object)e);
    }

    private void maybeVerifyDoubleLiterals(Expression e) {
        if (e instanceof AdditiveExpression || e instanceof MultiplicativeExpression) {
            IArithmeticExpression ae = (IArithmeticExpression)e;
            this.maybeVerifyDoubleLiteral(ae.getLHS(), ae.getRHS());
            this.maybeVerifyDoubleLiteral(ae.getRHS(), ae.getLHS());
        }
    }

    private void maybeVerifyDoubleLiteral(IExpression oneSide, IExpression otherSide) {
        if ((JavaTypes.BIG_DECIMAL().equals(oneSide.getType()) || JavaTypes.BIG_INTEGER().equals(oneSide.getType())) && JavaTypes.pDOUBLE().equals(otherSide.getType())) {
            if (otherSide instanceof UnaryExpression) {
                otherSide = ((UnaryExpression)otherSide).getExpression();
            }
            if (otherSide instanceof NumericLiteral) {
                NumericLiteral nl = (NumericLiteral)otherSide;
                boolean repsAreIdentical = new BigDecimal(nl.getStrValue()).equals(CommonServices.getCoercionManager().makeBigDecimalFrom((Object)nl.getValue()));
                this.verify((ParsedElement)otherSide, repsAreIdentical, Res.MSG_LOSS_OF_PRECISION_IN_NUMERIC_LITERAL, nl.getStrValue() + "bd");
            }
        }
    }

    @Override
    public Expression popExpression() {
        return (Expression)this._stack.pop();
    }

    public void setTokenizer(ISourceCodeTokenizer tokenizer) {
        this._tokenizer = (SourceCodeTokenizer)tokenizer;
    }

    @Override
    protected Expression peekExpression() {
        ParsedElement elem = this.peekParsedElement();
        return elem instanceof Expression ? (Expression)elem : null;
    }

    protected ParsedElement peekParsedElement() {
        if (this._stack.isEmpty()) {
            return null;
        }
        return (ParsedElement)this._stack.peek();
    }

    @Override
    protected void pushStatement(Statement stmt) {
        this._stack.push((Object)stmt);
    }

    @Override
    protected Statement popStatement() {
        ParsedElement stmt = (ParsedElement)this._stack.pop();
        return (Statement)stmt;
    }

    @Override
    protected Statement peekStatement() {
        ParsedElement elem = this.peekParsedElement();
        return elem instanceof Statement ? (Statement)elem : null;
    }

    protected void pushDynamicFunctionSymbol(DynamicFunctionSymbol stmt) {
        this._stackDFS.push((Object)stmt);
    }

    protected DynamicFunctionSymbol popDynamicFunctionSymbol() {
        return (DynamicFunctionSymbol)this._stackDFS.pop();
    }

    protected DynamicFunctionSymbol peekDynamicFunctionSymbol() {
        if (this._stackDFS.isEmpty()) {
            return null;
        }
        return (DynamicFunctionSymbol)this._stackDFS.peek();
    }

    protected void clearDfsStack() {
        this._stackDFS.clear();
    }

    public void putDfsDeclsInTable(ISymbolTable table) {
        if (table == null) {
            return;
        }
        for (ISymbol symbol : table.getSymbols().values()) {
            if (!(symbol instanceof IDynamicFunctionSymbol)) continue;
            this.putDfsDeclInSetByName((IDynamicFunctionSymbol)symbol);
        }
    }

    public void putDfsDeclInSetByName(IDynamicFunctionSymbol dfs) {
        String displayName = dfs.getDisplayName();
        List<IFunctionSymbol> dfsDecls = this._dfsDeclByName.get(displayName);
        if (dfsDecls == null) {
            dfsDecls = new ArrayList<IFunctionSymbol>(2);
            try {
                this._dfsDeclByName.put(displayName, dfsDecls);
                dfsDecls.add((IFunctionSymbol)dfs);
            }
            catch (Exception e) {
                throw new RuntimeException("Map type: " + this._dfsDeclByName.getClass().getName(), e);
            }
        } else {
            int iIndex = dfsDecls.indexOf(dfs);
            if (iIndex >= 0) {
                dfsDecls.set(iIndex, (IFunctionSymbol)dfs);
            } else {
                dfsDecls.add((IFunctionSymbol)dfs);
            }
        }
    }

    public int nextIndexOfErrantDuplicateDynamicSymbol(IDynamicSymbol ds, Collection<? extends ISymbol> symbols, boolean bCheckContains) {
        if (symbols == null) {
            return -1;
        }
        int iMax = -1;
        if (!bCheckContains || this.symbolIn(ds, symbols)) {
            for (ISymbol iSymbol : symbols) {
                int iIndex;
                boolean bInjected = iSymbol instanceof IInjectedSymbol;
                if (!(iSymbol instanceof IDynamicSymbol) && !bInjected) continue;
                String strName = iSymbol.getName();
                if (iSymbol.getGosuClass() != ds.getGosuClass() && !bInjected) continue;
                if (iMax < 0 && strName.equals(ds.getName())) {
                    iMax = 0;
                    continue;
                }
                if (!strName.toLowerCase().contains("_duplicate_" + ds.getName().toLowerCase()) || (iIndex = Integer.parseInt(strName.substring(0, strName.indexOf(95)))) <= iMax) continue;
                iMax = iIndex;
            }
        }
        return iMax < 0 ? iMax : iMax + 1;
    }

    private boolean symbolIn(IDynamicSymbol ds, Collection<? extends ISymbol> symbols) {
        for (ISymbol iSymbol : symbols) {
            if (!iSymbol.getName().equals(ds.getName())) continue;
            return true;
        }
        return false;
    }

    public void setDfsDeclInSetByName(Map<String, List<IFunctionSymbol>> dfsDecl) {
        this._dfsDeclByName = dfsDecl;
    }

    protected void newDfsDeclInSetByName() {
        this._dfsDeclByName = new HashMap<String, List<IFunctionSymbol>>();
    }

    public Map<String, List<IFunctionSymbol>> getDfsDecls() {
        return this._dfsDeclByName;
    }

    protected List<IFunctionType> getFunctionTypesForName(String strFunctionName) {
        List<IFunctionSymbol> list = this.getDfsDeclsForFunction(strFunctionName);
        ArrayList<IFunctionType> listOfTypes = new ArrayList<IFunctionType>(list.size());
        for (IFunctionSymbol dfs : list) {
            listOfTypes.add((IFunctionType)((FunctionType)dfs.getType()));
        }
        return listOfTypes;
    }

    protected TypeLiteral resolveTypeLiteral(String[] T) {
        return this.resolveTypeLiteral(T, true, false);
    }

    protected TypeLiteral resolveTypeLiteral(String[] T, boolean bRelative, boolean bInterface) {
        String strTypeName = T[0] == null ? "" : T[0];
        return this.resolveTypeLiteral(strTypeName, bRelative, bInterface);
    }

    protected List<IFunctionSymbol> getDfsDeclsForFunction(String strFunctionName) {
        List<IFunctionSymbol> setOfDfsDecls = this._dfsDeclByName.get(strFunctionName);
        return setOfDfsDecls == null ? Collections.emptyList() : setOfDfsDecls;
    }

    public TypeLiteral resolveTypeLiteral(String strTypeName) {
        return this.resolveTypeLiteral(strTypeName, true, false);
    }

    public TypeLiteral resolveTypeLiteral(String strTypeName, boolean bRelative, boolean bInterface) {
        Object intrType;
        int iArrayDims = 0;
        if (strTypeName.length() > 0 && strTypeName.charAt(strTypeName.length() - 1) == ']') {
            int iFirstBracketIndex = strTypeName.indexOf(91);
            strTypeName = strTypeName.substring(0, iFirstBracketIndex);
            iArrayDims = (strTypeName.length() - iFirstBracketIndex) / 2;
        }
        boolean bClassTypeVar = false;
        ITypeVariableDefinition typeVarDef = this.getTypeVarDef(strTypeName);
        if (typeVarDef != null) {
            bClassTypeVar = !typeVarDef.getType().isFunctionStatement();
            intrType = typeVarDef.getType();
            if (intrType == null) {
                intrType = this.resolveTypeByRelativeName(strTypeName);
            }
        } else if (strTypeName.indexOf(46) >= 0) {
            intrType = this.resolveTypeName(strTypeName, false);
            if (intrType == null) {
                intrType = this.resolveTypeByRelativeName(strTypeName);
            }
        } else {
            intrType = this.resolveTypeByRelativeName(strTypeName);
            if (intrType == null) {
                intrType = this.resolveTypeName(strTypeName, bRelative);
            }
        }
        if (intrType == null) {
            intrType = ErrorType.getInstance(strTypeName);
        }
        IType finalType = intrType;
        for (int i = 0; i < iArrayDims; ++i) {
            finalType = finalType.getArrayType();
        }
        if (TypeSystem.isDeleted((IType)finalType)) {
            finalType = TypeSystem.getErrorType();
        }
        TypeLiteral typeLiteral = bInterface ? new InterfaceTypeLiteral((IType)MetaType.getLiteral(finalType), this._ignoreTypeDeprecation > 0) : new TypeLiteral((IType)MetaType.getLiteral(finalType), this._ignoreTypeDeprecation > 0);
        this.verify((ParsedElement)typeLiteral, !bClassTypeVar || !this.isParsingStaticFeature() || this.isParsingConstructor(), Res.MSG_CANNOT_REFERENCE_CLASS_TYPE_VAR_IN_STATIC_CONTEXT, new String[0]);
        if (this.verify((ParsedElement)typeLiteral, !(intrType instanceof ErrorType) || "ErrorType".equals(strTypeName), Res.MSG_INVALID_TYPE, strTypeName)) {
            this.verifyCase(typeLiteral, strTypeName, intrType.getName(), Res.MSG_TYPE_CASE_MISMATCH, true);
        }
        return typeLiteral;
    }

    private IType resolveTypeName(String strTypeName, boolean bRelative) {
        return this.resolveTypeName_Cache(strTypeName, bRelative);
    }

    private IType resolveTypeName_NoCache(String strTypeName, boolean bRelative) {
        IType type = bRelative ? TypeLoaderAccess.instance().getTypeByRelativeNameIfValid_NoGenerics(strTypeName, this.getTypeUsesMap()) : TypeLoaderAccess.instance().getByFullNameIfValid(strTypeName);
        return type;
    }

    private IType resolveTypeName_Cache(String strTypeName, boolean bRelative) {
        Object type;
        Map<String, IType> cache = this._typeCache.get(null);
        if (cache == null) {
            cache = new HashMap<String, IType>();
            this._typeCache.put(this.getScriptPart(), cache);
            type = null;
        } else {
            type = cache.get(strTypeName);
        }
        if (type == null) {
            type = this.resolveTypeName_NoCache(strTypeName, bRelative);
            if (type == null) {
                type = notfound;
            }
            cache.put(strTypeName, (IType)type);
        }
        return type == null || type == notfound ? null : type;
    }

    private ITypeVariableDefinition getTypeVarDef(String strTypeName) {
        ITypeVariableDefinition typeVarDef = this.getTypeVariables().get(strTypeName);
        if (typeVarDef != null && this.getGosuClass() != null && this.getGosuClass().isStatic() && TypeLord.encloses(typeVarDef.getEnclosingType(), (IType)this.getGosuClass())) {
            typeVarDef = null;
        }
        if (typeVarDef == null) {
            typeVarDef = this.getEnclosingTypeVars().get(strTypeName);
        }
        return typeVarDef;
    }

    private Map<String, TypeVariableDefinition> getEnclosingTypeVars() {
        ICompilableTypeInternal gsClass = this.getGosuClass();
        if (gsClass == null) {
            return Collections.emptyMap();
        }
        HashMap<String, TypeVariableDefinition> mapTypeVarDefByName = new HashMap<String, TypeVariableDefinition>(2);
        while (!gsClass.isStatic() && gsClass.getEnclosingType() != null) {
            ICompilableType enclosingType = gsClass.getEnclosingType();
            for (IGenericTypeVariable gtv : enclosingType.getGenericTypeVariables()) {
                Map<String, ITypeVariableDefinition> typeVarMap = this.getTypeVariables();
                if (typeVarMap.containsKey(gtv.getTypeVariableDefinition().getName())) continue;
                this.getTypeVariables().put(gtv.getName(), gtv.getTypeVariableDefinition());
            }
            gsClass = enclosingType;
        }
        return mapTypeVarDefByName;
    }

    private IType resolveTypeByRelativeName(String strTypeName) {
        ICompilableTypeInternal gsClass = this.getGosuClass();
        if (gsClass == null) {
            return null;
        }
        return gsClass.resolveRelativeInnerClass(strTypeName, false);
    }

    public Map<String, ITypeVariableDefinition> getTypeVariables() {
        return this._typeVarsByName;
    }

    public IGosuClassInternal parseClass(String strQualifiedClassName, ISourceFileHandle sourceFile, boolean bThrowOnWarnings, boolean bFullyCompile) throws ParseResultsException {
        GosuClassTypeLoader classLoader;
        if (!ExecutionMode.isIDE()) {
            classLoader = GosuClassTypeLoader.getDefaultClassLoader((IModule)TypeSystem.getGlobalModule());
        } else {
            IFile file = sourceFile.getFile();
            IModule module = TypeSystem.getExecutionEnvironment().getModule((IResource)file);
            classLoader = module == null ? GosuClassTypeLoader.getDefaultClassLoader((IModule)TypeSystem.getGlobalModule()) : (GosuClassTypeLoader)module.getModuleTypeLoader().getTypeLoader(GosuClassTypeLoader.class);
        }
        IGosuClassInternal gsClass = (IGosuClassInternal)classLoader.makeNewClass(sourceFile, this._symTable);
        gsClass.setEditorParser(this);
        gsClass.setCreateEditorParser(this.isEditorParser());
        try {
            if (bFullyCompile) {
                gsClass.compileDefinitionsIfNeeded(true);
            } else {
                gsClass.compileDeclarationsIfNeeded();
            }
        }
        catch (ErrantGosuClassException errantGosuClassException) {
            // empty catch block
        }
        if (gsClass.getParseResultsException() != null && (gsClass.getParseResultsException().hasParseExceptions() || bThrowOnWarnings)) {
            throw gsClass.getParseResultsException();
        }
        return gsClass;
    }

    public IFunctionType getFunctionType(IType classBean, String functionName, Expression[] eArgs, List<IFunctionType> listAllMatchingMethods, GosuParser parser, boolean bMatchParamTypes) throws ParseException {
        int i;
        if (classBean == null) {
            throw new ParseException((IParserState)(parser == null ? null : parser.makeFullParserState()), Res.MSG_BEAN_CLASS_IS_NULL, new Object[0]);
        }
        if (functionName == null) {
            throw new ParseException((IParserState)(parser == null ? null : parser.makeFullParserState()), Res.MSG_BEAN_MEMBER_PATH_IS_NULL, new Object[0]);
        }
        ITypeInfo beanInfo = classBean.getTypeInfo();
        if (beanInfo == null) {
            throw new ParseException((IParserState)(parser == null ? null : parser.makeFullParserState()), Res.MSG_NO_EXPLICIT_TYPE_INFO_FOUND, new Object[]{classBean.getName()});
        }
        if (ErrorType.shouldHandleAsErrorType(classBean)) {
            return ErrorType.getInstance().getErrorTypeFunctionType(eArgs, functionName, listAllMatchingMethods);
        }
        boolean bFoundMethodWithName = false;
        MethodList methods = BeanAccess.getMethods(beanInfo, (IType)(this.getGosuClass() == null ? JavaTypes.OBJECT() : this.getGosuClass()));
        if (methods != null) {
            DynamicArray theMethods = methods.getMethods(functionName);
            for (i = 0; i < theMethods.size; ++i) {
                IMethodInfo method = (IMethodInfo)theMethods.data[i];
                if (BeanAccess.isDescriptorHidden((IAttributedFeatureInfo)method)) continue;
                bFoundMethodWithName = true;
                if (!bMatchParamTypes) {
                    return new FunctionType(method);
                }
                IParameterInfo[] paramTypes = method.getParameters();
                if (eArgs != null && paramTypes.length != eArgs.length) continue;
                if (listAllMatchingMethods == null) {
                    return new FunctionType(method);
                }
                listAllMatchingMethods.add((IFunctionType)new FunctionType(method));
            }
        }
        if (listAllMatchingMethods != null && listAllMatchingMethods.size() > 0) {
            return listAllMatchingMethods.get(0);
        }
        if (bFoundMethodWithName) {
            throw new ParseException((IParserState)(parser == null ? null : parser.makeFullParserState()), Res.MSG_WRONG_NUMBER_OF_ARGS_FOR_METHOD_ON_CLASS, new Object[]{functionName, TypeSystem.getUnqualifiedClassName((IType)classBean)});
        }
        this.checkForStaticMethod(classBean, eArgs, functionName, parser);
        if (classBean.isDynamic()) {
            IMethodInfo mi;
            IType[] params = null;
            if (eArgs != null) {
                params = new IType[eArgs.length];
                for (i = 0; i < eArgs.length; ++i) {
                    params[i] = eArgs[i].getType();
                }
            }
            if ((mi = classBean.getTypeInfo().getMethod((CharSequence)functionName, params)) != null) {
                FunctionType funcType = new FunctionType(mi);
                if (listAllMatchingMethods != null) {
                    listAllMatchingMethods.add((IFunctionType)funcType);
                }
                return funcType;
            }
        }
        throw new ParseException((IParserState)(parser == null ? null : parser.makeFullParserState()), Res.MSG_NO_METHOD_DESCRIPTOR_FOUND_FOR_METHOD, new Object[]{functionName, TypeSystem.getUnqualifiedClassName((IType)classBean)});
    }

    private void checkForStaticMethod(IType classBean, Expression[] eArgs, String strMethod, GosuParser parserState) throws ParseException {
        if (classBean instanceof MetaType) {
            IType referredType = ((MetaType)classBean).getType();
            IType[] paramTypes = new IType[eArgs == null ? 0 : eArgs.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = eArgs[i].getType();
            }
            IMethodInfo mi = referredType.getTypeInfo().getCallableMethod((CharSequence)strMethod, paramTypes);
            if (mi != null && !mi.isStatic()) {
                throw new ParseException((IParserState)(parserState == null ? null : parserState.makeFullParserState()), Res.MSG_METHOD_IS_NOT_STATIC, new Object[]{strMethod, TypeSystem.getUnqualifiedClassName((IType)classBean)});
            }
        } else {
            MetaType referredType = MetaType.get(classBean);
            IType[] paramTypes = new IType[eArgs == null ? 0 : eArgs.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = eArgs[i].getType();
            }
            IMethodInfo mi = referredType.getTypeInfo().getCallableMethod((CharSequence)strMethod, paramTypes);
            if (mi != null && !mi.isStatic()) {
                throw new ParseException((IParserState)(parserState == null ? null : parserState.makeFullParserState()), Res.MSG_METHOD_IS_STATIC, new Object[]{strMethod, TypeSystem.getUnqualifiedClassName((IType)classBean)});
            }
        }
    }

    private IInvocableType inferFunctionType(IInvocableType funcType, List<? extends IExpression> eArgs, boolean bUseCtx, TypeVarToTypeMap inferenceMap) {
        if (funcType instanceof IFunctionType && funcType.isGenericType()) {
            return this.inferFunction(funcType, eArgs, bUseCtx);
        }
        if (funcType instanceof ConstructorType) {
            return this.inferConstructor(funcType, inferenceMap);
        }
        return funcType;
    }

    private IInvocableType inferConstructor(IInvocableType funcType, TypeVarToTypeMap inferenceMap) {
        IType actualDeclaringType;
        IType declaringType = ((ConstructorType)funcType).getDeclaringType();
        if (declaringType.isGenericType() && !declaringType.isParameterizedType() && (actualDeclaringType = TypeLord.makeParameteredType(declaringType, inferenceMap)) != null) {
            List genDeclaredConstructors = ((IRelativeTypeInfo)declaringType.getTypeInfo()).getDeclaredConstructors();
            for (int i = 0; i < genDeclaredConstructors.size(); ++i) {
                IConstructorInfo rawCtor = (IConstructorInfo)genDeclaredConstructors.get(i);
                if (!new ConstructorType(rawCtor).equals(funcType)) continue;
                List paramDeclaredConstructors = ((IRelativeTypeInfo)actualDeclaringType.getTypeInfo()).getDeclaredConstructors();
                for (IConstructorInfo csr : paramDeclaredConstructors) {
                    if (!csr.hasRawConstructor(rawCtor)) continue;
                    return new ConstructorType(csr);
                }
                break;
            }
        }
        return funcType;
    }

    private IInvocableType inferFunction(IInvocableType funcType, List<? extends IExpression> eArgs, boolean bUseCtx) {
        int i;
        IType[] argTypes = new IType[eArgs.size()];
        for (i = 0; i < eArgs.size(); ++i) {
            argTypes[i] = eArgs.get(i).getType();
        }
        for (i = 0; i < funcType.getParameterTypes().length; ++i) {
            IType paramType = funcType.getParameterTypes()[i];
            if (i >= argTypes.length) continue;
            IType argType = argTypes[i];
            IType boundArgType = TypeLord.boundTypes(paramType, this.getCurrentlyInferringFunctionTypeVars());
            ICoercer coercer = CommonServices.getCoercionManager().resolveCoercerStatically(boundArgType, argType);
            if (!(coercer instanceof IResolvingCoercer)) continue;
            argTypes[i] = ((IResolvingCoercer)coercer).resolveType(paramType, argType);
        }
        return ((IFunctionType)funcType).inferParameterizedTypeFromArgTypesAndContextType(argTypes, bUseCtx ? this.getContextType().getType() : null);
    }

    private String getPropertyNameFromMethodName(String strMethod) {
        if (strMethod == null || strMethod.length() == 0) {
            return null;
        }
        for (String strPrefix : METHOD_PREFIX_LIST) {
            String strProperty = this.getPropertyNameFromMethodName(strPrefix, strMethod);
            if (strProperty == null) continue;
            return strProperty;
        }
        return null;
    }

    private String getPropertyNameFromMethodNameIncludingSetter(String strMethod) {
        if (strMethod == null || strMethod.length() == 0) {
            return null;
        }
        for (String strPrefix : METHOD_PREFIX_LIST_WITH_SETTER) {
            String strProperty = this.getPropertyNameFromMethodName(strPrefix, strMethod);
            if (strProperty == null) continue;
            return strProperty;
        }
        return null;
    }

    private String getPropertyNameFromMethodName(String strPrefix, String strMethod) {
        int iPropertyOffset = strPrefix.length();
        if (strMethod.startsWith(strPrefix) && strMethod.length() > iPropertyOffset && Character.isUpperCase(strMethod.charAt(iPropertyOffset))) {
            return strMethod.substring(iPropertyOffset);
        }
        return null;
    }

    private void verifyPropertyWritable(IType classRoot, String strProperty, boolean bFromObjInitializer) throws ParseException {
        if (classRoot == null) {
            throw new IllegalArgumentException("Root class is null|");
        }
        if (strProperty == null) {
            throw new IllegalArgumentException("Bean member path is null!");
        }
        IPropertyInfo pi = BeanAccess.getPropertyInfo(classRoot, strProperty, null, null, null);
        if (pi != null && !BeanAccess.isDescriptorHidden((IAttributedFeatureInfo)pi)) {
            if (!(pi.isWritable((IType)this.getGosuClass()) || !bFromObjInitializer && this.isParsingConstructor() && pi instanceof IGosuVarPropertyInfo && pi.isFinal() && !pi.isStatic())) {
                throw new ParseException((IParserState)this.makeFullParserState(), Res.MSG_CLASS_PROPERTY_NOT_WRITABLE, new Object[]{strProperty, TypeSystem.getUnqualifiedClassName((IType)classRoot)});
            }
            return;
        }
        throw new IllegalArgumentException("No property descriptor found for property, " + strProperty + ", on class, " + TypeSystem.getUnqualifiedClassName((IType)classRoot));
    }

    public IConstructorType getConstructorType(IType classBean, Expression[] eArgs, List<IConstructorType> listAllMatchingMethods, ParserBase parserState) throws ParseException {
        if (classBean == null) {
            throw new ParseException((IParserState)(parserState == null ? null : parserState.makeFullParserState()), Res.MSG_BEAN_CLASS_IS_NULL, new Object[0]);
        }
        if (ErrorType.shouldHandleAsErrorType(classBean)) {
            return ErrorType.getInstance().getErrorTypeConstructorType(eArgs, listAllMatchingMethods);
        }
        if (classBean instanceof TypeVariableType) {
            IType[] paramTypes = new IType[eArgs == null ? 0 : eArgs.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypes[i] = eArgs[i].getType();
            }
            ConstructorType ctorType = new ConstructorType(new DynamicConstructorInfo(classBean.getTypeInfo(), paramTypes));
            if (listAllMatchingMethods != null) {
                listAllMatchingMethods.add(ctorType);
            }
            return ctorType;
        }
        ITypeInfo typeInfo = classBean.getTypeInfo();
        if (typeInfo != null) {
            List constructors;
            if (typeInfo instanceof IRelativeTypeInfo) {
                while (classBean instanceof ITypeVariableType) {
                    classBean = ((ITypeVariableType)classBean).getBoundingType();
                }
                constructors = ((IRelativeTypeInfo)typeInfo).getConstructors(classBean);
            } else {
                constructors = typeInfo.getConstructors();
            }
            for (IConstructorInfo constructor : constructors) {
                if (typeInfo instanceof JavaTypeInfo && constructor.isPrivate()) continue;
                IParameterInfo[] paramTypes = constructor.getParameters();
                if (eArgs != null && paramTypes.length != eArgs.length) continue;
                if (listAllMatchingMethods == null) {
                    return new ConstructorType(constructor);
                }
                listAllMatchingMethods.add(new ConstructorType(constructor));
            }
            if (listAllMatchingMethods != null && listAllMatchingMethods.size() > 0) {
                return listAllMatchingMethods.get(0);
            }
        }
        throw new NoCtorFoundException(parserState == null ? null : parserState.makeFullParserState(), new Object[]{TypeSystem.getUnqualifiedClassName((IType)classBean), eArgs == null ? 0 : eArgs.length});
    }

    private void verifyCase(ParsedElement element, String foundName, String actualName, ResourceKey errorKey, boolean isEndsWithMatchOK) {
        this.verifyCase(element, foundName, actualName, null, errorKey, isEndsWithMatchOK);
    }

    private void verifyCase(ParsedElement element, String foundName, String actualName, IParserState state, ResourceKey errorKey, boolean isEndsWithMatchOK) {
        if (this._bWarnOnCaseIssue) {
            if (isEndsWithMatchOK) {
                if (!actualName.endsWith(foundName) && actualName.toUpperCase().endsWith(foundName.toUpperCase())) {
                    CharSequence correctedName = actualName.subSequence(actualName.length() - foundName.length(), actualName.length());
                    if (state == null) {
                        this.warn(element, false, errorKey, foundName, correctedName);
                    } else {
                        this.warn(element, false, state, errorKey, foundName, correctedName);
                    }
                }
            } else if (!GosuObjectUtil.equals((Object)foundName, (Object)actualName) && actualName.toUpperCase().equals(foundName.toUpperCase())) {
                if (state == null) {
                    this.warn(element, false, errorKey, foundName, actualName);
                } else {
                    this.warn(element, false, state, errorKey, foundName, actualName);
                }
            }
        }
    }

    public void setWarnOnCaseIssue(boolean warnOnCaseIssue) {
        this._bWarnOnCaseIssue = warnOnCaseIssue;
    }

    public void setEditorParser(boolean bStudioEditorParser) {
        this._bStudioEditorParser = bStudioEditorParser;
    }

    public boolean isEditorParser() {
        if (this.getOwner() != this) {
            return this.getOwner().isEditorParser();
        }
        return this._bStudioEditorParser;
    }

    public IParserState getState() {
        return this.makeFullParserState();
    }

    public boolean isParsingAnnotation() {
        return this._parsingAnnotation;
    }

    public void setParsingAnnotation(boolean parsingAnnotation) {
        this._parsingAnnotation = parsingAnnotation;
    }

    public boolean isAllowingWildcards() {
        return this._allowWildcards;
    }

    public void setAllowWildcards(boolean allowWildcards) {
        this._allowWildcards = allowWildcards;
    }

    public boolean isIgnoreTypeDeprecation() {
        return this._ignoreTypeDeprecation > 0;
    }

    public void pushIgnoreTypeDeprecation() {
        ++this._ignoreTypeDeprecation;
    }

    public void popIgnoreTypeDeprecation() {
        if (this._ignoreTypeDeprecation == 0) {
            throw new IllegalStateException("Unbalanced calls to push/popIgnoreTypeDeprecation()");
        }
        --this._ignoreTypeDeprecation;
    }

    public void setLocationsFromProgramClassParser(List<ParseTree> savedLocations) {
        this._savedLocations = savedLocations;
    }

    boolean maybeAdvanceTokenizerToEndOfSavedLocation() {
        if (this._savedLocations == null) {
            return false;
        }
        for (ParseTree pt : this._savedLocations) {
            Token T = this.getTokenizer().getCurrentToken();
            if (T.getTokenStart() < pt.getOffset() || T.getTokenEnd() > pt.getExtent()) continue;
            try {
                this.getTokenizer().goToPosition(pt.getOffset() + pt.getLength());
                return true;
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    protected void pushTypeVariableTypesToInfer(IInvocableType functionType) {
        if (functionType != null) {
            IType declaringType;
            ArrayList<IType> typeVariableTypes = new ArrayList<IType>();
            if (functionType.isGenericType()) {
                IGenericTypeVariable[] typeVariables = functionType.getGenericTypeVariables();
                this.addTypeVarsToList(typeVariableTypes, typeVariables);
            } else if (functionType instanceof ConstructorType && (declaringType = ((ConstructorType)functionType).getDeclaringType()).isGenericType() && !declaringType.isParameterizedType()) {
                IGenericTypeVariable[] typeVariables = declaringType.getGenericTypeVariables();
                this.addTypeVarsToList(typeVariableTypes, typeVariables);
            }
            this.pushInferringFunctionTypeVars(typeVariableTypes);
        }
    }

    private void addTypeVarsToList(List<IType> typeVariableTypes, IGenericTypeVariable[] typeVariables) {
        for (IGenericTypeVariable typeVariable : typeVariables) {
            ITypeVariableDefinition typeVariableDefinition = typeVariable.getTypeVariableDefinition();
            if (typeVariableDefinition == null || typeVariableDefinition.getType() == null) continue;
            typeVariableTypes.add((IType)typeVariableDefinition.getType());
        }
    }

    public String toString() {
        return "Parsing: " + this.getScriptPart();
    }

    private static class FunctionDeclTransparentActivationContext
    extends TransparentActivationContext {
        public FunctionDeclTransparentActivationContext(IScriptPartId scriptPart) {
            super(scriptPart);
        }

        public String getLabel() {
            return "parseFunctionDecl";
        }
    }

    private static class GosuParserTransparentActivationContext
    extends TransparentActivationContext {
        public GosuParserTransparentActivationContext(IScriptPartId scriptPart) {
            super(scriptPart);
        }

        public String getLabel() {
            return this.getContext().toString();
        }
    }
}

