/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.DocCommentBlock;
import gw.internal.gosu.parser.StringCache;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IToken;
import gw.lang.parser.Keyword;
import gw.lang.parser.SourceCodeReader;
import gw.util.GosuEscapeUtil;

public class Token
extends IToken {
    int _iType;
    String _strValue;
    Keyword _keyword;
    int _iInvalidCharPos = -1;
    int _iDocPosition;
    int _iDocLength;
    int _iColumn;
    int _iLine;
    int _iLineOffset;
    boolean _bUnterminated;
    boolean _bAnalyzingSeparately;
    boolean _bAnalyzingDirective;
    DocCommentBlock _turd;
    IParseTree _after;

    Token init(int iType, int iInvalidCharPos, int iTokenStart, int iTokenEnd, int iTokenColumn, int iLine, int iLineOffset, boolean bUnterminatedString, String strValue, Keyword keyword, boolean bAnalyzingSeparately, boolean bAnalyzingDirective, SourceCodeReader document, DocCommentBlock turd) {
        this._iType = iType;
        this._iInvalidCharPos = iInvalidCharPos;
        this._iDocPosition = iTokenStart;
        this._iDocLength = iTokenEnd - this._iDocPosition;
        this._iColumn = iTokenColumn;
        this._bUnterminated = bUnterminatedString;
        this._bAnalyzingSeparately = bAnalyzingSeparately;
        this._bAnalyzingDirective = bAnalyzingDirective;
        this._iLine = iLine;
        this._iLineOffset = iLineOffset;
        this._keyword = keyword;
        this._turd = turd;
        this.assignContent(strValue, document);
        return this;
    }

    public IToken copy() {
        return this.copyInto(this.create());
    }

    public <E extends IToken> E copyInto(E t) {
        Token copy = (Token)t;
        copy._iType = this._iType;
        copy._strValue = this._strValue;
        copy._iInvalidCharPos = this._iInvalidCharPos;
        copy._iDocPosition = this._iDocPosition;
        copy._iDocLength = this._iDocLength;
        copy._iColumn = this._iColumn;
        copy._iLine = this._iLine;
        copy._iLineOffset = this._iLineOffset;
        copy._bUnterminated = this._bUnterminated;
        copy._bAnalyzingSeparately = this._bAnalyzingSeparately;
        copy._bAnalyzingDirective = this._bAnalyzingDirective;
        copy._turd = this._turd;
        copy._after = this._after;
        return t;
    }

    Token create() {
        return new Token();
    }

    public void collapse() {
        this._iDocPosition += this._iDocLength;
    }

    protected void assignContent(String strValue, SourceCodeReader document) {
        this._strValue = strValue == null ? null : this.getMyTextFromSource(document);
    }

    public int getTokenStart() {
        return this._iDocPosition;
    }

    public int getTokenEnd() {
        return this._iDocPosition + this._iDocLength;
    }

    public int getTokenColumn() {
        return this._iColumn;
    }

    public int getLine() {
        return this._iLine;
    }

    public int getLineOffset() {
        return this._iLineOffset;
    }

    public String getStringValue() {
        return this._strValue;
    }

    public boolean isValueKeyword() {
        return this._keyword != null && this._keyword.isValue();
    }

    public final Keyword getKeyword() {
        return this._keyword;
    }

    public int getInvalidCharPos() {
        return this._iInvalidCharPos;
    }

    public int getType() {
        return this._iType;
    }

    public String getText() {
        return this._strValue != null ? (this._iType == 34 || this._iType == 39 ? GosuEscapeUtil.escapeForGosuStringLiteral((String)this._strValue, (int)0, (int)this._strValue.length()) : this._strValue) : (this._iType == -9 || this._iType == -4 ? this._strValue : String.valueOf((char)this._iType));
    }

    public void setAfter(IParseTree after) {
        this._after = after;
    }

    public IParseTree getAfter() {
        return this._after;
    }

    public String toString() {
        return "Token : [" + this.getText() + "]";
    }

    protected String getMyTextFromSource(SourceCodeReader document) {
        String strText = "";
        if (this._iDocLength > 0) {
            int iTokenEnd = Math.min(this._iDocPosition + this._iDocLength, document.getLength());
            strText = document.subsequence(this._iDocPosition, iTokenEnd).toString();
            strText = StringCache.get((String)strText);
        }
        return strText;
    }

    public boolean isAnalyzingSeparately() {
        return this._bAnalyzingSeparately;
    }

    public boolean isAnalyzingDirective() {
        return this._bAnalyzingDirective;
    }

    public DocCommentBlock getTurd() {
        return this._turd;
    }
}

